<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Libraries\infrastructure\ScheduledJobLoggerService;

/**
 * @property CI_Loader $load
 * @property Orderallocationservice $orderallocationservice
 * @property Common $common
 * @property Singletriporder $singletriporder
 * @property Uniqloediservices $uniqloediservices
 * @property CI_DB_mysqli_driver $db
 * @property UniqloOrder $uniqloModel
 * @property CI_Email $testMail
*/
class UniqloCarrierAllocation extends CI_Controller
{
    private const VENDOR_DELHIVERY    = '310';
    private const VENDOR_ECOM_EXPRESS = '311';
    private const VENDOR_XPRESS_BEES  = '312';
    private static $SUCCESSFULLY_ALLOCATED = 0;
    private static $FAILED_TO_ALLOCATE = 0;

    /** @var ScheduledJobLoggerService */
    private $scheduledJobService;

    public function __construct()
    {
        parent::__construct();

        $this->load->library('Orderallocationservice');
        $this->load->model('common');
        $this->load->model('Uniqlo/UniqloOrder', 'uniqloModel');
        $this->load->library('singletriporder');
        $this->load->library("uniqloediservices");
        $this->load->helper('log_helper');

        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    public function index()
    {
        $this->scheduledJobService->startJob();

        $orderResults = $ccorderResults = $existsOrders = [];

        $currentDateTime = new DateTime();

        $unAllocatedCarrierOrders = $this->uniqloModel->getUnAllocatedCarrierOrders();

        $this->scheduledJobService->log(
            'tb_orders',
            sprintf('Found %d possible records to allocated', count($unAllocatedCarrierOrders))
        );

        foreach ($unAllocatedCarrierOrders as $res) {
            $res['pickup_state'] = $this->getOriginState($res);
            $res['delivery_state'] = $this->getDestinationState($res);

            if ($res['ordtype_code'] === 'CC') {
                $ccorderResults[] = $res;
            } else {
                $existsOrders[] = $res['id'];
                $orderResults[] = $res;
            }
        }

        /*check exists orders from transaction table*/
        if (!empty($existsOrders)) {
            $this->db->select('order_id');
            $this->db->where_in('order_id', $existsOrders);
            $checkTransactionOrders = $this->db->get('tb_allocate_ratio_txn');

            if ($checkTransactionOrders->num_rows() > 0) {
                $ordersExists = [];
                foreach ($checkTransactionOrders as $extord) {
                    $ordersExists[] = $extord->order_id;
                }

                foreach ($orderResults as $key => $checkOrder) {
                    if (in_array($checkOrder['id'], $ordersExists)) {
                        unset($orderResults[$key]);
                    }
                }
            }
        }

        $this->scheduledJobService->log(
            'tb_orders',
            sprintf('Creating trips for  %d records', count($unAllocatedCarrierOrders))
        );

        $orderTotalCount = count($ccorderResults) + count($orderResults);
        if (!empty($ccorderResults)) {
            /*get kn carrier*/
            $vendor = $this->getDefaultVendorData($currentDateTime);
            $cccarrier = 0;

            $vendorinfo = $this->common->gettblrowdata(
                ["mobile" => '9032033997', 'user_id' => 244],
                "id",
                "tb_vendors",
                0,
                0
            );

            $cccarrier = (!empty($vendorinfo)) ? $vendorinfo['id'] : $this->common->insertTableData(
                "tb_vendors",
                $vendor
            );

            foreach ($ccorderResults as $orderInfo) {
                $orderTransactionData = [
                    "user_id"              => $orderInfo['user_id'],
                    "order_id"             => $orderInfo['id'],
                    "awb_num"              => $orderInfo['order_id'],
                    "order_type"           => $orderInfo['ordtype_code'],
                    "actual_carrier_id"    => $cccarrier,
                    "allocated_carrier_id" => $cccarrier,
                    "batch_count"          => count($ccorderResults),
                    "allocate_status"      => 1,
                    "nsz"                  => "",
                    "alloted_state"        => 1,
                    "createdon"            => $currentDateTime,
                    "total_count"          => $orderTotalCount,
                ];
                $this->orderallocationservice->saveTransaction($orderTransactionData);
                $transcationCcOrder = [
                    'order_id'   => $orderInfo['id'],
                    'user_id'    => $orderInfo['user_id'],
                    'carrier_id' => $cccarrier
                ];

                $ship_id = $this->singletriporder->ordercreatetrip($transcationCcOrder);
                $updwhr = ["order_row_id" => $orderInfo['id']];
                $updset = ["delivery_note" => $orderInfo['order_id']];

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "Uniqlocarrierallot updated data in a tb_order_details: " . print_r($updset, true)
                );

                $this->common->updatetbledata("tb_order_details", $updset, $updwhr);
                $whereStatement = [
                    "order_id"     => $orderInfo['id'],
                    "reference_id" => "AWB",
                    "ref_value"    => $orderInfo['order_id'],
                    "status"       => 1
                ];
                $check = $this->common->gettblrowdata($whereStatement, "id", "tb_order_references", 0, 0);
                if (count($check) == 0) {
                    $insarr = [
                        "order_id"     => $orderInfo['id'],
                        "reference_id" => "AWB",
                        "ref_value"    => $orderInfo['order_id'],
                        "createdon"    => $currentDateTime,
                        "status"       => 1
                    ];

                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "Uniqlocarrierallot inserted data in a tb_order_references: " . print_r($insarr, true)
                    );

                    $this->common->insertTableData("tb_order_references", $insarr);
                }

                $this->uniqloediservices->senddocketnumber($orderInfo['id']);
            }
        }

        $this->scheduledJobService->log(
            'tb_orders',
            sprintf('Allocating %d records', count($unAllocatedCarrierOrders))
        );

        if (!empty($orderResults)) {
            $this->orderallocationservice->allocateOrders(
                $orderResults,
                $orderTotalCount
            );
            /*get all carrier orders to create trip and get awb number*/
            $whrtxn = sprintf(
                'actual_carrier_id!=0 AND allocate_status=0 AND alloted_state IN(0,2) AND status=1 AND order_id IN(%s)',
                implode(', ', $this->getOrderResultsId($orderResults)),
            );
            $select = "id,order_id,user_id,actual_carrier_id as carrier_id,order_type,pincode";
            $tbl = "tb_allocate_ratio_txn";
            $transactionOrders = $this->common->gettbldataorderby($whrtxn, $select, $tbl, "id", "ASC");
            foreach ($transactionOrders as $transactionOrder) {
                $order_type = 0;
                $qccarrier = 0;
                $orderTypeMessage = "Forward Order";
                if ($transactionOrder['order_type'] != 'SO') {
                    $order_type = 1;
                    $initialVendorId = $transactionOrder['carrier_id'];
                    $orderTypeMessage = "Return Order";
                    /* check qc */
                    $qccarrier = $this->checkCarrierRevQc(
                        $transactionOrder['carrier_id'],
                        $transactionOrder['pincode']
                    );
                    if ($qccarrier == 0) {
                        $startEndTime = $this->getStartAndEndTime();

                        $getReturnNxtCarrier = $this->getNextCarrier(
                            $transactionOrder['carrier_id'],
                            $order_type,
                            $startEndTime['start'],
                            $startEndTime['end'],
                            $transactionOrder['pincode']
                        );
                        if (!empty($getReturnNxtCarrier)) {
                            if ($getReturnNxtCarrier['carrier_id'] != $initialVendorId) {
                                $qccarrier = $transactionOrder['carrier_id'] = $getReturnNxtCarrier['carrier_id'];
                            }
                        }
                    }
                }

                if ($order_type == 1 && $qccarrier == 0) {
                    $this->sendNocToWarehouse(
                        'NOC',
                        $transactionOrder,
                        $order_type,
                        $orderTypeMessage
                    );
                    //Request AWS/Docketnumber from the carrier
                } else {
                    $this->createTripAndAllocateToCarriers(
                        $transactionOrder,
                        $order_type,
                        $orderTypeMessage
                    );
                }
            }
        }

        $this->scheduledJobService->log(
            'tb_orders',
            sprintf('Successfully allocated %d orders', self::$SUCCESSFULLY_ALLOCATED)
        );
        $this->scheduledJobService->log(
            'tb_orders',
            sprintf('Failed to allocate %d orders', self::$FAILED_TO_ALLOCATE)
        );

        $this->scheduledJobService->finishJob(true);
    }

    /*check carrier pincode reverse qc*/
    private function checkCarrierRevQc($carrierId, $pincode)
    {
        $resp = 0;
        $whrcond = ['destination_pin' => $pincode, 'carrier_id' => $carrierId, 'reverse_qc' => 1, 'status' => 1];
        $chkrevqc = $this->common->gettblrowdata($whrcond, "id,carrier_id", "tb_customer_pincodes", 0, 0);
        if (count($chkrevqc) > 0) {
            $resp = $carrierId;
        }

        log_error(UNIQLO_LOG_PREFIX . "checkCarrierRevQc outbound data: " . $resp);

        return $resp;
    }

    private function getAwbNum($vendor_id, $ship_id)
    {
        if ($vendor_id == self::VENDOR_DELHIVERY) {
            $sendTrip = $this->uniqloediservices->getdelverywaybillnumber($ship_id);
            $carrierName = 'Delhivery';
        } elseif ($vendor_id == self::VENDOR_ECOM_EXPRESS) {
            $sendTrip = $this->uniqloediservices->forwardmanifestation($ship_id);
            $carrierName = 'EcomExpress';
        } elseif ($vendor_id == self::VENDOR_XPRESS_BEES) {
            $sendTrip = $this->uniqloediservices->xbordercreatemanifestation($ship_id);
            $carrierName = 'ExpressBees';
        }

        if(empty($sendTrip)){
            return;
        }

        if ($sendTrip['status'] == 0) {
            $sendTrip['failmsg'] = sprintf('%s: %s, ', $carrierName, $sendTrip['data']);
        }

        return $sendTrip;
    }

    private function sendEmailForNoAwb($mailinfo)
    {
        log_error(UNIQLO_LOG_PREFIX . "sendEmailForNoAwb inbound data: " . print_r($mailinfo, true));

        $receivemail = ["pawan.batra@kuehne-nagel.com", "sunny.sharma@kuehne-nagel.com"];
        $cc = [
            "athmanathan.gnanavel@kuehne-nagel.com",
            "arun.perumalraj@kuehne-nagel.com",
            "kumar.sanjeev@kuehne-nagel.com",
            "Sandeep.Singh@kuehne-nagel.com",
            "vasudev.mishra@kuehne-nagel.com",
            "vasudev.mishra@kuehne-nagel.com",
            "subhadip.saha@kuehne-nagel.com",
            "chandan.kumar@kuehne-nagel.com",
            "abdul.nisar@kuehne-nagel.com",
            "krishna.agarwal@kuehne-nagel.com"
        ];
        $orditem = $mailinfo['order_id'];
        $ordtypemsg = $mailinfo['ordtype'];
        $failmsg = $mailinfo['failmsg'];
        $sub1 = "eTN: " . $orditem . " " . $ordtypemsg . " Assigning Failed";
        $this->load->library('email');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to($receivemail);
        $this->email->cc($cc);
        $this->email->subject($sub1);
        $this->email->set_mailtype("html");
        $body = "Dear Team, <br/>";
        $body .= $sub1 . " <br/>";
        $body .= "Details. <br/><br/>";
        $body .= $failmsg . "<br/><br/>";
        $body .= "Thank You <br/>";
        $body .= "Svkonekt <br/>";
        $this->email->message($body);
        $sendmail = $this->email->send();

        log_error(UNIQLO_LOG_PREFIX . "sendEmailForNoAwb sended email: " . $sendmail);

        return true;
    }

    public function updatecarr($order_id, $carid, $shift_id)
    {
        $this->common->updatetbledata("tb_orders", ["vendor_id" => $carid], ["id" => $order_id]);

        $this->common->updatetbledata("tb_shifts", ["vendor_id" => $carid], ["id" => $shift_id]);

        $this->common->updatetbledata("tb_employee", ["vendor_id" => $carid], ["shift_id" => $shift_id]);

        $this->common->updatetbledata("tb_shft_veh", ["carrier_id" => $carid], ["shft_id" => $shift_id]);
    }

    private function getNextCarrier($carid, $type, $stime, $etime, $pincode)
    {
        $getnxtcarr = [];
        $whr = [
            'carrier_id' => $carid,
            "order_type" => $type,
            "startdate <=" => $stime,
            "enddate>=" => $etime,
            "status" => 1
        ];
        $getcurrcarr = $this->common->gettblrowdata($whr, "carrier_id,sequence_no", "tb_allocate_ratio_batch", 0, 0);
        if (!empty($getcurrcarr)) {
            $sequence_no = $getcurrcarr['sequence_no'] + 1;
            $whr2 = [
                "order_type" => $type,
                "sequence_no" => $sequence_no,
                "startdate <=" => $stime,
                "enddate>=" => $etime,
                "status" => 1
            ];
            $getnxtcarr = $this->common->gettblrowdata(
                $whr2,
                "carrier_id,sequence_no",
                "tb_allocate_ratio_batch",
                0,
                0
            );
            if (!empty($getnxtcarr)) {
                if ($type == 1) {
                    $chkqccarrier = $this->checkCarrierRevQc($getnxtcarr['carrier_id'], $pincode);
                    if ($chkqccarrier == 0) {
                        $nextcarrierseq = $sequence_no + 1;
                        $getnxtcarr = $this->getNxtQcCarrier(
                            $getnxtcarr['carrier_id'],
                            $type,
                            $stime,
                            $etime,
                            $nextcarrierseq,
                            $pincode
                        );
                        if (!empty($getnxtcarr)) {
                            log_error(
                                UNIQLO_LOG_PREFIX . "getNextCarrier outbound data: " . print_r($getnxtcarr, true)
                            );

                            return $getnxtcarr;
                        }
                    }
                }

                log_error(UNIQLO_LOG_PREFIX . "getNextCarrier outbound data: " . print_r($getnxtcarr, true));

                return $getnxtcarr;
            } else {
                $whr3 = [
                    "order_type" => $type,
                    "sequence_no" => 1,
                    "startdate <=" => $stime,
                    "enddate>=" => $etime,
                    "status" => 1
                ];
                $getnxtcarr = $this->common->gettblrowdata(
                    $whr3,
                    "carrier_id,sequence_no",
                    "tb_allocate_ratio_batch",
                    0,
                    0
                );
                if (!empty($getnxtcarr)) {
                    if ($type == 1) {
                        $chkqccarrier = $this->checkCarrierRevQc($getnxtcarr['carrier_id'], $pincode);
                        if ($chkqccarrier == 0) {
                            $getnxtcarr = [];
                        }
                    }
                }

                log_error(UNIQLO_LOG_PREFIX . "getNextCarrier outbound data: " . print_r($getnxtcarr, true));

                return $getnxtcarr;
            }
        } else {
            log_error(UNIQLO_LOG_PREFIX . "getNextCarrier outbound data: " . print_r($getnxtcarr, true));

            return $getnxtcarr;
        }
    }

    public function getNxtQcCarrier($carid, $type, $stime, $etime, $sequence_no, $pincode)
    {
        $getnxtcarr = [];
        $whr2 = [
            "order_type" => $type,
            "sequence_no" => $sequence_no,
            "startdate <=" => $stime,
            "enddate>=" => $etime,
            "status" => 1
        ];
        $getnxtcarr = $this->common->gettblrowdata($whr2, "carrier_id,sequence_no", "tb_allocate_ratio_batch", 0, 0);
        if (!empty($getnxtcarr)) {
            $chkqccarrier = $this->checkCarrierRevQc($getnxtcarr['carrier_id'], $pincode);
            if ($chkqccarrier == 0) {
                $seqno = $sequence_no + 1;
                $getnxtcarr = $this->getNxtQcCarrier($carid, $type, $stime, $etime, $seqno, $pincode);
                if (!empty($getnxtcarr)) {
                    return $getnxtcarr;
                }
            }
            return $getnxtcarr;
        } else {
            $whr3 = [
                "order_type" => $type,
                "sequence_no" => 1,
                "startdate <=" => $stime,
                "enddate>=" => $etime,
                "status" => 1
            ];
            $getnxtcarr = $this->common->gettblrowdata(
                $whr3,
                "carrier_id,sequence_no",
                "tb_allocate_ratio_batch",
                0,
                0
            );
            if (!empty($getnxtcarr)) {
                $chkqccarrier = $this->checkCarrierRevQc($getnxtcarr['carrier_id'], $pincode);
                if ($chkqccarrier == 0) {
                    $getnxtcarr = [];
                }
            }

            log_error(UNIQLO_LOG_PREFIX . "getNxtQcCarrier outbound data: " . print_r($getnxtcarr, true));

            return $getnxtcarr;
        }
    }

    /**
     * @param $res
     *
     * @return string
     */
    private function getDestinationState($res): string
    {
        $dest_cnt = explode(", ", $res['delivery_address2']);
        if (!empty($dest_cnt) && count($dest_cnt) > 0) {
            $dest_state = $dest_cnt[count($dest_cnt) - 1] ?? "";
        }

        if ($res['created_source'] === 16) {
            $dest_state = 'HARYANA';
        }

        return $dest_state ?? $res['delivery_city'];
    }

    /**
     * @param $res
     *
     * @return string
     */
    private function getOriginState($res): string
    {
        $orgin_cnt = explode(", ", $res['pickup_address2']);
        if (!empty($orgin_cnt) && count($orgin_cnt) > 0) {
            $origin_state = $orgin_cnt[count($orgin_cnt) - 1] ?? "";
        }

        if ($res['created_source'] === 15) {
            $origin_state = 'HARYANA';
        }

        return $origin_state ?? $res['pickup_city'];
    }

    /**
     * @param DateTime $currentDateTime
     *
     * @return array
     */
    private function getDefaultVendorData(DateTime $currentDateTime): array
    {
        return [
            'name' => 'KN_CARR',
            'mobile' => '9032033997',
            'location' => 'GURGAON',
            'address' => 'KUEHNE + NAGEL, JKS LOGISTICS PARK, WH2, GURGAON, INDIA, 122413',
            'pincode' => '122413',
            'country' => 'INDIA',
            'password' => 'd41d8cd98f00b204e9800998ecf8427e',
            'code' => '9032033997',
            'offering_type' => '',
            'carrier_grade' => 'FTL',
            'effective_date' => $currentDateTime->format('Y-m-d'),
            'expiry_date'    => $currentDateTime->format('Y-m-d'),
            'service_id'     => '',
            'service_name'   => '',
            'fcm_token'      => null,
            'user_id'        => 244,
            'custid'         => null,
            'partyid'        => null,
            'company_code'   => 'INKN',
            'branch_code'    => 'INCL',
            'status'         => 1,
            'created_on'     => $currentDateTime->format('Y-m-d H:i:s'),
            'updated_on'     => $currentDateTime->format('Y-m-d H:i:s'),
        ];
    }

    /**
     * @param        $transactionOrder
     * @param        $data
     * @param  $failmsg
     * @param        $ship_id
     *
     * @return void
     */
    private function allocatedCarrier($transactionOrder, $data, string $failMsg, $ship_id): void
    {
        $this->common->updatetbledata(
            "tb_allocate_ratio_txn",
            [
                "allocated_carrier_id" => $transactionOrder['carrier_id'],
                "allocate_status" => 1,
                "awb_num" => $data,
                "nsz" => $failMsg
            ],
            [
                "id" => $transactionOrder['id']
            ],
        );

        $this->updatecarr(
            $transactionOrder['order_id'],
            $transactionOrder['carrier_id'],
            $ship_id
        );
    }

    /**
     * @param string $noAwbReason
     * @param array $transactionOrder
     * @param int $orderType
     * @param string $orderTypeMessage
     */
    private function sendNocToWarehouse(
        string $noAwbReason,
        array $transactionOrder,
        int $orderType,
        string $orderTypeMessage
    ): void {
        $orderItem = $this->getOrderItem($transactionOrder['order_id'], $orderType);

        $this->sendEmailForNoAwb([
                                     'failmsg' => $noAwbReason,
                                     'order_id' => $transactionOrder['order_id'] ?? $orderItem['ref_value'],
                                     'ordtype' => $orderTypeMessage,
                                 ]);

        $this->common->updatetbledata(
            'tb_allocate_ratio_txn',
            [
                'allocated_carrier_id' => 0,
                'allocate_status' => 1,
                'nsz' => $noAwbReason
            ],
            [
                'id' => $transactionOrder['id']
            ]
        );

        $this->uniqloediservices->senddocketnumber($transactionOrder['order_id']);
    }

    /**
     * @param array $transactionOrder
     * @param int $orderType
     * @param string $orderTypeMessage
     * @param        $shipId
     *
     * @return array
     */
    public function allocateOrderToCarriersReadable(
        array $transactionOrder,
        int $orderType,
        string $orderTypeMessage,
        $shipId
    ): array {
        $vendorId = $triedCarrierIds[] = $transactionOrder['carrier_id'];
        $noAwbReason = [];
        $currentTime = new DateTime();

        for ($i = 1; $i <= 3; $i++) {
            $sendTrip = $this->getAwbNum($vendorId, $shipId);
            if ($sendTrip['status'] !== 0) {
                $this->allocatedCarrier($transactionOrder, $sendTrip['data'], (string) $sendTrip['failmsg'], $shipId);

                return [
                    'isAllocated' => true,
                ];
            }

            $noAwbReason[] = $sendTrip['failmsg'];

            $getNextCarrier = $this->getNextCarrier(
                $vendorId,
                $orderType,
                $currentTime->format('Y-m-d'),
                ((clone $currentTime)->add(new DateInterval('PT30M')))->format('Y-m-d'),
                $transactionOrder['pincode'],
            );

            if (empty($getNextCarrier) || in_array($getNextCarrier['carrier_id'], $triedCarrierIds)) {
                break;
            }

            $triedCarrierIds[] = $vendorId = $getNextCarrier['carrier_id'];
        }

        $this->common->updatetbledata(
            'tb_orders',
            [
                'status' => 1,
                'shift_id' => 0
            ],
            [
                'id' => $transactionOrder['order_id']
            ]
        );

        $this->sendNocToWarehouse(implode(", \n", $noAwbReason), $transactionOrder, $orderType, $orderTypeMessage);

        return [
            'isAllocated' => false,
            'triedCarriers' => $triedCarrierIds
        ];
    }

    /**
     * @param array $transactionOrder
     * @param int $order_type
     * @param string $ordtypemsg
     *
     * @throws JsonException
     */
    private function createTripAndAllocateToCarriers(array $transactionOrder, int $order_type, string $ordtypemsg): void
    {
        $ship_id = $this->singletriporder->ordercreatetrip($transactionOrder);
        if ($ship_id === null || $ship_id <= 0) {
            return;
        }

        if (!($allocationResult = $this->allocateOrderToCarriersReadable(
            $transactionOrder,
            $order_type,
            $ordtypemsg,
            $ship_id
        ))['isAllocated']) {
            $this->uniqloModel->markAllocationAsFailed(
                $transactionOrder['order_id'],
                $allocationResult['triedCarriers']
            );
            self::$FAILED_TO_ALLOCATE++;
        }

        self::$SUCCESSFULLY_ALLOCATED++;
    }

    private function getOrderResultsId(array $orderResults): array
    {
        return array_map(function ($order) {
            return $order['id'];
        }, $orderResults);
    }

    /**
     * @param $orderId
     * @param int $orderType
     * @return array
     */
    private function getOrderItem($orderId, int $orderType): array
    {
        return $this->common->gettblrowdata(
            [
                'order_id' => $orderId,
                'reference_id' => $orderType == 0 ? 'PO' : 'DQ',
                "status" => 1
            ],
            'ref_value',
            'tb_order_references',
            0,
            0
        );
    }

    /**
     * @return array
     */
    private function getStartAndEndTime(): array
    {
        $currentDateTime = new DateTime();
        $negativeDateInterval = new DateInterval('PT30M');
        $negativeDateInterval->invert = 1;
        $starTime = $currentDateTime->add($negativeDateInterval)->format('Y-m-d');
        $endTime = $currentDateTime->format('Y-m-d');

        return ['start' => $starTime, 'end' => $endTime];
    }
}
