<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Uniqloautocloseorders extends CI_Controller
{
    private const UNIQLO_USER = '244';
    private const VENDOR_DELHIVERY = '310';
    private const VENDOR_ECOM_EXPRESS = '311';

    public function __construct()
    {
        parent::__construct();
        $this->load->model("common");
    }

    /*Before 90 days of orders status to be close if any open orders (cron run in everyday night)*/
    public function index($daysToClose = 90)
    {
        if($daysToClose < 31) {
            echo "Number of days must be > 31 to close uniqlo open orders";
            return;
        }
        $ordersDate = date('Y-m-d', strtotime('-' . $daysToClose . ' days'));
        $selectColumns = "id,pickup_city,delivery_city,weight,goods_value,vendor_id,shift_id,trip_id,updatedon,created_source";
        $whereCondition = [
            'user_id' => self::UNIQLO_USER,
            'status <>' => 0,
            'trip_sts' => 0,
            'createdon <' => $ordersDate
        ];
        $this->db->select($selectColumns);
        $this->db->from("tb_orders");
        $this->db->where($whereCondition);
        $uniqloOrders = $this->db->get();
        if ($uniqloOrders->num_rows() > 0) {
            foreach ($uniqloOrders->result_array() as $order) {
                $shipment_id = $trip_id = $stop_id = $stop_detail_id = 0;
                /*get order recent status to get stop id and stop details id*/
                $statusWhereCondition = [
                    'order_id' => $order['id']
                ];
                $selectColumns = "order_id,shipment_id,stop_id,stop_detail_id,trip_id,status_id,status_code,createdon";
                $this->db->select($selectColumns);
                $this->db->from("tb_stop_status");
                $this->db->where($statusWhereCondition);
                $this->db->order_by("id", "DESC");
                $this->db->limit(1);
                $orderStatus = $this->db->get();
                if ($orderStatus->num_rows() > 0) {
                    $shipment_id = $orderStatus->row()->shipment_id;
                    $trip_id = $orderStatus->row()->trip_id;
                    $stop_id = $orderStatus->row()->stop_id;
                    $stop_detail_id = $orderStatus->row()->stop_detail_id;
                }
                $shipment_id = ($shipment_id == 0) ? $order['shift_id'] : $shipment_id;
                $trip_id = ($trip_id == 0) ? $order['trip_id'] : $trip_id;

                /*check order deliver status and update*/
                $pickupStopType = 'P';
                $deliverStopType = 'D';
                $deliverStatusCode = '2300';
                $statusWhere = [
                    "order_id" => $order['id'],
                    "status_id" => 1,
                    "stop_type" => $deliverStopType,
                    "status_code" => $deliverStatusCode
                ];
                $deliverStatusResult = $this->common->gettblrowdata($statusWhere, "id", "tb_stop_status", 0, 0);
                if (empty($deliverStatusResult)) {
                    $insertStatusData = [
                        'order_id' => $order['id'],
                        'shipment_id' => $shipment_id,
                        'stop_id' => $stop_id,
                        'stop_detail_id' => $stop_detail_id,
                        'stop_type' => $deliverStopType,
                        'trip_id' => $trip_id,
                        'status_id' => 1,
                        'status_code' => $deliverStatusCode,
                        'status' => 1,
                        'createdon' => $order['updatedon']
                    ];
                    $this->common->insertTableData("tb_stop_status", $insertStatusData);
                }
                $senderName = 'KUEHNE NAGEL UNIQLO';
                $origin = $order['pickup_city'] . "_" . $pickupStopType;
                $destination = $order['delivery_city'] . "_" . $deliverStopType;
                $statusCode = 'EOD-135';
                $statusType = 'DL';
                $orderType = 'Pre-paid';
                $statusName = 'Delivered';
                $returnOrderType = 16;
                if ($order['vendor_id'] == self::VENDOR_ECOM_EXPRESS) {
                    $statusCode = '999';
                    $statusType = 'UD';
                }
                if ($order['created_source'] == $returnOrderType) {
                    $orderType = 'Pickup';
                    if ($order['vendor_id'] == self::VENDOR_DELHIVERY) {
                        $statusName = "DTO";
                    }
                }
                $weight = round(($order['weight'] / 1000), 2);

                /*insert tracking table data*/
                $statusTrackWhere = [
                    "order_id" => $order['id'],
                    'status_name' => $statusName,
                    'status_type' => $statusType,
                    'status_code' => $statusCode
                ];
                $statusTrackResult = $this->common->gettblrowdata($statusTrackWhere, "id", "tb_uniqlo_order_tracking", 0, 0);
                if (empty($statusTrackResult)) {
                    $insertTrackStatusData = [
                        'order_id' => $order['id'],
                        'origin' => $origin,
                        'status_name' => $statusName,
                        'status_location' => $destination,
                        'status_datetime' => $order['updatedon'],
                        'receivedby' => "",
                        'instructions' => $statusName,
                        'status_type' => $statusType,
                        'status_code' => $statusCode,
                        'pickup_date' => $order['updatedon'],
                        'charged_weight' => $weight,
                        'order_type' => $orderType,
                        'destination' => $destination,
                        'returned_date' => $order['updatedon'],
                        'origin_recieve_date' => $order['updatedon'],
                        'out_destination_date' => $order['updatedon'],
                        'cod_amount' => $order['goods_value'],
                        'reverse_ntransit' => 0,
                        'sender_name' => $senderName,
                        'dispatch_count' => 1,
                        'invoice_amount' => $order['goods_value'],
                        'status' => 1,
                        'createdon' => $order['updatedon']
                    ];
                    $this->common->insertTableData("tb_uniqlo_order_tracking", $insertTrackStatusData);
                }

                /*insert scan status table data*/
                $statusScanWhere = [
                    "order_id" => $order['id'],
                    'scan_type' => $statusType,
                    'scan_val' => $statusName,
                    'scan_status_code' => $statusCode
                ];
                $statusScanResult = $this->common->gettblrowdata($statusScanWhere, "id", "tb_uniqlo_order_scans", 0, 0);
                if (empty($statusScanResult)) {
                    $insertScanStatusData = [
                        'order_id' => $order['id'],
                        'scan_datetime' => $order['updatedon'],
                        'scan_type' => $statusType,
                        'scan_val' => $statusName,
                        'scan_status_time' => $order['updatedon'],
                        'scan_location' => $destination,
                        'scan_instruction' => $statusName,
                        'scan_status_code' => $statusCode,
                        'call_duration' => 0,
                        'status' => 1,
                        'createdon' => $order['updatedon']
                    ];
                    $this->common->insertTableData("tb_uniqlo_order_scans", $insertScanStatusData);
                }
                /*update order,shipment,trip for close status*/
                $orderWhere = [
                    'id' => $order['id']
                ];
                $setOrderData = [
                    'status' => 2,
                    'shift_id' => $shipment_id,
                    'trip_id' => $trip_id,
                    'trip_sts' => 1
                ];
                $this->common->updatetbledata("tb_orders", $setOrderData, $orderWhere);
                if ($shipment_id > 0) {
                    $shipmentWhereCondition = [
                        'id' => $shipment_id
                    ];
                    $setShipmentData = [
                        'status' => 0
                    ];
                    $this->common->updatetbledata("tb_shifts", $setShipmentData, $shipmentWhereCondition);
                }
                if ($trip_id > 0) {
                    $tripWhereCondition = [
                        'id' => $trip_id
                    ];
                    $setTripData = [
                        'status' => 0
                    ];
                    $this->common->updatetbledata("tb_trips", $setTripData, $tripWhereCondition);
                }
            }
        }
    }
}
