<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once './vendor/pear/http_request2/HTTP/Request2.php';

use App\Libraries\infrastructure\ScheduledJobLoggerService;
use phpseclib\Net\SFTP;

class Uniqlocronjobs extends CI_Controller
{
    private const VENDOR_DELHIVERY = '310';
    private const VENDOR_ECOM_EXPRESS = '311';
    private const VENDOR_XPRESS_BEES = '312';
    private const UNIQLO_WAREHOUSE_LOCATION = 'GURUGRAM';
    /** @var ScheduledJobLoggerService */
    private $scheduledJobService;

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('log_helper');
        $this->load->model('common');
        $this->load->model('Uniqlomodel');
        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    /**
     * get traking data from uniqlo 3 carriers
     */
    public function trackingstatus(int $weekValue = 0)
    {
        $this->scheduledJobService->startJob();
        $this->scheduledJobService->log("trackingstatus","Init trackingstatus() with Weekvalue " . $weekValue);
        // $this->delhiveryOrderTracking($weekValue);
        // $this->scheduledJobService->log("trackingstatus","Done with delhiveryOrderTracking()");
        $this->ecomShipmentTracking($weekValue);
        $this->scheduledJobService->log("trackingstatus","Done with ecomShipmentTracking()");
        // XpressBees not implementedre-
        //$this->xpBorderTracking($weekValue);
        //$this->scheduledJobService->log("trackingstatus","Done with xpBorderTracking()");
        $this->scheduledJobService->finishJob(true);
    }

    public function delhiveryOrderTracking(int $weekValue): void
    {

        $referencesAndOrders = $this->Uniqlomodel->getReferencesValueAndOrdersIdByVendorId(
            self::VENDOR_DELHIVERY,
            $weekValue
        );

        $this->scheduledJobService->log("delhiveryOrderTracking","Number of references in delhiveryOrderTracking(): " . count($referencesAndOrders));

        if (empty($referencesAndOrders)) {
            return;
        }

        foreach ($referencesAndOrders as $referenceAndOrder) {
            $pstr = $referenceAndOrder['refValue'];
            $reqdata = "?waybill=" . $pstr . "&token=" . DELHIVERY_AUTH_TOKEN;
            $edi_request = $reqdata;
            $edi_response = "Status check";
            $edi_id = 8;
            $edi_name = "Delhivery";
            $status = 0;
            $params = array(
                'edi_type' => 2, /* 1->EDI Transport Order, 2->EDI Status */
                'transaction_id' => time(),
                'edi_id' => $edi_id, /* edi id based on name take it from tb_edi_types */
                'edi_name' => $edi_name,
                'bounded_type' => 1, /* 1->Inbound(partner => kN),2->Outbound (KN => partner) */
                'edi_format_type' => 'json',
                'status' => $status,
                'obj_type' => 1,
                'txn_obj_id' => $referenceAndOrder['ordersId'],
                'user_id' => 244,
                'company_code' => "INKN",
                'branch_code' => "INCL",
                'edi_request' => $edi_request,
                'edi_response' => $edi_response
            );

            $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

            $stsarr = array();
            $serverUrl = DELHIVERY_ORD_TRACK . "" . $reqdata;
            $request = new HTTP_Request2();
            $request->setUrl($serverUrl);
            $request->setMethod(HTTP_Request2::METHOD_GET);
            $request->setConfig(getHttpRequestConfig());

            try {
                $response = $request->send();

                if ($response->getStatus() == 200) {
                    $resp = $edi_response = $response->getBody();
                    $resp1 = json_decode($resp, true);

                    $stsarr = $this->dvordertrackupdate($resp1, $referenceAndOrder['ordersId']);
                } else {
                    $this->scheduledJobService->log("delhiveryOrderTracking", "Delhivery API getStatus not 200 but: " . print_r($response->getStatus(), true));
                }

                if (!empty($stsarr)) {
                    $set = array(
                        "status" => 1,
                        "user_id" => $stsarr['user_id'],
                        "company_code" => $stsarr['company_code'],
                        "branch_code" => $stsarr['branch_code'],
                        "edi_response" => $edi_response
                    );
                } else {
                    $set = array("status" => 0, "edi_response" => $edi_response);
                }

                $whr = array("id" => $edilogid);
                $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
            } catch (HTTP_Request2_Exception $e) {
                $this->scheduledJobService->log("delhiveryOrderTracking", "Delhivery API error: " . print_r($e, true));
            }
        }
    }

    /**
     * Update trip statuses from delhivery API order tracking data
     */
    public function dvordertrackupdate($stsdata, $order_id)
    {
        $resp = array();
        $response = array();
        if (isset($stsdata['ShipmentData']) && !isset($stsdata['Error'])) {
            foreach ($stsdata['ShipmentData'] as $res) {
                $ship = $res['Shipment'];
                $scans = $ship['Scans'];
                $scanarr = array();

                foreach ($scans as $scn) {
                    $scanarr[] = $scn['ScanDetail'];
                }

                $reverse = 0;

                if ($ship['ReverseInTransit']) {
                    $reverse = 1;
                }

                $status_datetime = $returned_date = $dest_recieve_date = $out_destination_date = $first_attempt_date = null;

                if ($ship['Status']['StatusDateTime'] != "") {
                    $status_datetime = date("Y-m-d H:i:s", strtotime($ship['Status']['StatusDateTime']));
                }

                if ($ship['ReturnedDate'] != "") {
                    $returned_date = date("Y-m-d H:i:s", strtotime($ship['ReturnedDate']));
                }

                if ($ship['DestRecieveDate'] != "") {
                    $dest_recieve_date = date("Y-m-d H:i:s", strtotime($ship['DestRecieveDate']));
                }

                if ($ship['OutDestinationDate'] != "") {
                    $out_destination_date = date("Y-m-d H:i:s", strtotime($ship['OutDestinationDate']));
                }

                if ($ship['FirstAttemptDate'] != "") {
                    $first_attempt_date = date("Y-m-d H:i:s", strtotime($ship['FirstAttemptDate']));
                }

                $hresponse = array(
                    'order_id' => $order_id,
                    'origin' => $ship['Origin'],
                    'status_name' => $ship['Status']['Status'],
                    'status_location' => $ship['Status']['StatusLocation'],
                    'status_datetime' => $status_datetime,
                    'receivedby' => $ship['Status']['RecievedBy'],
                    'instructions' => $ship['Status']['Instructions'],
                    'status_type' => $ship['Status']['StatusType'],
                    'status_code' => $ship['Status']['StatusCode'],
                    'pickup_date' => $ship['PickUpDate'],
                    'charged_weight' => $ship['ChargedWeight'],
                    'order_type' => $ship['OrderType'],
                    'destination' => $ship['Destination'],
                    'returned_date' => $returned_date,
                    'dest_recieve_date' => $dest_recieve_date,
                    'origin_recieve_date' => $ship['OriginRecieveDate'],
                    'out_destination_date' => $out_destination_date,
                    'cod_amount' => $ship['CODAmount'],
                    'first_attempt_date' => $first_attempt_date,
                    'reverse_ntransit' => $reverse,
                    'sender_name' => $ship['SenderName'],
                    'dispatch_count' => $ship['DispatchCount'],
                    'invoice_amount' => $ship['InvoiceAmount'],
                    'status' => 1
                );
                $chkdata = array(
                    'order_id' => $order_id,
                    'status_name' => $ship['Status']['Status'],
                    'status_datetime' => $status_datetime,
                    'status_type' => $ship['Status']['StatusType'],
                    'status_code' => $ship['Status']['StatusCode'],
                    'order_type' => $ship['OrderType']
                );
                $chk = $this->common->gettblrowdata($chkdata, "id", "tb_uniqlo_order_tracking", 0, 0);
                if (count($chk) > 0) {
                    $set = $hresponse;
                    $whr = array("id" => $chk['id']);
                    $this->common->updatetbledata("tb_uniqlo_order_tracking", $set, $whr);
                } else {
                    $this->common->insertTableData("tb_uniqlo_order_tracking", $hresponse);
                }

                if (!empty($scanarr)) {
                    foreach ($scanarr as $scnrs) {
                        if (isset($scnrs['Scan'])) {
                            $scan_datetime = $scan_status_time = null;

                            if ($scnrs['ScanDateTime'] != "") {
                                $scan_datetime = date("Y-m-d H:i:s", strtotime($scnrs['ScanDateTime']));
                            }

                            if ($scnrs['StatusDateTime'] != "") {
                                $scan_status_time = date("Y-m-d H:i:s", strtotime($scnrs['StatusDateTime']));
                            }

                            $sresponse['order_id'] = $order_id;
                            $sresponse['scan_datetime'] = $scan_datetime;
                            $sresponse['scan_type'] = $scnrs['ScanType'];
                            $sresponse['scan_val'] = $scnrs['Scan'];
                            $sresponse['scan_status_time'] = $scan_status_time;
                            $sresponse['scan_location'] = $scnrs['ScannedLocation'];
                            $sresponse['scan_instruction'] = $scnrs['Instructions'];
                            $sresponse['scan_status_code'] = $scnrs['StatusCode'];
                            $sresponse['call_duration'] = isset($scnrs['call_duration']) ? $scnrs['call_duration'] : 0;
                            $latlng = isset($scnrs['geo_location']) ? $scnrs['geo_location'] : array();

                            if (!empty($latlng)) {
                                $sresponse['scan_geo_lat'] = $latlng['lat'];
                                $sresponse['scan_geo_lng'] = $latlng['long'];
                            }

                            $sresponse['status'] = 1;
                            $chkdata = array(
                                'order_id' => $order_id,
                                'scan_datetime' => $scan_datetime,
                                'scan_type' => $scnrs['ScanType'],
                                'scan_val' => $scnrs['Scan'],
                                'scan_instruction' => $scnrs['Instructions'],
                                'scan_status_code' => $scnrs['StatusCode']
                            );
                            $chk = $this->common->gettblrowdata($chkdata, "id", "tb_uniqlo_order_scans", 0, 0);

                            if (count($chk) > 0) {
                            /* commenting for now - until the changes settle */
                            //    $set = $sresponse;
                            //    $whr = array("id" => $chk['id']);
                            //    $this->common->updatetbledata("tb_uniqlo_order_scans", $set, $whr);
                            } else {
                                $this->common->insertTableData("tb_uniqlo_order_scans", $sresponse);
                            }
                        }
                    }
                }

                $ship['EWBN'] = isset($ship['EWBN']) ? $ship['EWBN'] : "";
                $response = array(
                    'Status' => $ship['Status']['Status'],
                    'StatusLocation' => $ship['Status']['StatusLocation'],
                    'StatusDateTime' => $ship['Status']['StatusDateTime'],
                    'RecievedBy' => $ship['Status']['RecievedBy'],
                    'Instructions' => $ship['Status']['Instructions'],
                    'StatusType' => $ship['Status']['StatusType'],
                    'StatusCode' => $ship['Status']['StatusCode'],
                    'ref_num' => $ship['ReferenceNo'],
                    'CODAmount' => $ship['CODAmount'],
                    'EWBN' => $ship['EWBN'],
                    'SenderName' => $ship['SenderName'],
                    'AWB' => $ship['AWB'],
                    'DispatchCount' => $ship['DispatchCount'],
                    'InvoiceAmount' => $ship['InvoiceAmount'],
                    'ScanDetail' => $scanarr
                );
            }
        }

        if (!empty($response)) {
            $curdt = date("Y-m-d H:i:s");
            $response['Stop_Type'] = 'P';
            $intransts = array();

            if ($response['StatusType'] == "") {
                $response['StatusType'] = "UD";
            }

            $response['desc'] = "statustype: " . $response['StatusType'] . ", Desc:" . $response['Instructions'];

            if (($response['Status'] == "Manifested") || ($response['Status'] == "Open") || ($response['Status'] == "Shipment details manifested")) {
                $response['Status'] = "Manifested";
                $response['Status_Code'] = '0470';
                $response['Stop_Type'] = 'P';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if (isset($scnrs['Scan'])) {
                            if ($scnrs['Scan'] == "Manifested" || $scnrs['Scan'] == "Open") {
                                $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                            }
                        }
                    }
                }
            } elseif ($response['Status'] == "Not Picked") {
                $response['Status'] = "Gate In";
                $response['StatusID'] = 2;
                $response['Status_Code'] = '0420';
                $response['Stop_Type'] = 'P';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Not Picked") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "In Transit") {
                $response['Status'] = "In-Transit";
                $response['StatusID'] = 4;
                $response['Status_Code'] = '1550';
                $response['Stop_Type'] = 'P';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "In Transit" || $scnrs['Scan'] == "Pending") {
                            if ($scnrs['Instructions'] == "Shipment picked up") {
                                $intransts[] = array(
                                    'sts_name' => 'Pickup Or Drop',
                                    'stp_type' => 'P',
                                    'stscode' => '0500',
                                    'stsid' => 1,
                                    'time' => $scnrs['StatusDateTime'],
                                    'location' => $scnrs['ScannedLocation'],
                                    'desc' => $scnrs['Instructions']
                                );
                            }

                            if ($scnrs['Instructions'] == "Shipment Recieved at Origin Center") {
                                $intransts[] = array(
                                    'sts_name' => 'Gate Out',
                                    'stp_type' => 'P',
                                    'stscode' => '0191',
                                    'stsid' => 3,
                                    'time' => $scnrs['StatusDateTime'],
                                    'location' => $scnrs['ScannedLocation'],
                                    'desc' => $scnrs['Instructions']
                                );
                            }

                            if ($scnrs['Instructions'] == "Connected to destination") {
                                $intransts[] = array(
                                    'sts_name' => 'In-Transit',
                                    'stp_type' => 'P',
                                    'stscode' => '1550',
                                    'stsid' => 4,
                                    'time' => $scnrs['StatusDateTime'],
                                    'location' => $scnrs['ScannedLocation'],
                                    'desc' => $scnrs['Instructions']
                                );
                            }

                            if ($scnrs['Instructions'] == "Shipment Received at Facility") {
                                $intransts[] = array(
                                    'sts_name' => 'Shipment Received at Facility',
                                    'stp_type' => 'D',
                                    'stscode' => '2990',
                                    'stsid' => 0,
                                    'time' => $scnrs['StatusDateTime'],
                                    'location' => $scnrs['ScannedLocation'],
                                    'desc' => $scnrs['Instructions']
                                );
                            }

                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Pending") {
                $response['Status'] = "Pending";
                $response['Status_Code'] = '2989';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Pending") {
                            if ($scnrs['Instructions'] == "Shipment Received at Facility") {
                                $response['Status'] = "In-Transit";
                                $response['Status_Code'] = '2990';
                                $response['Stop_Type'] = 'D';
                                $sts_type = 'yes';
                                $intransts[] = array(
                                    'sts_name' => 'Shipment Received at Facility',
                                    'stp_type' => 'D',
                                    'stscode' => '2990',
                                    'stsid' => 0,
                                    'time' => $scnrs['StatusDateTime'],
                                    'location' => $scnrs['ScannedLocation'],
                                    'desc' => $scnrs['Instructions']
                                );
                            }
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Dispatched") {
                $response['Status'] = "Gate In";
                $response['StatusID'] = 2;
                $response['Status_Code'] = '0192';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Dispatched" || $scnrs['Scan'] == "Out for delivery") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Delivered") {
                $response['Status'] = "Pickup Or Drop";
                $response['StatusID'] = 1;
                $response['Status_Code'] = '2300';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Delivered") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "RTO") {
                $response['Status'] = "RTO";
                $response['Status_Code'] = 'RTO';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "RTO") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Cancelled" || $response['Status'] == "Canceled") {
                $response['Status'] = "Cancelled";
                $response['StatusID'] = 19;
                $response['Status_Code'] = '3050';
                $response['Stop_Type'] = 'D';
                $sts_type = 'no';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Cancelled" || $scnrs['Scan'] == "Canceled") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Closed") {
                $response['Status'] = "Closed";
                $response['Status_Code'] = '3051';
                $response['Stop_Type'] = 'D';
                $sts_type = 'no';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Closed") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "DTO") {
                $response['Status'] = "DTO";
                $response['Status_Code'] = 'DTO';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "DTO") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Scheduled") {
                $response['Status'] = "Planned Delivery Date";
                $response['StatusID'] = 11;
                $response['Status_Code'] = '2400';
                $response['Stop_Type'] = 'P';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Scheduled") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Collected") {
                $response['Status'] = "Gate Out";
                $response['StatusID'] = 3;
                $response['Status_Code'] = '3000';
                $response['Stop_Type'] = 'D';
                $sts_type = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scnrs) {
                        if ($scnrs['Scan'] == "Collected") {
                            $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                        }
                    }
                }
            } else {
                $response['Status_Code'] = $response['StatusCode'];
                $response['Stop_Type'] = $response['StatusType'];
                $sts_type = 'no';
            }

            if ($response['Status_Code'] == "") {
                $response['Status_Code'] = $response['StatusType'];
            }
            $stscode = $response['Status_Code'];

            if ($response['Stop_Type'] == "P" || $response['Stop_Type'] == "D") {
                $ststype = $response['Stop_Type'];
            } else {
                $ststype = "P";
            }

            $stsdate1 = $response['StatusDateTime'];
            $seldt = date("Y-m-d H:i:s", strtotime($stsdate1));
            $curtz = "Asia/Kolkata";
            $gentime = getdatetimebytimezone(DFLT_TZ, $seldt, $curtz);
            $stsdate = $gentime['datetime'];
            $orddata = $this->common->gettblrowdata(
                array("id" => $order_id),
                "id,order_id,pickup_city,plat,plng,dlat,dlng,user_id,shift_id,trip_id,vendor_id,company_code,branch_code,created_source",
                "tb_orders",
                0,
                0
            );

            if ($orddata['trip_id'] == 0) {
                $tripacc = $this->accepttrip($orddata);
                $orddata['trip_id'] = $tripacc;
            }

            $resp['user_id'] = $orddata['user_id'];
            $resp['company_code'] = $orddata['company_code'];
            $resp['branch_code'] = $orddata['branch_code'];

            if ($orddata['created_source'] == 16) {
                if (($response['Status'] == "Scheduled") || ($response['Status'] == "Planned Delivery Date") || ($response['Status'] == "Pickup Scheduled")) {
                    $response['Status'] = "Pickup Scheduled";
                    $response['StatusID'] = 47;
                    $response['Status_Code'] = '2400';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';

                    if (!empty($response['ScanDetail'])) {
                        foreach ($response['ScanDetail'] as $scnrs) {
                            if ($scnrs['Scan'] == "Scheduled") {
                                $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                            }
                        }
                    }
                } elseif ($response['Status'] == "Dispatched" || ($response['Status'] == "Gate In" && $response['Stop_Type'] == "D")) {
                    $response['Status'] = "Gate In";
                    $response['StatusID'] = 2;
                    $response['Status_Code'] = '0191';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';

                    if (!empty($response['ScanDetail'])) {
                        foreach ($response['ScanDetail'] as $scnrs) {
                            if ($scnrs['Scan'] == "Dispatched" || $scnrs['Scan'] == "Out for pickup") {
                                $response['desc'] = "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'];
                            }
                        }
                    }
                }
            }

            if ($response['Status'] == "Gate In" && $response['Stop_Type'] == "P") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } elseif ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "P") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } elseif ($response['Status'] == "Gate In" && $response['StatusID'] == "D") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } elseif ($response['Status'] == "Pickup Or Drop" && $response['StatusID'] == "D") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "D") {
                $stscode = $response['Status_Code'];
                $stsid = $response['StatusID'];
            } else {
                $sts = $this->common->gettblrowdata(
                    array("status_name" => $response['Status'], "status_code" => $stscode),
                    "id,status_code",
                    "tb_status_master",
                    0,
                    0
                );

                if (count($sts) > 0) {
                    $stscode = $sts['status_code'];
                    $stsid = $sts['id'];
                } else {
                    $arr = array(
                        'status_name' => $response['Status'],
                        'description' => $response['Status'],
                        'status_type' => $sts_type,
                        'status_code' => $stscode,
                        'customer_id' => 0,
                        'company_code' => $orddata['company_code'],
                        'branch_code' => $orddata['branch_code'],
                        'status' => 1,
                        'createdon' => $curdt
                    );

                    $stsid = $this->common->insertTableData("tb_status_master", $arr);
                }
            }

            $resp['user_id'] = $orddata['user_id'];
            $resp['company_code'] = $orddata['company_code'];
            $resp['branch_code'] = $orddata['branch_code'];

            if ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                if (!empty($intransts)) {
                    foreach ($intransts as $inss) {
                        if ($inss['stsid'] == 0) {
                            $sts = $this->common->gettblrowdata(
                                array("status_name" => $inss['sts_name'], "status_code" => $inss['stscode']),
                                "id,status_code",
                                "tb_status_master",
                                0,
                                0
                            );

                            if (count($sts) > 0) {
                                $inss['stsid'] = $sts['id'];
                            } else {
                                $arr = array(
                                    'status_name' => $inss['sts_name'],
                                    'description' => $inss['desc'],
                                    'status_type' => 'yes',
                                    'status_code' => $inss['stscode'],
                                    'customer_id' => 0,
                                    'company_code' => $orddata['company_code'],
                                    'branch_code' => $orddata['branch_code'],
                                    'status' => 1,
                                    'createdon' => $curdt
                                );

                                $inss['stsid'] = $this->common->insertTableData("tb_status_master", $arr);
                            }
                        }

                        $chqryx = $this->common->gettblrowdata(
                            array(
                                "order_id" => $order_id,
                                "shipment_id" => $orddata['shift_id'],
                                "status_id" => $inss['stsid'],
                                "status_code" => $inss['stscode'],
                                "stop_type" => $inss['stp_type']
                            ),
                            "id",
                            "tb_stop_status",
                            0,
                            0
                        );

                        if (count($chqryx) == 0) {
                            $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $where = array(
                                "shipment_id" => $orddata['shift_id'],
                                'stoptype' => $inss['stp_type'],
                                "status" => 1
                            );
                            $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($stopidinfo) > 0) {
                                $stop_id = $stopidinfo['id'];
                            }
                            $select = "id";
                            $table = "tb_employee";
                            $where = array(
                                "shift_id" => $orddata['shift_id'],
                                "order_id" => $orddata['order_id'],
                                "status" => 1
                            );
                            $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($stop_detail) > 0) {
                                $stop_detail_id = $stop_detail['id'];
                            }
                            $select = "vehicle_id,driver_id";
                            $table = "tb_trips";
                            $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                            $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($trip) > 0) {
                                $veh_id = $trip['vehicle_id'];
                                $driver_id = $trip['driver_id'];
                            }

                            $gentime1 = getdatetimebytimezone(DFLT_TZ, $inss['time'], $curtz);
                            $stsdate2 = $gentime1['datetime'];
                            $insarry = array(
                                "order_id" => $order_id,
                                "shipment_id" => $orddata['shift_id'],
                                "stop_id" => $stop_id,
                                "stop_detail_id" => $stop_detail_id,
                                "stop_type" => $inss['stp_type'],
                                "trip_id" => $orddata['trip_id'],
                                "status_id" => $inss['stsid'],
                                "loc_name" => $response['StatusLocation'],
                                "status" => 1,
                                "reason" => $response['desc'],
                                "vehicle_id" => $veh_id,
                                "driver_id" => $driver_id,
                                "status_code" => $inss['stscode'],
                                "createdon" => $stsdate2
                            );

                            $this->common->insertTableData("tb_stop_status", $insarry);
                        }
                    }
                }
                $resp['user_id'] = $orddata['user_id'];
                $resp['company_code'] = $orddata['company_code'];
                $resp['branch_code'] = $orddata['branch_code'];
            }

            $chqryx = $this->common->gettblrowdata(
                array(
                    "order_id" => $order_id,
                    "shipment_id" => $orddata['shift_id'],
                    "status_id" => $stsid,
                    "status_code" => $stscode,
                    "stop_type" => $ststype
                ),
                "id",
                "tb_stop_status",
                0,
                0
            );

            if (count($chqryx) == 0) {
                $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                $select = "id";
                $table = "tb_shiporder_stops";
                $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => $ststype, "status" => 1);
                $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stopidinfo) > 0) {
                    $stop_id = $stopidinfo['id'];
                }

                $select = "id";
                $table = "tb_employee";
                $where = array("shift_id" => $orddata['shift_id'], "order_id" => $orddata['order_id'], "status" => 1);
                $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stop_detail) > 0) {
                    $stop_detail_id = $stop_detail['id'];
                }

                $select = "vehicle_id,driver_id";
                $table = "tb_trips";
                $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($trip) > 0) {
                    $veh_id = $trip['vehicle_id'];
                    $driver_id = $trip['driver_id'];
                }

                $insarry = array(
                    "order_id" => $order_id,
                    "shipment_id" => $orddata['shift_id'],
                    "stop_id" => $stop_id,
                    "stop_detail_id" => $stop_detail_id,
                    "stop_type" => $ststype,
                    "trip_id" => $orddata['trip_id'],
                    "status_id" => $stsid,
                    "loc_name" => $response['StatusLocation'],
                    "status" => 1,
                    "reason" => $response['desc'],
                    "vehicle_id" => $veh_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stscode,
                    "createdon" => $stsdate
                );

                $this->common->insertTableData("tb_stop_status", $insarry);
                $resp['user_id'] = $orddata['user_id'];
                $resp['company_code'] = $orddata['company_code'];
                $resp['branch_code'] = $orddata['branch_code'];
            } else {
                $updarr = array("reason" => $response['desc']);
                $updwhr = array("id" => $chqryx['id']);

                $this->common->updatetbledata("tb_stop_status", $updarr, $updwhr);
            }

            if ($orddata['created_source'] != "16") {
                if ($ststype == "D" && ($stscode == "2300" || $stscode == "3000" || $stscode == "DTO")) {
                    $data1 = array();
                    $tdata = array("id" => $orddata['trip_id']);
                    $data1["end_imei"] = "";
                    $data1["end_reading"] = '0';
                    $data1["etime"] = $data1["updated_on"] = $stsdate;
                    $data1["status"] = '0';
                    $data1["transit_status"] = '1';
                    $this->common->updatetbledata(
                        "tb_orders",
                        array("trip_sts" => '1'),
                        array("id" => $order_id, "trip_id <>" => 0)
                    );

                    $this->common->updatetbledata("tb_trips", $data1, $tdata);
                    $this->common->updatetbledata(
                        "tb_orders",
                        array("trip_sts" => '1'),
                        array("id" => $order_id, "shift_id" => $orddata['shift_id'])
                    );
                    $trip_type = 0;
                    $this->generatesummary($orddata['trip_id'], $curtz, $trip_type);
                }
            }
        }

        return $resp;
    }

    public function ecomShipmentTracking(int $weekValue): void
    {
        $referencesAndOrders = [];
        $referencesRtoOrders = $this->Uniqlomodel->getRtoRefIdReferencesValueAndOrdersIdByVendorId(
            self::VENDOR_ECOM_EXPRESS,
            $weekValue
        );
        foreach($referencesRtoOrders as $rtoOrders){
            $referencesAndOrders[] = $rtoOrders;
        }
        $referencesAwbOrders = $this->Uniqlomodel->getReferencesValueAndOrdersIdByVendorId(
                self::VENDOR_ECOM_EXPRESS,
                $weekValue
            );
        foreach($referencesAwbOrders as $soOrders){
            $refAwbExists = array_search($soOrders['ordersId'], array_column($referencesRtoOrders, 'ordersId'));
            if($refAwbExists === false){
                $referencesAndOrders[] = $soOrders;
            }
        }

        $this->scheduledJobService->log("ecomShipmentTracking", "Number of references in ecomShipmentTracking(): " .  count($referencesAndOrders));

        if (empty($referencesAndOrders)) {
            return;
        }

        foreach ($referencesAndOrders as $referenceAndOrder) {
                $refAWBStatus = 0;
                if($referenceAndOrder['refType'] == "REFAWB"){
                    $refAWBStatus = 1;
                }
                $curtz = "Asia/Kolkata";
                $server_url = ECOM_EXP_SHIP_TRACK;
                $username = ECOM_EXP_UNAME;
                $password = ECOM_EXP_PWD;
                $method = 'POST';
                $proxy = defined('VZEN_PROXY') ? VZEN_PROXY : '';
                $headers = array("Content-Type: application/json");
                $request = "username=$username&password=$password&awb=" . $referenceAndOrder['refValue'];
                $edi_request = $request;
                $edi_response = "Status check";
                $edi_id = 9;
                $edi_name = "Ecom Express";
                $status = 0;
                $stsarr = array('user_id' => 244, 'company_code' => 'INKN', 'branch_code' => 'INCL');
                $params = array(
                    'edi_type' => 2, /* 1->EDI Transport Order, 2->EDI Status */
                    'transaction_id' => time(),
                    'edi_id' => $edi_id, /*edi id based on name take it from tb_edi_types*/
                    'edi_name' => $edi_name,
                    'bounded_type' => 1, /* 1->Inbound(partner => kN), 2->Outbound (KN => partner) */
                    'edi_format_type' => 'json',
                    'status' => $status,
                    'obj_type' => 1,
                    'txn_obj_id' => $referenceAndOrder['ordersId'],
                    'user_id' => 244,
                    'company_code' => "INKN",
                    'branch_code' => "INCL",
                    'edi_request' => $edi_request,
                    'edi_response' => $edi_response
                );

                $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

                $requestConfig = [];

                if (ENVIRONMENT !== 'development') {
                    $requestConfig['proxy'] = VZEN_PROXY;
                }

                //switching to curlRequestor()
                //$resp = $edi_response = ecomtrackservicecurl($server_url, $headers, $request, $requestConfig);
                $ecomResponse = curlRequestor(
                    $server_url,
                    $method,
                    $request,
                    $proxy,
                    [],
                    retryDecider(),
                    retryDelay()
                );
                $resp = $edi_response = $ecomResponse['body'];

                if ($ecomResponse['respCode'] !== 200) {
                    log_error(
                        sprintf(
                            '[UNIQLO_TRACKING][%d][%s][ECOM_API_ERROR[%s]]',
                            $weekValue,
                            (new DateTime('now', new DateTimeZone('Europe/Amsterdam')))->format('YmdHis'),
                            (string) $ecomResponse['curlError'],
                        )
                    );
                }

                if (!empty($resp)) {

                    try {
                        $xml = new SimpleXMLElement($resp);
                    } catch (Exception $e) {
                        log_message('error', 'String could not be parsed as XML' . $resp);
                    }

                    $output = $scanoutput = array();

                    if (!empty($xml)) {
                        $ecomsts = isset($xml->object->field) ? $xml->object->field : array();

                        if (!empty($ecomsts)) {
                            foreach ($ecomsts as $es) {
                                $name = (array)$es['name'];
                                $val = (array)$es;
                                unset($val['@attributes']);
                                $val1 = isset($val[0]) ? $val[0] : "";

                                if ($name[0] == "scans") {
                                    $ecomscan = isset($es->object) ? $es->object : array();

                                    if (!empty($ecomscan)) {
                                        $scanoutput = $this->getscandata($ecomscan);
                                    }
                                }

                                if ($val1 != "") {
                                    $output[$name[0]] = $val1;
                                }
                            }
                        }
                    }

                    if (!empty($output)) {
                        $status_datetime = date("Y-m-d H:i:s", strtotime($output['last_update_datetime']));

                        if ($output['status'] != "" && $status_datetime != "") {
                            $curdt = date("Y-m-d H:i:s");
                            $orddata = $this->common->gettblrowdata(
                                array("id" => $referenceAndOrder['ordersId']),
                                "id,order_id,pickup_city,plat,plng,dlat,dlng,user_id,shift_id,trip_id,vendor_id,company_code,branch_code,created_source",
                                "tb_orders",
                                0,
                                0
                            );
                            $order_type = "Pre-paid";

                            if ($orddata['created_source'] == "16") {
                                $order_type = "Pickup";
                            }

                            $output['expected_date'] = date("Y-m-d H:i:s", strtotime($output['expected_date']));

                            if (strpos($output['expected_date'], "1970-01-01") === false) {
                                /* update promise date and no of attempts in order details table */
                                if ($output['expected_date'] != '') {
                                    $setData = ["promise_deliver_date" => $output['expected_date']];
                                    $whereCondition = ["order_row_id" => $referenceAndOrder['ordersId']];
                                    $updatePromiseData = $this->common->updatetbledata("tb_order_details", $setData, $whereCondition);
                                }
                            }

                            $returned_date = $dest_recieve_date = $origin_recieve_date = $out_destination_date = $first_attempt_date = null;
                            $sender_name = "KUEHNE NAGEL UNIQLO";
                            $tresponse = array(
                                'order_id' => $referenceAndOrder['ordersId'],
                                'origin' => $output['origin'],
                                'status_name' => substr($output['status'], 0, 60),
                                'status_location' => $output['current_location_name'],
                                'status_datetime' => $status_datetime,
                                'receivedby' => "",
                                'instructions' => $output['tracking_status'],
                                'status_type' => 'UD',
                                'status_code' => $output['reason_code_number'],
                                'pickup_date' => $output['expected_date'],
                                'charged_weight' => $output['actual_weight'],
                                'order_type' => $order_type,
                                'destination' => $output['destination'],
                                'returned_date' => $returned_date,
                                'dest_recieve_date' => $dest_recieve_date,
                                'origin_recieve_date' => $origin_recieve_date,
                                'out_destination_date' => $out_destination_date,
                                'cod_amount' => 0.00,
                                'first_attempt_date' => $first_attempt_date,
                                'reverse_ntransit' => $output['rts_shipment'],
                                'sender_name' => $sender_name,
                                'dispatch_count' => 0,
                                'invoice_amount' => 0.00,
                                'status' => 1
                            );
                            $chkdata = array(
                                'order_id' => $referenceAndOrder['ordersId'],
                                'status_name' => substr($output['status'], 0, 60),
                                'status_datetime' => $status_datetime,
                                'status_type' => 'UD',
                                'status_code' => $output['reason_code_number'],
                                'order_type' => $order_type
                            );
                            $chk = $this->common->gettblrowdata($chkdata, "id", "tb_uniqlo_order_tracking", 0, 0);

                            if (count($chk) > 0) {
                            /* commenting for now - until changes settle */
                            //    $set = $tresponse;
                            //    $whr = array("id" => $chk['id']);
                            //    $this->common->updatetbledata("tb_uniqlo_order_tracking", $set, $whr);
                            } else {
                                $this->common->insertTableData("tb_uniqlo_order_tracking", $tresponse);
                            }

                            $scandata = array();

                            if (!empty($scanoutput)) {
                                foreach ($scanoutput as $scnrs) {
                                    $scan_datetime = $scan_status_time = date("Y-m-d H:i:s");

                                    if ($scnrs['updated_on'] != "") {
                                        $scan_datetime = $scan_status_time = date(
                                            "Y-m-d H:i:s",
                                            strtotime($scnrs['updated_on'])
                                        );
                                    }

                                    if (strpos($scan_datetime, "1970-01-01") !== false) {
                                        $scan_datetime = $scan_status_time = $status_datetime;
                                    }

                                    $sresponse['order_id'] = $referenceAndOrder['ordersId'];
                                    $sresponse['scan_datetime'] = $scan_datetime;
                                    $sresponse['scan_type'] = 'UD';
                                    $sresponse['scan_val'] = substr($scnrs['status'], 0, 100);
                                    $sresponse['scan_status_time'] = $scan_status_time;
                                    $sresponse['scan_location'] = $scnrs['location_city'];
                                    $sresponse['scan_instruction'] = $scnrs['scan_status'] . " ## " . $scnrs['reason_code'];
                                    $sresponse['scan_status_code'] = $scnrs['reason_code_number'];
                                    $sresponse['call_duration'] = 0;
                                    $sresponse['scan_geo_lat'] = isset($output['lat']) ? $output['lat'] : "";
                                    $sresponse['scan_geo_lng'] = isset($output['long']) ? $output['long'] : "";
                                    $sresponse['status'] = 1;
                                    $scandata[] = $sresponse;
                                    $chkdata = array(
                                        'order_id' => $referenceAndOrder['ordersId'],
                                        'scan_datetime' => $scan_datetime,
                                        'scan_type' => 'UD',
                                        'scan_val' => $sresponse['scan_val'],
                                        'scan_instruction' => $sresponse['scan_instruction'],
                                        'scan_status_code' => $scnrs['reason_code_number']
                                    );
                                    $chk = $this->common->gettblrowdata($chkdata, "id", "tb_uniqlo_order_scans", 0, 0);

                                    if (count($chk) > 0) {
                                        $set = $sresponse;
                                        $whr = array("id" => $chk['id']);

                                        $this->common->updatetbledata("tb_uniqlo_order_scans", $set, $whr);
                                    } else {
                                        $this->common->insertTableData("tb_uniqlo_order_scans", $sresponse);
                                    }
                                }
                            }

                            $deliverstscode = "";
                            $response = array();
                            $gentime1 = getdatetimebytimezone(DFLT_TZ, $status_datetime, $curtz);
                            $stsdate2 = $gentime1['datetime'];
                            $cancelcodes = array(
                                '404',
                                '405',
                                '406',
                                '409',
                                '410',
                                '411',
                                '412',
                                '413',
                                '414',
                                '415',
                                '419',
                                '425',
                                '426',
                                '428',
                                '015',
                                '1330',
                                '326'
                            );
                            $intransitcodes = array(
                                '002',
                                '127',
                                '003',
                                '003',
                                '004',
                                '005',
                                '100',
                                '101',
                                '203',
                                '205',
                                '240',
                                '301',
                                '303',
                                '304',
                                '305',
                                '306',
                                '307',
                                '308',
                                '309',
                                '230',
                                '325',
                                '400',
                                '450',
                                '002',
                                '003',
                                '004',
                                '005',
                                '007',
                                '008',
                                '009',
                                '010',
                                '011',
                                '203',
                                '205',
                                '206',
                                '207',
                                '303',
                                '305',
                                '306',
                                '200',
                                '201',
                                '202',
                                '555'
                            );
                            $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'] . " <br/>";

                            if ($output['reason_code_number'] == '013' || $output['reason_code_number'] == '014') {
                                $response['Status'] = "Manifested";
                                $response['Status_Code'] = '0470';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '1220') {
                                $response['Status'] = "Planned Delivery Date";
                                $response['StatusID'] = 11;
                                $response['Status_Code'] = '2400';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '1230') {
                                $response['Status'] = "Gate In";
                                $response['StatusID'] = 2;
                                $response['Status_Code'] = '0420';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '0011') {
                                $response['Status'] = "Pickup Or Drop";
                                $response['StatusID'] = 1;
                                $response['Status_Code'] = '0500';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif (in_array($output['reason_code_number'], $cancelcodes)) {
                                $response['Status'] = "Cancelled";
                                $response['StatusID'] = 19;
                                $response['Status_Code'] = '3050';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'no';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '004' || $output['reason_code_number'] == '005') {
                                $response['Status'] = "Gate Out";
                                $response['StatusID'] = 3;
                                $response['Status_Code'] = '0191';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif (in_array($output['reason_code_number'], $intransitcodes)) {
                                $response['Status'] = "In-Transit";
                                $response['StatusID'] = 4;
                                $response['Status_Code'] = '1550';
                                $response['Stop_Type'] = 'P';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '777') {
                                $refAwb = $output['ref_awb'];
                                if ($refAwb != '' && $refAwb != 'None') {
                                    $referenceValueData = [
                                        "order_id" => $referenceAndOrder['ordersId'],
                                        "reference_id" => "REFAWB",
                                        "ref_value" => $refAwb
                                    ];
                                    $checkReferenceValueExists = $this->common->gettblrowdata($referenceValueData, "id", "tb_order_references", 0, 0);
                                    if (count($checkReferenceValueExists) == 0) {
                                        $currentDate = date('Y-m-d H:i:s');
                                        $insertReferenceData = [
                                            "order_id" => $referenceAndOrder['ordersId'],
                                            "reference_id" => "REFAWB",
                                            "ref_value" => $refAwb,
                                            "status" => 1,
                                            "createdon" => $currentDate
                                        ];
                                        $insertRefValue = $this->common->insertTableData("tb_order_references", $insertReferenceData);
                                    }
                                }
                                $response['Status'] = "RTO";
                                $response['Status_Code'] = 'RTO';
                                $response['Stop_Type'] = 'D';
                                $sts_type = 'yes';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            } elseif ($output['reason_code_number'] == '999' || $output['reason_code_number'] == '204') {
                                $response['Status'] = "Pickup Or Drop";
                                $response['StatusID'] = 1;
                                $response['Status_Code'] = '2300';
                                $response['Stop_Type'] = 'D';
                                $sts_type = 'yes';
                                $deliverstscode = '2300';
                                $reason = "Time:" . $stsdate2 . ", Location:" . $output['current_location_name'] . ", Desc:" . $output['tracking_status'] . ", " . $output['reason_code_number'];
                            }

                            $lattitude = isset($output['lat']) ? $output['lat'] : "";
                            $longitude = isset($output['long']) ? $output['long'] : "";

                            if ($orddata['trip_id'] == 0) {
                                $tripacc = $this->accepttrip($orddata);
                                $orddata['trip_id'] = $tripacc;
                            }

                            $allscanarr = array();

                            if (!empty($scandata)) {
                                foreach ($scandata as $inss) {
                                    $scanarr = array();

                                    if ($inss['scan_status_code'] == '013' || $inss['scan_status_code'] == '014') {
                                        $scanarr['Status'] = "Manifested";
                                        $scanarr['Status_Code'] = '0470';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '1220') {
                                        $scanarr['Status'] = "Planned Delivery Date";
                                        $scanarr['StatusID'] = 11;
                                        $scanarr['Status_Code'] = '2400';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '1230') {
                                        $scanarr['Status'] = "Gate In";
                                        $scanarr['StatusID'] = 2;
                                        $scanarr['Status_Code'] = '0420';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '1260' || $inss['scan_status_code'] == '0011') {
                                        $scanarr['Status'] = "Pickup Or Drop";
                                        $scanarr['StatusID'] = 1;
                                        $scanarr['Status_Code'] = '0500';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif (in_array($inss['scan_status_code'], $cancelcodes)) {
                                        $scanarr['Status'] = "Cancelled";
                                        $scanarr['StatusID'] = 19;
                                        $scanarr['Status_Code'] = '3050';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'no';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '004' || $inss['scan_status_code'] == '005') {
                                        $scanarr['Status'] = "Gate Out";
                                        $scanarr['StatusID'] = 3;
                                        $scanarr['Status_Code'] = '0191';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif (in_array($inss['scan_status_code'], $intransitcodes)) {
                                        $scanarr['Status'] = "In-Transit";
                                        $scanarr['StatusID'] = 4;
                                        $scanarr['Status_Code'] = '1550';
                                        $scanarr['Stop_Type'] = 'P';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '777') {
                                        $scanarr['Status'] = "RTO";
                                        $scanarr['Status_Code'] = 'RTO';
                                        $scanarr['Stop_Type'] = 'D';
                                        $scanarr['sts_type'] = 'yes';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    } elseif ($inss['scan_status_code'] == '999' || $inss['scan_status_code'] == '204') {
                                        $scanarr['Status'] = "Pickup Or Drop";
                                        $scanarr['StatusID'] = 1;
                                        $scanarr['Status_Code'] = '2300';
                                        $scanarr['Stop_Type'] = 'D';
                                        $scanarr['sts_type'] = 'yes';
                                        $deliverstscode = '2300';
                                        $scanarr['sts_time'] = $inss['scan_status_time'];
                                        $scanarr['scanreason'] = "Time:" . $inss['scan_status_time'] . ", Location:" . $inss['scan_location'] . ", Desc:" . $inss['scan_instruction'];
                                    }

                                    if (!empty($scanarr)) {
                                        $allscanarr[] = $scanarr;
                                    }
                                }
                            }

                            if (!empty($response)) {
                                $whr = array(
                                    "status_name" => $response['Status'],
                                    'company_code' => $orddata['company_code'],
                                    'branch_code' => $orddata['branch_code']
                                );
                                $sts = $this->common->gettblrowdata($whr, "id,status_code", "tb_status_master", 0, 0);

                                if (count($sts) > 0) {
                                    $stscode = $sts['status_code'];
                                    $stsid = $sts['id'];
                                } else {
                                    $stscode = $output['reason_code_number'];
                                    $arr = array(
                                        'status_name' => $response['Status'],
                                        'description' => $response['Status'],
                                        'status_type' => 'yes',
                                        'status_code' => $stscode,
                                        'customer_id' => 0,
                                        'company_code' => $orddata['company_code'],
                                        'branch_code' => $orddata['branch_code'],
                                        'status' => 1,
                                        'createdon' => $curdt
                                    );

                                    $stsid = $this->common->insertTableData("tb_status_master", $arr);
                                }

                                $stsarr['user_id'] = $orddata['user_id'];
                                $stsarr['company_code'] = $orddata['company_code'];
                                $stsarr['branch_code'] = $orddata['branch_code'];
                                $chqryx = $this->common->gettblrowdata(
                                    array(
                                        "order_id" => $referenceAndOrder['ordersId'],
                                        "shipment_id" => $orddata['shift_id'],
                                        "status_id" => $stsid
                                    ),
                                    "id,reason",
                                    "tb_stop_status",
                                    0,
                                    0
                                );

                                if (count($chqryx) == 0) {
                                    $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                                    $select = "id";
                                    $table = "tb_shiporder_stops";
                                    $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => 'P', "status" => 1);
                                    $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                    if (count($stopidinfo) > 0) {
                                        $stop_id = $stopidinfo['id'];
                                    }

                                    $select = "id";
                                    $table = "tb_employee";
                                    $where = array(
                                        "shift_id" => $orddata['shift_id'],
                                        "order_id" => $orddata['order_id'],
                                        "status" => 1
                                    );
                                    $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                    if (count($stop_detail) > 0) {
                                        $stop_detail_id = $stop_detail['id'];
                                    }

                                    $select = "vehicle_id,driver_id";
                                    $table = "tb_trips";
                                    $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                                    $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                    if (count($trip) > 0) {
                                        $veh_id = $trip['vehicle_id'];
                                        $driver_id = $trip['driver_id'];
                                    }

                                    $insarry = array(
                                        "order_id" => $referenceAndOrder['ordersId'],
                                        "shipment_id" => $orddata['shift_id'],
                                        "stop_id" => $stop_id,
                                        "stop_detail_id" => $stop_detail_id,
                                        "stop_type" => $response['Stop_Type'],
                                        "trip_id" => $orddata['trip_id'],
                                        "status_id" => $stsid,
                                        'latitude' => $lattitude,
                                        'longitude' => $longitude,
                                        "status" => 1,
                                        "reason" => $reason,
                                        "vehicle_id" => $veh_id,
                                        "driver_id" => $driver_id,
                                        "status_code" => $stscode,
                                        "createdon" => $stsdate2
                                    );

                                    $this->common->insertTableData("tb_stop_status", $insarry);
                                    $status = 1;
                                } else {
                                    $stsreason = $chqryx['reason'];

                                    if (strpos($stsreason, $reason) === false) {
                                        $stsreason .= $reason;
                                        $updarr = array("reason" => $stsreason);
                                        $updwhr = array("id" => $chqryx['id']);

                                        $this->common->updatetbledata("tb_stop_status", $updarr, $updwhr);
                                    }
                                }
                            } elseif ($reason != "") {
                                $chqryx1 = $this->common->gettbllastrowdata(
                                    array(
                                        "order_id" => $referenceAndOrder['ordersId'],
                                        "shipment_id" => $orddata['shift_id']
                                    ),
                                    "id,reason",
                                    "tb_stop_status",
                                    0,
                                    0
                                );

                                if (count($chqryx1) > 0) {
                                    $existsreason = $chqryx1['reason'];
                                    if (strpos($existsreason, $reason) === false) {
                                        $existsreason .= $reason;
                                        $updset = array("reason" => $existsreason);
                                        $updwhr = array("id" => $chqryx1['id']);

                                        $this->common->updatetbledata("tb_stop_status", $updset, $updwhr);
                                    }
                                }
                            }

                            if (!empty($allscanarr)) {
                                foreach ($allscanarr as $scnar) {
                                    if (isset($scnar['StatusID'])) {
                                        $stsid = $scnar['StatusID'];
                                        $stscode = $scnar['Status_Code'];
                                    } else {
                                        $whr = array(
                                            "status_name" => $scnar['Status'],
                                            'company_code' => $orddata['company_code'],
                                            'branch_code' => $orddata['branch_code']
                                        );
                                        $sts = $this->common->gettblrowdata(
                                            $whr,
                                            "id,status_code",
                                            "tb_status_master",
                                            0,
                                            0
                                        );

                                        if (count($sts) > 0) {
                                            $stscode = $sts['status_code'];
                                            $stsid = $sts['id'];
                                        } else {
                                            $stscode = $scnar['Status_Code'];
                                            $arr = array(
                                                'status_name' => $scnar['Status'],
                                                'description' => $scnar['Status'],
                                                'status_type' => $scnar['sts_type'],
                                                'status_code' => $stscode,
                                                'customer_id' => 0,
                                                'company_code' => $orddata['company_code'],
                                                'branch_code' => $orddata['branch_code'],
                                                'status' => 1,
                                                'createdon' => $curdt
                                            );

                                            $stsid = $this->common->insertTableData("tb_status_master", $arr);
                                        }
                                    }

                                    $chqryx = $this->common->gettblrowdata(
                                        array(
                                            "order_id" => $referenceAndOrder['ordersId'],
                                            "shipment_id" => $orddata['shift_id'],
                                            "status_id" => $stsid
                                        ),
                                        "id",
                                        "tb_stop_status",
                                        0,
                                        0
                                    );

                                    if (count($chqryx) == 0) {
                                        $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                                        $select = "id";
                                        $table = "tb_shiporder_stops";
                                        $where = array(
                                            "shipment_id" => $orddata['shift_id'],
                                            'stoptype' => 'P',
                                            "status" => 1
                                        );
                                        $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                        if (count($stopidinfo) > 0) {
                                            $stop_id = $stopidinfo['id'];
                                        }

                                        $select = "id";
                                        $table = "tb_employee";
                                        $where = array(
                                            "shift_id" => $orddata['shift_id'],
                                            "order_id" => $orddata['order_id'],
                                            "status" => 1
                                        );
                                        $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                        if (count($stop_detail) > 0) {
                                            $stop_detail_id = $stop_detail['id'];
                                        }

                                        $select = "vehicle_id,driver_id";
                                        $table = "tb_trips";
                                        $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                                        $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                                        if (count($trip) > 0) {
                                            $veh_id = $trip['vehicle_id'];
                                            $driver_id = $trip['driver_id'];
                                        }

                                        $scnar['sts_time'] = date('Y-m-d H:i:s', strtotime($scnar['sts_time']));
                                        $gentime1 = getdatetimebytimezone(DFLT_TZ, $scnar['sts_time'], $curtz);
                                        $stsdate2 = $gentime1['datetime'];
                                        $insarry = array(
                                            "order_id" => $referenceAndOrder['ordersId'],
                                            "shipment_id" => $orddata['shift_id'],
                                            "stop_id" => $stop_id,
                                            "stop_detail_id" => $stop_detail_id,
                                            "stop_type" => $scnar['Stop_Type'],
                                            "trip_id" => $orddata['trip_id'],
                                            "status_id" => $stsid,
                                            'latitude' => $lattitude,
                                            'longitude' => $longitude,
                                            "status" => 1,
                                            "reason" => $scnar['scanreason'],
                                            "vehicle_id" => $veh_id,
                                            "driver_id" => $driver_id,
                                            "status_code" => $stscode,
                                            "createdon" => $stsdate2
                                        );

                                        $this->common->insertTableData("tb_stop_status", $insarry);
                                        $status = 1;
                                    }
                                }
                            }

                            if ($orddata['created_source'] != "16" && $deliverstscode === "2300") {
                                    $data1 = array();
                                    $tdata = array("id" => $orddata['trip_id']);
                                    $data1["end_imei"] = "";
                                    $data1["end_reading"] = '0';
                                    $data1["etime"] = $data1["updated_on"] = $stsdate2;
                                    $data1["status"] = '0';
                                    $data1["transit_status"] = '1';
                                    $this->common->updatetbledata(
                                        "tb_orders",
                                        array("trip_sts" => '1'),
                                        array("id" => $referenceAndOrder['ordersId'], "trip_id <>" => 0)
                                    );

                                    $this->common->updatetbledata("tb_trips", $data1, $tdata);
                                    $trip_type = 0;
                                    $this->generatesummary($orddata['trip_id'], $curtz, $trip_type);
                            }
                        } else {
                            log_error(
                                sprintf(
                                    '[UNIQLO_TRACKING][%d][%s][ECOM_API_ERROR[%s]]',
                                    $weekValue,
                                    (new DateTime('now', new DateTimeZone('Europe/Amsterdam')))->format('YmdHis'),
                                    'wrong response',
                                )
                            );
                        }
                    } else {
                        log_error(
                            sprintf(
                                '[UNIQLO_TRACKING][%d][%s][ECOM_API_ERROR[%s]]',
                                $weekValue,
                                (new DateTime('now', new DateTimeZone('Europe/Amsterdam')))->format('YmdHis'),
                                'unformatted response',
                            )
                        );
                    }

                    if (!empty($stsarr)) {
                        $set = array(
                            "status" => $status,
                            "user_id" => $stsarr['user_id'],
                            "company_code" => $stsarr['company_code'],
                            "branch_code" => $stsarr['branch_code'],
                            "edi_response" => $edi_response
                        );
                    } else {
                        $set = array("status" => $status, "edi_response" => $edi_response);
                    }

                    $whr = array("id" => $edilogid);

                    $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
                }
        }
    }

    public function getscandata($scans)
    {
        $scanoutput = array();

        if (!empty($scans)) {
            foreach ($scans as $scn) {
                $scnarr = (array)$scn;
                $scandata = isset($scnarr['field']) ? $scnarr['field'] : array();

                if (!empty($scandata)) {
                    $updated_on = isset($scandata[0]) ? trim($scandata[0]) : "";
                    $updated_on = str_replace(",", "", $updated_on);
                    $status = isset($scandata[1]) ? $scandata[1] : "";
                    $reason_code = isset($scandata[2]) ? $scandata[2] : "";
                    $reason_code_number = isset($scandata[3]) ? $scandata[3] : "";
                    $scan_status = isset($scandata[4]) ? $scandata[4] : "";
                    $location = isset($scandata[5]) ? $scandata[5] : "";
                    $location_city = isset($scandata[6]) ? $scandata[6] : "";
                    $location_type = isset($scandata[7]) ? $scandata[7] : "";
                    $city_name = isset($scandata[8]) ? $scandata[8] : "";
                    $employee = isset($scandata[9]) ? $scandata[9] : "";
                    $scanoutput[] = array(
                        'updated_on' => $updated_on,
                        'status' => $status,
                        'reason_code' => $reason_code,
                        'reason_code_number' => $reason_code_number,
                        'scan_status' => $scan_status,
                        'location' => $location,
                        'location_city' => $location_city,
                        'location_type' => $location_type,
                        'city_name' => $city_name,
                        'employee' => $employee
                    );
                }
            }
        }

        return $scanoutput;
    }

    /**
     * if awb generated, update the accept trip status, here while accept, need to create data in tb_trips table for trip, status in tb_stop_status table
     */
    public function accepttrip($orddata)
    {
        $vehicle_id = $driver_id = 0;
        $imei = "";
        $getvehicleid = $this->common->gettblrowdata(
            array('shft_id' => $orddata['shift_id']),
            "vehicle_id",
            "tb_shft_veh",
            0,
            0
        );

        if (count($getvehicleid) > 0) {
            $vehicle_id = $getvehicleid['vehicle_id'];
        }

        if ($vehicle_id > 0) {
            $getdriverid = $this->common->gettblrowdata(
                array('vehicle_id' => $vehicle_id, 'status' => '1'),
                "driver_id,imei",
                "tbl_assigned_drivers",
                0,
                0
            );

            if (count($getdriverid) > 0) {
                $driver_id = $getdriverid['driver_id'];
                $imei = $getdriverid['imei'];
            }
        }

        $latitude = $longitude = "";

        if ($orddata['plat'] != "" && $orddata['plng'] != "") {
            $latitude = $orddata['plat'];
            $longitude = $orddata['plng'];
        } else {
            $chklatlng = $this->common->gettblrowdata(
                array("user_id" => $orddata['user_id']),
                "latitude,longitude",
                "tb_site_settings",
                0,
                0
            );

            if (count($chklatlng) > 0) {
                $latitude = $chklatlng['latitude'];
                $longitude = $chklatlng['longitude'];
            }
        }
        $curdt = date("Y-m-d H:i:s");
        $curtz = "Asia/Kolkata";
        $gentime = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $stsdate = $gentime['datetime'];
        $triparr = array(
            'shift_id' => $orddata['shift_id'],
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id,
            'stime' => $stsdate,
            'start_imei' => $imei,
            'splace' => "",
            'eplace' => "",
            'start_reading' => 0,
            'end_reading' => 0,
            'created_on' => $stsdate,
            'updated_on' => $curdt,
            'status' => 1,
            'trip_type' => 0,
            'transit_status' => 0,
            'plat' => $latitude,
            'plng' => $longitude
        );

        $trip = $this->common->insertTableData('tb_trips', $triparr);
        $stid = 10;
        $stcode = '0212';
        $insarry = array(
            "order_id" => $orddata['id'],
            "shipment_id" => $orddata['shift_id'],
            "stop_id" => 0,
            "stop_detail_id" => 0,
            "stop_type" => "",
            "trip_id" => $trip,
            "status_id" => $stid,
            "latitude" => $latitude,
            "longitude" => $longitude,
            "status" => 1,
            "reason" => "From Admin",
            "vehicle_id" => $vehicle_id,
            "driver_id" => $driver_id,
            "status_code" => $stcode,
            "createdon" => $stsdate
        );

        $this->db->insert("tb_stop_status", $insarry);
        $set = array("trip_id" => $trip);
        $whr = array("id" => $orddata['id']);

        $this->common->updatetbledata("tb_orders", $set, $whr);

        if ($orddata['created_source'] == "16") {
            $sts = $this->common->gettblrowdata(
                array("status_name" => "Planned Pickup Date", "status_code" => "0106"),
                "id,status_code",
                "tb_status_master",
                0,
                0
            );

            if (count($sts) > 0) {
                $stscode1 = $sts['status_code'];
                $stsid1 = $sts['id'];
            } else {
                $stscode1 = '0106';
                $arr = array(
                    'status_name' => 'Planned Pickup Date',
                    'description' => 'Planned Pickup Date',
                    'status_type' => 'yes',
                    'status_code' => '0106',
                    'customer_id' => 0,
                    'company_code' => $orddata['company_code'],
                    'branch_code' => $orddata['branch_code'],
                    'status' => 1,
                    'createdon' => $curdt
                );

                $stsid1 = $this->common->insertTableData("tb_status_master", $arr);
            }
            $chqryx = $this->common->gettblrowdata(
                array(
                    "order_id" => $orddata['id'],
                    "shipment_id" => $orddata['shift_id'],
                    "status_id" => $stsid1,
                    "status_code" => $stscode1,
                    "stop_type" => 'P'
                ),
                "id",
                "tb_stop_status",
                0,
                0
            );

            if (count($chqryx) == 0) {
                $stop_id = $stop_detail_id = 0;
                $select = "id";
                $table = "tb_shiporder_stops";
                $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => 'P', "status" => 1);
                $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stopidinfo) > 0) {
                    $stop_id = $stopidinfo['id'];
                }

                $select = "id";
                $table = "tb_employee";
                $where = array("shift_id" => $orddata['shift_id'], "order_id" => $orddata['order_id'], "status" => 1);
                $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stop_detail) > 0) {
                    $stop_detail_id = $stop_detail['id'];
                }

                $dt = date("Y-m-d");
                $dt1 = strtotime($dt);
                $dt2 = date("l", $dt1);
                $dt3 = strtolower($dt2);
                $cur = date($stsdate, strtotime('+12 hours'));

                if ($dt3 == "saturday") {
                    if (date('H') >= 18) {
                        $cur = date("Y-m-d" . " 23:59:59", strtotime($cur . '+36 hours'));
                    } elseif (date('H') <= 6) {
                        $cur = date('Y-m-d H:i:s', strtotime($cur . '+12 hours'));
                    } else {
                        $cur = date("Y-m-d H:i:s", strtotime('+12 hours'));
                    }
                } elseif ($dt3 == "sunday") {
                    $cur = date("Y-m-d" . " 23:59:59", strtotime($cur . '+12 hours'));
                }

                $insarry = array(
                    "order_id" => $orddata['id'],
                    "shipment_id" => $orddata['shift_id'],
                    "stop_id" => $stop_id,
                    "stop_detail_id" => $stop_detail_id,
                    "stop_type" => 'P',
                    "trip_id" => $trip,
                    "status_id" => $stsid1,
                    "loc_name" => $orddata['pickup_city'],
                    "status" => 1,
                    "reason" => 'Planned Pickup Date',
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stscode1,
                    "createdon" => $cur
                );

                $this->common->insertTableData("tb_stop_status", $insarry);
            }
        }

        return $trip;
    }


    public function xpBorderTracking(int $weekValue): void
    {
        $referencesAndOrders = $this->Uniqlomodel->getReferencesValueAndOrdersIdByVendorId(
            self::VENDOR_XPRESS_BEES,
            $weekValue
        );

        $this->scheduledJobService->log("xpBorderTracking", "Number of references in xpBorderTracking(): " . count($referencesAndOrders));

        if (empty($referencesAndOrders)) {
            return;
        }

        foreach ($referencesAndOrders as $referenceAndOrder) {
            $server_url = EXP_BEES_SHIP_TRACK;
            $method = 'POST';
            $request = json_encode([
                                'XBkey' => EXP_BEES_XBKEY,
                                'AWBNo' => $referenceAndOrder['refValue']
                                ]);
            $headers = ['Content-Type: application/json'];
            $stsarr = [];
            $edi_response = "Status check";
            $edi_id = 10;
            $edi_name = "ExpressBees";
            $status = 0;
            $params = array(
                'edi_type' => 2, /* 1->EDI Transport Order, 2->EDI Status */
                'transaction_id' => time(),
                'edi_id' => $edi_id, /* edi id based on name take it from tb_edi_types */
                'edi_name' => $edi_name,
                'bounded_type' => 1, /* 1->Inbound(partner => kN), 2->Outbound (KN => partner) */
                'edi_format_type' => 'json',
                'status' => $status,
                'obj_type' => 1,
                'txn_obj_id' => $referenceAndOrder['ordersId'],
                'user_id' => 244,
                'company_code' => "INKN",
                'branch_code' => "INCL",
                'edi_request' => $request,
                'edi_response' => $edi_response
            );

            $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

            $xBeesResponse = curlRequestor(
                $server_url,
                $method,
                $request,
                '',
                $headers,
                retryDecider(),
                retryDelay()
            );
            $resp = $edi_response = $xBeesResponse['body'];

            if ($xBeesResponse['respCode'] === 200) {
                $resp1 = json_decode($resp, true);
                $stsarr = $this->xpordertrackupdate($resp1, $referenceAndOrder['ordersId']);

                if (!empty($stsarr)) {
                    $set = array(
                        "status" => 1,
                        "user_id" => $stsarr['user_id'],
                        "company_code" => $stsarr['company_code'],
                        "branch_code" => $stsarr['branch_code'],
                        "edi_response" => $edi_response
                    );
                } else {
                    $set = array("status" => 0, "edi_response" => $edi_response);
                    log_error(
                        sprintf(
                            '[UNIQLO_TRACKING][%d][%s][XPBORDER_API_ERROR[%s]]',
                            $weekValue,
                            (new DateTime('now', new DateTimeZone('Europe/Amsterdam')))->format('YmdHis'),
                            'wrong response',
                        )
                    );
                }

                $whr = array("id" => $edilogid);
                $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
            } else {
                log_error(
                    sprintf(
                        '[UNIQLO_TRACKING][%d][%s][XPBORDER_API_ERROR[%s]]',
                        $weekValue,
                        (new DateTime('now', new DateTimeZone('Europe/Amsterdam')))->format('YmdHis'),
                        (string) $xBeesResponse['curlError'],
                    )
                );
            }
        }
    }

    /**
     * Expressbees order tracking status update
     */
    public function xpordertrackupdate($stsdata, $order_id)
    {
        $resp = array();
        $trresponse = array();

        if (isset($stsdata['GetBulkShipmentStatus'])) {
            foreach ($stsdata['GetBulkShipmentStatus'] as $res) {
                $ship = $res['ReturnMessage'];

                if ($ship == "Successful") {
                    $ststime = $res['StatusTime'];
                    $ststimes = str_split($ststime, strlen($ststime) / 2);

                    if (!empty($ststimes)) {
                        $ststime = $ststimes[0] . ":" . $ststimes[1];
                    }

                    $trresponse[] = array(
                        'Status' => $res['Status'],
                        'StatusLocation' => $res['CurrentLocation'],
                        'StatusDateTime' => $res['StatusDate'] . " " . $ststime,
                        'Instructions' => $res['TransporterRemark'],
                        'InScanDate' => $res['InScanDate'],
                        'StatusCode' => $res['StatusCode'],
                        'EWBN' => $res['AWBNO'],
                        'CODAmount' => $res['NetPayment'],
                        'OrderType' => $res['OrderType'],
                        'ReceiverName' => $res['ReceiverName'],
                        'ShipmentType' => $res['ShipmentType'],
                        'OrderNo' => $res['OrderNo']
                    );
                }
            }
        }

        if (!empty($trresponse)) {
            foreach ($trresponse as $response) {
                $curdt = date("Y-m-d H:i:s");
                $response['Stop_Type'] = 'P';
                $response['desc'] = "Status: " . $response['Status'] . ", StatusType: " . $response['StatusCode'] . ", Desc:" . $response['Instructions'] . "<br/>";

                if ($response['Status'] == "Data Received") {
                    $response['Status'] = "Manifested";
                    $response['Status_Code'] = '0470';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "Pickup Created") {
                    $response['Status'] = "Accepted by Driver";
                    $response['StatusID'] = 10;
                    $response['Status_Code'] = '0212';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "Out for Pickup") {
                    $response['Status'] = "Gate In";
                    $response['StatusID'] = 2;
                    $response['Status_Code'] = '0420';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "PickDone" || $response['Status'] == "Pickup Not Done") {
                    $response['Status'] = "Planned Delivery Date";
                    $response['StatusID'] = 1;
                    $response['Status_Code'] = '2400';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "Picked") {
                    $response['Status'] = "Pickup Or Drop";
                    $response['StatusID'] = 1;
                    $response['Status_Code'] = '0500';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "InTransit") {
                    $response['Status'] = "In-Transit";
                    $response['StatusID'] = 4;
                    $response['Status_Code'] = '1550';
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "LOST") {
                    $response['Status'] = "LOST";
                    $response['Status_Code'] = '9910';
                    $response['Stop_Type'] = 'D';
                    $sts_type = 'no';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "Delivered" || $response['Status'] == "ReturnDelivered") {
                    $response['Status'] = "Pickup Or Drop";
                    $response['StatusID'] = 1;
                    $response['Status_Code'] = '2300';
                    $response['Stop_Type'] = 'D';
                    $sts_type = 'yes';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "RTO") {
                    $response['Status'] = "RTO";
                    $response['Status_Code'] = 'RTO';
                    $response['Stop_Type'] = 'D';
                    $sts_type = 'no';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } elseif ($response['Status'] == "ReturnUndelivered") {
                    $response['Status'] = "ReturnUndelivered";
                    $response['Status_Code'] = '3050';
                    $response['Stop_Type'] = 'D';
                    $sts_type = 'no';
                    $response['desc'] .= "Time:" . $response['StatusDateTime'] . ", Location:" . $response['StatusLocation'] . ", Desc:" . $response['Instructions'] . " <br/>";
                } else {
                    $response['Status_Code'] = $response['StatusCode'];
                    $response['Stop_Type'] = 'P';
                    $sts_type = 'no';
                }

                if ($response['Status_Code'] == "") {
                    $response['Status_Code'] = $response['StatusCode'];
                }

                $stscode = $response['Status_Code'];

                if ($response['Stop_Type'] == "P" || $response['Stop_Type'] == "D") {
                    $ststype = $response['Stop_Type'];
                } else {
                    $ststype = "P";
                }

                $stsdate1 = $response['StatusDateTime'];
                $seldt = date("Y-m-d H:i:s", strtotime($stsdate1));
                $curtz = "Asia/Kolkata";
                $gentime = getdatetimebytimezone(DFLT_TZ, $seldt, $curtz);
                $stsdate = $gentime['datetime'];
                $orddata = $this->common->gettblrowdata(
                    array("id" => $order_id),
                    "id,order_id,plat,plng,dlat,dlng,user_id,shift_id,trip_id,vendor_id,company_code,branch_code,created_source",
                    "tb_orders",
                    0,
                    0
                );

                if ($orddata['created_source'] == 16) {
                    if ($response['Status'] == "Pickup Created") {
                        $response['Status'] = "Pickup Scheduled";
                        $response['StatusID'] = 11;
                        $response['Status_Code'] = '0420';
                        $response['Stop_Type'] = 'P';
                        $sts_type = 'yes';

                        if (!empty($response['ScanDetail'])) {
                            foreach ($response['ScanDetail'] as $scnrs) {
                                if ($scnrs['Scan'] == "Scheduled") {
                                    $response['desc'] .= "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'] . " <br/>";
                                }
                            }
                        }
                    } elseif ($response['Status'] == "Dispatched") {
                        $response['Status'] = "Gate In";
                        $response['StatusID'] = 2;
                        $response['Status_Code'] = '0191';
                        $response['Stop_Type'] = 'P';
                        $sts_type = 'yes';

                        if (!empty($response['ScanDetail'])) {
                            foreach ($response['ScanDetail'] as $scnrs) {
                                if ($scnrs['Scan'] == "Dispatched" || $scnrs['Scan'] == "Out for pickup") {
                                    $response['desc'] .= "Time:" . $scnrs['StatusDateTime'] . ", Location:" . $scnrs['ScannedLocation'] . ", Desc:" . $scnrs['Instructions'] . " <br/>";
                                }
                            }
                        }
                    }
                }

                if ($orddata['trip_id'] == 0) {
                    $vehicle_id = $driver_id = 0;
                    $imei = "";
                    $getvehicleid = $this->common->gettblrowdata(
                        array('shft_id' => $orddata['shift_id']),
                        "vehicle_id",
                        "tb_shft_veh",
                        0,
                        0
                    );

                    if (count($getvehicleid) > 0) {
                        $vehicle_id = $getvehicleid['vehicle_id'];
                    }

                    if ($vehicle_id > 0) {
                        $getdriverid = $this->common->gettblrowdata(
                            array('vehicle_id' => $vehicle_id, 'status' => '1'),
                            "driver_id,imei",
                            "tbl_assigned_drivers",
                            0,
                            0
                        );

                        if (count($getdriverid) > 0) {
                            $driver_id = $getdriverid['driver_id'];
                            $imei = $getdriverid['imei'];
                        }
                    }

                    $latitude = $longitude = "";

                    if ($orddata['plat'] != "" && $orddata['plng'] != "") {
                        $latitude = $orddata['plat'];
                        $longitude = $orddata['plng'];
                    } else {
                        $chklatlng = $this->common->gettblrowdata(
                            array("user_id" => $orddata['user_id']),
                            "latitude,longitude",
                            "tb_site_settings",
                            0,
                            0
                        );
                        if (count($chklatlng) > 0) {
                            $latitude = $chklatlng['latitude'];
                            $longitude = $chklatlng['longitude'];
                        }
                    }

                    $triparr = array(
                        'shift_id' => $orddata['shift_id'],
                        'vehicle_id' => $vehicle_id,
                        'driver_id' => $driver_id,
                        'stime' => $stsdate,
                        'start_imei' => $imei,
                        'splace' => "",
                        'eplace' => "",
                        'start_reading' => 0,
                        'end_reading' => 0,
                        'created_on' => $stsdate,
                        'updated_on' => $curdt,
                        'status' => 1,
                        'trip_type' => 0,
                        'transit_status' => 0,
                        "plat" => $latitude,
                        "plng" => $longitude
                    );

                    $trip = $this->common->insertTableData('tb_trips', $triparr);
                    $stid = 10;
                    $stcode = '0212';
                    $insarry = array(
                        "order_id" => $orddata['id'],
                        "shipment_id" => $orddata['shift_id'],
                        "stop_id" => 0,
                        "stop_detail_id" => 0,
                        "stop_type" => "",
                        "trip_id" => $trip,
                        "status_id" => $stid,
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "status" => 1,
                        "reason" => "From Admin",
                        "vehicle_id" => $vehicle_id,
                        "driver_id" => $driver_id,
                        "status_code" => $stcode,
                        "createdon" => $stsdate
                    );

                    $ins = $this->db->insert("tb_stop_status", $insarry);
                    $set = array("trip_id" => $trip);
                    $whr = array("id" => $orddata['id']);

                    $this->common->updatetbledata("tb_orders", $set, $whr);

                    if ($orddata['created_source'] == "16") {
                        $sts = $this->common->gettblrowdata(
                            array("status_name" => "Planned Pickup Date", "status_code" => "0106"),
                            "id,status_code",
                            "tb_status_master",
                            0,
                            0
                        );

                        if (count($sts) > 0) {
                            $stscode1 = $sts['status_code'];
                            $stsid1 = $sts['id'];
                        } else {
                            $stscode1 = '0106';
                            $arr = array(
                                'status_name' => 'Planned Pickup Date',
                                'description' => 'Planned Pickup Date',
                                'status_type' => 'yes',
                                'status_code' => '0106',
                                'customer_id' => 0,
                                'company_code' => $orddata['company_code'],
                                'branch_code' => $orddata['branch_code'],
                                'status' => 1,
                                'createdon' => $curdt
                            );

                            $stsid1 = $this->common->insertTableData("tb_status_master", $arr);
                        }

                        $chqryx = $this->common->gettblrowdata(
                            array(
                                "order_id" => $order_id,
                                "shipment_id" => $orddata['shift_id'],
                                "status_id" => $stsid1,
                                "status_code" => $stscode1,
                                "stop_type" => 'P'
                            ),
                            "id",
                            "tb_stop_status",
                            0,
                            0
                        );

                        if (count($chqryx) == 0) {
                            $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                            $select = "id";
                            $table = "tb_shiporder_stops";
                            $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => 'P', "status" => 1);
                            $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($stopidinfo) > 0) {
                                $stop_id = $stopidinfo['id'];
                            }

                            $select = "id";
                            $table = "tb_employee";
                            $where = array(
                                "shift_id" => $orddata['shift_id'],
                                "order_id" => $orddata['order_id'],
                                "status" => 1
                            );
                            $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($stop_detail) > 0) {
                                $stop_detail_id = $stop_detail['id'];
                            }

                            $select = "vehicle_id,driver_id";
                            $table = "tb_trips";
                            $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                            $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                            if (count($trip) > 0) {
                                $veh_id = $trip['vehicle_id'];
                                $driver_id = $trip['driver_id'];
                            }

                            $dt = date("Y-m-d");
                            $dt1 = strtotime($dt);
                            $dt2 = date("l", $dt1);
                            $dt3 = strtolower($dt2);
                            $cur = date("Y-m-d H:i:s", strtotime('+12 hours'));

                            if ($dt3 == "saturday") {
                                if (date('H') >= 18) {
                                    $cur = date("Y-m-d" . " 23:59:59", strtotime($curdt . '+36 hours'));
                                } elseif (date('H') <= 6) {
                                    $cur = date('Y-m-d H:i:s', strtotime($curdt . '+12 hours'));
                                } else {
                                    $cur = date("Y-m-d H:i:s", strtotime('+12 hours'));
                                }
                            } elseif ($dt3 == "sunday") {
                                $cur = date("Y-m-d" . " 23:59:59", strtotime($curdt . '+12 hours'));
                            }

                            $insarry = array(
                                "order_id" => $order_id,
                                "shipment_id" => $orddata['shift_id'],
                                "stop_id" => $stop_id,
                                "stop_detail_id" => $stop_detail_id,
                                "stop_type" => 'P',
                                "trip_id" => $orddata['trip_id'],
                                "status_id" => $stsid1,
                                "loc_name" => $response['StatusLocation'],
                                "status" => 1,
                                "reason" => $response['desc'],
                                "vehicle_id" => $veh_id,
                                "driver_id" => $driver_id,
                                "status_code" => $stscode1,
                                "createdon" => $cur
                            );

                            $this->common->insertTableData("tb_stop_status", $insarry);
                            $resp['user_id'] = $orddata['user_id'];
                            $resp['company_code'] = $orddata['company_code'];
                            $resp['branch_code'] = $orddata['branch_code'];
                        }
                    }
                }

                if ($response['Status'] == "Gate In" && $response['Stop_Type'] == "P") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } elseif ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "P") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } elseif ($response['Status'] == "Gate In" && $response['StatusID'] == "D") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } elseif ($response['Status'] == "Pickup Or Drop" && $response['StatusID'] == "D") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "D") {
                    $stscode = $response['Status_Code'];
                    $stsid = $response['StatusID'];
                } else {
                    $sts = $this->common->gettblrowdata(
                        array("status_name" => $response['Status'], "status_code" => $stscode),
                        "id,status_code",
                        "tb_status_master",
                        0,
                        0
                    );

                    if (count($sts) > 0) {
                        $stscode = $sts['status_code'];
                        $stsid = $sts['id'];
                    } else {
                        $arr = array(
                            'status_name' => $response['Status'],
                            'description' => $response['Status'],
                            'status_type' => $sts_type,
                            'status_code' => $stscode,
                            'customer_id' => 0,
                            'company_code' => $orddata['company_code'],
                            'branch_code' => $orddata['branch_code'],
                            'status' => 1,
                            'createdon' => $curdt
                        );

                        $stsid = $this->common->insertTableData("tb_status_master", $arr);
                    }
                }

                $resp['user_id'] = $orddata['user_id'];
                $resp['company_code'] = $orddata['company_code'];
                $resp['branch_code'] = $orddata['branch_code'];

                if ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                    $chqryx = $this->common->gettblrowdata(
                        array(
                            "order_id" => $order_id,
                            "shipment_id" => $orddata['shift_id'],
                            "status_id" => 1,
                            "status_code" => '0500',
                            "stop_type" => 'P'
                        ),
                        "id",
                        "tb_stop_status",
                        0,
                        0
                    );

                    if (count($chqryx) == 0) {
                        $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                        $select = "id";
                        $table = "tb_shiporder_stops";
                        $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => 'P', "status" => 1);
                        $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                        if (count($stopidinfo) > 0) {
                            $stop_id = $stopidinfo['id'];
                        }

                        $select = "id";
                        $table = "tb_employee";
                        $where = array(
                            "shift_id" => $orddata['shift_id'],
                            "order_id" => $orddata['order_id'],
                            "status" => 1
                        );
                        $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                        if (count($stop_detail) > 0) {
                            $stop_detail_id = $stop_detail['id'];
                        }

                        $select = "vehicle_id,driver_id";
                        $table = "tb_trips";
                        $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                        $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                        if (count($trip) > 0) {
                            $veh_id = $trip['vehicle_id'];
                            $driver_id = $trip['driver_id'];
                        }

                        $insarry = array(
                            "order_id" => $order_id,
                            "shipment_id" => $orddata['shift_id'],
                            "stop_id" => $stop_id,
                            "stop_detail_id" => $stop_detail_id,
                            "stop_type" => 'P',
                            "trip_id" => $orddata['trip_id'],
                            "status_id" => 1,
                            "loc_name" => $response['StatusLocation'],
                            "status" => 1,
                            "reason" => $response['desc'],
                            "vehicle_id" => $veh_id,
                            "driver_id" => $driver_id,
                            "status_code" => '0500',
                            "createdon" => $stsdate
                        );

                        $this->common->insertTableData("tb_stop_status", $insarry);
                        $resp['user_id'] = $orddata['user_id'];
                        $resp['company_code'] = $orddata['company_code'];
                        $resp['branch_code'] = $orddata['branch_code'];
                    }
                }

                $chqryx = $this->common->gettblrowdata(
                    array(
                        "order_id" => $order_id,
                        "shipment_id" => $orddata['shift_id'],
                        "status_id" => $stsid,
                        "status_code" => $stscode,
                        "stop_type" => $ststype
                    ),
                    "id",
                    "tb_stop_status",
                    0,
                    0
                );

                if (count($chqryx) == 0) {
                    $stop_id = $stop_detail_id = $veh_id = $driver_id = 0;
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => $ststype, "status" => 1);
                    $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                    if (count($stopidinfo) > 0) {
                        $stop_id = $stopidinfo['id'];
                    }

                    $select = "id";
                    $table = "tb_employee";
                    $where = array(
                        "shift_id" => $orddata['shift_id'],
                        "order_id" => $orddata['order_id'],
                        "status" => 1
                    );
                    $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                    if (count($stop_detail) > 0) {
                        $stop_detail_id = $stop_detail['id'];
                    }

                    $select = "vehicle_id,driver_id";
                    $table = "tb_trips";
                    $where = array("shift_id" => $orddata['shift_id'], "status" => 1);
                    $trip = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                    if (count($trip) > 0) {
                        $veh_id = $trip['vehicle_id'];
                        $driver_id = $trip['driver_id'];
                    }

                    $insarry = array(
                        "order_id" => $order_id,
                        "shipment_id" => $orddata['shift_id'],
                        "stop_id" => $stop_id,
                        "stop_detail_id" => $stop_detail_id,
                        "stop_type" => $ststype,
                        "trip_id" => $orddata['trip_id'],
                        "status_id" => $stsid,
                        "loc_name" => $response['StatusLocation'],
                        "status" => 1,
                        "reason" => $response['desc'],
                        "vehicle_id" => $veh_id,
                        "driver_id" => $driver_id,
                        "status_code" => $stscode,
                        "createdon" => $stsdate
                    );

                    $this->common->insertTableData("tb_stop_status", $insarry);
                    $resp['user_id'] = $orddata['user_id'];
                    $resp['company_code'] = $orddata['company_code'];
                    $resp['branch_code'] = $orddata['branch_code'];
                } else {
                    $updarr = array("reason" => $response['desc']);
                    $updwhr = array("id" => $chqryx['id']);

                    $this->common->updatetbledata("tb_stop_status", $updarr, $updwhr);
                }

                if ($orddata['created_source'] != "16") {
                    if ($ststype == "D" && ($stscode == "2300" || $stscode == "3000")) {
                        $data1 = array();
                        $tdata = array("id" => $orddata['trip_id']);
                        $data1["end_imei"] = "";
                        $data1["end_reading"] = '0';
                        $data1["etime"] = $data1["updated_on"] = $stsdate;
                        $data1["status"] = '0';
                        $data1["transit_status"] = '1';
                        $this->common->updatetbledata(
                            "tb_orders",
                            array("trip_sts" => '1'),
                            array("id" => $order_id, "trip_id <>" => 0)
                        );

                        $this->common->updatetbledata("tb_trips", $data1, $tdata);
                        $this->common->updatetbledata(
                            "tb_orders",
                            array("trip_sts" => '1'),
                            array("id" => $order_id, "shift_id" => $orddata['shift_id'])
                        );
                        $trip_type = 0;
                        $this->generatesummary($orddata['trip_id'], $curtz, $trip_type);
                    }
                }
            }
        }

        return $resp;
    }

    /**
     * generate trip summary after trip status closed/delivered
     */
    public function generatesummary($tripid, $curtz, $trip_type)
    {
        if ($tripid != "") {
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }

            if ($trip_type == "") {
                $trip_type = 0;
            }

            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->db->query(
                "SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1"
            );

            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query(
                    "SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=" . $shift . " LIMIT 1"
                );
                $data["trip"] = $sql1->row();
                $emp1 = $this->db->query(
                    "select e.name,convertToClientTZ(te.stime,'" . $curtz . "') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=" . $tripid
                );
                $emp = $this->db->query(
                    "SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid
                );
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $vendor_id = 0;
                $dlat = $dlng = "";
                $trucks_query = $this->common->gettblrowdata(
                    array("id" => $vehicleid),
                    "truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude",
                    "tb_trucks_data",
                    0,
                    0
                );
                $cab_capacity = $truck_weight = $truck_volume = 0;

                if (count($trucks_query) > 0) {
                    $cab_capacity = $trucks_query['truck_capacity'];
                    $reg = $trucks_query['register_number'];
                    $vendor_id = $trucks_query['vendor_id'];
                    $truck_weight = $trucks_query['truck_weight'];
                    $truck_volume = $trucks_query['truck_volume'];
                    $dlat = $trucks_query['latitude'];
                    $dlng = $trucks_query['longitude'];
                }

                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }

                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }

                $whrtrip = array("id" => $tripid);
                $settrip = array("dlat" => $dlat, "dlng" => $dlng);

                $this->db->where($whrtrip)->update("tb_trips", $settrip);
                $vtripinfo = array(
                    "plat" => $sql->row()->plat,
                    "plng" => $sql->row()->plng,
                    "dlat" => $dlat,
                    "dlng" => $dlng
                );
                $data['tripinfo'] = (object)$vtripinfo;

                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }

                $regg = $this->db->query(
                    "select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1"
                );

                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;

                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }

                $sql2 = $this->db->query(
                    "select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc"
                );
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;

                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }

                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }

                $attendemp = 1;
                $totalemp = getempcount($tripid);

                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }

                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);

                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }

                $arr = array(
                    'trip_id' => $tripid,
                    'vehicle_id' => $vehicleid,
                    'driver_id' => $driverid,
                    'vendor_id' => $vendor_id,
                    'trip_distance' => $dist,
                    'no_of_emp' => $totalemp,
                    'attended_emp' => $attendemp,
                    'start_imei' => $imei,
                    'end_imei' => $eimei,
                    'start_time' => $stime,
                    'end_time' => $etime,
                    'user_id' => $uid,
                    'cab_capacity' => $cab_capacity,
                    'trip_status' => 1,
                    'trip_type' => $trip_type,
                    'ship_delay' => $driver_late,
                    'createdon' => $curdt
                );
                $chktrip = $this->common->gettblrowdata(array("trip_id" => $tripid), "id", "tb_trip_summary", 0, 0);

                if (count($chktrip) == 0) {
                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "Uniqlo Cronjob generatesummary inserted data in a tb_trip_summary: " . implode(', ', $arr)
                    );

                    $this->common->insertTableData("tb_trip_summary", $arr);
                }
                $data["trip_id"] = $tripid;

                if ($trip_type != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }

                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $dist;
                $data["stime"] = $stime;
                $data["etime"] = $etime;
                $data["simei"] = $imei;
                $data["eimei"] = $eimei;

                if ($odometer_end == "") {
                    $odometer_end = 0;
                }

                if ($odometer_start == "") {
                    $odometer_start = 0;
                }

                $data["odometer"] = ($odometer_end - $odometer_start);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cab_capacity;
                $data["employees"] = $emp1;
                $data["trip_type"] = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"] = $truck_weight;
                $data["truck_volume"] = $truck_volume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where(
                    "tb_users",
                    array(
                        "id" => $uid,
                        "emailid !=" => ""
                    ),
                    1,
                    0
                );

                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @array(
                        'trip_id' => $tripid,
                        'shift_id' => $shift,
                        'splace' => $data["trip"]->splace,
                        'eplace' => $data["trip"]->eplace,
                        'stime' => $stime,
                        'etime' => $etime,
                        'capacity' => $cab_capacity,
                        'simei' => $data['simei'],
                        'eimei' => $data['eimei'],
                        'totcnt' => $totalemp,
                        'attcnt' => $attendemp,
                        'distance' => $data['distance'],
                        'odometer' => $data['odometer'],
                        'driver_late' => $data['driver_late'],
                        'receivemail' => $receivemail,
                        'receivename' => $receivename,
                        'user_id' => $uid,
                        'createdon' => $curdt
                    );

                    $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);

                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }

                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');

                    if ($trip_type == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }

                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $this->email->send();
                }
            }
        }
    }

    /**
     * Get the return orders from MFT
     */
    public function returngoodsarrival()
    {
        $this->scheduledJobService->startJob();
        $statusmsg = "";
        $sftp_url = SWIFLOG_FTP;
        $username = SWIFLOG_FTP_USER;
        $password = SWIFLOG_FTP_PWD;
        $folder_name = "/pub/outbound/uniqlo/etnreturngoods/";
        $sftp = new SFTP($sftp_url);

        if (!$sftp->login($username, $password)) {
            unset($sftp);
            $this->scheduledJobService->log("returngoodsarrival","Cannot login into SFTP server");

            throw new Exception('Cannot login into your server !');
        }

        $sftp->chdir($folder_name);
        $files_list = $sftp->nlist();

        $this->scheduledJobService->log("returngoodsarrival","Number of files received: ".count($files_list));

        if (!empty($files_list)) {
            foreach ($files_list as $key => $value) {
                if ($value != "." && $value != "..") {
                    $path_info = pathinfo($value);
                    $extesion = $path_info['extension'];

                    if ($extesion == "xml") {
                        $server_file = "/pub/outbound/uniqlo/etnreturngoods/" . $value;
                        $localfile = "./assets/swiftlog/" . $value;

                        if (!file_exists(dirname($localfile))) {
                            mkdir(dirname($localfile), 0700, true);
                        }

                        @file_put_contents($localfile, $sftp->get($server_file));
                        $xml = simplexml_load_file($localfile);
                        $company_code = "INKN";
                        $branch_code = "INCL";
                        $edi_request = $value;
                        $edi_response = "";
                        $params = array(
                            'edi_type' => 1, /* 1->EDI Transport Order, 2->EDI Status */
                            'transaction_id' => time(),
                            'edi_id' => 15, /*edi id based on name take it from tb_edi_types*/
                            'edi_name' => 'Swiftlog ShipmetReady',
                            'bounded_type' => 1, /* 1->Inbound(partner => kN), 2->Outbound (KN => partner) */
                            'edi_format_type' => 'XML',
                            'status' => 0,
                            'obj_type' => 1,
                            'txn_obj_id' => 0,
                            'user_id' => 244,
                            'company_code' => $company_code,
                            'branch_code' => $branch_code,
                            'edi_request' => $edi_request,
                            'edi_response' => $edi_response
                        );

                        $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

                        if (!empty($xml)) {
                            $bkp_file = "/pub/outbound/uniqlo/backups/etnreturngoods/" . $value;
                            $sftp->put($bkp_file, $sftp->get($server_file));
                            $sftp->delete($server_file, false);
                            $file_content = file_get_contents($localfile);
                            $postData = json_decode(json_encode(simplexml_load_string($file_content)), true);

                            if (!empty($postData)) {
                                $response = $this->read_shipmentdata($postData);

                                if (!empty($response)) {
                                    if ($response['order_id'] > 0) {
                                        $whr = array("id" => $edilogid);
                                        $set = array(
                                            "status" => 1,
                                            "txn_obj_id" => $response['order_id'],
                                            "user_id" => $response['user_id'],
                                            'company_code' => $response['company_code'],
                                            'branch_code' => $response['branch_code'],
                                            "edi_response" => "Booking closed successfully"
                                        );

                                        $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);

                                        $statusmsg = "Success";
                                    } else {
                                        $statusmsg = "Order not found";
                                    }
                                } else {
                                    $whr = array("id" => $edilogid);
                                    $set = array("edi_response" => "Received Return Order is not available");

                                    $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
                                    $statusmsg = "Received Return Order is not available";
                                }
                            }
                        } else {
                            $statusmsg = "Failed for unformatted request,Please try again!";
                        }
                        $this->scheduledJobService->log("returngoodsarrival","Order close update: XML file:".$value.", Status:".$statusmsg);
                    }
                }
            }
        }
        unset($sftp);
        $this->scheduledJobService->finishJob(true);
        echo $statusmsg;
    }

    /**
     * Get the parsed return orders data
     */
    public function read_shipmentdata($xml)
    {
        $response = array();
        $order_no = isset($xml['HEADER_SEG']['ORIG_ORD_NUM']) ? $xml['HEADER_SEG']['ORIG_ORD_NUM'] : "";
        $shipment_id = isset($xml['HEADER_SEG']['ORG_SHIP_REF']) ? $xml['HEADER_SEG']['ORG_SHIP_REF'] : "";
        $lines = isset($xml['HEADER_SEG']['LINE_SEG']) ? $xml['HEADER_SEG']['LINE_SEG'] : array();
        $line_seg = array();

        if (!empty($lines)) {
            if (!isset($lines['RMANUM'])) {
                foreach ($lines as $ln) {
                    $line_seg[] = array(
                        'rmanum' => $ln['RMANUM'],
                        'order_no' => $ln['ORIG_ORDNUM'],
                        'paytype' => $ln['ORIG_CARCOD'],
                        'shipment_id' => $ln['ORIG_SHIP_REF'],
                        'line_no' => $ln['LIN_NUM'],
                        'party_num' => $ln['PRTNUM'],
                        'qty' => $ln['IDNQTY'],
                        'retcod' => $ln['RETCOD']
                    );
                }
            } else {
                $line_seg[] = array(
                    'rmanum' => $lines['RMANUM'],
                    'order_no' => $lines['ORIG_ORDNUM'],
                    'paytype' => $lines['ORIG_CARCOD'],
                    'shipment_id' => $lines['ORIG_SHIP_REF'],
                    'line_no' => $lines['LIN_NUM'],
                    'party_num' => $lines['PRTNUM'],
                    'qty' => $lines['IDNQTY'],
                    'retcod' => $lines['RETCOD']
                );
            }
        }

        $curdt = date("Y-m-d H:i:s");
        $curtz = "Asia/Kolkata";
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $uniqloTZDate = $getactual['datetime'];

        if ($order_no != "" && $shipment_id != "") {
            $whr = array("reference_id" => "XSR", "ref_value" => $order_no);
            $refs1 = $this->common->gettblrowdata($whr, "order_id", "tb_order_references", 0, 0);

            if (count($refs1) > 0) {
                $order_id = $refs1['order_id'];
                $chkmuliti = $this->common->gettblrowdata(
                    array("id" => $order_id, "trip_sts" => 0),
                    "id,user_id,shift_id,trip_id,company_code,branch_code",
                    "tb_orders",
                    0,
                    0
                );

                if (count($chkmuliti) > 0) {
                    $shift_id = $chkmuliti['shift_id'];
                    $trip_id = $chkmuliti['trip_id'];
                    $whr = array("id" => $order_id, "shift_id" => $shift_id, "trip_sts" => '0');
                    $checkOrdClose = $this->common->gettblrowdata($whr, "id,order_id", "tb_orders", 0, 0);
                    if (count($checkOrdClose) > 0) {
                        $ordSerialId = $checkOrdClose['order_id'];

                        $updwhr = array("id" => $shift_id);
                        $upddata = array("status" => '0', "updated_on" => $curdt);

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "Uniqlo Cronjob read_shipmentdata - updated data in a tb_shifts: " . implode(', ', $upddata)
                        );

                        $this->common->updatetbledata("tb_shifts", $upddata, $updwhr);
                        $data1 = array();
                        $tdata = array("id" => $trip_id);
                        $data1["end_imei"] = "";
                        $data1["end_reading"] = '0';
                        $data1["etime"] = $data1["updated_on"] = $curdt;
                        $data1["status"] = '0';
                        $data1["transit_status"] = '1';

                        log_error(
                            UNIQLO_LOG_PREFIX .
                            "Uniqlo Cronjob read_shipmentdata - updated data in a tb_trips: " . implode(', ', $data1)
                        );

                        $this->common->updatetbledata("tb_trips", $data1, $tdata);
                        $this->common->updatetbledata(
                            "tb_orders",
                            array("trip_sts" => '1'),
                            array("id" => $order_id, "shift_id" => $shift_id)
                        );
                        $trip_type = 1;
                        /* insert status of return order is delivered after goods arrival*/
                        $ordStatusCondChk = ["order_id" => $order_id, "stop_type" => 'D', "status_id" => 1, "status_code" => '2300'];
                        $qryRes = $this->common->gettblrowdata($ordStatusCondChk, "id", "tb_stop_status", 0, 0);
                        if (count($qryRes) == 0) {
                            $stopId = $stopDetailId = 0;
                            $qryGetStopRes = $this->common->gettblrowdata(["order_id" => $ordSerialId], "id,drop_stopid", "tb_employee", 0, 0);
                            if (count($qryGetStopRes) > 0) {
                                $stopId = $qryGetStopRes['drop_stopid'];
                                $stopDetailId = $qryGetStopRes['id'];
                            }
                            $insOrdStatus = ["order_id" => $order_id, "shipment_id" => $shift_id, "stop_id" => $stopId, "stop_detail_id" => $stopDetailId,
                                "stop_type" => 'D', "trip_id" => $trip_id, "status_id" => 1, "status_code" => '2300', "createdon" => $curdt];
                            $insRes = $this->common->insertTableData('tb_stop_status', $insOrdStatus);
                            $inOrdScanInfo = ["order_id" => $order_id, "scan_datetime" => $uniqloTZDate, "scan_type" => 'DL', "scan_val" => 'Delivered', "scan_status_time" => $uniqloTZDate, "scan_instruction" => 'Delivered',
                                "scan_status_code" => '999', "scan_location" => self::UNIQLO_WAREHOUSE_LOCATION, "createdon" => $uniqloTZDate];
                            $insScanRes = $this->common->insertTableData('tb_uniqlo_order_scans', $inOrdScanInfo);
                        }
                        /* Ends insert status of return order is delivered after goods arrival*/
                        $this->generatesummary($trip_id, $curtz, $trip_type);
                    }

                    $response['order_id'] = $order_no;
                    $response['user_id'] = $chkmuliti['user_id'];
                    $response['company_code'] = $chkmuliti['company_code'];
                    $response['branch_code'] = $chkmuliti['branch_code'];
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob read_shipmentdata outbound data: " . implode(', ', $response));

        return $response;
    }

    /**
     * get daily summary report sending to uniqlo customer mails, calling daily 7pm IST
     */
    public function dailyreport()
    {
        $today = date("Y-m-d");
        $whr = "user_id=244 AND DATE(createdon)='" . $today . "'";
        $select = "id,order_id,shift_id,created_source";
        $orddata = $this->common->gettbldata($whr, $select, "tb_orders", 0, 0);
        $forwardordercnt = $returnordercnt = $generalorderscnt = $forwardshiftcnt = $returnshiftcnt = $forwardorderAWBcnt = $returnorderAWBcnt = $returnwaybillsuccesscnt = $returnwaybillsfailcnt = $forwardwaybillsfailcnt = $forwardwaybillsuccesscnt = 0;

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dailyreport - number of tb_orders found: " . count($orddata));

        if (count($orddata) > 0) {
            foreach ($orddata as $ord) {
                $orderid = $ord['id'];
                $shift_id = $ord['shift_id'];
                $created_source = $ord['created_source'];
                $generalorderscnt++;

                if ($created_source == 16) {
                    $returnordercnt++;

                    if ($shift_id != 0) {
                        $returnshiftcnt++;
                    }
                    $returnorderAWB = $this->getdelhiverydocket($orderid);
                    if (($returnorderAWB != $orderid) && $returnorderAWB != "") {
                        $returnorderAWBcnt++;
                    }
                    $returnwaybillsuccess = $this->getwaybillcount($orderid, 1);
                    $returnwaybillsuccesscnt += $returnwaybillsuccess;
                    $returnwaybillsfail = $this->getwaybillcount($orderid, 0);
                    $returnwaybillsfailcnt += $returnwaybillsfail;
                } elseif ($created_source == 15) {
                    $forwardordercnt++;

                    if ($shift_id != 0) {
                        $forwardshiftcnt++;
                    }

                    $forwardorderAWB = $this->getdelhiverydocket($orderid);

                    if (($forwardorderAWB != $orderid) && $forwardorderAWB != "") {
                        $forwardorderAWBcnt++;
                    }

                    $forwardwaybillsuccess = $this->getwaybillcount($orderid, 1);
                    $forwardwaybillsuccesscnt += $forwardwaybillsuccess;
                    $forwardwaybillsfail = $this->getwaybillcount($orderid, 0);
                    $forwardwaybillsfailcnt += $forwardwaybillsfail;
                }
            }

            $data = array(
                "todaydate" => $today,
                "total_orders" => $generalorderscnt,
                "forward_order" => $forwardordercnt,
                "forward_trip" => $forwardshiftcnt,
                "forward_AWB_success" => $forwardorderAWBcnt,
                "forward_AWB_fail" => $forwardwaybillsfailcnt,
                "return_order" => $returnordercnt,
                "return_trip" => $returnshiftcnt,
                "return_AWB_success" => $returnorderAWBcnt,
                "return_AWB_fail" => $returnwaybillsfailcnt,
            );

            if (!empty($data)) {
                $htmldata = $this->load->view('uniqlotransactions/notification', $data, true);
                $this->load->library('notifytrigger');
                $data['username'] = "Hello Team";
                $data['subject'] = "Today Summary Report - " . $today;
                $data['emailid'] = "pawan.batra@kuehne-nagel.com,sunny.sharma@kuehne-nagel.com";
                $data['cc'] = "athmanathan.gnanavel@kuehne-nagel.com, arun.perumalraj@kuehne-nagel.com, kumar.sanjeev@kuehne-nagel.com, Sandeep.Singh@kuehne-nagel.com";
                $message = "Hello Team,<br><br>";
                $message .= "Below are the orders summary for today <br><br>";
                $message .= $htmldata;
                $data['body'] = $message;

                log_error(
                    UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dailyreport - try to send email with data: " . implode(
                        ', ',
                        $data
                    )
                );

                $this->notifytrigger->sendstatusmail($data);
            }
        }
    }

    /**
     * get order reference AWB
     */
    public function getdelhiverydocket($orderid)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getdelhiverydocket inbound data: " . $orderid);

        $resp = "";
        $whr = array("order_id" => $orderid, "reference_id" => "AWB", "status" => 1);
        $select = "ref_value";
        $refs = $this->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);

        if (count($refs) > 0) {
            $resp = $refs['ref_value'];
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getdelhiverydocket outbound data: " . implode(', ', $resp));

        return $resp;
    }

    /**
     * get generated waybill count
     */
    public function getwaybillcount($orderid, $status)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getwaybillcount inbound data: " . $orderid . ' and ' . $status);

        $resp = 0;
        $whr = array("txn_obj_id" => $orderid, "edi_type" => 1, "status" => $status);
        $select = "count(id) as waybillcount";
        $refs = $this->common->gettblrowdata($whr, $select, "tb_etn_edi_transactions", 0, 0);

        if (count($refs) > 0) {
            $resp = $refs['waybillcount'];
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getwaybillcount outbound data: " . implode(', ', $resp));

        return $resp;
    }

    /**
     * get NDR status from Delivery API
     */
    //TODO: created for ruture (info form Ram)
    public function ndrorderstatus($order_id)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob ndrorderstatus inbound data: " . $order_id);

        $status = "failed";
        $whr = array("order_id" => $order_id, "reference_id" => "NDR", "status" => 1);
        $select = "order_id,ref_value";
        $shipdata = $this->common->gettbldata($whr, $select, "tb_order_references", 0, 0);

        if (!empty($shipdata)) {
            foreach ($shipdata as $ord) {
                $whr = " id='" . $ord['order_id'] . "' AND status!=0 AND trip_sts=0 AND shift_id!=0 AND trip_id!=0";
                $select = "id,vendor_id,user_id,company_code,branch_code";
                $orddata = $this->common->gettbldata($whr, $select, "tb_orders", 0, 0);

                if (count($orddata) > 0) {
                    foreach ($orddata as $ord1) {
                        $ndrinfo = array(
                            "order_id" => $ord1['order_id'],
                            "ref_value" => $ord1['ref_value'],
                            'user_id' => $ord1['user_id'],
                            'company_code' => $ord1['company_code'],
                            'branch_code' => $ord1['branch_code']
                        );

                        if ($ord['vendor_id'] == '310') {
                            $sendord = $this->dhndrstatus($ndrinfo);
                        }

                        $status = "success";
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob ndrorderstatus outbound data: " . $status);

        echo $status;
    }

    /**
     * Update NDR status
     */
    public function dhndrstatus($shipdata)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dhndrstatus inbound data: " . $shipdata);

        $whresponse = "no data";

        if (!empty($shipdata)) {
            $order_id = $shipdata['order_id'];
            $api_token = DELHIVERY_AUTH_TOKEN;
            $serverUrl = $edi_request = DELHIVERY_NDR_STATUS . "/" . $shipdata['ref_value'] . "?verbose=true";
            $request = new HTTP_Request2();
            $request->setUrl($serverUrl);
            $request->setMethod(HTTP_Request2::METHOD_GET);
            $config = [
                'follow_redirects' => true,
                'ssl_verify_peer' => false,
                'connect_timeout' => 100,
                'timeout' => 120
            ];

            if (ENVIRONMENT !== "development") {
                $config['proxy'] = PROXY_CONSTANT_HERE;
            }

            $request->setConfig($config);
            $request->setHeader(array(
                                    'Authorization' => "Token " . $api_token,
                                    'Content-Type' => 'application/json'
                                ));
            $status = 0;
            $edi_id = 8;
            $edi_name = 'Delhivery';
            $edi_response = "NDR Status API";
            $stsarr = array('user_id' => 244, 'company_code' => 'INKN', 'branch_code' => 'INCL');
            $params = array(
                'edi_type' => 2, /* 1->EDI Transport Order,2->EDI Status */
                'transaction_id' => time(),
                'edi_id' => $edi_id, /*edi id based on name take it from tb_edi_types*/
                'edi_name' => $edi_name,
                'bounded_type' => 1, /* 1->Inbound(partner => kN),2->Outbound (KN => partner) */
                'edi_format_type' => 'json',
                'status' => $status,
                'obj_type' => 1,
                'txn_obj_id' => $orders[0], //TODo $orders is not defined
                'user_id' => $shipdata['user_id'],
                'company_code' => $shipdata['company_code'],
                'branch_code' => $shipdata['branch_code'],
                'edi_request' => $edi_request,
                'edi_response' => $edi_response
            );

            log_error(
                UNIQLO_LOG_PREFIX .
                "Uniqlo Cronjob dhndrstatus - inserted data in a tb_etn_edi_transactions: " . implode(', ', $params)
            );

            $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

            try {
                log_error(
                    UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob dhndrstatus connecting with API: ' . $serverUrl
                );

                $response = $request->send();
                $resp = $edi_response = $response->getBody();

                log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dhndrstatus - NDR Status resp" . $resp);

                $pinresp = json_decode($resp, true);

                log_error(
                    UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob dhndrstatus API response payload: ' . implode(', ', $pinresp)
                );

                if (!empty($pinresp)) {
                    $curdt = date("Y-m-d H:i:s");

                    if (isset($pinresp['status']) && $pinresp['status'] != '') {
                        if (isset($pinresp['failed_wbns'])) {
                            foreach ($pinresp['failed_wbns'] as $rs) {
                                $waybill = $rs['waybill'];
                                $message = $rs['message'];
                                $action = $rs['action'];
                                $set = array(
                                    "ref_value" => $pinresp['request_id'],
                                    'ref_belongs_to' => $message,
                                    'order_shortNo' => $action
                                );
                                $whr = array("order_id" => $order_id, 'reference_id' => 'NDR');
                                $ins = array(
                                    "order_id" => $order_id,
                                    'reference_id' => 'NDR',
                                    "ref_value" => $pinresp['request_id'],
                                    'ref_belongs_to' => $message,
                                    'order_shortNo' => $action,
                                    "status" => 1,
                                    "createdon" => $curdt
                                );
                                $select = "id";
                                $refqry = $this->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);

                                if (count($refqry) > 0) {
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "Uniqlo Cronjob dhndrstatus - updated data in a tb_order_references: " . implode(
                                            ', ',
                                            $set
                                        )
                                    );

                                    $whr1 = array("id" => $refqry['id']);
                                    $this->common->updatetbledata('tb_order_references', $set, $whr1);
                                } else {
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "Uniqlo Cronjob dhndrstatus - inserted data in a tb_order_references: " . implode(
                                            ', ',
                                            $ins
                                        )
                                    );

                                    $this->common->insertTableData('tb_order_references', $ins);
                                }
                            }
                        }

                        if (isset($pinresp['success_wbns'])) {
                            foreach ($pinresp['success_wbns'] as $rs) {
                                $waybill = $rs['waybill'];
                                $message = $rs['message'];
                                $action = $rs['action'];
                                $set = array(
                                    "ref_value" => $pinresp['request_id'],
                                    'ref_belongs_to' => $message,
                                    'order_shortNo' => $action
                                );
                                $whr = array("order_id" => $order_id, 'reference_id' => 'NDR');
                                $ins = array(
                                    "order_id" => $order_id,
                                    'reference_id' => 'NDR',
                                    "ref_value" => $pinresp['request_id'],
                                    'ref_belongs_to' => $message,
                                    'order_shortNo' => $action,
                                    "status" => 1,
                                    "createdon" => $curdt
                                );
                                $select = "id";
                                $refqry = $this->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);

                                if (count($refqry) > 0) {
                                    $whr1 = array("id" => $refqry['id']);
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "Uniqlo Cronjob dhndrstatus - updated data in a tb_order_references: " . implode(
                                            ', ',
                                            $set
                                        )
                                    );

                                    $srefqryins = $this->common->updatetbledata('tb_order_references', $set, $whr1);
                                } else {
                                    log_error(
                                        UNIQLO_LOG_PREFIX .
                                        "Uniqlo Cronjob dhndrstatus - inserted data in a tb_order_references: " . implode(
                                            ', ',
                                            $ins
                                        )
                                    );

                                    $srefqryins = $this->common->insertTableData('tb_order_references', $ins);
                                }
                            }
                        }

                        $status = 1;
                        $whresponse = "Success";
                    } else {
                        $whresponse = "Failed";
                    }
                } else {
                    $whresponse = 'Unexpected HTTP status: ' . $response->getStatus(
                        ) . ' ' . $response->getReasonPhrase();

                    log_error(UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob dhndrstatus ' . $whresponse);
                }
            } catch (HTTP_Request2_Exception $e) {
                $whresponse = 'Error: ' . $e->getMessage();

                log_error(UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob dhndrstatus ' . $whresponse);
            }

            $set = array("status" => $status, "edi_response" => $edi_response);
            $whr = array("id" => $edilogid);

            log_error(
                UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dhndrstatus - updated data in a tb_etn_edi_transactions: " . implode(
                    ', ',
                    $set
                )
            );

            $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob dhndrstatus outbound data: " . $whresponse);

        return $whresponse;
    }

    /**
     * get NDR status from 3 carriers
     */
    //TODO: created for ruture (info form Ram)
    public function ndrorders()
    {
        $status = "failed";
        $whr = "";
        $curdt = date("Y-m-d");
        $curdt = date('Y-m-d', strtotime('-3 days', strtotime($curdt)));
        $whr .= " o.vendor_id IN(310,311,312) AND o.status!=0 AND o.trip_sts=0 AND o.shift_id=0 AND o.trip_id!=0 AND ";
        $whr .= " s.status!=0 AND s.stop_type='P' AND s.status_id=1 AND (s.createdon)<'" . $curdt . "'";
        $select = "o.id,o.shift_id,o.vendor_id";
        $tbl = "tb_orders o";
        $tbl2 = "tb_stop_status s";
        $whr1 = "o.id=s.order_id";

        //TODO $tbl1 is not defined
        $orddata = $this->common->getjointbldata($tbl, $tbl1, $whr1, $whr, $select, 0, 0);

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob ndrorders - number of tb_orders found: " . count($orddata));

        if (count($orddata) > 0) {
            foreach ($orddata as $ord) {
                if ($ord['vendor_id'] == '310') {
                    $sendord = $this->delhiveryndrorder($ord['shift_id']);
                    log_message("error", UNIQLO_LOG_PREFIX . "DL NDR" . $sendord);
                } elseif ($ord['vendor_id'] == '312') {
                    $sendord = $this->xpbndrorder($ord['shift_id']); //TODO xpbndrorder not found in this file
                    log_message("error", UNIQLO_LOG_PREFIX . "XP NDR" . $sendord);
                } elseif ($ord['vendor_id'] == '311') {
                    $sendord = $this->ecomndrorder($ord['shift_id']); //TODO ecomndrorder not found in this file
                    log_message("error", UNIQLO_LOG_PREFIX . "ECOM NDR" . $sendord);
                }

                $status = "success";
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob ndrorders outbound data: " . $status);

        echo $status;
    }

    /**
     * update NDR status from Delivery API
     */
    public function delhiveryndrorder($shipmentid = null)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob delhiveryndrorder inbound data: " . $shipmentid);

        $whresponse = "no data";
        $ndrtype = 1;
        $shipdata = $this->getdhordinfodata($shipmentid, $ndrtype);

        if (!empty($shipdata)) {
            $orders = $shipdata['order_id'];
            unset($shipdata['order_id']);
            $reqdata = $edi_request = json_encode($shipdata['data']);
            $api_token = DELHIVERY_AUTH_TOKEN;
            $serverUrl = DELHIVERY_NDR;
            $request = new HTTP_Request2();
            $request->setUrl($serverUrl);
            $request->setMethod(HTTP_Request2::METHOD_POST);
            $config = [
                'follow_redirects' => true,
                'ssl_verify_peer' => false,
                'connect_timeout' => 100,
                'timeout' => 120
            ];

            if (ENVIRONMENT !== "development") {
                $config['proxy'] = PROXY_CONSTANT_HERE;
            }

            $request->setConfig($config);
            $request->setHeader(array(
                                    'Authorization' => "Token " . $api_token,
                                    'Content-Type' => 'application/json'
                                ));
            $edi_id = 8;
            $status = 0;
            $edi_name = 'Delhivery';
            $edi_response = "NDR API";
            $stsarr = array('user_id' => 244, 'company_code' => 'INKN', 'branch_code' => 'INCL');
            $params = array(
                'edi_type' => 2, /*'1->EDI Transport Order,2->EDI Status'*/
                'transaction_id' => time(),
                'edi_id' => $edi_id, /*edi id based on name take it from tb_edi_types*/
                'edi_name' => $edi_name,
                'bounded_type' => 1, /*'1->Inbound(partner => kN),2->Outbound (KN => partner)'*/
                'edi_format_type' => 'json',
                'status' => $status,
                'obj_type' => 1,
                'txn_obj_id' => $orders[0],
                'user_id' => 244,
                'company_code' => "INKN",
                'branch_code' => "INCL",
                'edi_request' => $edi_request,
                'edi_response' => $edi_response
            );

            log_error(
                UNIQLO_LOG_PREFIX .
                "Uniqlo Cronjob delhiveryndrorder - inserted data in a tb_order_references: " . implode(', ', $params)
            );

            $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

            log_error(
                UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob delhiveryndrorder connecting with API: ' . $serverUrl . ' with payload ' . $reqdata
            );

            $request->setBody($reqdata);

            try {
                $response = $request->send();
                $resp = $response->getBody();
                $pinresp = $edi_response = json_decode($resp, true);

                log_error(
                    UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob delhiveryndrorder API response payload: ' . implode(
                        ', ',
                        $pinresp
                    )
                );


                if (!empty($pinresp)) {
                    $curdt = date("Y-m-d H:i:s");

                    if (isset($pinresp['request_id']) && $pinresp['request_id'] != '') {
                        foreach ($shipdata['order_id'] as $rs) {
                            $set = array("ref_value" => $pinresp['request_id']);
                            $whr = array("order_id" => $rs, 'reference_id' => 'NDR');
                            $ins = array(
                                "order_id" => $rs,
                                'reference_id' => 'NDR',
                                "ref_value" => $pinresp['request_id'],
                                "status" => 1,
                                "createdon" => $curdt
                            );
                            $select = "id";
                            $refqry = $this->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);

                            if (count($refqry) > 0) {
                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "Uniqlo Cronjob delhiveryndrorder - updated data in a tb_order_references: " . implode(
                                        ', ',
                                        $set
                                    )
                                );

                                $whr1 = array("id" => $refqry['id']);
                                $this->common->updatetbledata('tb_order_references', $set, $whr1);
                            } else {
                                log_error(
                                    UNIQLO_LOG_PREFIX .
                                    "Uniqlo Cronjob delhiveryndrorder - inserted data in a tb_order_references: " . implode(
                                        ', ',
                                        $ins
                                    )
                                );

                                $this->common->insertTableData('tb_order_references', $ins);
                            }
                        }

                        $status = 1;
                        $whresponse = "Success";
                    } else {
                        $whresponse = "Failed";
                    }
                } else {
                    $whresponse = 'Unexpected HTTP status: ' . $response->getStatus(
                        ) . ' ' . $response->getReasonPhrase();

                    log_error(UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob delhiveryndrorder ' . $whresponse);
                }

                if (!empty($stsarr)) {
                    $set = array(
                        "status" => $status,
                        "user_id" => $stsarr['user_id'],
                        "company_code" => $stsarr['company_code'],
                        "branch_code" => $stsarr['branch_code'],
                        "edi_response" => $edi_response
                    );
                } else {
                    $set = array("status" => $status, "edi_response" => $edi_response);
                }

                log_error(
                    UNIQLO_LOG_PREFIX .
                    "Uniqlo Cronjob delhiveryndrorder - updated data in a tb_etn_edi_transactions: " . implode(
                        ', ',
                        $set
                    )
                );

                $whr = array("id" => $edilogid);
                $this->common->updatetbledata("tb_etn_edi_transactions", $set, $whr);
            } catch (HTTP_Request2_Exception $e) {
                $whresponse = 'Error: ' . $e->getMessage();

                log_error(UNIQLO_LOG_PREFIX . 'Uniqlo Cronjob delhiveryndrorder ' . $whresponse);
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob delhiveryndrorder outbound data: " . $whresponse);

        return $whresponse;
    }

    /**
     * get NDR data to call Delivery API
     */
    public function getdhordinfodata($shipid, $type)
    {
        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getdhordinfodata inbound data: " . $shipid . ' and ' . $type);

        $request = array();
        $whr = array("shift_id" => $shipid, "trip_sts" => 0, "status <>" => 0);
        $select = "*";
        $orders = $this->common->gettbldata($whr, $select, "tb_orders", 0, 0);

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getdhordinfodata - number of tb_orders found: " . count($orders));

        if (count($orders) > 0) {
            foreach ($orders as $ord) {
                $request['order_id'][] = $ord['id'];
                $request1 = array();
                $waybill = "";
                $whr = array("order_id" => $ord['id'], "reference_id" => "AWB");
                $select = "ref_value";
                $refs = $this->common->gettblrowdata($whr, $select, "tb_order_references", 0, 0);

                if (count($refs) > 0) {
                    $waybill = $refs['ref_value'];
                }

                $consignee_party_type = 3;
                $whr = array(
                    "name" => 'Consignee',
                    "company_code" => $ord['company_code'],
                    "branch_code" => $ord['branch_code'],
                    "status" => 1
                );
                $select = "id";
                $partyqry = $this->common->gettblrowdata($whr, $select, "tbl_party_types", 0, 0);

                if (count($partyqry) > 0) {
                    $consignee_party_type = $partyqry['id'];
                }

                $name = $address = $phone = "";
                $whr = "p.id=c.party_id";
                $whr1 = array("c.order_id" => $ord['id'], "c.party_type" => $consignee_party_type, "c.status" => 1);
                $select = "p.name,p.mobile,p.address";
                $consignee = $this->common->getjointbldata(
                    "tbl_party_master p",
                    "tb_order_parties c",
                    $whr,
                    $whr1,
                    $select,
                    1,
                    0
                );

                if (count($consignee) > 0) {
                    $cons = $consignee[0];
                    $name = $cons['name'];
                    $phone = $cons['mobile'];
                    $address = $cons['address'];
                }

                if ($type == "3") { /* both defered date and edit details*/
                    $request1['waybill'] = $waybill;
                    $request1['act'] = 'DEFER_DLV';
                    $request1['action_data'] = array('deferred_date' => $ord['delivery_datetime']);
                    $request['data'][] = $request1;
                    $request1['waybill'] = $waybill;
                    $request1['act'] = 'EDIT_DETAILS';
                    $request1['action_data'] = array('name' => $name, 'add' => $address, 'phone' => $phone);
                    $request['data'][] = $request1;
                } else {
                    if ($type == "1") { /* only defered date*/
                        $request1['waybill'] = $waybill;
                        $request1['act'] = 'DEFER_DLV';
                        $request1['action_data'] = array('deferred_date' => $ord['delivery_datetime']);
                        $request['data'][] = $request1;
                    }

                    if ($type == "2") { /* only edit details*/
                        $request1['waybill'] = $waybill;
                        $request1['act'] = 'EDIT_DETAILS';
                        $request1['action_data'] = array('name' => $name, 'add' => $address, 'phone' => $phone);
                        $request['data'][] = $request1;
                    }
                }
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "Uniqlo Cronjob getdhordinfodata outbound data: " . implode(', ', $request));

        return $request;
    }

}
