<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once './vendor/pear/http_request2/HTTP/Request2.php';

class Vendoratromgpstrack extends CI_Controller
{
    private $trackType = "gps";
    private $kkTransSuffix = '_176';
    private $kusTransSuffix = '_79';

    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
        $this->load->helper(['log', 'generic']);
    }

    //This updates the location of a truck/trailer
    public function insertvehiclesposition($vendor = 0)
    {
        $currentDate = date("Y-m-d");
        $getTrackingVendors = $this->getTrackingVendors($currentDate);

        if (count($getTrackingVendors) > 0) {
            $atromApiResponse = $this->callAtromByVendorNameAndTask($vendor, 'insert');
            $updatedTrucksData = [];
            $currentdate = date('Y-m-d H:i:s');
            $accuracy = 15.00; // TODO: We are currently not receiving this data from ATROM so it is static for now. Update after ATROM provides this.
            $battery = 50.00; // TODO: We are currently not receiving this data from ATROM so it is static for now. Update after ATROM provides this.

            if (!empty($atromApiResponse)) {
                foreach ($atromApiResponse as $result) {
                    if (!is_array($result)) {
                        $result = [$result];
                    }
                    foreach ($result as $resultValue) {
                        $latitude = round($resultValue['LAT'], 8) ?? 0.00;
                        $longitude = round($resultValue['LON'], 8) ?? 0.00;
                        $dateTime = date('Y-m-d H:i:s', strtotime($resultValue['POINT_DATE'])) ?? $currentdate;
                        $counterKm = $resultValue['COUNTER_KM'] ?? 0;
                        $azimuth = $resultValue['AZIMUTH'] ?? 0;
                        $keyExists = $resultValue['KEY_EXIST'] ?? false;
                        $inOut_1 = $resultValue['INOUT_1'] ?? false;
                        $imei = $resultValue['ID'] ?? 0;
                        $id = ($vendor == 0) ? $imei . $this->kkTransSuffix : $imei . $this->kusTransSuffix;

                        $locationDataArray = [
                            'vehicle_id' => 0,
                            "latitude" => $latitude,
                            "longitude" => $longitude,
                            "timestamp" => $dateTime,
                            "bearing" => is_float($counterKm) ? $counterKm : 0,
                            "battery" => $battery,
                            "accuracy" => $accuracy,
                            "azimuth" => $azimuth,
                            "key_exist" => $keyExists,
                            "inouts" => $inOut_1
                        ];
                        // This block is used only for trucks
                        if ($latitude !== 0 && $longitude !== 0) {
                            $previousLatitude = "";
                            $selectStatement = 'id,truck_number,phone,imei,latitude';
                            $whereStatement = [
                                "imei" => $id,
                                "status" => "Active"
                            ];

                            $getTruck = $this->common->gettblrowdata($whereStatement, $selectStatement, 'tb_trucks_data', 0, 0);
                            if (count($getTruck) > 0) {
                                $previousLatitude = $getTruck['latitude'];
                                $locationDataArray['vehicle_id'] = $getTruck['id'];

                                $updatedTrucksData = [
                                    "latitude" => $latitude,
                                    "longitude" => $longitude,
                                    'receivedon' => $dateTime,
                                    'bearing' => is_float($counterKm) ? $counterKm : 0,
                                    "azimuth" => $azimuth,
                                    "key_exist" => $keyExists,
                                    "inouts" => $inOut_1,
                                    "is_triggered" => 0
                                ];
                                $locationDataArray['mobileimei'] = $id;

                            } else {
                                // This else block is used only for trailers
                                $selectStatement = 'id,truck_number,phone,imei,latitude';
                                $whereStatement = [
                                    "trailer_imei" => $id,
                                    "status" => "Active"
                                ];
                                $getTruck = $this->common->gettblrowdata($whereStatement, $selectStatement, 'tb_trucks_data', 0, 0);
                                if (count($getTruck) > 0) {
                                    $previousLatitude = $getTruck['latitude'];
                                    $locationDataArray['vehicle_id'] = $getTruck['id'];
                                    $updatedTrucksData = [
                                        "trailer_latitude" => $latitude,
                                        "trailer_longitude" => $longitude,
                                        'receivedon' => $dateTime,
                                        'bearing' => is_float($counterKm) ? $counterKm : 0,
                                        "azimuth" => $azimuth,
                                        "key_exist" => $keyExists,
                                        "inouts" => $inOut_1,
                                        "is_triggered" => 0
                                    ];
                                    $locationDataArray['mobileimei'] = $id;
                                }
                            }
                            if ($previousLatitude != $latitude) {
                                $select = 'id,driver_id,start_imei';
                                $getTrip = $this->getTrips([
                                    'vehicle_id' => $locationDataArray['vehicle_id'],
                                    'status' => 1
                                ], $select, 'tb_trips', 0, 0);

                                if (count($getTrip) > 0) {
                                    $getOrders = $this->common->gettblrowdata([
                                        'trip_id' => $getTrip['id'],
                                    ], 'id', 'tb_orders', 0, 0);

                                    if (!empty($getOrders)) {
                                        $locationDataArray['trip_id'] = $getTrip['id'];
                                        $locationDataArray['driver_id'] = $getTrip['driver_id'];
                                        $this->common->insertTableData("tb_rtdrive_locations", $locationDataArray);

                                        if ($locationDataArray['vehicle_id'] != "" && !empty($updatedTrucksData)) {

                                            $vehicleWhereStatement = [
                                                "id" => $locationDataArray['vehicle_id']
                                            ];
                                            $updateTruckData = $this->db->where($vehicleWhereStatement)->update("tb_trucks_data", $updatedTrucksData);
                                            if ($updateTruckData) {
                                                echo $this->generateResponse(200, "OK");
                                            } else {
                                                log_error('ATROM ERROR : database is not updated.');
                                                echo $this->generateResponse(500, "Error");
                                            }
                                        }
                                    } else {
                                        echo $this->generateResponse(400, "No active trip found for this vehicle.");
                                    }
                                } else {
                                    echo $this->generateResponse(400, "No active trip found for this vehicle.");
                                }
                            } else {
                                echo $this->generateResponse(200, "Already Exists");
                            }
                        } else {
                            echo $this->generateResponse(403, "Unauthorized");
                        }
                    }
                }
            } else {
                log_error('ATROM ERROR : ATROM API gave an empty response.');
                echo $this->generateResponse(500, "Error");
            }
        } else {
            echo $this->generateResponse(500, "No data found.");
        }
    }

    public function getTrips($where, $select, $table, $limit, $start)
    {
        $result = array();
        $this->db->select($select);
        $this->db->from($table);
        $this->db->where($where);
        $this->db->order_by('updated_on', 'DESC');
        if($table == 'tb_consolidation_rules'){
            $this->db->order_by('id','DESC');
        }
        $this->db->limit(1);
        $res = $this->db->get();
        if($res){
            if($res->num_rows() > 0){
                $result = $res->row_array();
            }
        }
        return $result;
    }

    //This sets the IMEI
    public function savevehicleslist($vendor = 0)
    {
        $currentDate = date("Y-m-d");
        $createdon = date('Y-m-d H:i:s');
        $getTrackingVendors = $this->getTrackingVendors($currentDate);

        if (count($getTrackingVendors) > 0) {
            $atromApiData = $this->callAtromByVendorNameAndTask($vendor, 'getList');
            if (!empty($atromApiData)) {
                foreach ($atromApiData as $result) {
                    if (!is_array($result)) {
                        $result = [$result];
                    }
                    foreach ($result as $resultValue) {

                        $imeiFinal = ($vendor == 0) ? $resultValue['ID'] . $this->kkTransSuffix : $resultValue['ID'] . $this->kusTransSuffix;
                        $data = [
                            "truck_number" => $resultValue['REG_NO'],
                            "imei" => $imeiFinal,
                            "register_number" => $resultValue['REG_NO'],
                            "user_id" => 7,
                            "track_vendor_id" => 4,
                            "status" => "Active",
                            "gpsstatus" => 1,
                            "createdon" => $createdon
                        ];

                        if (!empty($data)) {
                            $getTruck = $this->common->gettblrowdata(['register_number' => $resultValue['REG_NO'], "status" => "Active"], 'id,truck_number', 'tb_trucks_data', 0, 0);
                            if (count($getTruck) > 0) {
                                if ($getTruck['truck_number'] == "") {
                                    $trucksDataUpdate = ["truck_number" => $resultValue['REG_NO'], "imei" => $imeiFinal, "user_id" => 7, "track_vendor_id" => 4];
                                    $vehicleWhere = ["id" => $getTruck['id']];
                                    $updateStatement = $this->db->where($vehicleWhere)->update("tb_trucks_data", $trucksDataUpdate);
                                    if ($updateStatement) {
                                        echo $this->generateResponse(200, "Updated");
                                    } else {
                                        log_error("ATROM ERROR: Database error, data wasn't updated.");
                                        echo $this->generateResponse(500, "Error");
                                    }
                                } else{
                                    echo $this->generateResponse(200, "Already exists");
                                }
                            } else {
                                $data['createdon'] = date('Y-m-d H:i:s');
                                $data['updatedon'] = date('Y-m-d H:i:s');
                                $trucksDataInsert = $this->common->insertTableData("tb_trucks_data", $data);
                                if ($trucksDataInsert) {
                                    echo $this->generateResponse(200, "OK");
                                } else {
                                    log_error("ATROM ERROR: Database error, data wasn't inserted.");
                                    echo $this->generateResponse(500, "Error");
                                }
                            }
                        }
                    }
                }
            } else {
                log_error("ATROM ERROR: Api didn't respond or response was empty.");
                echo $this->generateResponse(400, "No data found");
            }
        } else {
            log_error("ATROM ERROR: No tracking vendors found.");
            echo $this->generateResponse(500, "Error");
        }
    }

    private function getTrackingVendors(string $currentDate)
    {
        $whereTrackingVendors = ["track_type" => $this->trackType, "vendor_name " => "ATROM", "DATE(key_expire) >=" => $currentDate, "status" => 1];
        $selectTrackingVendors = 'id,authkey,timeinterval,username,password,service_url';
        return $this->common->gettblrowdata($whereTrackingVendors, $selectTrackingVendors, 'tb_tracking_vendors', 0, 0);
    }

    private function callAtromByVendorNameAndTask(int $vendor, string $task)
    {
        if ($vendor == 0) {
            log_message('error', 'Atrom: KKTrans API triggered');
            $post = [
                'login' => ATROM_USERNAME,
                'password' => ATROM_KKTrans_PWD
            ];
            if ($task === 'getList') {
                return $this->getAtromApiData(ATROM_LIST_URL, $post);
            }

            if ($task === 'insert') {
                return $this->getAtromApiData(ATROM_URL, $post);
            }

        }
        if ($vendor == 1) {
            log_message('error', 'Atrom: KUSTrans API triggered');
            $post = [
                'login' => ATROM_USERNAME,
                'password' => ATROM_PWD
            ];
            if ($task === 'getList') {
                return $this->getAtromApiData(ATROM_LIST_URL_V1, $post);
            }

            if ($task === 'insert') {
                return $this->getAtromApiData(ATROM_URL_v1, $post);
            }
        }
    }


    private function getAtromApiData($url, $post)
    {
        $postData = '';
        foreach ($post as $key => $val) {
            $postData .= urlencode($key) . '=' . urlencode($val) . '&';
        }
        $postData = rtrim($postData, '&');

        $request = new HTTP_Request2();
        $requestConfig = getHttpRequestConfig();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig($requestConfig);
        $request->setBody($postData);

        try {
            $response = $request->send();
            $xml = simplexml_load_string($response->getBody());
            $json = json_encode($xml);
            return json_decode($json,TRUE);
        } catch (HTTP_Request2_Exception $e) {
            log_error('ATROM ERROR: ' . $e->getMessage());
            throw new HTTP_Request2_Exception();
        }
    }

    private function generateResponse($statusCode = 400, $message = "Bad Request")
    {
        try {
            return json_encode([
                "status" => $statusCode,
                "data" => $message
            ], JSON_THROW_ON_ERROR);
        } catch (JsonException $e) {
            log_error('JSON ERROR: ' . $e->getMessage());
            throw new JsonException();
        }
    }
}
