<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Vendorprofile extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->library('form_validation');
        $this->load->model("common");
        $this->load->model("vendorprofilemodel");
        if (!checkUrlAccessForUser('VENDORPROFILE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
            $data["page_title"] = $this->lang->line('vendor_profile');
            $data["sub_title"] = $this->lang->line('general_search');
            $post = $whr = $where = [];
            $whr['user_id'] = $this->session->userdata('user_id');
            // common where.
            $whr['company_code'] = $this->session->userdata('company_code');
            if($whr['company_code'] != 'RUKN') {
                $whr['branch_code'] = $this->session->userdata('branch_code');
            }

            $where['status'] = 1;

            if (isset($_POST['searchsubmit']) && $this->input->post('searchsubmit') == "Search") {
                $post =  $this->input->post(NULL,TRUE);
            }

            if (!empty($post)) {
                $where = $this->searchprofile($post);
                if (isset($post['name1']) && $post['name1'] != "") {
                    $name1    = $post['name1'];
                    $whr["name"] = $name1;
                }

                if (isset($post['customer_name']) && $post['customer_name'] != "") {
                    $customer_name    = $post['customer_name'];
                    $whr["name"] = $customer_name;
                }
            }
            $data['vendor_profile_list'] = $this->vendorprofilemodel->getvendorprofiledata($whr, $where);

            $this->newtemplate->dashboard("vendorprofile/index", $data);
    }

    public function searchprofile($post)
    {
        $whr = [];
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['profile_id1']) && $post['profile_id1'] != "") {
            $profile_id1  = $post['profile_id1'];
            $whr["vend_profile_id="] = $profile_id1;
        }

        if (isset($post['profile_id']) && $post['profile_id'] != "") {
            $profile_id  = $post['profile_id'];
            $whr["vend_profile_id="] = $profile_id;
        }

        if (isset($post['status']) && $post['status'] != "") {
            $status  = $post['status'];
            $whr["status="] = $status;
        } else {
            $whr['status='] = 1;
        }

        return $whr;
    }

    public function add() {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $table = 'tb_customers';
        $whr = [
            "user_id" => $user_id
        ];
        $cusname = $this->vendorprofilemodel->selectlist('id,name', $table, $whr,'name');
        $data['cusname'] = $cusname;
        $table1 = 'tb_department_master';
        $whr1 = [
            "company_code" => $company_code,
            "branch_code" => $branch_code
        ];
        $deprt = $this->vendorprofilemodel->selectlist('id,department_name', $table1, $whr1,'department_name');
        $data['depat'] = $deprt;

        $data["page_title"] = $this->lang->line('vendor_profile');
        $data["sub_title"] = $this->lang->line('general_add');

        //$this->newtemplate->dashboard("vendorprofile/add", $data);
        $this->load->view("vendorprofile/add", $data);
    }

    public function update() {
        $post = $this->input->post(NULL,TRUE);
        $id = $post['id'];
        if (!is_numeric($id))
            return json_encode(FALSE);

        $name = ($post['profile_name']) ? ($post['profile_name']) : '';
        $company_code = ($post['company_code']) ? ($post['company_code']) : '';
        $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
        $description = ($post['description']) ? ($post['description']) : '';
        $status = ($post['status']) ? ($post['status']) : '';
        $user_id = $this->session->userdata('user_id');
        $data = [
            'id' => $id, 'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
         'status' => $status
        ];

        $table = 'tb_vendor_profile';
        $whr = [
            'id' => $id,'user_id' => $user_id
        ];

        $result = $this->common->updatetbledata($table, $data, $whr);
        echo json_encode($result);
    }

    public function edit($id) {
        $data["page_title"] = $this->lang->line('vendor_profile');
        $data["sub_title"] = $this->lang->line('cutomer_edit');

        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['vendor_profile'] = $this->vendorprofilemodel->editdata($id,$company_code,$branch_code);
        if ($data['vendor_profile']) {
            //$this->newtemplate->dashboard('vendorprofile/edit', $data);
            $this->load->view("vendorprofile/edit", $data);
        } else {
            //redirect('vendorprofile/add');
            $this->load->view("vendorprofile/add", $data);
        }
    }

    public function view($id) {
        $data["page_title"] = $this->lang->line('vendor_profile');
        $data["sub_title"] = $this->lang->line('view_view');
        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $data['vendor_profile'] = $this->vendorprofilemodel->viewdata($id,$company_code,$branch_code);
        if($data['vendor_profile']){
            //$this->newtemplate->dashboard("vendorprofile/view", $data);
            $this->load->view("vendorprofile/view", $data);
        } else {
            //redirect('vendorprofile/add');
            $this->load->view("vendorprofile/add", $data);
        }
    }

    public function delete($id) {
        if ($id != '' && is_numeric($id)) {
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where(['id' => $id, 'company_code' => $company_code, 'branch_code' => $branch_code]);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_vendor_profile');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save() {
        $post = $this->input->post(NULL,TRUE);
        $name = ($post['profile_name']) ? ($post['profile_name']) : '';
        $company_code = ($post['company_code']) ? ($post['company_code']) : '';
        $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
        $description = ($post['description']) ? ($post['description']) : '';
        $user_id = $this->session->userdata('user_id');

        $vend_profile_id = $this->genvpid();

        $data = [
            'vend_profile_id' => $vend_profile_id, 'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
            'user_id' => $user_id, 'status' => 1
        ];

        $table = 'tb_vendor_profile';
        $vendor_profile_id = $this->common->insertTableData($table, $data);
        $vendor_ids = explode(',',$post['vendor_ids']);
        $updatedata = ['vp_id'=>$vendor_profile_id];
        $result = $this->vendorprofilemodel->updatelistmodule('tb_vendor_profile_list',$updatedata,$vendor_ids);
        echo json_encode($result);
    }

    public function getpartymaster() {
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $where_cond = "";
        
            if ($company_code == "KNAU") {
                $company_code = "AUKN";
            }

        if($company_code == 'RUKN' ||  $company_code == "AUKN") {
            $where_cond = " company_code='$company_code'";
           
        } else {
            $where_cond = " user_id='$user_id'";
        }
        if (isset($_POST)) {
            $result = [];
            
            $chkqry = $this->db->query("SELECT id,name,mobile,code,address,pincode FROM `tb_vendors` where code is not null and code != '' and code!='0' and $where_cond and status=1 group by code ORDER by id desc");
            
            if ($chkqry->num_rows() > 0) {
                foreach ($chkqry->result() as $res) {
                    $check = "<input type='radio' name='listvendor' id='listvendor_" . $res->code . "' class='listvendor' onchange='selectPartyMaster(" . $res->id . ")' value='" . $res->code . "'>";
                    $result[] = ['check' => $check, 'name' => $res->name, 'mobile' => $res->mobile, 'address' => $res->address, "pincode" => $res->pincode];
                }
            }
            echo json_encode($result);
        }
    }

    public function checkvendorname()
    {
        $post = $this->input->post();
        $name = isset($post['name']) ? $post['name'] : "";
        $id = isset($post['id']) ? $post['id'] : "";
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        // $id = $this->uri->segment(3);
        $user_id = $this->session->userdata('user_id');
        $where = [
            'name' => $name,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'user_id' => $user_id,
            'status' => 1
        ];
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, '*', 'tb_vendor_profile', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {
            echo "1";
        }
    }

    public function getvendprofileid()
    {
        $uid = $this->session->userdata('user_id');

        $profile_id1 = isset($_REQUEST["profile_id1"])?$_REQUEST["profile_id1"]:"";

        $profile_id1 = trim($profile_id1);

        $data = [];

        $get_data = $this->db->query("SELECT vend_profile_id FROM tb_vendor_profile  WHERE vend_profile_id like '%$profile_id1%' and user_id='$uid' and status=1");

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->vend_profile_id;

            }

        }

        echo json_encode($data);
    }


    public function savevendor($id = null){
        $post = $this->input->post(NULL,TRUE);
        $vendor_p = [];
        $userid = $this->session->userdata('user_id');
        $vendor_p['profile_id'] = ($post['code'])?$post['code']:'';
        $vendor_p['party_id'] = ($post['party_id'])?$post['party_id']:0;
        if($id == null) {
            if(isset($post['venprid'])) {
                $vendor_p['vp_id'] = $post['venprid'];
            } else {
                $vendor_p['vp_id'] = 0;
            }
            $vendor_p['status'] = 1;
            $vendor_p['createdon'] = date('Y-m-d H:i:s');
            $vendor_p['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_vendor_profile_list',$vendor_p);
        } else {
            $vendor_p['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_vendor_profile_list',$vendor_p,['id'=>$id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showprofilelist()
    {
        $profilelist  = [];
        $ids     = isset($_POST['vendor_ids_list']) ? $_POST['vendor_ids_list'] : "";
        if ($ids != "") {
            $lists = $this->vendorprofilemodel->getprofilelist($ids);
            foreach($lists as $list){
                $party_id = '"'.$list['party_id'].'"';
                $name = '"'.$list['name'].'"';
                $mobile = '"'.$list['mobile'].'"';
                $address = '"'.$list['address'].'"';
                $pincode = '"'.$list['pincode'].'"';
                $code = '"'.$list['code'].'"';
                $list['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvendorEdit(this," . $list['vendor_profile_list_id'] ."," . $list['party_id'] .");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvendorElim(this," . $list['vendor_profile_list_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowVenProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";
                $profilelist[] = $list;
            }
        }
        echo json_encode( $profilelist);
    }

    public function genvpid()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $vend_res = $this->db->query("SELECT vend_profile_id FROM tb_vendor_profile ORDER BY id DESC LIMIT 1");
        if ($vend_res->num_rows() > 0) {
            $get_vend_id = $vend_res->row()->vend_profile_id;
            $get_vend_id_c = strlen($get_vend_id);
            $previous_weeknumber = substr($get_vend_id, 6, 2);
            $get_vend_id1 = substr($get_vend_id, 8);
            $get_vend_id2 = ltrim($get_vend_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_vend_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $vend_id1 = "VN" . $country_code . $year . $week . $id1;
            $chk = $this->db->query("select vend_profile_id FROM tb_vendor_profile WHERE vend_profile_id='" . $vend_id1 . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $vend_id1 = "VN" . $country_code . $year . $week . $ii_d;
            } else {
                $vend_id1 = $vend_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $vend_id1 = "VN" . $country_code . $year . $week . $id1;
        }
        return $vend_id1;
    }

    public function deleteprofiledetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id,profile_id')->get_where('tb_vendor_profile_list', [
                'id' => $id
            ]);
            if ($chk->num_rows() > 0) {
                $row_id = $chk->row()->profile_id;
                $upd = $this->db->where([
                    'id' => $id
                ])->update('tb_vendor_profile_list', [
                    'status' => 0
                ]);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function getprofilelist()
    {
        $profile_list  = [];
        $venprid    = isset($_POST['venprid']) ? $_POST['venprid'] : "";
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if ($venprid != "") {
            $profilelist = $this->vendorprofilemodel->profilelistbyid($venprid, $company_code, $branch_code);
            foreach($profilelist as $profile){
                $party_id = '"'.$profile['party_id'].'"';
                $name = '"'.$profile['name'].'"';
                $mobile = '"'.$profile['mobile'].'"';
                $address = '"'.$profile['address'].'"';
                $pincode = '"'.$profile['pincode'].'"';
                $code = '"'.$profile['code'].'"';
                $profile['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowvendorEdit(this," . $profile['vendor_profile_list_id'] .",".$party_id.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowvendorElim(this," . $profile['vendor_profile_list_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowVenProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";
                $profile_list[] = ['vend_id'=>$profile['vendor_profile_list_id'],'name'=>$profile['name'],'mobile'=>$profile['mobile'],'address'=>$profile['address'],'pincode'=>$profile['pincode'],'action'=>$profile['action']];
            }
        }
        echo json_encode( $profile_list);
    }
         public function getvendorinfo($id) {
        $result = [];
        if ($id > 0) {
            $where = ['id'=>$id];
            $chk_cust = $this->common->gettblrowdata($where, 'id,name,mobile,code,address,pincode', 'tb_vendors', 0, 0);
            if (!empty($chk_cust)) {
                    $result = ['id' => $chk_cust['id'], 'name' => $chk_cust['name'], 'mobile' => $chk_cust['mobile'], 'address' => $chk_cust['address'], "pincode" => $chk_cust['pincode'],'code'=>$chk_cust['code']];
            }
        }
         echo json_encode($result);
    }

}
