<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Visibility extends CI_Controller
{
   public $chinaurl;
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_id')) {
            redirect('login');
        }
        error_reporting(0);
        $this->load->helper("jwt");
        $this->load->model(['shippeomodel', 'common','ShipmentVisibilityModel']);
        $this->load->library(['carriercommonedilib', 'shippeostatusintigration', 'tollcarrieredi','TripCreateFromOrders']);
        if (!checkUrlAccessForUser('VISIBILITY')) {
            redirect("Forbiddenaccess");
        }
        $this->chinaurl = "https://svkonekt.kuehne-nagel.com/";
    }
    public function index()
    {
        $this->shipment();
    }

    public function shipment(): void
    {
        $this->load->library('visibilityservice');

        // only Admin and Users may go forward
        if (in_array((int) $this->session->userdata('user_role_id'), [3,4])) {
            // redirect Carriers and Customers
            redirect('login');
        }

        // setup
        $data['page_title'] = $this->lang->line('shipment_visibility');
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $data['orders'] = [];

        // use service to gather data
        $shiftsData = $this->visibilityservice
            ->getShiftsData($this->session->userdata);

        // return first if array of IDs is empty
        if (empty($shiftIds = array_unique(array_column($shiftsData, 'id')))) {
            $this->settemplate->dashboard("containerVisibility", $data);
            return;
        }

        $data['orders'] = $this->visibilityservice
            ->updateShiftsDataAndStopstatusWithOrderId(
                $this->getAllTripsStopStatus($shiftsData, $shiftIds)
            );

        if ( $this->isCallApiButtonAvailable() ) {
            $data['show_callapi'] = 1;
        }
        $this->settemplate->dashboard("containerVisibility", $data);
    }

    private function isCallApiButtonAvailable(): bool
    {
        return $this->session->userdata('company_code') === "AUKN"
            && empty($this->session->userdata('country_user_ids'));
    }

    /**
     * @deprecated
     * @param int $shiftId
     * @param string $enddate
     * @return string
     */
    public function getShipmentEndtime(int $shiftId, string $enddate): string
    {
        $endDateTime = $enddate;
        $dropdatetimeRes = $this->db->query(
            "SELECT enddate FROM tb_shiporder_stops
                WHERE shipment_id=?
                  AND stoptype=?
                  AND status =?
                ORDER BY id DESC
                LIMIT 1",
            [$shiftId, 'D', 1]
        );
        if ($dropdatetimeRes->num_rows() > 0) {
            $endDateTime = $dropdatetimeRes->row()->enddate;
        }
        return ($endDateTime == "" || $endDateTime == null) ? date("Y-m-d H:i:s") : $endDateTime;
    }

    /**
     *  This method is used to get all stop details from shift id by ajax call
     */
    public function getalltripstopdetailsbyshiftid()
    {
        $post = $this->input->post();
        $shiftId = $post['shiftId'] ?? 0;
        $stopDetails = gettripstopdetails(['id' => $shiftId], $rej = false);
        $data['stopDetails'] = $stopDetails;
        $data['companyCode'] = $this->session->userdata('company_code');
        $data['shiftId'] = $shiftId;
        echo $this->load->view("stopsContainerVisibility", $data, true);
    }

    /**
     *  This method is used to get all stop details from shift ids
     *
     * @param array $shiftDetails
     * @param array $shiftIds
     * @return array
     */
    public function getAllTripsStopStatus(array $shiftDetails, array $shiftIds): array
    {
        $employeeData = $stopIds = $stopsData = [];
        if (empty($shiftIds)) {
            return $shiftDetails;
        }
        $getStopIds = $this->db->query(
            "SELECT id,shipment_id,plat,plng,stoptype,stopstatus
                FROM tb_shiporder_stops
                WHERE shipment_id IN ?
                  AND status =?
                ORDER BY id",
            [$shiftIds, 1]
        );
        foreach ($getStopIds->result_array() as $stops) {
            if ($stops['id'] > 0) {
                $stopsData[$stops['id']] = $stops;
                $stopIds[] = $stops['id'];
            }
        }
        if (empty($stopIds)) {
            return $shiftDetails;
        }
        $getEmployeeIds = $this->db->query(
            "SELECT id,stop_id,drop_stopid
                FROM tb_employee
                WHERE (stop_id IN ? OR drop_stopid IN ?)
                    AND status=?",
            [$stopIds, $stopIds, 1]
        );
        foreach ($getEmployeeIds->result_array() as $eachEmployee) {
            $employeeData[] = $eachEmployee;
        }
        $stopsData = $this->arrangeEmployeeStopsData($employeeData, $stopsData, $stopIds);
        $employeeStopDetails = [];
        foreach ($employeeData as $i => $iValue) {
            $employeeStopDetails[$iValue['stop_id']][] = $employeeData[$i]['id'];
        }
        $stopsData = $this->getEmployeeStopsStatus($employeeStopDetails, $stopIds, $shiftIds, $stopsData);
        foreach ($stopsData as $eachStop) {
            $shipmentId = $eachStop['shipment_id'];
            $shiftDetails[$shipmentId]['stops'][] = $eachStop;
        }
        return $shiftDetails;
    }

    /**
     *  This method is used to get stop status from employee details
     *
     * @param array $employeeStopDetails , array $stopIds, array $shiftIds, array $stopsData
     *    return :array $stopsData
     */
    private function getEmployeeStopsStatus(
        array $employeeStopDetails,
        array $stopIds,
        array $shiftIds,
        array $stopsData
    ): array {
        $dummyStops = $dummyStops1 = $dummyStops2 = [];

        $stopDetailsIds = array_merge(...array_values($employeeStopDetails));
        $query = $this->db->query(
            "SELECT id, shipment_id, stop_id, stop_detail_id, status_id, stop_type
                        FROM tb_stop_status
                        WHERE shipment_id IN ? AND status = ? AND stop_type != '' ORDER BY stop_type DESC",
            [$shiftIds, 1]
        );
        if (!$query) {
            return $stopsData;
        }

        $cacheStopDetailsCompleted = [];
        $cacheStopDetailsPending = [];
        foreach ($query->result_array() as $row) {
            if($row['stop_id'] == 0 || $row['stop_detail_id'] == 0){
                 if($row['stop_type'] == 'P'){
                     $query = $this->db->query(
                         "select s.id as stop_id, e.id as stop_detail_id FROM tb_shiporder_stops s,tb_employee e
                         where s.`shipment_id` = ? and s.stoptype='P' AND s.id = e.stop_id",
                         [$row['shipment_id']]
                     )->row();
                     if (1 === (int)$row['status_id']) {
                         $cacheStopDetailsCompleted[$query->stop_detail_id] [] = [$query->stop_id, $row['stop_type']];
                     } else {
                         $cacheStopDetailsPending [$query->stop_detail_id] [] = [$query->stop_id, $row['stop_type']];
                     }
                 }
                 if($row['stop_type'] == 'D'){
                     $query = $this->db->query(
                         "select s.id as stop_id, e.id as stop_detail_id FROM tb_shiporder_stops s,tb_employee e
                         where s.`shipment_id` = ? and s.stoptype='D' AND s.id = e.drop_stopid",
                         [$row['shipment_id']]
                     )->row();
                     if (1 === (int)$row['status_id']) {
                         $cacheStopDetailsCompleted[$query->stop_detail_id] [] = [$query->stop_id, $row['stop_type']];
                     } else {
                         $cacheStopDetailsPending [$query->stop_detail_id] [] = [$query->stop_id, $row['stop_type']];
                     }
                 }
            }else {
                if (1 === (int)$row['status_id']) {
                    $cacheStopDetailsCompleted[$row['stop_detail_id']] [] = [$row['stop_id'], $row['stop_type']];
                } else {
                    $cacheStopDetailsPending [$row['stop_detail_id']] [] = [$row['stop_id'], $row['stop_type']];
                }
            }
        }
        foreach ($employeeStopDetails as $key => $value) {
            if (empty($value) || !$key) {
                continue;
            }


            $inCacheRows = $cacheStopDetailsCompleted[$value[0]] ?? [];

            if (count($inCacheRows) > 0) {
                if (count($inCacheRows) >= count($value)) {
                    foreach ($inCacheRows as $stop_id) {
                        $eachStopId = $stop_id[0];
                        $eachStopType = $stop_id[0].$stop_id[1];
                        if (!in_array($eachStopType, $dummyStops)) {
                            if($stop_id[1] == 'D'){
                               if(in_array($eachStopId."P", $dummyStops)){
                                   $eachStopId += 1;
                                   $stopsData[$eachStopId]['stopstatus'] = "2";
                               }else
                                   $stopsData[$eachStopId]['stopstatus'] = "2";
                            }else
                                $stopsData[$eachStopId]['stopstatus'] = "2";
                            $dummyStops[] = $eachStopType;
                        }
                    }
                } else {
                    foreach ($inCacheRows as $stop_id) {
                        $eachStopId = $stop_id[0];
                        $eachStopType = $stop_id[0].$stop_id[1];
                        if (!in_array($eachStopType, $dummyStops1)) {
                            if($stop_id[1] == 'D'){
                                if(in_array($eachStopId."P", $dummyStops1)){
                                    $eachStopId += 1;
                                    $stopsData[$eachStopId]['stopstatus'] = "2";
                                }else
                                    $stopsData[$eachStopId]['stopstatus'] = "2";
                            }else
                                $stopsData[$eachStopId]['stopstatus'] = "2";
                            $dummyStops1[] = $eachStopType;
                        }
                    }
                }
            } else {
                $pending = $cacheStopDetailsPending[$value[0]] ?? [];
                foreach ($pending as $stop_id) {
                    $eachStopId = $stop_id[0];
                    $eachStopType = $stop_id[0].$stop_id[1];
                    if (!in_array($eachStopType, $dummyStops2)) {
                        if($stop_id[1] == 'D'){
                            if(in_array($eachStopId."P", $dummyStops2)){
                                $eachStopId += 1;
                                $stopsData[$eachStopId]['stopstatus'] = "1";
                            }else
                                $stopsData[$eachStopId]['stopstatus'] = "1";
                        }else
                            $stopsData[$eachStopId]['stopstatus'] = "1";
                        $dummyStops2[] = $eachStopType;
                    }
                }
            }
        }

        return $stopsData;
    }

    /**
     *  This method is used to set stop type to that particular employee details
     *
     * @param array $employeeData , array $stopsData, array $ordersDate, array $stopIds
     *    return :array $stopsData
     */
    private function arrangeEmployeeStopsData(
        array $employeeData,
        array $stopsData,
        array $stopIds
    ): array {
        foreach ($employeeData as $emp) {
            $stopRowId = $emp['stop_id'];
            if (in_array($stopRowId, $stopIds)) {
                $type[] = "P";
            } else {
                $type[] = "D";
            }
            $type = array_unique($type);
            $stopsData[$stopRowId]["stoptype"] = "";
            if (count($type) == 2) {
                $stopsData[$stopRowId]["stoptype"] = "P/D";
            } elseif (count($type) == 1) {
                $stopsData[$stopRowId]["stoptype"] = $type[0];
            }
        }
        return $stopsData;
    }

    public function checkTrip()
    {
        $post = $this->input->post(null, true);
        if (isset($post["vehicle_id"]) && strlen($post["vehicle_id"]) > 0 && isset($post["shift_id"]) && strlen(
                $post["shift_id"]
            ) > 0) {
            $vehicle_id = $post["vehicle_id"];
            $shift_id = $post["shift_id"];
            if ($vehicle_id != "" && $shift_id != "") {
                $trips = $this->db->query(
                    "SELECT id FROM tb_trips WHERE vehicle_id='$vehicle_id' AND shift_id='$shift_id' AND status = 1"
                );
                if ($trips->num_rows() > 0) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function notify_customer()
    {
        $company_code = $this->session->userdata('company_code');
        $action = $this->input->post('action', true);
        $shift_id = $this->input->post('shift_id', true);
        if ($company_code === "RUKN" && $action === "notify") {
            // For RU
            $this->load->library('Notifycustomer');
            $this->notifycustomer->notify_customer($shift_id);
        }
    }

    public function getPickupAndDrops($stop_id, $shift_id)
    {
        $data["stop_id"] = $stop_id;
        $data["shift_id"] = $shift_id;
        $data["data"] = [];
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $orders = $this->db->query(
            "SELECT
        e.id,
        e.pickup,
        e.plat,
        e.plng,
        e.drop,
        e.dlat,
        e.dlng,
        convertToClientTZ(e.pickup_datetime,'" . $currentTimeZone . "') as pickup_datetime,
        convertToClientTZ(e.drop_datetime,'" . $currentTimeZone . "') as drop_datetime,
        e.name,
        e.phone,
        e.address,
        e.img,
        m.material,
        e.capacity,
        e.shipment_weight,
        e.shipment_volume,
        'P' as ship_type,
        e.order_id,
        (
          SELECT
            count(s.id)
          FROM
            tb_stop_status s
          WHERE
            s.stop_id = e.stop_id
            AND s.status = '1'
        ) as sts
      FROM
        tb_employee e
        LEFT JOIN tb_materials m ON m.id = e.material_id
        INNER JOIN tb_orders o ON o.order_id = e.order_id
      WHERE
      o.shift_id > 0 AND 
        o.status != 0
        AND e.status = '1'
        AND e.shift_id = '$shift_id'
        AND (e.stop_id = '$stop_id')
      UNION
      SELECT
        e.id,
        e.pickup,
        e.plat,
        e.plng,
        e.drop,
        e.dlat,
        e.dlng,
        convertToClientTZ(e.pickup_datetime,'" . $currentTimeZone . "') as pickup_datetime,
        convertToClientTZ(e.drop_datetime,'" . $currentTimeZone . "') as drop_datetime,
        e.name,
        e.phone,
        e.address,
        e.img,
        m.material,
        e.capacity,
        e.shipment_weight,
        e.shipment_volume,
        'D' as ship_type,
        e.order_id,
        (
          SELECT
            count(s.id)
          FROM
            tb_stop_status s
          WHERE
            s.stop_id = e.stop_id
            AND s.status = '1'
        ) as sts
      FROM
        tb_employee e
        LEFT JOIN tb_materials m ON m.id = e.material_id
        INNER JOIN tb_orders o ON o.order_id = e.order_id
      WHERE
        o.shift_id > 0 AND 
        o.status != 0
        AND e.status = '1'
        AND e.shift_id = '$shift_id'
        AND (e.drop_stopid = '$stop_id')
      "
        );

        foreach ($orders->result_array() as $row) {
            $row["statuses"] = $this->getPickupAndDropStatuses($row["id"]);
            if ('Carrier' === $this->session->userdata('business_type')) {
                $orderidVal = $row['order_id'];
                $resultdata = $this->common->gettblrowdata(['order_id' => $orderidVal, 'status !=' => 0],
                                                           'id',
                                                           'tb_orders',
                                                           0,
                                                           0);
                if (count($resultdata) > 0) {
                    $row['orderRow_id'] = $resultdata['id'];
                } else {
                    $row['orderRow_id'] = '';
                }
            }
            $data["data"][] = $row;
        }
        $this->load->view("pickAndDrops", $data);
    }

    public function getPickupAndDropStatuses($pickupDropId)
    {
        $statusesData = [];
        $statuses = $this->db->query(
            "SELECT s.status_id,m.status_name,s.createdon FROM tb_stop_status s LEFT JOIN tb_status_master m ON m.id = s.status_id WHERE s.stop_id='$pickupDropId' ORDER BY s.createdon DESC"
        );
        foreach ($statuses as $row) {
            $statusesData[] = $row;
        }
        return $statusesData;
    }

    public function openAssignVehicle()
    {
        $shift_id = $this->input->post('shift_id', true);
        $carrier_id = $this->input->post('carrier_id', true);
        $company_code = $this->session->userdata('company_code');
        $data["shipment_id"] = $shift_id;
        $userid = $this->session->userdata('user_id');
        $data["carrier_id"] = $carrier_id;
        $data["volume"] = $this->input->post('volume', true);
        $data["vehicle_id"] = $this->input->post('vehicle_id', true);
        $chklegs = $this->db->select("id")->get_where("tb_shifts", array('shift_leg_id' => $shift_id), 1, 0);
        if ($chklegs->num_rows() == 0) {
            $permission = checkuserpermissions();
            if (in_array("carrier", $permission)) {
                if ($company_code === "KNAU") {
                    $data["carriers"] = $this->db->query(
                        "SELECT v.id, v.name,v.code
                        FROM tb_vendors AS v
                        JOIN tbl_party_master AS pm ON (pm.code=v.code AND v.code IS NOT NULL AND pm.company_code=v.company_code)
                        WHERE pm.status = ? AND v.status = ? AND v.company_code in ?
                        GROUP BY v.id
                        ORDER BY v.name ASC ",
                        array(1, 1, array('AUKN', 'KNAU'))
                    );
                } else {
                    $data["carriers"] = $this->db->query(
                        "SELECT v.id, v.name,v.code
                        FROM tb_vendors AS v
                        JOIN tbl_party_master AS pm ON (pm.code=v.code AND v.code IS NOT NULL AND pm.company_code=v.company_code)
                        WHERE pm.status = ? AND v.status = ? AND v.company_code = ?
                        GROUP BY v.id
                        ORDER BY v.name ASC",
                        array(1, 1, $company_code)
                    );
                }
            } else {
                $data["carriers"] = $this->db->query(
                    "SELECT v.id, v.name, v.code
                     FROM tb_vendors AS v
                     JOIN tbl_party_master AS pm ON (pm.code = v.code AND v.code IS NOT NULL AND pm.user_id = v.user_id)
                     WHERE pm.status = ? AND v.status = ? AND v.user_id = ?
                     GROUP BY v.id
                     ORDER BY v.name ASC",
                    array(1, 1, $userid)
                );
            }
           /* $data["carriers"] = $this->db->query(
                        "SELECT v.id, v.name,v.code
                        FROM tb_vendors AS v
                        JOIN tbl_party_master AS pm ON (pm.code=v.code AND v.code IS NOT NULL AND pm.company_code=v.company_code)
                        WHERE pm.status = ? AND v.status = ?
                        GROUP BY v.id
                        ORDER BY v.name ASC",
                        array(1, 1)
                    );*/
            $schedule_date = $this->db->select("*")->get_where("tb_shifts", array("id" => $shift_id), 1, 0);
            $data["schedule_date"] = "";
            if ($schedule_date->num_rows() > 0) {
                $data["schedule_date"] = $schedule_date->row()->schedule_date;
            }
            if ($data["schedule_date"] == "") {
                $data["schedule_date"] = date("Y-m-d H:i:s");
            }
            $data["carrier_instructions"] = $schedule_date->row()->carrier_instructions;
            $data["weight_capacity"] = $schedule_date->row()->weight_capacity;
            $data["volume_capacity"] = $schedule_date->row()->volume_capacity;
            $data["additional_conditions"] = $schedule_date->row()->additional_conditions;
            $data["temperature_regime"] = $schedule_date->row()->temperature_regime;
            $data["time_for_loading_penality_rate"] = $schedule_date->row()->time_for_loading_penality_rate;
            $data['vehicle_type'] = $schedule_date->row()->vehicle_type;
            $category_data = $this->db->select("category,rate")->get_where(
                "tb_shipment_rates",
                array("shift_id" => $shift_id)
            )->row();
            $data["category"] = $category_data->category;
            $data["rate"] = $category_data->rate;
            $getCarrierCode = $this->common->gettblrowdata(['id'=>$carrier_id],'code','tb_vendors',1,1);
            $data["carrier_code"] = $getCarrierCode ? $getCarrierCode['code'] : '';
            $driver = $this->db->query(
                "select
											  driver_id
											from
											  tb_shft_veh v,
											  tbl_assigned_drivers a
											WHERE
											  v.vehicle_id = a.vehicle_id
											  AND v.shft_id = '$shift_id'
											  AND v.status = 1
											  AND a.status = 1
											LIMIT
											  1"
            );
            if ($driver->num_rows() > 0) {
                $data['driver'] = $driver->row()->driver_id;
            }
            $data['rate_categories'] = $this->db->select('id,name')->get_where(
                "tb_shipment_rate_categories",
                array("status" => 1)
            );
            echo $this->load->view("assignVehicleToShipmentStop", $data, true);
        } else {
            echo 1;
        }
    }

    public function getVehciles($value = '')
    {
        $company_code = $this->session->userdata('company_code');
        if (checkAccessConditions('CID_BASED_VEHICLES_DRIVERS', $company_code))
        {
            $user_role_id      = (int) $this->session->userdata('user_role_id');
            if($user_role_id===3) {
                $userId = $this->session->userdata('id');
                $vendor = $this->db->query("SELECT code FROM tb_vendors WHERE id = ? AND status=?",[$userId,1]);
                if($vendor->num_rows() > 0)
                {
                    $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE code = ? AND company_code = ? AND status=?",[$vendor->row()->code, $company_code, 1]);
                }
            }
            else {
                $vendorsList = $this->db->query("SELECT id FROM tb_vendors WHERE company_code = ? AND status=?",[$company_code, 1]);
            }

            if($vendorsList->num_rows() > 0)
            {
                $carrier_ids = array_column($vendorsList->result_array(), 'id');
            }
        }
        elseif ($this->session->userdata('business_type') === "Carrier" && checkAccessConditions(
                'RELATED_2_SG_MY',
                $this->session->userdata(
                    'company_code'
                )
            )) {
            $this->load->model('Vendors');
            $carrier_ids = $this->Vendors->getChildren($this->session->userdata('id'));
        } else {
            $carrier_ids = [ $this->input->post('carrier_id', true) ];
        }

        /*  $data["vehicles"] = $this->db->query("SELECT td.id,td.register_number,(td.length*td.breadth) as size FROM tb_trucks_data td WHERE td.vendor_id='$carrier_id' AND td.status='Active' ORDER BY (td.length*td.breadth) desc")->result_array(); */
        $vehicles = $this->db->query(
            "SELECT td.id,td.register_number,(td.length*td.breadth) as size,tt.trucktype
                FROM tb_trucks_data td , tb_trucktypes tt
                WHERE td.vendor_id IN ? AND td.status='Active' AND tt.id = td.truck_type
                AND vendor_id != 0
                ORDER BY td.register_number",
            [ $carrier_ids ]
        )->result_array();
        /* Commented by dhanu due to there is no limit in both queries with UNION so volume check is not needed */
        /* $data["vehicles"] = $this->db->query("SELECT * from((SELECT td.id,td.register_number,(td.length*td.breadth) as size FROM tb_trucks_data td JOIN tb_vendor_vehicles vv ON vv.vendor_id=$carrier_id WHERE td.user_id=$user_id AND td.id= vehicle_id AND td.register_number NOT LIKE '%DUMMY%' AND (td.length*td.breadth) >= $volume) UNION (SELECT td.id,td.register_number,(td.length*td.breadth) as size FROM tb_trucks_data td JOIN tb_vendor_vehicles vv ON vv.vendor_id=$carrier_id WHERE td.user_id=$user_id AND td.id= vehicle_id AND td.register_number NOT LIKE '%DUMMY%' AND (td.length*td.breadth) < $volume)) T ORDER BY size desc ")->result_array();
          echo $this->db->last_query();
          if(count($data["vehicles"]) == 0){
          $data["vehicles"] = $this->db->query("SELECT td.id,td.register_number,(td.length*td.breadth) as size FROM tb_trucks_data td WHERE td.vendor_id=$carrier_id AND td.register_number NOT LIKE '%DUMMY%' AND (td.length*td.breadth) >= $volume ORDER BY size desc")->result_array();
          } */
        $carrierDetails = $this->common->gettblrowdata(['id' => (int) $this->input->post('carrier_id', true)], "code", "tb_vendors", 0, 0);
        $carrierCode = $carrierDetails ? $carrierDetails['code'] : '';
        echo json_encode([ 'vehicles' => $vehicles, 'carrierCode'=>$carrierCode]);
    }

    public function assignVehicleToShipmentStop($value = '')
    {
        $shipment_id = $this->input->post("shipment_id", true);
        $carrier_id = $this->input->post("carrier_id", true);
        $vehicle_id = $this->input->post("vehicle_id", true);
        $user_id = $this->session->userdata('user_id');
        $schedule_date = $this->input->post('schedule_date', true);

        $input = $this->input->post();
        $assginedDriverId = isset($input['driveridhiden']) ? $input['driveridhiden'] : "";
        $vehicle_type = isset($input['vehicle_typ']) ? $input['vehicle_typ'] : "";
        $driver_idd = isset($input['driver_id']) ? $input['driver_id'] : "";
        $rate_category = isset($input['rate_category']) ? $input['rate_category'] : "";
        $shipment_cost = isset($input['shipment_cost']) ? $input['shipment_cost'] : "0";
        $carrier_instructions = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
        $weight_capacity = isset($input['weight_capacity']) ? $input['weight_capacity'] : "";
        $volume_capacity = isset($input['volume_capacity']) ? $input['volume_capacity'] : "";
        $additional_conditions = isset($input['additional_conditions']) ? $input['additional_conditions'] : "";
        $temperature_regime = isset($input['temperature_regime']) ? $input['temperature_regime'] : "";
        $time_for_loading_penality_rate = isset($input['time_for_loading_penality_rate']) ? $input['time_for_loading_penality_rate'] : "";
        $rate_category = isset($input['rate_category']) ? $input['rate_category'] : "";
        $shipment_cost = isset($input['shipment_cost']) ? $input['shipment_cost'] : "";
        $vehicle_type = $input['vehicle_typeId'] ?? "";
        $triggerToWeChat = 0;
        $curdt = date('Y-m-d H:i:s');
        if ($vehicle_id === "-select-") {
            $chk = $this->db->where(array("shft_id" => $shipment_id, "carrier_id" => $carrier_id, "status" => 1))->get(
                "tb_shft_veh"
            );
            $register_number = $this->db->where("id", $vehicle_id)->get("tb_trucks_data")->row()->register_number;
            if ($chk->num_rows() > 0) {
                $id = $chk->row()->id;
                $upd = $this->db->where(array("shft_id" => $shipment_id, "carrier_id" => $carrier_id))->update(
                    "tb_shft_veh",
                    array("status" => "0", 'updated_on' => $curdt)
                );
                $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                $driver_id = $chkdrivers->row()->driver_id;
                $insvehold = array(
                    "user_id" => $user_id,
                    "shft_id" => $shipment_id,
                    "carrier_id" => $carrier_id,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "register_number" => $register_number,
                    "status" => "1",
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                );
                $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $insvehold);
            } else {
                $upd = $this->db->where(array("shft_id" => $shipment_id))->update(
                    "tb_shft_veh",
                    array(
                        "status" => "0",
                        'updated_on' => $curdt
                    )
                );
                $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                $driver_id = $chkdrivers->row()->driver_id;
                $insvehold = array(
                    "user_id" => $user_id,
                    "shft_id" => $shipment_id,
                    "carrier_id" => $carrier_id,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "register_number" => $register_number,
                    "status" => "1",
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                );
                $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $insvehold);
            }
            echo "2";
        } else {
            if (checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code'))) {
                $bindParams = [];
                $sqlQuery = "SELECT vendor_id from tb_shifts where id = ? LIMIT ?";
                $bindParams[] = $shipment_id;
                $bindParams[] = 1;
                $assignedInfo = $this->common->fetchRecordsByCustomQry($sqlQuery, $bindParams, false);
                if ($assignedInfo && ($assignedInfo['vendor_id'] !==$carrier_id)) {
                    $triggerToWeChat = 1;
                    try {
                        $this->load->library(['Wechat', 'Carrierstandardtripoutbound']);
                        $carrierEDIDetails = $this->common->carrierEDIDetails($assignedInfo['vendor_id']);
                        if (!empty($carrierEDIDetails)) {
                            if ($carrierEDIDetails["editype"] == "P") {
                                if ($carrierEDIDetails["ediservice"] == "Web Services") {
                                    $response = $this->carrierstandardtripoutbound->shipmentdata($shipment_id, "CA");
                                }
                            }
                        }
                    } catch (Exception $ex) {
                        log_message("error", "Some Problem occured!, While Sending Trip Notification XML  " . $shipment_id . " : " . $ex->getMessage());
                    }
                }
            }
            if ($schedule_date != null && strlen($schedule_date) > 0) {
                $schedule_date = date("Y-m-d H:i:s", strtotime($schedule_date));
                $ins = $this->db->where(array("id" => $shipment_id))->update(
                    "tb_shifts",
                    array("schedule_date" => $schedule_date)
                );
            }
            $curdt = date('Y-m-d H:i:s');
            $data_tb_shift = array(
                "schedule_date" => $schedule_date,
                'vendor_id' => $carrier_id,
                'vehicle_type' => $vehicle_type,
                'carrier_instructions' => $carrier_instructions,
                'weight_capacity' => $weight_capacity,
                'volume_capacity' => $volume_capacity,
                'additional_conditions' => $additional_conditions,
                'temperature_regime' => $temperature_regime,
                'time_for_loading_penality_rate' => $time_for_loading_penality_rate,
                'status' => 1
            );
            $upd = $this->db->where(array("id" => $shipment_id))->update("tb_shifts", $data_tb_shift);

            //check rate saved or not
            $chk_rate = $this->db->where(array("shift_id" => $shipment_id, "status" => 1))->get("tb_shipment_rates");

            if ($chk_rate->num_rows() == 0) {
                $this->common->insertTableData(
                    "tb_shipment_rates",
                    array(
                        "shift_id" => $shipment_id,
                        "category" => $rate_category,
                        "rate" => $shipment_cost,
                        "status" => 1,
                        "created_on" => $curdt
                    )
                );
            } else {
                $this->db->where(array("shift_id" => $shipment_id))->update(
                    "tb_shipment_rates",
                    array(
                        "category" => $rate_category,
                        "rate" => $shipment_cost,
                        'updated_on' => $curdt
                    )
                );
            }
            $checkShifts = $this->db->select("id")->get_where(
                "tb_trips",
                array(
                    'shift_id' => $shipment_id,
                ),
                1,
                0
            );
            if ($checkShifts->num_rows() != 0) {
                $whr = ['vehicle_id' => $vehicle_id, 'status' => 1];
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $whr, 1, 0);
                $driver_id = $chkdrivers->row()->driver_id;
                $curtzs = $this->session->userdata("usr_tzone")['timezone'];
                $this->shippeomodel->updateTrip($shipment_id, $vehicle_id, $driver_id, $curdt, $curtzs, $curdt);
            }
            $upd = $this->db->where(array("shift_id" => $shipment_id))->update(
                "tb_orders",
                array("vendor_id" => $carrier_id)
            );
            $chk = $this->db->select('id')->get_where(
                "tb_shft_veh",
                array(
                    "shft_id" => $shipment_id,
                    "carrier_id" => $carrier_id,
                    "status" => 1
                ),
                1,
                0
            );
            if ($chk->num_rows() > 0) {
                $id = $chk->row()->id;
                $upd = $this->db->where(array("shft_id" => $shipment_id, "carrier_id" => $carrier_id))->update(
                    "tb_shft_veh",
                    array("status" => "0", 'updated_on' => $curdt)
                );
                $register_number = $this->db->where("id", $vehicle_id)->get("tb_trucks_data")->row()->register_number;
                $upd = $this->db->where(array("id" => $id))->update(
                    "tb_shft_veh",
                    array(
                        "vehicle_id" => $vehicle_id,
                        "register_number" => $register_number,
                        "status" => "1",
                        'updated_on' => $curdt
                    )
                );
                // if ($this->session->userdata('company_code') == 'PLKN') {
                $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                $driver_id = $chkdrivers->row()->driver_id;
                $insvehold = array(
                    "user_id" => $user_id,
                    "shft_id" => $shipment_id,
                    "carrier_id" => $carrier_id,
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "register_number" => $register_number,
                    "status" => "1",
                    'created_on' => $curdt,
                    'updated_on' => $curdt
                );
                $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $insvehold);
                // }
            } else {
                $chk1 = $this->db->where(array("shft_id" => $shipment_id, "status" => 1))->get("tb_shft_veh");
                if ($chk1->num_rows() > 0) {
                    $id = $chk1->row()->id;
                    $register_number = $this->db->where("id", $vehicle_id)->get("tb_trucks_data")->row(
                    )->register_number;
                    $upd = $this->db->where(array("id" => $id))->update(
                        "tb_shft_veh",
                        array(
                            "vehicle_id" => $vehicle_id,
                            "carrier_id" => $carrier_id,
                            "register_number" => $register_number,
                            "status" => "1",
                            'updated_on' => $curdt
                        )
                    );
                    // if ($this->session->userdata('company_code') == 'PLKN') {
                    $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                    $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                    $driver_id = $chkdrivers->row()->driver_id;
                    $vendorDetailsArray = array(
                        "user_id" => $user_id,
                        "shft_id" => $shipment_id,
                        "carrier_id" => $carrier_id,
                        "vehicle_id" => $vehicle_id,
                        "driver_id" => $driver_id,
                        "register_number" => $register_number,
                        "status" => "1",
                        'created_on' => $curdt,
                        'updated_on' => $curdt
                    );
                    $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                    // }
                } else {
                    $register_number = $this->db->where("id", $vehicle_id)->get("tb_trucks_data")->row(
                    )->register_number;
                    $chk1 = $this->db->where(array("shft_id" => $shipment_id, "status" => "0"))->get("tb_shft_veh");
                    if ($chk1->num_rows() > 0) {
                        $id = $chk1->row()->id;
                        $upd = $this->db->where(array("id" => $id))->update(
                            "tb_shft_veh",
                            array(
                                "vehicle_id" => $vehicle_id,
                                "carrier_id" => $carrier_id,
                                "register_number" => $register_number,
                                "status" => "1",
                                'updated_on' => $curdt
                            )
                        );
                        // if ($this->session->userdata('company_code') == 'PLKN') {
                        $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                        $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                        $driver_id = $chkdrivers->row()->driver_id;
                        $vendorDetailsArray = array(
                            "user_id" => $user_id,
                            "shft_id" => $shipment_id,
                            "carrier_id" => $carrier_id,
                            "vehicle_id" => $vehicle_id,
                            "driver_id" => $driver_id,
                            "register_number" => $register_number,
                            "status" => "1",
                            'created_on' => $curdt,
                            'updated_on' => $curdt
                        );
                        $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                        // }
                    } else {
                        $ins = $this->db->insert(
                            "tb_shft_veh",
                            array(
                                "user_id" => $user_id,
                                "shft_id" => $shipment_id,
                                "vehicle_id" => $vehicle_id,
                                "carrier_id" => $carrier_id,
                                "register_number" => $register_number,
                                "status" => "1",
                                'created_on' => $curdt
                            )
                        );
                        $id = $this->db->insert_id();
                        // if ($this->session->userdata('company_code') == 'PLKN') {
                        $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                        $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                        $driver_id = $chkdrivers->row()->driver_id;
                        $vendorDetailsArray = array(
                            "user_id" => $user_id,
                            "shft_id" => $shipment_id,
                            "carrier_id" => $carrier_id,
                            "vehicle_id" => $vehicle_id,
                            "driver_id" => $driver_id,
                            "register_number" => $register_number,
                            "status" => "1",
                            'created_on' => $curdt,
                            'updated_on' => $curdt
                        );
                        $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $vendorDetailsArray);
                        // }
                    }
                }
            }
            /* update in tbl_assigned_drivers */
            /*if ($this->session->userdata('company_code') === "UKKN") {*/
                $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                if ($chkdrivers->num_rows() > 0) {
                    $driver_id = $chkdrivers->row()->driver_id;
                    $veharr1 = array('vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 1);
                    $chkveh1 = $this->db->select("id")->get_where("tbl_assigned_drivers", $veharr1, 1, 0);
                    if ($chkveh1->num_rows() == 0) {
                        $insveh1 = array(
                            "vehicle_id" => $vehicle_id,
                            "user_id" => $user_id,
                            "driver_id" => $driver_id,
                            "from_time" => $curdt,
                            "to_time" => $curdt,
                            "status" => 1,
                            'created_on' => $curdt,
                            'updated_on' => $curdt
                        );
                        $ins = $this->db->insert("tbl_assigned_drivers", $insveh1);
                    }
                }
            //}

            //           /* start update tripdetails */
            $imei = $this->db->where("id", $vehicle_id)->get("tb_trucks_data")->row()->imei;

            $checkAssignedDriver = $this->db->select("id")->get_where(
                "tbl_assigned_drivers",
                array(
                    "driver_id" => $assginedDriverId,
                    "vehicle_id" => $vehicle_id
                ),
                1,
                0
            );

            if ($checkAssignedDriver->num_rows() > 0) {
                $upd = $this->db->where(array("id" => $checkAssignedDriver->row()->id))->update(
                    "tbl_assigned_drivers",
                    array(
                        "driver_id" => $driver_idd,
                        "status" => "1",
                        'updated_on' => $curdt
                    )
                );
            } else {
                $checkAssignedDriver = $this->db->select("id")->get_where(
                    "tbl_assigned_drivers",
                    array(
                        "driver_id <>" => $driver_idd,
                        "vehicle_id" => $vehicle_id,
                        "status" => 1
                    ),
                    1,
                    0
                );
                if ($checkAssignedDriver->num_rows() == 0) {
                    $ins = $this->db->insert(
                        "tbl_assigned_drivers",
                        array(
                            "vehicle_id" => $vehicle_id,
                            "user_id" => $user_id,
                            "driver_id" => $driver_idd,
                            "mobile_no" => $register_number,
                            "imei" => $imei,
                            "from_time" => $curdt,
                            "to_time" => $curdt,
                            "status" => "1",
                            'created_on' => $curdt
                        )
                    );
                }
            }
            $insvehold = array(
                "user_id" => $user_id,
                "shft_id" => $shipment_id,
                "carrier_id" => $carrier_id,
                "vehicle_id" => $vehicle_id,
                "driver_id" => $driver_idd,
                "register_number" => $register_number,
                "status" => "1",
                'created_on' => $curdt,
                'updated_on' => $curdt
            );
            $shipvehidold = $this->common->insertTableData("tb_shft_veh_history", $insvehold);

//           /*  end */

            $chk = $this->db->select("id")->get_where(
                "tb_shft_veh_emp",
                array("shft_veh_id" => $id, "status" => 1),
                1,
                0
            );
            if ($chk->num_rows() == 0) {
                $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where(
                    "tb_employee",
                    array("shift_id" => $shipment_id)
                );
                if ($getemp->num_rows() > 0) {
                    $pri = 1;
                    foreach ($getemp->result() as $gt) {
                        $insveh1 = array(
                            "user_id" => $user_id,
                            "shft_veh_id" => $id,
                            "emp_id" => $gt->id,
                            "priority" => $pri,
                            "pickup_time" => $gt->pickup_datetime,
                            'created_on' => $curdt,
                            'updated_on' => $curdt,
                            "status" => 1,
                            "drop_time" => $gt->drop_datetime
                        );
                        $ins = $this->db->insert("tb_shft_veh_emp", $insveh1);
                        $pri++;
                    }
                }
            }
            $checkvendors = $this->db->select("id")->get_where(
                "tb_vendors",
                array('id' => $carrier_id, 'tms_auto_accept' => 1),
                1,
                0
            );
            if ($checkvendors->num_rows() != 0) {
                $vehar = array('vehicle_id' => $vehicle_id, 'status' => 1);
                $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $vehar, 1, 0);
                $driver_id = $chkdrivers->row()->driver_id;
                $dvrarr1 = array('id' => $driver_id, 'status' => 1);
                $chknum = $this->db->select("contact_num")->get_where("tb_truck_drivers", $dvrarr1, 1, 0);
                $contact_num = $chknum->row()->contact_num;
                $checkshifts = $this->db->select("id")->get_where(
                    "tb_trips",
                    array(
                        'shift_id' => $shipment_id,
                    ),
                    1,
                    0
                );
                if ($checkshifts->num_rows() == 0) {
                    $whr = ['vehicle_id' => $vehicle_id, 'status' => 1];
                    $chkdrivers = $this->db->select("driver_id")->get_where("tb_vehicles_drivers", $whr, 1, 0);
                    $driver_id = $chkdrivers->row()->driver_id;
                    $curtzs = $this->session->userdata("usr_tzone")['timezone'];
                    $this->shippeomodel->updateTrip($shipment_id, $vehicle_id, $driver_id, $curdt, $curtzs, $curdt);
                    if (!empty($ins) && (($this->session->userdata(
                                    'company_code'
                                ) === 'NZKN') || ($this->session->userdata('company_code') == 'NZPG'))) {
                        $getvendorname = $this->db->select("name")->get_where(
                            "tb_vendors",
                            [
                                'id' => $carrier_id,
                                'name' => 'BASCIK TRANSPORT'
                            ]
                        );
                        if ($getvendorname->num_rows() > 0) {
                            $this->load->helper('nz_edis_helper');
                            bascikedi_call($shipment_id);
                        }

                        $gettollvendorname = $this->db->select("name")->get_where(
                            "tb_vendors",
                            [
                                'id' => $carrier_id,
                                'name' => 'TOLL NETWORKS (NZ) LTD'
                            ]
                        );
                        if ($gettollvendorname->num_rows() > 0) {
                            $getTOLLfile = $this->tollcarrieredi->shipmentdata($shipment_id);
                        }

                        if (checkAccessConditions('CHECK_ALTOVA_NZ_CARRIERS', $carrier_id)) {
                            $carrierStatus = $this->carriercommonedilib->shipmentdata($shipment_id);
                        }
                    }
                }
            }

            echo "1";
        }
        /* Push notification to mobile using Firebase */
        $orders = $this->common->gettbldata(["shift_id" =>$shipment_id],"id,order_id,customer_id,pickup_datetime,shipmentid,created_source,company_code","tb_orders",0,0);
        $orderIDs = $bookingIds = $customerIds = $pickUpDates = $createdSource = $customerNames= $knTrackingNos=[];

        if ($triggerToWeChat === 1 && checkAccessConditions('WECHAT_COUNTRY', $this->session->userdata('company_code'))) {
            try {
                $carrierEDIDetails = $this->common->carrierEDIDetails($carrier_id);
                if (!empty($carrierEDIDetails)) {
                    if ($carrierEDIDetails["editype"] == "P") {
                        if ($carrierEDIDetails["ediservice"] == "Web Services") {
                            $response = $this->carrierstandardtripoutbound->shipmentdata($shipment_id, "I");
                        }
                    }
                }
            } catch (Exception $ex) {
                log_message("error", "Some Problem occured!, While Sending Trip Notification XML  " . $shipment_id . " : " . $ex->getMessage());
            }
        }
        foreach ($orders as $eachRow) {
            $orderIDs[] = $eachRow['id'];
            $bookingIds[] = $eachRow['order_id'];
            $customerIds[] = $eachRow['customer_id'];
            $pickUpDates[]= $eachRow['pickup_datetime'];
            $createdSource[] = $eachRow['created_source'];
            $tripNo = $eachRow['shipmentid'];
            if ($triggerToWeChat === 1 && checkAccessConditions('WECHAT_COUNTRY', $eachRow['company_code'])) {
                $this->wechat->isDuplicateTrigger =1;
                $this->wechat->orderId = $eachRow['order_id'];
                $this->wechat->sendNotificationsToWeChat();
            }
        }
        if (!empty($customerIds)) {
            $customerData = $this->common->gettbldata("id IN (" . implode(",", $customerIds) . ")", "name", "tb_customers", 0, 0);
            $customerNames = array_merge($customerNames, array_column($customerData, 'name'));
        }
        if (!empty($createdSource)) {
            $referenceId = in_array(18, $createdSource) ? 'AWB' : 'DQ';
            $whereCondition = "order_id IN (" . implode(",", $orderIDs) . ") AND reference_id = '" . $referenceId . "' AND status = '1'";
            $trackingData = $this->common->gettbldata($whereCondition, "ref_value", "tb_order_references", 0, 0);
            $knTrackingNos = array_merge($knTrackingNos, array_column($trackingData, 'ref_value'));
        }
        if ($tripNo != "" && $driver_idd >0) {
            $customerName = implode(", ", $customerNames);
            $pickUpDate = implode(
                ", ",
                array_map(function ($date) {
                    return substr($date, 0, 10);
                }, $pickUpDates)
            );
            $bookingID = implode(", ", $bookingIds);
            $knTrackingNo = implode(", ", $knTrackingNos);
            $message = "New trip is assigned" . " "
                . "Pickup Date: " . $pickUpDate . " "
                . "Customer Name: " . $customerName . " "
                . "Booking ID: " . $bookingID . " "
                . "Trip No: " . $tripNo . " "
                . "KN tracking No: " . $knTrackingNo;
            $messageData = json_encode(["msg" => $message, "info" => (object)[], "type"=>1],JSON_UNESCAPED_UNICODE);
            $this->load->library('sendfirebase');
            $fire_ret = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driver_idd, 'type' => 'Driver']);
        }
        /*END  Push notification to mobile using Firebase */
    }

    public function openHistory()
    {
        $shift_id = $this->input->post("shift_id", true);
        $stop_id = $this->input->post("stop_id", true);
        $pickup_id = $this->input->post("pickup_id", true);
        $report_id = $this->input->post("report_id", true);
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $whr = " AND status = 1";
        if (isset($report_id) && $report_id == 1) {
            $whr = " ";
        }
        $dlat = $dlng = $slat = $slng = "";
        $shift = $this->db->query("SELECT slat,slng,elat,elng FROM tb_shifts WHERE id = $shift_id");
        if ($shift->num_rows() > 0) {
            $dlat = $shift->row()->elat;
            $dlng = $shift->row()->elng;
            $slat = $shift->row()->slat;
            $slng = $shift->row()->slng;
        }
        $trip = $this->db->query(
            "SELECT id,vehicle_id,status,dlat as latitude,dlng as longitude from tb_trips where shift_id = '$shift_id' $whr ORDER BY id DESC"
        );
        if ($trip->num_rows() > 0) {
            $trip_id = $trip->row()->id;
            $vehicle_id = $trip->row()->vehicle_id;
            if ($trip->row()->status == 1) {
                $rec = $this->db->query(
                    "SELECT latitude,longitude from tb_trucks_data WHERE id = '$vehicle_id' LIMIT 1"
                );
                if ($rec->num_rows() > 0) {
                    $slat = $rec->row()->latitude;
                    $slng = $rec->row()->longitude;
                }
            } else {
                $slat = $trip->row()->latitude;
                $slng = $trip->row()->longitude;
            }
            $data["drivers"] = [];
            $vehicles = $this->db->query(
                "SELECT vehicle_id FROM tb_shft_veh where shft_id=$shift_id AND status=1 GROUP BY vehicle_id"
            );
            $vs = [];
            $chk = array();
            $primary_driver = "";
            if ($vehicles->num_rows() > 0) {
                foreach ($vehicles->result() as $veh) {
                    $vs[] = $veh->vehicle_id;
                }
                $vs = "(" . implode(",", $vs) . ")";
                $arr = $this->db->query(
                    "SELECT d.id,d.name,d.contact_num,td.created_on as createdon from tbl_assigned_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.vehicle_id in $vs AND td.status ='1' GROUP BY d.id ORDER BY td.created_on ASC"
                );
                if($arr && $arr->result_array()){
                   // foreach ($arr as $ar1) {
                   foreach ($arr->result_array() as $ar1) {
                        $primary_driver = $ar1["id"];
                        if (!in_array($ar1["id"], $chk)) {
                            $chk[] = $ar1["id"];
                            $data["drivers"][] = $ar1;
                        }
                    }
                }
                $arr = $this->db->query(
                    "SELECT d.id,d.name,d.contact_num,td.createdon as createdon from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.trip_id = $trip_id AND td.status ='1' AND td.driver_id != '$primary_driver' GROUP BY d.id ORDER BY td.createdon ASC"
                );
                if($arr && $arr->result_array()){
                    //foreach ($arr as $ar) {
                    foreach ($arr->result_array() as $ar) {
                        if (!in_array($ar["id"], $chk)) {
                            $chk[] = $ar["id"];
                            $data["drivers"][] = $ar;
                        }
                    }
                }
            }
            $data["primary_driver"] = $primary_driver;
        } else {
            $trip_id = 0;
            $data["drivers"] = [];
            $vehicles = $this->db->query(
                "SELECT vehicle_id FROM tb_shft_veh where shft_id=$shift_id AND status=1 GROUP BY vehicle_id"
            );
            $vs = [];
            $primary_driver = "";
            $chk = array();
            if ($vehicles->num_rows() > 0) {
                foreach ($vehicles->result() as $veh) {
                    $vs[] = $veh->vehicle_id;
                }
                $vs = "(" . implode(",", $vs) . ")";
                $arr = $this->db->query(
                    "SELECT d.id,d.name,d.contact_num,td.created_on as createdon from tbl_assigned_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.vehicle_id in $vs AND td.status ='1' GROUP BY d.id ORDER BY td.created_on ASC"
                )->result_array();
                foreach ($arr as $ar1) {
                    $primary_driver = $ar1["id"];
                    if (!in_array($ar1["id"], $chk)) {
                        $chk[] = $ar1["id"];
                        $data["drivers"][] = $ar1;
                    }
                }
                $arr2 = $this->db->query(
                    "SELECT d.id,d.name,d.contact_num,td.createdon as createdon from tb_vehicles_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE vehicle_id in $vs AND td.status ='1' AND td.driver_id != '$primary_driver' GROUP BY d.id ORDER BY td.createdon ASC"
                )->result_array();
                foreach ($arr2 as $ar) {
                    if (!in_array($ar["id"], $chk)) {
                        $chk[] = $ar["id"];
                        $data["drivers"][] = $ar;
                    }
                }
            }
            $data["primary_driver"] = $primary_driver;
        }
        if (strlen($stop_id) > 0 && strlen($pickup_id) > 0) {
            $sql = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,e.address,e.order_id,e.pickup,e.drop from tb_stop_status ts LEFT JOIN tb_status_master sm ON sm.id=ts.status_id LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id=ts.stop_id OR e.drop_stopid=ts.stop_id) WHERE ts.shipment_id = '$shift_id' GROUP BY ts.id ORDER BY ts.createdon ASC"
            );
            $sql1 = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,ts.createdon,ts.imgpath,e.address,e.order_id,e.pickup,e.drop from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.stop_detail_id = $pickup_id AND ts.shipment_id = $shift_id AND ts.stop_id = $stop_id GROUP BY ts.id ORDER BY ts.createdon ASC"
            );
            $emp = $this->db->query(
                "SELECT plat,plng,dlat,dlng,stop_id FROM tb_employee where id = $pickup_id AND (stop_id= $stop_id OR drop_stopid = $stop_id)"
            );
            if ($emp->num_rows() > 0) {
                if ($emp->row()->stop_id = $stop_id) {
                    $dlat = $emp->row()->plat;
                    $dlng = $emp->row()->plng;
                } else {
                    $dlat = $emp->row()->dlat;
                    $dlng = $emp->row()->dlng;
                }
                if ($trip_id == 0) {
                    if ($emp->num_rows() > 0) {
                        if ($emp->row()->stop_id = $stop_id) {
                            $slat = $emp->row()->plat;
                            $slng = $emp->row()->plng;
                        }
                    }
                }
            }
        } else {
            if (strlen($stop_id) > 0) {
                $sql = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,e.address,e.order_id,e.pickup,e.drop from tb_stop_status ts LEFT JOIN tb_status_master sm ON sm.id=ts.status_id LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id=ts.stop_id OR e.drop_stopid=ts.stop_id) WHERE ts.shipment_id = '$shift_id' GROUP BY ts.id ORDER BY ts.createdon ASC"
                );
                $sql1 = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath,e.address,e.order_id,e.pickup,e.drop from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id LEFT JOIN tb_shiporder_stops ss ON (ss.id=e.drop_stopid OR ss.id=e.stop_id) WHERE ts.stop_id = $stop_id AND ts.shipment_id = $shift_id GROUP BY ts.id ORDER BY ts.createdon ASC"
                );
                $stops = $this->db->query(
                    "SELECT * FROM tb_shiporder_stops WHERE shipment_id = $shift_id AND id >=$stop_id ORDER BY id ASC limit 2"
                );
                if ($stops->num_rows() > 0) {
                    $stops = $stops->result_array();
                    $slat = $stops[0]["plat"];
                    $slng = $stops[0]["plng"];
                    if ($trip_id == 0) {
                        if (count($stops) > 1) {
                            $slat = $stops[0]["plat"];
                            $slng = $stops[0]["plng"];
                            $dlat = $stops[1]["plat"];
                            $dlng = $stops[1]["plng"];
                        } else {
                            $slat = $stops[0]["plat"];
                            $slng = $stops[0]["plng"];
                        }
                    }
                }
            } else {
                $sql = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.loc_name,ts.stop_id,ts.stop_type,sm.status_name,ts.status_code,ts.comment,convertToClientTZ(ts.createdon,?) as createdon,e.address,e.order_id,e.pickup,e.drop from tb_stop_status ts LEFT JOIN tb_status_master sm ON sm.id=ts.status_id LEFT JOIN tb_employee e ON e.shift_id = ts.shipment_id AND (e.stop_id=ts.stop_id OR e.drop_stopid=ts.stop_id) WHERE ts.shipment_id = ? GROUP BY ts.id ORDER BY ts.createdon ASC",
                    [$curtz, $shift_id]
                );
                $sql1 = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,?) as createdon,ts.imgpath,e.address,o.order_id,e.pickup,e.drop from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id LEFT JOIN tb_orders o ON o.id = ts.order_id  WHERE ts.shipment_id = ? GROUP BY ts.id ORDER BY ts.createdon ASC",
                    [$curtz, $shift_id]
                );
            }
        }
        if ($sql1->num_rows() > 0) {
            $i = 1;
            foreach ($sql1->result_array() as $eachRow) {
                $base64DocumentData = getBase64DocumentData($eachRow['imgpath']);
                $pods[] = [
                    'sno' => $i,
                    'location' => @getLocationName($eachRow['latitude'], $eachRow['longitude']),
                    'type_name' => $eachRow['type_name'],
                    'driver_name' => @getDrivernameById($eachRow['createdby'])["name"],
                    'stop_id' => $eachRow['stop_id'],
                    'stop_type' => $eachRow['stop_type'],
                    'createdon' => date("d M,y h:i A", strtotime($eachRow['createdon'])),
                    'extention' => $base64DocumentData['extention'],
                    'file_content' => $base64DocumentData['file_content'],
                ];
                $i++;
            }
        }
        $history = $sql->num_rows() >0 ? $sql->result_array() : [];
        $data["history"] = $this->tripcreatefromorders->getCustomStatusForOrders($history,$shift_id, $curtz);
        $data["pods"] = $pods ?? [];
        $data["slat"] = @$slat;
        $data["slng"] = @$slng;
        $data["dlat"] = @$dlat;
        $data["dlng"] = @$dlng;
        echo $this->load->view("openHistory", $data, true);
    }

    public function openHistoryMap()
    {
        $shift_id = $this->input->post("shift_id", true);
        $stop_id = $this->input->post("stop_id", true);
        $pickup_id = $this->input->post("pickup_id", true);
        $status = $this->input->post("status", true);
        $imei = $this->input->post("imei", true);
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if (strlen($stop_id) > 0 && strlen($pickup_id) > 0) {
            $sql = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,sm.status_name,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,e.address,e.order_id,e.pickup,e.drop,e.order_id from tb_stop_status ts LEFT JOIN tb_status_master sm ON sm.id=ts.status_id lEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.stop_detail_id = $pickup_id AND ts.shipment_id = $shift_id AND ts.stop_id = $stop_id GROUP BY ts.id"
            );
            $sql1 = $this->db->query(
                "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,dt.type_name,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath,e.address,e.order_id,e.pickup,e.drop,e.order_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type lEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.stop_detail_id = $pickup_id AND ts.shipment_id = $shift_id AND ts.stop_id = $stop_id GROUP BY ts.id"
            );
        } else {
            if (strlen($stop_id) > 0) {
                $sql = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,sm.status_name,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon, e.address, e.order_id, e.pickup, e.drop, e.order_id from tb_stop_status ts LEFT JOIN tb_status_master sm ON sm.id=ts.status_id lEFT JOIN tb_employee e ON e.id = ts.stop_detail_id LEFT JOIN tb_shiporder_stops ss ON (ss.id=e.drop_stopid OR ss.id=e.stop_id) WHERE ts.stop_id = $stop_id AND ts.shipment_id = $shift_id GROUP BY ts.id"
                );
                $sql1 = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,dt.type_name,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon, ts.imgpath, e.address, e.order_id, e.pickup,e.drop,e.order_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type lEFT JOIN tb_employee e ON e.id = ts.stop_detail_id LEFT JOIN tb_shiporder_stops ss ON (ss.id=e.drop_stopid OR ss.id=e.stop_id) WHERE ts.stop_id = $stop_id AND ts.shipment_id = $shift_id GROUP BY ts.id"
                );
                if ($status > 0) {
                    $point = $this->db->query(
                        "SELECT max(createdon) as `to`,min(createdon) as `from` from (SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.createdon,e.address,e.order_id,e.pickup,e.drop from tb_stop_status ts lEFT JOIN tb_employee e ON e.id = ts.stop_detail_id LEFT JOIN tb_shiporder_stops ss ON (ss.id=e.drop_stopid OR ss.id=e.stop_id) WHERE ts.stop_id = $stop_id AND ts.shipment_id = $shift_id GROUP BY ts.id) T"
                    );
                    $start = $point->row()->to;
                    $query = $this->db->query(
                        "SELECT latitude,longitude from tb_rtdrive_locations WHERE mobileimei = '$imei' AND `timestamp` >= '$start' GROUP BY SUBSTR(`timestamp`,1,15) ORDER BY `timestamp` DESC"
                    );
                    $data["records"] = [];
                    foreach ($query->result() as $row) {
                        $data["records"][] = array(
                            "lat" => $row->latitude,
                            "lng" => $row->longitude
                        );
                    }
                } else {
                    $data["records"] = [];
                }
            }
        }
        $data["history"] = $sql;
        $data["pod"] = $sql1;
        echo $this->load->view("openHistoryMap", $data, true);
    }

    public function opensinglemap()
    {
        $data['imei'] = $imei = $_GET["imei"] ?? "";
        $veh = $_GET["veh"] ?? "";

        $data["page_title"] = "MAP";
        $data["vehicle"] = (object)array("register_number" => $veh);

        if ($veh != "") {
            $record = $this->db->query(
                "SELECT latitude,longitude,receivedon as `timestamp` from tb_trucks_data where register_number = '" . $veh . "' limit 1"
            );
        } else {
            if ($imei != "" && $imei != "0") {
                $sql = "start_imei = '" . $imei . "' OR  end_imei = '" . $imei . "'";
            } else {
                $sql = "vehicle_id = '" . $veh . "'";
            }

            $record = $this->db->query(
                "SELECT dlat as latitude,dlng as longitude,etime as `timestamp` from tb_trips where " . $sql . " order by etime desc limit 1"
            );
            if ($record->num_rows() == 0) {
                $record = $this->db->query(
                    "SELECT plat as latitude,plng as longitude,stime as `timestamp` from tb_trips where " . $sql . " order by etime desc limit 1"
                );
            }
        }

        $data["record"] = array();
        if ($record->num_rows() > 0) {
            $data["record"] = $record->row();
        }

        $this->settemplate->dashboardtemp('singlemap', $data);
    }

    public function getLiveLocation($imei = null, $receivedon = 0)
    {
        $response = [];
        if ($imei != null) {
            $speedval = 1;
            if ($receivedon == 0 || $receivedon == "") {
                $date = date("Y-m-d H:i:s");
                $time = strtotime($date);
                $time = $time - (1 * 60);
                $rectime = date("Y-m-d H:i:s", $time);
                $query = $this->db->query(
                    "SELECT * from (SELECT latitude,longitude,round(speed*$speedval,2) as speed,bearing as course,`timestamp` from tb_rtdrive_locations where mobileimei = '$imei' AND `timestamp`>'$rectime' ORDER BY `timestamp` DESC limit 3) T ORDER BY `timestamp` ASC"
                );
            } else {
                $receivedon = date("Y-m-d H:i:s", ($receivedon));
                $query = $this->db->query(
                    "SELECT * from (SELECT latitude,longitude,round(speed*$speedval,2) as speed,bearing as course,`timestamp` from tb_rtdrive_locations where mobileimei = '$imei' AND `timestamp`>'$receivedon' ORDER BY `timestamp` DESC limit 3) T ORDER BY `timestamp` ASC"
                );
            }
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $response[] = array(
                        "lat" => $row->latitude,
                        "lng" => $row->longitude,
                        "speed" => uom_value($row->speed, 'kph'),
                        "course" => $row->course,
                        "receivedon" => date("Y m,d h:i:s", strtotime($row->timestamp)),
                        "timestamp" => strtotime($row->timestamp)
                    );
                }
            }

            if (count($response) > 0) {
                echo json_encode(array(
                                     "status" => "1",
                                     "data" => $response,
                                     "message" => ""
                                 ));
            } else {
                echo json_encode(array(
                                     "status" => "0",
                                     "data" => $response,
                                     "message" => "No data Found!"
                                 ));
            }
        } else {
            echo json_encode(array(
                                 "status" => "0",
                                 "data" => $response,
                                 "message" => "Vehicle sent empty!"
                             ));
        }
    }

    public function getTripLocation($trip_id = null, $receivedon = 0)
    {
        $response = [];
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if ($trip_id != null) {
            $speedval = 1.60934;
            if ($receivedon == 0 || $receivedon == "") {
                $query = $this->db->query(
                    "SELECT * from (SELECT latitude,longitude,round(speed*$speedval,2) as speed,bearing as course,convertToClientTZ(`timestamp`,'" . $curtz . "') as `timestamp` from tb_rtdrive_locations where trip_id = '$trip_id'  ORDER BY `timestamp` DESC limit 3) T ORDER BY `timestamp` ASC"
                );
            } else {
                $receivedon = date("Y-m-d H:i:s", ($receivedon));
                $query = $this->db->query(
                    "SELECT * from (SELECT latitude,longitude,round(speed*$speedval,2) as speed,bearing as course, convertToClientTZ(`timestamp`,'" . $curtz . "') as `timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' AND `timestamp`>'$receivedon' ORDER BY `timestamp` DESC limit 3) T ORDER BY `timestamp` ASC"
                );
                //echo $this->db->last_query();
            }
            foreach ($query->result() as $row) {
                $response[] = array(
                    "lat" => $row->latitude,
                    "lng" => $row->longitude,
                    "speed" => uom_value($row->speed, 'kph'),
                    "course" => $row->course,
                    "receivedon" => date("Y m,d h:i:s", strtotime($row->timestamp)),
                    "timestamp" => strtotime($row->timestamp)
                );
            }

            if (count($response) > 0) {
                echo json_encode(array(
                                     "status" => "1",
                                     "data" => $response,
                                     "message" => ""
                                 ));
            } else {
                echo json_encode(array(
                                     "status" => "0",
                                     "data" => $response,
                                     "message" => "No data Found!"
                                 ));
            }
        } else {
            echo json_encode(array(
                                 "status" => "0",
                                 "data" => $response,
                                 "message" => "Vehicle sent empty!"
                             ));
        }
    }

    public function tripMap($trip_id = '')
    {
        if ($trip_id != "") {
            $data["trip_id"] = $trip_id;
            $data["trip"] = $trip = $this->db->select(
                "shift_id,vehicle_id,status,dlat as latitude,dlng as longitude"
            )->get_where("tb_trips", array("id" => $trip_id), 1, 0)->row();
            $shift_id_way_points = $trip->shift_id;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $data["stops"] = $this->db->query(
                "SELECT id,stopname,stoptype,convertToClientTZ(startdate,'" . $curtz . "') as startdate,address,weight,volume,ship_units from tb_shiporder_stops where shipment_id = " . $trip->shift_id . " AND status='1' ORDER BY ordernumber ASC"
            );
            $data["details"] = [];
            foreach ($data["stops"]->result() as $stop) {
                $det = $this->db->query(
                    "SELECT id,plat,plng,pickup,convertToClientTZ(pickup_datetime,'" . $curtz . "') as pickup_datetime,dlat,dlng,`drop`,convertToClientTZ(drop_datetime,'" . $curtz . "') as drop_datetime,stop_id,shipment_weight,shipment_volume,order_id from tb_employee where (stop_id = " . $stop->id . " OR drop_stopid = " . $stop->id . ") AND status = '1'"
                );
                foreach ($det->result() as $row) {
                    $details = [];
                    if ($row->stop_id == $stop->id) {
                        $details["lat"] = $row->plat;
                        $details["lng"] = $row->plng;
                        $details["name"] = $row->pickup;
                        $details["time"] = $row->pickup_datetime;
                        $details["type"] = "P";
                    } else {
                        $details["lat"] = $row->dlat;
                        $details["lng"] = $row->dlng;
                        $details["name"] = $row->drop;
                        $details["time"] = $row->drop_datetime;
                        $details["type"] = "D";
                    }
                    $details["weight"] = $row->shipment_weight;
                    $details["volume"] = $row->shipment_volume;

                    $details["stop_id"] = $stop->id;
                    $details["id"] = $row->id;
                    $details["order_id"] = $row->order_id;
                    $details["alphabet"] = getColName(count($data["details"]) + 1);
                    $details["status"] = "0";
                    $done = $this->db->query(
                        "SELECT ss.status_id,ss.latitude,ss.longitude,convertToClientTZ(ss.createdon,'" . $curtz . "') as createdon,sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm ON sm.id=ss.status_id WHERE ss.shipment_id=" . $trip->shift_id . " AND ss.stop_id = " . $stop->id . " AND ss.stop_detail_id = " . $row->id . " AND ss.status='1' ORDER BY ss.createdon ASC"
                    );
                    $status_row = [];
                    if ($done->num_rows() > 0) {
                        foreach ($done->result() as $status) {
                            $status_row["detail_id"] = $row->id;
                            $status_row["status_id"] = $status->status_id;
                            $status_row["status_name"] = $status->status_name;
                            $status_row["in_lat"] = $status->latitude;
                            $status_row["in_lng"] = $status->longitude;
                            $status_row["in_time"] = $status->createdon;
                            $details["statuses"][] = (object)$status_row;
                        }
                        $details["status"] = "1";
                    } else {
                        $details["statuses"][] = (object)$status_row;
                    }
                    $data["details"][] = (object)$details;
                }
            }
            $data["drivers"] = $this->db->query(
                "SELECT d.id,d.name,d.contact_num,convertToClientTZ(td.createdon,'" . $curtz . "') as createdon,td.travelled_km from tb_trip_drivers td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE trip_id = $trip_id AND td.status =1 GROUP BY d.id ORDER BY td.createdon ASC"
            )->result_array();
            if ($trip->status == 1) {
                $data["record"] = $this->db->query(
                    "SELECT latitude,longitude from tb_trucks_data where id = '$trip->vehicle_id' limit 1"
                )->row();
            } else {
                $data["record"] = $trip;
            }

            if ($shift_id_way_points != "") {
                $where = array("shipment_id" => $shift_id_way_points);
                $table = "tb_shiporder_stops";
                $stop_points = $this->db->select("id,stopname,plat,plng")->order_by("ordernumber", "ASC")->get_where(
                    $table,
                    $where
                );
                if ($stop_points->num_rows() > 0) {
                    $data['stop_points'] = $stop_points->result_array();
                }
            }


            if ($this->session->userdata('company_code') == "CNKN") {
                $this->settemplate->dashboardtemp('admin/tripMapChina', $data);
            } else {
                $this->settemplate->dashboardtemp('admin/tripMap', $data);
            }
        }
    }

    public function getColName($index)
    {
        $alpha = [
            'A',
            'B',
            'C',
            'D',
            'E',
            'F',
            'G',
            'H',
            'I',
            'J',
            'K',
            'L',
            'M',
            'N',
            'O',
            'P',
            'Q',
            'R',
            'S',
            'T',
            'U',
            'V',
            'W',
            'X',
            'Y',
            'Z'
        ];
        $index--;
        $nAlphabets = 26;
        $f = floor($index / pow($nAlphabets, 0)) % $nAlphabets;
        $s = (floor($index / pow($nAlphabets, 1)) % $nAlphabets) - 1;
        $t = (floor($index / pow($nAlphabets, 2)) % $nAlphabets) - 1;

        $f = $f < 0 ? '' : $alpha[$f];
        $s = $s < 0 ? '' : $alpha[$s];
        $t = $t < 0 ? '' : $alpha[$t];

        return trim("{$t}{$s}{$f}");
    }

    public function popOverData($value = '')
    {
        $post = $this->input->post(null, true);
        $shipment_id = isset($post["shipment_id"]) ? $post["shipment_id"] : "";
        $stop_id = isset($post["stop_id"]) ? $post["stop_id"] : "";
        $type = isset($post["type"]) ? $post["type"] : "";
        $data["emps"] = getpicksdropsbystopDetail($shipment_id, $stop_id, $type);
        echo $this->load->view("popOverData", $data, true);
    }

    public function openSpeedHistory()
    {
        $trip_id = $this->input->post("trip_id", true);
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        if ($curtz == "") {
            $curtz = DFLT_TZ;
        }
        $data["speeds"] = $this->db->query(
            "select round(avg(abs(speed)),2) as avg_speed,convertToClientTZ(`timestamp`,'" . $curtz . "') as `timestamp` from tb_rtdrive_locations where trip_id = '$trip_id' group by date(`timestamp`),hour(`timestamp`)"
        );
        echo $this->load->view("cabreports/tripSpeed", $data, true);
    }

    public function fleetview()
    {
        $post1 = $this->input->post(null, true);
        $this->load->model("cabmodel");
        $data["page_title"] = $this->lang->line('fleet_view');
        $uid = $this->session->userdata('user_id');
        $whradm = " ($uid) ";

        if ($this->session->userdata('business_type') == 'Country Admin') {
            if (count($this->session->userdata('country_user_ids')) > 0) {
                $users = implode(",", $this->session->userdata('country_user_ids'));
                $whradm = " ($users) ";
            }
        }

        $data["sub_title"] = $this->lang->line('menu_visibility');
        $imei = ($this->input->get_post('imei', true)) ? $this->input->get_post('imei', true) : "";
        $groupid = ($this->input->get_post('groupid', true)) ? $this->input->get_post('groupid', true) : "";
        $data['imei'] = $imei;
        $data['groupid'] = $groupid;
        $enddt = date('Y-m-d');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $getactual = getdatetimebytimezone(DFLT_TZ, $enddt, $curtz);
        $enddt = $getactual['date'];
        $startdt = date('Y-m-d', strtotime('-7 days'));
        $getactual = getdatetimebytimezone(DFLT_TZ, $startdt, $curtz);
        $startdt = $getactual['date'];

        $post = [
            'fromdate_search' => $startdt,
            'todate_search' => $enddt,
            'dbsearchvehicle' => '',
            'durationwise' => 1
        ];

        if (isset($post1['durationwise'])) {
            $post = $post1;
            if ($post['fromdate_search'] != "") {
                $startdt = trim($post['fromdate_search']);
            }
            if ($post['todate_search'] != "") {
                $enddt = trim($post['todate_search']);
            }
        }
        $data['post'] = $post;
        $rdata = $this->cabmodel->dashbsearch($post, $uid);
        $data['livecabcount'] = $rdata['livecabcount'];
        $data['tripdistance'] = $rdata['tripdistance'];
        $data['latecabcount'] = $rdata['latecabcount'];
        $data['ontimetrips'] = $rdata['ontimetrips'];
        $data['latecabsbottom'] = $rdata['latecabsbottom'];

        $occ = getOccupencybyVehicle(null, $startdt, $enddt);

        $data["volume_occ"] = isset($occ['avg_weight']) ? $occ['avg_weight'] : 0;
        $data["weight_occ"] = isset($occ['avg_volume']) ? $occ['avg_volume'] : 0;
        $data['liveshipcnt'] = 2;
        $data['totaltrips'] = $rdata['totaltrips'];
        $chartdata[0] = array("cabcnt" => 0);

        $chkchrdt = $this->db->query(
            "select count(id) as cabcnt from tb_trucks_data WHERE user_id IN $whradm AND status='Active'"
        );
        if ($chkchrdt->num_rows() > 0) {
            $chartdata[0] = $chkchrdt->row_array();
        }
        $data["carriers"] = $this->db->query("select id,name from tb_vendors WHERE user_id IN $whradm AND status=1");

        $chartdata[1] = ["cabcnt" => $data["carriers"]->num_rows()];
        $chartdata[2] = ["cabcnt" => 0];

        $chkchrdt1 = $this->db->query(
            "select count(id) as cabcnt from tb_truck_drivers WHERE status='Active' AND user_id IN $whradm "
        );

        if ($chkchrdt1->num_rows() > 0) {
            $chartdata[2] = $chkchrdt1->row_array();
        }

        $arr = array();
        $colorarr[0] = "#f56954";
        $colorarr[1] = "#00a65a";
        $colorarr[2] = "#f39c12";
        $arr1[0] = "Vehicles";
        $arr1[1] = "Vendors";
        $arr1[2] = "Drivers";

        for ($i = 0; $i < 3; $i++) {
            $cbc = $chartdata[$i]['cabcnt'] ?? 0;
            $color = $colorarr[$i] ?? "#f56954";
            $highlight = $colorarr[$i] ?? "#f56954";
            $label = $arr1[$i] ?? "Vehicles";

            $arr[] = array(
                'value' => $cbc,
                'color' => $color,
                'highlight' => $highlight,
                'label' => $label
            );
        }
        $data['chartdata'] = $arr;
        $data["km_chart"] = $this->db->query(
            "SELECT v.id,v.name as register_number,sum(s.trip_distance) as distance FROM tb_vendors v,tb_trip_summary s where v.id=s.vendor_id and DATE(s.start_time)>='$startdt' and DATE(s.start_time)<='$enddt' and s.user_id IN $whradm GROUP BY v.id"
        );

        $carriers = $_GET["carriers"] ?? "";
        $drivers = $_GET["drivers"] ?? [];

        if (count($drivers) > 0) {
            $data["live_trucks"] = $this->db->query(
                "select d.id, a.imei, d.name,t.register_number,IFNULL(CONCAT(t.latitude,'@',t.longitude,'@',t.speed,'@',convertToClientTZ(t.receivedon,'" . $curtz . "')),'') as dtt from tbl_assigned_drivers a,tb_truck_drivers d,tb_trucks_data t where a.user_id IN $whradm and a.driver_id=d.id and a.vehicle_id=t.id and a.status=1 and t.imei in (" . implode(
                    ",",
                    $drivers
                ) . ")"
            );
        } else {
            if ($carriers != "") {
                $d = $this->db->query(
                    "SELECT d.id FROM tb_trips t
                        JOIN tb_truck_drivers d ON d.id=t.driver_id
                        JOIN tb_trucks_data v ON v.id=t.vehicle_id
                        JOIN tb_vehicles_drivers vc ON vc.vehicle_id=t.vehicle_id
                        LEFT JOIN tb_vendor_vehicles c ON c.vehicle_id = t.vehicle_id AND c.status=1
                    WHERE t.status=1 AND d.user_id IN $whradm AND v.user_id IN $whradm AND c.vendor_id=$carriers"
                );

                $drivers = [];
                foreach ($d->result() as $dd) {
                    $drivers[] = $dd->imei;
                }

                if (count($drivers) > 0) {
                    $data["live_trucks"] = $this->db->query(
                        "select d.id, d.name,t.register_number,IFNULL(CONCAT(t.latitude,'@',t.longitude,'@',t.speed,'@',convertToClientTZ(t.receivedon,'" . $curtz . "')),'') as dtt from tbl_assigned_drivers a,tb_truck_drivers d,tb_trucks_data t where a.user_id IN $whradm and a.driver_id=d.id and a.vehicle_id=t.id and a.status=1 and t.imei in (" . implode(
                            ",",
                            $drivers
                        ) . ")"
                    );
                }
            }
        }

        $data["drivers"] = $this->db->query(
            "SELECT d.id, d.name, c.vendor_id as carrier_id
             FROM tb_truck_drivers d
                LEFT JOIN tb_vehicles_drivers ad ON ad.driver_id = d.id
                LEFT JOIN tb_trucks_data v ON v.id=ad.vehicle_id
                LEFT JOIN tb_vendor_vehicles c ON c.vehicle_id = v.id AND c.status=1
             WHERE d.user_id IN $whradm AND v.user_id IN $whradm AND ad.status=1
             GROUP BY d.id"
        );

        if (in_array($this->session->userdata('company_code'), ["CNKN","HKKN","TWKN"])) {
            $this->settemplate->dashboard("visibility/fleetview_china", $data);
        } elseif ($this->session->userdata('map_type') == 0) {
            $this->settemplate->dashboard("visibility/fleetview", $data);
        } elseif ($this->session->userdata('map_type') == 1) {
            $this->settemplate->dashboard("visibility/fleetview_eu", $data);
        } else {
            $this->settemplate->dashboard("visibility/fleetview", $data);
        }
    }

    public function trackbyship()
    {
        $uid = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('track_by_shipment');
        $data["sub_title"] = $this->lang->line('menu_visibility');
        $post = array();
        $post1 = $this->input->post(null, true);
        if (isset($post1["todate_search"]) && strlen($post1["todate_search"]) > 0) {
            $enddt = date('Y-m-d H:i:s', strtotime($post1["todate_search"]));
        } else {
            $enddt = date('Y-m-d H:i:s');
        }
        if (isset($post1["fromdate_search"]) && strlen($post1["fromdate_search"]) > 0) {
            $startdt = date('Y-m-d H:i:s', strtotime($post1["fromdate_search"]));
        } else {
            $startdt = date('Y-m-d H:i:s', strtotime('-7 days'));
        }
        $post = array(
            'fromdate_search' => date('Y-m-d', strtotime($startdt)),
            'todate_search' => date('Y-m-d', strtotime($enddt)),
            'dbsearchvehicle' => '',
            'durationwise' => 1
        );
        if (isset($post1['durationwise'])) {
            $post = $post1;
        }
        $data['post'] = $post;
        /* $data["intransit"] = $this->db->query("SELECT t.id as trip_id,s.* FROM tb_trips t LEFT JOIN tb_shifts s ON s.id = t.shift_id WHERE t.status='1' AND s.user_id='$uid' AND t.stime >= '$startdt' AND t.stime <= '$enddt'");
          $data["all"] = $this->db->query("SELECT t.id as trip_id,s.* FROM tb_trips t LEFT JOIN tb_shifts s ON s.id = t.shift_id WHERE s.user_id='$uid' AND t.stime >= '$startdt' AND t.stime <= '$enddt'"); */

        if ($this->session->userdata('usr_tzone')['country'] == "CN") {
            $this->settemplate->dashboard("visibility/trackbyship_china", $data);
        } else {
            if ($this->session->userdata('company_code') == "CNKN") {
                $this->settemplate->dashboard("visibility/trackbyship_china", $data);
            } elseif ($this->session->userdata('map_type') == 0) {
                $this->settemplate->dashboard("visibility/trackbyship", $data);
            } elseif ($this->session->userdata('map_type') == 1) {
                $this->settemplate->dashboard("visibility/trackbyship_eu", $data);
            } else {
                $this->settemplate->dashboard("visibility/trackbyship", $data);
            }
        }
    }

    public function loadMapVehicles()
    {
        $uid = $this->session->userdata("user_id");
        $post = $this->input->post(null, true);
        $shipment_id = isset($post["shipment_id"]) ? $this->input->post("shipment_id", true) : "";
        $data = array();
        $whr = "";
        if (strlen(trim($shipment_id)) != 0) {
            $query = $this->db->query(
                "SELECT s.id FROM tb_shifts s JOIN tb_employee e ON s.id=e.shift_id WHERE (s.shipmentid LIKE '%" . $shipment_id . "%' OR e.order_id LIKE '%" . $shipment_id . "%') AND s.`status`='1' GROUP BY s.id ORDER BY s.id ASC"
            );
            $shift_ids = [];
            foreach ($query->result() as $key => $value) {
                $shift_ids[] = $value->id;
            }
            if (count($shift_ids) > 0) {
                $sids = implode(",", $shift_ids);
                $whr = " AND s.id in ($sids)";
            }
        }
        $sql = "select d.id,d.name,a.imei,tr.vehicle_id,t.register_number,a.status,a.imei as nimei,a.updated_on
                FROM tb_shifts s
                JOIN tb_trips tr on (tr.shift_id = s.id AND tr.status = '1')
                LEFT JOIN tbl_assigned_drivers a ON (a.vehicle_id = tr.vehicle_id AND a.status = '1')
                LEFT JOIN tb_trucks_data t ON t.id = a.vehicle_id
                LEFT JOIN tb_truck_drivers d ON d.id = a.driver_id
                WHERE s.user_id='$uid' $whr
                GROUP BY t.id
                ORDER BY t.register_number";
        $qr = $this->db->query($sql);
        $data["data"] = array();
        if ($qr->num_rows() > 0) {
            foreach ($qr->result() as $row) {
                $d = array();
                $drivid = $row->id;
                $updon = $row->updated_on;
                $d[] = $row->name;
                $d[] = $row->register_number;
                $imei = $row->imei;
                if ($imei == "") {
                    $imei = $row->nimei;
                }
                $qry = $this->db->query(
                    "SELECT CONCAT(latitude,'@',longitude,'@',speed,'@',receivedon,'@',battery,'@',imei,'@',fuel) as dt from tb_trucks_data WHERE id=" . $row->vehicle_id . " ORDER BY receivedon LIMIT 1"
                );
                $dt1 = "";
                $dt = array();
                if ($qry->num_rows() > 0) {
                    $dt1 = $qry->row()->dt;
                }
                if ($dt1 != "") {
                    $dt = explode("@", $dt1);
                }
                if (count($dt) != 7) {
                    $dt = array("17.6868", "83.2185", "0", "0001-01-01 00:00:00", "0", "0", "0");
                }
                if (strlen(trim($dt[0])) == 0) {
                    $dt = array("17.6868", "83.2185", "0", "0001-01-01 00:00:00", "0", "0", "0");
                }
                $d[] = getLocationName(
                        $dt[0],
                        $dt[1]
                    ) . "<input type='hidden' id='position' value='" . $dt[0] . "," . $dt[1] . "'><input type='hidden' id='speed' value='" . $dt[2] . "'><input type='hidden' id='imei' value='" . $dt[5] . "'><input type='hidden' id='fuel' value='" . $dt[6] . "'>";
                if (strlen($dt[2]) > 0) {
                    $d[] = $dt[2] . " KMPH";
                } else {
                    $d[] = "";
                }
                $d[] = (strlen(trim($dt[4])) > 0 ? $dt[4] . " %" : "");
                $d[] = getShipDetailByVeh($row->id);
                if (strlen($dt[3]) > 0) {
                    $d[] = date('d M,Y H:i a', strtotime($dt[3]));
                } else {
                    $d[] = "";
                }
                $data["data"][] = $d;
            }
        }
        echo json_encode($data);
    }

    public function getActiveTrips()
    {
        //$input = $this->input->post();
        $input = $this->input->post(null, true);
        $uid = $this->session->userdata('user_id');
        $trips = [];
        $whr = "";
        if (isset($input['shipment_id']) && $input['shipment_id'] != "") {
            $sh = trim($input['shipment_id']);
            $whr .= " AND (e.order_id LIKE '%" . $sh . "%' OR e.shipmentid LIKE '%" . $sh . "%') ";
        }
       
        $sql = $this->db->query(
            "SELECT e.trip_id as id,e.pickup_city as splace,e.delivery_city as eplace,e.shipmentid FROM tb_orders e WHERE e.trip_sts=0 AND e.trip_id!=0 AND e.user_id='$uid' $whr GROUP BY e.trip_id ORDER BY e.updatedon ASC"
        );
        foreach ($sql->result() as $row) {
            $trips[] = array(
                "id" => $row->id,
                "name" => "<div class='btn btn-xs btn-primary' onclick='openTripMap(\"" . $row->id . "\",\"" . $row->shipmentid . " - " . $row->splace . " - " . $row->eplace . "\")'>" . $row->shipmentid . "</div> " . $row->splace . " - " . $row->eplace,
            );
        }
        echo json_encode($trips);
    }

    //function for securelink popup
    public function secureLink(): void
    {
        // Driver Secure Link
        $this->load->model('Common');
        $vendor_id = $this->input->post("vendor_id", true);
        $shipmentid = $this->input->post("shipmentid", true);
        $voyage_number = $this->input->post("voyage_number", true);

        $errors = [];
        if (empty($vendor_id)) {
            $errors[] = "vendor ID should not be empty.";
        }
        if (empty($shipmentid)) {
            $errors[] = "shipment ID should not be empty.";
        }
        $vendor_info = $this->Common->gettblrowdata(['id' => $vendor_id], ['code'], 'tb_vendors', 1, 0);
        $carrier_party_identifier = $vendor_info['code'] ?? 0;

        //expiry of token after 10 days
        $expDate = strtotime('+10 days');
        $jwt_claim = ["sub" => $shipmentid, "exp" => $expDate, 'iss' => 'kn' . $carrier_party_identifier];
        $get_jwt = generate_jwt($jwt_claim);
        if ((SYS_TYPE == 'TMS') && ($this->session->userdata('company_code') == 'CNKN')) {
            $data["link_id"] = $this->chinaurl . "driverappv3/" . $get_jwt;
        } else {
            $data["link_id"] = base_url() . "driverappv3/" . $get_jwt;
        }
        $data["voyage_number"] = $voyage_number;

        // Carrier Secure Link
        $carrier_jwt_claim = ['iss' => "kn" . $carrier_party_identifier, "sub" => $shipmentid];
        $carrier_get_jwt = generate_jwt_carrier($carrier_jwt_claim);
        if ((SYS_TYPE == 'TMS') && ($this->session->userdata('company_code') == 'CNKN')) {
            $data['carrier_link_id'] = $this->chinaurl . "knmcdbkg/" . $carrier_get_jwt;
        } else {
            $data['carrier_link_id'] = base_url() . "knmcdbkg/" . $carrier_get_jwt;
        }
        $data['errors'] = $errors;
        echo $this->load->view("popSecureLink", $data, true);
    }

    /*
     *  To use as service for mobile web application to get secure link.
     *  Method : POST
     *  @param ship_id
     *  return json
     */

    public function getsecureLink()
    {
        $ship_id = $this->input->post("ship_id", true);
        $expDate = strtotime('+10 days');
        $jwt_claim = ["sub" => $ship_id, "exp" => $expDate];
        $get_jwt = generate_jwt($jwt_claim);
        $link_id = base_url() . "driverapp/" . $get_jwt;
        if ($link_id != "") {
            echo json_encode(array("status" => "1", "secure_link" => $link_id));
        } else {
            echo json_encode(array("status" => "0", "secure_link" => $link_id));
        }
    }

    /*
     *    Purpose : To send transport order pdf using mail services
     *    Method : POST
     *    @param string carrier_email
     *    @param string email_subject
     *    return JSON|CI_VIEW i.e mixed.
     */

    public function sent_transport_order($action = '')
    {
        if ($action == "sent") {
            $carrier_email = trim($this->input->post('carrier_email', true));
            $email_subject = trim($this->input->post('email_subject', true));

            if (!filter_var($carrier_email, FILTER_VALIDATE_EMAIL)) {
                $response = array("status" => 0, "message" => 'Please provide valid email');
                echo json_encode($response);
                return;
            }
            if (is_numeric($email_subject)) {
                $response = array("status" => 0, "message" => 'Only digits as subject is not allowed.');
                echo json_encode($response);
                return;
            }
            if (strlen($email_subject) <= 3) {
                $response = array("status" => 0, "message" => 'Subject requires min 4 charaters');
                echo json_encode($response);
                return;
            }
            if (strlen($email_subject) > 40) {
                $response = array("status" => 0, "message" => 'Subject allows max 40 charaters');
                echo json_encode($response);
                return;
            }
            if (isset($_FILES['transport_order']['name']) && $_FILES['transport_order']['name'] != '' && $_FILES['transport_order']['size'] > 0) {
                $tmp_name = $_FILES['transport_order']['tmp_name'];
                // $file_mime = mime_content_type($tmp_name);
                $pdf = "application/pdf";
                $image_info = pathinfo(basename($_FILES["transport_order"]["name"], PATHINFO_EXTENSION));
                $type = strtolower($image_info['extension']);

                try {
                    $dir = './assets/send_transport_order/';
                    if (!file_exists($dir) && !mkdir($dir, 0755) && !is_dir($dir)) {
                        $response = array("status" => 0, "message" => 'Uploaded path is invalid.');
                        echo json_encode($response);
                        return;
                    }
                    if (!is_writable($dir)) {
                        $response = array("status" => 0, "message" => 'Folder must be writable.');
                        echo json_encode($response);
                        return;
                    }
                    /*
                      if ($file_mime != $pdf) {
                      $response = array("status" => 0, "message" => 'Only Pdf allowed.');
                      echo json_encode($response);
                      return;
                      }
                      if ($file_mime == $pdf && $type != 'pdf') {
                      $response = array("status" => 0, "message" => 'Only Pdf allowed.');
                      echo json_encode($response);
                      return;
                      }
                     */
                    $fileName1 = 'transport_order_' . round(microtime(true) * 1000) . '.' . $type;
                    $config = array(
                        'upload_path' => $dir,
                        'allowed_types' => 'pdf',
                        'overwrite' => true,
                        'file_name' => $fileName1,
                    );
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    if ($this->upload->do_upload('transport_order')) {
                        $imgname = $this->upload->data();
                        $imgtype = $imgname['image_type'];
                        $fileName = $imgname['file_name'];
                        $data['image_path'] = $fileName1;
                        // send  mail.
                        if ($this->sendstatusmail(
                            array(
                                'emailid' => $carrier_email,
                                'subject' => $email_subject,
                                'dir' => $dir,
                                'fileName1' => $fileName1
                            )
                        )) {
                            $response = array("status" => 1, "message" => 'Mail send successfully');
                            echo json_encode($response);
                            // sleep(5);
                            unlink($dir . $fileName1);
                            return;
                        } else {
                            $response = array("status" => 0, "message" => 'Opps! something is went wrong');
                            echo json_encode($response);
                            return;
                        }
                    } else {
                        $response = array("status" => 0, "message" => 'Pdf upload failed.');
                        echo json_encode($response);
                        return;
                    }
                } catch (Exception $exc) {
                    $exception_ = $exc->getTraceAsString();
                    log_message('error', '-----catch block transport order.---' . $exception_);
                }
            } else {
                $response = array("status" => 0, "message" => 'Please upload valid pdf.');
                echo json_encode($response);
                return;
            }
        }

        $trip_id = $this->input->post('trip_id', true);
        $data['email'] = '';
        if ($trip_id != '' && strlen($trip_id) > 6) {
            $this->load->model('Common');
            $trip_info = $this->Common->gettblrowdata(array('shipmentid' => $trip_id),
                                                      array('vendor_id'),
                                                      'tb_orders',
                                                      1,
                                                      0);
            if (isset($trip_info['vendor_id']) && $trip_info['vendor_id'] != '' && is_numeric(
                    $trip_info['vendor_id']
                )) {
                $vendor_id = $trip_info['vendor_id'];
                $vendor_info = $this->Common->gettblrowdata(array('id' => $vendor_id),
                                                            array('email'),
                                                            'tb_vendors',
                                                            1,
                                                            0);
                if (isset($vendor_info['email']) && $vendor_info['email'] != '' && filter_var(
                        $vendor_info['email'],
                        FILTER_VALIDATE_EMAIL
                    )) {
                    $data['email'] = $vendor_info['email'];
                }
            }
        }

        $this->load->view('visibility/send_transport_order', $data);
    }

    /*
     *  Purpose : To Send mail with attachment.
     */

    public function sendstatusmail($data)
    {
        $this->load->library('email');
        $this->load->helper('email_templates');
        $config['mailtype'] = 'html';
        $config['charset'] = 'iso-8859-1';
        $config['wordwrap'] = false;
        $config['validate'] = true;
        $config['newline'] = "\r\n";
        try {
            $this->email->initialize($config);
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->to($data['emailid'], '');
            $this->email->subject($data['subject']);
            $this->email->message(transport_order_template());
            $this->email->attach(base_url($data['dir'] . $data['fileName1']));
            if ($this->email->send()) {
                return true;
            } else {
                return false;
            }
        } catch (Exception $e) {
            $exception_ = $e->getTraceAsString();
            log_message('error', '-----catch block send status mail transport order.---' . $exception_);
            return false;
        }
    }

    public function sent_secure_link_email()
    {
        $message = $this->input->post('message', true);
        $recipient = $this->input->post('recipient', true);
        $link_type = $this->input->post('link_type', true);
        if (strlen($message) > 5 && strlen($recipient) > 5) {
            $this->load->library('PhpMailerLibrary');
            $this->load->helper('email_templates');
            try {
                $subject = 'Secure Link';
                if ($link_type == "driver") {
                    if ($this->session->userdata('company_code') == "FRKN") {
                        $voyage_number = $this->input->post('voyage_number', true);
                        $body = driverapp_securelink_email_template($message, $voyage_number);
                        $subject = 'Shared trip ' . $voyage_number;
                    } else {
                        $body = secutelinke_template_1($message);
                    }
                } else {
                    $body = secutelink_template_2($message);
                }
                if ($this->phpmailerlibrary->sendmail($recipient, $subject, $body)) {
                    return "1";
                } else {
                    log_message("error", "Visibility Secure Link email failed");
                }
                return "0";
            } catch (Exception $e) {
                log_message("error", "Visibility Secure Link email failed - " . $e->getMessage());
                return "0";
            }
        }
    }

    public function getCarrierVehicleMultiAssignInfo()
    {
        $this->load->model('MultiOrderToCarrierAssignModel');
        $shiftIds = $this->input->post('shift_id', true);
        $companyCode = $this->session->userdata('company_code');
        $data["shipment_id"] = implode(",", $shiftIds);
        $userId = $this->session->userdata('user_id');
        $data["carrier_id"] = "";
        $data["volume"] = "";
        $data["vehicle_id"] = "";
        $isMultiLegShipment = $this->MultiOrderToCarrierAssignModel->getMultiLegOrdersCount($shiftIds);
        if ((int)$isMultiLegShipment === 0){
            $permission = checkuserpermissions();
            if (in_array("carrier", $permission)) {
                $companyCodes = [$companyCode];
                if ($companyCode === "KNAU") {
                    $companyCodes = ['AUKN', 'KNAU'];
                }
                $data["carriers"] = $this->MultiOrderToCarrierAssignModel->getCarriersByCompanyCode($companyCodes);
            } else {
                $data["carriers"] = $this->MultiOrderToCarrierAssignModel->getCarriersByAdminUser($userId);
            }
            $data["schedule_date"] = date("Y-m-d H:i:s");
            $data["carrier_instructions"] = "";
            $data["weight_capacity"] = "";
            $data["volume_capacity"] = "";
            $data["additional_conditions"] = "";
            $data["temperature_regime"] = "";
            $data["time_for_loading_penality_rate"] = "";
            $data['vehicle_type'] = "";
            $data["category"] = "";
            $data["rate"] = "";
            $data['driver'] = "";
            $data['rate_categories'] = $this->db->select('id,name')->get_where("tb_shipment_rate_categories",["status" => 1]);
            echo $this->load->view("multiAssignVehicleToShipmentStop", $data, true);
        } else {
            echo 1;
        }
    }

    public function openStreetMapFleetView(string $userType='admin'):void {
        $data = compact('userType');
        echo $this->load->view('open-street-map/fleetview_osm',$data,true);
    }
    public function openStreetMapFleetViewVehicleData():void {
        $uid  = $this->session->userdata("user_id");
        $tzone = $this->session->userdata("usr_tzone")['timezone'];
        $post = $this->input->post(null, true);
        $users = $data = $bindParams = [];
        $users[] = $uid;
        $cnUsers=[];
        if (in_array($uid, [36,37,38])) {
            $users[] = 7;
        }
        if ($this->session->userdata("business_type") == "Country Admin") {
            $users = $this->session->userdata("country_user_ids");
        }
        if (count($users) === 0) {
            $users = [0];
        }
        $usrs = implode(",", $users);
        $companyCode = $this->session->userdata('company_code');
        $checkAccessConditions = checkAccessConditions('RELATED_2_TW_CN', $companyCode);
        if ($checkAccessConditions) {
            $countryCode = $companyCode === "CNKN" ? "CN" : "TW";
            $sql = "SELECT GROUP_CONCAT(id SEPARATOR ', ') AS userids FROM tb_users WHERE country_code = ? GROUP BY country_code";
            $bindParams[] = $countryCode;
            $users = $this->common->fetchRecordsByCustomQry($sql,$bindParams,false);
            $cnUsers = explode(', ', $users['userids']);
            $bindParams = [];
            $sql = "SELECT id,register_number,truck_number FROM tb_trucks_data WHERE user_id IN ? AND status = ? ";
            $bindParams[] = $cnUsers;
            $bindParams[] = 'Active';
        } else {
            $sql = "SELECT id,register_number,truck_number FROM tb_trucks_data WHERE user_id IN ? AND status = ? ";
            $bindParams[] = $users;
            $bindParams[] = 'Active';
        }
        $results = $this->common->fetchRecordsByCustomQry($sql,$bindParams,true);
        $data["data"] = [];
        if ($results) {
            foreach ($results as $row) {
                $row = (object)$row;
                $bindParams = [];
                $dateLimit = date('Y-m-d H:00:00', strtotime('-90 days'));
                $sql = "SELECT tr.id AS trip_id,tr.vehicle_id,d.id,d.name FROM tb_trips tr,tb_truck_drivers d WHERE tr.driver_id=d.id AND tr.vehicle_id=? AND tr.created_on >= ? AND tr.status = ? GROUP BY tr.id LIMIT ?";
                $bindParams[] = $row->id;
                $bindParams[] = $dateLimit;
                $bindParams[] = 1;
                $bindParams[] = 1;
                $tripsInfo = $this->common->fetchRecordsByCustomQry($sql,$bindParams,false);
                $currentdate = date("Y-m-d");
                if ($tripsInfo) {
                    $tripdata = (object)$tripsInfo;
                    $bindParams = [];
                    if ($checkAccessConditions) {
                        $currentdate = date("Y-m-d H:i:s");
                        $sql = "SELECT td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.speed,td.battery,td.imei AS mobileimei,td.trailer_imei AS mobiletrailerimei, convertToClientTZ(td.receivedon,?) as `timestamp`,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts,o.order_id AS orderid, o.shipmentid as shipmentid,o.trip_id as tripid FROM tb_trips tr  LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id  LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id = ?  AND tr.status=? AND s.status_code=? AND o.pickup_datetime <= ?  AND TIMESTAMPDIFF(HOUR, ?, o.pickup_datetime) <= ? AND o.company_code = ? GROUP BY tr.id LIMIT ?";
                        $bindParams[] = $tzone;
                        $bindParams[] = $tripdata->vehicle_id;
                        $bindParams[] = 1;
                        $bindParams[] = '0212';
                        $bindParams[] = $currentdate;
                        $bindParams[] = $currentdate;
                        $bindParams[] = 2;
                        $bindParams[] = $companyCode;
                        $bindParams[] = 1;
                    } else {
                        $sql = "SELECT td.latitude,td.longitude,td.trailer_latitude,td.trailer_longitude,td.speed,td.battery,td.imei as mobileimei,td.trailer_imei as mobiletrailerimei,convertToClientTZ(td.receivedon, ?) as `timestamp`,td.fuel,td.bearing,td.azimuth,td.key_exist,td.inouts,o.order_id AS orderid, o.shipmentid as shipmentid,o.trip_id as tripid FROM tb_trips tr  LEFT JOIN tb_orders o ON o.trip_id = tr.id LEFT JOIN tb_trucks_data td ON td.id = tr.vehicle_id  LEFT JOIN tb_stop_status s ON s.order_id =o.id AND s.trip_id =tr.id WHERE td.id=? AND tr.status=? AND s.status_code=? AND o.pickup_datetime <= ?  AND TIMESTAMPDIFF(HOUR, ?, o.pickup_datetime) <= ? AND o.user_id IN ? GROUP BY tr.id LIMIT ?";
                        $bindParams[] = $tzone;
                        $bindParams[] = $tripdata->vehicle_id;
                        $bindParams[] = 1;
                        $bindParams[] = '0212';
                        $bindParams[] = $currentdate;
                        $bindParams[] = $currentdate;
                        $bindParams[] = 2;
                        $bindParams[] = $users;
                        $bindParams[] = 1;
                    }
                    $orderInfo = $this->common->fetchRecordsByCustomQry($sql,$bindParams,false);
                    if ($orderInfo) {
                        $rec = (object)$orderInfo;
                        if ($rec->latitude && $rec->longitude) {
                            $shipmentInfo = getShipDetailByVeh($tripdata->id);
                            $trailerInfo = [];
                            if ($row->truck_number != '' && $row->truck_number != $row->register_number && ($rec->trailer_latitude != '' && $rec->trailer_longitude != '')) {
                                $trailerInfo = [
                                    'truckNumber'       => (string)$row->truck_number,
                                    'trailerLatitude'   => (string)$rec->trailer_latitude,
                                    'trailerLongitude'  => (string)$rec->trailer_longitude,
                                    'imei'=>(string)$rec->mobiletrailerimei,
                                ];
                            }
                            $data["data"][] = [
                                'latitude'     => $rec->latitude,
                                'longitude'    => $rec->longitude,
                                'imei'         => (string)$rec->mobileimei,
                                'fuel'         => (string)$rec->fuel,
                                'speed'        => $rec->speed > 0 ? (string)$rec->speed.'kph' : '',
                                'bearing'      => (string)$rec->bearing,
                                'shipmentId'   => (string)$rec->shipmentid,
                                'orderId'      => (string)$rec->orderid,
                                'tripId'       => (string)$rec->tripid,
                                'truckNumber'  => $row->truck_number ? (string)$row->truck_number : (string)$row->register_number,
                                'trailerInfo'  => $trailerInfo,
                                'timeStamp'    => (strlen($rec->timestamp) > 0) ? date('d M,Y H:i a', strtotime($rec->timestamp)) : '',
                                'shipmentInfo' => $shipmentInfo,
                                'driverName'   => (string)$tripdata->name
                            ];
                        }
                    }
                }
            }
        }

        if ($checkAccessConditions) {
            $bindParams = [];
            $sql = "SELECT o.id,o.order_id as orderid,o.plat as latitude,o.plng as longitude,o.trip_sts FROM tb_orders o
            WHERE o.user_id IN ? AND o.trip_id=? AND (`o`.`trip_id` =? AND (SELECT COUNT(trip_id) FROM tb_employee WHERE order_id=o.order_id) = ?) AND o.status != ? AND o.trip_sts=? AND o.plat!='' AND o.plng!='' GROUP BY o.order_id ORDER BY o.pickup_datetime DESC";
            $bindParams[] = $cnUsers;
            $bindParams[] = 0;
            $bindParams[] = 0;
            $bindParams[] = 0;
            $bindParams[] = 0;
            $bindParams[] = 0;
            $orderDetails = $this->common->fetchRecordsByCustomQry($sql,$bindParams,true);
            if ($orderDetails) {
                foreach ($orderDetails as $orderData) {
                    $orderData = (object)$orderData;
                    if ($orderData->latitude && $orderData->longitude) {
                        $data["data"][] = [
                            'latitude'     => $orderData->latitude,
                            'longitude'    => $orderData->longitude,
                            'imei'         => '',
                            'fuel'         => '',
                            'speed'        => '',
                            'bearing'      => '',
                            'shipmentId'   => '',
                            'orderId'      => (string)$orderData->orderid,
                            'tripId'       => '',
                            'truckNumber'  => '',
                            'trailerInfo'  => [],
                            'timeStamp'    => '',
                            'shipmentInfo' => '',
                            'driverName'   => ''
                        ];
                    }
                }
            }
        }
        $checkAccessConditions = checkAccessConditions('WHEELS_EYE_COUNTRIES', $companyCode);
        if ($checkAccessConditions){
            $results = $this->common->getWheelsEyeOrderVehicles();
            if($results)
            {
                foreach ($results as $orderData){
                    $orderData = (object) $orderData;
                    if ($orderData->latitude && $orderData->longitude) {
                        $data["data"][] = [
                            'latitude'     => $orderData->latitude,
                            'longitude'    => $orderData->longitude,
                            'imei'         => (string)$orderData->trailer_imei,
                            'fuel'         => (string)$orderData->fuel,
                            'speed'        => '',
                            'bearing'      => round((float) $orderData->bearing),
                            'shipmentId'   => (string)$orderData->shipmentid,
                            'orderId'      => (string)$orderData->orderid,
                            'tripId'       => '',
                            'truckNumber'  => (string)$orderData->register_number,
                            'trailerInfo'  => [],
                            'timeStamp'    => '',
                            'shipmentInfo' => '',
                            'driverName'  => (string)$orderData->name
                        ];
                    }
                }
            }
        }
        echo json_encode($data);
    }
}
