<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class VolumeReport extends CI_Controller
{

    public function __construct()
    {
      parent::__construct();
      if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if (!checkUrlAccessForUser('VOLUMEREPORT')) {
            redirect("Forbiddenaccess");
        }
	}
    public function index()
    {
        $data['page_title'] = $this->lang->line('volume_report');
        $data['sub_title'] = $this->lang->line('leftmenu_reports');
		$uid = $this->session->userdata('user_id');
		$cid = $this->session->userdata('id');
    	$company_code = $this->session->userdata('company_code');
		$data['orders']=array();
		$where="";
		if ($_POST) {
			if (!empty($this->input->post('bookingid',true)) || !empty($this->input->post('bookingid_a',true)) ) {
				 $bookingid=$this->input->post('bookingid',true)==""?$this->input->post('bookingid_a',true):$this->input->post('bookingid',true);
				$where.=" AND o.order_id='".$bookingid."'";

			}

			if (!empty($this->input->post('fromDate',true)) || !empty($this->input->post('fromDate_a',true))) {
				 $fromDate=$this->input->post('fromDate',true)==""?$this->input->post('fromDate_a',true):$this->input->post('fromDate',true);
				 $where.=" AND (DATE_FORMAT(o.createdon,'%Y-%m-%d') >='".date('Y-m-d', strtotime($fromDate))."')";
			 }

			if (!empty($this->input->post('toDate',true)) || !empty($this->input->post('toDate_a',true))) {
				 $oate=$this->input->post('toDate',true)==""?$this->input->post('toDate_a',true):$this->input->post('toDate',true);
				$where.=" AND  (DATE_FORMAT(o.createdon,'%Y-%m-%d') <='".date('Y-m-d', strtotime($oate))."')";

			 }
			if (!empty($this->input->post('delivery_note',true))) {
				$delivery_note=$this->input->post('delivery_note',true);
				$getdelivery_noteid = $this->db->select( "order_id" )->get_where( "tb_order_references", array( 'ref_value' => $delivery_note, 'status' => '1', 'reference_id' => 'DQ' ) );
				if ( $getdelivery_noteid->num_rows() > 0 ) {
					$order_id    = $getdelivery_noteid->row()->order_id;
					$where.=" AND o.id ='".$order_id."'";
				}

			}
			if (!empty($this->input->post('salog_ref',true))) {
				$salog_ref=$this->input->post('salog_ref',true);

				$getdelivery_noteid = $this->db->select( "order_id" )->get_where( "tb_order_references", array( 'ref_value' => $salog_ref, 'status' => '1', 'reference_id' => 'XSR' ) );
				if ( $getdelivery_noteid->num_rows() > 0 ) {
					$order_id    = $getdelivery_noteid->row()->order_id;
					$where.=" AND o.id ='".$order_id."'";
				}

			}
			if (!empty($this->input->post('status',true))) {
				 $status=$this->input->post('status',true);
				 if($status=='PENDING'){
					$where.=" AND o.status != 0 AND o.trip_id=0";
				 }
				 if($status=='ACTIVE'){
					 $where.=" AND o.status != 0 AND o.trip_id !=0 AND o.trip_sts=0";
				 }
				 if($status=='CLOSED'){
					 $where.="AND o.status != 0 AND o.trip_id !=0 AND o.trip_sts=1";
				 }

			 }
			 $getorder=$this->db->query("SELECT o.id, o.order_id,o.pickup_company, o.delivery_company, o.`delivery_address2` AS province, SUM(CASE WHEN c.status = '1' THEN c.weight ELSE 0 END) AS total_weight, SUM(CASE WHEN c.status = '1' THEN c.volume ELSE 0 END) AS total_volume, SUM(CASE WHEN c.status = '1' THEN c.quantity ELSE 0 END) AS totatl_quantity, o.createdon FROM `tb_orders` `o` LEFT OUTER JOIN `tb_order_cargodetails` `c` ON `o`.`id` = `c`.`order_id` WHERE `o`.`vendor_id` = '".$cid."' AND `o`.`company_code` = '".$company_code."' $where GROUP BY `o`.`id` ORDER BY `o`.`createdon` DESC");
			 $orderdata = 	$getorder->result_array();

			 foreach ( $orderdata as $res ) {
				$order_id=$res['id'];
				$orderref=$this->db->query("SELECT reference_id,ref_value from tb_order_references where order_id='".$order_id."' AND reference_id in ('DQ','XSR') AND status=1");
				$orderrefdata = 	$orderref->result_array();
				$deliverynote= $slogref = "";
				foreach ($orderrefdata as $ref ) {
					if($ref['reference_id']=="DQ"){
						$deliverynote=$ref['ref_value'];
					}
					if($ref['reference_id']=="XSR"){
						$slogref=$ref['ref_value'];
					}
				}
				$data['orders'][]=array(
					"id"=>$res['id'],
					"order_id"=>$res['order_id'],
					"pickup_company"=>$res['pickup_company'],
					"delivery_company"=>$res['delivery_company'],
					"province"=>$res['province'],
					"total_weight"=>$res['total_weight'],
					"total_volume"=>$res['total_volume'],
					"totatl_quantity"=>$res['totatl_quantity'],
					"createdon"=>$res['createdon'],
					"deliverynote"=>$deliverynote,
					"slogref"=>$slogref
				);
			 }
		}

        $this->newtemplate->dashboard( "volumereport/index", $data );
    }
}
