<?php

/**
 * Description of Vozovozcronjob.
 *
 * @author Apple
 */
class Vozovozcronjob extends CI_Controller {

    public function __Construct() {
        parent::__Construct();
        $this->load->library("VozovozEdi");
        $this->load->library("edi/EdiStatusProcess");
        $this->load->model('common');
    }

    function index() {
        $vendor_id = 0;
        $vendor_info = $this->common->gettblrowdata(['name' => 'ВОЗОВОЗ ООО'], 'id', 'tb_vendors', 0, 0);
        if (isset($vendor_info['id'])) {
            $vendor_id = $vendor_info['id'];
        }
        if (0 === $vendor_id) {
            log_message('error', 'Invalid vendor id generated during vozovoz cronjob');
            return;
        }
        $rows = $this->edistatusprocess->get_vendor_related_orders($vendor_id);
        if ((!empty($rows)) && sizeof($rows)) {
            foreach ($rows as $row) {
                $id = $row['id']; // tb_orders id
                $order_id = $row['order_id'];
                $shift_id = $row['shift_id'];
                $trip_id = $row['trip_id'];
                $vendor_id = $row['vendor_id'];
                $ref_value = $row['ref_value'];
                $tb_order_reference_row_id = $row['tb_order_reference_row_id'];
                $this->vozovozedi->status_tracking($ref_value);

                $where_ = array("shift_id" => $shift_id, "trip_sts" => '0', 'status!=' => '0');
                $result_order = $this->common->gettblrowdata($where_, 'id', 'tb_orders', 0, 0);
                if (isset($result_order['id']) && $result_order['id'] != "" && is_numeric($result_order['id'])) {
                    //few records still open so do nothing here..
                } else {
                    // close shipment
                    log_message("Error", "close shipment happend @Vozovoz");
                    $this->common->updatetbledata("tb_shifts", array("status" => 0), array("id" => $shift_id));
                    $this->common->updatetbledata("tb_trips", array("status" => 0), array("id" => $trip_id));
                    $this->generatesummary($trip_id,'');
                }
            }
        }
    }

    public function generatesummary($tripid = null, $curtz = null) {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=" . $shift . " LIMIT 1");
                $data["trip"] = $sql1->row();
                /* $emp1 = $this->db->query("select e.name,convertToClientTZ(te.stime,'".$curtz."') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=".$tripid); */
                $emp = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $dlat = $dlng = "";
                $trucks_query = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude from tb_trucks_data WHERE id=$vehicleid LIMIT 1");
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                    $dlat = $trucks_query->row()->latitude;
                    $dlng = $trucks_query->row()->longitude;
                }
                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }
                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }
                /* update end lat lng in trips */
                $whrtrip = array("id" => $tripid);
                $settrip = array("dlat" => $dlat, "dlng" => $dlng);
                $upd = $this->db->where($whrtrip)->update("tb_trips", $settrip);
                $vtripinfo = array("plat" => $sql->row()->plat, "plng" => $sql->row()->plng, "dlat" => $dlat, "dlng" => $dlng);
                $data['tripinfo'] = (Object) $vtripinfo;
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                $sql2 = $this->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 1;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt);
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                /* $data["trip_id"] = $tripid;
                  $shifttime = 0;
                  if ($trip_type != 2) {
                  $shti = $sql1->row()->startdate;
                  $shifttime = date('H:i A', strtotime($shti));
                  } else {
                  $shifttime = "Empty";
                  }
                  $data["driver_late"]  = $driver_late;
                  $data["empshifttime"] = $shifttime;
                  $data["distance"]     = $dist;
                  $data["stime"]        = $stime;
                  $data["etime"]        = $etime;
                  $data["simei"]        = $imei;
                  $data["eimei"]        = $eimei;
                  if ($odometer_end == "") {$odometer_end = 0;}
                  if ($odometer_start == "") {$odometer_start = 0;}
                  $data["odometer"]        = ($odometer_end - $odometer_start);
                  $data["page_title"]      = "Trip Report";
                  $data["capacity"]        = $cab_capacity;
                  $data["employees"]       = $emp1;
                  $data["trip_type"]       = $trip_type;
                  $data["register_number"] = $reg;
                  $data["truck_weight"]    = $truck_weight;
                  $data["truck_volume"]    = $truck_volume;
                  $data["ep"] = ""; */
                /* $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                  if ($getusermail->num_rows() > 0) {
                  $receivemail = $getusermail->row()->emailid;
                  $receivename = $getusermail->row()->name;
                  $receivecc   = $getusermail->row()->cc_mails;
                  $data["ep"] = $getusermail->row()->address;
                  $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);
                  $repotmaildata = $this->db->insert('tb_trips_mails',$insertdata);
                  $this->load->library('email');
                  $this->email->to($receivemail, $receivename);
                  if ($receivecc != "") {
                  $this->email->cc($receivecc);
                  }
                  $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                  if ($trip_type == 1) {
                  $this->email->subject('svkonekt: Return Trip Status');
                  } else if ($trip_type == 2) {
                  $this->email->subject('svkonekt: Empty Trip Status');
                  } else {
                  $this->email->subject('svkonekt: Trip Status');
                  }
                  $this->email->set_mailtype('html');
                  $body = $this->load->view('mail_forms/basicreport', $data, true);
                  $this->email->message($body);
                  $sendmail = $this->email->send();
                  } */
                /* echo json_encode(array("status" => 1, "data" => $data)); */
            }
        }
    }

}
