<?php if(!defined('BASEPATH')) exit('No direct script access allowed');
class Welcome extends CI_Controller {

	public function __Construct()
    {
        parent::__Construct();
        // if (isset($_SERVER['HTTP_ORIGIN'])) {
        //     header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
        //     header('Access-Control-Allow-Credentials: true');
        //     header('Access-Control-Max-Age: 86400'); // cache for 1 day
        // }
        // if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        //     if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
        //         header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
        //     }
        //     if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
        //         header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
        //     }
        // }
        $this->load->model("user_model");
    }

  	public function index()
	{

		$data['location'] ='';

		@$ip = $_SERVER["REMOTE_ADDR"]; // the IP address to query
		$query = @unserialize(file_get_contents('http://ip-api.com/php/'.$ip));
		if($query && $query['status'] == 'success') {
		  //echo 'Hello visitor from '.$query['country'].', '.$query['city'].'!';
		  $data['location'] = $query['city'];
 		}
		$getVehicles = $this->user_model->getvehicleslist();
		$data['vehiclelist'] = $getVehicles;
 		$this->settemplate->general('templates/content',$data);
 		$this->load->library('form_validation');
	}

	public function loadmapoints()
	{
	  $this->load->view('loadroutemap');
	}
 	public function confirmorder()
	{
 	   $this->load->view('confirmorderview');
 	}
	public function useregistration()
	{
	  // $this->load->view('useregistrationview');
	  $this->load->library('form_validation');
	  // field name, error message, validation rules
	  $this->form_validation->set_rules('signup-name', 'User Name', 'trim|required|min_length[4]|xss_clean');
	  $this->form_validation->set_rules('signup-email', 'Your Email', 'trim|required|valid_email');
	  $this->form_validation->set_rules('signup-password', 'Password', 'trim|required|min_length[4]|max_length[32]');
	  $useremail = $this->input->post('signup-email');
	  $username = $this->input->post('signup-name');
	  if($this->form_validation->run() == TRUE)
		  {
 		     $adduser = $this->user_model->add_user();
			 $this->sendemail($useremail,$username);
 		  }

	}
 	public function userlogin()
	{
	   $email=$this->input->post('login-email');
       $password=password_hash($this->input->post('login-password'),PASSWORD_DEFAULT);
       $result=$this->user_model->login($email,$password);
	   if(is_array($result))
	   {
	        $this->session->set_userdata($result);
		    echo  $this->session->userdata('user_id');
			//die();
 	   }
	   else
	   {
	       echo 0;
	   }
   	}

 	public function userlogout()
	{
        $this->session->sess_destroy();
        $this->user_model->logout();
	    redirect('welcome');
 	}
 	public function sendemail($useremail,$username)
	{
 	    $this->load->library('email');
	    $this->email->to($useremail);
		$this->email->from('admin@citytrucks.in');
		$this->email->subject('Here is your info '.$username);
		$this->email->message('Hi '.$username.' Thanks for registering with city trucks .');
		$this->email->send();
		//echo $this->email->print_debugger();
 	}

	public function checkemail()
	{
	   $email=$this->input->post('emailid');
	   $checkStatus = $this->user_model->checkemailavaiblity($email);
	   echo $checkStatus;
 	}
 	public function support()
	{

		$this->load->view('support_view');

	}
 	public function profile()
	{
	      $userdid = $this->session->userdata('user_id');
		  if($userdid==''){ redirect('welcome'); }

		  $userid = $this->session->userdata('user_id');
		  $getuser = $this->user_model->getuserdetails($userid);
 		  $data['userdetails'] =$getuser;
	      $this->settemplate->innerpagesview('templates/profile',$data);
  	}

	public function bookings()
	{
 	      $userdid = $this->session->userdata('user_id');
		  if($userdid==''){ redirect('welcome'); }

	      $data['location'] ='';
		  $userid = $this->session->userdata('user_id');
		  $getorders = $this->user_model->getuserbookings($userid);
		  $data['userorders'] =$getorders;
 	      $this->settemplate->innerpagesview('templates/bookings',$data);

	}

	public function getrackloadprice()
	{
	    $vehiclid=$this->input->post('vehiclid');
		$gettrackprice = $this->user_model->getvehicletrackprice($vehiclid);
		//print_r($gettrackprice);
		echo $gettrackprice['live_trucking'];
	}
	function aboutus()
	{

		$this->settemplate->innerpagesview('aboutus',"");
	}
	function faq()
	{

		$this->settemplate->innerpagesview('faq',"");
	}
	function privacy_policy()
	{

		$this->settemplate->innerpagesview('privacypolicy',"");
	}
	function termsofuse()
	{

		$this->settemplate->innerpagesview('termsofuse',"");
	}
	function contactus()
	{

		$this->settemplate->innerpagesview('contactus',"");
	}

	public function logout()
	{
		$currentDateTime = date("Y-m-d H:i:s");

		if($this->session->userdata('user_id')){
			if($this->session->userdata('user_id') !== ""){
				$userId = $this->session->userdata('user_id');
				$userType = 1;
				$childId = 0;
				$actionName = "Admin Logout";
				if($this->session->userdata('cust_id')){
					$userId = $this->session->userdata('cust_id');
					$actionName = "Customer Logout";
					$userType = 3;
					if($this->session->userdata('child_id')){
						$childId = $this->session->userdata('child_id');
					}
				}
				$logDateTime = [
				    'user_id'=>$userId,
                    'user_type'=>$userType,
                    'activity_id'=>0,
                    'action_name'=>$actionName,
                    'child_id'=>$childId,
                    'device_type'=>1,
                    'description'=>$actionName,
                    'status'=>1,
                    'createdon'=>$currentDateTime
                ];
				$this->db->insert("tb_user_activities",$logDateTime);
				if($userType === 1){
					$this->db->where(["id"=>$userId])
                        ->update('tb_users',["online"=>0]);
				}else{
					$this->db->where(["id"=>$userId])
                        ->update('tb_customers',["online"=>0]);
				}
			}
		}
        $this->session->sess_destroy();
		redirect('login');
	}

	function sendcontactus()
	{
		$data['post'] = array();
			$username = $this->input->post('ct_name');
			$usermail = $this->input->post('ct_mailid');
			$usermobile = $this->input->post('ct_phone');
			$usermsg = $this->input->post('ct_message');
			$createdon = date('Y-m-d H:i:s');
			$inser_array= array('name'=>$username,'phone'=>$usermobile,'email'=>$usermail,'description'=>$usermsg);
			$this->db->insert(TBSUFFIX.CONTACTUS, $inser_array);
			$rowid = $this->db->insert_id();
			if($rowid>0)
			{
			$d = array('to'=>$usermail,'cc'=>'svkonekt@kuehne-nagel.com','bcc'=>'','subject'=>'CITY TRUCKS CONTACT FORM','message'=>$usermsg,'module'=>'Contact Us','user_id'=>'','ct_name' =>$_POST['ct_name'],'ct_phone' =>$_POST['ct_phone'],'ct_mailid' =>$_POST['ct_mailid'],'usermsg' =>$usermsg);
				$this->load->library('sendemail');
				$this->sendemail->send_contactmail($d);
				$this->session->set_flashdata('success_msg', "Thank you for contact us. Your request has been sent successfully!");
				redirect("welcome/contactus");
			}
	}
	function subscribe()
	{
		$subsciberemail=	$this->input->post('subscriber_email');
		$sql="select  * from tb_emailsubscribe where email='$subsciberemail'";
		//echo $sql;
		$query=$this->db->query($sql);
		if($query->num_rows()==0)
		{
			$inser_array= array('email'=>$subsciberemail);
			$this->db->insert(TBSUFFIX.EMAILSUBSCRIBE, $inser_array);
			$rowid = $this->db->insert_id();
			if($rowid>0)
			{
			$d = array('to'=>$subsciberemail,'cc'=>'svkonekt@kuehne-nagel.com','bcc'=>'','subject'=>'CITY TRUCKS Email Subscription','module'=>'Email Subscription','user_id'=>'','message'=>'Dear User You have Successfully Activated Email News Letter Subscription');
				$this->load->library('sendemail');
				$this->sendemail->send_subscriptionMessage($d);
				$this->session->set_flashdata('success_msg', "Thank you for contact us. Your request has been sent successfully!");

			}
		}
		//redirect("welcome");
	}

	public function settings(){
		$userid = $this->session->userdata('user_id');
		if(isset($_POST)&&count($_POST)>0){
			foreach($_POST as $key=>$val){
				$data=array(
					"user_id"=>$userid,
					"setting_type_id"=>$key
				);
				$set=$this->db->where($data)->get("tb_user_settings");
				$data["setting_value"]=$val;
				if($set->num_rows()>0){
					$id=$set->row()->id;
					$this->db->where("id",$id)->update("tb_user_settings",$data);
				}else{
					$this->db->insert("tb_user_settings",$data);
				}
			}
		}
		$data["page_title"]="Dashboard";
		$data["sub_title"]="Settings";
		$data["setting_type"]=$this->db->query("select st.id,st.type_name,(select setting_value from tb_user_settings where setting_type_id=st.id and user_id=$userid limit 1) as setting_value from tb_user_setting_types st");
		$this->settemplate->dashboard("settings",$data);
	}

	// Chatbot logic
	public function getCustDefaultQuestions($bool = false)
	{
		$question_group = "1";
		$data = [];
		$date = date("d M h:i A");
		$user ="KN ETN";
		if(!$bool){
			$data["questons"][] = array("id"=>"", "text" => "Welcome to Svkonekt","date"=>$date,"user"=>$user);
			$data["questons"][] = array("id"=>"-1", "text" => "Before we get started, I just have a couple questions. Are you a current svkonekt customer? (Y/N)","date"=>$date,"user"=>$user,"intent"=>"user_info","parameter"=>"existing_user");
		}else{
			$data["questons"][] = array("id"=>"", "text" => "Thanks for sharing the details, how can I help u today?","date"=>$date,"user"=>$user);
			$questons = $this->db->select("id,question")->get_where("tb_default_questions",array("status"=>"1","question_group"=>$question_group,"parent_question_id"=>null));
			$cnt = $questons->result_array();
			foreach($cnt as $row){
				$data["questons"][] = array("id"=>$row['id'],"text" => $row['question'],"date"=>$date,"user"=>$user);
			}
		}
		echo json_encode($data);
	}

	// Chatbot mobile logic
	public function getDefaultQuestions()
	{
		$question_group = "1";
		$data = [];
		$date = date("d M h:i A");
		$user ="KN ETN";
		if(!$bool){
			$data["questons"][] = array("id"=>"", "text" => "Welcome to Svkonekt","date"=>$date,"user"=>$user);
			$data["questons"][] = array("id"=>"-1", "text" => "Before we get started, I just have a couple questions. Are you a current svkonekt customer? (Y/N)","date"=>$date,"user"=>$user,"intent"=>"user_info","parameter"=>"existing_user");
		}else{
			$data["questons"][] = array("id"=>"", "text" => "Thanks for sharing the details, how can I help u today?","date"=>$date,"user"=>$user);
			$questons = $this->db->select("id,question")->get_where("tb_default_questions",array("status"=>"1","question_group"=>$question_group,"parent_question_id"=>null));
			$cnt = $questons->result_array();
			foreach($cnt as $row){
				$data["questons"][] = array("id"=>$row['id'],"text" => $row['question'],"date"=>$date,"user"=>$user);
			}
		}
		echo json_encode($data);
	}
	public function userQuestion()
	{
		if(isset($_POST)){
			$text = $this->input->post("text");
			if($text != ""){
				$text = trim($text);
			}
			$date = $this->input->post("date");
			$user = $this->input->post("user");
			$parameter = $this->input->post("parameter");
			$intent = $this->input->post("intent");
			$question_id = $this->input->post("id");
			$data =[];
			if($this->isByeMessage($text)){
				$this->sendByeMessage();
			}else{
				if(strlen($intent)>0 && strlen($parameter)>0){
					if($intent == "orderInfo" && $parameter == "order_id"){
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN Admin";
						$row["id"] ="";
						$row["text"] =$this->getRecentStatus($text);
						$data["questons"][] = $row;
						echo json_encode($data);
					}else if($intent == "parties" && $parameter == "order_id"){
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN Admin";
						$row["id"] ="";
						$row["text"] =$this->involvedParties($text);
						$data["questons"][] = $row;
						echo json_encode($data);
					}else if($intent == "user_info"){
						$parts = explode("@", $parameter);
						$repeat = 0;
						if(count($parts) > 0){
							$parameter = $parts[0];
							if(count($parts) > 1){
								$repeat = $parts[1];
							}
						}
						$message = array("id"=>"-1", "text" => "Before we get started, I just have a couple questions. Are you a current svkonekt customer? (Y/N)","date"=>$date,"user"=>$user,"intent"=>"user_info","parameter"=>"existing_user");
						$ip = $this->input->ip_address();
						if($parameter == "existing_user"){
							$possibilities=["yes","y","no","n"];
							if(in_array(strtolower($text), $possibilities)){
								if(strtolower($text) == strtolower("Yes") || strtolower($text) == strtolower("Y")){
									$this->db->insert("tb_chatbot_users",array("ip_address"=>$ip,"existing_user"=>"Y"));
									$message["text"] = "Welcome back to svkonekt, can you provide your ID please?";
									$message["parameter"] = "id";
									$data["questons"][] = $message;
									echo json_encode($data);
								}else{
									$this->db->insert("tb_chatbot_users",array("ip_address"=>$ip,"existing_user"=>"N"));
									$message["text"] = "Thanks. What is your name?";
									$message["parameter"] = "name";
									$data["questons"][] = $message;
									echo json_encode($data);
								}
							}else if(!$this->isValidQuestion($text)){
								$repeat = $repeat + 1;
								$message["text"] = "Sorry, I didn't understand.";
								$message["parameter"] = "existing_user@$repeat";
								$data["questons"][] = $message;
								$message["text"] = "Say Yes / No";
								$data["questons"][] = $message;
								echo json_encode($data);
							}
						}else if($parameter == "name"){
							if(strlen(trim($text)) > 1){
								$queries = $this->db->query("SELECT id FROM tb_chatbot_users WHERE ip_address = '$ip' AND existing_user='N' AND timediff(now(), created_on) < '24:00:00' ORDER BY id desc");
								if($queries->num_rows()>0){
									$upd = $this->db->where("id",$queries->row()->id)->update("tb_chatbot_users",array("name"=>$text));
									$message["text"] = "For better communication for next time, could you please tell me your mail id?";
									$message["parameter"] = "email";
									$data["questons"][] = $message;
									echo json_encode($data);
								}else{
									$this->getCustDefaultQuestions();
								}
							}else if(strlen(trim($text)) <= 1){
								$repeat = $repeat + 1;
								$message["text"] = "May I know your correct name please?";
								$message["parameter"] = "name@$repeat";
								$data["questons"][] = $message;
								echo json_encode($data);
							}else{
								$repeat = $repeat + 1;
								$message["text"] = "May I know your name please?";
								$message["parameter"] = "name@$repeat";
								$data["questons"][] = $message;
								echo json_encode($data);
							}
						}else if($parameter == "id"){
							if(strlen(trim($text)) > 0){
								if($this->validUserId($text)){
									$queries = $this->db->query("SELECT * FROM tb_chatbot_users WHERE ip_address = '$ip' AND existing_user='Y' AND timediff(now(), created_on) < '24:00:00' ORDER BY id desc");
									if($queries->num_rows()>0){
										$upd = $this->db->where("id",$queries->row()->id)->update("tb_chatbot_users",array("name"=>$text));
										$this->getCustDefaultQuestions(true);
									}else{
										$this->getCustDefaultQuestions();
									}
								}else{
									$repeat = $repeat + 1;
									$message["text"] = "Your ID is invalid, Are you a current svkonekt customer? (Y/N)";
									$message["parameter"] = "existing_user@$repeat";
									$data["questons"][] = $message;
									echo json_encode($data);
								}
							}else{
								$repeat = $repeat + 1;
								$message["text"] = "Your ID is invalid, Are you a current svkonekt customer? (Y/N)";
								$message["parameter"] = "existing_user@$repeat";
								$data["questons"][] = $message;
								echo json_encode($data);
							}
						}else if($parameter == "email"){
							if(strlen(trim($text)) > 0 && $this->isValidEmail($text)){
								$queries = $this->db->query("SELECT * FROM tb_chatbot_users WHERE ip_address = '$ip' AND existing_user='N' AND timediff(now(), created_on) < '24:00:00' ORDER BY id desc");
								if($queries->num_rows()>0){
									$upd = $this->db->where("id",$queries->row()->id)->update("tb_chatbot_users",array("email"=>$text));
									$message["text"] = "What company do you work for?";
									$message["parameter"] = "company";
									$data["questons"][] = $message;
									echo json_encode($data);
								}else{
									$this->getCustDefaultQuestions();
								}
							}else{
								if($repeat == 2){
									$this->getCustDefaultQuestions(true);
								}else{
									$repeat = $repeat + 1;
									$message["text"] = "This email format seems wrong, plz enter correct email?";
									$message["parameter"] = "email@$repeat";
									$data["questons"][] = $message;
									echo json_encode($data);
								}
							}
						}else if($parameter == "company"){
							if(strlen(trim($text)) > 0){
								$queries = $this->db->query("SELECT * FROM tb_chatbot_users WHERE ip_address = '$ip' AND existing_user='N' AND timediff(now(), created_on) < '24:00:00' ORDER BY id desc");
								if($queries->num_rows()>0){
									$upd = $this->db->where("id",$queries->row()->id)->update("tb_chatbot_users",array("company"=>$text));
									$this->getCustDefaultQuestions(true);
								}else{
									$this->getCustDefaultQuestions();
								}
							}else{
								if($repeat == 2){
									$this->getCustDefaultQuestions(true);
								}else{
									$repeat = $repeat + 1;
									$message["text"] = "This email format seems wrong, plz enter correct email?";
									$message["parameter"] = "email@$repeat";
									$data["questons"][] = $message;
									echo json_encode($data);
								}
							}
						}
					}else{
						$this->sendSorry();
					}
				}else{
					if(!$this->isValidQuestion($text)){
					    $this->sendSorry();
					}
				}
			}
		}
	}
	public function isValidQuestion($text){
	    $result = sendchatbotmsgservice($text);
		if($this->isJson($result)){
			$array = json_decode($result,TRUE);
			if(isset($array["entities"]) && count($array["entities"])>0 && isset($array["entities"]["intent"]) && count($array["entities"]["intent"])>0){
				$intent = $array["entities"]["intent"][0]["value"];
				if($intent == "orderInfo"){
					$data = [];
					if(isset($array["entities"]["order_id"]) && count($array["entities"]["order_id"])>0){
						$order_id = $array["entities"]["order_id"][0]["value"];
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN ETN";
						$row["id"] ="";
						$row["text"] =$this->getRecentStatus($order_id);
						$data["questons"][] = $row;
						echo json_encode($data);
						return true;
					}else{
						return false;
					}
				}else if($intent == "parties"){
					$data = [];
					if(isset($array["entities"]["order_id"]) && count($array["entities"]["order_id"])>0){
						$order_id = $array["entities"]["order_id"][0]["value"];
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN ETN";
						$row["id"] ="";
						$row["text"] =$this->involvedParties($order_id);
						$data["questons"][] = $row;
						echo json_encode($data);
						return true;
					}else{
						return false;
					}
				}else if($intent == "orders"){
					$data = [];
				// 	if(isset($array["entities"]["party_name"]) && count($array["entities"]["party_name"])>0){
				// 		$party_name = $array["entities"]["party_name"][0]["value"];
				// 		$from = @$array["entities"]["from_location"][0]["value"];
				// 		$to = @$array["entities"]["to_location"][0]["value"];
				// 		$date = @$array["entities"]["date_on"][0]["value"];
				// 		$row["date"] = date("d M h:i A");
				// 		$row["user"] ="KN ETN";
				// 		$row["id"] ="";
				// 		$row["text"] =$this->involvedOrders($party_name,$from,$to,$date);
				// 		$data["questons"][] = $row;
				// 		echo json_encode($data);
				// 		return true;
				// 	}else{
				// 		return false;
				// 	}
				    $party_name = @$array["entities"]["party_name"][0]["value"];
					$from = @$array["entities"]["from_location"][0]["value"];
					$to = @$array["entities"]["to_location"][0]["value"];
					$date = @$array["entities"]["date_on"][0]["value"];
					$row["date"] = date("d M h:i A");
					$row["user"] ="KN ETN";
					$row["id"] ="";
					$row["text"] =$this->involvedOrders($party_name,$from,$to,$date);
					$data["questons"][] = $row;
					echo json_encode($data);
					return true;
				}else if($intent == "shipper_info"){
					$data = [];$entval = array(); $botquery = "";
					$getdata = $this->db->select("entity_name")->get_where("tb_chatbot_querytypes",array("question_type"=>"general","status"=>1));
					if($getdata->num_rows() > 0){
						foreach($getdata->result() as $rs){
							$entval = isset($array["entities"][$rs->entity_name]) ? $array["entities"][$rs->entity_name] : array();
							$botquery = $rs->entity_name;
							$cb = isset($entval[0]['value']) ? $entval[0]['value'] : "";
							if(!empty($entval) && strlen($cb) > 10){
								$botquery = $rs->entity_name;
								break;
							}
						}
					}
					if(!empty($entval)){
						$ans = $entval[0]["value"];
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN ETN";
						$row["id"] ="";
						if($ans == "" || strlen($ans) <= 10){
							$ans = $this->shipperplatform($botquery);
						}
						$row["text"] = $ans;
						$data["questons"][] = $row;
						echo json_encode($data);
						return true;
					}else{
						return false;
					}
				}else if($intent == "greetings"){
					$data = [];$entval = array(); $botquery = "";
					$getdata = $this->db->select("entity_name")->get_where("tb_chatbot_querytypes",array("question_type"=>"greetings","status"=>1));
					if($getdata->num_rows() > 0){
						foreach($getdata->result() as $rs){
							$entval = isset($array["entities"][$rs->entity_name]) ? $array["entities"][$rs->entity_name] : array();
							$botquery = $rs->entity_name;
							$cb = isset($entval[0]['value']) ? $entval[0]['value'] : "";
							if(!empty($entval) && strlen($cb) > 10){
								$botquery = $rs->entity_name;
								break;
							}
						}
					}
					if(!empty($entval)){
						$ans = $entval[0]["value"];
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN ETN";
						$row["id"] ="";
						if($ans == "" || strlen($ans) <= 10){
							$ans = $this->greetingsplatform($botquery);
						}
						$row["text"] = $ans;
						$data["questons"][] = $row;
						echo json_encode($data);
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}else{
				if(isset($array["entities"]) && count($array["entities"])>0){
					$data = [];$entval = array(); $botquery = "";
					$getdata = $this->db->query("SELECT entity_name FROM tb_chatbot_querytypes WHERE (question_type='general' OR question_type='greetings') AND status=1");
					if($getdata->num_rows() > 0){
						foreach($getdata->result() as $rs1){
							$entval = isset($array["entities"][$rs1->entity_name]) ? $array["entities"][$rs1->entity_name] : array();
							$botquery = $rs1->entity_name;
							$cb = isset($entval[0]['value']) ? $entval[0]['value'] : "";
							if(!empty($entval) && strlen($cb) > 10){
								$botquery = $rs1->entity_name;
								break;
							}
						}
					}
					if(!empty($entval)){
						$ans = $entval[0]["value"];
						$row["date"] = date("d M h:i A");
						$row["user"] ="KN ETN";
						$row["id"] ="";
						if($ans == "" || strlen($ans) <= 10){
							$ans = $this->shipperplatform($botquery);
						}
						$row["text"] = $ans;
						$data["questons"][] = $row;
						echo json_encode($data);
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			}
		}else{
			return false;
		}
	}
	public function sendByeMessage()
	{
		$user ="KN Admin";
		$date = date("d M h:i A");
		$data["questons"][] = array("id"=>"", "text" => "Thanks, Hope I have helped you with queries. Bye!","date"=>$date,"user"=>$user);
		echo json_encode($data);
	}
	public function isByeMessage($value='')
	{
		$list = array("bye","good bye","see you later","thanks");
		return in_array(strtolower(trim($value)), $list);

	}

	function isValidEmail($email){
	    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
	}

	public function validUserId($value='')
	{
		if($value != ""){
			$value = trim($value);
	        $chkcust = $this->db->query("SELECT id FROM tb_customers WHERE (phone='".$value."' OR code='".$value."') LIMIT 1");
	        if($chkcust->num_rows()>0){
	        	return true;
	        }else{
	        	$cust = $this->db->query("SELECT id,name,countrycode,parent_id,user_id FROM tb_customer_logins WHERE (code='".$value."' OR cust_id='".$value."') LIMIT 1");
	            if ($cust->num_rows() > 0) {
	            	return true;
	            }else{
	            	return false;
	            }
	        }
	    }else{
	    	return false;
	    }
	}

	public function shipperplatform($value='')
	{
		$msg = "Please ask us your required question!";
		if($value != ""){
			$qry = $this->db->query("SELECT id,answer FROM tb_chatbot_querytypes WHERE question_type='general' AND question LIKE '%".$value."%' AND intent_name='shipper_info'");
            if ($qry->num_rows() > 0) {
            	foreach($qry->result() as $rs){
            		$msg1 .= $rs->answer."<br/>";
            	}
                $msg = $msg1;
            }else{
            	$msg = "No information found!";
            }
		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}

	public function greetingsplatform($value='')
	{
		$msg = "Please ask us your required question!";
		if($value != ""){
			$qry = $this->db->query("SELECT id,answer FROM tb_chatbot_querytypes WHERE question_type='greetings' AND question LIKE '%".$value."%' AND intent_name='greetings'");
            if ($qry->num_rows() > 0) {
            	foreach($qry->result() as $rs){
            		$msg1 .= $rs->answer."<br/>";
            	}
                $msg = $msg1;
            }else{
            	$msg = "No information found!";
            }
		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}

	/*mobile app */
	public function chatbotuserQuestion()
	{
	    $this->userQuestion();
		/*if(isset($_POST)){
			$text = $this->input->post("text");
			$date = $this->input->post("date");
			$user = $this->input->post("user");
			$parameter = $this->input->post("parameter");
			$intent = $this->input->post("intent");
			$question_id = $this->input->post("id");
			if(strlen($intent)>0 && strlen($parameter)>0){
				if($intent == "orderInfo" && $parameter == "order_id"){
					$row["date"] = date("d M h:i A");
					$row["user"] ="KN Admin";
					$row["id"] ="";
					$row["text"] =$this->getAppRecentStatus($text);
					$data["questons"][] = $row;
					echo json_encode($data);
				}else if($intent == "parties" && $parameter == "order_id"){
					$row["date"] = date("d M h:i A");
					$row["user"] ="KN Admin";
					$row["id"] ="";
					$row["text"] =$this->involvedPartiesApp($text);
					$data["questons"][] = $row;
					echo json_encode($data);
				}else{
					$this->sendSorry();
				}
			}else{
				$result = sendchatbotmsgservice($text);
				if($this->isJson($result)){
					$array = json_decode($result,TRUE);
					if(isset($array["entities"]) && count($array["entities"])>0 && isset($array["entities"]["intent"]) && count($array["entities"]["intent"])>0){
						$intent = $array["entities"]["intent"][0]["value"];
						if($intent == "orderInfo"){
							$data = [];
							if(isset($array["entities"]["order_id"]) && count($array["entities"]["order_id"])>0){
								$order_id = $array["entities"]["order_id"][0]["value"];
								$row["date"] = date("d M h:i A");
								$row["user"] ="KN Admin";
								$row["id"] ="";
								$row["text"] =$this->getAppRecentStatus($order_id);
								$data["questons"][] = $row;
								echo json_encode($data);
							}else{
								$this->sendSorry();
							}
						}else if($intent == "parties"){
							$data = [];
							if(isset($array["entities"]["order_id"]) && count($array["entities"]["order_id"])>0){
								$order_id = $array["entities"]["order_id"][0]["value"];
								$row["date"] = date("d M h:i A");
								$row["user"] ="KN Admin";
								$row["id"] ="";
								$row["text"] =$this->involvedPartiesApp($order_id);
								$data["questons"][] = $row;
								echo json_encode($data);
							}else{
								$this->sendSorry();
							}
						}else if($intent == "shipper_info"){
							$data = [];
							if(isset($array["entities"]["shipper_platform"]) && count($array["entities"]["shipper_platform"])>0){
								//$platform = $array["entities"]["platform"][0]["value"];
								$row["date"] = date("d M h:i A");
								$row["user"] ="KN Admin";
								$row["id"] ="";
								$row["text"] = "svkonekt seamlessly connects carriers and shipppers on a single, easy-to-use platform. For shippers, if you need a truck to move a shipment from A to B"; //$this->involvedParties($platform);
								$data["questons"][] = $row;
								echo json_encode($data);
							}else if(isset($array["entities"]["type_of_shipper"]) && count($array["entities"]["type_of_shipper"])>0){
								//$platform = $array["entities"]["platform"][0]["value"];
								$row["date"] = date("d M h:i A");
								$row["user"] ="KN Admin";
								$row["id"] ="";
								$row["text"] = "It doesnot matter if you are a global company shipping thousands of loads a day or a local manufacturer shipping a few loads a week, the svkonekt platform will take care of your cargo transportation needs. We've got you covered."; //$this->involvedParties($platform);
								$data["questons"][] = $row;
								echo json_encode($data);
							}else{
								$this->sendSorry();
							}
						}else{
							$this->sendSorry();
						}
					}else{
						$this->sendSorry();
					}
				}else{
					$this->sendSorry();
				}
			}
		}*/
	}

	public function messageClick()
	{
		if(isset($_POST)){
			$id = $this->input->post("id");
			$questons = $this->db->select("id,question as text,intent,parameter")->get_where("tb_default_questions",array("status"=>"1","parent_question_id"=>$id));
			foreach($questons->result_array() as $row){
				$row["date"] = date("d M h:i A");
				$row["date"] = date("d M h:i A");
				$row["user"] ="KN Admin";
				$data["questons"][] = $row;
			}
			echo json_encode($data);
		}
	}
	/*mobile app */
	public function msgClick()
	{
		if(isset($_POST)){
			$id = $this->input->post("id");
			$questons = $this->db->select("id,question as text,intent,parameter")->get_where("tb_default_questions",array("status"=>"1","parent_question_id"=>$id));
			foreach($questons->result_array() as $row){
				$row["date"] = date("d M h:i A");
				$row["date"] = date("d M h:i A");
				$row["user"] ="KN Admin";
				$data["questons"][] = $row;
			}
			echo json_encode($data);
		}
	}

	public function getRecentStatus($value='')
	{
		$msg = "Please enter your order number!";
		$curtz = "Asia/Kolkata";
		if($value != ""){
			$qry = $this->db->query("SELECT s.stop_type,s.status_id,s.latitude,s.longitude,convertToClientTZ(s.createdon,'".$curtz."') as createdon,m.status_name FROM tb_stop_status s,tb_status_master m,tb_employee e WHERE s.status_id=m.id AND s.shipment_id=e.shift_id AND (e.order_id='".$value."' OR e.assoc_id='".$value."') ORDER BY s.createdon DESC LIMIT 1");
            if ($qry->num_rows() > 0) {
            	$res = $qry->row();
                $placename = getLocationName($res->latitude, $res->longitude);
                $status_name = $res->status_name;
                if($res->status_id == 1 && $res->stop_type == "P"){
                	$status_name = "Pickup Done";
                }else if($res->status_id == 1 && $res->stop_type == "D"){
                	$status_name = "Delivery Done";
                }else if($res->status_id == 2 && $res->stop_type == "P"){
                	$status_name = "Pickup ".$status_name;
                }else if($res->status_id == 2 && $res->stop_type == "D"){
                	$status_name = "Delivery ".$status_name;
                }else if($res->status_id == 3 && $res->stop_type == "P"){
                	$status_name = "Pickup ".$status_name;
                }else if($res->status_id == 3 && $res->stop_type == "D"){
                	$status_name = "Delivery ".$status_name;
                }else if($res->status_id == 4){
                	$status_name = $status_name;
                }else if($res->status_id == 9){
                	$status_name = $status_name;
                }else if($res->status_id == 10){
                	$status_name = $status_name;
                }
                /*$data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));*/
                $msg1 = "Recent status for ORDER #$value is <b>".$status_name."</b> <br/>";
                $msg1 .= "<b style='color:#3c8dbc'>Order Details:</b><br/>";
                $msg1 .= "<b>Current Location:</b> ".$placename."<br/>";
                $msg1 .= "<b>Time:</b> ".date("d/M/Y H:i A",strtotime($res->createdon));
                $msg = $msg1;
            }else{
            	$msg = "No Order #$value found in system";
            }

		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}

	public function getAppRecentStatus($value='')
	{
		$msg = "Please enter your order number!";
		$curtz = "Asia/Kolkata";
		if($value != ""){
			$qry = $this->db->query("SELECT s.stop_type,s.status_id,s.latitude,s.longitude,convertToClientTZ(s.createdon,'".$curtz."') as createdon,m.status_name FROM tb_stop_status s,tb_status_master m,tb_employee e WHERE s.status_id=m.id AND s.shipment_id=e.shift_id AND (e.order_id='".$value."' OR e.assoc_id='".$value."') ORDER BY s.createdon DESC LIMIT 1");
            if ($qry->num_rows() > 0) {
            	$res = $qry->row();
                $placename = getLocationName($res->latitude, $res->longitude);
                $status_name = $res->status_name;
                if($res->status_id == 1 && $res->stop_type == "P"){
                	$status_name = "Pickup Done";
                }else if($res->status_id == 1 && $res->stop_type == "D"){
                	$status_name = "Delivery Done";
                }else if($res->status_id == 2 && $res->stop_type == "P"){
                	$status_name = "Pickup ".$status_name;
                }else if($res->status_id == 2 && $res->stop_type == "D"){
                	$status_name = "Delivery ".$status_name;
                }else if($res->status_id == 3 && $res->stop_type == "P"){
                	$status_name = "Pickup ".$status_name;
                }else if($res->status_id == 3 && $res->stop_type == "D"){
                	$status_name = "Delivery ".$status_name;
                }else if($res->status_id == 4){
                	$status_name = $status_name;
                }else if($res->status_id == 9){
                	$status_name = $status_name;
                }else if($res->status_id == 10){
                	$status_name = $status_name;
                }
                /*$data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));*/
                $msg1 = "Recent status for ORDER #$value is ".$status_name;
                $msg1 .= " Order Details: ";
                $msg1 .= " Current Location: ".$placename;
                $msg1 .= " Time: ".date("d/M/Y H:i A",strtotime($res->createdon));
                $msg = $msg1;
            }else{
            	$msg = "No Order #$value found in system";
            }

		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}

	public function involvedParties($value='')
	{
		$msg = "Please enter your order number!";
		if($value != ""){
			$qry = $this->db->query("SELECT p.id,p.name,t.name as partytype FROM tb_order_parties s,tb_employee e,tbl_party_master p,tbl_party_types t WHERE s.order_number=e.order_id AND s.party_id=p.id AND p.party_type_id=t.id AND (e.order_id='".$value."' OR e.assoc_id='".$value."') GROUP BY p.id");
            if ($qry->num_rows() > 0) {
            	$msg1 = "Involved parties for ORDER #$value are: <br/>";
            	foreach($qry->result() as $rs){
            		$msg1 .= $rs->name." - ".$rs->partytype."<br/>";
            	}
                $msg = $msg1;
            }else{
            	$msg = "No Party found for ORDER #$value";
            }
		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}

	public function involvedPartiesApp($value='')
	{
		$msg = "Please enter your order number!";
		if($value != ""){
			$qry = $this->db->query("SELECT p.id,p.name,t.name as partytype FROM tb_order_parties s,tb_employee e,tbl_party_master p,tbl_party_types t WHERE s.order_number=e.order_id AND s.party_id=p.id AND p.party_type_id=t.id AND (e.order_id='".$value."' OR e.assoc_id='".$value."') GROUP BY p.id");
            if ($qry->num_rows() > 0) {
            	$msg1 = "Involved parties for ORDER #$value are: ";
            	foreach($qry->result() as $rs){
            		$msg1 .= $rs->name." - ".$rs->partytype;
            	}
                $msg = $msg1;
            }else{
            	$msg = "No Party found for ORDER #$value";
            }
		}else{
			$msg = "Please enter your order number!";
		}
		return $msg;
	}
	public function involvedOrders($value='',$from="",$to="",$date="")
	{
		$msg = "$value has no orders";
		$whr = "";
		if($value != ""){
			$whr .= "AND pm.name like '%$value%'";
		}
		if($from != ""){
			$whr .= " AND (pickup_company like '%$from%' OR pickup_country like '%$from%' OR pickup_city like '%$from%' OR pickup_pincode like '%$from%' OR pickup_address1 like '%$from%' OR pickup_address2 like '%$from%')";
		}
		if($to != ""){
			$whr .= " AND (delivery_company like '%$to%' OR delivery_country like '%$to%' OR delivery_city like '%$to%' OR delivery_pincode like '%$to%' OR delivery_address1 like '%$to%' OR delivery_address2 like '%$to%')";
		}
		if($date != ""){
			$date = date("Y-m-d",strtotime($date));
			$whr .= " AND (pickup_datetime like '%$date%' OR delivery_datetime like '%$date%')";
		}
		if($whr != ""){
			$query = "SELECT op.order_number FROM tb_order_parties op,tbl_party_master pm,tb_orders o WHERE op.party_id = pm.id AND op.status='1' AND op.order_id=o.id $whr group by op.order_number order by op.id desc";
			$count = $this->db->query($query)->num_rows();
			$qry = $this->db->query("$query limit 3");
	        if ($qry->num_rows() > 0) {
	        	$msg1 = "$value involved orders are: ";
	        	foreach($qry->result() as $rs){
	        		$msg1 .= $rs->order_number.", ";
	        	}
	            $msg = $msg1."<br>$value has ".$count." orders found!";
	        }
	    }
		return $msg;
	}
	public function sendSorry()
	{
		$message["questons"] = [];
		$message["questons"][] = array("id"=>"", "text" => "I am sorry I don't understand, please ask something else", "user" => "KN ETN", "date" => date("d M h:i A"));
		echo json_encode($message);
	}

	public function etnlmvchatbot(){
		$data = array();
		$this->load->view("etnlmv_chatbot",$data);
	}

	public function etnchatbot(){
		$data = array();
		$this->load->view("kn_chatbot",$data);
	}

	function isJson($string) {
	    $decoded = json_decode($string);
	    if ( !is_object($decoded) && !is_array($decoded) ) {
	        return false;
	    }
	    return (json_last_error() == JSON_ERROR_NONE);
	}
}

