<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class XBRDRorders extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['Order','common','trips_model']);
        $this->load->library(['email','form_validation','statusintigration','crossborderlib']);
        $this->load->helper('user_helper');
    }
 public function index($id =null)
    {
        if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code'))) {
            redirect('SmtcXBRDRorders');
        }
        if (!checkUrlAccessForUser('XBRDRORDERS')) {
            redirect("Forbiddenaccess");
        }
        if($id != ""){
            $this->orderslist($id);
        }else{
            $this->orderslist();
        }
    }
    public function orderslist($id = null){
        if (!checkUrlAccessForUser('XBRDRORDERS')) {
            redirect("Forbiddenaccess");
        }
        $data['page_title'] = $this->lang->line('xborder');
        $data['sub_title']  = $this->lang->line('menu_orders');
        $order              = $country_userids = array();
        $userid             = $this->session->userdata("user_id");
        $custid             = $this->session->userdata("cust_id");
        $country_userids    = $this->session->userdata("country_user_ids");
        $notificationCount = xborderCount();
        $data['count'] = $notificationCount[0]['count'] ?? 0;
        if ($data['count'] > 0) {
            $orderIds = $notificationCount[0]['order_id'];
            $orderIds = explode(",", $orderIds);

            $data['xborderData'] = $this->Order->getXborderNotificationData($orderIds);
        }
        $this->load->view("xborder/modal", $data);
        $data['userRoleId'] = $this->session->userdata('user_role_id');
        $whr = $searchids = array();
        $post = array();
        if($id != ""){
            $searchids = array($id);
            $post['bookingid'] = array();
            $getbooking_id = $this->common->gettblrowdata(array('id'=>$id),"order_id","tb_orders",0,0);
            if(!empty($getbooking_id)){
                $post['bookingid'] = array($getbooking_id['order_id']);
            }
            $data['getbookingid'] = $this->db->escape_str($post['bookingid']);
        }
        $subcust = $this->session->userdata('sub_cust');
        $status_search = "";
        if (isset($_POST['searchsubmit']) && $this->input->post('searchsubmit',TRUE) == "Search") {
            $post = $this->input->post(NULL,TRUE);
        }
        if (!empty($post)) {
            $whr = $this->searchorders($post);
            $order_status = isset($post['status']) ? $this->db->escape_str($post['status']) : "";
            $status_search = $order_status;
            $searchids1 = isset($post['bookingid']) ? $this->db->escape_str($post['bookingid']) : array();
            $company_code = $this->session->userdata('company_code');
            $orderids = $bookingids = [];
            if (empty($searchids1)) {
                $getXborder = $this->common->gettbldata(['ref_value' => $company_code,'reference_id'=>'XBRDR', 'status' => '1'], 'order_id', 'tb_order_references', 0, 0);
                foreach ($getXborder as $eachRow) {
                    $orderids[] = $eachRow['order_id'];
                }
            }

            if(!empty($orderids)){
                $this->db->select("order_id");
                $this->db->from("tb_orders");
                $this->db->where_in("id",$orderids);
                $this->db->where('status !=',0);
                $getbookingids =  $this->db->get();
                if($getbookingids->num_rows() >0){
                    foreach ($getbookingids->result() as $res) {
                        $bookingids[] = $res->order_id;
                    }
                }
            }
            $searchids = array_merge($searchids1,$bookingids);
            $response = $this->Order->getxborderorderdata($searchids,$status_search,$whr);
            $orderdata = $response['orders'] ?? [];
            $tripsdata = $response['trips'] ?? [];
            if (!empty($orderdata)) {
                foreach ($orderdata as $res) {
                    $delivery_note = $container_no = "";
                    $shipmentid = $res['shipment_id'];
                    $trip_no = $res['shipmentid'];
                    if($trip_no == '0'){
                        $trip_no = "";
                    }
                    $shift_id = $res['shift_id'];
                    $trip_sts = $res['trip_sts'];
                    $otherstatus = $res['order_status'];
                    $trip_id = $res['trip_id'];
                    $order_status = 'PENDING';
                    if($trip_id != 0 && $trip_sts == 0){
                        $order_status = 'ACTIVE';
                    }
                    if($trip_id != 0 && $trip_sts == 1){
                        $order_status = 'CLOSED';
                    }
                    if ($order_status == 'PENDING') {
                        $orderIndex = $res['order_id'];
                        if (isset($tripsdata[$orderIndex])) {
                            $tripno = $tripsdata[$orderIndex]['trip_no'];
                            if ($tripno > 0) {
                                if ($trip_sts == 1) {
                                    $order_status = 'CLOSED';
                                } else {
                                    $order_status = 'ACTIVE';
                                }
                            }
                        }
                    }
                    $otherstatus = strtoupper($res['order_status']);
                        if($otherstatus == ""){
                        $chkdetails = $this->db->select("order_status")->get_where("tb_order_details",array('order_row_id'=>$res['id']));
                        if($chkdetails->num_rows() >0){
                            $otherstatus = $chkdetails->row()->order_status;
                        }
                    }
                    if($otherstatus == 'READY'){
                        $otherstatus = 'READY';
                    }else if($otherstatus == 'INVOICE'){
                        $otherstatus = 'INVOICE';
                    }else{
                        $otherstatus = "";
                    }
                    $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE
                                                           order_id =? AND reference_id IN ('DQ','CTR')",[$res['id']]);
                    if($getdnote->num_rows() >0){
                        foreach($getdnote->result() as $ref){
                            $ref_id = $ref->reference_id;
                            if($ref_id == "DQ"){
                                $delivery_note = $ref->ref_value;
                            }
                            if($ref_id == "CTR"){
                                $container_no = $ref->ref_value;
                            }
                        }
                    }
                    $chkdate = '2020-07-01 00:00:00';
                    $createdon = $res['createdon'];
                    $order_str = strtotime($createdon);
                    $chk_str = strtotime($chkdate);
                    $early_pickup = $res['pickup_datetime'];
                    $early_delivery = $res['delivery_datetime'];
                    $curtz = $this->session->userdata("usr_tzone")['timezone'];
                    if($order_str > $chk_str){
                        if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                            $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                            $early_pickup = $epickup['datetime'];
                        }
                        if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                            $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                            $early_delivery = $edelivery['datetime'];
                        }
                    }
                    $order[] = array('order_row_id' => $res['id'], 'order_id' => $res['order_id'], 'delivery_note' => $delivery_note, 'pickup' => $res['pickup'], 'delivery' => $res['delivery'], 'trip_no' => $trip_no, 'order_status' => $order_status, 'transport_mode' => $res['transport_mode'], 'createdon' => $res['createdon'], 'total_packages' => round($res['totqty']), 'weight' => $res['totwg'], 'volume' => $res['totvol'], 'company_code' => $res['company_code'], 'branch_code' => $res['branch_code'], 'department_code' => $res['department_code'],'otherstatus'=>$otherstatus,'delivery_date'=>$early_delivery,'pickup_date'=>$early_pickup,'container_no'=>$container_no);
                }
            }
        }
        $data['order']          = $order;
        $this->newtemplate->dashboard("xborder/order", $data);
    }
    public function searchorders($post)
    {
        $whr = array();
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
			$post_fromdate = $this->db->escape_str($post['fromdate']);
            $fromdate = date('Y-m-d', strtotime($post_fromdate));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;

        }
        if (isset($post['todate']) && $post['todate'] != "") {
			$post_todate = $this->db->escape_str($post['todate']);
            $todate = date('Y-m-d', strtotime($post_todate));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }
        if (isset($post['order_id']) && $post['order_id'] != "") {
            $whr['o.order_id'] = $this->db->escape_str($post['order_id']);

        }
        if (isset($post['searchcustomer_id']) && $post['searchcustomer_id'] != "") {
            $getcustomer_id = $this->db->select("id")->get_where("tb_customers",array('code'=>$post['searchcustomer_id']));
            if($getcustomer_id->num_rows() >0){
                $whr['o.customer_id'] = $getcustomer_id->row()->id;
            }


        }
        if (isset($post['service']) && $post['service'] != "") {
            $whr['d.service'] = $this->db->escape_str($post['service']);

        }
        if (isset($post['order_type']) && $post['order_type'] != "") {
            $whr['d.order_type'] = $this->db->escape_str($post['order_type']);

        }
        if (isset($post['product']) && $post['product'] != "") {
            $whr['o.product'] = $this->db->escape_str($post['product']);

        }
        if (isset($post['modeof_trasnport']) && $post['modeof_trasnport'] != "") {
            $whr['o.transport_mode'] = $this->db->escape_str($post['modeof_trasnport']);

        }
        if (isset($post['searchshipper_id']) && $post['searchshipper_id'] != "") {
            $whr['o.pickup_custid'] = $this->db->escape_str($post['searchshipper_id']);

        }
        if (isset($post['searchconsignee_id']) && $post['searchconsignee_id'] != "") {
            $whr['o.drop_custid'] = $this->db->escape_str($post['searchconsignee_id']);

        }
        if (isset($post['delivery_note']) && $post['delivery_note'] != "") {
			$post_delivery_note = $this->db->escape_str($post['delivery_note']);
            $getdelivery_noteid = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$post_delivery_note, 'status'=>'1','reference_id'=>'DQ'));
            if($getdelivery_noteid->num_rows() >0){
                $order_id = $getdelivery_noteid->row()->order_id;
                $whr['o.id'] = $order_id;
            }
        }
        if (isset($post['container_no']) && $post['container_no'] != "") {
			$post_container_no = $this->db->escape_str($post['container_no']);
            $getcontainer_no = $this->db->select("order_id")->get_where("tb_order_references",array('ref_value'=>$post_container_no, 'status'=>'1','reference_id'=>'CTR'));
            if($getcontainer_no->num_rows() >0){
                $order_id = $getcontainer_no->row()->order_id;
                $whr['o.id'] = $order_id;
            }else{
                $whr['o.id'] = '0';
            }
        }
        if (isset($post['purchase_order']) && $post['purchase_order'] != "") {
            $whr['d.purchase_order'] = $this->db->escape_str($post['purchase_order']);

        }
        if (isset($post['company_code']) && $post['company_code'] != "") {
            $whr['o.company_code'] = $this->db->escape_str($post['company_code']);

        }
        if (isset($post['branch_code']) && $post['branch_code'] != "") {
            $whr['o.branch_code'] = $post['branch_code'];

        }
        if (isset($post['from_date']) && $post['from_date'] != "") {
			$post_from_date = $this->db->escape_str($post['from_date']);
            $from_date = date('Y-m-d', strtotime($post_from_date));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $from_date;

        }
        if (isset($post['todate']) && $post['todate'] != "") {
			$post_todate = $this->db->escape_str($post['todate']);
            $todate = date('Y-m-d', strtotime($post_todate));
            $whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

        }
        return $whr;

    }

    public function neworder()
    {
        $data             = $transport             = array();
        $user_id          = $this->session->userdata('user_id');
        $company_code     = $this->session->userdata('company_code');
        $branch_code      = $this->session->userdata('branch_code');
        if($company_code == 'RUKN'){
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = array('code' => $res->code, 'name' => $res->name);
                }
            }
        }else{
             $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = array('code' => $res->code, 'name' => $res->name);
                }
            }
        }
        $data['transport']    = $transport;
        $data['company_code'] = $company_code;
        $data['branch_code']  = $branch_code;
        $pickup_details       = array();
        $custid               = $this->session->userdata('cust_id');
        $ordertypes             = array();
        if ($custid != "") {
            $getpickupdetails = $this->Order->getpickupdetails($custid);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $getorders = $this->db->select("id,type_name")->get_where("tb_order_types", array('customer_id' => $custid,'company_code'=>$company_code,'status'=>'1'));
            if ($getorders->num_rows() > 0) {
                foreach ($getorders->result() as $res) {
                    $ordertypes[] = array('type_id' => $res->id, 'type_name' => $res->type_name);
                }
            }else{
                $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>$company_code,"status"=>1));
                if($getorders->num_rows() >0){
                  foreach($getorders->result() as $res){
                    $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
                }
            }else{
              $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
              if($getorders->num_rows() >0){
                foreach($getorders->result() as $res){
                  $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
              }
          }
      }
  }
}else{

    $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>$company_code,"status"=>1));
    if($getorders->num_rows() >0){
      foreach($getorders->result() as $res){
        $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
    }
}else{
  $getorders = $this->db->select("id,type_name")->group_by("type_name")->get_where("tb_order_types",array('company_code'=>"SGKN","status"=>1));
  if($getorders->num_rows() >0){
    foreach($getorders->result() as $res){
      $ordertypes[] = array('type_id'=>$res->id,'type_name'=>$res->type_name);
  }
}
}

}
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
 $data['pickup_details'] = $pickup_details;
$data['ordertypes'] = $ordertypes;
$data['roles'] = $roles;
$this->newtemplate->dashboard('xborder/neworder', $data);
}

public function copyorder($id = null)
{
    $data          = $order_types          = array();
    $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = $delivery_array = $chargecodes = array();

    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->Order->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='".$id."' AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR')");
            if($getdnote->num_rows() >0){
                foreach($getdnote->result() as $ref){
                    $ref_id = $ref->reference_id;
                    if($ref_id == 'DQ'){
                        $shipment_id = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_DLVINST'){
                        $delivery_inst = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_PIKINST'){
                        $pickup_inst = $ref->ref_value;
                    }
                    if($ref_id == 'CTR'){
                        $container_no = $ref->ref_value;
                    }

                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status        = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;
            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array('id' => $chkorder->row()->id, 'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'service' => $chkorder->row()->service, 'delivery_term' => $chkorder->row()->delivery_term, 'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $chkorder->row()->purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode,'container_no'=>$container_no);
            $order_details['order_status'] = $order_status;
            if ($incoterm != '') {
                $delivery_array = getDeliverytermsbyIncoterm($incoterm);
            }
            $pickup_id    = $chkorder->row()->customer_id;
            $company_code = $this->session->userdata('company_code');
            if ($company_code != "") {
                $company_code = $chkorder->row()->company_code;
            }
            $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                }
            }
            $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $party_row_ids = array();
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
              foreach($chekparty->result() as $rr){

                $ptype = $rr->party_type;
                $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                if($chktype->num_rows()>0){
                  if($chktype->row()->name == "Consignee"){
                    $drop_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
                }else if($chktype->row()->name == "Shipper"){
                   $shipper_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
               }else{
                   $party_row_ids[] = $rr->id;
               }
           }
       }
   }
   $shipper_details['name'] = $chkorder->row()->pickup;
   $shipper_details['street'] = $chkorder->row()->pickup_address1;
   $shipper_details['state'] = $chkorder->row()->pickup_address2;
   $shipper_details['city'] = $chkorder->row()->pickup_city;
   $shipper_details['country'] = $chkorder->row()->pickup_country;
   $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

   $drop_details['name'] = $chkorder->row()->delivery;
   $drop_details['street'] = $chkorder->row()->delivery_address1;
   $drop_details['state'] = $chkorder->row()->delivery_address2;
   $drop_details['city'] = $chkorder->row()->delivery_city;
   $drop_details['country'] = $chkorder->row()->delivery_country;
   $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
   $drop_id = $chkorder->row()->drop_custid;
}

$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {
        $stackable = 'Off';
        if ($res->stackable == 0) {
            $stackable = 'Off';
        } else if ($res->stackable == 1) {
            $stackable = 'On';
        }
        $cargo_ins = array('cargo_type' => $res->cargo_type, 'goods_description' => $res->goods_description, 'quantity' => $res->quantity, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'weight' => $res->weight, 'weight_unit' => $res->weight_unit, 'volume' => $res->volume, 'volume_unit' => $res->volume_unit, 'stackable' => $res->stackable,'volumetric_weight'=>$res->volumetric_weight,'volweight_uom'=>$res->volweight_uom, 'createdby' => $user_id, 'createdon' => $cdate,'ldm'=>$res->ldm);
        $ins_cargo = $this->db->insert("tb_cargo_details",$cargo_ins);
        $cargo_row_ids[] = $this->db->insert_id();
        /*   array_push($ids,$cargo_row_id);*/
    }
}

$getreference = $this->Order->getreferencebyorder($id);
if (!empty($getreference)) {
    foreach ($getreference as $ref) {
        if ($ref['name'] == 'INN') {
            $order_details['INN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'Z15') {
            $order_details['Z15'] = $ref['ref_value'];
        } else if ($ref['name'] == 'BRN') {
            $order_details['BRN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'SD') {
            $order_details['SD'] = $ref['ref_value'];
        } else if ($ref['name'] == 'CMP') {
            $order_details['CMP'] = $ref['ref_value'];
        } else if ($ref['name'] == 'TRN') {
            $order_details['TRN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'XSR') {
            $order_details['XSR'] = $ref['ref_value'];
        } else {
            $reference_details[] = $ref['id'];
        }

    }
}
}
$transport        = array();
if($company_code == 'RUKN'){
    $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
    if ($gettrasnportmode->num_rows() > 0) {
        foreach ($gettrasnportmode->result() as $res) {
            $transport[] = array('code' => $res->code, 'name' => $res->name);
        }
    }
}else{
     $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
    if ($gettrasnportmode->num_rows() > 0) {
        foreach ($gettrasnportmode->result() as $res) {
            $transport[] = array('code' => $res->code, 'name' => $res->name);
        }
    }
}
$cargo_id = "";
if(!empty($cargo_row_ids)){
    $cargo_id = implode(',', $cargo_row_ids);
} $party_id = "";
if(!empty($party_row_ids)){
    $party_id = implode(',', $party_row_ids);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$data['transport']         = $transport;
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['shipper_details']   = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types']       = $order_types;
$data['delivery_array']    = $delivery_array;
$data['chargecodes']       = $chargecodes;
$data['roles']             = $roles;

$this->newtemplate->dashboard('xborder/copyorder', $data);
}

public function reverseorder($id = null)
{
    $data          = $order_types          = array();
    $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = $delivery_array = $chargecodes = array();

    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->Order->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = "";
            if ($shipment_id != "" && $shipment_id != 0) {

                $getshipment_number = $this->db->select("shipid")->get_where("tb_shipments", array('id' => $shipment_id));
                if ($getshipment_number->num_rows() > 0) {
                    $shipment_id = $getshipment_number->row()->shipid;
                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status        = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            /*if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }*/
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;
            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array('id' => $chkorder->row()->id, 'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'service' => $chkorder->row()->service, 'delivery_term' => $chkorder->row()->delivery_term, 'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $chkorder->row()->purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode);
            $order_details['order_status'] = $order_status;
            if ($incoterm != '') {
                $delivery_array = getDeliverytermsbyIncoterm($incoterm);
            }
            $pickup_id    = $chkorder->row()->customer_id;
            $company_code = $this->session->userdata('company_code');
            if ($company_code != "") {
                $company_code = $chkorder->row()->company_code;
            }
            $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                }
            }
            $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $party_row_ids = array();
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
              foreach($chekparty->result() as $rr){

                $ptype = $rr->party_type;
                $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                if($chktype->num_rows()>0){
                  if($chktype->row()->name == "Consignee"){
                    $shipper_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
                }else if($chktype->row()->name == "Shipper"){
                   $drop_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
               }else{
                $party_row_ids[] = $rr->id;
            }
        }
    }
}
$drop_details['name'] = $chkorder->row()->pickup;
$drop_details['street'] = $chkorder->row()->pickup_address1;
$drop_details['state'] = $chkorder->row()->pickup_address2;
$drop_details['city'] = $chkorder->row()->pickup_city;
$drop_details['country'] = $chkorder->row()->pickup_country;
$drop_details['pincode'] = $chkorder->row()->pickup_pincode;

$shipper_details['name'] = $chkorder->row()->delivery;
$shipper_details['street'] = $chkorder->row()->delivery_address1;
$shipper_details['state'] = $chkorder->row()->delivery_address2;
$shipper_details['city'] = $chkorder->row()->delivery_city;
$shipper_details['country'] = $chkorder->row()->delivery_country;
$shipper_details['pincode'] = $chkorder->row()->delivery_pincode;
$drop_id = $chkorder->row()->drop_custid;
}

$user_id = $this->session->userdata('user_id');
$roles = array();
$qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
if($qyery->num_rows() >0){
    foreach($qyery->result() as $res){
        $roles[] = array('id'=>$res->id,'name'=>$res->name);
    }
}
$getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
if ($getchargecodes->num_rows() > 0) {
    foreach ($getchargecodes->result() as $res) {
        $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
    }
}
$cdate = date('Y-m-d H:i:s');
$cargo_row_ids = array();
$qry = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $id . "' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
if ($qry->num_rows() > 0) {
    foreach ($qry->result() as $res) {
        $stackable = 'Off';
        if ($res->stackable == 0) {
            $stackable = 'Off';
        } else if ($res->stackable == 1) {
            $stackable = 'On';
        }
        $cargo_ins = array('cargo_type' => $res->cargo_type, 'goods_description' => $res->goods_description, 'quantity' => $res->quantity, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'weight' => $res->weight, 'weight_unit' => $res->weight_unit, 'volume' => $res->volume, 'volume_unit' => $res->volume_unit, 'stackable' => $res->stackable,'volumetric_weight'=>$res->volumetric_weight,'volweight_uom'=>$res->volweight_uom, 'createdby' => $user_id, 'createdon' => $cdate,'ldm'=>$res->ldm);
        $ins_cargo = $this->db->insert("tb_cargo_details",$cargo_ins);
        $cargo_row_ids[] = $this->db->insert_id();
        /*   array_push($ids,$cargo_row_id);*/
    }
}

$getreference = $this->Order->getreferencebyorder($id);
if (!empty($getreference)) {
    foreach ($getreference as $ref) {
        if ($ref['name'] == 'INN') {
            $order_details['INN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'Z15') {
            $order_details['Z15'] = $ref['ref_value'];
        } else if ($ref['name'] == 'BRN') {
            $order_details['BRN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'SD') {
            $order_details['SD'] = $ref['ref_value'];
        } else if ($ref['name'] == 'CMP') {
            $order_details['CMP'] = $ref['ref_value'];
        } else if ($ref['name'] == 'TRN') {
            $order_details['TRN'] = $ref['ref_value'];
        } else if ($ref['name'] == 'XSR') {
            $order_details['XSR'] = $ref['ref_value'];
        } else {
            $reference_details[] = $ref['id'];
        }

    }
}
}
$transport        = array();
if($company_code == 'RUKN'){
            $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = array('code' => $res->code, 'name' => $res->name);
                }
            }
        }else{
             $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
            if ($gettrasnportmode->num_rows() > 0) {
                foreach ($gettrasnportmode->result() as $res) {
                    $transport[] = array('code' => $res->code, 'name' => $res->name);
                }
            }
        }
$cargo_id = "";
if(!empty($cargo_row_ids)){
    $cargo_id = implode(',', $cargo_row_ids);
} $party_id = "";
if(!empty($party_row_ids)){
    $party_id = implode(',', $party_row_ids);
}
$order_details['cargo_id'] = $cargo_id;
$order_details['party_id'] = $party_id;
$data['transport']         = $transport;
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['shipper_details']   = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types']       = $order_types;
$data['delivery_array']    = $delivery_array;
$data['chargecodes']       = $chargecodes;
$data['roles']             = $roles;

$this->newtemplate->dashboard('xborder/copyorder', $data);
}


public function editorder($id = null)
{
    if (!checkUrlAccessForUser('XBRDRORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data = $order_types = $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = $delivery_array = $chargecodes = [];
    $order_details['type_name'] = $order_details['ordtype_code'] = "";
    if ($id != "") {
        $chkorder = $this->Order->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $incoterm    = $chkorder->row()->incoterm;
            $shipment_id = $pickup_inst = $delivery_inst = $container_no = "";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='".$id."' AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR')");
            if($getdnote->num_rows() >0){
                foreach($getdnote->result() as $ref){
                    $ref_id = $ref->reference_id;
                    if($ref_id == 'DQ'){
                        $shipment_id = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_DLVINST'){
                        $delivery_inst = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_PIKINST'){
                        $pickup_inst = $ref->ref_value;
                    }
                    if($ref_id == 'CTR'){
                        $container_no = $ref->ref_value;
                    }

                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $status        = $chkorder->row()->status;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;
            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details = array('id' => $chkorder->row()->id, 'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'service' => $chkorder->row()->service, 'delivery_term' => $chkorder->row()->delivery_term, 'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $chkorder->row()->purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'order_type' => $chkorder->row()->order_type, 'transport_mode' => $chkorder->row()->transport_mode,'container_no'=>$container_no);
            $order_details['order_status'] = $order_status;
            if ($incoterm != '') {
                $delivery_array = getDeliverytermsbyIncoterm($incoterm);
            }
            $pickup_id    = $chkorder->row()->customer_id;
            $company_code = $this->session->userdata('company_code');
            if ($company_code != "") {
                $company_code = $chkorder->row()->company_code;
            }
            $getorder_types = $this->db->select("id,type_name")->get_where("tb_order_types", array('company_code' => $company_code, 'status' => 1));
            if ($getorder_types->num_rows() > 0) {
                foreach ($getorder_types->result() as $res) {
                    $order_types[] = array('type_name' => $res->type_name, 'type_id' => $res->id);
                }
            }
            $getpickupdetails = $this->Order->getpickupdetails($pickup_id);
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
              foreach($chekparty->result() as $rr){
                $ptype = $rr->party_type;
                $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                if($chktype->num_rows()>0){
                  if($chktype->row()->name == "Consignee"){
                    $drop_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
                }else if($chktype->row()->name == "Shipper"){
                 $shipper_details = array('id'=>$rr->id,'name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
             }
         }
     }
 }
 $shipper_details['name'] = $chkorder->row()->pickup;
 $shipper_details['street'] = $chkorder->row()->pickup_address1;
 $shipper_details['state'] = $chkorder->row()->pickup_address2;
 $shipper_details['city'] = $chkorder->row()->pickup_city;
 $shipper_details['country'] = $chkorder->row()->pickup_country;
 $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

 $drop_details['name'] = $chkorder->row()->delivery;
 $drop_details['street'] = $chkorder->row()->delivery_address1;
 $drop_details['state'] = $chkorder->row()->delivery_address2;
 $drop_details['city'] = $chkorder->row()->delivery_city;
 $drop_details['country'] = $chkorder->row()->delivery_country;
 $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
 $drop_id = $chkorder->row()->drop_custid;
}
            /* $getcargo = $this->db->query("SELECT c.* FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='".$id."' AND o.cargo_id=c.id AND o.status=1 GROUP BY c.id ORDER BY c.id DESC");
            $cargos = array();
            if($getcargo->num_rows() >0){
            foreach ($getcargo->result() as $res) {
            $cargo_type = '"'.$res->cargo_type.'"';
            $goods_desc = '"'.$res->goods_description.'"';
            $cargos[] = array('cargo_id'=>$res->id,'goods_desc'=>$res->goods_description,'cargo_type'=>$res->cargo_type,'length'=>$res->length." ".$res->length_unit,'width'=>$res->width." ".$res->width_unit,'height'=>$res->height." ".$res->height_unit,'weight'=>$res->weight." ".$res->weight_unit,'volume'=>$res->volume." ".$res->volume_unit,'quantity'=>$res->quantity,'action'=>$action);
            }
        }*/
        $user_id = $this->session->userdata('user_id');
        $roles = array();
        $qyery=$this->db->query("SELECT id,name FROM tbl_party_types WHERE user_id= '".$user_id."' AND status=1 GROUP BY name");
        if($qyery->num_rows() >0){
            foreach($qyery->result() as $res){
                $roles[] = array('id'=>$res->id,'name'=>$res->name);
            }
        }
        $getchargecodes = $this->db->select("id,charge_code")->get_where("tb_charge_codes", array('status' => '1'));
        if ($getchargecodes->num_rows() > 0) {
            foreach ($getchargecodes->result() as $res) {
                $chargecodes[] = array('charge_id' => $res->id, 'charge_code' => $res->charge_code);
            }
        }

        $getreference = $this->Order->getreferencebyorder($id);
        if (!empty($getreference)) {
            foreach ($getreference as $ref) {
                if ($ref['name'] == 'INN') {
                    $order_details['INN'] = $ref['ref_value'];
                } else if ($ref['name'] == 'Z15') {
                    $order_details['Z15'] = $ref['ref_value'];
                } else if ($ref['name'] == 'BRN') {
                    $order_details['BRN'] = $ref['ref_value'];
                } else if ($ref['name'] == 'SD') {
                    $order_details['SD'] = $ref['ref_value'];
                } else if ($ref['name'] == 'CMP') {
                    $order_details['CMP'] = $ref['ref_value'];
                } else if ($ref['name'] == 'TRN') {
                    $order_details['TRN'] = $ref['ref_value'];
                } else if ($ref['name'] == 'XSR') {
                    $order_details['XSR'] = $ref['ref_value'];
                } else {
                    $reference_details[] = $ref['id'];
                }

            }
        }
    }
    $transport        = array();
    if($company_code == 'RUKN'){
        $gettrasnportmode = $this->db->query("SELECT code,name FROM tb_transportmode WHERE code IN ('LTL','FTL','GRP')");
        if ($gettrasnportmode->num_rows() > 0) {
            foreach ($gettrasnportmode->result() as $res) {
                $transport[] = array('code' => $res->code, 'name' => $res->name);
            }
        }
    }else{
         $gettrasnportmode = $this->db->select("code,name")->get_where("tb_transportmode", array('status' => 1));
        if ($gettrasnportmode->num_rows() > 0) {
            foreach ($gettrasnportmode->result() as $res) {
                $transport[] = array('code' => $res->code, 'name' => $res->name);
            }
        }
    }
    $data['stoppagecodes'] = $data['resolutioncodes'] = array();
    $select = "id,code";
    /*$getstoppage = $this->Order->getmasters('tbl_stoppage_master',$select);
    if($getstoppage->num_rows() > 0){
        foreach ($getstoppage->result()  as $res) {
          $data['stoppagecodes'][]  = array('id'=>$res->id,'code'=>$res->code);
      }
  }*/
  $select = "id,name";
 /* $getresolution = $this->Order->getmasters('tbl_resolution_master',$select);
  if($getresolution->num_rows() > 0){
    foreach ($getresolution->result()  as $res) {
        $data['resolutioncodes'][]  = array('id'=>$res->id,'name'=>$res->name);
    }
}*/
$data['transport']         = $transport;
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['shipper_details']   = $shipper_details;
$data['reference_details'] = $reference_details;
$data['order_types']       = $order_types;
$data['delivery_array']    = $delivery_array;
$data['chargecodes']       = $chargecodes;
$data['roles']             = $roles;
        //  $data['cargos'] = $cargos;

$this->newtemplate->dashboard('xborder/editorder', $data);
}

public function vieworder($id = null)
{
    if (!checkUrlAccessForUser('XBRDRORDERS')) {
        redirect("Forbiddenaccess");
    }
    $data = $order_details = $shipper_details = $drop_details = $pickup_details = $reference_details = [];
    if ($id != "") {
        $chkorder = $this->Order->getordertoedit($id);
        if ($chkorder->num_rows() > 0) {
            $transport      = $chkorder->row()->transport_mode;
            $transport_mode = "";
            if ($transport != "") {

                $getmode = $this->db->select("name")->get_where("tb_transportmode", array('code' => $transport));
                if ($getmode->num_rows() > 0) {
                    $transport_mode = $getmode->row()->name;
                }
            }
            $shipment_id = $pickup_inst = $delivery_inst = $container_no ="";
            $getdnote = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id ='".$id."' AND reference_id IN ('DQ','ORD_DLVINST','ORD_PIKINST','CTR')");
            if($getdnote->num_rows() >0){
                foreach($getdnote->result() as $ref){
                    $ref_id = $ref->reference_id;
                    if($ref_id == 'DQ'){
                        $shipment_id = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_DLVINST'){
                        $delivery_inst = $ref->ref_value;
                    }
                    if($ref_id == 'ORD_PIKINST'){
                        $pickup_inst = $ref->ref_value;
                    }
                    if($ref_id == 'CTR'){
                        $container_no = $ref->ref_value;
                    }

                }
            }
            $pickup_custid = $chkorder->row()->pickup_custid;
            $trip_id = $chkorder->row()->trip_id;
            $trip_sts = $chkorder->row()->trip_sts;
            $order_status = "PENDING";
            if($trip_id != 0 && $trip_sts == 0){
                $order_status = 'ACTIVE';
            }
            if($trip_id != 0 && $trip_sts == 1){
                $order_status = 'CLOSED';
            }
            $chkdate = '2020-07-01 00:00:00';
            $createdon = $chkorder->row()->createdon;
            $order_str = strtotime($createdon);
            $chk_str = strtotime($chkdate);
            $early_pickup = $chkorder->row()->pickup_datetime;
            $early_delivery = $chkorder->row()->delivery_datetime;
            $late_pickup = $chkorder->row()->pickup_endtime;
            $late_delivery = $chkorder->row()->drop_endtime;
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            if($order_str > $chk_str){
                if($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00"){
                    $epickup = getdatetimebytimezone($curtz,$early_pickup,DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }
                if($early_delivery != "" && $early_delivery != "0000-00-00 00:00:00"){
                    $edelivery = getdatetimebytimezone($curtz,$early_delivery,DFLT_TZ);
                    $early_delivery = $edelivery['datetime'];
                }
                if($late_pickup != "" && $late_pickup != "0000-00-00 00:00:00"){
                    $lpickup = getdatetimebytimezone($curtz,$late_pickup,DFLT_TZ);
                    $late_pickup = $lpickup['datetime'];
                }
                if($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00"){
                    $ldelivery = getdatetimebytimezone($curtz,$late_delivery,DFLT_TZ);
                    $late_delivery = $ldelivery['datetime'];
                }

            }
            $order_details               = array('id' => $chkorder->row()->id, 'order_id' => $chkorder->row()->order_id, 'shipment_id' => $shipment_id, 'order_status' => $order_status, 'early_pickup' => $early_pickup, 'early_delivery' => $early_delivery, 'late_pickup' => $late_pickup, 'late_delivery' => $late_delivery, 'product' => $chkorder->row()->product, 'incoterm' => $chkorder->row()->incoterm, 'delivery_note' => $chkorder->row()->delivery_note, 'purchase_order' => $chkorder->row()->purchase_order, 'notify_party' => $chkorder->row()->notify_party, 'goods_value' => $chkorder->row()->goods_value, 'lane_reference' => $chkorder->row()->lane_reference, 'distance' => $chkorder->row()->distance, 'customs_required' => $chkorder->row()->customs_required, 'high_cargo_value' => $chkorder->row()->high_cargo_value, 'valorance_insurance' => $chkorder->row()->valorance_insurance, 'temperature_control' => $chkorder->row()->temperature_control, 'company_code' => $chkorder->row()->company_code, 'branch_code' => $chkorder->row()->branch_code, 'department_code' => $chkorder->row()->department_code, 'createdon' => $chkorder->row()->createdon, 'transport_mode' => $transport_mode,'container_no'=>$container_no);
            $delivery_term               = "";
            $pickup_id                   = $chkorder->row()->customer_id;
            $ord_type                    = $chkorder->row()->order_type;
            $order_details['order_type'] = "";

            $getordertype = $this->db->select("type_name")->get_where("tb_order_types", array('id' => $ord_type, 'status' => '1','company_code'=>$chkorder->row()->company_code));
            if ($getordertype->num_rows() > 0) {
                $order_details['order_type'] = $getordertype->row()->type_name;
            }
            $delivery_term_id = $chkorder->row()->delivery_term;
            if ($delivery_term_id != "") {

                $getdelivery_term = $this->db->select("term_id,name")->get_where("tb_delivery_terms", array('term_id' => $delivery_term_id));
                if ($getdelivery_term->num_rows() > 0) {
                    $delivery_term = $getdelivery_term->row()->term_id . "-" . $getdelivery_term->row()->name;
                }
            }
            $service    = "";
            $service_id = $chkorder->row()->service;
            if ($service_id != "") {
                $getservice = $this->db->select("service_id,name")->get_where("tb_service_master", array('id' => $service_id));
                if ($getservice->num_rows() > 0) {
                    $service = $getservice->row()->service_id . "-" . $getservice->row()->name;
                }
            }
            $order_details['service']       = $service;
            $order_details['delivery_term'] = $delivery_term;

            $getpickupdetails = $this->db->select("id,name,address,pincode,code,country")->get_where("tb_customers", array('status' => 1, 'id' => $pickup_id));
            if ($getpickupdetails->num_rows() > 0) {
                $pickup_details = array('id' => $getpickupdetails->row()->id, 'name' => $getpickupdetails->row()->name, 'party_id' => $getpickupdetails->row()->code, 'address' => $getpickupdetails->row()->address, 'pincode' => $getpickupdetails->row()->pincode, 'country' => $getpickupdetails->row()->country);
            }
            $drop_id        = $chkorder->row()->drop_custid;
            $drop_row_id    = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name, p.mobile, p.email,p.code,p.fax,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
              foreach($chekparty->result() as $rr){
                $ptype = $rr->party_type;
                $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                if($chktype->num_rows()>0){
                  if($chktype->row()->name == "Consignee"){
                    $drop_details = array('name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
                }else if($chktype->row()->name == "Shipper"){
                   $shipper_details = array('name'=>$rr->name,'phone'=>$rr->mobile,'email'=>$rr->email,'fax'=>$rr->fax,'party_id'=>$rr->code);
               }
           }
       }
   }
    $shipper_details['name'] = $chkorder->row()->pickup;
   $shipper_details['street'] = $chkorder->row()->pickup_address1;
   $shipper_details['state'] = $chkorder->row()->pickup_address2;
   $shipper_details['city'] = $chkorder->row()->pickup_city;
   $shipper_details['country'] = $chkorder->row()->pickup_country;
   $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

   $drop_details['name'] = $chkorder->row()->delivery;
   $drop_details['street'] = $chkorder->row()->delivery_address1;
   $drop_details['state'] = $chkorder->row()->delivery_address2;
   $drop_details['city'] = $chkorder->row()->delivery_city;
   $drop_details['country'] = $chkorder->row()->delivery_country;
   $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
   $drop_id = $chkorder->row()->drop_custid;
}
$getreference = $this->db->query("SELECT o.ref_value,r.id,r.name FROM tb_order_references o,tb_reference_master r WHERE o.order_id='" . $id . "' AND o.reference_id=r.name AND o.status='1' AND r.status='1' ORDER BY o.id DESC");
if ($getreference->num_rows() > 0) {
    foreach ($getreference->result() as $ref) {
        if ($ref->name == 'INN') {
            $order_details['INN'] = $ref->ref_value;
        } else if ($ref->name == 'Z15') {
            $order_details['Z15'] = $ref->ref_value;
        } else if ($ref->name == 'BRN') {
            $order_details['BRN'] = $ref->ref_value;
        } else if ($ref->name == 'SD') {
            $order_details['SD'] = $ref->ref_value;
        } else if ($ref->name == 'CMP') {
            $order_details['CMP'] = $ref->ref_value;
        } else if ($ref->name == 'TRN') {
            $order_details['TRN'] = $ref->ref_value;
        } else if ($ref->name == 'XSR') {
            $order_details['XSR'] = $ref->ref_value;
        } else {
            $reference_details[] = $ref->id;
        }

    }
}

}
$data['order_details']     = $order_details;
$data['pickup_details']    = $pickup_details;
$data['drop_details']      = $drop_details;
$data['reference_details'] = $reference_details;
$data['shipper_details']   = $shipper_details;

$this->newtemplate->dashboard('xborder/vieworder', $data);
}

    public function updateorder()
    {
        $order_id = isset($_POST['order_id']) ? $this->db->escape_str($_POST['order_id']) : '0';
        if ($order_id != "0") {
            $cdate            = date('Y-m-d H:i:s');
            $user_id          = $this->session->userdata('user_id');
            $booking_id       = isset($_POST['booking_id']) ? $this->db->escape_str($_POST['booking_id']) : "";
            $company_code     = isset($_POST['company_code']) ? $this->db->escape_str($_POST['company_code']) : "";
            $branch_code      = isset($_POST['branch_code']) ? $this->db->escape_str($_POST['branch_code']) : "";
            $department_code  = isset($_POST['department_code']) ? $this->db->escape_str($_POST['department_code']) : "";
            $product          = isset($_POST['product']) ? $this->db->escape_str($_POST['product']) : "";
            $service          = isset($_POST['service']) ? $this->db->escape_str($_POST['service']) : "";
            $delivery_terms   = isset($_POST['delivery_terms']) ? $this->db->escape_str($_POST['delivery_terms']) : "";
            $modeof_trasnport = isset($_POST['modeof_trasnport']) ? $this->db->escape_str($_POST['modeof_trasnport']) : "TL";
            $order_type       = isset($_POST['order_type']) ? $this->db->escape_str($_POST['order_type']) : "";
            $incoterm         = isset($_POST['incoterm']) ? $this->db->escape_str($_POST['incoterm']) : "";
            $shipment_id      = isset($_POST['delivery_note']) ? $this->db->escape_str($_POST['delivery_note']) : "";
            $container_no      = isset($_POST['container_num']) ? $this->db->escape_str($_POST['container_num']) : "";
            $porder           = isset($_POST['purchase_order']) ? $this->db->escape_str($_POST['purchase_order']) : "";
            $order_shipper_id = isset($_POST['order_shipper_id']) ? $this->db->escape_str($_POST['order_shipper_id']) : "0";
            if ($shipment_id != "") {
                $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'DQ' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                if ($upddq->num_rows() > 0) {
                    $this->db->where(array('id' => $upddq->row()->id))->update('tb_order_references', array('ref_value' => $shipment_id));
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id);
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            if($company_code == 'AUKN' || $company_code == 'UKKN'){
                if ($container_no != "") {
                    $upddq = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'CTR' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                    if ($upddq->num_rows() > 0) {
                        $this->db->where(array('id' => $upddq->row()->id))->update('tb_order_references', array('ref_value' => $container_no));
                    } else {
                        $arr = array('order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no,'createdon'=>$cdate);
                        $this->db->insert('tb_order_references', $arr);
                    }
                }
            }
            if ($porder != "") {
                $updporder = $this->db->query("SELECT o.id FROM tb_order_references o,tb_reference_master r WHERE r.name LIKE 'PO' AND r.name=o.reference_id AND o.order_id=" . $order_id);
                if ($updporder->num_rows() > 0) {
                    $this->db->where(array('id' => $updporder->row()->id))->update('tb_order_references', array('ref_value' => $shipment_id));
                } else {
                    $arr = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder);
                    $this->db->insert('tb_order_references', $arr);
                }
            }
            $goods_value = isset($_POST['goods_value']) ? $_POST['goods_value'] : "0.00";
            if ($goods_value == "") {
                $goods_value = 0.00;
            }
            $lane_reference   = isset($_POST['lane_reference']) ? $this->db->escape_str($_POST['lane_reference']) : "";
            $distance         = isset($_POST['distance']) ? $this->db->escape_str($_POST['distance']) : "";
            $party_row_id     = isset($_POST['order_party_row_id']) ? $this->db->escape_str($_POST['order_party_row_id']) : "0";
            $reference_ids    = isset($_POST['reference_ids']) ? $this->db->escape_str($_POST['reference_ids']) : "0";
            $order_inv_row_id = isset($_POST['order_inv_row_id']) ? $this->db->escape_str($_POST['order_inv_row_id']) : '0';
            $order_cargo_id   = isset($_POST['order_cargo_id']) ? $this->db->escape_str($_POST['order_cargo_id']) : "";
            $pickup           = isset($_POST['order_pickup_id']) ? $this->db->escape_str($_POST['order_pickup_id']) : "";
            $delivery         = isset($_POST['order_drop_id']) ? $this->db->escape_str($_POST['order_drop_id']) : "";
            $customs_required = isset($_POST['customs_required']) ? $this->db->escape_str($_POST['customs_required']) : "0";
            $high_value_cargo = isset($_POST['high_value_cargo']) ? $this->db->escape_str($_POST['high_value_cargo']) : "0";
            $ad_valorence_ins = isset($_POST['ad_valorence_ins']) ? $this->db->escape_str($_POST['ad_valorence_ins']) : "0";
            $temp_control     = isset($_POST['temp_control']) ? $this->db->escape_str($_POST['temp_control']) : "0";
            $early_pickup     = isset($_POST['early_pickup']) ? $this->db->escape_str($_POST['early_pickup']) : "";
            $late_pickup      = isset($_POST['late_pickup']) ? $this->db->escape_str($_POST['late_pickup']) : "";
            $early_delivery   = isset($_POST['early_delivery']) ? $this->db->escape_str($_POST['early_delivery']) : "";
            $late_delivery    = isset($_POST['late_delivery']) ? $this->db->escape_str($_POST['late_delivery']) : "";
            $e_pickup         = date('Y-m-d H:i:s');
            if ($early_pickup != "") {
                $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
            }
            if ($late_pickup != "") {
                $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
            } else {
                $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
            }
            $e_delivery = date('Y-m-d H:i:s');
            if ($early_delivery != "") {
                $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
            }
            if ($late_delivery != "") {
                $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
            } else {
                $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
            }
            $pickup_name       = $pickup_country       = $pickup_street       = $pickup_pincode       = $pickup_city       = "";
            $drop_id           = $drop_name           = $drop_country           = $drop_street           = $drop_pincode           = $drop_city           = $drop_state           = $pickup_state = $drop_state = $pickup_address = $drop_address = "";
            $pickup_custid     = $drop_custid     = $pickup_id     = 0;

            $drop_row_id    = 0;
            $chekparty = $this->db->query("SELECT p.id,p.party_type_id, p.name,p.code,o.party_type FROM tbl_party_master p INNER JOIN tb_order_parties o ON p.id=o.party_id AND o.status=1  WHERE p.status=1 AND o.order_id='$order_id' GROUP BY o.party_type");
            if($chekparty->num_rows() >0){
                foreach($chekparty->result() as $rr){
                    $ptype = $rr->party_type;
                    $chktype = $this->db->select("name")->get_where("tbl_party_types",array("id"=>$ptype),1,0);
                    if($chktype->num_rows()>0){
                        if($chktype->row()->name == "Consignee"){
                            $drop_row_id = $rr->id;
                            $drop_id     = $rr->code;
                            $drop_name   = $rr->name;
                            $drop_custid = $rr->code;
                        }else if($chktype->row()->name == "Shipper"){
                            $pickup_id     = $rr->id;
                            $pickup_custid = $rr->code;
                            $pickup_name   = $rr->name;
                        }
                    }
                }
            }
            if ($pickup_id != "0") {
                $chk_shipperaddress = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $pickup_id));
                if ($chk_shipperaddress->num_rows() > 0) {
                    $pickup_city    = $chk_shipperaddress->row()->location_id;
                    $pickup_country = $chk_shipperaddress->row()->country;
                    $pickup_street  = $chk_shipperaddress->row()->street;
                    $pickup_pincode = $chk_shipperaddress->row()->pincode;
                    $pickup_state   = $chk_shipperaddress->row()->state;
                    $pickup_address = $chk_shipperaddress->row()->address;
                }
            }else{
                if($order_shipper_id != "0"){
                    $getshippercustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $order_shipper_id . "'");
                    if ($getshippercustid->num_rows() > 0) {
                        $pickup_id      = $order_shipper_id;
                        $pickup_custid  = $getshippercustid->row()->code;
                        $pickup_name    = $getshippercustid->row()->name;
                        $pickup_state   = $getshippercustid->row()->state;
                        $pickup_address = $getshippercustid->row()->address;
                        $pickup_country = $getshippercustid->row()->country;
                        $pickup_street  = $getshippercustid->row()->street;
                        $pickup_pincode = $getshippercustid->row()->pincode;
                        $pickup_city    = $getshippercustid->row()->city;
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address",array('order_id'=>$order_id,'party_master_id'=>$order_shipper_id));
                        $shipper_address    = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id,'status'=>'1');
                        if($chkpartyaddress->num_rows() >0){
                            $pickup_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(array('id'=>$pickup_addressid))->update("tbl_orderparty_address",$shipper_address);
                        }else{
                            $shipper_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address",$shipper_address);
                        }
                    }
                }
            }
            if ($drop_row_id != "0") {
                $chkdrop = $this->db->select("location_id,street,state,address,pincode,country")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $drop_row_id));
                if ($chkdrop->num_rows() > 0) {
                    $drop_city    = $chkdrop->row()->location_id;
                    $drop_state   = $chkdrop->row()->state;
                    $drop_country = $chkdrop->row()->country;
                    $drop_street  = $chkdrop->row()->street;
                    $drop_pincode = $chkdrop->row()->pincode;
                    $drop_address = $chkdrop->row()->address;
                }
            }else{
                if($delivery != "0"){
                    $getdropcustid = $this->db->query("SELECT name,code,location_id as city,street,state,address,country,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
                    if ($getdropcustid->num_rows() > 0) {
                        $drop_id      = $delivery;
                        $drop_custid  = $getdropcustid->row()->code;
                        $drop_name    = $getdropcustid->row()->name;
                        $drop_state   = $getdropcustid->row()->state;
                        $drop_address = $getdropcustid->row()->address;
                        $drop_country = $getdropcustid->row()->country;
                        $drop_street  = $getdropcustid->row()->street;
                        $drop_pincode = $getdropcustid->row()->pincode;
                        $drop_city    = $getdropcustid->row()->city;
                        $chkpartyaddress = $this->db->select("id")->get_where("tbl_orderparty_address",array('order_id'=>$order_id,'party_master_id'=>$delivery));
                        $drop_address    = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id,'status'=>'1');
                        if($chkpartyaddress->num_rows() >0){
                            $drop_addressid = $chkpartyaddress->row()->id;
                            $upd = $this->db->where(array('id'=>$drop_addressid))->update("tbl_orderparty_address",$drop_address);
                        }else{
                            $drop_address['createdon'] = $cdate;
                            $this->db->insert("tbl_orderparty_address",$drop_address);
                        }
                    }
                }
            }
             if($order_shipper_id != "" || $order_shipper_id != 0){
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
                if($chk->num_rows() >0){
                    $party_type = $chk->row()->id;
                }else{
                   $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'user_id'=>$user_id));
                   if($chk1->num_rows()>0)
                       $party_type = $chk1->row()->id;
               }

               $party     = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
               $ins_party = $this->db->insert("tb_order_parties", $party);
           }
           if($delivery != "" || $delivery != 0){
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
            if($chk->num_rows() >0){
                $party_type = $chk->row()->id;
            }else{
                $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'user_id'=>$user_id));
                if($chk1->num_rows()>0){
                   $party_type = $chk1->row()->id;
               }
           }
           $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
           $ins_party = $this->db->insert("tb_order_parties", $party);
       }
            $ship_row_id      = 0;
            $enddate          = date('Y-m-d H:i:s', strtotime("+1 day"));
            $tid              = $tname              = "";
            $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
            if ($gettrasnportmode->num_rows() > 0) {
                $tid   = $gettrasnportmode->row()->id;
                $tname = $gettrasnportmode->row()->name;
            }
            $ship_arr   = array('unitspec' => 1, 'shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $modeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid);
            $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");
            if ($chk_shipid->num_rows() > 0) {
                $ship_row_id = $chk_shipid->row()->id;
                $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
            } else {

                $ship_arr['createdon'] = $cdate;
                $ship_ins              = $this->db->insert("tb_shipments", $ship_arr);
                $ship_row_id           = $this->db->insert_id();
            }

            $ins = [
                'shipment_id' => $ship_row_id,
                'product' => $product,
                'pickup_datetime' => $e_pickup,
                'delivery_datetime' => $e_delivery,
                'pickup_endtime' => $l_pickup,
                'drop_endtime' => $l_delivery,
                'goods_value' => $goods_value,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'transport_mode' => $modeof_trasnport,
                'updatedon' => date('Y-m-d H:i:s')
            ];
            if($pickup_name != ""){
                $ins['pickup_company'] = $pickup_name;
            }
            if($pickup_country != ""){
                $ins['pickup_country'] = $pickup_country;
            }
            if($drop_name != ""){
                $ins['delivery_company'] = $drop_name;
            }
            if($drop_country != ""){
                $ins['delivery_country'] = $drop_country;
            }
            if($pickup_street != ""){
                $ins['pickup_address1'] = $pickup_street;
            }
            if($pickup_city != ""){
                $ins['pickup_city'] = $pickup_city;
            }
            if($pickup_pincode != ""){
                $ins['pickup_pincode'] = $pickup_pincode;
            }
            if($pickup_state != ""){
                $ins['pickup_address2'] = $pickup_state;
            }
            if($drop_street != ""){
                $ins['delivery_address1']  = $drop_street;
            }
            if($drop_state != ""){
                $ins['delivery_address2'] = $drop_state;
            }
            if($drop_city != ""){
                $ins['delivery_city'] = $drop_city;
            }
            if($drop_pincode != ""){
                $ins['delivery_pincode'] = $drop_pincode;
            }

            $this->db->where(array('id' => $order_id))->update('tb_orders', $ins);

            $details_ins  = array( 'service' => $service, 'delivery_term' => $delivery_terms, 'incoterm' => $incoterm, 'purchase_order' => $porder, 'lane_reference' => $lane_reference, 'distance' => $distance, 'department_code' => $department_code, 'temperature_control' => $temp_control, 'valorance_insurance' => $ad_valorence_ins, 'high_cargo_value' => $high_value_cargo, 'customs_required' => $customs_required, 'order_type' => $order_type);
            $upd_details  = $this->db->where(array('order_row_id' => $order_id))->update("tb_order_details", $details_ins);
            $total_weight = $total_volume = $total_quantity = 0;
            $gettotal     = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
            if ($gettotal->num_rows() > 0) {
                $total_volume   = $gettotal->row()->total_volume;
                $total_weight   = $gettotal->row()->total_weight;
                $total_quantity = $gettotal->row()->total_quantity;
            }
            $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
            $this->ordernotify('booking_edit',$order_id);
        }

        if($order_id != "" && $order_id !='0'){
            redirect('XBRDRorders/orderslist/'.$order_id);
        }else{
            redirect('xborder');
        }

    }


public function insertorder()
{

    $cdate            = date('Y-m-d H:i:s');
    $user_id          = $this->session->userdata('user_id');
    $company_code     = isset($_POST['company_code']) ? $this->db->escape_str($_POST['company_code']) : "";
    $branch_code      = isset($_POST['branch_code']) ? $this->db->escape_str($_POST['branch_code']) : "";
    $department_code  = isset($_POST['department_code']) ? $this->db->escape_str($_POST['department_code']) : "";
    $product          = isset($_POST['product']) ? $this->db->escape_str($_POST['product']) : "";
    $service          = isset($_POST['service']) ? $this->db->escape_str($_POST['service']) : "";
    $order_shipper_id = isset($_POST['order_shipper_id']) ? $this->db->escape_str($_POST['order_shipper_id']) : "";
    $delivery_terms = isset($_POST['delivery_terms']) ? $this->db->escape_str($_POST['delivery_terms']) : "";
    $incoterm       = isset($_POST['incoterm']) ? $this->db->escape_str($_POST['incoterm']) : "";
    $shipment_id    = isset($_POST['delivery_note']) ? $this->db->escape_str($_POST['delivery_note']) : "";
    $container_no    = isset($_POST['container_num']) ? $this->db->escape_str($_POST['container_num']) : "";
    $porder         = isset($_POST['purchase_order']) ? $this->db->escape_str($_POST['purchase_order']) : "";
    $notify_party   = isset($_POST['notify_party']) ? $this->db->escape_str($_POST['notify_party']) : "";
    $goods_value    = isset($_POST['goods_value']) ? $this->db->escape_str($_POST['goods_value']) : "0.00";
    if ($goods_value == "") {
        $goods_value = 0.00;
    }
    $lane_reference   = isset($_POST['lane_reference']) ? $this->db->escape_str($_POST['lane_reference']) : "";
    $distance         = isset($_POST['distance']) ? $this->db->escape_str($_POST['distance']) : "";
    $party_row_id     = isset($_POST['order_party_row_id']) ? $this->db->escape_str($_POST['order_party_row_id']) : "0";
    $reference_ids    = isset($_POST['reference_ids']) ? $this->db->escape_str($_POST['reference_ids']) : "0";
    $order_inv_row_id = isset($_POST['order_inv_row_id']) ? $this->db->escape_str($_POST['order_inv_row_id']) : '0';
    $order_cargo_id   = isset($_POST['order_cargo_id']) ? $this->db->escape_str($_POST['order_cargo_id']) : "";
    $pickup           = isset($_POST['order_pickup_id']) ? $this->db->escape_str($_POST['order_pickup_id']) : "";
    $customer_code    = isset($_POST['customer_id']) ? $this->db->escape_str($_POST['customer_id']) : "";
    $delivery         = isset($_POST['order_drop_id']) ? $this->db->escape_str($_POST['order_drop_id']) : "";
    $customs_required = isset($_POST['customs_required']) ? $this->db->escape_str($_POST['customs_required']) : "0";
    $high_value_cargo = isset($_POST['high_value_cargo']) ? $this->db->escape_str($_POST['high_value_cargo']) : "0";
    $ad_valorence_ins = isset($_POST['ad_valorence_ins']) ? $this->db->escape_str($_POST['ad_valorence_ins']) : "0";
    $temp_control     = isset($_POST['temp_control']) ? $this->db->escape_str($_POST['temp_control']) : "0";
    $early_pickup     = isset($_POST['early_pickup']) ? $this->db->escape_str($_POST['early_pickup']) : "";
    $late_pickup      = isset($_POST['late_pickup']) ? $this->db->escape_str($_POST['late_pickup']) : "";
    $early_delivery   = isset($_POST['early_delivery']) ? $this->db->escape_str($_POST['early_delivery']) : "";
    $late_delivery    = isset($_POST['late_delivery']) ? $this->db->escape_str($_POST['late_delivery']) : "";
    $modeof_trasnport = isset($_POST['modeof_trasnport']) ? $this->db->escape_str($_POST['modeof_trasnport']) : "LTL";
    $order_type       = isset($_POST['order_type']) ? $this->db->escape_str($_POST['order_type']) : "";
    $e_pickup         = date('Y-m-d H:i:s');
    if ($early_pickup != "") {
        $e_pickup = date('Y-m-d H:i:s', strtotime($early_pickup));
    }
    if ($late_pickup != "") {
        $l_pickup = date('Y-m-d H:i:s', strtotime($late_pickup));
    } else {
        $l_pickup = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_pickup)));
    }
    $e_delivery = date('Y-m-d H:i:s');
    if ($early_delivery != "") {
        $e_delivery = date('Y-m-d H:i:s', strtotime($early_delivery));
    }
    if ($late_delivery != "") {
        $l_delivery = date('Y-m-d H:i:s', strtotime($late_delivery));
    } else {
        $l_delivery = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($e_delivery)));
    }
    $same_porder = "0";
    if ($porder != "") {

        $chkporder = $this->db->query("SELECT id FROM tb_order_details WHERE purchase_order='" . $porder . "' AND status='1'");
        if ($chkporder->num_rows() > 0) {
            $same_porder = "1";

        }
    }
    if ($same_porder == 1) {
        $this->session->set_flashdata('error_msg', 'Purchase Order "' . $porder . '" already exists with One ORDER');
    } else {
        $drop_id        = $pickup_custid        = 0;
        $pickup_name    = $pickup_country    = $pickup_street    = $pickup_pincode    = $pickup_city    = $drop_name    = $drop_country    = $drop_street    = $drop_pincode    = $drop_city    = $pickup_address    = $pickup_state    = $drop_address    = $drop_state = "";
        $getdrop_custid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id='" . $delivery . "'");
        if ($getdrop_custid->num_rows() > 0) {
            $drop_id      = $getdrop_custid->row()->customeridentifier;
            $drop_name    = $getdrop_custid->row()->name;
            $drop_state   = $getdrop_custid->row()->state;
            $drop_address = $getdrop_custid->row()->address;
            $drop_country = $getdrop_custid->row()->country;
            $drop_street  = $getdrop_custid->row()->street;
            $drop_pincode = $getdrop_custid->row()->pincode;
            $drop_city    = $getdrop_custid->row()->city;
        }

        $getshippercustid = $this->db->query("SELECT name,location_id as city,street,state,address,country,customeridentifier,pincode FROM tbl_party_master WHERE id='" . $order_shipper_id . "'");
        if ($getshippercustid->num_rows() > 0) {
            $pickup_custid  = $getshippercustid->row()->customeridentifier;
            $pickup_name    = $getshippercustid->row()->name;
            $pickup_state   = $getshippercustid->row()->state;
            $pickup_address = $getshippercustid->row()->address;
            $pickup_country = $getshippercustid->row()->country;
            $pickup_street  = $getshippercustid->row()->street;
            $pickup_pincode = $getshippercustid->row()->pincode;
            $pickup_city    = $getshippercustid->row()->city;

        }
        $add1             = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
        $add2             = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
        $data             = getlatlngsbyplace($add1);
        $lat1             = @$data[0];
        $lng1             = @$data[1];
        $data             = [];
        $data             = getlatlngsbyplace($add2);
        $lat2             = @$data[0];
        $lng2             = @$data[1];
        $ship_row_id      = 0;
        $enddate          = date('Y-m-d H:i:s', strtotime("+1 day"));
        $tid              = $tname              = "";
        $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '" . $modeof_trasnport . "'");
        if ($gettrasnportmode->num_rows() > 0) {
            $tid   = $gettrasnportmode->row()->id;
            $tname = $gettrasnportmode->row()->name;
        }
        if ($shipment_id == "") {
            $shipment_id = "KN" . time();
        }

        $ship_arr   = array('unitspec' => 1, 'shipid' => $shipment_id, 'txnid' => $shipment_id, 'trucktype' => $tname, 'pickupcnt' => '1', 'dropcnt' => '1', 'insertusr' => $pickup_custid, 'carrier' => '0', 'insertuserdate' => $cdate, 'enddate' => $enddate, 'insdate' => $cdate, 'upddate' => $cdate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $cdate, 'transport_mode' => $modeof_trasnport, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'product' => $product, 'freight_term' => '60', 'freight_termname' => 'Free of Charge', 'incoterm' => $incoterm, 'modeoftransport' => $tid);
        $chk_shipid = $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '" . $shipment_id . "'");

        if ($chk_shipid->num_rows() > 0) {
            $ship_row_id = $chk_shipid->row()->id;
            $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", $ship_arr);
        } else {

            $ship_arr['createdon'] = $cdate;
            $ship_ins              = $this->db->insert("tb_shipments", $ship_arr);
            $ship_row_id           = $this->db->insert_id();
        }
        $customer_id = $pickup;
        if($customer_id == "" || $customer_id == "0"){
            if($customer_code != "" && $customer_code != "0"){
                $getcustomerid = $this->db->select("id")->get_where("tb_customers",array('code'=>$customer_code,'user_id'=>$user_id,'status'=>'1'));
                if($getcustomerid->num_rows() >0){
                    $customer_id = $getcustomerid->row()->id;
                }
            }
        }
        if ($this->session->userdata('company_code') == 'NZKN') {
            if ($product == "") {
                $product = "KN AsiaLink";
            }
            if ($modeof_trasnport == "") {
                $modeof_trasnport = "LTL";
            }
            if ($service == "") {
                $service = "19";
            }
        }
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $logdate = $getactual['datetime'];
        $getpickup = getdatetimebytimezone(DFLT_TZ,$e_pickup,$curtz);
        $e_pickup = $getpickup['datetime'];
        $getlpickup = getdatetimebytimezone(DFLT_TZ,$l_pickup,$curtz);
        $l_pickup = $getlpickup['datetime'];
        $getdelivery = getdatetimebytimezone(DFLT_TZ,$e_delivery,$curtz);
        $e_delivery = $getdelivery['datetime'];
        $getldelivery = getdatetimebytimezone(DFLT_TZ,$l_delivery,$curtz);
        $l_delivery = $getldelivery['datetime'];
        $ins       = array('shipment_id' => $ship_row_id, 'customer_id' => $customer_id, 'product' => $product, 'pickup_datetime' => $e_pickup, 'delivery_datetime' => $e_delivery, 'pickup_endtime' => $l_pickup, 'drop_endtime' => $l_delivery, 'goods_value' => $goods_value, 'company_code' => $company_code, 'branch_code' => $branch_code, 'createdon' => $cdate, 'drop_custid' => $drop_id, 'drop_partyid' => $drop_id, 'user_id' => $user_id, 'pickup_custid' => $pickup_custid, 'pickup_partyid' => $pickup_custid, 'pickup_country' => $pickup_country, 'pickup_city' => $pickup_city, 'pickup_pincode' => $pickup_pincode, 'pickup_company' => $pickup_name, 'pickup_address1' => $pickup_street,'pickup_address2'=>$pickup_state, 'delivery_country' => $drop_country, 'delivery_city' => $drop_city, 'delivery_pincode' => $drop_pincode, 'delivery_company' => $drop_name, 'delivery_address1' => $drop_street,'delivery_address2'=>$drop_state, 'is_created' => '1', 'plat' => $lat1, 'plng' => $lng1, 'dlat' => $lat2, 'dlng' => $lng2, 'transport_mode' => $modeof_trasnport,'created_source'=>'4','createdon'=>$logdate);
        $ins_order = $this->db->insert("tb_orders", $ins);
        $order_id  = $this->db->insert_id();

        $user_id = $this->session->userdata('user_id');
        if ($user_id != "") {
            $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
            $country_code  = $get_country->row()->country_code;
            $company_code  = $get_country->row()->company_code;
            $genord = array("user_id"=>$user_id,"order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code);
            $booking_id = generatebookingid($genord);
            $upd     = $this->db->where(array('id' => $order_id))->update("tb_orders", array('order_id' => $booking_id));
            $details = array('service' => $service, 'delivery_term' => $delivery_terms, 'incoterm' => $incoterm, 'purchase_order' => $porder, 'notify_party' => $notify_party, 'lane_reference' => $lane_reference, 'distance' => $distance, 'department_code' => $department_code, 'temperature_control' => $temp_control, 'valorance_insurance' => $ad_valorence_ins, 'high_cargo_value' => $high_value_cargo, 'customs_required' => $customs_required, 'order_row_id' => $order_id, 'order_id' => $booking_id, 'createdon' => $cdate, 'shipper_id' => $order_shipper_id, 'order_type' => $order_type);
            $this->db->insert("tb_order_details", $details);
        }
        $shipper_address    = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
        $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
        if ($chk_shipperaddress->num_rows() > 0) {
            $shipperadd_id = $chk_shipperaddress->row()->id;
            $upd_add       = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
        } else {
            $shipper_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $shipper_address);
            $shipperadd_id = $this->db->insert_id();
        }
        $delivery_address    = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
        $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
        if ($chk_deliveryaddress->num_rows() > 0) {
            $dropadd_id = $chk_deliveryaddress->row()->id;
            $upd_add    = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
        } else {
            $delivery_address['createdon'] = $cdate;
            $this->db->insert("tbl_orderparty_address", $delivery_address);
            $dropadd_id = $this->db->insert_id();
        }
        $cargo_forship = array();
        if ($order_cargo_id != "") {
            $cargo_ids = array();
            $cargo_ids = explode(',', $order_cargo_id);
            for ($i = 0; $i < count($cargo_ids); $i++) {
                $length           = $width           = $height           = $weight           = $volume           = 0;
                $quantity         = 1;
                $getcargo_details = $this->db->query("SELECT cargo_type,length,width,height,weight,volumetric_weight,volume,quantity,goods_description FROM tb_cargo_details WHERE id='" . $cargo_ids[$i] . "'");
                $cargo_type       = $description       = "";
                if ($getcargo_details->num_rows() > 0) {
                    $length            = $getcargo_details->row()->length;
                    $width             = $getcargo_details->row()->width;
                    $height            = $getcargo_details->row()->height;
                    $weight            = $getcargo_details->row()->weight;
                    $volume            = $getcargo_details->row()->volume;
                    $quantity          = $getcargo_details->row()->quantity;
                    $cargo_type        = $getcargo_details->row()->cargo_type;
                    $description       = $getcargo_details->row()->goods_description;
                    $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                    $cargo_forship[$i] = $getcargo_details->row()->cargo_type;
                }
                $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '" . $cargo_type . "'");
                $handling_unit    = "";
                if ($gethandling_unit->num_rows() > 0) {
                    $handling_unit = $gethandling_unit->row()->id;
                } else {
                    $handlingunit_ar = array('unit_name' => $cargo_type,'description'=>$cargo_type,  'user_id' => $user_id, 'created_at' => $cdate, 'status' => '1');
                    $this->db->insert("tbl_shipunit_types", $handlingunit_ar);
                    $handling_unit = $this->db->insert_id();
                }
                $cargo     = array('order_id' => $order_id, 'cargo_id' => $cargo_ids[$i], 'status' => '1', 'length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight,'volumetric_weight'=>$volumetric_weight,'volweight_uom'=>'kg', 'volume' => $volume, 'quantity' => $quantity, 'cargo_content' => $description, 'quantity_type' => $cargo_type, 'handling_unit' => $handling_unit);
                $ins_cargo = $this->db->insert("tb_order_cargodetails", $cargo);
            }
        }
        $unitspec = "1";
        if (!empty($cargo_forship)) {
            $unitspec = implode(',', $cargo_forship);
        }
        $updship      = $this->db->where(array('id' => $ship_row_id))->update("tb_shipments", array('unitspec' => $unitspec, 'txncode' => $booking_id));
        $total_weight = $total_volume = $total_quantity = 0;
        $gettotal     = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $order_id . "'");
        if ($gettotal->num_rows() > 0) {
            $total_volume   = $gettotal->row()->total_volume;
            $total_weight   = $gettotal->row()->total_weight;
            $total_quantity = $gettotal->row()->total_quantity;
        }
        $upd_order = $this->db->where(array('id' => $order_id))->update("tb_orders", array('volume' => $total_volume, 'weight' => $total_weight, 'quantity' => $total_quantity));
        $ids       = array();
        if ($reference_ids != "0") {
            $refids = explode(',', $reference_ids);
        }
        if (!empty($refids)) {
            for ($i = 0; $i < count($refids); $i++) {
                if ($refids[$i] != "") {
                    $chk = $this->db->query("SELECT o.id FROM tb_reference_master r,tb_order_references o WHERE r.id='" . $refids[$i] . "' AND r.name=o.reference_id");
                    if ($chk->num_rows() > 0) {
                        $upd = $this->db->where(array('id' => $chk->row()->id))->update("tb_order_references", array('order_id' => $order_id));
                    }
                }

            }
        }
        if ($shipment_id != "") {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'DQ', 'ref_value' => $shipment_id, 'createdon' => $cdate);
            $ins     = $this->db->insert('tb_order_references', $ins_ref);

        }
        if($company_code == 'UKKN' || $company_code == 'AUKN'){
            if ($container_no != "") {
                $ins_ref = array('order_id' => $order_id, 'reference_id' => 'CTR', 'ref_value' => $container_no, 'createdon' => $cdate);
                $ins     = $this->db->insert('tb_order_references', $ins_ref);

            }
        }
        if ($porder != "") {
            $ins_ref = array('order_id' => $order_id, 'reference_id' => 'PO', 'ref_value' => $porder, 'createdon' => $cdate);
            $ins     = $this->db->insert('tb_order_references', $ins_ref);

        }

        if ($party_row_id != "0") {
            $ids = explode(',', $party_row_id);
        }
        if ($order_inv_row_id != 0 || $order_inv_row_id != "") {
            array_push($ids, $order_inv_row_id);
        }
            if (!empty($ids)) {
                for ($i = 0; $i < count($ids); $i++) {
                    if ($ids[$i] != "") {
                        $getpartytype = $this->db->query("SELECT party_type_id FROM tbl_party_master WHERE id='" . $ids[$i] . "'");
                        $party_type   = 1;
                        if ($getpartytype->num_rows() > 0) {
                            $party_type = $getpartytype->row()->party_type_id;
                        }
                        $party     = array('order_id' => $order_id, 'party_id' => $ids[$i], 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
                        $ins_party = $this->db->insert("tb_order_parties", $party);
                    }
                }
            }
            if($order_shipper_id != "" || $order_shipper_id != 0){
                $party_type = 0;
                $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
                if($chk->num_rows() >0){
                    $party_type = $chk->row()->id;
                }else{
                   $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'user_id'=>$user_id));
                   if($chk1->num_rows()>0)
                       $party_type = $chk1->row()->id;
               }

               $party     = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
               $ins_party = $this->db->insert("tb_order_parties", $party);
           }
           if($delivery != "" || $delivery != 0){
            $party_type = 0;
            $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
            if($chk->num_rows() >0){
                $party_type = $chk->row()->id;
            }else{
                $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'user_id'=>$user_id));
                if($chk1->num_rows()>0){
                   $party_type = $chk1->row()->id;
               }
           }
           $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
           $ins_party = $this->db->insert("tb_order_parties", $party);
       }
        $this->ordernotify('booking_create',$order_id);
   }
   redirect("XBRDRorders");

}

public function savequickbook()
{

    $cdate = date('Y-m-d H:i:s');
    $user_id = $this->session->userdata('user_id');
    $cust_id = $this->session->userdata('cust_id');
    $company_code = isset($_POST['popupcompany_code']) ? $this->db->escape_str($_POST['popupcompany_code']) : "";
    $branch_code = isset($_POST['popupbranch_code']) ? $this->db->escape_str($_POST['popupbranch_code']) : "";
    $department_code = isset($_POST['popupdepartment_code']) ? $this->db->escape_str($_POST['popupdepartment_code']) : "";
    $product = isset($_POST['productpopup']) ? $this->db->escape_str($_POST['productpopup']) : "";
    $service = isset($_POST['servicepopup']) ? $this->db->escape_str($_POST['servicepopup']) : "";
    $delivery_terms = isset($_POST['popupdelivery_terms']) ? $this->db->escape_str($_POST['popupdelivery_terms']) : "";
    $incoterm = isset($_POST['incoterm_popup']) ? $this->db->escape_str($_POST['incoterm_popup']) : "";
    $shipment_id = isset($_POST['popupdelivery_note']) ? $this->db->escape_str($_POST['popupdelivery_note']) : "";
    $porder = isset($_POST['purchaseorder_popup']) ? $this->db->escape_str($_POST['purchaseorder_popup']) : "";
    $notify_party = isset($_POST['popupnotifyparty']) ? $this->db->escape_str($_POST['popupnotifyparty']) : "";
    $popuppickup = isset($_POST['popuppickup']) ? $this->db->escape_str($_POST['popuppickup']) : "";
    $popupdelivery = isset($_POST['popupdelivery']) ? $this->db->escape_str($_POST['popupdelivery']) : "";

    $earlyquickbook_delivery = $latequickbook_delivery = "";
    if($popupdelivery != ""){
      $earlyquickbook_delivery = date('Y-m-d H:i:s',strtotime($popupdelivery));
      $latequickbook_delivery = date('Y-m-d H:i:s',strtotime('+1 hour',strtotime($earlyquickbook_delivery)));
    }
    $earlyquickbook_pickup = $latequickbook_pickup = "";
    if($popuppickup != ""){
      $earlyquickbook_pickup = date('Y-m-d H:i:s',strtotime($popuppickup));
      $latequickbook_pickup = date('Y-m-d H:i:s',strtotime('+1 hour',strtotime($earlyquickbook_pickup)));
    }
    $popuporder_type = isset($_POST['popuporder_type']) ? $this->db->escape_str($_POST['popuporder_type']) : "";
    $popupmodeof_trasnport = isset($_POST['popupmodeof_trasnport']) ? $this->db->escape_str($_POST['popupmodeof_trasnport']) : "LTL";

    $reference_ids = isset($_POST['quickbookreference_ids']) ? $this->db->escape_str($_POST['quickbookreference_ids']) : "0";
    $quickbook_order_reference_ids = isset($_POST['quickbook_order_reference_ids']) ? $this->db->escape_str($_POST['quickbook_order_reference_ids']) : "0";
    $order_cargo_id = isset($_POST['quickbookorder_cargo_id']) ? $this->db->escape_str($_POST['quickbookorder_cargo_id']) : "";
     $inv_parties = array($_POST['quickbookshipper_id'],$_POST['quickboookconsignee_id']);
    $pickup = $this->db->escape_str($_POST['quickbookpickup_id']);
    $delivery = $this->db->escape_str($_POST['quickboookconsignee_id']);
    $drop_id = $pickup_custid = 0;
      $pickup_name = $pickup_country = $pickup_street = $pickup_state = $drop_state = $pickup_pincode = $pickup_city =$drop_name = $drop_country = $drop_street = $drop_pincode = $drop_city = "";
    $getdrop_custid= $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='".$delivery."'");
    if($getdrop_custid->num_rows() >0){
      $drop_id = $getdrop_custid->row()->customeridentifier;
      $drop_name = $getdrop_custid->row()->name;
        $drop_country = $getdrop_custid->row()->country;
        $drop_state = $getdrop_custid->row()->state;
        $drop_street = $getdrop_custid->row()->street;
        $drop_pincode = $getdrop_custid->row()->pincode;
        $drop_city = $getdrop_custid->row()->city;
    }
    $getshippercustid= $this->db->query("SELECT name,country,state,street,customeridentifier,pincode,location_id as city FROM tbl_party_master WHERE id='".$_POST['quickbookshipper_id']."'");
    if($getshippercustid->num_rows() >0){
        $pickup_custid = $getshippercustid->row()->customeridentifier;
        $pickup_name = $getshippercustid->row()->name;
        $pickup_country = $getshippercustid->row()->country;
        $pickup_state = $getshippercustid->row()->state;
        $pickup_street = $getshippercustid->row()->street;
        $pickup_pincode = $getshippercustid->row()->pincode;
        $pickup_city = $getshippercustid->row()->city;
    }
    $tname = "Full Truck Load";
    $tid ="FTL";
     $enddate = date('Y-m-d H:i:s',strtotime("+1 day"));
       $tid = 1; $tname = "";
      $gettrasnportmode = $this->db->query("SELECT id,name FROM tb_transportmode WHERE code LIKE '".$popupmodeof_trasnport."'");
        if($gettrasnportmode->num_rows() >0){
          $tid = $gettrasnportmode->row()->id;
          $tname= $gettrasnportmode->row()->name;
        }
        if($shipment_id == ""){
            $shipment_id = "KN".time();
        }
        $ship_row_id = 0;
     $ship_arr = array('shipid'=>$shipment_id,'txnid'=>$shipment_id,'trucktype'=>$tname,'pickupcnt'=>'1','dropcnt'=>'1','insertusr'=>$pickup_custid,'carrier'=>'0','insertuserdate'=>$cdate,'enddate'=>$enddate,'insdate'=>$cdate,'upddate'=>$cdate,'reason'=>'SHIPMENT','purpose'=>'SEND INTEGRATION','ship_object'=>'SHIPMENT','logdate'=>$cdate,'transport_mode'=>$popupmodeof_trasnport,'domainname'=>$branch_code,'company_code'=>$company_code,'branch_code'=>$branch_code,'product'=>$product,'freight_term'=>'60','freight_termname'=>'Free of Charge','incoterm'=>$incoterm,'modeoftransport'=>$tid,'unitspec'=>1);
      $chk_shipid= $this->db->query("SELECT id FROM tb_shipments WHERE shipid LIKE '".$shipment_id."'");

      if($chk_shipid->num_rows() >0){
        $ship_row_id = $chk_shipid->row()->id;
        $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",$ship_arr);
      }else{

       $ship_arr['createdon'] = $cdate;
        $ship_ins = $this->db->insert("tb_shipments",$ship_arr);
        $ship_row_id = $this->db->insert_id();
      }
     $add1 = implode(",",[$pickup_street,$pickup_city,$pickup_country,$pickup_pincode]);
      $add2 = implode(",",[$drop_street,$drop_city,$drop_country,$drop_pincode]);
      $data = getlatlngsbyplace($add1);
      $lat1 = @$data[0];
      $lng1 = @$data[1];
      $data = [];
      $data = getlatlngsbyplace($add2);
      $lat2 = @$data[0];
      $lng2 = @$data[1];
       $customer_id = $cust_id;
      if($this->session->userdata('company_code') == 'NZKN'){
        if($product == ""){
          $product = "KN AsiaLink";
        }
        if($popupmodeof_trasnport == ""){
          $popupmodeof_trasnport = "LTL";
        }
        if($service == ""){
          $service = "19";
        }
      }
    $curtz = $this->session->userdata("usr_tzone")['timezone'];
    $logdate = date('Y-m-d H:i:s');
    $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
    $logdate = $getactual['datetime'];
    $getpickup = getdatetimebytimezone(DFLT_TZ,$earlyquickbook_pickup,$curtz);
    $earlyquickbook_pickup = $getpickup['datetime'];
    $getlpickup = getdatetimebytimezone(DFLT_TZ,$latequickbook_pickup,$curtz);
    $latequickbook_pickup = $getlpickup['datetime'];
    $getdelivery = getdatetimebytimezone(DFLT_TZ,$earlyquickbook_delivery,$curtz);
    $earlyquickbook_delivery = $getdelivery['datetime'];
    $getldelivery = getdatetimebytimezone(DFLT_TZ,$latequickbook_delivery,$curtz);
    $latequickbook_delivery = $getldelivery['datetime'];
    $ins = array('goods_value'=>'0.00','shipment_id'=>$ship_row_id,'customer_id'=>$customer_id,'product'=>$product,'company_code'=>$company_code,'branch_code'=>$branch_code,'createdon'=>$cdate,'pickup_datetime'=>$earlyquickbook_pickup,'delivery_datetime'=>$earlyquickbook_delivery,'pickup_endtime'=>$latequickbook_pickup,'drop_endtime'=>$latequickbook_delivery,'drop_custid'=>$drop_id,'drop_partyid'=>$drop_id,'user_id'=>$user_id,'pickup_custid'=>$pickup_custid,'pickup_partyid'=>$pickup_custid,'pickup_country'=>$pickup_country,'pickup_city'=>$pickup_city,'pickup_pincode'=>$pickup_pincode,'pickup_company'=>$pickup_name,'pickup_address1'=>$pickup_street,'delivery_country'=>$drop_country,'delivery_city'=>$drop_city,'delivery_pincode'=>$drop_pincode,'delivery_company'=>$drop_name,'delivery_address1'=>$drop_street,'pickup_address2'=>$pickup_state,'delivery_address2'=>$drop_state,'transport_mode'=>$popupmodeof_trasnport,'plat'=>$lat1,'plng'=>$lng1,'dlat'=>$lat2,'dlng'=>$lng2,'modeoftransport'=>$tid,'created_source'=>'3','createdon'=>$logdate);
    $ins_order = $this->db->insert("tb_orders",$ins);
    $order_id = $this->db->insert_id();
    $user_id = $this->session->userdata('user_id');
    if($user_id != ""){
    $get_country = $this->db->select('country_code,company_code')->get_where("tb_users",array('id'=>$user_id));
    $country_code  = $get_country->row()->country_code;
    $company_code  = $get_country->row()->company_code;
    $genord = array("user_id"=>$user_id,"order_id"=>$order_id,"country_code"=>$country_code,"company_code"=>$company_code);
    $booking_id = generatebookingid($genord);
    $upd = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('order_id'=>$booking_id));
    $details = array('shipper_id'=>$_POST['quickbookshipper_id'],'service'=>$service,'delivery_term'=>$delivery_terms,'incoterm'=>$incoterm,'purchase_order'=>$porder,'notify_party'=>$notify_party,'department_code'=>$department_code,'createdon'=>$cdate,'order_row_id'=>$order_id,'order_id'=>$booking_id,'order_type'=>$popuporder_type);
    $this->db->insert('tb_order_details',$details);
    }
    $order_shipper_id  = isset($_POST['quickbookshipper_id']) ? $_POST['quickbookshipper_id'] : "";
    $pickup_address = $pickup_street.",".$pickup_city.",".$pickup_state;
   $shipper_address    = array('order_id' => $order_id, 'party_master_id' => $order_shipper_id, 'location_id' => $pickup_city, 'street' => $pickup_street, 'state' => $pickup_state, 'address' => $pickup_address, 'pincode' => $pickup_pincode, 'country' => $pickup_country, 'user_id' => $user_id);
      $chk_shipperaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $order_shipper_id));
      if ($chk_shipperaddress->num_rows() > 0) {
          $shipperadd_id = $chk_shipperaddress->row()->id;
          $upd_add       = $this->db->where(array('id' => $shipperadd_id))->update("tbl_orderparty_address", $shipper_address);
      } else {
          $shipper_address['createdon'] = $cdate;
          $this->db->insert("tbl_orderparty_address", $shipper_address);
          $shipperadd_id = $this->db->insert_id();
      }
      $drop_address = $drop_street.",".$drop_city.",".$drop_state;
      $delivery_address    = array('order_id' => $order_id, 'party_master_id' => $delivery, 'location_id' => $drop_city, 'street' => $drop_street, 'state' => $drop_state, 'address' => $drop_address, 'pincode' => $drop_pincode, 'country' => $drop_country, 'user_id' => $user_id);
      $chk_deliveryaddress = $this->db->select("id")->get_where("tbl_orderparty_address", array('order_id' => $order_id, 'party_master_id' => $delivery));
      if ($chk_deliveryaddress->num_rows() > 0) {
          $dropadd_id = $chk_deliveryaddress->row()->id;
          $upd_add    = $this->db->where(array('id' => $dropadd_id))->update("tbl_orderparty_address", $delivery_address);
      } else {
          $delivery_address['createdon'] = $cdate;
          $this->db->insert("tbl_orderparty_address", $delivery_address);
          $dropadd_id = $this->db->insert_id();
      }
    if($order_cargo_id != ""){
      $cargo_ids = array();
        $cargo_ids = explode(',', $order_cargo_id);

        for($i=0;$i<count($cargo_ids);$i++){
           $length =
                  $width =  $height = $weight = $volume = 0;
                  $quantity = 1;
            if($cargo_ids[$i] != ""){
                $getcargo_details = $this->db->query("SELECT cargo_type,goods_description,length,width,height,weight,volumetric_weight,volume,quantity FROM tb_cargo_details WHERE id='".$cargo_ids[$i]."'");
                $length = $width = $height = $weight = $volume = $quantity = $cargo_type = $description= "";
                if($getcargo_details->num_rows() >0){
                  $length = $getcargo_details->row()->length;
                  $width = $getcargo_details->row()->width;
                  $height = $getcargo_details->row()->height;
                  $weight = $getcargo_details->row()->weight;
                  $volume = $getcargo_details->row()->volume;
                  $volumetric_weight = $getcargo_details->row()->volumetric_weight;
                  $quantity = $getcargo_details->row()->quantity;
                  $cargo_type = $getcargo_details->row()->cargo_type;
                  $description = $getcargo_details->row()->goods_description;
                }
                $gethandling_unit = $this->db->query("SELECT id FROM tbl_shipunit_types WHERE unit_name LIKE '".$cargo_type."'");
              $handling_unit = "";
              if($gethandling_unit->num_rows() >0){
                $handling_unit = $gethandling_unit->row()->id;
              }else{
                $handlingunit_ar = array('unit_name'=>$cargo_type,'description'=>$cargo_type, 'user_id'=>$user_id,'created_at'=>$cdate,'status'=>'1');
                $this->db->insert("tbl_shipunit_types",$handlingunit_ar);
                $handling_unit = $this->db->insert_id();
              }
            $cargo = array('order_id'=>$order_id,'cargo_id'=>$cargo_ids[$i],'status'=>'1','length'=>$length,'width'=>$width,'height'=>$height,'weight'=>$weight,'volume'=>$volume,'quantity'=>$quantity,'cargo_content'=>$description,'quantity_type'=>$cargo_type,'handling_unit'=>$handling_unit,'volumetric_weight'=>$volumetric_weight,'volweight_uom'=>'kg');
            $this->db->insert("tb_order_cargodetails",$cargo);
            }
        }
    }
     $total_weight = $total_volume = $total_quantity = 0;
      $gettotal = $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='".$order_id."'");
      if($gettotal->num_rows() >0){
        $total_volume = $gettotal->row()->total_volume;
        $total_weight = $gettotal->row()->total_weight;
        $total_quantity = $gettotal->row()->total_quantity;
      }
       $cargo_forship = array();
      $getcargos  = $this->db->query("SELECT quantity_type FROM tb_order_cargodetails WHERE order_id ='".$order_id."'");
      if($getcargos->num_rows() >0){
        foreach($getcargos->result() as $res){
          $cargo_forship[] = $res->quantity_type;
        }
      }
      $unitspec = "";
      if(!empty($cargo_forship)){
        $unitspec = implode(',', $cargo_forship);
      }
      $updship = $this->db->where(array('id'=>$ship_row_id))->update("tb_shipments",array('unitspec'=>$unitspec,'txncode'=>$booking_id));
       $upd_order = $this->db->where(array('id'=>$order_id))->update("tb_orders",array('volume'=>$total_volume,'weight'=>$total_weight,'quantity'=>$total_quantity));
    $ids = array();
    if($reference_ids != "0"){
      $refids = explode(',', $reference_ids);
    }
    $order_ref_ids = array();
    if($quickbook_order_reference_ids != "0"){
      $order_ref_ids = explode(',', $quickbook_order_reference_ids);
    }
    if(!empty($order_ref_ids)){
      for($i=0;$i<count($order_ref_ids);$i++){
          if($order_ref_ids[$i] != ""){
              $upd = $this->db->where(array('id'=>$order_ref_ids[$i]))->update("tb_order_references",array('order_id'=>$order_id));
          }
    }
    }
    if($shipment_id != ""){
        $ins_ref = array('order_id'=>$order_id,'reference_id'=>'DQ','ref_value'=>$shipment_id,'createdon'=>$cdate);
        $ins = $this->db->insert('tb_order_references',$ins_ref);

      }
       if($porder != ""){
        $ins_ref = array('order_id'=>$order_id,'reference_id'=>'PO','ref_value'=>$porder,'createdon'=>$cdate);
        $ins = $this->db->insert('tb_order_references',$ins_ref);

      }
    if($order_shipper_id != "" || $order_shipper_id != 0){

            $party_type = 0;
           $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
           if($chk->num_rows() >0){
            $party_type = $chk->row()->id;
           }else{
             $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Shipper','company_code'=>$company_code,'user_id'=>$user_id));
            if($chk1->num_rows()>0)
             $party_type = $chk1->row()->id;
           }

             $party     = array('order_id' => $order_id, 'party_id' => $order_shipper_id, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
                    $ins_party = $this->db->insert("tb_order_parties", $party);

    }
    if($delivery != "" || $delivery != 0){
        $party_type = 0;
        $chk = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'branch_code'=>$branch_code,'user_id'=>$user_id));
       if($chk->num_rows() >0){
            $party_type = $chk->row()->id;
       }else{
            $chk1 = $this->db->select("id")->get_where("tbl_party_types",array('name'=>'Consignee','company_code'=>$company_code,'user_id'=>$user_id));
            if($chk1->num_rows()>0){
             $party_type = $chk1->row()->id;
            }
       }
        $party = array('order_id' => $order_id, 'party_id' => $delivery, 'status' => '1', 'createdon' => $cdate, 'status' => '1', 'party_type' => $party_type, 'order_number' => $booking_id);
                    $ins_party = $this->db->insert("tb_order_parties", $party);
    }
     $this->ordernotify('booking_create',$order_id);
    redirect("XBRDRorders");

}

/* code for trip management */


public function ordernotify($action,$orderid){
  /*  $this->load->library('notifytrigger');
    $info['page_title'] = 'Booking Notification';
    $info['subject'] = 'Booking Notification';
    $info['order_id'] = $orderid;
    $info['action'] = $action;
    $orderinfo = $this->common->gettblrowdata(array('id'=>$orderid),'order_id','tb_orders',0,0);
    if($orderinfo){
        $info['orderid'] = $orderinfo['order_id'];
        $info['cargos'] = $this->common->gettbldata(array('order_id'=>$orderid),'quantity_type,quantity','tb_order_cargodetails',0,0);
        $info['body'] = $this->load->view('mail_forms/notifytrigger/'.$action,$info,true);
        $this->notifytrigger->sendordernotify($info);
    }*/
}

    public function massstatus()
    {
        $userRoleId = $this->session->userdata('user_role_id');
        $companyCode = $this->session->userdata('company_code');
        if (checkAccessConditions('RELATED_2_SG_MY', $this->session->userdata('company_code')) && $userRoleId !== "5") {
            redirect('SmtcXBRDRorders/massstatus');
        }
        $config = [];
        $data['page_title'] = $this->lang->line('menu_massstsupd');
        $data['sub_title'] = $this->lang->line('general_search');
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $post = $this->input->post(null, true);
        $crossBorderTrips = $this->crossborderlib->getMassStatusData($post);
        $crossBorderShiftIds = $shiftData = $tripsdata = [];
        if(!empty($crossBorderTrips)){
            foreach ($crossBorderTrips as $eachLine) {
                $shiftLegIds[] = $eachLine['shift_leg_id'];
                $crossBorderShiftIds[] = $eachLine['id'];
                $orderIds[] = $eachLine['id'];
                $shiftData[$eachLine['employee_id']] = [
                    'id' => $eachLine['id'],
                    'shiftLegId' => $eachLine['shift_leg_id'],
                    'employeeId' => $eachLine['employee_id'],
                    'shipmentId' => $eachLine['shipmentid'],
                    'vehicleId' => $eachLine['vehicle_id'],
                    'driverId' => $eachLine['driver_id'],
                    'imei' => $eachLine['imei'],
                    'contactNumber' => $eachLine['contact_num'],
                    'trackType' => $eachLine['track_type'],
                    'trackVendor' => $eachLine['track_vendor'],
                    'simCarrier' => $eachLine['sim_carrier'],
                    'orderRowId' => $eachLine['orderrowid'],
                    'bookingId' => $eachLine['order_id'],
                    'tripId' => $eachLine['trip_id'],
                    'crossBorderCheck' => '1',
                    'shift_id'=>$eachLine['id']
                ];
            }
        }
        if (!empty($crossBorderShiftIds)) {
            sort($crossBorderShiftIds);
            $totalCount = count($crossBorderShiftIds);
            $config["base_url"] = base_url() . "XBRDRorders/massstatus";
            $config["total_rows"] = $totalCount;
            $config["per_page"] = 10;
            $config["uri_segment"] = 3;
            $config['display_pages'] = true;
            $this->pagination->initialize($config);
            $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
            if ($page == "01") {
                $page = 0;
            }
            $finalResult = $this->trips_model->getTripsBasedOnId($crossBorderShiftIds,$config['per_page'],$page);
            $tripsdata = $this->crossborderlib->getstopsStatusBasedOnLegsForOrder($finalResult,$shiftData);
        }
        $data['tripsdata'] = $tripsdata;
        $data['postdata'] = $post;
        $data['curtz'] = $currentTimeZone;
        $data['companyCode'] = $companyCode;
        $data['userRoleId'] = $userRoleId;
        $this->newtemplate->dashboard("admin/crossbordermassstatus", $data);
    }

}

?>
