<?php

use App\PodUploads\CheckSignatureAndPodTrait;
use App\ShiftsData\AddressesFromShiftTrait;
use App\ShiftsData\ExtractShiporderStopsTrait;
use App\ShiftsData\GetStopstatuses;
use App\ShiftsData\ProcessStopstatuses;

defined('BASEPATH') OR exit('No direct script access allowed');

use App\ShipmentStopDetails\ShipmentStopDetailsService;
use App\ShipmentStops\GetShipmentStopsService;
use phpseclib\Net\SFTP;

class Xdocapp extends CI_Controller {
    use CheckSignatureAndPodTrait;
    use AddressesFromShiftTrait;
    use ExtractShiporderStopsTrait;
    private const  KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    function __construct() {
        parent::__construct();

        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }

        $this->load->helper('date');
        $this->load->helper('cabs');
        $this->load->model('cabmodel');
        $this->load->model('common');
        $this->load->library('smsnotifier');
        $this->load->library('sendfirebase');
        $this->load->library("statusintigration");
        $this->load->helper("jwt");
        $this->load->helper("log_helper");
    }

    /*
     *   Purpose : secure view parsing.
     *   @Param token string  encripted string.
     *   retrun CI_VIEW
     */

    public function index($token = '') {
        if ($token == '') {
            redirect('xdocapplogin', 'refresh');
        } else {
            if (strlen($token) > 10) {
                $data['token'] = urldecode($token);

                $this->session->set_userdata('secure_token_link', 'xdocapp/' . urldecode($token));
                $this->load->view("xdocapp/index", $data);
            } else {
                redirect('xdocapplogin', 'refresh');
            }
        }
    }

    /*
     *   Purpose : Login Authentication if given details are true it will routes to home page.
     *   @Param mobie    int
     *   @Param password string
     *   retrun CI_VIEW
     */

    public function auth() {
        $_POST['imei'] = $this->input->post('mobile', TRUE);
        $_POST['mobile_number'] = $this->input->post('mobile', TRUE);
        $driver_data = json_decode($this->driverLogin());
        if ($driver_data->status != 1) {
            redirect('xdocapplogin', 'refresh');
        }
        $driver_data_obj = $driver_data->data;
        $imei = $driver_data_obj->imei ?? ($_POST['imei'] ?? '');

        $this->session->set_userdata('is_login', TRUE);
        $this->session->set_userdata('imei', $imei);

        $this->session->set_userdata('id', $driver_data_obj->id);
        $this->session->set_userdata('name', $driver_data_obj->name);
        $this->session->set_userdata('user_id', $driver_data_obj->user_id);
        $this->session->set_userdata('vendor_id', $driver_data_obj->vendor_id);
        $this->session->set_userdata('mobile_no', $driver_data_obj->mobile_no);
        $this->session->set_userdata('vehicle', $driver_data_obj->vehicle);
        $this->session->set_userdata('vehicle_id', $driver_data_obj->vehicle_id);
        $this->session->set_userdata('trip_id', $driver_data_obj->trip_id);
        $this->session->set_userdata('timezone', $driver_data_obj->timezone);
        $this->session->set_userdata('user_enc_p', $driver_data_obj->password);
        $timezone = $driver_data_obj->timezone;

        $usr_tzone = array('timezone' => $timezone);
        $this->session->set_userdata('usr_tzone', $usr_tzone);
        date_default_timezone_set($timezone);
        redirect('xdocapphome', 'refresh');
    }

    /*
     *   Purpose : User Home screen after successfull login attempt.
     *   retrun CI_VIEW
     */

    public function home() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['body_content'] = 'xdocapp/home';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *   Purpose : To know a shipment is deviated or not
     *   retrun CI_VIEW
     */

    public function login() {
        $data['body_content'] = 'xdocapp/login';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *   Purpose : Users Shipment home screen
     *   retrun CI_VIEW
     */

    public function shipment_home() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['body_content'] = 'xdocapp/shipment_home';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *   Purpose : This shows active shipment for specific driver.
     *   retrun CI_VIEW
     */

    public function shipment_list() {
        if ($this->session->userdata('is_login')) {
            $timezone = $this->session->userdata('timezone');
            $id = $this->session->userdata('id');
            $imei = $this->session->userdata('imei');
            $_POST = array(
                "driver_id" => $id, "imei" => $imei, 'timezone' => $timezone
            );
            $shipments_info = json_decode($this->getshipments());
            if ($shipments_info->status) {
                $ship_data = $shipments_info->data;
                $shipment_trips = $ship_data->trips;
                $size_of_ship_data = (!empty($shipment_trips)) ? sizeof($shipment_trips) : 0;
                for ($i = 0; $i < $size_of_ship_data; $i++) {
                    $trip_id = $ship_data->trips[$i]->id;
                    $shift_id = $ship_data->trips[$i]->shift_id;
                    $shift_veh_id = $ship_data->trips[$i]->shift_veh_id;
                    $ship_data->trips[$i]->stops_list = $this->get_shipment_stops_list($shift_id, $trip_id, $shift_veh_id);
                }
            }

            $data['shipments_info'] = $shipments_info;
            $data['body_content'] = 'xdocapp/shipment_list';
            $this->load->view('xdocapp/index', $data);
        } else {
            redirect('xdocapplogin', 'refresh');
        }
    }

    /*
     *    Purpose : Search activiy in shipment list
     *    $param  search mixed
     *    return  CI_VIEW
     */

    public function shipment_list_search() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $timezone = $this->session->has_userdata('timezone');
        $id = $this->session->userdata('id');
        $imei = $this->session->userdata('imei');
        $search = $this->input->post('search', TRUE);
        $_POST = array("driver_id" => $id, "imei" => $imei, 'timezone' => $timezone, 'search' => $search);
        $shipments_info = json_decode($this->getshipments());
        if ($shipments_info->status) {
            $ship_data = $shipments_info->data;
            $shipment_trips = $ship_data->trips;
            $size_of_ship_data = (!empty($shipment_trips)) ? sizeof($shipment_trips) : 0;
            for ($i = 0; $i < $size_of_ship_data; $i++) {
                $trip_id = $ship_data->trips[$i]->id;
                $shift_id = $ship_data->trips[$i]->shift_id;
                $shift_veh_id = $ship_data->trips[$i]->shift_veh_id;
                $ship_data->trips[$i]->stops_list = $this->get_shipment_stops_list($shift_id, $trip_id, $shift_veh_id);
            }
        }
        $data['shipments_info'] = $shipments_info;
        $this->load->view('xdocapp/shipment_list_search', $data);
    }

    /*
     *    Purpose : To see orders list
     */

    public function orders() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['body_content'] = 'xdocapp/orders';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *    Purpose : User profile activity
     *    return  CI_VIEW
     */

    public function profile() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $_POST = array("id" => $this->session->userdata('id'));
        $driver_data = json_decode($this->getDriverData());
        $data['driver_data'] = $driver_data;
        $data['body_content'] = 'xdocapp/profile';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *    Purpose : Completed shipment list based on driver
     *    return  CI_VIEW
     */

    public function shipment_completed() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $id = $this->session->userdata('id');
        $imei = $this->session->userdata('imei');
        $_POST = array("driver_id" => $id, "imei" => $imei, 'type' => '2');
        $shipments_info = json_decode($this->getshipments());

        $data['shipments_info'] = $shipments_info;
        $data['body_content'] = 'xdocapp/shipment_completed';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *    Purpose : To search on completed shipments.
     *    return  CI_VIEW
     */

    public function shipment_completed_search() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $search = $this->input->post('search', TRUE);
        $id = $this->session->userdata('id');
        $imei = $this->session->userdata('imei');
        $_POST = array("driver_id" => $id, "imei" => $imei, 'type' => '2', 'search' => $search);
        $shipments_info = json_decode($this->getshipments());

        $data['shipments_info'] = $shipments_info;
        $this->load->view('xdocapp/shipment_completed_search', $data);
    }

    /*
     *    Purpose : Change password activity
     *    return  CI_VIEW
     */

    public function change_password() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        if (isset($_POST) && !empty($_POST)) {
            $password = trim($this->input->post('password', true)); // entered current pwd
            $new_password = trim($this->input->post('new_password', true));
            $confirm_new_password = trim($this->input->post('confirm_new_password', true));
            $current_password = (($this->session->userdata('user_enc_p'))); //  session current password
            if ((!empty($password)) && (!empty($current_password)) && (!empty($confirm_new_password)) && (!empty($new_password))) {
                // all are not emtpy
                if ($password == $current_password) {
                    if ($confirm_new_password == $new_password) {
                        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
                        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
                        $newpassword = isset($_POST['newpassword']) ? $_POST['newpassword'] : "";
                        $_POST = array(
                            'user_id' => $this->session->userdata('user_id'),
                            'driver_id' => $this->session->userdata('id'),
                            'newpassword' => $new_password
                        );
                        $response = $this->updatepassword();
                        redirect('xdocapplogin', 'refresh');
                    } else {

                        redirect('xdocapplogin', 'refresh');
                    }
                } else {

                    redirect('xdocapplogin', 'refresh');
                }
            } else {

                redirect('xdocapplogin', 'refresh');
            }
        }

        $data['body_content'] = 'xdocapp/change_password';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *    Purpose : Collections Entry
     */

    public function collections() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }

        if (isset($_POST) && count($_POST) > 0) {

            $customer_id = $this->input->post('customer_id', TRUE);
            if (is_numeric($customer_id) && $customer_id > 0) {
                echo json_encode(array("status" => 0, "message" => "Please choose valid customer "));
                return;
            }
            $pickup_pary_id = $this->input->post('pickup_pary_id', TRUE);
            if (is_numeric($pickup_pary_id) && $pickup_pary_id > 0) {
                echo json_encode(array("status" => 0, "message" => "Please choose valid pickup party "));
                return;
            }

            $delivery_pary_id = $this->input->post('delivery_pary_id', TRUE);
            if (is_numeric($delivery_pary_id) && $delivery_pary_id > 0) {
                echo json_encode(array("status" => 0, "message" => "Please choose valid pickup destination"));
                return;
            }

            $source_party_location = $this->input->post('source_party_location', TRUE);
            if (trim($source_party_location) != "" && strlen($source_party_location) > 5) {
                echo json_encode(array("status" => 0, "message" => "Please choose valid destination party "));
                return;
            }
            $destination_party_location = $this->input->post('destination_party_location', TRUE);
            if (trim($destination_party_location) != "" && strlen($destination_party_location) > 5) {
                echo json_encode(array("status" => 0, "message" => "Please choose valid destination party "));
                return;
            }

            /*
             *  Source Addresss Block
             */
            $source_party_location = urlencode($this->input->post('source_party_location', TRUE));
            if ($this->input->post('source_party_location') != "") {
                $source_party_details = ProcessGoogleAPICurl("https://maps.googleapis.com/maps/api/geocode/json?address=$source_party_location&key=".GOOGLE_BKND_API_KEY, true);
                if ($source_party_details->status == 'OK') {
                    // push entered address
                    $source_party_details->results[0]->adr_address = urldecode($source_party_location);
                    $source_party_details->results[0]->name = $source_party_details->results[0]->address_components[0]->long_name;
                    /*
                     *  remove un necessary data to make req data more clear.
                     */
                    unset($source_party_details->results[0]->geometry->bounds);
                    unset($source_party_details->results[0]->types);
                    unset($source_party_details->results[0]->geometry->viewport);
                    unset($source_party_details->results[0]->geometry->location_type);
                    $_POST['pickup'] = $source_party_details->results[0];
                } else {
                    $_POST['pickup'] = array();
                }
            } else {
                $_POST['pickup'] = array();
            }
            /*
             *  Destination Address Block
             */

            $destination_party_location = urlencode($this->input->post('destination_party_location'));
            if ($this->input->post('destination_party_location') != "") {
                $destination_party_details = ProcessGoogleAPICurl("https://maps.googleapis.com/maps/api/geocode/json?address=$destination_party_location&key=".GOOGLE_BKND_API_KEY, true);
                if ($destination_party_details->status == 'OK') {
                    // push entered address
                    $destination_party_details->results[0]->adr_address = $this->input->post('destination_party_location', TRUE);
                    $destination_party_details->results[0]->name = $destination_party_details->results[0]->address_components[0]->long_name;
                    /*
                     *  remove un necessary data to make req data more clear.
                     */
                    unset($destination_party_details->results[0]->geometry->bounds);
                    unset($destination_party_details->results[0]->types);
                    unset($destination_party_details->results[0]->geometry->viewport);
                    unset($destination_party_details->results[0]->geometry->location_type);
                    $_POST['destination'] = $destination_party_details->results[0];
                } else {
                    $_POST['destination'] = array();
                }
            } else {
                $_POST['destination'] = array();
            }


            $uoms = $this->input->post('uom', TRUE);
            $uoms_count = sizeof($uoms);
            $uoms1 = array();
            if ($uoms_count > 0) {
                for ($y = 0; $y < $uoms_count; $y++) {
                    $inner_uoms = $uoms[$y];
                    $id = $inner_uoms[0];
                    $name = $inner_uoms[1];
                    $value = $inner_uoms[2];
                    if (is_numeric($id) && is_numeric($value) && is_string($name))
                        $uoms1[] = (object) array("id" => $id, "name" => $name, "value" => $value);
                }
            }
            unset($_POST['uom']);
            $_POST['uoms'] = $uoms1;


            // References
            $references = array();

            $reference_id_1 = $this->input->post('reference_id_1', TRUE);
            $reference_id_1_value = $this->input->post('reference_id_1_value', TRUE);
            if ($reference_id_1 != "" && $reference_id_1_value != "")
                $references[] = (object) array("reference_id" => $reference_id_1, "value" => $reference_id_1_value);

            $reference_id_2 = $this->input->post('reference_id_2', TRUE);
            $reference_id_2_value = $this->input->post('reference_id_2_value', TRUE);
            if ($reference_id_2 != "" && $reference_id_2_value != "")
                $references[] = (object) array("reference_id" => $reference_id_2, "value" => $reference_id_2_value);

            $reference_id_3 = $this->input->post('reference_id_3', TRUE);
            $reference_id_3_value = $this->input->post('reference_id_3_value', TRUE);
            if ($reference_id_3 != "" && $reference_id_3_value != "")
                $references[] = (object) array("reference_id" => $reference_id_3, "value" => $reference_id_3_value);

            $_POST['references'] = $references;

            unset($_POST['reference_id_1'], $_POST['reference_id_1_value'], $_POST['reference_id_2'], $_POST['reference_id_2_value'], $_POST['reference_id_3'], $_POST['reference_id_3_value']);
            unset($_POST['source_party_location'], $_POST['destination_party_location']);



            $driver_id = $this->session->userdata('id');
            $imei = $this->session->userdata('imei');
            $user_id = $this->session->userdata('user_id');
            $timezone = $this->session->userdata('timezone');

            $params = array("user_id" => $user_id, "imei" => $imei, "driver_id" => $driver_id, "timezone" => $timezone,
                "data" => json_encode(array(
                    "pickup_pary_id" => $this->input->post('pickup_pary_id', TRUE),
                    "delivery_pary_id" => $this->input->post('delivery_pary_id', TRUE),
                    "customer_id" => $this->input->post('customer_id', TRUE),
                    "references" => $this->input->post('references', TRUE),
                    "pickup" => $this->input->post('pickup', TRUE),
                    "uoms" => $this->input->post('uoms', TRUE),
                    "destination" => $this->input->post('destination', TRUE)))
            );
            /*
             *  this function is not in user
             */
            /*$final_response = curl_post($params, 'drivercollection');*/

        }

        /*
         *  this function is not in user
         */
        $params = array("user_id" => $this->session->userdata('user_id'));
        $uoms = curl_post($params, 'uoms');

        $data['uoms'] = array();
        if ($uoms->status == 1) {
            $data['uoms'] = $uoms->data;
        }
        $data['body_content'] = 'xdocapp/collections';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *   Purpose : Comming Soon Screen
     */

    public function comming_soon() {
        $data['body_content'] = 'xdocapp/comming_soon';
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *
     * shipment_details - this function responsible for showing pickup and drop points and to update all status.
     *
     * @param type $shift_id      integer   shipmentid
     * @param type $trip_id       integer   trip id
     * @param type $shift_veh_id  integer   vechicle id
     * @param type $astatus       integer   1 - accepted 0 - not accepted
     * @param type $group         integer   0-ungroup 1-group
     *
     * return CI_VIEW.
     */

    public function shipment_details($shift_id = '', $trip_id = '', $shift_veh_id = '', $astatus = '', $group = '') {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $timezone = $this->session->userdata('timezone');
        $imei = $this->session->userdata('imei');
        $driver_id = $this->session->userdata('id');
        $this->load->helper('home');

        if (isset($_POST['shipment_list_id'])) {
            $shipment_list_id = $this->input->post('shipment_list_id', TRUE);
            if (trim($shipment_list_id) != '') {
                $this->session->set_userdata('shipment_list_id', $shipment_list_id);
            }
            $data['shipment_list_id'] = $shipment_list_id;
        }

        $setshipstopstatus_atpickup = array(
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        );
        $setshipstopstatus_atdrop = array(
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        );
        $getshipmentstops = '';
        if ($shift_id != '' && $trip_id != '' && $shift_veh_id != '' && $timezone != '') {
            $_POST = array("shift_id" => $shift_id, "trip_id" => $trip_id, "shift_veh_id" => $shift_veh_id, "timezone" => $timezone);
            $getshipmentstops = (object) json_decode($this->getshipmentstops());
        }
        if ($getshipmentstops == "") {
            $status = 0;
        } else {
            $status = $getshipmentstops->status;
        }

        /*
         *  redireact no data found.
         */
        if ($status != 1) {
            redirect('xdocappshipment_list', 'refresh');
        }
        /*
         *      set pre required data for view.
         */
        $pickup = array();
        $destination = array();
        $shipmentstops = $getshipmentstops->data;

        $shipments_stops_count = (!empty($shipmentstops)) ? sizeof($shipmentstops) : 0;


        $map_lat_lang_p = ''; // To navigation of google map
        $map_lat_lang_d = ''; // To navigation of google map
        $stop_id = 0;
        $stop_details_id = 0;
        $data['is_destination_reached'] = "0";  // to know weather atleast one destination is reached based on this we need to show closeshipment is status view
        $data['is_danger_goods'] = "0";  // to know weather atleast one cargo is dg or not
        $data['danger_goods_order_id'] = "0";  // to know weather atleast one cargo is dg or not
        /*
         *  to decide wheather all destinations are reached or not.
         */
        $total_no_of_delivery = 0;
        $total_no_of_deliveries_reached_milestone = 0;

        for ($i = 0; $i < $shipments_stops_count; $i++) {
            $stop_point = $shipmentstops[$i];
            $shipment_stop_id = $stop_point->id;
            $ship_type = $stop_point->ship_type;
            /*
             *  set for setshipstopstatus service
             */
            if ($ship_type == "P") {
                $setshipstopstatus_atpickup['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atpickup['stop_type'] = $ship_type;
            } else {
                $setshipstopstatus_atdrop['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atdrop['stop_type'] = $ship_type;
            }

            if ($stop_id == '')
                $stop_id = $shipment_stop_id;
            $status = $stop_point->status;
            /*
             *     Get shipment Stop Details based on shipment stop ids
             */

            $_POST = array(
                "shift_id" => $shift_id, "trip_id" => $trip_id, "shift_veh_id" => $shift_veh_id,
                "timezone" => $timezone, "stop_sts" => $status, "stop_id" => $shipment_stop_id
            );
            $shipmentstopdetails = json_decode($this->shipmentstopdetails());
            if ($shipmentstopdetails->status == 1) {
                $shipmentstopdetails_list = $shipmentstopdetails->data;

                $shipmentstopdetails_data_count = (!empty($shipmentstopdetails_list)) ? sizeof($shipmentstopdetails_list) : 0;
                for ($j = 0; $j < $shipmentstopdetails_data_count; $j++) {
                    $shipmentstopdetails_data = $shipmentstopdetails_list[$j];
                    $ship_type = $shipmentstopdetails_data->ship_type;
                    $stop_details_id = $shipmentstopdetails_data->id;
                    $dg_goods = $shipmentstopdetails_data->dg_goods;
                    if ($dg_goods == "1") {
                        $data['is_danger_goods'] = "1";
                        $data['danger_goods_order_id'] = $shipmentstopdetails_data->tb_order_cargodetails_orderid;
                    }

                    /*
                     *  push stop id for next page usage
                     */
                    $shipmentstopdetails_data->stop_id = $shipment_stop_id;
                    if ($ship_type == "P") {
                        /*
                         *  Shipment Pickup block
                         */
                        $startdate = $shipmentstopdetails_data->startdate; // early picktime
                        $pickup_late_datetime = $shipmentstopdetails_data->pickup_late_datetime; // late pickup time

                        if ($map_lat_lang_p == '') {
                            $map_lat_lang_p = 'saddr=' . $shipmentstopdetails_data->plat . ',' . $shipmentstopdetails_data->plng;

                        }
                        /*
                         *  set for setshipstopstatus service
                         */
                        $setshipstopstatus_atpickup['latitude'] = $shipmentstopdetails_data->plat;
                        $setshipstopstatus_atpickup['longitude'] = $shipmentstopdetails_data->plng;

                        $data['soure_name'] = $shipmentstopdetails_data->pickup;
                        $data['soure_name_with_date'] = htmlspecialchars($stop_point->name . '&nbsp;-&nbsp;<small>' . date('d M', $startdate) . '</smal>');
                        $data['source_date'] = date('d M', $startdate) . ',' . date('h:i A', $startdate) . ' - ' . date('d M', $pickup_late_datetime) . ',' . date('h:i A', $pickup_late_datetime);
                        $data['pickup_pincode'] = substr($shipmentstopdetails_data->pickup_pincode, 0, 2);
                        $pickup[] = $shipmentstopdetails_data;
                    } else {
                        /*
                         *   Shipment Delivery Block
                         */

                        $enddate = $shipmentstopdetails_data->enddate; // early drop time
                        $drop_late_datetime = $shipmentstopdetails_data->drop_late_datetime; // late drop time
                        /*
                         *  set for setshipstopstatus service
                         */
                        $map_lat_lang_d = '&daddr=' . $shipmentstopdetails_data->dlat . ',' . $shipmentstopdetails_data->dlng;

                        $setshipstopstatus_atdrop['latitude'] = $shipmentstopdetails_data->dlat;
                        $setshipstopstatus_atdrop['longitude'] = $shipmentstopdetails_data->dlng;

                        $data['destination_name'] = $shipmentstopdetails_data->drop;
                        $data['destination_name_with_date'] = htmlspecialchars($stop_point->name . '&nbsp;-&nbsp;<small>' . date('d M', $enddate) . '</small>');
                        $data['destination_date'] = date('d M', $enddate) . ',' . date('h:i A', $enddate) . ' - ' . date('d M', $drop_late_datetime) . ',' . date('h:i A', $drop_late_datetime);
                        $data['delivery_pincode'] = substr($shipmentstopdetails_data->delivery_pincode, 0, 2);

                        // count it
                        $total_no_of_delivery = $total_no_of_delivery + 1;
                        $allstatus = (array) $shipmentstopdetails_data->allstatus;
                        if (array_sum($allstatus) > 3) {
                            $total_no_of_deliveries_reached_milestone = 1 + $total_no_of_deliveries_reached_milestone++;
                        }

                        $destination[] = $shipmentstopdetails_data;
                    }
                }
            }
        }
        // if total_no_of_delivery is equal to total no of deliveries reached milestone
        // now set is_destiation_reached flag
        if ($total_no_of_deliveries_reached_milestone == $total_no_of_delivery) {
            $data['is_destination_reached'] = "1";
        }

        $data['shipstopsstatus_atdrop'] = $setshipstopstatus_atdrop;
        $data['shipstopsstatus_atpickup'] = $setshipstopstatus_atpickup;

        $data['status_view_params'] = "$trip_id/$shift_id/$stop_id/$stop_details_id";
        $data['pickup'] = $pickup;
        $data['destination'] = $destination;
        $data['map_view_lat_lng'] = 'http://maps.google.com/maps?' . $map_lat_lang_p . $map_lat_lang_d;
        $data['astatus'] = $astatus;

        $data['is_ungroup_btn_visible'] = '0';

        $pickup_size__ = (!empty($pickup)) ? sizeof($pickup) : 0;
        $destination_size__ = (!empty($destination)) ? sizeof($destination) : 0;
        if (($pickup_size__ + $destination_size__) > 2) {
            $data['is_ungroup_btn_visible'] = '1';
        }

        /*
         * close shimpment service parameters.
         */
        $data['closetrip'] = array("driver_id" => $driver_id, "imei" => $imei, "trip_id" => $trip_id, "shipment_id" => $shift_id, 'timezone' => $timezone);

        if ($group == "1") {
            // group data layout
            $data['group_ungroup_url'] = base_url("drivershipment_details/$shift_id/$trip_id/$shift_veh_id/$astatus/0");
            $data['body_content'] = 'xdocapp/shipment_details';
        } else {
            // ungroup data layout
            $data['group_ungroup_url'] = base_url("drivershipment_details/$shift_id/$trip_id/$shift_veh_id/$astatus/1");
            $data['body_content'] = 'xdocapp/shipment_details_ungroup';
        }

        $this->load->view('xdocapp/index', $data);
    }

    /*
     * Purpose - Status view (has 3 types status_view.php , status_view_single.php , status_view_multiple.php)
     *
     * when user clicks on  status view btn status_view.php content will show.
     * when user clicks on pod/pop
     *               if grouping happend then status_view_multiple.php content will show.
     *               else status_view_single.php content will show
     *
     * @param type $trip_id          integer   trip id
     * @param type $shipment_id      integer   shipmentid
     * @param type $stop_id          integer   stop id
     * @param type $stop_Details_id  integer   Stop Details Id
     *
     * return CI_VIEW.
     */

    public function status_view($trip_id = '', $shipment_id = '', $stop_id = '', $stop_details_id = '') {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $gloabal_post = $_POST;
//        trip_id,shipment_id,stop_id,stop_details_id,timezone
        if ($trip_id != '' && $shipment_id != '' && $stop_id != '' && $stop_details_id != '') {
            $timezone = $this->session->userdata('timezone');
            if (isset($_POST['btn_type']) && $this->input->post('btn_type', TRUE) == '1') {
                $params = array(
                    "trip_id" => $trip_id, "shipment_id" => $shipment_id, "timezone" => $timezone
                );
            } else {
                $params = array(
                    "trip_id" => $trip_id, "shipment_id" => $shipment_id, "timezone" => $timezone
                );
            }
            $_POST = $params;
            $getshipstatuses = json_decode($this->getshipstatuses());
        }
        $_POST = $gloabal_post;
        $data['shipment_status_list'] = array();
        if ($getshipstatuses->status == 1) {
            $data['docstatus'] = $getshipstatuses->docstatus;
            $data['shipment_status_list'] = $getshipstatuses->data;
        }
        $data['pod_status'] = $this->input->post('pod_status', TRUE);
        if (isset($_POST['proof_of_pickup_details'])) {
            $proof_of_pickup_details = json_decode(html_entity_decode($this->input->post('proof_of_pickup_details', TRUE)));
            $data['proof_of_pickup_details'] = $proof_of_pickup_details;
            // // log_message("error", "status view block");
            if ((!empty($proof_of_pickup_details->employee_id)) && is_array((array) $proof_of_pickup_details->employee_id) && count($proof_of_pickup_details->employee_id) > 1) {
                $data['body_content'] = 'xdocapp/status_view_multiple';
            } else {
                $data['body_content'] = 'xdocapp/status_view_single';
            }
        } else {
            $data['body_content'] = 'xdocapp/status_view_single';
        }
        $data['docstatus'] = $getshipstatuses->docstatus;

        $data['trip_id'] = $trip_id;
        $data['shipment_id'] = $shipment_id;
        if (isset($_POST['btn_type'])) {
            // status_view btn
            $btn_type = $this->input->post('btn_type', TRUE);
            $is_destination_reached = $this->input->post('is_destination_reached', TRUE);
            $data['is_destination_reached'] = $is_destination_reached;
            $data['body_content'] = 'xdocapp/status_view';
        } else {
            // pop or pod
            $btn_type = '0';
        }

        $data['deviation_params'] = $params = array(
            "trip_id" => $trip_id, "shipment_id" => $shipment_id, "timezone" => $timezone,
            "stop_details_id" => $stop_details_id, 'stop_id' => $stop_id
        );
        $data['btn_type'] = $btn_type;
        $this->load->view('xdocapp/index', $data);
    }

    /*
     *    Purpose : To Testing autocomplete dropdown gener
     *              but present not in use. (just for test purpose)
     */

    public function get_selected_customer() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $customers = array();
        for ($i = 0; $i < 10; $i++) {
            $customers[] = array("name" => 'durgarao' . time(), "code" => "rja" . time());
        }
        echo json_encode($customers);
    }

    /*
     *  Purpose : when user clicks on following btns(Gate in, Pickup,Gateout,drop ) it will update status.
     *  @param      pickup_data     array of shipment pickup information
     *  @param      drop_data       array of shipment drop information
     *  return json
     */

    public function setshipstopstatus() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $status = $this->input->post('status', TRUE);
        $status_type = $this->input->post('status_type', TRUE);
        if ($status_type == "P") {
            $req_data = (array) json_decode(html_entity_decode($this->input->post('pickup_data', TRUE)));
        } else {
            $req_data = (array) json_decode(html_entity_decode($this->input->post('drop_data', TRUE)));
            // log_message('error', '---req data setshipstopstatus---' . json_encode($req_data));
        }
        // common data..
        $req_data['status'] = $status;
        $manual_date_time = $this->input->post('status_manual_date', TRUE);
        $req_data['status_manual_date'] = '';
        if (strlen($manual_date_time) > 7) {
            $req_data['status_manual_date'] = date('Y-m-d H:i:s', strtotime($manual_date_time));
        }
        $req_data['timezone'] = $this->session->userdata('timezone');
        $_POST = $req_data;
        // log_message('error', '---FINAL SERVICE REQ DATA---' . json_encode($req_data));
        $response = json_decode($this->setShipstopStatus1());
        echo json_encode($response);
    }

    /*
     *  Purpose : when user clicks on following btns(Gate in, Pickup,Gateout,drop ) it will update status.
     *  when grouping is happen then we need to use this function to update status
     *  @param      pickup_data     array of shipment pickup information
     *  @param      drop_data       array of shipment drop information
     *  returns json
     */

    public function setshipstopstatus_multiple() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $global_post = $_POST;
        $status = $this->input->post('status', TRUE);
        $status_type = $this->input->post('status_type', TRUE);
        if ($status_type == "P") {
            $req_data = (array) json_decode(html_entity_decode($this->input->post('pickup_data', TRUE)));
        } else {
            $req_data = (array) json_decode(html_entity_decode($this->input->post('drop_data', TRUE)));
            // log_message("error", "---Hello---" . json_encode($req_data));
        }
        // common data....
        $req_data['status'] = $status;
        $manual_date_time = $this->input->post('status_manual_date', TRUE);
        $req_data['status_manual_date'] = '';
        if (strlen($manual_date_time) > 7) {
            $req_data['status_manual_date'] = date('Y-m-d H:i:s', strtotime($manual_date_time));
        }

        $req_data['timezone'] = $this->session->userdata('timezone');
        $stop_details_id = $req_data['employee_id'];
        if (is_array($stop_details_id) && !is_numeric($req_data['employee_id'])) {
            $stop_details_id = (array) $stop_details_id;
            $response = '';
            $stop_details_id_size__ = (!empty($stop_details_id)) ? count($stop_details_id) : 0;
            for ($i = 0; $i < $stop_details_id_size__; $i++) {
                $req_data['employee_id'] = $stop_details_id[$i];
                $_POST = $req_data;
                $response = json_decode($this->setShipstopStatus1());
                $_POST = $global_post;
            }
            echo json_encode($response);
            return;
        } else {
            $_POST = $req_data;
            $response = json_decode($this->setShipstopStatus1());
            echo json_encode($response);
            return;
        }
    }

    /*
     *  Purpose : To accept trip
     *  @param      on_accept       array of shipment information
     *  returns     json.
     */

    function trip_accept() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $trip_accept_params = html_entity_decode($this->input->post('on_accept', TRUE));
        $timezone = $this->session->userdata('timezone');
        $_POST = array("data" => $trip_accept_params, 'timezone' => $timezone);
        $starttrip = json_decode($this->startTrip());

        echo json_encode($starttrip);
    }

    /*
     *  Purpose : To accept trip
     *  @param      on_reject   array of shipment info
     *  returns     json.
     */

    function trip_reject() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $trip_reject_params = (array) json_decode(html_entity_decode($this->input->post('on_reject', TRUE)));
        $reason = $this->input->post('reason', TRUE);
        $trip_reject_params['reason'] = $reason;
        $timezone = $this->session->userdata('timezone');
        $_POST = array("data" => json_encode($trip_reject_params), 'timezone' => $timezone);
        $starttrip = json_decode($this->setShipReject());
        echo json_encode($starttrip);
    }

    /*
     *  Purpose : To reschedue shipment.
     *  returns     json.
     */

    function trip_reschedule() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $onreschedule = (array) json_decode(html_entity_decode($this->input->post('onreschedule', TRUE)));
        $reschedule_date = $this->input->post('reschedule_date', TRUE);
        $reason = $this->input->post('reason', TRUE);
        $onreschedule['reason'] = $reason;
        $onreschedule['check'] = 1;
        $onreschedule['reschedule_date'] = $reschedule_date;
        $timezone = $this->session->userdata('timezone');
        $_POST = array("data" => json_encode($onreschedule), 'timezone' => $timezone);
        $trip_reschedule = json_decode($this->rescheduleShift());
        echo json_encode($trip_reschedule);
    }

    /*
     *
     * Purpose - Secure view
     *
     * @param type $shift_id      integer   shipmentid
     * @param type $trip_id       integer   trip id
     * @param type $shift_veh_id  integer   vechicle id
     * @param type $astatus       integer   1 - accepted 0 - not accepted
     *
     * return CI_VIEW.
     */

    public function shipment_details_access($shift_id = '', $trip_id = '', $shift_veh_id = '', $astatus = '') {

        $timezone = $this->session->userdata('timezone');
        $imei = $this->session->userdata('imei');
        $driver_id = $this->session->userdata('id');
        $this->load->helper('home');

        if (isset($_POST['shipment_list_id'])) {
            $shipment_list_id = $this->input->post('shipment_list_id', TRUE);
            if (trim($shipment_list_id) != '') {
                $this->session->set_userdata('shipment_list_id', $shipment_list_id);
            }
            $data['shipment_list_id'] = $shipment_list_id;
        }
        /*
         *    create an array for setshipstopstatus service
         */

        $setshipstopstatus_atpickup = array(
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        );
        $setshipstopstatus_atdrop = array(
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        );
        $getshipmentstops = '';
        if ($shift_id != '' && $trip_id != '' && $shift_veh_id != '' && $timezone != '') {
            $_POST = array("shift_id" => $shift_id, "trip_id" => $trip_id, "shift_veh_id" => $shift_veh_id, "timezone" => $timezone);
            $getshipmentstops = (object) json_decode($this->getshipmentstops());
        }
        if ($getshipmentstops == "") {
            $status = 0;
        } else {
            $status = $getshipmentstops->status;
        }

        /*
         *  redireact no data found.
         */
        if ($status != 1) {
            redirect('xdocappshipment_list', 'refresh');
        }
        /*
         *      set pre required data for view.
         */
        $pickup = array();
        $destination = array();
        $shipmentstops = $getshipmentstops->data;

        $shipments_stops_count = (!empty($shipmentstops)) ? sizeof($shipmentstops) : 0;


        $map_lat_lang_p = ''; // To navigation of google map
        $map_lat_lang_d = ''; // To navigation of google map
        $stop_id = 0;
        $stop_details_id = 0;
        $data['is_destination_reached'] = "0";  // to know weather atleast one destination is reached based on this we need to show closeshipment is status view
        $data['is_danger_goods'] = "0";  // to know weather atleast one cargo is dg or not
        $data['danger_goods_order_id'] = "0";  // to know weather atleast one cargo is dg or not
        /*
         *  below two variables are used to  decide wheather all destinations are reached or not.
         */
        $total_no_of_delivery = 0;
        $total_no_of_deliveries_reached_milestone = 0;

        for ($i = 0; $i < $shipments_stops_count; $i++) {
            $stop_point = $shipmentstops[$i];
            $shipment_stop_id = $stop_point->id;
            $ship_type = $stop_point->ship_type;
            /*
             *  set for setshipstopstatus service
             */
            if ($ship_type == "P") {
                $setshipstopstatus_atpickup['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atpickup['stop_type'] = $ship_type;
            } else {
                $setshipstopstatus_atdrop['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atdrop['stop_type'] = $ship_type;
            }

            if ($stop_id == '')
                $stop_id = $shipment_stop_id;
            $status = $stop_point->status;
            /*
             *     Get shipment Stop Details based on shipment stop ids
             */

            $_POST = array(
                "shift_id" => $shift_id, "trip_id" => $trip_id, "shift_veh_id" => $shift_veh_id,
                "timezone" => $timezone, "stop_sts" => $status, "stop_id" => $shipment_stop_id
            );
            $shipmentstopdetails = json_decode($this->shipmentstopdetails());
            if ($shipmentstopdetails->status == 1) {

                $shipmentstopdetails_list = $shipmentstopdetails->data;

                $shipmentstopdetails_data_count = (!empty($shipmentstopdetails_list)) ? sizeof($shipmentstopdetails_list) : 0;
                for ($j = 0; $j < $shipmentstopdetails_data_count; $j++) {
                    $shipmentstopdetails_data = $shipmentstopdetails_list[$j];
                    $ship_type = $shipmentstopdetails_data->ship_type;
                    $stop_details_id = $shipmentstopdetails_data->id;
                    $dg_goods = $shipmentstopdetails_data->dg_goods;
                    if ($dg_goods == "1") {
                        $data['is_danger_goods'] = "1";
                        $data['danger_goods_order_id'] = $shipmentstopdetails_data->tb_order_cargodetails_orderid;
                    }

                    /*
                     *  push stop id for next page usage
                     */
                    $shipmentstopdetails_data->stop_id = $shipment_stop_id;
                    if ($ship_type == "P") {
                        /*
                         *  Shipment Pickup block
                         */
                        $startdate = $shipmentstopdetails_data->startdate; // early picktime
                        $pickup_late_datetime = $shipmentstopdetails_data->pickup_late_datetime; // late pickup time

                        if ($map_lat_lang == '') {
                            $map_lat_lang_p = 'saddr=' . $shipmentstopdetails_data->plat . ',' . $shipmentstopdetails_data->plng;

                        }
                        /*
                         *  set for setshipstopstatus service
                         */
                        $setshipstopstatus_atpickup['latitude'] = $shipmentstopdetails_data->plat;
                        $setshipstopstatus_atpickup['longitude'] = $shipmentstopdetails_data->plng;

                        $data['soure_name'] = $shipmentstopdetails_data->pickup;
                        $data['soure_name_with_date'] = htmlspecialchars($stop_point->name . '&nbsp;-&nbsp;<small>' . date('d M', $startdate) . '</smal>');
                        $data['source_date'] = date('d M', $startdate) . ',' . date('h:i A', $startdate) . ' - ' . date('d M', $pickup_late_datetime) . ',' . date('h:i A', $pickup_late_datetime);
                        $data['pickup_pincode'] = substr($shipmentstopdetails_data->pickup_pincode, 0, 2);
                        $pickup[] = $shipmentstopdetails_data;
                    } else {
                        /*
                         *   Shipment Delivery Block
                         */

                        $enddate = $shipmentstopdetails_data->enddate; // early drop time
                        $drop_late_datetime = $shipmentstopdetails_data->drop_late_datetime; // late drop time


                        $map_lat_lang_d = '&daddr=' . $shipmentstopdetails_data->dlat . ',' . $shipmentstopdetails_data->dlng;

                        /*
                         *  set for setshipstopstatus service
                         */
                        $setshipstopstatus_atdrop['latitude'] = $shipmentstopdetails_data->dlat;
                        $setshipstopstatus_atdrop['longitude'] = $shipmentstopdetails_data->dlng;

                        $data['destination_name'] = $shipmentstopdetails_data->drop;
                        $data['destination_name_with_date'] = htmlspecialchars($stop_point->name . '&nbsp;-&nbsp;<small>' . date('d M', $enddate) . '</small>');
                        $data['destination_date'] = date('d M', $enddate) . ',' . date('h:i A', $enddate) . ' - ' . date('d M', $drop_late_datetime) . ',' . date('h:i A', $drop_late_datetime);
                        $data['delivery_pincode'] = substr($shipmentstopdetails_data->delivery_pincode, 0, 2);

                        $total_no_of_delivery = $total_no_of_delivery + 1;
                        $allstatus = (array) $shipmentstopdetails_data->allstatus;
                        if (array_sum($allstatus) > 3) {
                            $total_no_of_deliveries_reached_milestone = 1 + $total_no_of_deliveries_reached_milestone++;
                        }

                        $destination[] = $shipmentstopdetails_data;
                    }
                }
            }
        }

        // if total_no_of_delivery is equal to total no of deliveries reached milestone
        // now set is_destiation_reached flag
        if ($total_no_of_deliveries_reached_milestone == $total_no_of_delivery) {
            $data['is_destination_reached'] = "1";
        }

        $data['shipstopsstatus_atdrop'] = $setshipstopstatus_atdrop;
        $data['shipstopsstatus_atpickup'] = $setshipstopstatus_atpickup;

        $data['status_view_params'] = "$trip_id/$shift_id/$stop_id/$stop_details_id";
        $data['pickup'] = $pickup;
        $data['destination'] = $destination;
        $data['map_view_lat_lng'] = 'http://maps.google.com/maps?' . $map_lat_lang_p . $map_lat_lang_d;
        $data['astatus'] = $astatus;

        $data['is_ungroup_btn_visible'] = '0';

        $pickup_size__ = (!empty($pickup)) ? sizeof($pickup) : 0;
        $destination_size__ = (!empty($destination)) ? sizeof($destination) : 0;
        if (($pickup_size__ + $destination_size__) > 2) {
            $data['is_ungroup_btn_visible'] = '1';
        }

        /*
         * close shimpment service parameters.
         */
        $data['closetrip'] = array("driver_id" => $driver_id, "imei" => $imei, "trip_id" => $trip_id, "shipment_id" => $shift_id, 'timezone' => $timezone);

        if ($group == "1") {
            // group data layout
            $data['group_ungroup_url'] = base_url("drivershipment_details/$shift_id/$trip_id/$shift_veh_id/$astatus/0");

        } else {
            // ungroup data layout
            $data['group_ungroup_url'] = base_url("drivershipment_details/$shift_id/$trip_id/$shift_veh_id/$astatus/1");

        }

        $this->load->view('xdocapp/header');
        $this->load->view('xdocapp/shipment_details_secure_view', $data);
        $this->load->view("xdocapp/footer");
    }

    /*
     *   Purpose: Token decrypt, Verify token and get complete Url
     *   return json.
     */

    public function get_secure_view() {
        $token = trim($this->input->post('token', TRUE));
        if ($token != "") {
            $complete_url = $this->getpayloadinfo($token);
            if ($complete_url == '') {
                echo json_encode(array('status' => "0", "response" => array()));
                return;
            } else {
                echo json_encode(array('status' => "1", "response" => array("url" => $complete_url)));
                return;
            }
        } else {
            echo json_encode(array('status' => "0", "response" => array()));
            return;
        }
    }

    /*
     *   Purpose : This a supporing method (for get_secure_view method) to decrypt token and to return complete url.
     *   return String.
     */

    public function getpayloadinfo($token) {
        // getpayload
        $complete_url = '';
        $_POST = array('value' => $token, 'key' => 'ency_key');
        $payload = (array) json_decode($this->get_driver_secure_link());
        $status = $payload['status'];
        $response = (array) $payload['response'];
        if ($status == "1" && isset($response['shipment_id']) && $response['shipment_id'] != '') {
            $shipment_id = $response['shipment_id'];
            $query = "SELECT
                        tb_shifts.id AS shift_id
                        ,tb_shifts.shipmentid
                        ,tb_trips.id AS trip_id
                        ,tb_trips.driver_id AS driver_id
                        ,tb_shft_veh.id AS shift_veh_id
                        ,IFNULL(tb_trips.transit_status,'-1') AS astatus
                        FROM tb_shifts
                        JOIN `tb_trips` ON (tb_trips.shift_id = tb_shifts.id)
                        JOIN `tb_shft_veh` ON (tb_shft_veh.shft_id=tb_shifts.id AND tb_shft_veh.status =1)
                        WHERE tb_shifts.shipmentid ='$shipment_id' limit 1";

            $row = $this->db->query($query)->row_array();
            if (isset($row['shift_id']) && isset($row['trip_id']) && isset($row['shift_veh_id']) && isset($row['astatus'])) {
                $shift_id = $row['shift_id'];
                $trip_id = $row['trip_id'];
                $shift_veh_id = $row['shift_veh_id'];
                $astatus = $row['astatus'];
                $driver_id = $row['driver_id'];

                if (!($shift_id != '' && $trip_id != '' && $shift_veh_id != '' && $astatus != '' && $driver_id != '')) {
                    return $complete_url;
                }

                $query = "SELECT password,contact_num as mobile FROM tb_truck_drivers WHERE id='$driver_id' limit 1";
                $row = $this->db->query($query)->row_array();
                $params = array(
                    "mobile" => $row['mobile'],
                    "password" => (($row['password'])),
                );
                $_POST = $params;
                $driver_data = json_decode($this->driverLogin());
                if ($driver_data->status != 1) {
                    redirect('xdocapplogin', 'refresh');
                }
                session_regenerate_id();
                $driver_data_obj = $driver_data->data;
                $imei = $driver_data_obj->imei ?? ($_POST['imei'] ?? '');

                $this->session->set_userdata('is_login', "1");
                $this->session->set_userdata('imei', $imei);

                $this->session->set_userdata('id', $driver_data_obj->id);
                $this->session->set_userdata('name', $driver_data_obj->name);
                $this->session->set_userdata('user_id', $driver_data_obj->user_id);
                $this->session->set_userdata('vendor_id', $driver_data_obj->vendor_id);
                $this->session->set_userdata('mobile_no', $driver_data_obj->mobile_no);
                $this->session->set_userdata('vehicle', $driver_data_obj->vehicle);
                $this->session->set_userdata('vehicle_id', $driver_data_obj->vehicle_id);
                $this->session->set_userdata('trip_id', $driver_data_obj->trip_id);
                $this->session->set_userdata('timezone', $driver_data_obj->timezone);

                $complete_url = base_url("drivershipment_details_access/$shift_id/$trip_id/$shift_veh_id/$astatus");

            }
        }
        return $complete_url;
    }

    //secure link service api for retrieving shipping data from jwt
    /*
     *   Purpose : To get secure link
     *   @param  value string  shipment id
     */
    public function get_driver_secure_link() {
        /* Ku5hn5Nag5l5Tru3know */
        $jwt = $this->input->post('value', true);
        $result = validate_jwt($jwt);
        // $response = array('status' => '0', 'response' => array());
        switch ($result["code"]) {
            case 200:
                $response["status"] = 1;
                $response["response"] = array("shipment_id" => $result["token"]["sub"]);
                return json_encode($response);
                break;
            case 401:
                $response["status"] = 0;
                $response["response"] = $result["error"];
                return json_encode($response);
                break;
            default:
                $response["status"] = 0;
                $response["response"] = $result;
                return json_encode($response);
                break;
        }
    }

    /*
     *  Purpose : pod_pop used to do some CURD on already uploaded documents and signature under activiy Proof Of Pickup Or Proof of Drop
     */

    function pod_pop() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        // proof_of_pickup_details
        $proof_of_pickup_documents = json_decode(html_entity_decode($this->input->post('proof_of_pickup_documents', TRUE)));
        $stop_detail_ids = $proof_of_pickup_documents->stop_detail_id;
        if ((!empty($stop_detail_ids)) && is_array($stop_detail_ids) && count($stop_detail_ids) > 1) {
            $pod_pop_list_arr = array();
            $stop_detail_ids_size__ = (!empty($stop_detail_ids)) ? count($stop_detail_ids) : 0;
            for ($i = 0; $i < $stop_detail_ids_size__; $i++) {
                $stop_detail_id = $stop_detail_ids[$i];
                $proof_of_pickup_documents->stop_detail_id = $stop_detail_id;

                $_POST = (array) $proof_of_pickup_documents;
                $pod_pop_list = json_decode($this->shipmentstoppods());


                if ($pod_pop_list->status == "1") {
                    $pod_pop_list_arr[] = $pod_pop_list->data;
                }
            }
            $data['is_multiple'] = "1";
            $data['pod_pop_list'] = $pod_pop_list_arr;
        } else {

            $_POST = (array) $proof_of_pickup_documents;
            $pod_pop_list = json_decode($this->shipmentstoppods());

            $data['pod_pop_list'] = array();
            if ($pod_pop_list->status == "1") {
                $data['pod_pop_list'] = $pod_pop_list->data;
            }
            $data['is_multiple'] = "0";
        }
        $data['proof_of_pickup_documents'] = $proof_of_pickup_documents;
        $data['body_content'] = 'xdocapp/pod_pop';
        $this->load->view('xdocapp/index', $data);

    }

    /*
     *  Purpose : To get Date Picker
     */

    function getdatepickert() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['deviation_seq'] = $this->input->post('deviation_seq', TRUE);
        $data['status_type'] = $this->input->post('status_type', TRUE);
        $data['stop_status'] = $this->input->post('stop_status', TRUE);
        $this->load->view('xdocapp/datepicker', $data);
    }

    function test() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $this->load->view('datepicker');
    }

    /*
     *  Purpose  : To get secure link
     */

    function get_secure_link() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $ship_id = $this->input->post('ship_id', TRUE);
        $_POST = array("ship_id" => $ship_id);
        $response = json_decode($this->getsecureLink());
        echo json_encode($response);
    }

    function change_site_language() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $language = trim($this->input->post('language', TRUE));
        if (strlen($language) > 0 && $language != '') {
            $this->session->set_userdata('site_lang', $language);
            echo json_encode(array("status" => "1", "response" => "Language changed successfully..."));
            return;
        }
        echo json_encode(array("status" => "0", "response" => "Please do valid selection"));
        return;
    }

    /*
     *   Purpose : Shipment Party details(Its is a call screen controller supporting method.).
     */

    function order_party_details($order_id) {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $_POST = array("order_id" => $order_id);
        $response = json_decode($this->order_partys_details());
        return $response;

    }

    /*
     *    Purpose : To show Involved party details (call screen btn controller)
     */

    function call_screen() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $order_id = json_decode(html_entity_decode($this->input->post('order_id')));

        $party_details = array();
        if ((!empty($order_id)) && count($order_id) > 0) {
            foreach ($order_id as $key => $value) {

                $party_detail_info = $this->order_party_details($value);
                if ($party_detail_info->status == "1") {
                    $response = $party_detail_info->response;
                    if ((!empty($response)) && count($response) > 0) {
                        for ($i = 0; $i < count($response); $i++) {
                            $party_details[] = $response[$i];
                        }
                    }
                }
            }
        }
        if (!empty($party_details) && count($party_details) > 0) {
            $total_party_details = (object) array("status" => 1, "response" => $party_details);
        }
        $data['party_details'] = $total_party_details;
        $this->load->view('xdocapp/call_screen', $data);
    }

    /*
     *  Purpose : To share secure link using mail services.
     *  @param              string      secure_link_id       .url
     *
     *  return json
     */

    function sentmail() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        header('Content-Type: text/plain; charset=utf-8');
        $this->load->helper('email_templates');
        $order_id = $this->input->post('order_id', TRUE);
        $secure_link = $this->input->post('secure_link_id', TRUE);
        $body = secutelinke_template_1($secure_link);
        $email = $this->input->post('email', TRUE);
        $data = array("email" => $email, "username" => '', "subject" => "Secure Link", "body" => $body, 'action' => 'ShareLink Email');
        $_POST = $data;
        echo $this->send_mail();
    }

    /*
     *   Purpose : Sign Pad
     */

    function sign_pad() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $this->load->view('xdocapp/signature_pad');
    }

    /*
     *  Purpose : It can show Scanquanities   and also set/update Scanned quantity. based on set_quantites flag bit
     *
     *  @param      set_quantites       boolean         1 or 0
     */

    function scan_and_load() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        if (isset($_POST['set_quantites']) && $this->input->post('set_quantites', TRUE) == "1") {
            // unset previous scanned quantities from session
            if ($this->session->has_userdata('scanned_cargos')) {
                $this->session->unset_userdata('scanned_cargos');
            }

            /*
             *   setQuantites*
             */
            $post_data = $this->input->post();
            $post_data['cargos_types'] = json_encode($this->input->post('cargo', TRUE));
            unset($post_data['set_quantites']);
            unset($post_data['cargo']);
            $_POST = (array) $post_data;
            $set_quantity_response = json_decode($this->setQuantities());
            echo json_encode($set_quantity_response);
        } else {
            /*
             *      Get Quantites
             */
            $service_parameters = json_decode(html_entity_decode($this->input->post('service_parameters', TRUE)));

            $_POST = (array) $service_parameters;
            $response = json_decode($this->getQuantities());
            if ($response->status == "1") {
                $data['scan_and_load_data'] = $response->data;
                $data['post_req_data'] = $service_parameters;
            }
            $this->load->view('xdocapp/scan_and_load', $data);
        }
    }

    /*
     *  Purpose : When grouping is happend , It can show Scanquanities   and also set/update Scanned quantity. based on set_quantites flag bit
     *
     *  @param      set_quantites       boolean         1 or 0
     */

    function scan_and_load_multiple() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        if (isset($_POST['set_quantites']) && $this->input->post('set_quantites', TRUE) == "1") {
            // update quantity
            // unset previous scanned quantities from session
            if ($this->session->has_userdata('scanned_cargos')) {
                $this->session->unset_userdata('scanned_cargos');
            }

            $post_data = $this->input->post();
            $post_data['cargos_types'] = json_encode($this->input->post('cargo', TRUE));
            unset($post_data['set_quantites']);
            unset($post_data['cargo']);
            $_POST = (array) $post_data;
            $set_quantity_response = json_decode($this->setQuantities());
            echo json_encode($set_quantity_response);
        } else {
            // to get quantity
            $scan_and_load_data = array();
            $service_parameters = json_decode(html_entity_decode($this->input->post('service_parameters', TRUE)));
            // post parameters
            $stop_detail_id_list = $service_parameters->stop_detail_id;
            $stop_id_list = $service_parameters->stop_id;
            $handling_unit_cargo_id_list = $service_parameters->handling_unit_cargo_id;
            if (is_array($stop_detail_id_list)) {
                $data['is_multiple'] = 1;
                $stop_detail_id_list_size__ = (!empty($stop_detail_id_list)) ? sizeof($stop_detail_id_list) : 0;
                for ($i = 0; $i < $stop_detail_id_list_size__; $i++) {
                    $service_parameters->stop_detail_id = $stop_detail_id_list[$i];
                    $service_parameters->stop_id = $stop_id_list[$i];
                    $service_parameters->handling_unit_cargo_id = $handling_unit_cargo_id_list[$i];
                    $service_parameters_req = $service_parameters;

                    $_POST = (array) $service_parameters_req;
                    if ((!empty($handling_unit_cargo_id_list[$i])) && is_numeric($handling_unit_cargo_id_list[$i]) && $handling_unit_cargo_id_list[$i] > 0) {
                        $response = json_decode($this->getQuantitiesMultiple());
                        if ($response->status == "1") {
                            $scan_and_load_data[] = array('response' => $response->data, "post_data" => json_encode($service_parameters_req));
                        }
                    }
                }
                $data['scan_and_load_data'] = $scan_and_load_data;
                $this->load->view('xdocapp/scan_and_load_multiple', $data);
            } else {
                $data['is_multiple'] = 0;

                $_POST = (array) $service_parameters;
                $response = json_decode($this->getQuantities());

                if ($response->status == "1") {
                    $data['scan_and_load_data'] = $response->data;
                    $data['post_req_data'] = $service_parameters;
                }
                $this->load->view('xdocapp/scan_and_load', $data);
            }
        }
    }

    /*
     *  Purpose : To show entry screen for deviation when grouping not happend
     */

    function deviation_ungroup() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['deviation_params'] = json_decode($this->input->post('deviation_params', TRUE));
        $this->load->view('xdocapp/deviation_ungroup', $data);
    }

    /*
     *  Purpose : To show entry screen for deviation when grouping not
     */

    function deviation_group() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $deviation_params = json_decode($this->input->post('deviation_params', TRUE));
        $deviation_params_size = (!empty(sizeof($deviation_params))) ? sizeof($deviation_params) : 0;
        if ($deviation_params_size > 1) {

            $data['deviation_params'] = $deviation_params;
            $this->load->view('xdocapp/deviation_group', $data);
        } else {
            $data['deviation_params'] = $deviation_params[0];
            $this->load->view('xdocapp/deviation_ungroup', $data);
        }
    }

    /*
     *  Purpose : To get Deviation list
     *  @param      trip_id         int
     *  @param      trip_id         int
     *  @param      timezone        timezone
     *  @param      stop_details_id int
     *  @param      stop_id         int
     *
     *  return      CI_VIEW
     */

    function get_deviation_list() {
        if (isset($_POST)) {
            $trip_id = $this->input->post('trip_id', TRUE);
            $shipment_id = $this->input->post('shipment_id', TRUE);
            $timezone = $this->input->post('timezone', TRUE);
            $stop_details_id = $this->input->post('stop_details_id', TRUE);
            $stop_id = $this->input->post('stop_id', TRUE);
            $data['deviation_list'] = array();
            if ($trip_id != '' && $shipment_id != '' && $stop_id != '' && $stop_details_id != '') {
                $timezone = $this->session->userdata('timezone');
                $params = array(
                    "trip_id" => $trip_id, "shipment_id" => $shipment_id, "timezone" => $timezone,
                    "stop_details_id" => $stop_details_id, 'stop_id' => $stop_id
                );
                $_POST = $params;
                $deviation_details = json_decode($this->getDeviationList());
                $data['deviation_list'] = $deviation_details;
            }
            $this->load->view('xdocapp/deviation_list', $data);
        }
    }

    /*
     *    To get dangers Goods information based on Order id
     *    @param danger_goods_order_id
     */

    function danger_goods_description() {
        if (is_numeric($this->input->post('danger_goods_order_id'))) {
            $_POST = array('danger_goods_order_id' => $this->input->post('danger_goods_order_id', TRUE));
            $data['response'] = json_decode($this->get_danger_goods_details());
        } else {
            $data['response'] = array("status" => '0');
        }

        $this->load->view('xdocapp/danger_goods', $data);
    }

    public function driverLogin() {
        $response = array();

        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {

            $mobile = isset($_POST["mobile"]) ? trim($_POST["mobile"]) : '';
            $pwd = isset($_POST["password"]) ? trim($_POST["password"]) : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : '';
            $phone = isset($_POST["mobile_number"]) ? $_POST["mobile_number"] : '';
            if ($mobile != "") {
                if (!empty($phone)) {
                    if (is_array($phone)) {
                        $phone = implode(",", $phone);
                    }
                }
                $password = password_hash($pwd,PASSWORD_DEFAULT);
                $whr = array("d.contact_num" => $mobile, "d.password" => $password, "d.status" => "Active");
                $this->db->select('d.*,u.country_code,u.mobile_no,u.default_currency as currency');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();

                $curdt = date('Y-m-d H:i:s');
                $drcnt = $sql->num_rows();
                $insdata = array("mobile" => $mobile, "password" => $pwd, "imei" => $imei, "simcard_phone" => $phone, "status" => $drcnt);
                $res = $this->common->insertTableData("tb_driver_login_logs", $insdata);
                if ($drcnt > 0) {
                    $data = $sql->row_array();
                    $id = $data["id"];
                    $imei_k = $data["imei"];
                    $qry = $this->db->query("SELECT t.id,t.register_number from tbl_assigned_drivers a, tb_trucks_data t, tb_truck_drivers d where a.driver_id=$id AND t.id=a.vehicle_id AND a.status=1 AND d.status='Active' AND d.id=a.driver_id AND t.status='Active' ORDER BY a.id DESC LIMIT 1");
                    $veh = $veh_id = "";
                    if ($qry->num_rows() > 0) {
                        $veh = $qry->row()->register_number;
                        $veh_id = $qry->row()->id;
                    }
                    $whrarr = array("id" => $id);
                    if ($gcm_id != "") {
                        $updset = array("gcm_id" => $gcm_id);
                        $this->common->updatetbledata("tb_truck_drivers", $updset, $whrarr);
                    }
                    $countrytimezone = "Asia/Singapore";
                    $selwhr = array("country_code" => $data['country_code']);
                    $chkcntry = $this->common->gettblrowdata($selwhr, "cntry_timezone", "tbl_country_master", 0, 0);
                    if (count($chkcntry) > 0) {
                        $countrytimezone = $chkcntry['cntry_timezone'];
                    }
                    $data['imei'] = $imei_k;
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = "";
                    $data['timezone'] = $countrytimezone;
                    $data['border_type'] = 0;
                    if ($veh_id != "") {
                        $whr = array("vehicle_id" => $veh_id, "driver_id" => $id, "status" => "1");
                        $trip = $this->common->gettblrowdata($whr, 'id,shift_id', 'tb_trips', 0, 0);
                        if (count($trip) > 0) {
                            $data['trip_id'] = $trip['id'];
                            $shiptid = $trip['shift_id'];
                            $bwhr = array("id" => $shiptid, "border_type" => 1);
                            $shipid = $this->common->gettblrowdata($bwhr, "id", "tb_shifts", 0, 0);
                            if (count($shipid) > 0) {
                                $data['border_type'] = 1;
                            }
                        }
                    }
                    $response = array("status" => 1, "data" => $data);
                } else {
                    $response = array("status" => 0, "data" => "Not Found");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        return json_encode($response);
    }

    public function getshipments()
    {
        $response = array("status" => 0, "data" => "Insufficient Input Data");

        if (isset($_POST)) {
            /* null-new, 0-accepted , 1-in-transit, 2-completed */
            $driver = isset($_POST["driver_id"]) ? $_POST["driver_id"] : "";
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : "";
            $type = isset($_POST["type"]) ? $_POST["type"] : "";
            $search = isset($_POST["search"]) ? $_POST["search"] : "";

            if ($driver != "" && $imei != "") {
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';

                if ($curtz == "") {
                    $curtz = "Asia/Singapore";
                }

                $whr = array("id" => $driver, "status" => "Active");
                $res = $this->db->select("id,user_id")->get_where("tb_truck_drivers", $whr, 1, 0);

                if ($res->num_rows() > 0) {
                    if (isset($_POST["pman"]) && $_POST["pman"] == '2') {
                    } else {
                        $upd = $this->db->where(array("id" => $driver))->update("tb_truck_drivers", array("imei" => $imei));
                        $chkdri = $this->db->select("id")->get_where("tbl_assigned_drivers", array("driver_id" => $driver), 1, 0);
                        if ($chkdri->num_rows() > 0) {
                            $upd = $this->db->where(array("driver_id" => $driver))->update("tbl_assigned_drivers", array("imei" => $imei));
                        }
                    }

                    /* search by ord or ord ref num */
                    $searchres = array();
                    $resqry = $res->row();
                    $uid = $resqry->user_id;

                    if ($search != "") {
                        $searchwhr = " AND (r.ref_value LIKE '%" . $search . "%' OR o.order_id LIKE '%" . $search . "%') ";
                        $cmpwhr = "";

                        if (($type == "") || ($type == 0) || ($type == 1)) {
                            $cmpwhr = " AND o.trip_sts=0 ";
                        } else {
                            $cmpwhr = " AND o.trip_sts=1 ";
                        }

                        $qry = $this->db->query("select o.shift_id FROM tb_orders o, tb_order_references r WHERE o.id=r.order_id AND o.user_id=$uid $searchwhr AND o.status=2 $cmpwhr AND r.status=1 GROUP BY o.shift_id");

                        if ($qry->num_rows() > 0) {
                            foreach ($qry->result() as $res1) {
                                $searchres[] = $res1->shift_id;
                            }
                        }
                    }

                    $reswhr = "";

                    if (!empty($searchres)) {
                        $reswhr = " AND s.id IN(" . implode(',', $searchres) . ") ";
                    }

                    if ($type === "" || $type === 0 || $type === 1) {
                        $sql = "select
                                    IFNULL(t.id,'') as id,
                                    s.id as shift_id,s.user_id,d.id as driver_id,s.stime,s.etime,s.trip_type,
                                    convertToClientTZ(s.startdate,'" . $curtz . "') as startdate,
                                    convertToClientTZ(s.enddate,'" . $curtz . "') as enddate,
                                    s.splace,s.eplace,s.scity,s.dcity, s.slat,s.slng,s.elat,s.elng,s.shipmentid,
                                    s.border_type,v.id as shift_veh_id, a.vehicle_id, a.imei,
                                    IFNULL(
                                        (SELECT SUM(cargo.weight) as weight FROM tb_order_cargodetails cargo JOIN tb_orders ord ON ord.id=cargo.order_id WHERE cargo.status = 1 AND ord.shift_id=s.id), 0
                                    ) AS shipweight,
                                    IFNULL(t.transit_status,'-1') as astatus,
                                    tss.stop_id,tss.drop_stopid
                                FROM tb_shifts s
                                    JOIN tb_orders o ON o.shift_id=s.id
                                    JOIN tb_shft_veh v ON s.id = v.shft_id AND v.status=1
                                    JOIN tbl_assigned_drivers a ON v.vehicle_id = a.vehicle_id
                                    JOIN tb_truck_drivers d ON d.id = a.driver_id
                                    LEFT JOIN tb_trips t ON t.shift_id=s.id AND t.driver_id=d.id AND t.status=1
                                    LEFT JOIN tb_employee AS tss ON tss.shift_id = s.id
                                WHERE s.user_id='$uid'
                                    AND s.status=1
                                    AND v.status=1
                                    AND a.status=1
                                    AND a.driver_id='$driver' AND d.id='$driver' $reswhr
                                GROUP BY s.id
                                ORDER BY astatus DESC";

                    } else {
                        $sql = "select
                                    s.id as shift_id, t.id, s.user_id, s.stime, s.etime, s.trip_type,
                                    convertToClientTZ(s.startdate,'" . $curtz . "') as startdate,
                                    convertToClientTZ(s.enddate,'" . $curtz . "') as enddate,
                                    s.splace,s.eplace,s.scity,s.dcity,s.slat,s.slng,s.elat,s.elng,s.shipmentid,
                                    s.border_type,v.id as shift_veh_id,t.vehicle_id,t.start_imei as imei,
                                    IFNULL(
                                        (SELECT SUM(cargo.weight) as weight FROM tb_order_cargodetails cargo JOIN tb_orders ord ON ord.id=cargo.order_id WHERE cargo.status = 1 AND ord.shift_id=s.id), 0
                                    ) AS shipweight,
                                    '2' AS astatus
                                from tb_shifts s,tb_shft_veh v,tb_employee e,tb_trips t
                                    JOIN tb_orders o ON o.shift_id=s.id
                                where s.id=v.shft_id AND s.id=e.shift_id AND s.id=t.shift_id AND e.status=1
                                    AND t.driver_id=$driver and v.vehicle_id=t.vehicle_id and s.status=0
                                    AND t.status=0 and v.user_id=$uid $reswhr GROUP BY s.id";
                    }
                    $query = $this->db->query($sql);
                    $res = array();
                    $res['trips'] = array();

                    if ($query->num_rows() > 0) {
                        $i = 0;
                        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', array('status' => 1))->result_array();

                        foreach ($query->result_array() as $d) {
                            $d = $this->extractShiporderStops($d);
                            list($pickup, $drop) = $this->addressesFromShift($d);

                            $d["splace"] = $pickup;
                            $d["eplace"] = $drop;

                            if ($type == "2") {
                                $d['no_of_pickup'] = 0;
                                $d['no_of_drop'] = 0;
                                $d['is_deviated'] = 0;
                                $d['no_of_stops'] = 0;
                            } else {
                                $p_pickdropbystop = $this->getpicksdropsbystop($d['shift_id'], $d['stop_id'], 'P');
                                $d_pickdropbystop = $this->getpicksdropsbystop($d['shift_id'], $d['drop_stopid'], 'D');

                                $d['no_of_pickup'] = count($p_pickdropbystop);
                                $d['no_of_drop'] = count($d_pickdropbystop);

                                $d['is_deviated'] = $this->is_deviated($d['id'], $d['shift_id'], $d['stop_id']);
                                $d['no_of_stops'] = count(array_unique($p_pickdropbystop)) + count(array_unique($d_pickdropbystop));
                            }

                            if ($type === "" || $type === 0 || $type === 1) {
                                if ($d['id'] == "") {
                                    $trip = $this->db->query("SELECT id,transit_status FROM tb_trips WHERE driver_id='$driver' AND shift_id='" . $d["shift_id"] . "' AND status=1 ORDER BY id DESC LIMIT 1");
                                    if ($trip->num_rows() > 0) {
                                        $d['astatus'] = 0;
                                        if ($trip->row()->transit_status == 1) {
                                            $d['astatus'] = 1;
                                        }
                                        $d["id"] = $trip->row()->id;
                                    }
                                }

                                if ($d["id"] == "") {
                                    $d['astatus'] = '';
                                } else {
                                    list($signature, $pod) = $this->checkSignatureAndPod($d);
                                }

                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance'] = $dist['disttext'];
                                $d['duration'] = $dist['duratext'];
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate'] = strtotime($d['enddate']);
                                $d['pod'] = $pod;
                                $d['signature'] = $signature;
                                $res['trips'][] = $d;
                                $i++;
                            } else {
                                list($signature, $pod) = $this->checkSignatureAndPod($d);

                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance'] = $dist['disttext'];
                                $d['duration'] = $dist['duratext'];
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate'] = strtotime($d['enddate']);

                                if ($d['astatus'] == '-1') {
                                    $d['astatus'] = '';
                                }

                                $d['pod'] = $pod;
                                $d['signature'] = $signature;
                                $res['trips'][] = $d;
                                $i++;
                            }
                        }

                        $response = array("status" => 1, "data" => $res);
                    } else {
                        $response = array("status" => 0, "data" => "Not Found");
                    }
                } else {
                    $response = array("status" => 2, "data" => "Imei Changed!");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found!");
            }
        }
        return json_encode($response);
    }

    function getpicksdropsbystop_1($ship = '', $stop = '', $type = '') {
        $ci = & get_instance();
        $res = array();
        if ($ship != "" && $type == "P") {
            $whr = array('shift_id' => $ship, 'stop_id' => $stop, 'status' => 1);
            $sql = $ci->db->query("SELECT e.id,e.ship_type FROM tb_employee e WHERE e.shift_id='$ship' AND e.stop_id='$stop' AND e.status='1'");
            if ($sql->num_rows() > 0) {
                foreach ($sql->result() as $qr) {
                    $res[] = array('id' => $qr->id, 'ship_type' => "P");
                }
            }
        } else if ($ship != "" && $type == "D") {

            $sql1 = $ci->db->query("SELECT e.id,e.ship_type FROM tb_employee e WHERE e.shift_id='$ship' AND e.drop_stopid='$stop' AND e.status='1'");
            if ($sql1->num_rows() > 0) {
                foreach ($sql1->result() as $qr1) {
                    $res[] = array('id' => $qr1->id, 'ship_type' => "D");
                }
            }
        }
        $size_ = (!empty($res)) ? sizeof($res) : 0;
        return $size_;
    }

    function getpicksdropsbystop($ship = '', $stop = '', $type = '') {
        $ci = & get_instance();
        $res = array();
        if ($ship != "" && $type == "P") {
            $sql = $ci->db->query("SELECT group_concat(stop_id) stop_ids FROM tb_employee  WHERE shift_id='$ship' AND status='1' limit 1");
            $row = $sql->row_array();
            $stop_ids = $row['stop_ids'];
            $res = explode(',', $stop_ids);
        } else if ($ship != "" && $type == "D") {
            $sql = $ci->db->query("SELECT group_concat(drop_stopid) drop_stopids FROM tb_employee  WHERE shift_id='$ship' AND status='1' limit 1");
            $row = $sql->row_array();
            $drop_stopids = $row['drop_stopids'];
            $res = explode(',', $drop_stopids);
        }

        return $res;
    }

    public function getDriverData() {
        $response = array();
        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {

            $id = isset($_POST["id"]) ? $_POST["id"] : '';
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : '';
            $gcm_id = isset($_POST["gcm_id"]) ? $_POST["gcm_id"] : '';
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : '';
            if ($user_id != "" || $id != "") {
                $veh = $veh_id = $tripid = "";
                $whr = array("d.id" => $id, "d.status" => "Active");
                $this->db->select('d.*,u.mobile_no');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                if ($sql->num_rows() > 0) {
                    $data = $sql->row_array();
                    if ($gcm_id != "" && $imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei, "gcm_id" => $gcm_id));
                    } else if ($imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei));
                    }
                    $whr1 = array("driver_id" => $id, "status" => "1", "transit_status" => "1");
                    $trip1 = $this->db->select('id,vehicle_id')->order_by('id', 'DESC')->get_where("tb_trips", $whr1, 1, 0);
                    if ($trip1->num_rows() > 0) {
                        $veh_id = $trip1->row()->vehicle_id;
                        $vehqry = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $veh_id, "status" => "Active"), 1, 0);
                        if ($vehqry->num_rows() > 0) {
                            $veh = $vehqry->row()->register_number;
                        }
                        $tripid = $trip1->row()->id;
                    } else {
                        $whr1 = array("driver_id" => $id, "status" => "1", "transit_status" => "0");
                        $trip = $this->db->select('id,vehicle_id')->order_by('id', 'DESC')->get_where("tb_trips", $whr1, 1, 0);
                        if ($trip->num_rows() > 0) {
                            $veh_id = $trip->row()->vehicle_id;
                            $vehqry = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $veh_id, "status" => "Active"), 1, 0);
                            if ($vehqry->num_rows() > 0) {
                                $veh = $vehqry->row()->register_number;
                            }
                            $tripid = $trip->row()->id;
                        }
                    }
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = $tripid;
                    $response = array("status" => 1, "data" => $data);
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        return json_encode($response);
    }

    /*
     *   Purpose : To know a shipment is deviated or not
     *   @Param Trip int
     *   @Param shipment_id int
     *   @Param stop_id   Int
     *   retrun int
     */

    function is_deviated($trip_id, $shipment_id, $stop_id) {
        $is_deviated = 0;
        if (is_numeric($trip_id) && is_numeric($shipment_id) && is_numeric($stop_id)) {
            $query = "SELECT id FROM `tb_deviations_details` WHERE shift_id='$shipment_id' AND trip_id='$trip_id' AND stop_id='$stop_id' limit 1";
            $result_set = $this->db->query($query);
            if ($result_set->num_rows() > 0) {
                $is_deviated = 1;
            }
        }
        return $is_deviated;
    }

    public function getshipmentstops()
    {
        $result = array();
        $i = 0;
        $prevsts = "N";

        if (isset($_POST)) {
            $shft_veh_id = isset($_POST["shift_veh_id"]) ? $_POST["shift_veh_id"] : "";
            $shft_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : "";

            if ($shft_veh_id != "" && $shft_id != "") {
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : "Asia/Singapore";
                $query = GetShipmentStopsService::getStops($curtz ?? "", $shift_id ?? 0, $this->db);

                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $stop_id = $res->id;
                        $emp = $this->db->query("SELECT id,order_id FROM tb_employee WHERE stop_id='$stop_id' AND shift_id = $shft_id AND status=1 LIMIT 1");
                        if ($emp->num_rows() > 0) {
                            if ($prevsts == "C") {
                                $status = $prevsts = "S";
                            } else {
                                $status = "N";
                            }
                            $detailsid = $emp->row()->id;
                            $whr = array("stop_id" => $stop_id, "shipment_id" => $shft_id, "status_id" => 1, "status" => 1, "stop_type" => $res->stoptype, "stop_detail_id" => $detailsid);
                            $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                            if ($gateout_details->num_rows() > 0) {
                                $status = $prevsts = "C";
                            } else {
                                $whr = array("stop_id" => $stop_id, "shipment_id" => $shft_id);
                                $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if ($statuses->num_rows() > 0) {
                                    $status = $prevsts = "S";
                                }
                            }
                            $stopname = "";
                            if (strlen($res->stopcity) > 0) {
                                $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                            }
                            if (strlen($res->stopname) > 0) {
                                $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                            }
                            if ($status == "N" && $i == 0) {
                                $status = "S";
                            }
                            $result[] = array('id' => $stop_id, 'name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'status' => $status, 'order_id' => $emp->row()->order_id);
                            if ($status == "C" && $i == 0) {
                                $status = "S";
                            }
                        } else {
                            $emp = $this->db->query("SELECT id,order_id FROM tb_employee WHERE drop_stopid='$stop_id' AND shift_id = $shft_id AND status=1 LIMIT 1"); /* AND accepted=1 */
                            if ($emp->num_rows() > 0) {
                                if ($prevsts == "C") {
                                    $status = $prevsts = "S";
                                } else {
                                    $status = "N";
                                }
                                $detailsid = $emp->row()->id;
                                $whr = array("stop_id" => $stop_id, "shipment_id" => $shft_id, "status_id" => 1, "status" => 1, "stop_type" => 'D', "stop_detail_id" => $detailsid);
                                $gateout_details = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                if ($gateout_details->num_rows() > 0) {
                                    $status = $prevsts = "C";
                                } else {
                                    $whr = array("stop_id" => $stop_id, "shipment_id" => $shft_id);
                                    $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                                    if ($statuses->num_rows() > 0) {
                                        $status = $prevsts = "S";
                                    }
                                }
                                $stopname = "";
                                if (strlen($res->stopcity) > 0) {
                                    $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                                }
                                if (strlen($res->stopname) > 0) {
                                    $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                                }
                                if ($status == "N" && $i == 0) {
                                    $status = "S";
                                }
                                $result[] = array('id' => $stop_id, 'name' => $stopname, 'plat' => $res->plat, 'plng' => $res->plng, 'ship_type' => $res->stoptype, 'shipment_weight' => $res->weight, 'shipment_volume' => $res->volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->ordernumber, 'status' => $status, 'order_id' => $emp->row()->order_id);
                                if ($status == "C" && $i == 0) {
                                    $status = "S";
                                }
                            }
                        }
                        $i++;
                    }
                    return json_encode(array("status" => 1, "data" => $result));
                } else {
                    return json_encode(array("status" => 0, "data" => "Not Found"));
                }
            } else {
                return json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
            }
        } else {
            return json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }

    public function shipmentstopdetails($type = "0")
    {
        $result = array();

        if (isset($_POST)) {
            $shft_veh_id = isset($_POST["shift_veh_id"]) ? $_POST["shift_veh_id"] : '';
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
            $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
            $stop_sts = isset($_POST["stop_sts"]) ? $_POST["stop_sts"] : "N";
            $curtz = isset( $_POST['timezone'] ) ? $_POST['timezone'] : "Asia/Singapore";

            if ($shft_veh_id > 0) {
                $trip = ($trip == "") ? 0 : $trip;

                $where = ($type == "1") ? " AND accepted = 1 " : "";
                $query = ShipmentStopDetailsService::getStopDetailsDataV3($shift_id, $stop_id, $curtz, $where, $this->db);

                if ($query->num_rows() > 0) {
                    $k = 0;
                    $sts = 0;

                    foreach ($query->result() as $res) {
                        $allstatus['1'] = $allstatus['2'] = $allstatus['3'] = $allstatus['4'] = $allstatus['5'] = 0;
                        $status = 'N';
                        $statusid = '0';
                        $check_in = '';
                        $reason = '';
                        $whr = array('stop_id' => $res->stop_id);
                        $custname = $res->customer_name;
                        $custmobi = $res->custphone;
                        $getsts = $this->getstopstatus($whr, $curtz);

                        if (!empty($getsts)) {
                            $status = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason = $getsts['name'];
                        }

                        $stop_detail_id = $res->id;

                        if ($sts == 2) {
                            $sts = 1;
                        } else {
                            $sts = 0;
                        }

                        $anystatus = 0;
                        $has_pod = 0;
                        $chkpodsign = $this->db->query("SELECT id FROM tb_pod_uploads WHERE shipment_id='$shift_id' AND stop_id='$stop_id' AND stop_detail_id='$stop_detail_id' ORDER BY createdon DESC");

                        if ($chkpodsign->num_rows() > 0) {
                            $anystatus = 1;
                            $allstatus['5'] = 1;
                            $has_pod = 1;
                        }

                        if ($trip > 0) {
                            $chk1 = $this->db->select('id,stop_type')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $res->id, 'status_id' => 3));
                            if ($chk1->num_rows() > 0) {
                                $sts = 1;
                                foreach ($chk1->result() as $cr) {
                                    if ($cr->stop_type == "D") {
                                        $chkdoc = $this->db->query("select id,doc_type from tb_pod_uploads where doc_type in(1,3) and shipment_id = $shift_id AND stop_id='" . $res->stop_id . "' AND stop_detail_id='" . $res->id . "' AND trip_id=$trip");
                                        if ($chkdoc->num_rows() > 0) {
                                            $sts = 2;
                                        }
                                    } else if ($cr->stop_type == "P") {
                                        $chk2 = $this->db->select('id')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $res->id, 'status_id' => 4));
                                        if ($chk2->num_rows() > 0) {
                                            $sts = 2;
                                        }
                                    }
                                }
                            }

                            $chk11 = $this->db->select('id,status_id')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $res->ship_type));

                            if ($chk11->num_rows() > 0) {
                                if ($sts != 2) {
                                    $sts = 1;
                                }
                                foreach ($chk11->result() as $chr) {
                                    if ($chr->status_id == 2) {
                                        $allstatus['2'] = 1;
                                    }
                                    if ($chr->status_id == 1) {
                                        $allstatus['1'] = 1;
                                    }
                                    if ($chr->status_id == 3) {
                                        $allstatus['3'] = 1;
                                    }
                                    if ($chr->status_id == 4) {
                                        $allstatus['4'] = 1;
                                    }
                                }
                            }
                        }

                        $material = ($res->material_name == "") ? $res->name : $res->material_name;
                        $drop = "";

                        if (strlen($res->drop_city) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop_city)) . " - ";
                        }

                        if (strlen($res->drop) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop));
                        }

                        $pickup = "";
                        if (strlen($res->pickup_city) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup_city)) . " - ";
                        }

                        if (strlen($res->pickup) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup));
                        }

                        if ($sts != 0) {
                            $k = 1;
                        }

                        $singarr = array('id' => $res->id, 'name' => $res->name, 'pickup' => $pickup . ',' . $res->pickup_address2 . ',' . $res->pickup_pincode, 'drop' => $drop . ',' . $res->delivery_address2 . ',' . $res->delivery_pincode, 'phone' => $res->phone, 'plat' => $res->plat, 'plng' => $res->plng, 'dlat' => $res->dlat, 'dlng' => $res->dlng, 'capacity' => $res->capacity, 'ship_type' => $res->ship_type, 'shipment_weight' => $res->shipment_weight, 'shipment_volume' => $res->shipment_volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->priority, 'status' => $status, 'status_id' => $statusid, 'check_in' => $check_in, 'reason' => $reason, 'milestone' => $sts, 'exists_status' => $anystatus, 'material' => $material, 'order_id' => $res->order_id, "accepted" => $res->accepted, 'customer' => $custname, 'customerphone' => $custmobi, "allstatus" => $allstatus, "has_pod" => $has_pod, 'service_id' => $res->service_id, 'service_name' => $res->service_name, 'dg_goods' => $res->dg_goods, 'goods_description' => $res->goods_description, 'purchase_order' => $res->purchase_order, 'pickup_late_datetime' => strtotime($res->pickup_late_datetime), 'drop_late_datetime' => strtotime($res->drop_late_datetime), 'tb_orders_id' => $res->tb_orders_id, 'cargo_type' => $res->cargo_type, 'handling_unit' => $res->handling_unit, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'quantity' => $res->quantity, 'stackable' => $res->stackable, 'grounded' => $res->grounded, 'splittable' => $res->splittable, 'pickup_pincode' => $res->pickup_pincode, 'delivery_pincode' => $res->delivery_pincode, 'cargo_id' => $res->cargo_id, 'pickup_datetime' => strtotime($res->pickup_datetime), 'drop_datetime' => strtotime($res->drop_datetime), 'tb_order_cargodetails_orderid' => $res->tb_order_cargodetails_orderid);
                        $result[] = $singarr;
                    }

                    if ($stop_sts == "S" && $k == 1) {
                        if (count($result) > 0) {
                            $ms = array_column($result, 'milestone');
                            array_multisort($ms, SORT_DESC, $result);
                        }
                    } else if ($stop_sts == "S" && $k == 0) {
                        if (count($result) > 0) {
                            $result[0]['milestone'] = 1;
                        }
                    }

                    return json_encode(array("status" => 1, "data" => $result));
                } else {
                    return json_encode(array("status" => 0, "data" => "Not Found"));
                }
            } else {
                return json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
            }
        } else {
            return json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }

    public function getstopstatus($whr, $curtz) {
        $res = array();
        $this->db->select("s.id,s.stop_type,s.status_id,convertToClientTZ(s.createdon,'" . $curtz . "') as createdon,t.status_name");
        $this->db->from('tb_stop_status s');
        $this->db->join('tb_status_master t', 's.status_id=t.id', 'INNER');
        $this->db->where($whr);
        $this->db->order_by('s.createdon', 'DESC');
        $this->db->limit(1);
        $chkrecent = $this->db->get();
        if ($chkrecent->num_rows() > 0) {
            $res['name'] = $chkrecent->row()->status_name;
            $res['id'] = $chkrecent->row()->id;
            $res['createdon'] = $chkrecent->row()->createdon;
            $res['status_id'] = $chkrecent->row()->status_id;
            $res['stop_type'] = $chkrecent->row()->stop_type;
        }
        return $res;
    }

    public function getshipstatuses() {

        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data1 = array();
            $status = 0;

            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
            $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            if ($trip_id != "") {
                $sq["trip_id"] = $trip_id;

                if ($stop_id != null) {
                    $sq["stop_id"] = $stop_id;
                }
                if ($stop_detail_id != null) {
                    $sq["stop_detail_id"] = $stop_detail_id;
                }

                $sign_sign = $this->db->select('id')->get_where('tb_pod_uploads', $sq, 1, 0);
                if ($sign_sign->num_rows() > 0) {

                    $status = 1;
                }
                $ww = "";
                if ($stop_id != null) {
                    $ww = " AND s.stop_id = $stop_id";
                }
                if ($stop_detail_id != null) {
                    $ww .= " AND s.stop_detail_id = $stop_detail_id";
                }
                if ($sq["trip_id"] != "") {
                    $ww .= " AND s.trip_id='" . $sq["trip_id"] . "'";
                } else {
                    if ($shipment_id != "") {
                        $sq["shipment_id"] = $shipment_id;
                        $ww .= " AND s.shipment_id='" . $sq["shipment_id"] . "'";
                    }
                }
                $qry = $this->db->query("SELECT s.latitude,s.longitude,convertToClientTZ(s.createdon,'" . $curtz . "') as createdon,m.status_name FROM tb_stop_status s,tb_status_master m WHERE s.status_id=m.id $ww ");
                $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $placename = getLocationName($res->latitude, $res->longitude);
                        $data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));
                    }
                    $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                }
            }
        }
        return json_encode($response);
    }

    public function setShipstopStatus1() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data = array();
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            $latitude = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $data["trip_id"] = isset($_POST["trip_id"]) ? $_POST["trip_id"] : '';
            $shipment_id = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $stop_id = isset($_POST['stop_id']) ? $_POST["stop_id"] : '0';
            $data["employee_id"] = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_type = isset($_POST["stop_type"]) ? $_POST["stop_type"] : '';
            $driver_id = isset($_POST["driver_id"]) ? $_POST["driver_id"] : '';
            $employee_id = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_detail_type = isset($_POST["stop_detail_type"]) ? $_POST["stop_detail_type"] : '';
            $status_type = isset($_POST["status_type"]) ? $_POST["status_type"] : '';
            $pdfName = $fileName = "";

            $curdt = date('Y-m-d H:i:s');
            $file_upload_flag = false;
            $legsorder_id = "";
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                        'overwrite' => true,
                    );
                    $file_name = $_FILES['file_name']['name'];
                    $file_ext = @strtolower(end(explode('.', $_FILES['file_name']['name'])));
                    $expensions = array("jpeg", "jpg", "png", "gif", "pdf");
                    if (in_array($file_ext, $expensions) === false) {

                    } else {
                        if ($file_ext == "pdf") {
                            $imgtype = "pdf";
                            $this->load->library('upload', $config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                            }
                        } else {
                            $fileName = date('dmyhis') . '' . $file_name;
                            $filePath = NEW_POD_PATH . $fileName;
                            $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if ($file_ext == "png") {
                                $top = imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            } else {
                                $top = imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                    $imgtype = "jpeg";
                                } else {
                                    $imgtype = $file_ext;
                                }
                            }
                            header('Content-Type: image/jpeg');
                            imagejpeg($top, $filePath, $quality);
                            imagedestroy($top);
                        }
                        if ($stop_type == "") {
                            $stop_type = "P";
                        }
                        $ordid = $uid = 0;
                        if ($stop_id != "") {
                            $chkstype = $this->db->select("stoptype")->get_where("tb_shiporder_stops", array("id" => $stop_id, "stoptype" => "D"), 1, 0);
                            if ($chkstype->num_rows() > 0) {
                                $stop_type = $chkstype->row()->stoptype;
                            }
                            $chkord = $this->db->query("SELECT id,order_id,user_id FROM tb_orders WHERE shift_id='" . $shipment_id . "' LIMIT 1");
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $uid = $chkord->row()->user_id;
                            }
                        }
                        $filedata = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_type, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt);
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $file_upload_flag = true;
                    }
                }
            }
            if ($data["employee_id"] != "" && $data["trip_id"] != "") {
                $vehicle = $driver = 0;
                $checkintrans = $this->db->select("id,vehicle_id,driver_id")->get_where("tb_trips", array('id' => $data["trip_id"]), 1, 0);
                if ($checkintrans->num_rows() > 0) {
                    $update = $this->db->set(array('transit_status' => 1))->where(array('id' => $data["trip_id"]))->update("tb_trips");
                    $vehicle = $checkintrans->row()->vehicle_id;
                    $driver = $checkintrans->row()->driver_id;
                }
                $tdata['employee_id'] = $data['employee_id'];
                $tdata['trip_id'] = $data['trip_id'];
                $tdata['stop_id'] = $stop_id;
                $data["status"] = $status_type;
                $data["absent_reason"] = $stsreason = $data["pd_status"] = isset($_POST["status"]) ? $_POST["status"] : '';
                $data["stime"] = $data["created_on"] = $data["check_in"] = $curdt;
                $notests = 0;
                $stscode = "0420";
                if ($stsreason == 2 && $stop_type == "P") {
                    $stscode = "0420";
                    $notests = 2;
                }
                if ($stsreason == 2 && $stop_type == "D") {
                    $stscode = "0192";
                    $notests = 2;
                }
                if ($stsreason == 3 && $stop_type == "P") {
                    $stscode = "0191";
                    $notests = 3;
                }
                if ($stsreason == 3 && $stop_type == "D") {
                    $stscode = "3000";
                    $notests = 3;
                }
                if ($stsreason == 1 && $stop_type == "P") {
                    $stscode = "0500";
                    $notests = 1;
                }
                if ($stsreason == 1 && $stop_type == "D") {
                    $stscode = "2300";
                    $notests = 5;
                }
                if ($stsreason == 4) {
                    $stscode = "1550";
                    $notests = 4;
                }
                $chksts = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'status' => $data["status"]);
                $checksts = $this->db->select("id")->get_where("tb_stop_status", $chksts, 1, 0);
                if ($checksts->num_rows() > 0) {
                    $updstsarr = array('latitude' => $latitude, 'longitude' => $longitude);
                    $stswhr = array('id' => $checksts->row()->id);
                    $upd = $this->db->where($stswhr)->update('tb_stop_status', $updstsarr);
                } else {
                    $data1 = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => $data["status"], 'status_code' => $stscode, "reason" => "From Mobile", 'vehicle_id' => $vehicle, 'driver_id' => $driver, 'createdon' => $curdt);
                    $insrt = $this->db->insert('tb_stop_status', $data1);
                }
                if ($legsorder_id == "") {
                    $shift = $this->db->query("select order_id,user_id from tb_employee where (stop_id=$stop_id OR drop_stopid=$stop_id) LIMIT 1");
                    if ($shift->num_rows() > 0) {
                        $legsorder_id = $shift->row()->order_id;
                        $uid = $shift->row()->user_id;
                    }
                }
                $cnt = $this->db->select('id')->get_where('tb_pod_uploads', array('trip_id' => $data["trip_id"]))->num_rows();
                if ($cnt == 0) {
                    $cntstr = "001";
                } else {
                    $cntstr = "00" . $cnt;
                    if ($cnt > 9) {
                        $cntstr = "0" . $cnt;
                    }
                }
                $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $data["trip_id"],
                    "driver_id" => $driver_id,
                    "stop_id" => $stop_id,
                    "order_id" => $legsorder_id,
                    "inc_id" => $cntstr,
                    "pod_type" => $status_type,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "stop_type" => $stop_type,
                    "vehicle_id" => $vehicle,
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );
                if ($stsreason == 8) {

                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipcollectcancel($postdata);
                } else if ($stsreason == 4) {

                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                } else if ($stsreason == 1) {
                    if ($stop_detail_type == "D") {

                        /* send to roadlog */
                        $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        if ($file_upload_flag == true) {
                            $stop = $this->db->select('txncode')->where(array("id" => $stop_id))->get("tb_shiporder_stops")->row();
                            $postdata["txn_code"] = $stop->txncode;
                            $postdata["file_name"] = $fileName; /* $pdfName; */
                            $postdata["file_type"] = isset($imgtype) ? $imgtype : 'png';

                            /* send to roadlog */
                            if ($status_type == '3') {
                                $sts = $this->statusintigration->roadlogorderpodstatus($postdata);
                                /* send mail to admin cc mail */
                                /* $sendnotify = $this->sendepodstatusnotifyadmin($postdata); */
                                /* send mail to specific party */
                                $sendnotify = $this->sendepodstatusnotify($postdata);
                            }

                        }

                        $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, $stop_id);
                        if ($stop_closed) {

                            /* send to roadlog */
                            $sts = $this->statusintigration->roadlogshipmentdeliverpartial($postdata);
                        }
                    } else {
                        if ($stop_detail_type == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                    }
                } else if ($stsreason == 2) {
                    /* send to roadlog */
                    if ($stop_type == "P") {
                        $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                    }
                    if ($stop_type == "D") {
                        $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                    }
                } else if ($stsreason == 3) {
                    /* send to roadlog */
                    if ($stop_type == "P") {
                        $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                    }
                    if ($stop_type == "D") {
                        /* send to epod notifymail */
                        $sts = $this->sendepodgateoutnotify($postdata);
                    }
                }
                /* Here send driver action status send to otm */
                $sql = $this->db->select("id")->get_where("tb_trip_employee", $tdata, 1, 0);
                if ($sql->num_rows() > 0) {
                    $id = $sql->row()->id;
                    if ($data["status"] == 1 && $stsreason == 1) {
                        $empdt = array('status' => 1, 'absent_reason' => 'Closed', 'pd_status' => 'Closed', 'updated_on' => $curdt);
                        $upd = $this->db->where(array('id' => $id))->update('tb_trip_employee', $empdt);
                    }
                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                } else {
                    if ($data['status'] == '1') {
                        $chkltlng = $this->checkLatLng($data["employee_id"]);
                        if ($chkltlng == "true") {
                            $lat = $latitude;
                            $lng = $longitude;
                            $svpk = $this->savePickup($data["employee_id"], $lat, $lng);
                        }
                    }
                    if (($stsreason == 1 && $data["status"] == 1) || ($data["status"] == 0)) {
                        if ($stsreason == 1) {
                            $data['absent_reason'] = 'Closed';
                        } else if ($stsreason == 0) {
                            $data['absent_reason'] = 'Cancelled';
                        }
                        $data["stop_id"] = $stop_id;
                        $res = $this->db->insert("tb_trip_employee", $data);
                        $id = $this->db->insert_id();
                        $smsdata = array();
                        if ($id > 0) {
                            $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                            if ($data["status"] == 1) {
                                $result = array();

                                $result = $this->sendTripAlert($data["trip_id"], $curtz);
                                if (!empty($result)) {
                                    if (isset($result['sms_data'])) {
                                        $smsdata = $result['sms_data'];
                                    }
                                    if (isset($result['pickup_data'])) {
                                        $pickdata = $result['pickup_data'];
                                    }
                                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => $smsdata, "pickup_data" => $pickdata);
                                }
                            }
                            $response = array("status" => 1, "data" => "Updated Status!");
                        } else {
                            $response = array("status" => 0, "data" => "Failed to Set Shipment Status");
                        }
                    } else {
                        $response = array("status" => 1, "data" => "Updated Status!");
                    }
                }

                $sendnotify = $this->sendshipstatusnotify($postdata, $notests);
            }
        }
        return json_encode($response);
    }

    public function sendshipstatusnotify($postdata, $sts) {
        $ord_id = $postdata['order_id'];
        $chkcust = $this->db->query("SELECT o.customer_id,o.user_id,c.name,c.gcm_id,c.company_code,c.branch_code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.order_id='" . $ord_id . "' AND c.gcm_id != '' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $cust_id = $chkcust->row()->customer_id;
            $user_id = $chkcust->row()->user_id;
            $cust_name = $chkcust->row()->name;
            $company_code = $chkcust->row()->company_code;
            $branch_code = $chkcust->row()->branch_code;
            $chksend = $this->db->query("SELECT id,status_name FROM tb_customer_status WHERE customer_id=$cust_id AND status_id=$sts AND company_code='" . $company_code . "' AND branch_code='" . $branch_code . "' AND status=1 LIMIT 1");
            if ($chksend->num_rows() > 0) {
                $sts_name = $chksend->row()->status_name;
                $ship_id = $postdata['shipment_id'];
                $trip_id = $postdata['trip_id'];
                $stop_id = $postdata['stop_id'];
                $stopdetailsid = 0;
                $notifydata = array();
                $stopdetails = $this->db->query("SELECT id FROM tb_employee WHERE (stop_id='$stop_id' OR drop_stopid='$stop_id') AND shift_id='$ship_id' LIMIT 1");
                if ($stopdetails->num_rows() > 0) {
                    $stopdetailsid = $stopdetails->row()->id;
                }
                if ($sts == 1) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 2) {
                    $stsmsg = $sts_name . " for Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " for Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 3) {
                    $stsmsg = $sts_name . " from Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " from Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 4) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 5) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 6) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                }
                $fire_ret = @$this->sendfirebase->sendSingleOrderPush($notifydata);
            }
        }
    }

    public function sendepodgateoutnotify($postdata) {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $driver_id = $postdata['driver_id'];
        $vehicle_id = $postdata['vehicle_id'];
        $curtz = $postdata['curtz'];

        $chkcust = $this->db->query("SELECT o.*,c.name FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.order_id='" . $order_id . "' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $cust_id = $orddata['customer_id'];
            $user_id = $orddata['user_id'];
            $cust_name = $orddata['name'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            $createdsource = $orddata['created_source'];
            if($createdsource != 5){
                $chkadminusr = $this->db->query("SELECT name,emailid,cc_mails FROM tb_users WHERE id='$user_id' AND emailid!='' LIMIT 1");
                if ($chkadminusr->num_rows() > 0) {
                    $this->load->library('email');
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = array();
                    if ($chkadminusr->row()->cc_mails != "") {
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    $data['order'] = $orddata;
                    $data['userid'] = $user_id;
                    $fileName = "RL".$order_id.".pdf";
                    $epodpath = "./assets/trippods/".$fileName;
                    $data["pod"] = $this->db->query("SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon, ts.imgpath,ts.hash, e.address,e.pickup,e.drop,e.order_id from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE ts.shipment_id =  ? AND ts.status=? GROUP BY ts.id ORDER BY ts.createdon ASC",[$ship_id,1]);
                    $data["orderref"] = $this->db->query("SELECT group_concat(r.reference_id) as reference_id FROM tb_order_references r WHERE r.order_id=$ordid AND r.status=1");
                    $this->load->library('m_pdf');
                    $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $whrin = " AND reference_id in('XSR','SD') ";
                    $chkordtypeqry = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
                    $refvalue = $newsub = "";
                    $iofeof = "EOF";
                    if ($chkordtypeqry->num_rows() > 1) {
                        $refs = array();
                        foreach ($chkordtypeqry->result() as $oref) {
                            $refs[] = $oref->ref_value;
                            if ($oref->reference_id == "XSR") {
                                $refvalue = $oref->ref_value;
                            }
                            if ($oref->reference_id == "SD" && $oref->ref_value == "2") {
                                $iofeof = "IOF";
                            }
                        }
                        $newsub = $refvalue . "#746#" . $iofeof;
                        $sub .= $chkref . ":" . $refvalue . "#746#" . $iofeof . "";
                        $chkparty = "SELECT emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                        $query = $this->db->query($chkparty);
                        if ($query->num_rows() > 0) {
                            foreach ($query->result() as $pmails) {
                                $ccmail[] = $pmails->emailid;
                            }
                        }
                    }
                    if ($newsub == "") {
                        $newsub = $sub;
                    }

                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->to($receivemail, $receivename);
                    if (!empty($ccmail)) {
                        $ccmail = array_unique($ccmail);
                        $cc_mail = implode(", ", $ccmail);
                        $cc_mail = '"' . $cc_mail . '"';
                        $this->email->cc($cc_mail);
                    }

                    $this->email->subject($newsub);
                    $this->email->set_mailtype("html");
                    $data['mailtype'] = "ePOD";

                    $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $this->db);
                    list($dataStops, $dataPickupDatetime, $dataDeliveryDatetime) = ProcessStopstatuses::processStopstatuses($stops);

                    $data['stops'] = $dataStops;
                    $data['pickup_datetime'] = $dataPickupDatetime;
                    $data['delivery_datetime'] = $dataDeliveryDatetime;

                    $html = $this->load->view('settings/bulkepod', $data, true);
                    $chk = $this->m_pdf->pdf->WriteHTML($html);
                    $chk = $this->m_pdf->pdf->Output($epodpath, "F");
                    $body = $this->load->view('mail_forms/deliveredshipment', $data, true);
                    $unique_id = "RL" . $order_id . "." . date("Ymd") . "." . date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    $jplData = array("country" => substr($company_code, 0, -2), "branch" => substr($branch_code, 2), "order_id" => $order_id, "time" => date("hi"), "unique_id" => $unique_id, "date" => date("d.m.Y"), "pages" => $pages);
                    $jplFilePath = $this->saveJPF($jplData);
                    $storeftipjpl = $this->uploadKNFile($jplFilePath);
                    $storeftippdf = $this->uploadKNFile($epodpath);
                    $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                    $this->email->message($body);
                    $this->email->attach($epodpath);
                    if (!$this->email->send()) {
                    }
                }
            }
        }
    }

    public function saveJPF($jplData) {
        $content = $this->load->view("jpl_template", $jplData, TRUE);
        $order_id = $jplData["order_id"];
        $file_path = "./assets/jpl_files/RL$order_id.jpl";
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    public function uploadKNFile($localfile) {
        $remotefile = basename($localfile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                log_error("XDOCApp uploadKNFile: Cannot login into your KNLogin MTF Test server !");
            }else{
                $sftp->chdir(self::KNLOGIN_EPOD_PATH);
                $sftp->put(self::KNLOGIN_EPOD_PATH."/".$remotefile,$localfile,SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_error("XDOCApp uploadKNFile: Some problem occured!, KNLogin MTF Test server, Please Try Again Later.");
        }
    }

    public function checkLatLng($emp) {
        $sql = $this->db->select("plat,plng")->get_where("tb_employee", array("id" => $emp), 1, 0);
        if ($sql->num_rows() > 0) {
            $res = $sql->row();
            if ($res->plat == "" || $res->plng == "") {
                return "true";
            } else {
                return "false";
            }
        } else {
            return "false";
        }
    }

    public function sendTripAlert($trip = null, $curtz = null) {
        $result = array();
        if ($trip != null) {
            $q = $this->db->query("select employee_id from tb_trip_employee where trip_id=$trip");
            $emps = array();
            if ($q->num_rows() > 0) {
                foreach ($q->result() as $qr) {
                    array_push($emps, $qr->employee_id);
                }
            }
            $result = $this->sendFirstAlert($trip, $emps, $curtz);
        }
        return $result;
    }

    public function savePickup($emp, $lat, $lng) {
        $data = array();
        $data["plat"] = $lat;
        $data["plng"] = $lng;
        $loc = getLocationName($lat, $lng);
        if (strlen($loc) > 0) {
            $type = 'P';
            $emptype = $this->db->select('ship_type')->get_where('tb_employee', array('id' => $emp), 1, 0);
            if ($emptype->num_rows() > 0) {
                $type = $emptype->row()->ship_type;
            }
            if ($type == 'P') {
                $data["pickup"] = $data["address"] = $loc;
            } else {
                $data["dlat"] = $lat;
                $data["dlng"] = $lng;
                $data['drop'] = $data["address"] = $loc;
            }
        }
        $res = $this->db->where("id", $emp)->update("tb_employee", $data);
    }

    public function isStopUnitsPartiallyPicked($shipment_id = '', $stop_id = '') {
        if ($stop_id != "") {
            $driver_entered = $this->db->query("SELECT ship_units FROM tb_shiporder_stops WHERE id = $stop_id")->row()->ship_units;
            if (strlen($driver_entered) > 0) {
                $total_units = 0;
                $sdet = $this->db->query("SELECT no_of_pkgs from tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND status='1'");
                if ($sdet->num_rows() > 0) {
                    foreach ($sdet->result() as $row) {
                        $total_units += $row->no_of_pkgs;
                    }
                }
                if ($total_units != $driver_entered) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {
            if ($shipment_id != "") {
                $stops = $this->db->query("SELECT id FROM tb_shiporder_stops WHERE shipment_id = '$shipment_id' ");
                $total_units = $driver_entered_total = 0;
                foreach ($stops->result() as $stop) {
                    $stop_id = $stop->id;
                    if ($stop_id != "") {
                        $driver_entered = $this->db->query("SELECT ship_units FROM tb_shiporder_stops WHERE id = $stop_id")->row()->ship_units;
                        if (strlen($driver_entered) > 0) {
                            $driver_entered_total += $driver_entered;
                            $total_units = 0;
                            $sdet = $this->db->query("SELECT no_of_pkgs from tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND status='1'");
                            if ($sdet->num_rows() > 0) {
                                foreach ($sdet->result() as $row) {
                                    $total_units += $row->no_of_pkgs;
                                }
                            }
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                if ($total_units != $driver_entered_total) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    public function startTrip() {
        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");

        if (isset($_POST)) {
            if (isset($_POST['data'])) {
                $post = json_decode($_POST['data']);

                $data["shift_id"] = isset($post->shift_id) ? $post->shift_id : '';
                $data["vehicle_id"] = isset($post->vehicle_id) ? $post->vehicle_id : '';
                $data["trip_type"] = isset($post->trip_type) ? $post->trip_type : 0;
                $data["driver_id"] = isset($post->driver_id) ? $post->driver_id : '';
                $data["splace"] = isset($post->splace) ? $post->splace : '';
                $data["eplace"] = isset($post->eplace) ? $post->eplace : '';
                $data["start_reading"] = isset($post->odemeter) ? $post->odemeter : '0';
                $latitude = isset($post->latitude) ? $post->latitude : '';
                $longitude = isset($post->longitude) ? $post->longitude : '';
                $imei = isset($post->imei) ? $post->imei : '';
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if ($curtz == "") {
                    $curtz = "Asia/Singapore";
                }

                $curdt = date('Y-m-d H:i:s');
                $data["stime"] = $data["created_on"] = $curdt;
                $arr = array("id" => $data["driver_id"], "imei" => $imei, "status" => 'Active');

                $chkqry = $this->db->select("id")->get_where("tb_truck_drivers", $arr)->num_rows();
                if ($chkqry > 0 && $data["shift_id"] != "") {
                    /* commented code for stop duplicate shifts */
                    /* here need to send SHIPMENT_CONFIRM status to otm */

                    $chk = $this->db->select("id")->get_where("tb_trips", array("shift_id" => $data["shift_id"]), 1, 0);
                    if ($chk->num_rows() == 0) {
                        $data["start_imei"] = $imei;
                        $ins = $this->db->insert("tb_trips", $data);
                        $id = $this->db->insert_id();
                        /* update orders table */
                        $ordwhr = array("shift_id" => $data["shift_id"]);
                        $ordset = array("trip_id" => $id);
                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                        $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $data["driver_id"], "trip_id" => $id, "imei" => $imei, "createdon" => $data["created_on"]));
                        $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(array("shift_id" => $data["shift_id"]))->get("tb_employee");
                        if ($shift->num_rows() > 0) {
                            $uid = $shift->row()->user_id;
                            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                            $hrs = 0;
                            if ($gethrs) {
                                $hrs = $gethrs->row()->cntry_hrs;
                            }
                            $postdata = array(
                                "shipment_id" => $data["shift_id"],
                                "trip_id" => $id,
                                "driver_id" => $data["driver_id"],
                                "order_id" => $shift->row()->order_id,
                                "vehicle_id" => $data["vehicle_id"],
                                "user_id" => $uid,
                                "stop_id" => '',
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );

                            /* send to roadlog */
                            $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                            /* status update */
                            $chqry = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "trip_id" => $id, "status_id" => 10), 1, 0);
                            if ($chqry->num_rows() == 0) {
                                $insarry = array("shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => '', "trip_id" => $id, "status_id" => 10, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "status_code" => "0212", "reason" => "From Mobile", "vehicle_id" => $data["vehicle_id"], "driver_id" => $data["driver_id"], "createdon" => $curdt);
                                $ins = $this->db->insert("tb_stop_status", $insarry);
                                /* send email confim to admin */
                                if ($uid == "12") {

                                    $sndmail = $this->loadconfirmmail($postdata);
                                }
                            }
                        }
                        if ($id > 0) {
                            $empdata = array();
                            $empdata["trip_id"] = $id;
                            $response = array("status" => 1, "data" => array($empdata));
                        } else {
                            $response = array("status" => 0, "data" => "Failed to Start");
                        }
                    } else {
                        $empdata = array();
                        $empdata["trip_id"] = $chk->row()->id;
                        $response = array("status" => 1, "data" => array($empdata));
                    }
                } else {
                    $response = array("status" => 3, "data" => "Please re-login to continue");
                }
            }
        }
        return json_encode($response);
    }

    public function loadconfirmmail($post) {
        $data['page_title'] = "Load Confirmed by Driver";
        $data['order_id'] = $post['order_id'];
        $driver_id = $post['driver_id'];
        $vehicle_id = $post['vehicle_id'];
        $data['user_id'] = $post['user_id'];
        $data['driver'] = $data['drivermobile'] = $data['register_number'] = "";
        $chk = $this->db->select("name,contact_num,user_id")->get_where("tb_truck_drivers", array("id" => $driver_id), 1, 0);
        if ($chk->num_rows() > 0) {
            $data['driver'] = $chk->row()->name;
            $data['user_id'] = $chk->row()->user_id;
            $data['drivermobile'] = $chk->row()->contact_num;
        }
        $chk1 = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $vehicle_id), 1, 0);
        if ($chk1->num_rows() > 0) {
            $data['register_number'] = $chk1->row()->register_number;
        }
        $this->load->library('email');
        $chkven = $this->db->select("name,emailid")->get_where("tb_users", array("id" => $data['user_id']), 1, 0);
        if ($chkven->num_rows() > 0) {
            $receivename = $chkven->row()->name;
            $receivemail = $chkven->row()->emailid;
            $newsub = "svkonekt: Load Confirmed by Driver for Order#" . $data['order_id'];
            $data['receivename'] = $receivename;
            if ($receivemail != "") {
                $body = $this->load->view('mail_forms/confirmbydriver', $data, true);
                $this->email->from('svkonekt@kuehne-nagel.com', 'Svkonekt');
                $this->email->to($receivemail, $receivename);
                $this->email->cc('external.ram.k@kuehne-nagel.com', "RCREDDY");

                $this->email->subject($newsub);
                $this->email->set_mailtype("html");
                $this->email->message($body);
            }
        }
    }

    public function setShipReject() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $data = array();

            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }

            $curdt = date('Y-m-d H:i:s');
            $trip_id = isset($post->trip_id) ? $post->trip_id : 0;
            $latitude = isset($post->latitude) ? $post->latitude : '';
            $longitude = isset($post->longitude) ? $post->longitude : '';
            $reason = isset($post->reason) ? $post->reason : '';
            $type = isset($post->type) ? $post->type : '1';
            $vehicle_id = isset($post->vehicle_id) ? $post->vehicle_id : '';
            $driver_id = isset($post->driver_id) ? $post->driver_id : '';
            $shipment_id = isset($post->shipment_id) ? $post->shipment_id : '';
            $status = 6;
            $statuscode = "0213";
            if ($shipment_id != "" && $driver_id > 0) {
                if ($type == '1') {
                    /* type 1 will never come, because this operation is heppen before trip starts only */
                    $chktrip = $this->db->select('id')->get_where('tb_trips', array('id' => $trip_id, 'status !=' => 0));
                    if ($chktrip->num_rows() > 0) {
                        $whr = array('id' => $trip_id);
                        $set = array('status' => 2, 'updated_on' => $curdt);
                        $upd = $this->db->set($set)->where($whr)->update('tb_trips');
                    }
                    $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
                }
                if ($type == '0') {
                    if ($trip_id == "") {
                        $trip_id = 0;
                    }
                    $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
                }
                $upd = $this->db->where(array("shft_id" => $shipment_id))->update("tb_shft_veh", array("status" => "0"));
                $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->get_where("tb_employee", array("shift_id" => $shipment_id, 'ship_type' => 'P'), 1, 0);
                if ($shift->num_rows() > 0) {
                    $ordid = $shift->row()->order_id;
                    $uid = $shift->row()->user_id;
                    $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                    $hrs = $gethrs->row()->cntry_hrs;
                    $postdata = array(
                        "shipment_id" => $shipment_id,
                        "trip_id" => $trip_id,
                        "driver_id" => $driver_id,
                        "stop_id" => "",
                        "order_id" => $ordid,
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "curtz" => $curtz,
                        "hrs" => $hrs
                    );

                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmentreject($postdata);
                    $qry = $this->db->insert('tb_stop_status', $addstatus);
                }
                $response = array("status" => 1, "data" => "Updated");
            }
        }
        return json_encode($response);
    }

    public function rescheduleShift() {
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $shift_id = isset($post->shift_id) ? $post->shift_id : "";
            $vehicle_id = isset($post->vehicle_id) ? $post->vehicle_id : "";
            $trip_type = isset($post->trip_type) ? $post->trip_type : "";
            $driver_id = isset($post->driver_id) ? $post->driver_id : "";
            $imei = isset($post->imei) ? $post->imei : "";
            $user_id = isset($post->user_id) ? $post->user_id : "";
            $splace = isset($post->splace) ? $post->splace : "";
            $eplace = isset($post->eplace) ? $post->eplace : "";
            $reschedule_date = isset($post->reschedule_date) ? $post->reschedule_date : "";
            $reason = isset($post->reason) ? $post->reason : "";
            $check = isset($post->check) ? $post->check : "";
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            if (strlen($reschedule_date) > 0 && strlen($shift_id) > 0 && strlen($vehicle_id) > 0 && strlen($user_id) > 0) {
                $vendor = $this->db->query("SELECT v.email FROM tb_trucks_data vv LEFT JOIN tb_vendors v ON v.id=vv.vendor_id WHERE vv.status='1' AND vv.id=$vehicle_id AND v.email != ''");
                $user = $this->db->query("SELECT name,emailid FROM tb_users WHERE id=$user_id ")->row();
                $driver = $this->db->query("SELECT name,contact_num FROM tb_truck_drivers WHERE id=$driver_id")->row();
                $shift = $this->db->select("convertToClientTZ(startdate,'" . $curtz . "') as startdate,shipmentid")->where(array("id" => $shift_id))->get("tb_shifts")->row();
                $this->load->library('email');
                $this->email->from("svkonekt@kuehne-nagel.com", "svkonekt");
                if ($vendor->num_rows() > 0) {
                    $this->email->to($vendor->email, $vendor->name);
                }
                if (strlen($user->emailid) > 0) {
                    $this->email->cc($user->emailid, $user->name);
                }
                $this->email->subject('Shipment reschedule requested');
                $this->email->set_mailtype('html');
                $this->email->message("
                    Hi,<br><br>
                    Your shipment is reschedule request by driver<br><br>
                    <table style=\"border: 1px solid #f4f4f4;width: 100%;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Shipment Id</th>
                            <th>Start Place</th>
                            <th>End Place</th>
                            <th>All materials are swapped in good condition</th>
                            <th>Actual Date</th>
                            <th>Re-scheduling Date</th>
                            <th>Re-scheduling reason</th>
                        </tr>
                        <tr>
                            <td>" . $shift->shipmentid . "</td>
                            <td>" . $splace . "</td>
                            <td>" . $eplace . "</td>
                            <td>" . $check . "</td>
                            <td>" . $shift->startdate . "</td>
                            <td>" . $reschedule_date . "</td>
                            <td>" . $reason . "</td>
                        </tr>
                    </tbody></table><br>
                    Driver Details:<br>
                    <table style=\"border: 1px solid #f4f4f4;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Driver</th>
                            <th>Mobile</th>
                        </tr>
                        <tr>
                            <td>" . $driver->name . "</td>
                            <td>" . $driver->contact_num . "</td>
                        </tr>
                    </tbody></table><br>
                    <a href='" . base_url() . "' target='_blank' title='Click here to Accept/Reject this request'>Click here</a> to Accept/Reject this request<br><br>
                    Thanks,<br>
                    Support Team,<br>
                    Svkonekt.
                ");
                $sendmail = $this->email->send();

                return json_encode(array("status" => "1", "message" => "Status updated sucessfully!"));
            } else {
                return json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
            }
        } else {
            return json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
        }
    }

    public function shipmentstoppods() {
        $response = array("status" => 0, "data" => "Not Found");
        $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
        $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
        $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : '';
        $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
        if ($shift_id > 0 && $stop_id > 0) {
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            $whr = array("shipment_id" => $shift_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "status" => 1);
            $qry = $this->db->select("id,doc_type,stop_type,imgpath,hash,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", $whr);
            if ($qry->num_rows() > 0) {
                $resdata = array();
                foreach ($qry->result() as $res) {
                    $docurl = base_url() . 'downloadEpod/safelink/' . $res->hash. '.epod';
                    $doctype = "Others";
                    if ($res->doc_type == "3" && $res->stop_type == "P") {
                        $doctype = "POP";
                    } else if ($res->doc_type == "3" && $res->stop_type == "D") {
                        $doctype = "POD";
                    } else if ($res->doc_type == "1") {
                        $doctype = "Signature";
                    }
                    $resdata[] = array("id" => $res->id, "doc_type" => $doctype, "url" => $docurl, "latitude" => $res->latitude, "longitude" => $res->longitude, "createdon" => strtotime($res->createdon));
                }
                $response = array("status" => 1, "data" => $resdata);
            }
        }
        return json_encode($response);
    }

    /*
     *  use as service for mobile web application to get secure link.
     *  Method : POST
     *  @param ship_id
     *  return json
     */

    public function getsecureLink() {
        $ship_id = $this->input->post("ship_id", true);
        $expDate = strtotime('+10 days');
        $jwt_claim = ["sub" => $ship_id, "exp" => $expDate];
        $this->load->helper("jwt");

        $get_jwt = generate_jwt($jwt_claim);
        $link_id = base_url() . "xdocapp/" . $get_jwt;
        if ($link_id != "") {
            return json_encode(array("status" => "1", "secure_link" => $link_id));
        } else {
            return json_encode(array("status" => "0", "secure_link" => $link_id));
        }
    }

    /*
     *    Purpose : To Get order Parties details Based on order id
     *
     *    @param order_id integer  this is order id
     *    return  json
     */

    public function order_partys_details() {
        $order_id = $this->input->post('order_id', TRUE);
        $response = array("status" => "0", "response" => array());
        if (is_numeric($order_id) && $order_id > 0) {
            $query = "SELECT
                        party_id,
                        party_type,
                        (SELECT tpt.name FROM tbl_party_types tpt WHERE tpt.id=party_type and status='1' LIMIT 1) AS party_type_name,
                        (SELECT CONCAT(tpm.name,'::',tpm.mobile,'::',tpm.email) FROM tbl_party_master tpm WHERE tpm.id=party_id and status='1' LIMIT 1) AS party_details,
                        (SELECT CONCAT(pickup_city,SPACE(20),'|',SPACE(20),delivery_city) AS source_destionation FROM `tb_orders` WHERE id='$order_id' limit 1) as source_destionation
                        FROM tb_order_parties WHERE order_id='$order_id' LIMIT 2";
            $response_data = $this->db->query($query)->result_array();
            $response_data_size = (!(empty($response_data))) ? sizeof($response_data) : 0;
            if ($response_data_size > 0) {
                $response = array("status" => "1", "response" => $response_data);
            }
        }
        return json_encode($response);
    }

    public function setQuantities() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";
        $cargos_types1 = isset($_POST['cargos_types']) ? json_decode($_POST['cargos_types']) : array();

        if (isset($_POST)) {
            $quantities = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query("SElECT o.id FROM tb_orders o,tb_shiporder_stops s WHERE o.shift_id=s.shipment_id AND s.id='$stop_id' AND o.shift_id='$shift_id' AND s.shipment_id='$shift_id' GROUP BY o.id");

                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query("SElECT e.id,sum(o.quantity) as quantity FROM tbl_shipunit_types e,tb_order_cargodetails o WHERE e.id=o.handling_unit AND o.order_id='$res->id' GROUP BY e.id");

                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $quantities[$res1->id] = $res1->quantity;
                            }
                        }
                    }
                }
            }
            if (!is_array($cargos_types1)) {
                $cargos_types = array();

            } else {
                $cargos_types = $cargos_types1;
            }
            $whr = array("driver_id" => $driver_id, "user_id" => $user_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
            $total_accepted_quantity = 0;
            if (!empty($cargos_types)) {
                foreach ($cargos_types as $cargo) {

                    $data = [];
                    $data = $whr;
                    $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);

                    if ($updates->num_rows() > 0) {
                        $data["cargo_type_id"] = $cargo->cargo_type_id;
                        $data["scanned_quantity"] = $cargo->scanned_quantity;
                        $data["quantity"] = @$quantities[$cargo->cargo_type_id];
                        $upd = $this->db->where($whr)->update("tb_cargo_driver_updates", $data);

                    } else {
                        $data["cargo_type_id"] = $cargo->cargo_type_id;
                        $data["scanned_quantity"] = $cargo->scanned_quantity;
                        $data["quantity"] = $quantities[$cargo->cargo_type_id];
                        $ins = $this->db->insert("tb_cargo_driver_updates", $data);
                    }
                }
            } else {

            }
            $quantity = $this->db->query("SELECT sum(scanned_quantity) as quantity FROM tb_cargo_driver_updates WHERE shift_id = '$shift_id' AND stop_id = '$stop_id' AND status = '1'");
            if ($quantity->num_rows() > 0) {
                $upd = $this->db->where(array("shipment_id" => $shift_id, "id" => $stop_id))->update("tb_shiporder_stops", array("ship_units" => $quantity->row()->quantity));
            }
            $response = array("status" => 1);
        }
        return json_encode($response);
    }

    public function getQuantities() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";

        if (isset($_POST)) {
            $data = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query("SElECT o.id FROM tb_orders o,tb_shiporder_stops s WHERE o.shift_id=s.shipment_id AND s.id='$stop_id' AND o.shift_id='$shift_id' AND s.shipment_id='$shift_id' GROUP BY o.id");

                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query("SElECT e.id,e.unit_name,sum(o.quantity) as quantity FROM tbl_shipunit_types e,tb_order_cargodetails o WHERE e.id=o.handling_unit AND o.order_id='$res->id' AND o.stop_detail_id ='$stop_detail_id' GROUP BY e.id");

                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $whr = array("stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
                                $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                                if ($updates->num_rows() > 0) {

                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => $updates->row()->scanned_quantity);
                                } else {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => 0);
                                }
                            }
                        }
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        return json_encode($response);
    }

    public function getQuantitiesMultiple() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";

        if (isset($_POST)) {
            $data = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query("SElECT o.id FROM tb_orders o,tb_shiporder_stops s WHERE o.shift_id=s.shipment_id AND s.id='$stop_id' AND o.shift_id='$shift_id' AND s.shipment_id='$shift_id' GROUP BY o.id");

                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query("SElECT e.id,e.unit_name,sum(o.quantity) as quantity,o.stop_detail_id FROM tbl_shipunit_types e,tb_order_cargodetails o WHERE e.id=o.handling_unit AND o.order_id='$res->id' and o.stop_detail_id ='$stop_detail_id' GROUP BY e.id");
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $whr = array("stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
                                $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                                if ($updates->num_rows() > 0) {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => $updates->row()->scanned_quantity);
                                } else {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => 0);
                                }
                            }
                        }
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        return json_encode($response);
    }

    function getDeviationList() {
        $response = array("status" => 0, "data" => array());
        if (isset($_POST)) {
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : null;
            $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : null;
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
            $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
            $where = "";
            if ($trip_id != null) {
                $where .= " AND trip_id='$trip_id'";
            }

            if ($shipment_id != null) {
                $where .= " AND shift_id ='$shipment_id'";
            }


            $query = "SELECT status_type,reason,comment,image_path FROM  `tb_deviations_details` WHERE status='1' $where";

            $qry = $this->db->query($query);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result_array() as $res) {
                    $status_type = $res['status_type'];
                    $reason = $res['reason'];
                    $comment = $res['comment'];
                    $res['image_path'] = base_url() . "assets/deviationuploads/" . $res['image_path'];
                    $data1[] = $res;
                }
                $response = array("status" => 1, "data" => $data1);
            }
            return json_encode($response);

        }
        return json_encode($response);
    }

    function get_danger_goods_details() {
        $danger_goods_order_id = $this->input->post('danger_goods_order_id', TRUE);

        $response = array("status" => "0", "response" => array());
        if (is_numeric($danger_goods_order_id) && $danger_goods_order_id > 0) {
            $query = "SELECT * FROM `tb_order_dg_goods` where order_id = '$danger_goods_order_id' LIMIT 1";
            $response_data = $this->db->query($query)->result_array();

            $response_data_size = (!(empty($response_data))) ? sizeof($response_data) : 0;
            if ($response_data_size > 0) {
                $response = array("status" => "1", "response" => $response_data);
            }
        }
        return json_encode($response);
    }

    public function sendFirstAlert($trip = null, $emps = array(), $curtz = null) {
        $result = array();
        $tt = $this->db->query("select t.driver_id,t.vehicle_id,sv.id,sv.register_number from tb_trips t,tb_shft_veh sv where t.id=$trip and sv.vehicle_id=t.vehicle_id and sv.shft_id=t.shift_id and sv.status=1 order by sv.id desc limit 1");
        if ($tt->num_rows() > 0) {
            $t = $tt->row();
            $driver = $t->driver_id;
            $vehicle_id = $t->vehicle_id;
            $shft_veh_id = $t->id;
            $reg = $t->register_number;
            if (count($emps) == 0) {
                $arr = array("shft_veh_id" => $shft_veh_id, "status" => 1);
                $sql2 = $this->db->select("priority,user_id")->group_by("priority")->order_by("priority", "asc")->get_where("tb_shft_veh_emp", $arr, 1, 0);
            } else {
                $sql2 = $this->db->select("priority,user_id")->where("shft_veh_id", $shft_veh_id)->where("status", 1)->where_not_in("emp_id", $emps)->group_by("priority")->order_by("priority", "asc")->limit(1)->get("tb_shft_veh_emp");
            }
            if ($sql2->num_rows() > 0) {
                $chksent = $this->db->select('id')->get_where('tb_tripfirst_alerts', array('trip_id' => $trip))->num_rows();
                $user_id = $sql2->row()->user_id;
                if ($chksent == 0) {
                    $this->db->select('d.contact_num');
                    $this->db->from('tb_truck_drivers d');
                    $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
                    $this->db->where('t.id', $trip);
                    $this->db->limit(1);
                    $drivermobile = $this->db->get();
                    $drivernum = "";
                    if ($drivermobile->num_rows() > 0) {
                        $drivernum = $drivermobile->row()->contact_num;
                    }

                    $link = $this->getLink($driver, $trip);
                    $msql1 = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1";
                    $mquery = $this->db->query($msql1);
                    $ecnt = $mquery->num_rows();
                    if ($ecnt > 0) {
                        $sntdata = array('trip_id' => $trip, 'module' => 'Truck Auto Arrival Alert Once', 'message' => $drivernum, 'sent_count' => $ecnt);
                        $sendres = $this->db->insert('tb_tripfirst_alerts', $sntdata);
                        foreach ($mquery->result() as $rw) {
                            $result['sms_data'][] = $this->sendBulkAlert($trip, $rw->emp_id, $rw->phone, $rw->name, $drivernum, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
                $sql1 = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1 and priority=" . $sql2->row()->priority;
                $query = $this->db->query($sql1);
                if ($query->num_rows() > 0) {
                    $link = $this->getLink($driver, $trip);
                    foreach ($query->result() as $emps) {
                        $res = $this->db->select('id')->get_where("tb_trip_alerts", array("trip_id" => $trip, "emp_id" => $emps->emp_id))->num_rows();
                        if ($res == 0) {
                            $distance = $this->getDist($vehicle_id, $emps->plat, $emps->plng);
                            $result['pickup_data'][] = $this->sendAlert($trip, $emps->emp_id, $emps->phone, $emps->name, $distance, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
            }
        }
        return $result;
    }

    /*
     *    Purpose : To sent mail
     *
     *    @param email string receiver mail
     *    @param subject string email_subject
     *    $param body text/html email_body
     *    return  json
     */

    function send_mail() {

        $email = $this->input->post('email', TRUE);
        $username = $this->input->post('email', TRUE);
        $subject = $this->input->post('subject', TRUE);
        $body = $this->input->post('body', TRUE);
        $data['emailid'] = $email;
        $data['username'] = $username;
        $data['subject'] = $subject;
        $data['body'] = $body;
        // sent mail
        if ($this->sendstatusmail($data)) {
            $response = json_encode(array('status' => '1', 'message' => 'Mail sent Successfully.'));
        } else {
            $response = json_encode(array('status' => '0', 'message' => 'Opps! Something is went wrong.'));
        }
        return $response;
    }

    public function sendstatusmail($data) {
        $this->load->library('email');

        // initial config
        $config['mailtype'] = 'html';
        $config['charset'] = 'iso-8859-1';
        $config['wordwrap'] = FALSE;
        $config['validate'] = TRUE;
        $config['newline'] = "\r\n";

        $this->email->initialize($config);
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to($data['emailid'], $data['username']);
        $this->email->subject($data['subject']);
        $this->email->message($data['body']);
        if (!$this->email->send()) {
            return false;
        } else {

            return true;
        }

    }

    public function logout() {
        session_destroy();
        redirect('xdocapplogin');
    }

    public function getLink($driver, $trip) {
        $link1 = base_url() . "cab/track/" . encryptIt($driver, $trip);
        return $link1;
    }

    public function getDist($vehicle_id, $lat, $lng) {
        $rr = array('0', '0');
        $imei1 = $this->db->select("latitude,longitude")->get_where("tb_trucks_data", array('id' => $vehicle_id), 1, 0);
        if ($imei1->num_rows() > 0) {
            $mbl = $imei1->row();
            if ($lat > 0 && $lng > 0 && $mbl->latitude > 0 && $mbl->longitude > 0) {
                $d = array();
            }
            $dist = distancemetrixship($lat, $lng, $mbl->latitude, $mbl->longitude);
            $d['distance'] = $dist['disttext'];
            $d['duration'] = $dist['duratext'];
            $rr[0] = $d['distance'];
            $rr[1] = $d['duration'];
        }
        return $rr;
    }

    public function sendAlert($trip, $emp, $mobile, $name, $distance, $veh, $link, $user_id, $curtz) {
        $result = array();
        $this->db->select('d.contact_num');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
        $this->db->where('t.id', $trip);
        $this->db->limit(1);
        $drivermobile = $this->db->get();
        $drivernum = "";
        if ($drivermobile->num_rows() > 0) {
            $drivernum = "(" . $drivermobile->row()->contact_num . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }

        $senddate = date('Y-m-d H:i:s');
        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " will be reached in " . $distance[1] . ", it is in distance " . $distance[0] . ",track your truck by " . $link;
        $smsdata = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $senddate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message" => $message,
            "id" => $sentid);
        if ($user_id == "") {
            $user_id = 0;
        }
        $datas = array(
            "emp_id" => $emp,
            "trip_id" => $trip,
            "mobile" => $mobile,
            "message" => $message,
            "user_id" => $user_id,
            "created_on" => $senddate,
        );
        $ins = $this->db->insert("tb_trip_alerts", $datas);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));

        return $result;
    }

    public function sendBulkAlert($trip, $emp, $mobile, $name, $drivernum, $veh, $link, $user_id, $curtz) {
        $result = array();
        if ($drivernum != "") {
            $drivernum = "(" . $drivernum . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }
        $logdate = date('Y-m-d H:i:s');

        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " is started now,track your truck by " . $link;
        $smsdata = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $logdate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message" => $message,
            "id" => $sentid);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert Once", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));

        return $result;
    }

    public function sendepodstatusnotify($postdata) {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $fileName = $postdata['file_name'];
        $chkcust = $this->db->query("SELECT o.*,c.name FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.order_id='" . $order_id . "' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $cust_id = $orddata['customer_id'];
            $user_id = $orddata['user_id'];
            $cust_name = $orddata['name'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            $createdsource = $orddata['created_source'];
            $chkref = "XSR";
            $whrin = " AND reference_id in('XSR','SD') ";
            $chkordtypeqry = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
            $refval = $refvalue = "";
            $iofeof = "EOF";
            if ($chkordtypeqry->num_rows() > 1) {

                foreach ($chkordtypeqry->result() as $oref) {

                    if ($oref->reference_id == "XSR") {
                        $refvalue = $oref->ref_value;
                    }
                    if ($oref->reference_id == "SD" && $oref->ref_value == "2") {
                        $iofeof = "IOF";
                    }
                }
                if($createdsource != 5){
                    $chkparty = "SELECT party_id,partycontact_id,customer_id,email_note,emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                    $query = $this->db->query($chkparty);
                    if ($query->num_rows() > 0) {
                        $this->load->library('email');
                        foreach ($query->result() as $pmails) {
                            $receivename = $pmails->party_name;
                            $receivemail = $pmails->emailid;
                            $data['order'] = $orddata;
                            $data['page_title'] = "Booking ePOD";
                            $data['receivemail'] = $receivemail;
                            $data['receivename'] = $receivename;

                            $sub = $refvalue . "#746#" . $iofeof;
                            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                            $this->email->to($receivemail, $receivename);

                            $this->email->subject($sub);
                            $this->email->set_mailtype("html");
                            $body = $this->load->view('mail_forms/bookepod', $data, true);
                            $this->email->message($body);
                            $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                            $this->email->attach($epodpath);
                        }
                    }
                }
            }
        }
    }

    /*
     *  Purpose : To Save Deviation Details.
     *  $param status_type int
     *  $param reason string
     *  $param comment string
     *  $param deviation_picture  file
     *  return json
     */

    function save_deviation_info() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['status_type'] = $this->input->post('status_type', TRUE);
        $data['reason'] = $this->input->post('reason', TRUE);
        $data['comment'] = $this->input->post('comment', TRUE);
        $data['shift_id'] = $this->input->post('shift_id', TRUE);
        $data['stop_id'] = $this->input->post('stop_id', TRUE);
        $data['trip_id'] = $this->input->post('trip_id', TRUE);
        $data['stop_detail_id'] = $this->input->post('stop_detail_id', TRUE);
        $data['stop_type'] = $this->input->post('stop_type', TRUE);
        $data['driver_id'] = $this->input->post('driver_id', TRUE);
        $data['shift_veh_id'] = $this->input->post('shift_veh_id', TRUE);

        if (strlen($data['reason']) < 5) {
            $response = array("status" => '0', "message" => 'Reason must contain atleast 5 characters');
            echo json_encode($response);
            return;
        }

        if (!(is_numeric($data['shift_id']) && is_numeric($data['stop_id']) && is_numeric($data['trip_id']) && is_numeric($data['stop_detail_id']))) {
            $response = array("status" => '0', "message" => 'Please provide valid details');
            echo json_encode($response);
            return;
        }

        if (isset($_FILES)) {
            $fileName1 = $this->input->post('shift_id') . '_' . $this->input->post('trip_id') . '_' . $this->input->post('stop_id') . '_' . $this->input->post('stop_detail_id') . '_' . $this->input->post('stop_type') . '_' . uniqid() . '_' . time() . '.jpg';

            if (isset($_FILES['deviation_picture']['name'])) {
                $config = array(
                    'upload_path' => './assets/deviationuploads/',
                    'allowed_types' => 'jpg|jpeg|png',
                    'overwrite' => TRUE,
                    'file_name' => $fileName1,
                    'remove_spaces' => TRUE,
                    'detect_mime' => TRUE,
                    'mod_mime_fix' => TRUE,
                    'max_size' => 2048,
                    'file_ext_tolower' => TRUE
                );
                $file_ext = @strtolower(end(explode('.', $_FILES['deviation_picture']['name'])));
            }
            $expensions = array("jpeg", "jpg", "png");
            if (in_array($file_ext, $expensions) === false) {
                $response = array("status" => 0, "data" => "Image Format Not Allowed");
            } else {
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if ($this->upload->do_upload('deviation_picture')) {
                    $imgname = $this->upload->data();
                    $imgtype = $imgname['image_type'];
                    $fileName = $imgname['file_name'];
                    $data['image_path'] = $fileName1;

                } else {
                    $errors = $this->upload->display_errors();

                }
            }
        }

        $res = $this->common->insertTableData("tb_deviations_details", $data);
        if ($res > 0) {
            $response = array("status" => '1', "message" => 'Deviation details saved succesfully.');
        }
        echo json_encode($response);
    }

    public function removestoppod() {
        $response = array("status" => 0, "data" => "Not Found");
        $id = isset($_POST["id"]) ? $_POST["id"] : '';
        $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
        $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
        $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : '';
        $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
        if ($id > 0) {
            $whr = array("id" => $id, "status" => 1);
            $qry = $this->db->select("id")->get_where("tb_pod_uploads", $whr);
            if ($qry->num_rows() > 0) {
                $resdata = array("status" => 0);
                $upd = $this->db->where($whr)->update("tb_pod_uploads", $resdata);
                $response = array("status" => 1, "data" => "Removed Successfully");
            }
        }
        echo json_encode($response);
    }

    public function setshipAbort() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data = array();

            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }

            $curdt = date('Y-m-d H:i:s');
            $latitude = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $shipment_id = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $trip_id = isset($_POST['trip_id']) ? $_POST["trip_id"] : 0;
            $driver_id = isset($_POST['driver_id']) ? $_POST["driver_id"] : '0';
            $vehicle_id = isset($_POST['vehicle_id']) ? $_POST["vehicle_id"] : '0';
            $reason = isset($_POST['reason']) ? $_POST["reason"] : '';
            $pdfName = $fileName = "";
            $ordid = $podinsid = 0;
            $legsorder_id = "";
            $uid = 5;
            if (isset($_FILES)) {
                if (isset($_FILES['photo']['name'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => 'jpg|gif|png|pdf',
                        'overwrite' => true,
                    );
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('photo')) {
                        $imgname = $this->upload->data();
                        $fileName = $imgname['file_name'];
                        $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id FROM tb_orders o WHERE o.shift_id='" . $shipment_id . "' LIMIT 1");
                        if ($chkord->num_rows() > 0) {
                            $ordid = $chkord->row()->id;
                            $legsorder_id = $chkord->row()->order_id;
                            $uid = $chkord->row()->user_id;
                        }
                        $filedata = array('trip_id' => $trip_id, 'shipment_id' => $shipment_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 3, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt);
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $podinsid = $this->db->insert_id();
                    }
                }
            }
            if ($ordid == 0) {
                $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id FROM tb_orders o WHERE o.shift_id='" . $shipment_id . "' LIMIT 1");
                if ($chkord->num_rows() > 0) {
                    $ordid = $chkord->row()->id;
                    $legsorder_id = $chkord->row()->order_id;
                    $uid = $chkord->row()->user_id;
                    if ($podinsid > 0) {
                        $upd = $this->db->where(array("id" => $podinsid))->update("tb_pod_uploads", array("order_id" => $ordid));
                    }
                }
            }
            if ($ordid > 0) {
                $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $trip_id,
                    "driver_id" => $driver_id,
                    "stop_id" => "",
                    "order_id" => $legsorder_id,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );

                /* send to roadlog */
                $sts = $this->statusintigration->roadlogshipmentabort($postdata);
                $statuscode = "0217";
                $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => 6, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
                $qry = $this->db->insert('tb_stop_status', $addstatus);

                if ($qry) {
                    $this->db->where('id', $shipment_id)->limit(1);
                    $this->db->update('tb_shifts', ['aborted' => 1]);
                }
            }
            $response = array("status" => 1, "data" => "Updated");
        }
        echo json_encode($response);
    }

    public function closeTrip() {
        if ($_POST) {

            $data["driver_id"] = $_POST["driver_id"];
            $data["id"] = $_POST["trip_id"];
            if ($data["id"] != "") {
                $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';
                if ($curtz == "") {
                    $curtz = "Asia/Singapore";
                }
                $data["id"] = trim($data["id"]);
                $gettrip = $this->db->select("shift_id")->get_where("tb_trips", array("id" => $data["id"], "status" => 1), 1, 0);
                if ($gettrip->num_rows() > 0) {

                    $curdt = date('Y-m-d H:i:s');
                    $shiftid = $gettrip->row()->shift_id;
                    $updwhr = array("id" => $shiftid);
                    $upddata = array("status" => '0', "updated_on" => $curdt);
                    if($shiftid>0){
                        $upd = $this->db->where(array("id" => $shiftid))->update("tb_shifts", $upddata);
                        $upd = $this->db->where(array("shift_id" => $shiftid))->update("tb_orders", array("trip_sts" => '1'));
                    }
                    $data1 = array();
                    $data1["end_imei"] = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
                    $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '0';
                    $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : $shiftid;
                    $latitude = isset($_POST["latitude"]) ? $_POST["latitude"] : '';
                    $longitude = isset($_POST["longitude"]) ? $_POST["longitude"] : '';
                    $data1["etime"] = $data1["updated_on"] = $curdt;
                    $data1["status"] = '0';
                    $data1["dlat"] = $latitude;
                    $data1["dlng"] = $longitude;
                    $res = $this->db->set($data1)->where($data)->update("tb_trips");
                    if ($res) {
                        $shift_res = $this->db->select('user_id,order_id')->order_by('id', 'desc')->get_where("tb_employee", array("shift_id" => $shipment_id), 1, 0);
                        if ($shift_res->num_rows() > 0) {
                            $shift = $shift_res->row();
                            $uid = $shift->user_id;
                            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                            $hrs = $gethrs->row()->cntry_hrs;
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id" => $data["id"],
                                "driver_id" => $data["driver_id"],
                                "stop_id" => '',
                                "order_id" => $shift->order_id,
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );
                            $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, "");
                            if ($stop_closed) {

                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipmenttripdeliverpartial($postdata);
                            } else {

                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                            }
                            $gensum = $this->generatesummary($data["id"], $curtz);
                            echo json_encode($this->printable(array("status" => "1", "data" => "Closed Sucessfully")));
                        } else {
                            echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                        }
                    } else {
                        echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                    }
                } else {
                    echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                }
            } else {
                echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
            }
        } else {
            echo json_encode($this->printable(array("status" => "0", "data" => "Insufficient Input Data")));
        }
    }

    public function printable($array) {
        $ret = [];
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $ret[$key] = $this->printable($value);
            } else {
                if (!isset($value) || $value == null) {
                    $value = "";
                }
                $ret[$key] = "$value";
            }
        }
        return $ret;
    }

    public function generatesummary($tripid = null, $curtz = null) {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }

            $curdt = date('Y-m-d H:i:s');
            $reg = "";
            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading, end_reading,trip_type,plat,plng,dlat,dlng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $data["tripinfo"] = $sql->row();
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace FROM tb_shifts WHERE id=" . $shift . " LIMIT 1");
                $data["trip"] = $sql1->row();
                $order_id = "";
                $emp1 = $this->db->query("select e.name,convertToClientTZ(te.stime,'" . $curtz . "') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=" . $tripid);
                if ($emp1->num_rows() > 0) {
                    $order_id = $emp1->row()->order_id;
                }
                if ($order_id == "") {
                    $order = $this->db->query("select order_id from tb_employee WHERE shift_id=" . $shift . " LIMIT 1");
                    if ($order->num_rows() > 0) {
                        $order_id = $order->row()->order_id;
                    }
                }
                $emp = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $trucks_query = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume from tb_trucks_data WHERE id=$vehicleid LIMIT 1");
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                }
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }


                $sql2 = $this->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 0;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt);
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                $data["trip_id"] = $tripid;
                $shifttime = 0;
                if ($trip_type != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }
                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $dist;
                $data["stime"] = $stime;
                $data["etime"] = $etime;
                $data["simei"] = $imei;
                $data["eimei"] = $eimei;
                if ($odometer_end == "") {
                    $odometer_end = 0;
                }
                if ($odometer_start == "") {
                    $odometer_start = 0;
                }
                $data["odometer"] = ($odometer_end - $odometer_start);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cab_capacity;
                $data["employees"] = $emp1;
                $data["trip_type"] = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"] = $truck_weight;
                $data["truck_volume"] = $truck_volume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);
                    $repotmaildata = $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);
                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    if ($trip_type == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else if ($trip_type == 2) {
                        $this->email->subject('svkonekt: Empty Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }

            }
        }
    }

    public function poduploads() {
        $response = array("status" => 0, "data" => "Upload Failed!");
        if (isset($_POST)) {
            $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
            $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;
            $status_id = isset($_POST['status_id']) ? $_POST['status_id'] : null;
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : null;
            $shipment_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : null;
            $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : null;
            $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : null;
            $stop_detail_type = isset($_POST['stop_detail_type']) ? $_POST['stop_detail_type'] : null;
            $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : null;
            $curtz = isset($_POST['timezone']) ? $_POST['timezone'] : '';

            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }

            $curdt = date('Y-m-d H:i:s');
            $pdfName = $fileName = "";

            if (isset($_FILES) || isset($_POST['i_am_base64'])) {

                if (isset($_FILES['file_name']['name']) || isset($_POST['i_am_base64'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => '*',
                        'overwrite' => true,
                    );

                    $file_name = $_FILES['file_name']['name'];
                    $file_ext = @strtolower(end(explode('.', $_FILES['file_name']['name'])));

                    /*
                     * If Image is a base64
                     */
                    $receive_base64 = false;
                    if (isset($_POST['i_am_base64'])) {
                        // valid base64
                        $encoded_image = explode(",", $_POST['i_am_base64'])[1];
                        $decoded_image = base64_decode($encoded_image);

                        $receive_base64 = TRUE;
                        $file_ext = 'jpeg';


                        $file_name = 'Sign_' . date('Ymd') . '_' . $trip_id . '_' . $shipment_id . '_' . $stop_id . '_' . $stop_detail_id . '_' . time() . '_' . uniqid() . '' . $file_ext;
                        file_put_contents($config['upload_path'] . $file_name, $decoded_image);
                    }

                    $expensions = array("jpeg", "jpg", "png", "gif", "pdf");

                    if (in_array($file_ext, $expensions) === false) {
                        $response = array("status" => 0, "data" => "Image Format Not Allowed");
                    } else {
                        if (!$receive_base64) {
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                                $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                            } else {
                                $errors = $this->upload->display_errors();
                                $response = array("status" => 0, "data" => $errors);
                            }
                        } else {
                            // base 64 data block
                            $imgname = $file_name;
                            $imgtype = $file_ext;
                            $fileName = $file_name;
                            $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                        }
                        if ($fileName != "") {
                            $stptype = "P";
                            $txncode = "";
                            $ordid = 0;
                            $legsorder_id = "";
                            if ($stop_id != "") {
                                $chkstype = $this->db->select("stoptype,txncode")->get_where("tb_shiporder_stops", array("id" => $stop_id, "status" => 1), 1, 0);
                                if ($chkstype->num_rows() > 0) {
                                    if ($chkstype->row()->stoptype == "D") {
                                        $stptype = $chkstype->row()->stoptype;
                                    }
                                    $txncode = $chkstype->row()->txncode;
                                }
                            }
                            $uid = 0;
                            $ord_whr = "";
                            if ($stop_id != "") {
                                $ord_whr = " AND (e.stop_id=" . $stop_id . " OR e.drop_stopid=" . $stop_id . ") ";
                            }
                            if ($stop_detail_id != "") {
                                $ord_whr = " AND e.id=" . $stop_detail_id;
                            }
                            $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id,o.shipmentid FROM tb_orders o,tb_employee e WHERE o.order_id=e.order_id AND o.shift_id='" . $shipment_id . "' AND e.status=1 $ord_whr LIMIT 1");
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $uid = $chkord->row()->user_id;
                                if ($txncode == "") {
                                    $txncode = $chkord->row()->shipmentid;
                                }
                            }
                            $filedata = array('stop_id' => $stop_id, "shipment_id" => $shipment_id, 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_id, 'imgpath' => $fileName, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stptype, 'user_id' => $uid, 'createdby' => $driver_id, 'order_id' => $ordid, 'status' => 1, 'createdon' => $curdt);
                            $res = $this->db->insert("tb_pod_uploads", $filedata);
                            $podinsid = $this->db->insert_id();
                            if ($stop_id == "") {
                                $stop = $this->db->select('id,stoptype,txncode')->order_by('ordernumber', 'ASC')->get_where("tb_shiporder_stops", array("shipment_id" => $shipment_id), 1, 0)->row();
                                $txncode = $stop->txncode;
                                $stop_id = $stop->id;
                                $stptype = $stop->stoptype;
                            }
                            $cnt = $this->db->select('id')->get_where('tb_pod_uploads', array('trip_id' => $trip_id))->num_rows();
                            if ($cnt == 0) {
                                $cntstr = "001";
                            } else {
                                $cntstr = "00" . $cnt;
                                if ($cnt > 9) {
                                    $cntstr = "0" . $cnt;
                                }
                            }
                            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                            $hrs = $gethrs->row()->cntry_hrs;
                            $imgtype = isset($imgtype) ? $imgtype : 'png';
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id" => $trip_id,
                                "driver_id" => $driver_id,
                                "stop_id" => $stop_id,
                                "order_id" => $legsorder_id,
                                "txn_id" => $txncode,
                                "txn_code" => $txncode,
                                "file_name" => $fileName,
                                "file_type" => $imgtype,
                                "inc_id" => $cntstr,
                                'pod_type' => $status_id,
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "stop_type" => $stptype,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );

                            if ($status_id == '3') {
                                $sts = $this->statusintigration->roadlogorderpodstatus($postdata);
                                /* send mail to customer */
                                $sendnotify = $this->sendshipstatusnotify($postdata, 6);

                                /* send mail to specific party */
                                $sendnotify = $this->sendepodstatusnotify($postdata);
                            }

                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function updatepassword() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $newpassword = isset($_POST['newpassword']) ? $_POST['newpassword'] : "";
        if (isset($_POST)) {
            if ($driver_id > 0 && $user_id > 0 && $newpassword != "") {
                $chk = $this->db->select("id")->get_where("tb_truck_drivers", array("id" => $driver_id), 1, 0);
                if ($chk->num_rows() > 0) {
                    $pwd =  password_hash($newpassword,PASSWORD_DEFAULT);
                    $upd = array("password" => $pwd);
                    $updqry = $this->db->set($upd)->where(array("id" => $driver_id))->update("tb_truck_drivers");
                    $response = array("status" => 1);
                }
            }
        }
        return json_encode($response);
    }

    function inscan() {

        $this->load->view('xdocapp/instascan');
    }

    function instascan_quantity() {
        $cargo_id = $this->input->post('cargo_id', TRUE);
        $quantity = $this->input->post('quantity', TRUE);
        if (!empty($cargo_id) && !empty($quantity)) {
            $scanned_cargos = $this->session->userdata('scanned_cargos');
            if (!empty($scanned_cargos) && is_array($scanned_cargos)) {
                if ((!empty($scanned_cargos['cargo_id_' . $cargo_id])) && isset($scanned_cargos['cargo_id_' . $cargo_id])) {
                    // array index found so update quanity
                    $prev_quantity = $scanned_cargos['cargo_id_' . $cargo_id];
                    $scanned_cargos['cargo_id_' . $cargo_id] = $quantity + $prev_quantity;
                    $this->session->set_userdata('scanned_cargos', $scanned_cargos);
                } else {
                    // index not found so add new item into session.
                    $scanned_cargos['cargo_id_' . $cargo_id] = $quantity;
                    $this->session->set_userdata('scanned_cargos', $scanned_cargos);
                }
            } else {
                $scanned_cargos = array();
                $scanned_cargos['cargo_id_' . $cargo_id] = $quantity;
                $this->session->set_userdata('scanned_cargos', $scanned_cargos);
            }
        } else {

        }
    }

    function test1($handling_unit, $quantity) {
        $this->load->library('barcode');
        $path = $this->barcode->generate(json_encode(array("cargo_id" => $handling_unit, "quantity" => $quantity)));
        $file_url = base_url($path);
        echo "<a href='$file_url' target='_blank'>click</a>";
    }

    function get_shipment_stops_list($shift_id = '', $trip_id = '', $shift_veh_id = '') {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $timezone = $this->session->userdata('timezone');
        $_POST = array("shift_id" => $shift_id, "trip_id" => $trip_id, "shift_veh_id" => $shift_veh_id, "timezone" => $timezone);
        $getshipmentstops = (object) json_decode($this->getshipmentstops());
        $status = $getshipmentstops->status;
        if ($status == "1") {
            return $shipmentstops = $getshipmentstops->data;
        } else {
            return array();
        }
    }

    function scan_and_load_using_reader() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $_POST = array("user_id" => "3", "shift_id" => "1365");
        $response = json_decode($this->getorderdetailsbyshipment());
        if ($response->status == "1") {
            $scan_and_load_data = $response->data;
            // set default scanner quantity to zero.
            for ($i = 0; $i < sizeof($scan_and_load_data); $i++) {

                $qr_codes[] = $scan_and_load_data[$i];
            }
            $data['scan_and_load_data'] = $qr_codes;
            $data['post_req_data'] = array("user_id" => "3", "shift_id" => "1365");
        }

        $data['body_content'] = 'xdocapp/scan_and_load_using_reader';
        $this->load->view('xdocapp/index', $data);
    }

    function barcode_reader() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data['scan_and_load_data'] = json_decode(html_entity_decode($this->input->post('scan_and_load_data')));

        $data['body_content'] = 'xdocapp/barcode_reader';
        $this->load->view('xdocapp/index', $data);
    }

    function scan_and_load_items_list() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $scan_and_load_data = json_decode(html_entity_decode($this->input->post('scan_and_load_data')));
        $received_qr = trim($this->input->post('received_qr'));
        for ($i = 0; $i < sizeof($scan_and_load_data); $i++) {
            $qr_code = $scan_and_load_data[$i]->qr_code;
            if ($received_qr == $qr_code) {
                if (is_numeric($scan_and_load_data[$i]->scanned_quantity)) {
                    $scan_and_load_data[$i]->scanned_quantity = $scan_and_load_data[$i]->scanned_quantity + 1;
                } else {
                    $scan_and_load_data[$i]->scanned_quantity = 1;
                }
            }
        }
        $data['scan_and_load_data'] = $scan_and_load_data;
        $data['post_req_data'] = array("user_id" => "3", "shift_id" => "1365");
        $this->load->view('xdocapp/scan_and_load_using_reader', $data);
    }

    public function getorderdetailsbyshipment() {
        if ($this->session->userdata('is_login') == '') {
            redirect('xdocapplogin', 'refresh');
        }
        $data = array();
        $response = array("status" => 0, "data" => $data);
        if (isset($_POST)) {
            $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            if ($shift_id == "") {
                $shift_id = 0;
            }
            if ($shift_id != 0) {
                $getdetails = $this->common->gettbldata(array('shift_id' => $shift_id), 'id', 'tb_orders', 0, 0);
                if (!empty($getdetails)) {
                    foreach ($getdetails as $res) {
                        $order_id = $res['id'];
                        $cargos = array();
                        $cargos_ref = $this->db->query("SELECT c.cargo_type,c.length_unit,c.width_unit,c.height_unit,c.volweight_uom,c.weight_unit,c.volume_unit,o.id as cargo_id,o.order_id as order_id,o.length,o.width,o.height,o.weight,o.volumetric_weight,o.ldm,o.volume,o.quantity,o.scanned_quantity,o.cargo_content,o.buyer_part,o.qr_code FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id =c.id");
                        if ($cargos_ref->num_rows() > 0) {
                            foreach ($cargos_ref->result() as $row) {
                                $scanned_quantity = $row->scanned_quantity;
                                if ($scanned_quantity == "") {
                                    $scanned_quantity = '0';
                                } else {
                                    $scanned_quantity = round($scanned_quantity);
                                }
                                $data[] = array('cargo_type' => $row->cargo_type, 'cargo_content' => $row->cargo_content,
                                    'length' => $row->length, 'length_unit' => $row->length_unit, 'width' => $row->width,
                                    'width_unit' => $row->width_unit, 'height' => $row->height, 'height_unit' => $row->height_unit,
                                    'volumetric_weight' => $row->volumetric_weight, 'volweight_uom' => $row->volweight_uom,
                                    'ldm' => $row->ldm, 'volume' => $row->volume, 'volume_unit' => $row->volume_unit,
                                    'cargo_id' => $row->cargo_id, 'buyer_part' => $row->buyer_part, 'qr_code' => $row->qr_code,
                                    'actual_quantity' => round($row->quantity), 'scanned_quantity' => $scanned_quantity,
                                    'order_id' => $row->order_id);
                            }
                        }
                    }
                }
                $response = array("status" => 1, "data" => $data);
            } else {
                $response = array("status" => 0, "data" => $data);
            }
        }

        $response = $this->printable($response);
        return json_encode($response);
    }
}
