<?php

defined('BASEPATH') or exit('No direct script access allowed');

use phpseclib\Net\SFTP;

class KNSarathiEDI extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library(['apis/SarathiEDIServices', 'apis/TCIExpressEDIServices']);
	}
	
	public function index()
	{
		ini_set("max_execution_time", 1000);
		try {
			$postData = file_get_contents('php://input');
			$postData = str_replace("otm:", "", $postData);
			log_message("error","Otm Trip Request Sarathi:".$postData);
			if (!$this->tciexpressediservices->checkClientAuth('KNSARATHI')) {
                header('HTTP/1.1 401 Unauthorized');
                header('WWW-Authenticate: Basic realm="API Access"');
                echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                exit;
            }
			if (empty($postData)) {
				echo "Please send proper XML Data";
				exit();
			}
			echo $this->sarathiediservices->getOtmShipmentData($postData);
		} catch (Exception $exc) {
			log_message("error", " SarathiTripDetails Catch Block:" . $exc->getTraceAsString());
		}
	}
}
