<?php

defined('BASEPATH') or exit('No direct script access allowed');

//use phpseclib\Net\SFTP;

class OtmOrderDetails extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library(['OtmBookingHandler']);
		$this->load->helper('auth');
	}

	public function index()
	{
		ini_set("max_execution_time", 1000);
		try {
			$postData = file_get_contents('php://input');
			log_message("error","Otm Order Request1111:".$postData);
			$postData = str_replace("otm:", "", $postData);
			//log_message("error","Otm Order Request:".$postData);
			$postData = str_replace(' xmlns="http://xmlns.oracle.com/apps/otm/transmission/v6.4"',"",$postData);
			if (empty($postData)) {
				echo "Please send proper XML Data";
				exit();
			}
			echo $this->otmbookinghandler->getOtmOrderReleaseData($postData);
		} catch (Exception $exc) {
			log_message("error", " OtmOrderDetails Catch Block:" . $exc->getTraceAsString());
		}
	}
	
	
	public function ELOGOrder()
	{
		ini_set("max_execution_time", 1000);
		try {
			$postData = file_get_contents('php://input');
			if (empty($postData)) {
				echo "Please send proper XML Data";
				exit();
			}
			$orderXML = json_decode(
			json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)),
			true,
			512,
			JSON_THROW_ON_ERROR
		);
			echo $this->otmbookinghandler->pullOrderXml($orderXML);
		} catch (Exception $exc) {
			log_message("error", " OtmOrderDetails Catch Block:" . $exc->getTraceAsString());
		}
	}
}
