<?php

defined('BASEPATH') or exit('No direct script access allowed');

use phpseclib\Net\SFTP;

class OtmTripDetails extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library(['OtmTripHandler','apis/SarathiEDIServices']);
	}
	
	public function index()
	{
		ini_set("max_execution_time", 1000);
		try {
			$postData = file_get_contents('php://input');
			$postData = str_replace("otm:", "", $postData);
			log_message("error","Otm Trip Request:".$postData);
			$postData = str_replace(' xmlns="http://xmlns.oracle.com/apps/otm/transmission/v6.4"',"",$postData);
			if (empty($postData)) {
				echo "Please send proper XML Data";
				exit();
			}
			echo $this->otmtriphandler->getOtmShipmentData($postData);
		} catch (Exception $exc) {
			log_message("error", " OtmTripDetails Catch Block:" . $exc->getTraceAsString());
		}
	}
	
	public function KNSarathiAPI()
	{
		ini_set("max_execution_time", 1000);
		try {
			$postData = file_get_contents('php://input');
			$postData = str_replace("otm:", "", $postData);
			log_message("error","Otm Trip Request Sarathi:".$postData);
			if (empty($postData)) {
				echo "Please send proper XML Data";
				exit();
			}
			echo $this->sarathiediservices->getOtmShipmentData($postData);
		} catch (Exception $exc) {
			log_message("error", " OtmTripDetails Catch Block:" . $exc->getTraceAsString());
		}
	}
}
