<?php

defined('BASEPATH') OR exit('No direct script access allowed');
class Singlestatusedi extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['Singlestatusmodel', 'Roadlogtosalogmodel']);
    }

    public function index(): void
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error","Post:".json_encode($postData));
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                echo $this->parseStatusXml($xmldata);
            }
        } else {
            echo "Please Send Proper XML";
        }
    }

    public function parseStatusXml(object $xmldata): string
    {
        $header = $xmldata->xpath('SVKEDITransmissionHeader');
        $body = $xmldata->xpath('SVKEDITransmissionBody');
        log_message("error","body:".json_encode($body));
        $headerdata = [
            //"partyId" => isset($header[0]->PartyId) ? (string)($header[0]->PartyId) : "",
            "SenderTransmissionNo" => isset($header[0]->SenderTransmissionNo) ? (string)($header[0]->SenderTransmissionNo) : "",
            "emailaddress" => isset($header[0]->AckSpec->EmailAddress) ? (string)($header[0]->AckSpec->EmailAddress) : "",
            "ackoption" => isset($header[0]->AckSpec->AckOption) ? (string)($header[0]->AckSpec->AckOption) : "",
            "sourceapp" => isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "",
            "destinationapp" => isset($header[0]->DestinationApp) ? (string)($header[0]->DestinationApp) : "",
            //"referenceid" => isset($header[0]->ReferenceId) ? (string)($header[0]->ReferenceId) : "",
            "action" => isset($header[0]->Action) ? (string)($header[0]->Action) : "",
        ];
        $ordersData = [];
        log_message("error","order:".json_encode($body[0]->Order));
        foreach ($body[0]->Order as $order) {
            $orderId = isset($order[0]->OrderID) ? (string)($order[0]->OrderID) : "";
            $statusCode = isset($order[0]->Status->StatusCode) ? (string)($order[0]->Status->StatusCode) : "";
            if ($orderId != '' && $statusCode != '') {
                $ordersData[] = [
                    "OrderID" => $orderId,
                    //"externalreferenceid" => isset($order[0]->ExternalReferenceId) ? (string)($order[0]->ExternalReferenceId) : "",
                    "statustype" => isset($order[0]->Status->StatusType) ? (string)($order[0]->Status->StatusType) : "",
                    "statuscode" => $statusCode,
                    "statusvalue" => isset($order[0]->Status->StatusValue) ? (string)($order[0]->Status->StatusValue) : "",
                    "datetime" => isset($order[0]->Status->DateTime) ? (string)($order[0]->Status->DateTime) : "",
                    "timezone" => isset($order[0]->Status->TimeZone) ? (string)($order[0]->Status->TimeZone) : "",
                    //"utc" => isset($order[0]->Status->UTC) ? (string)($order[0]->Status->UTC) : "",
                    "lat" => isset($order[0]->Status->Lat) ? (string)($order[0]->Status->Lat) : "",
                    "lng" => isset($order[0]->Status->Lng) ? (string)($order[0]->Status->Lng) : "",
                    "location" => isset($order[0]->Status->Location) ? (string)($order[0]->Status->Location) : "",
                    "actionuser" => isset($order[0]->Status->ActionUser) ? (string)($order[0]->Status->ActionUser) : "",
                    /*"PODURL" => isset($order[0]->Pod->PodImage) ? (string)($order[0]->Pod->PodImage) : "",
                    "referenceCode" => isset($order[0]->References->ReferenceCode) ? (string)($order[0]->References->ReferenceCode) : "",
                    "referenceValue" => isset($order[0]->References->ReferenceValue) ? (string)($order[0]->References->ReferenceValue) : "",*/
                ];
            }
        }
        log_message("error","ordersData1111:".json_encode($ordersData));
        $statusresponse = $this->Singlestatusmodel->updateStatus(json_encode($ordersData));
        log_message("error","statusresponse:".$statusresponse);
        if ("0" === $statusresponse) {
            return "No Order Id Found";
        } else {
            return "Status Updated Successfully";
        }
    }
    
    public function statusDTO(): void
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error","Post:".json_encode($postData));
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                echo $this->getStatus($xmldata);
            }
        } else {
            echo "Please Send Proper XML";
        }
    }
    
    public function getStatus(object $xmldata): string
    {
        $header = $xmldata->xpath('SVKEDITransmissionHeader');
        $carrier = isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "";
        $body = $xmldata->xpath('SVKEDITransmissionBody');
        $ordersData = [];
        log_message("error","order:".json_encode($body[0]->Order));
        foreach ($body[0]->Order as $order) {
            $orderId = isset($order->OrderID) ? (string)($order->OrderID) : "";
            log_message("error","status:".json_encode($order->Status));
            foreach ($order->Status as $status) {
                $statusCode = isset($status->StatusCode) ? (string)($status->StatusCode) : "";
                if ($orderId != '' && $statusCode != '') {
                    $ordersData[] = [
                        "OrderID" => $orderId,
                        "statustype" => isset($status->StatusType) ? (string)($status->StatusType) : "",
                        "statuscode" => $statusCode,
                        "statusvalue" => isset($status->StatusValue) ? (string)($status->StatusValue) : "",
                        "datetime" => isset($status->DateTime) ? (string)($status->DateTime) : "",
                        "timezone" => isset($status->TimeZone) ? (string)($status->TimeZone) : "",
                        "lat" => isset($status->Lat) ? (string)($status->Lat) : "",
                        "lng" => isset($status->Lng) ? (string)($status->Lng) : "",
                        "location" => isset($status->Location) ? (string)($status->Location) : "",
                    ];
                    log_message("error","ordersData:".json_encode($ordersData));
                    $statusresponse = $this->Singlestatusmodel->updateXPStatus(json_encode($ordersData), $carrier);
                }
            }
        }
        
        log_message("error","statusresponse:".$statusresponse);
        if ("0" === $statusresponse) {
            return "No Order Id Found";
        } else {
            return "Status Updated Successfully";
        }
    }
}
