<?php if (! defined('BASEPATH')) {exit('No direct script access allowed');}

class StandardEDI extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['apis/TCIExpressEDIServices', 'apis/CarrierInboundServices', 'apis/FlipkartEDIServices', 'apis/StandardTripInboundService']);
        $this->load->library('standardtriphandler');
        $this->load->helper('auth_helper');
        $this->load->model('order');
        $this->load->model('apis/StandardTripInboundModel');
    }

    public function generateAPIToken(): void
    {
        $this->flipkartediservices->generateTCIExpressToken();
    }
    
    public function decryptPassword()
    {
        $pwd='$2y$10$T.f7pJDZkc.AcvogKDi8ROHBy5tAFDtRJHlxqjdJUsHzIHdzRDtEO';
        $newPassword = '1000605111';
        $newHash = password_hash($newPassword, PASSWORD_BCRYPT);
        /*$decryptedPwd = decryptCryptoLibPassword($pwd);
        $decryptedPwd1 = decryptAES256($pwd);
        $decryptedPwd2 = decryptPassword($pwd);
        log_message("error", "Post:" . $decryptedPwd);
        log_message("error", "Post1:" . $decryptedPwd2);*/
        echo $newHash;
        log_message("error", "Post1:" . $newHash);
    }

    public function getBookingInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post:" . json_encode($postData));
        if (! empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header    = $xmldata->xpath('SVKEDITripHeader');
                log_message("error", "header: " . json_encode($header));
                $sourceApp = isset($header[0]->SourceApp) ? (string) $header[0]->SourceApp : "";
                log_message("error", "sourceApp: " . $sourceApp);
                $clientIdentifier = isset($header[0]->ClientIdentifier) ? (string) $header[0]->ClientIdentifier : "";
                $carrierIdentifier = isset($header[0]->CarrierIdentifier) ? (string) $header[0]->CarrierIdentifier : "";
                if ($clientIdentifier !== null) {
                    $clientIdentifier = $this->StandardTripInboundModel->getPartyUsersAPIData(
                        'Source',
                        $sourceApp,
                        $clientIdentifier,
                        $carrierIdentifier,
                        $sourceApp
                    );
                    if (empty($clientIdentifier)) {
                        $response = [
                            "status" => "error",
                            "message" => "Invalid Client Identifier " . $clientIdentifier
                        ];
                    }
                }
                else{
                    $response = [
                        "status" => "error",
                        "message" => "Invalid Client Identifier " . $clientIdentifier
                    ];
                }
                log_message('error', 'clientIdentifier: ' . $clientIdentifier);
                
                //  Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($clientIdentifier)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
                $response = [];

                $data = json_decode(
                    json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)),
                    true
                );

                //log_message("error", "Data:" . json_encode($data));

                $insertResponse = $this->standardtripinboundservice->insertTripXmlData($data);
                //log_message("error", "Insert Response:" . json_encode($insertResponse));

                // Wrap response in a consistent structure
                if (isset($insertResponse['message'])) {
                    $message = $insertResponse['message'];
                } elseif (isset($insertResponse[0])) {
                    $message = $insertResponse[0];
                } else {
                    $message = "Unknown response";
                }

                // Extract booking number if present
                $booking = "";
                if (preg_match('/Booking\s*-\s*(\d+)/', $message, $matches)) {
                    $booking = $matches[1];
                }

                $response = [
                    "status"  => "success",
                    "message" => $message,
                    //"booking" => $booking
                ];
            }
        } else {
            $response = [
                "status"  => "error",
                "message" => "Please Send Proper XML",
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($response);
        exit; // stop further output
    }

    /*public function getStatusInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post: " . json_encode($postData));
    
        $response = [];
    
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
    
            if ($xmldata === false) {
                $response = [
                    "status" => "error",
                    "message" => "Invalid XML request",
                ];
            } else {
                $header = $xmldata->xpath('SVKEDITransmissionHeader');
                $sourceApp = isset($header[0]->SourceApp) ? (string) $header[0]->SourceApp : "";
                $clientIdentifier = isset($header[0]->ClientIdentifier) ? (string) $header[0]->ClientIdentifier : "";
                $carrierIdentifier = isset($header[0]->CarrierIdentifier) ? (string) $header[0]->CarrierIdentifier : "";
                if ($clientIdentifier !== null) {
                    $clientIdentifier = $this->StandardTripInboundModel->getPartyUsersAPIData(
                        'Client',
                        $sourceApp,
                        $clientIdentifier,
                        $carrierIdentifier,
                        $clientIdentifier
                    );
                    if (empty($clientIdentifier)) {
                        $response = [
                            "status" => "error",
                            "message" => "Invalid Client Identifier " . $clientIdentifier
                        ];
                    }
                }
                else{
                    $response = [
                        "status" => "error",
                        "message" => "Invalid Client Identifier " . $clientIdentifier
                    ];
                }
                log_message('error', 'clientIdentifier: ' . $clientIdentifier);
                
                //  Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($clientIdentifier)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
    
                // ✅ Process all Orders
                $orders = $xmldata->xpath('SVKEDITransmissionBody/Order');
    
                if (!empty($orders)) {
                    foreach ($orders as $orderNode) {
                        $orderId = isset($orderNode->OrderID) ? (string) $orderNode->OrderID : null;
    
                        if ($orderId) {
                            $orderDetails = $this->order->getOrderDetails($orderId);
                            //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                            if ($orderDetails && isset($orderDetails->id)) {
                                $order_id = $orderDetails->order_id;
                                $external_order_id = $orderDetails->external_order_id;
                                $id = (int)$orderDetails->id;
    
                                // 👇 Assuming this method internally logs its process
                                $this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
    
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "success",
                                    "message" => "Status updated"
                                ];
                            } else {
                                log_message("error", "Order not found for ID: " . $orderId);
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "error",
                                    "message" => "Order not found"
                                ];
                            }
                        }
                    }
                } else {
                    $response = [
                        "status" => "error",
                        "message" => "No <Order> nodes found in XML"
                    ];
                }
            }
        } else {
            $response = [
                "status" => "error",
                "message" => "Please send proper XML"
            ];
        }
    
        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    public function getDocsInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post:" . json_encode($postData));
        if (! empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header       = $xmldata->xpath('SVKHeader');
                $orderIdNodes = $xmldata->xpath('SVKOrderID');
                $orderId      = isset($orderIdNodes[0]) ? (string) $orderIdNodes[0] : null;
                $sourceApp = isset($header[0]->SVKSourceApp) ? (string) $header[0]->SVKSourceApp : "";
                $clientIdentifier = isset($header[0]->ClientIdentifier) ? (string) $header[0]->ClientIdentifier : "";
                $carrierIdentifier = isset($header[0]->CarrierIdentifier) ? (string) $header[0]->CarrierIdentifier : "";
                if ($clientIdentifier !== null) {
                    /*log_message("error", "sourceApp:" . $sourceApp);
                    log_message("error", "clientIdentifier:" . $clientIdentifier);
                    $clientIdentifier = $this->StandardTripInboundModel->getPartyUsersAPIData(
                        'Client',
                        $sourceApp,
                        $clientIdentifier,
                        $carrierIdentifier,
                        $clientIdentifier
                    );
                    //log_message("error", "Qry:" . $this->db->last_query());
                    if (empty($clientIdentifier)) {
                        $response = [
                            "status" => "error",
                            "message" => "Invalid Client Identifier " . $clientIdentifier
                        ];
                    }
                }
                else{
                    $response = [
                        "status" => "error",
                        "message" => "Invalid Client Identifier " . $clientIdentifier
                    ];
                }
                //log_message('error', 'clientIdentifier: ' . $clientIdentifier);
                
                //  Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($clientIdentifier)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
                $response     = [];
                if ($orderId) {
                    $orderDetails = $this->order->getOrderDetails($orderId);
                    //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                    if ($orderDetails && isset($orderDetails->id)) {
                        $order_id = $orderDetails->order_id;
                        $external_order_id = $orderDetails->external_order_id;
                        $id = (int)$orderDetails->id;
    
                        // 👇 Assuming this method internally logs its process
                        //$this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
                        $this->tciexpressediservices->getXPPod($xmldata, $id);
    
                        $response = [
                            "order_id" => $orderId,
                            "status" => "success",
                            "message" => "Document updated"
                        ];
                    } else {
                        log_message("error", "Order not found for ID: " . $orderId);
                        $response = [
                            "order_id" => $orderId,
                            "status" => "error",
                            "message" => "Order not found"
                        ];
                    }
                }
            }
        } else {
            $response = [
                "status"  => "error",
                "message" => "Please Send Proper XML",
            ];
        }
        header('Content-Type: application/json');
        echo json_encode($response);
        exit; // stop further output
    }*/
    
    public function getStatusInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post: " . json_encode($postData));
    
        $response = [];
    
        if (!empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
    
            if ($xmldata === false) {
                $response = [
                    "status" => "error",
                    "message" => "Invalid XML request",
                ];
            } else {
                $header = $xmldata->xpath('SVKEDITransmissionHeader');
                $sourceApp = isset($header[0]->SourceApp) ? (string) $header[0]->SourceApp : "";
                
                //  Check Authorization
                if (!$this->tciexpressediservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
    
                // ✅ Process all Orders
                $orders = $xmldata->xpath('SVKEDITransmissionBody/Order');
    
                if (!empty($orders)) {
                    foreach ($orders as $orderNode) {
                        $orderId = isset($orderNode->OrderID) ? (string) $orderNode->OrderID : null;
    
                        if ($orderId) {
                            $orderDetails = $this->order->getOrderDetails($orderId);
                            //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                            if ($orderDetails && isset($orderDetails->id)) {
                                $order_id = $orderDetails->order_id;
                                //$external_order_id = $orderDetails->external_order_id;
                                $id = (int)$orderDetails->id;
    
                                // 👇 Assuming this method internally logs its process
                                if($sourceApp == "EKART"){$sourceApp = "FLIPKART";}
                                $this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
    
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "success",
                                    "message" => "Status updated"
                                ];
                            } else {
                                log_message("error", "Order not found for ID: " . $orderId);
                                $response = [
                                    "order_id" => $orderId,
                                    "status" => "error",
                                    "message" => "Order not found"
                                ];
                            }
                        }
                    }
                } else {
                    $response = [
                        "status" => "error",
                        "message" => "No <Order> nodes found in XML"
                    ];
                }
            }
        } else {
            $response = [
                "status" => "error",
                "message" => "Please send proper XML"
            ];
        }
    
        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    public function getDocsInboundAPI()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        log_message("error", "Post:" . json_encode($postData));
        if (! empty($postData)) {
            $xmldata = new SimpleXMLElement($postData);
            if ($xmldata === false) {
                echo "Invalid request,Please try again!";
            } else {
                $header       = $xmldata->xpath('SVKHeader');
                $orderIdNodes = $xmldata->xpath('SVKOrderID');
                $orderId      = isset($orderIdNodes[0]) ? (string) $orderIdNodes[0] : null;
                $sourceApp = isset($header[0]->SVKSourceApp) ? (string) $header[0]->SVKSourceApp : "";
                
                if (!$this->tciexpressediservices->checkClientAuth($sourceApp)) {
                    header('HTTP/1.1 401 Unauthorized');
                    header('WWW-Authenticate: Basic realm="API Access"');
                    echo json_encode(['status' => false, 'message' => 'Unauthorized']);
                    exit;
                }
                $response     = [];
                if ($orderId) {
                    $orderDetails = $this->order->getOrderDetails($orderId);
                    //log_message('error', 'orderDetails: ' . json_encode($orderDetails));
                    if ($orderDetails && isset($orderDetails->id)) {
                        $order_id = $orderDetails->order_id;
                        //$external_order_id = $orderDetails->external_order_id;
                        $id = (int)$orderDetails->id;
    
                        // 👇 Assuming this method internally logs its process
                        //$this->tciexpressediservices->getStatus($orderNode, $id, $sourceApp);
                        $this->tciexpressediservices->getXPPod($xmldata, $id);
    
                        $response = [
                            "order_id" => $orderId,
                            "status" => "success",
                            "message" => "Document updated"
                        ];
                    } else {
                        log_message("error", "Order not found for ID: " . $orderId);
                        $response = [
                            "order_id" => $orderId,
                            "status" => "error",
                            "message" => "Order not found"
                        ];
                    }
                }
            }
        } else {
            $response = [
                "status"  => "error",
                "message" => "Please Send Proper XML",
            ];
        }
        header('Content-Type: application/json');
        echo json_encode($response);
        exit; // stop further output
    }
}
