<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Dashboard extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['CodeIgniterAuthorization', 'session']);
        $this->load->model(['common','driverDashboard/DriverDashboard']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
    }

    public function index(): void
    {
        $uid = $this->session->userdata('user_id');
        $data['vendors'] = $this->DriverDashboard->getVendorslist($uid);
        $data['drivers'] = $this->DriverDashboard->getDriverlist($uid);
        $data['customers'] = $this->DriverDashboard->getCustomerlist($uid);
        $this->newtemplate->dashboard("driverDashboard/dashboard", $data);
    }

    public function ajaxtripListing(): void{
        $ajaxData['trips']  = $this->DriverDashboard->ajaxtripListing();
        $this->load->view('driverDashboard/getAjaxtrips', $ajaxData);
    }

    public function getmapsData(): void{
        $mapsdata['maps'] = $this->DriverDashboard->getallMapsdata();
        $this->load->view('driverDashboard/getAjaxtripmaps', $mapsdata);
    }
    public function getchartsData(): void{
        $chartdata['charts'] = $this->DriverDashboard->getallChartsdata();
        $this->load->view('driverDashboard/getAjaxtripchart', $chartdata);
    }

    public function getDriverlist(): void{
        $uid = $this->session->userdata('user_id');
        $get_drivers = $this->DriverDashboard->getDriverlist($uid);
        $driver = '<select class="form-control" name="driver"  id="driver">
                      <option value=""> Select Driver </option>';
        if ($get_drivers) {
            foreach ( $get_drivers as $drive ) {
                $driver .= '<option value="' . $drive['id'] . '">' . $drive['name'] .'</option>';
            }
        }
        $driver .='</select>';
        $result['drivers'] = $driver ?? "";
        echo json_encode( $result );
    }
}
