<?php

/**
 * Class Cronjob
 * @property Header header
 * @property Cronjob_runner cronjob_runner
 * @property CI_Loader load
 */
class Cronjob extends CI_Controller
{
    /** @var string  */
    private const HEADER_TOKEN_NAME = 'lambda-token';

    private const HEADER_TOKEN_VALUE = 'uNHrvdaSV1';

    public function __construct()
    {
        parent::__construct();
        $this->load->library('infrastructure/Header');
        $this->load->library('infrastructure/Cronjob_runner');
    }

    public function _remap(string $method, array $params): void
    {
        if (!$this->header->requestHasHeaderValue(static::HEADER_TOKEN_NAME, static::HEADER_TOKEN_VALUE)) {
            show_404();
            return;
        }

        $now = time();
        $this->cronjob_runner->runCronjob($method, implode('/', $params));
        $spent = time() - $now;
        error_log("Time spent on job " . $method . ": " . $spent);
    }
}
