<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use App\Authorization\Authorization;
use App\Models\OrderList\Search\Properties;

class CustomerOrders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('CodeIgniterAuthorization');
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->customerRowId = $this->session->userdata('cust_id');
        $this->userId = $this->session->userdata('user_id');
        $this->userRoleId = $this->session->userdata('user_role_id');
        $this->timeZone = $this->session->userdata("usr_tzone")['timezone'];
        if (!in_array($this->userRoleId, ['4', '6'])) {
            redirect('home');
        }
        $this->customerCode = $this->session->userdata('customer_code');
        if (checkAccessConditions('RELATED_TO_GLEN_CUSTOMER', $this->customerCode)) {
            redirect('NZGENorders');
        }
        if (checkAccessConditions('RELATED_2_NZPG', $this->companyCode)) {
            redirect('KNGENQikBkg');
        }
        $this->load->model(['common', 'Order', 'smtcorder', 'svkCustomer/CustomerOrder']);
        $this->load->library(['Ratemanagement', 'Customerordershandler', 'PhpMailerLibrary','altovaordercreation']);
    }

    public function index(string $id = '')
    {
        if ($id != "") {
            $this->orderList($id);
        } else {
            $this->orderList();
        }
    }

    public function orderList(string $id = ''): void
    {
        $data = [];
        $data['page_title'] = $this->lang->line('order_list');
        $data['sub_title'] = $this->lang->line('menu_orders');
        $data['list_type'] = "";
        $data['order'] = $this->CustomerOrder->orderList($id);
        $data['e_booking_count'] = $this->CustomerOrder->getCustomerebookingStatus($this->customerRowId);
        $data['finance_count'] = $this->CustomerOrder->getCustomerfinanceStatus($this->customerRowId);
        $data['show_map'] = $this->CustomerOrder->getCustomermapStatus($this->customerRowId);
        //log_message("error","5555:");
        $data['show_carrier'] = $this->CustomerOrder->getCustomercarrierStatus($this->customerRowId);
        $data['customerRowId'] = $this->customerRowId;
        $data['companyCode'] = $this->companyCode;
        $data['userRoleId'] = $this->userRoleId;
        $data['sessionCurrency'] = $this->session->userdata("usr_tzone")['currency'];
        $data['cust_id'] = $this->session->userdata('cust_id');
        $this->newtemplate->dashboard("svkCustomer/customerOrders", $data);
    }

    public function ajaxListing(): void
    {
        $switch_type = $this->input->get('toggleswitch');
        $ajaxData = $this->CustomerOrder->ajaxListing();
        $cust_id = $this->session->userdata('cust_id');
        $ajaxData['e_booking_count'] = $this->CustomerOrder->getCustomerebookingStatus($cust_id);
        $ajaxData['co2_emission'] = $this->CustomerOrder->getCustomerco2Status($cust_id);
        $ajaxData['cust_id'] = $cust_id;
        $customerCode = $this->session->userdata('customer_code');
        $ajaxData['enableOrderEdit'] = checkAccessConditions('ENABLE_ORDEREDIT_FOR_CUSTOMER', $customerCode);
        if ($this->session->userdata('company_code') == "PHKN") {
            $ajaxData['enableTwb'] = true;
        } else {
            $ajaxData['enableTwb'] = checkAccessConditions('ENABLE_TWB_FOR_CUSTOMER', $customerCode);
        }
        //log_message("error","switch_type:".$switch_type);
        //log_message("error","Ajax Data:".json_encode($ajaxData));
        if ($switch_type == 'off') {
            $this->load->view('svkCustomer/orderListAjaxView.php', $ajaxData);
        } else {
            $this->load->view('svkCustomer/orderListAjaxgridView.php', $ajaxData);
        }
    }

    public function ajaxListing2(): void
    {
        $ajaxData = $this->CustomerOrder->ajaxListing2();
        echo json_encode($ajaxData);
    }

    public function viewOrder(): void
    {
        /* below comment is required later after testing
        $this->codeigniterauthorization->isAuthorized(
            $this->session->userdata,
            Authorization::ENTITY_TYPE_ORDER,
            $id
        );
        */
        $data = [];
        $post = $this->input->get();
        $data = $this->CustomerOrder->viewOrder($post);       
        if ($post['selected_tab'] == "a_info") {
            $this->load->view('svkCustomer/orderViewTabs/infoTab', $data);
        }
        if ($post['selected_tab'] == "a_finance") {
            $this->load->view('svkCustomer/orderViewTabs/financeTab', $data);
        }
        if ($post['selected_tab'] == "a_status") {
            $this->load->view('svkCustomer/orderViewTabs/statusTab', $data);
        }
        if ($post['selected_tab'] == "a_attachment") {
            $this->load->view('svkCustomer/orderViewTabs/attachmentTab', $data);
        }
        if ($post['selected_tab'] == "a_visualization") {
            $this->load->view('svkCustomer/orderViewTabs/visualizationTab', $data);
        }
    }

    public function getOrderCargoDetails(): void
    {
        $jsonData = $this->CustomerOrder->getOrderCargoDetails();
        echo json_encode($jsonData);
    }

    public function getTripLocation(int $tripId, string $receivedOn): void
    {
        $jsonData = $this->CustomerOrder->getTripLocation($tripId, $receivedOn);
        echo json_encode($jsonData);
    }

    public function orderDocumentDetails(): void
    {
        $data = $this->CustomerOrder->orderDocumentDetails();
        echo $this->load->view("livetrack/managedocuments", $data, true);
    }

    public function newOrder(): void
    {
        $data = $this->CustomerOrder->newOrder();
        $this->newtemplate->dashboard('kncustorders/newOrder', $data);
    }

    public function getOtherReferenceDetails(): void
    {
        $data = $this->CustomerOrder->getOtherReferenceDetails();
        echo json_encode($data);
    }

    public function orddocsdetails() {
        $status   = array();
        $order_id = $this->input->post( 'order_id' );
        if ( $order_id != "" ) {
            $curtz = $this->session->userdata( "usr_tzone" )['timezone'];
            $sql1  = $this->db->query( "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,dt.type_name,ts.createdby,convertToClientTZ(ts.createdon,'" . $curtz . "') as createdon,ts.imgpath,ts.user_id  from tb_pod_uploads ts LEFT JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE ts.order_id = $order_id AND ts.status='1' GROUP BY ts.id" );
            //("error","test:".$this->db->last_query());
            if ($sql1->num_rows() > 0 ) {
                foreach ( $sql1->result() as $res ) {
                    if($res->latitude!="" && $res->longitude!="" ){
                        $location_name = getLocationName($res->latitude, $res->longitude);
                    }else{
                        $location_name='';
                    }


                    if($location_name==''){
                        $where = array("id"=>$order_id);
                        $getlocationorder=$this->db->select("order_id")->get_where("tb_orders",$where,1,0);
                        if($getlocationorder->num_rows()>0){
                            $getorderrid=$getlocationorder->row()->order_id;
                            $where = array("order_id"=>$getorderrid);
                            $getlocation=$this->db->select(" `pickup`,`drop`")->get_where("tb_employee",$where,1,0);
                            if($getlocation->num_rows()>0){
                                if($res->stop_type=='P'){
                                    $location_name = $getlocation->row()->pickup;
                                }
                                if($res->stop_type=='D'){
                                    $location_name = $getlocation->row()->drop;
                                }
                            }

                        }
                    }

                    $imgpath       = "";
                    $allowed       = array( 'pdf' );
                    if ( $res->imgpath != "" ) {
                        $base64DocumentData = getBase64DocumentData($res->imgpath);
                        $extention = $base64DocumentData['extention'];
                        $stringData = "'".$base64DocumentData['file_content']."',"."'".$extention."'";
                        if ($extention!= "") {
                            if (in_array($extention, $allowed)) {
                                $path = '<a onclick="return downloadDocument(' . $stringData . ')"> <img src="' . base_url('assets/img/docstore.png') . '" class="img-responsive" style="width: 30%;" type="application/pdf"></a>';
                            } else {
                                $path = '<a onclick="return downloadDocument(' . $stringData . ')"><img src="' . $base64DocumentData['file_content'] . '" class="img-responsive" style="width: 30%;"></a>';
                            }
                        }
                        $driver   = getDrivernameById( $res->createdby )["name"];
                        if($driver==""){
                            if($res->user_id!=0){
                                $where = array("id"=>$res->user_id);
                                $getuser=$this->db->select("name")->get_where("tb_users",$where,1,0);
                                if($getuser->num_rows()>0){
                                    $driver = $getuser->row()->name;

                                }
                            } else {
                                $where = array("id" => $this->session->userdata("user_id"));
                                $getuser = $this->db->select("name")->get_where("tb_users", $where, 1, 0);
                                if ($getuser->num_rows() > 0) {
                                    $driver = $getuser->row()->name;
                                }
                            }
                        }
                        $action = "";
                        $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft '> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowdocAdd(this," . $order_id . ")'><span class='glyphicon glyphicon-plus' > </span>Add Doc</a></li></li></ul>";
                        $status[] = array(
                            'id' => $res->id,
                            'type_name' => $res->type_name,
                            'imgpath' => $path ?? 'N/A',
                            'stop_id' => $res->stop_id,
                            'stop_type' => $res->stop_type,
                            'date' => date("d M,y h:i A", strtotime($res->createdon)),
                            'action' => $action,
                            'location' => $location_name,
                            'driver' => $driver
                        );
                    }

                }
            }
        }
        //log_message("error","status:".json_encode( $status['stop_type'] ));
        echo json_encode( $status );
    }

    public function getorderrevenueparties()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $order_id  = isset($post['order_id']) ? $post['order_id'] : "";
        $rev_ids = isset($post['rev_ids']) ? $post['rev_ids'] : "";
        $type      = $this->input->post('type');
        $revenues  = array();
        if($order_id != "" && $order_id != '0'){
            $revenue = $this->common->gettbldata(array('order_id' => $order_id, 'status' => 1, 'type' => '0'),'*','tb_reveneus',0,0);
        }else{
            if(!empty($rev_ids)){
                $getreveneus = $this->db->query("SELECT * FROM tb_reveneus WHERE id IN (".implode(',',$rev_ids).") ");
                if($getreveneus->num_rows()>0){
                    $revenue = $getreveneus->result_array();
                }
            }
        }
        if (!empty($revenue)) {
            foreach ($revenue as $res) {
                $invoice_status = $res['invoice_status'];
                $bill_id = $res['bill_id'];
                $bill_status = 0;
                if($bill_id >0){
                    $get_bill_status = $this->db->select("status")->get_where("tbl_bills",array('id'=>$bill_id));
                    if($get_bill_status->num_rows()>0){
                        $bill_status = $get_bill_status->row()->status;
                    }
                }
                $action_buttons =  $filetranfer_button = "";
                if($res['recipient_role'] == "Internal BU" && $res['invoice_status'] == '1'){
                    $filetranfer_button = "<li><a id='bElim' type='button' class=' btn btn-sm btn-default'  onclick='sendfiletoacon(" . $res['id'] . ",0)'><span class='glyphicon glyphicon-pencil' > </span>Send File to ACON</a></li>";
                }
                if($bill_status == 1 || $bill_status == 0){
                    if($res['recipient_role'] == "Internal BU" && $res['invoice_status'] >1 ){
                    }else{
                        $action_buttons = "<li><a id='bEdit'  type='button' class=' btn btn-sm btn-default'  onclick='rowEditrevenue(this," . $res['id'] . ")'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim'  type='button' class=' btn btn-sm btn-default' onclick='deleteorderevenue(" . $res['id'] . ")'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAcep' type='button' class='btn btn-sm btn-default' style='display:none;' onclick='rowAcep(this);'><span class='glyphicon glyphicon-ok' > </span>Update</a></li>" . $filetranfer_button;
                    }
                }
                $action = "<ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'> <a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='innerpacking' type='button' class='btn btn-sm btn-default'  title='Add charges' onclick='getchargesbyrevenue(this," . $res['id'] . ")''><span class='fa fa-archive' > </span> Get charges</a></li></ul></li></ul>";
                $inv_status = "";
                if($bill_status > 0){
                    if ($bill_status == '1') {
                        $inv_status = "Ready for Invocie";
                    }else{
                        $inv_status = "Billed";
                    }
                }else{
                    if ($res['invoice_status'] == '1' || $res['invoice_status'] == '2') {
                        $inv_status = "Ready for Invocie";
                    }else{
                        $inv_status = "";
                    }
                }
                $invoice_creation_date = $res['invoice_creation_date'];
                if ($invoice_creation_date != "0000-00-00 00:00:00" && $invoice_creation_date != "") {
                    $invoice_creation_date = $invoice_creation_date;
                } else {
                    $invoice_creation_date = "";
                }
                $invoice_receivdon_date = $res['invoice_receivdon_date'];
                if ($invoice_receivdon_date != "0000-00-00 00:00:00" && $invoice_receivdon_date != "") {
                    $invoice_receivdon_date = $invoice_receivdon_date;
                } else {
                    $invoice_receivdon_date = "";
                }
                $invoice_date = $res['invoice_date'];
                if ($invoice_date != "0000-00-00 00:00:00" && $invoice_date != "") {
                    $invoice_date = $invoice_date;
                } else {
                    $invoice_date = "";
                }
                if($res['bu_jfr'] == 0){
                    $res['bu_jfr'] = '';
                }
                $revenues[] = array('id' => $res['id'], 'order_id' => $res['order_id'], 'recipient_role' => $res['recipient_role'], 'recipient_code' => $res['recipient_code'], 'recipient_name' => $res['recipient_name'], 'debtor_jfr' => $res['debtor_jfr'], 'amount' => $res['amount'], 'currency' => $res['currency'], 'foreign_currency' => $res['foreign_currency'], 'exchange_rate' => $res['exchange_rate'], 'invoice_number' => $res['invoice_number'], 'credit_note_number' => $res['credit_note_number'], 'invoice_date' => $invoice_date, 'invoice_creation_date' => $invoice_creation_date, 'invoice_receivdon_date' => $invoice_receivdon_date, 'invoice_status' => $inv_status, 'action' => $action, 'accural_amount' => $res['accrual_amount'], 'actual_amount' => $res['actual_amount'], 'foreign_accuralamount' => $res['accrual_foreign_amount'],'bu_jfr'=>$res['bu_jfr']);
            }
        }
        echo json_encode($revenues);
    }

    public function getchargesforrevenue()
    {
        $post = array();
        $post = $this->input->post(NULL,TRUE);
        $revenue_id = isset($post['revenue_id']) ? $post['revenue_id'] : "";
        $charges    = array();
        if ($revenue_id != "") {
            $inv_status = $bill_id = $type =0;
            $bill_status = 1;
            $foreign_currency = $recipient_role = "";
            $getcharges =  $this->Order->getchargesforrevenuemodel($revenue_id);
            $get_invstatus = $this->db->select("type,recipient_role,foreign_currency,invoice_status,bill_id")->get_where("tb_reveneus",array('id'=>$revenue_id));
            if($get_invstatus->num_rows()>0){
                $inv_status = $get_invstatus->row()->invoice_status;
                $recipient_role = $get_invstatus->row()->recipient_role;
                $foreign_currency = $get_invstatus->row()->foreign_currency;
                $bill_id = $get_invstatus->row()->bill_id;
                $type = $get_invstatus->row()->type;
            }
            if($bill_id >0){
                $get_bill_status = $this->db->select("status")->get_where("tbl_bills",array('id'=>$bill_id));
                if($get_bill_status->num_rows()>0){
                    $bill_status = $get_bill_status->row()->status;
                }
            }
            if ($getcharges->num_rows() > 0) {
                foreach ($getcharges->result() as $res) {
                    $action    = "";
                    $vat_desc  = "";
                    $cat_id = $res->cat_id;
                    $source_created = $res->source_created;
                    if($cat_id >0){
                        $getvatdesc = $this->common->gettblrowdata(array('id'=>$cat_id,'status'=>'1'),"description","tb_vat_category",0,0);
                        if(!empty($getvatdesc)){
                            $vat_desc= $getvatdesc['description'];
                        }
                    }else{
                        $cat_id = 0;
                    }
                    $local_vat_amount = $local_total_amount = "";
                    if(is_numeric($res->local_vat_amount)){
                        $local_vat_amount = $res->local_vat_amount;
                    }
                    if(is_numeric($res->local_total_amount)){
                        $local_total_amount = $res->local_total_amount;
                    }
                    $charges[] = array('revenue_id' => $res->revenue_id, 'charge_id' => $res->id, 'charge_code' => $res->chargecode, 'description' => $res->description, 'quantity_unit' => $res->quantity_unit, 'value' => $res->value, 'rate_id' => $res->rate_id, 'amount' => $res->amount, 'currency' => $res->currency, 'local_amount' => $res->local_amount, 'local_currency' => $res->local_currency, 'action' => $action, 'chargecode_id' => $res->charge_code,'inv_status'=>$inv_status,'recipient_role'=>$recipient_role,'foreign_currency'=>$foreign_currency,'vat_percentage' => $res->vat_percentage,'vat_amount' => $res->vat_amount,'total_amount' => $res->total_amount,'cat_id'=>$cat_id,'cat_val'=>$res->cat_val,'bill_status'=>$bill_status,'vat_desc'=>$vat_desc,'type'=>$type, 'source_created'=>$source_created,'local_vat_amount'=>$local_vat_amount,'local_total_amount'=>$local_total_amount);
                }
            }
        }
        echo json_encode($charges);
    }

    public function getPartyTypesListFromCustomerLogin(): void
    {
        $post = $this->input->post(null, true);
        $allCustomerIds = $customerCodes = [];
        if ($this->session->userdata('sub_cust') !== false) {
            if ($this->session->userdata('sub_cust') != "") {
                $allCustomerIds = $this->session->userdata('sub_cust');
            }
        }
        array_push($allCustomerIds, $this->customerRowId);
        $getCustomerCodes = $this->common->gettbldata(" id IN ( '" . implode("','", $allCustomerIds) . "' ) ", "code", "tb_customers", 0, 0);
        foreach ($getCustomerCodes as $eachCode) {
            $customerCodes[] = $eachCode['code'];
        }
        $data = $this->CustomerOrder->getPartyTypesByGivenPostData($customerCodes, $post, $this->companyCode);
        echo json_encode($data);
    }

    public function getDistanceBetweenLocations(): void
    {
        $post = $this->input->post(null, true);
        $fromLatitude = $post['fromLatitude'];
        $fromLongitude = $post['fromLongitude'];
        $toLatitude = $post['toLatitude'];
        $toLongitude = $post['toLongitude'];
        if (in_array("", [$fromLatitude, $fromLongitude])) {
            $address = implode(",", [$post['fromStreet'], $post['fromCity'], $post['fromCountry'], $post['fromPostalCode']]);
            $location = getlatlngsbyplace($address);
            $fromLatitude = @$location[0];
            $fromLongitude = @$location[1];
        }
        if (in_array("", [$toLatitude, $toLongitude])) {
            $address = implode(",", [$post['toStreet'], $post['toCity'], $post['toCountry'], $post['toPostalCode']]);
            $location = getlatlngsbyplace($address);
            $toLatitude = @$location[0];
            $toLongitude = @$location[1];
        }
        $response = distanceship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
        if ($response['distance'] == "") {
            $response = distancemetrixship($fromLatitude, $fromLongitude, $toLatitude, $toLongitude);
        }
        echo json_encode(['distance' => $response['disttext'] ?? "", 'fromLatitude' => $fromLatitude ?? "", 'fromLongitude' => $fromLongitude ?? "", 'toLatitude' => $toLatitude ?? "", 'toLongitude' => $toLongitude ?? ""]);
    }

    public function saveQuickbookCargoDetails(): void
    {
        $post = $this->input->post(null, true);
        $itemId = $post['itemId'] ?? 0;
        $orderRowId = $post['cargoOrderRowId'] ?? 0;
        $rowId = $post['cargoRowId'] ?? 0;
        $cargoType = $post['cargoType'] ?? "";
        $packageType = $post['packageType'] ?? "";
        $quantity = $post['quantity'] ?? "";
        $weight = $post['weight'] ?? "";
        $length = $post['length'] ?? "0";
        $width = $post['width'] ?? "0";
        $height = $post['height'] ?? "0";
        $volume = $post['volume'] ?? "";
        $cargoStackable = $post['cargoStackable'] ?? 0;
        $cargoDg = $post['cargoDg'] ?? 0;
        $cargoGrounded = $post['cargoGrounded'] ?? 0;
        $cargoSplittable = $post['cargoSplittable'] ?? 0;
        $orderDgGoodsRow = $post['orderDgGoodsRow'] ?? 0;
        $goodsDescription = $post['goodsDescription'] ?? "";
        if ($itemId > 0) {
            $cargosArray = [
                'cargo_type' => $cargoType,
                'handling_unit' => $packageType,
                'length' => $length,
                'length_unit' => 'Cm',
                'width' => $width,
                'width_unit' => 'Cm',
                'height' => $height,
                'height_unit' => 'Cm',
                'weight' => $weight,
                'weight_unit' => 'Kg',
                'volume' => $volume,
                'volume_unit' => 'cbm',
                'second_volume' => $volume,
                'secondvolume_uom' => 'cbm',
                'second_weight' => $weight,
                'secondweight_uom' => 'Kg',
                'quantity' => $quantity,
                'status' => '1',
                'item_id' => $itemId,
                'stackable' => $cargoStackable,
                'grounded' => $cargoGrounded,
                'splittable' => $cargoSplittable,
                'dg_goods' => $cargoDg,
                'goods_description' => $goodsDescription
            ];
            if ($rowId > 0) {
                $this->common->updatetbledata("tb_cargo_details", $cargosArray, ['id' => $rowId]);
            } else {
                $checkExistingQuery = $this->common->gettblrowdata($cargosArray, "id", "tb_cargo_details", 0, 0);
                $rowId = $checkExistingQuery['id'] ?? 0;
                if (empty($checkExistingQuery)) {
                    $cargosArray['createdon'] = date('Y-m-d H:i:s');
                    $cargosArray['createdby'] = $this->userId;
                    $rowId = $this->common->insertTableData("tb_cargo_details", $cargosArray);
                }
            }
            if (!in_array('0', [$orderDgGoodsRow, $cargoDg]) && $orderRowId == 0) {
                $this->common->updatetbledata("tb_order_dg_goods", ['order_cargo_id' => $rowId], ['id' => $orderDgGoodsRow]);
            }
            if ($orderRowId > 0) {
                if ($orderDgGoodsRow > 0) {
                    $dgRowIds[] = $orderDgGoodsRow;
                }
                $checkExistingCargo = $this->common->gettblrowdata(['order_id' => $orderRowId, 'cargo_id' => $rowId], "id", "tb_order_cargodetails", 0, 0);
                if (empty($checkExistingCargo)) {
                    $this->addCargosForCreatedOrder(['orderRowId' => $orderRowId, 'bookingId' => "", 'cargoRowIds' => [$rowId], 'shipmentRowId' => 0, 'dgRowIds' => $dgRowIds ?? [], 'updateCargo' => '1']);
                } else {
                    $this->common->updatetbledata(
                        "tb_order_cargodetails",
                        [
                            'length' => $length,
                            'width' => $width,
                            'height' => $height,
                            'weight' => $weight,
                            'second_weight' => $weight,
                            'volume' => $volume,
                            'second_volume' => $volume,
                            'quantity' => $quantity,
                            'quantity_type' => $cargoType,
                            'cargo_content' => $goodsDescription
                        ],
                        ['id' => $checkExistingCargo['id']]
                    );
                }
                $totalCargos = $this->common->gettblrowdata(['order_id' => $orderRowId, 'status' => '1'], "sum(weight) as totalWeight,sum(volume) as totalVolume,sum(quantity) as totalQuantity", "tb_order_cargodetails", 0, 0);
                if (!empty($totalCargos)) {
                    $this->common->updatetbledata("tb_orders", ['volume' => $totalCargos['totalVolume'], 'weight' => $totalCargos['totalWeight'], 'quantity' => $totalCargos['totalQuantity']], ['id' => $orderRowId]);
                }
            }
        }
        echo json_encode(['rowId' => $rowId ?? 0, 'dgRowId' => $orderDgGoodsRow]);
    }

    public function saveUploadedDocuments(): void
    {
        $post = $this->input->post(null, true);
        $documentType = $post['documentType'] ?? 0;
        $documentOrderRowId = $post['documentOrderRowId'] ?? 0;
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        if (isset($_FILES)) {
            if (isset($_FILES['fileName']['name'])) {
                if ($_FILES['fileName']['name'] === "") {
                    echo json_encode(['status' => 2]);
                    return;
                }
                $config = [
                    'upload_path' => NEW_POD_PATH,
                    'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG'
                ];
                $fileName = $_FILES['fileName']['name'];
                $fileName = str_replace(" ", "", $fileName);
                $files = explode('.', $_FILES['fileName']['name'] ?? '');
                $fileExtension = @strtolower(end($files));
                $extensions = ["jpeg", "jpg", "png", "gif", "pdf"];
                if (in_array($fileExtension, $extensions)) {
                    if ($fileExtension == "pdf") {
                        $this->load->library('InspectPdfLibrary');
                        if (!($this->inspectpdflibrary->validatepdf($_FILES['fileName']['tmp_name']))) {
                            echo '3';
                            return;
                        }
                    }
                    $config['file_name'] = "RL" . date('dmyhis') . ".pdf";
                    if ($fileExtension == "pdf") {
                        $this->load->library('upload', $config);
                        if ($this->upload->do_upload('fileName')) {
                            $imgname = $this->upload->data();
                            $imgtype = $imgname['image_type'];
                            $fileName = $imgname['file_name'];
                            $filePath = NEW_POD_PATH . $fileName;
                            $imgSizes = filesize($_FILES['fileName']['tmp_name']);
                        }
                    } else {
                        $fileName = date('dmyhis') . '' . $fileName;
                        $filePath = NEW_POD_PATH . $fileName;
                        $imgsize = getimagesize($_FILES['fileName']['tmp_name']);
                        $imgSizes = filesize($_FILES['fileName']['tmp_name']);
                        if ($imgsize == false) {
                        } else {
                            $quality = 100;
                            if ($fileExtension == "png") {
                                $top = @imagecreatefrompng($_FILES['fileName']['tmp_name']);
                            } else {
                                $top = @imagecreatefromjpeg($_FILES['fileName']['tmp_name']);
                            }
                            if ($top) {
                                header('Content-Type: image/jpeg');
                                @imagejpeg($top, $filePath, $quality);
                                @imagedestroy($top);
                            } else {
                                $fileName = "";
                            }
                        }
                    }
                    if ($fileName != "" && $documentType > 0) {
                        $this->load->library('uuid');
                        $newUuid = $this->uuid->v4();
                        $uploadedDocumentRowId = $this->common->insertTableData("tb_pod_uploads", ['stop_id' => $post['stopId'] ?? 0, 'shipment_id' => $post['shiftRowId'] ?? 0, 'trip_id' => $post['tripRowId'] ?? 0, 'doc_type' => $documentType, 'imgpath' => $fileName, 'stop_type' => 'P', 'order_id' => $documentOrderRowId, 'status' => '1', 'user_id' => $this->userId, 'createdon' => $insertDate, 'filesize' => $imgSizes ?? "", 'hash' => $newUuid]);
                        $base64DocumentData = getBase64DocumentData($fileName);
                        $stringData = "'" . $base64DocumentData['file_content'] . "'," . "'" . $base64DocumentData['extention'] . "'";
                        $path = '<p style="cursor:pointer;" onclick="return downloadDocument(' . $stringData . ')"> ' . $fileName . '</p>';
                    }
                    $status = 1;
                } else {
                    $status = 0;
                }
            }
        }
        echo json_encode(['status' => $status ?? 0, 'uploadedDocumentRowId' => $uploadedDocumentRowId ?? 0, 'documentType' => $documentType, 'hash' => $newUuid ?? "", 'date' => date('d-m-Y', strtotime($insertDate)), 'fileName' => $path ?? ""]);
    }

    public function deletePodUploadedDocumentById(): void
    {
        $post = $this->input->post(null, true);
        $rowId = $post['podUploadRowId'] ?? 0;
        if ($rowId > 0) {
            $this->common->updatetbledata("tb_pod_uploads", ['status' => '0'], ['id' => $rowId]);
            echo "1";
        } else {
            echo "0";
        }
    }

    public function deleteCargoDetailsById(): void
    {
        $post = $this->input->post(null, true);
        $rowId = $post['cargoRowId'] ?? 0;
        $orderRowId = $post['orderRowId'] ?? 0;
        if ($rowId > 0) {
            $this->common->updatetbledata("tb_cargo_details", ['status' => '0'], ['id' => $rowId]);
            if ($orderRowId > 0) {
                $this->common->updatetbledata("tb_order_cargodetails", ['status' => '0'], ['order_id' => $orderRowId, 'cargo_id' => $rowId]);
            }
            echo "1";
        } else {
            echo "0";
        }
    }

    public function saveQuickbook(): void
    {
        //log_message("error","SaveQuickBook:");
        $post = $this->input->post(null, true);
        
        $orderRowId = $post['orderRowId'] ?? 0;
        if ($orderRowId > 0) {
            $this->updateOrderData($post);
            $bookingId = $post['bookingId'] ?? "";
            if ($bookingId !== "") {
                redirect('svkCustomer/CustomerOrders?bookingid=' . $bookingId);
            }
            redirect('svkCustomer/CustomerOrders');
        }
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        $shipmentId = $post['dqNumber'] ?: "KN" . time();
        $service = $post['service'] ?: "19";
        $modeOfTransport = $post['modeOfTransport'] ?: "LTL";
        $orderType = $post['orderType'] ?: "";
        $shipperCode = $post['shipperCode'] ?? "";
        $shipperRowId = $post['shipperRowId'] ?? 0;
        $shipperName = $post['shipperName'] ?? "";
        $shipperCountry = $post['shipperCountry'] ?? "";
        $shipperSuburb = $post['shipperSuburb'] ?? "";
        $shipperStreet = $post['shipperStreet'] ?? "";
        $shipperCity = $post['shipperCity'] ?? "";
        $shipperLatitude = $post['shipperLatitude'] ?? "";
        $shipperLongitude = $post['shipperLongitude'] ?? "";
        $shipperPostalCode = $post['shipperPostalCode'] ?? "";

        $consigneeRowId = $post['consigneeRowId'] ?? 0;
        $consigneeCode = $post['consigneeCode'] ?? "";
        $consigneeName = $post['consigneeName'] ?? "";
        $consigneeCountry = $post['consigneeCountry'] ?? "";
        $consigneeSuburb = $post['consigneeSuburb'] ?? "";
        $consigneeStreet = $post['consigneeStreet'] ?? "";
        $consigneeCity = $post['consigneeCity'] ?? "";
        $consigneeLatitude = $post['consigneeLatitude'] ?? "";
        $consigneeLongitude = $post['consigneeLongitude'] ?? "";
        $consigneePostalCode = $post['consigneePostalCode'] ?? "";
        $customerProfileId = $post['rateCustomerProfileId'] ?? 0;
        $rateServiceRowId = $post['rateServiceRowId'] ?? 0;
        $rateOfferingRowId = $post['rateOfferingRowId'] ?? 0;
        $rateRecordRowId = $post['rateRecordRowId'] ?? 0;
        $laneRowId = $post['rateLaneRowId'] ?? 0;
        
        $estimatedEarlyPickupDate = $post['estimatedPickupDate'] !== "" ? date('Y-m-d H:i:s', strtotime($post['estimatedPickupDate'])) : $insertDate;
        $estimatedLatePickupDate = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($estimatedEarlyPickupDate)));
        $estimatedDeliveryDate = $post['estimatedDeliveryDate'] !== "" ? date('Y-m-d H:i:s', strtotime($post['estimatedDeliveryDate'])) : date('Y-m-d H:i:s', strtotime('+1 day', strtotime($estimatedEarlyPickupDate)));
        $estimatedLateDeliveryDate = date('Y-m-d H:i:s', strtotime('+1 hour', strtotime($estimatedDeliveryDate)));
        $product = "KN AsiaLink";
        if ($modeOfTransport !== 0) {
            $getModeOfTransportName = $this->common->gettblrowdata(['code' => $modeOfTransport, 'status' => '1'], 'id,name', 'tb_transportmode', 0, 0);
            $modeOfTransportName = $getModeOfTransportName['name'] ?? "";
            $modeOfTransportRowId = $getModeOfTransportName['id'] ?? 1;
        }
        $shipmentArray = [
            'shipid' => $shipmentId,
            'txnid' => $shipmentId,
            'trucktype' => $modeOfTransportName ?? "",
            'pickupcnt' => '1',
            'dropcnt' => '1',
            'insertusr' => $shipperCode,
            'carrier' => '0',
            'insertuserdate' => $insertDate,
            'enddate' => $insertDate,
            'insdate' => $insertDate,
            'upddate' => $insertDate,
            'reason' => 'SHIPMENT',
            'purpose' => 'SEND INTEGRATION',
            'ship_object' => 'SHIPMENT',
            'logdate' => $insertDate,
            'transport_mode' => $modeOfTransport,
            'domainname' => $this->branchCode,
            'product' => $product,
            'company_code' => $this->companyCode,
            'branch_code' => $this->branchCode,
            'freight_term' => '60',
            'freight_termname' => 'Free of Charge',
            'modeoftransport' => $modeOfTransportRowId ?? 1,
            'unitspec' => 1
        ];
        $checkShipment = $this->common->gettblrowdata(['shipid' => $shipmentId], 'id', 'tb_shipments', 0, 0);
        if (empty($checkShipment)) {
            $shipmentArray['createdon'] = $insertDate;
            $shipmentRowId = $this->common->insertTableData("tb_shipments", $shipmentArray);
        } else {
            $shipmentRowId = $checkShipment['id'];
            $this->common->updatetbledata("tb_shipments", $shipmentArray, ['id' => $shipmentRowId]);
        }
        
        $getPickup = getdatetimebytimezone(DFLT_TZ, $estimatedEarlyPickupDate, $this->timeZone);
        $earlyPickupDate = $getPickup['datetime'];
        $getLatePickup = getdatetimebytimezone(DFLT_TZ, $estimatedLatePickupDate, $this->timeZone);
        $latePickupDate = $getLatePickup['datetime'];
        $getDelivery = getdatetimebytimezone(DFLT_TZ, $estimatedDeliveryDate, $this->timeZone);
        $earlyDeliveryDate = $getDelivery['datetime'];
        $getLateDelivery = getdatetimebytimezone(DFLT_TZ, $estimatedLateDeliveryDate, $this->timeZone);
        $lateDeliveryDate = $getLateDelivery['datetime'];
        
        $orderinfo = [
            'shipment_id' => $shipmentRowId,
            'customer_id' => $this->customerRowId,
            'product' => $product,
            'company_code' => $this->companyCode,
            'branch_code' => $this->branchCode,
            'createdon' => $insertDate,
            'pickup_datetime' => $earlyPickupDate,
            'delivery_datetime' => $earlyDeliveryDate,
            'pickup_endtime' => $latePickupDate,
            'drop_endtime' => $lateDeliveryDate,
            'drop_custid' => $consigneeCode,
            'drop_partyid' => $consigneeCode,
            'user_id' => $this->userId,
            'sub_uid' => 0,
            'pickup_custid' => $shipperCode,
            'pickup_partyid' => $shipperCode,
            'pickup_country' => $shipperCountry,
            'pickup_city' => $shipperCity,
            'pickup_pincode' => $shipperPostalCode,
            'pickup_company' => $shipperName,
            'pickup_address1' => $shipperStreet,
            'pickup_address2' => $shipperSuburb,
            'delivery_country' => $consigneeCountry,
            'delivery_city' => $consigneeCity,
            'delivery_pincode' => $consigneePostalCode,
            'delivery_company' => $consigneeName,
            'delivery_address1' => $consigneeStreet,
            'delivery_address2' => $consigneeSuburb,
            'transport_mode' => $modeOfTransport,
            'plat' => $shipperLatitude,
            'plng' => $shipperLongitude,
            'dlat' => $consigneeLatitude,
            'dlng' => $consigneeLongitude,
            'is_created' => '1',
            'modeoftransport' => $modeOfTransportRowId ?? 1,
            'created_source' => '20',
        ];
        $orderRowId = $this->common->insertTableData("tb_orders", $orderinfo);
        if ($orderRowId > 0) {
            $getCountryDetails = $this->common->gettblrowdata(['id' => $this->userId], 'country_code,company_code', 'tb_users', 0, 0);
            $countryCode = $getCountryDetails['country_code'] ?? "";
            $bookingInfo = ["user_id" => $this->userId, "order_id" => $orderRowId, "country_code" => $countryCode, "company_code" => $this->companyCode];
            $bookingId = generatebookingid($bookingInfo);
            makeorderinvolvedpartiestype($this->customerRowId, $orderRowId, "CUSTOMER", $this->userId, $this->companyCode);
            $this->common->updatetbledata("tb_orders", ['order_id' => $bookingId], ['id' => $orderRowId]);
            $details = [
                'service' => $service,
                'createdon' => $insertDate,
                'order_row_id' => $orderRowId,
                'order_id' => $bookingId,
                'order_type' => $orderType
            ];
            $this->common->insertTableData('tb_order_details', $details);
            $shipperAddress = $shipperStreet . "," . $shipperCity . "," . $shipperSuburb;
            $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderRowId, 'party_master_id' => $shipperRowId, 'location_id' => $shipperCity, 'street' => $shipperStreet, 'state' => $shipperSuburb, 'address' => $shipperAddress, 'pincode' => $shipperPostalCode, 'country' => $shipperCountry, 'user_id' => $this->userId, 'createdon' => $insertDate]);

            $consigneeAddress = $consigneeStreet . "," . $consigneeCity . "," . $consigneeSuburb;
            $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderRowId, 'party_master_id' => $consigneeRowId, 'location_id' => $consigneeCity, 'street' => $consigneeStreet, 'state' => $consigneeSuburb, 'address' => $consigneeAddress, 'pincode' => $consigneePostalCode, 'country' => $consigneeCountry, 'user_id' => $this->userId, 'createdon' => $insertDate]);
            $this->addCargosForCreatedOrder(['orderRowId' => $orderRowId, 'bookingId' => $bookingId, 'cargoRowIds' => $post['cargoRowIds'] ?? [], 'shipmentRowId' => $shipmentRowId, 'dgRowIds' => $post['dgRowIds'] ?? []]);
            $this->addReferencesForCreatedOrder($orderRowId, $shipmentId, $post);
            $this->addDocumentsForCreatedOrder($orderRowId, $post);
            $this->addAddonsForCreatedOrder($orderRowId, $post);
            $involvedParties = [];
            $involvedParties['0'] = $shipperRowId;
            $involvedParties['1'] = $consigneeRowId;
            if (checkAccessConditions('RELATED_2_SG_MY', $this->companyCode)) {
                $involvedParties['2'] = $shipperRowId;
                $involvedParties['3'] = $consigneeRowId;
            } else {
                $involvedParties['2'] = $involvedParties['3'] = '0';
            }
            if (!empty($involvedParties)) {
                subcustpartiesinsert($orderRowId, $bookingId, $involvedParties);
            }
            if (!in_array(0, [$customerProfileId, $rateServiceRowId, $rateOfferingRowId, $rateRecordRowId, $laneRowId], true)) {
                $getCustomerCode = $this->common->gettblrowdata(['id' => $this->customerRowId], 'code', 'tb_customers', 0, 0);
                $customerCode = $getCustomerCode['code'] ?? "";
                $this->ratemanagement->addratesForOrderFromRateEnquiry(
                    [
                        'customerId' => $customerCode,
                        'orderRowId' => $orderRowId,
                        'customerProfile' => $customerProfileId,
                        'rateServiceRowId' => $rateServiceRowId,
                        'rateOfferingRowId' => $rateOfferingRowId,
                        'rateRecordRowId' => $rateRecordRowId,
                        'currency' => $this->session->userdata("usr_tzone")['currency'],
                        'userId' => $this->userId,
                        'laneRowId' => $laneRowId,
                        'vendorIdFromProfile' => $post['vendorIdFromProfile'] ?? 0,
                        'vendorCodeFromProfile' => $post['vendorCodeFromProfile'] ?? "",
                        'orderCreatedSource' => '19'
                    ]
                );
            }
            $pickupInfo = ['country' => $shipperCountry, 'order_country' => $shipperCountry, 'order_city' => $shipperCity, 'order_zipcode' => $shipperPostalCode, 'state' => $shipperSuburb, 'city' => $shipperCity, 'region' => $shipperStreet, 'zipcode' => $shipperPostalCode, 'stoptype' => 'P'];
            $dropInfo = ['country' => $consigneeCountry, 'order_country' => $consigneeCountry, 'order_city' => $consigneeCity, 'order_zipcode' => $consigneePostalCode, 'state' => $consigneeSuburb, 'city' => $consigneeCity, 'region' => $consigneeStreet, 'zipcode' => $consigneePostalCode, 'stoptype' => 'D'];
            $pickupGeoCode = checkgeocode($pickupInfo);
            $dropGeoCode = checkgeocode($dropInfo);
            $this->checkRoutingAutomation(['pickupInfo' => $pickupInfo, 'pickupGeoCode' => $pickupGeoCode, 'dropInfo' => $dropInfo, 'dropGeoCode' => $dropGeoCode, 'orderRowId' => $orderRowId, 'bookingId' => $bookingId, 'orderInfo' => $orderinfo]);
            $this->sendMailNotification($bookingId, $orderRowId);
            $this->altovaordercreation->sendOrderToAltova($orderRowId);
            $checkTripForOrder = $this->common->gettblrowdata("id='" . $orderRowId . "' AND shift_id >0", "id,shift_id", "tb_orders", 0, 0);
            if (!empty($checkTripForOrder)) {
                $this->load->library('notifytrigger');
                $this->notifytrigger->sendNotificationToCarrier($checkTripForOrder['shift_id'], $this->companyCode, 'CR');
            }
        }
        redirect('svkCustomer/CustomerOrders?bookingid='.$bookingId);
    }

    private function addAddonsForCreatedOrder(int $orderRowId, array $postData): void
    {
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        $vasData = $postData['vasData'] ?? [];
        $insertData = [];
        if (empty($vasData)) {
            return;
        }
        foreach ($vasData as $eachLine) {
            $insertData[] = ['order_id' => $orderRowId, 'vas_id' => $eachLine, 'quantity' => '1.00', 'status' => '1', 'createdon' => $insertDate];
        }
        if (!empty($insertData)) {
            $this->common->insertbulk("tb_order_vas", $insertData);
        }
    }

    private function addDocumentsForCreatedOrder(int $orderRowId, array $postData): void
    {
        $podUploadIds = $postData['podUploadRowIds'] ?? [];
        if (empty($podUploadIds)) {
            return;
        }
        $this->common->updatetbledata_where_in('tb_pod_uploads', ['order_id' => $orderRowId], ['col' => 'id', 'arr' => $podUploadIds], []);
    }

    private function addReferencesForCreatedOrder(int $orderRowId, string $deliveryNote, array $postData): void
    {
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        $references[] = ['order_id' => $orderRowId, 'reference_id' => 'DQ', 'ref_value' => $deliveryNote, 'createdon' => $insertDate];
        $purchaseOrder = $postData['purchaseOrder'] ?? "";
        if ($purchaseOrder !== "") {
            $references[] = ['order_id' => $orderRowId, 'reference_id' => 'PO', 'ref_value' => $purchaseOrder, 'createdon' => $insertDate];
        }
        $pickupInstructions = $postData['pickupInstructions'] ?? "";
        if ($pickupInstructions !== "") {
            $references[] = ['order_id' => $orderRowId, 'reference_id' => 'ORD_PIKINST', 'ref_value' => $pickupInstructions, 'createdon' => $insertDate];
        }
        $deliveryInstructions = $postData['deliveryInstructions'] ?? "";
        if ($deliveryInstructions !== "") {
            $references[] = ['order_id' => $orderRowId, 'reference_id' => 'ORD_DLVINST', 'ref_value' => $deliveryInstructions, 'createdon' => $insertDate];
        }
        $this->common->insertbulk("tb_order_references", $references);
    }

    private function addCargosForCreatedOrder(array $data): void
    {
        $cargosArray = $data['cargoRowIds'] ?? [];
        $dgRowIds = $data['dgRowIds'] ?? [];
        $updateCargo = $data['updateCargo'] ?? 0;
        if (empty($cargosArray) && $updateCargo === 0) {
            return;
        }
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        $getCargoDetails = $this->common->gettbldata(" id IN (" . implode(',', $cargosArray) . ") AND status ='1'", "id,cargo_type,goods_description,length,width,height,weight,second_weight,volume,second_volume,quantity", "tb_cargo_details", 0, 0);
        $cargoDetails = $quantityType = [];
        $totalQuantity = $totalVolume = $totalWeight = 0;
        foreach ($getCargoDetails as $eachLine) {
            $totalQuantity += $eachLine['quantity'];
            $totalVolume += $eachLine['volume'];
            $totalWeight += $eachLine['weight'];
            $quantityType[] = $eachLine['cargo_type'];
            $cargoDetails[] = [
                'order_id' => $data['orderRowId'],
                'cargo_id' => $eachLine['id'],
                'length' => $eachLine['length'],
                'width' => $eachLine['width'],
                'height' => $eachLine['height'],
                'weight' => $eachLine['weight'],
                'second_weight' => $eachLine['second_weight'],
                'volume' => $eachLine['volume'],
                'second_volume' => $eachLine['second_volume'],
                'quantity' => $eachLine['quantity'],
                'quantity_type' => $eachLine['cargo_type'],
                'cargo_content' => $eachLine['goods_description'],
                'status' => '1',
                'createdon' => $insertDate
            ];
        }
        if (!empty($cargoDetails)) {
            $this->common->insertbulk("tb_order_cargodetails", $cargoDetails);
            if (!empty($quantityType)) {
                $unitSpec = implode(',', $quantityType);
            }
            if (!empty($dgRowIds)) {
                $dgGoodsQuery = $this->common->gettbldata(" id IN (" . implode(',', $dgRowIds) . ") AND order_cargo_id != '0' AND status ='1'", "id,order_cargo_id", "tb_order_dg_goods", 0, 0);
                foreach ($dgGoodsQuery as $eachLine) {
                    $dgRowId = $eachLine['id'];
                    $cargoRowId = $eachLine['order_cargo_id'];
                    $getOrderCargoRowId = $this->common->gettblrowdata(['order_id' => $data['orderRowId'], 'cargo_id' => $cargoRowId, 'status' => '1'], "id", "tb_order_cargodetails", 0, 0);
                    $orderCargoRowId = $getOrderCargoRowId['id'] ?? 0;
                    if ($orderCargoRowId > 0) {
                        $this->common->updatetbledata("tb_order_dg_goods", ['order_id' => $data['orderRowId'], 'order_cargo_id' => $orderCargoRowId], ['id' => $dgRowId]);
                    }
                }
            }
            if ($data['shipmentRowId'] === 0) {
                return;
            }
            $this->common->updatetbledata("tb_shipments", ['txncode' => $data['bookingId'], 'unitspec' => $unitSpec ?? ""], ['id' => $data['shipmentRowId']]);
            $this->common->updatetbledata("tb_orders", ['volume' => $totalVolume, 'weight' => $totalWeight, 'quantity' => $totalQuantity], ['id' => $data['orderRowId']]);
        }
    }

    public function displayQuickBookForCustomer(): void
    {
        if ($this->userRoleId === '4') {
            $data['quickbookData'] = $this->getQuickBookChangesForCustomer();
        }
        echo $this->load->view('svkCustomer/svkCustomerQuickbook', $data ?? [], true);
    }

    private function getQuickBookChangesForCustomer(int $orderRowId = 0): array
    {
        $quickbookSwitches = $this->CustomerOrder->enableTabsBySwitches(['customerRowId' => $this->customerRowId, 'companyCode' => $this->companyCode]);
        $allCustomerIds = $countryMaster = [];
        if ($this->session->userdata('sub_cust') !== false) {
            if ($this->session->userdata('sub_cust') != "") {
                $allCustomerIds = $this->session->userdata('sub_cust');
            }
        }
        array_push($allCustomerIds, $this->customerRowId);
        if (!empty($allCustomerIds)) {
            $getItemMastersData = $this->common->getjointbldata("tb_items it", "customer_items_master cit", "it.id=cit.item_id", "it.status ='1' AND cit.customer_id IN (" . implode(',', $allCustomerIds) . ") AND cit.status ='1'", "it.id as item_row_id,it.item_id,it.item_name,cit.id as master_id,cit.item_id as master_item_id,cit.description as master_description", 0, 0);
            foreach ($getItemMastersData as $eachLine) {
                $cargosData[$eachLine['item_row_id']] = [
                    'itemRowId' => $eachLine['item_row_id'],
                    'itemId' => $eachLine['item_id'],
                    'itemName' => $eachLine['item_name'],
                    'itemMasterRowId' => $eachLine['master_id'],
                    'itemMasterITemId' => $eachLine['master_item_id'],
                    'itemDescription' => $eachLine['master_description']
                ];
            }
            $getOrderTypes = $this->common->gettbldata("customer_id IN (" . implode(',', $allCustomerIds) . ") AND status ='1'", "id,type_name", "tb_order_types", 0, 0);
            foreach ($getOrderTypes as $eachLine) {
                $orderTypes[] = ['type_id' => $eachLine['id'], 'type_name' => $eachLine['type_name']];
            }
            $masterData = getAllCustomersMasterDataForQuickbook($allCustomerIds);
        }
        if ($orderRowId > 0) {
            $checkTrip = $this->common->gettblrowdata(['id' => $orderRowId, 'shift_id > ' => 0], "id,order_id", "tb_orders", 0, 0);
            if (!empty($checkTrip)) {
                $stops = $this->CustomerOrder->getOrderStopsByBookingId($checkTrip['order_id']);
                $getDocumentTypes = $this->common->gettbldata(['status' => '1'], "id,type_name", "tb_document_types", 0, 0);
                foreach ($getDocumentTypes as $eachType) {
                    $documentTypes[] = ['rowId' => $eachType['id'], 'typeName' => $eachType['type_name']];
                }
            }
        } else {
            $getDocumentTypes = $this->common->gettbldata("type_name IN ('Others','DG Declaration') ANd status ='1'", "id,type_name", "tb_document_types", 0, 0);
            foreach ($getDocumentTypes as $eachType) {
                $documentTypes[] = ['rowId' => $eachType['id'], 'typeName' => $eachType['type_name']];
            }
        }
        return ['cargosMasterData' => $cargosData ?? [], 'countryMaster' => $countryMaster ?? [], 'quickbookSwitches' => $quickbookSwitches ?? [], 'documentTypes' => $documentTypes ?? [], 'stops' => $stops ?? [], 'orderTypes' => $orderTypes ?? [], 'vasMasterData' => $masterData['vasData'] ?? [], 'service' => $masterData['service'] ?? [], 'transport' => $masterData['transport'] ?? []];
    }

    public function getPartyTypeFromRowId()
    {
        $post = $this->input->post(null, true);
        $rowId = $post['rowId'] ?? 0;
        $partyType = $post['partyType'] ?? "Shipper";
        $response = [];
        if ($rowId > 0) {
            $getPartyDetails = $this->common->gettblrowdata(['m.id' => $rowId], 'm.id,m.name,m.email,m.mobile,m.code,m.company_code,m.branch_code,m.location_id as city,m.address,m.country,m.state,m.street,m.pincode,m.latitude,m.longitude', "tbl_party_master m", 0, 0);
            if (!empty($getPartyDetails)) {
                $inputField = "<input type='radio' name='partylist' id='partylist_" . $getPartyDetails['id'] . "' class='partylistclass' value='" . $getPartyDetails['id'] . "'>";
                $response[] = [
                    'inputField' => $inputField,
                    'id' => $getPartyDetails['id'],
                    'name' => $getPartyDetails['name'],
                    'email' => $getPartyDetails['email'],
                    'street' => $getPartyDetails['street'],
                    'city' => $getPartyDetails['city'],
                    'state' => $getPartyDetails['state'],
                    'mobile' => $getPartyDetails['mobile'],
                    'address' => $getPartyDetails['address'],
                    'country' => $getPartyDetails['country'],
                    'pincode' => $getPartyDetails['pincode'],
                    'code' => $getPartyDetails['code'],
                    'company_code' => $getPartyDetails['company_code'],
                    'branch_code' => $getPartyDetails['branch_code'],
                    'latitude' => $getPartyDetails['latitude'],
                    'longitude' => $getPartyDetails['longitude'],
                    'role' => $partyType,
                ];
            }
        }
        echo json_encode($response);
    }

    public function saveDangerousGoodsForCargo(): void
    {
        $post = $this->input->post(null, true);
        $dgUnCode = $post['dgUnCode'] ?? "";
        if ($dgUnCode != "") {
            $dgUnCodeClass = $post['dgUnCodeClass'] ?? "";
            $dgRowId = $post['dgRowId'] ?? 0;
            $orderRowId = $post['dgorderRowId'] ?? 0;
            $dgUnCodeName = $post['dgUnCodeName'] ?? "";
            $dgNos = $post['dgNos'] ?? "";
            $dgTunnelCode = $post['dgTunnelCode'] ?? "";
            $dgNoOfPackages = $post['dgNoOfPackages'] ?? "";
            $dgPackageType = $post['dgPackageType'] ?? "";
            $dgGrossWeight = $post['dgGrossWeight'] ?? "";
            $dgNetWeight = $post['dgNetWeight'] ?? "";
            $dgNetExplosiveMass = $post['dgNetExplosiveMass'] ?? "";
            $dgLiters = $post['dgLiters'] ?? "";
            $dgLimitedQuantity = $post['dgLimitedQuantity'] ?? "";
            $dgExpectedQuantity = $post['dgExpectedQuantity'] ?? "";
            $dgFireworks = $post['dgFireworks'] ?? "";
            $dgTechinalName = $post['dgTechinalName'] ?? "";
            $dgEnvironmentally = $post['dgEnvironmentally'] ?? "";
            $dgUnCodePackingGroup = $post['dgUnCodePackingGroup'] ?? "";
            $dgAdrMultiplicator = $post['dgAdrMultiplicator'] ?? "";
            $dgTransportCategory = $post['dgTransportCategory'] ?? "";
            $dgCargo = [
                'order_id' => $orderRowId,
                'num_pkgs' => $dgNoOfPackages,
                'pkg_qty_type' => $dgPackageType,
                'quantity' => $dgNoOfPackages,
                'org_number' => $dgUnCode,
                'org_name' => $dgUnCodeName,
                'quantity_type' => $dgPackageType,
                'db_class' => $dgUnCodeClass,
                'description' => $dgTechinalName,
                'limited_quantity' => $dgLimitedQuantity,
                'excepted_quantity' => $dgExpectedQuantity,
                'status' => '1',
                'createdon' => date('Y-m-d H:i:s'),
                'tunnel_restriction_code' => $dgTunnelCode,
                'environment_hazardous' => $dgEnvironmentally,
                'nos' => $dgNos,
                'packing_group' => $dgUnCodePackingGroup,
                'gross_weight' => $dgGrossWeight,
                'net_weight' => $dgNetWeight,
                'netexplosive_mass' => $dgNetExplosiveMass,
                'liters' => $dgLiters,
                'fire_works' => $dgFireworks,
                'adr_multiplicator' => $dgAdrMultiplicator,
                'transport_category' => $dgTransportCategory,
            ];
            if ($dgRowId > 0) {
                $this->common->updatetbledata("tb_order_dg_goods", $dgCargo, ['id' => $dgRowId]);
            } else {
                $dgRowId = $this->common->insertTableData("tb_order_dg_goods", $dgCargo);
            }
            echo json_encode($dgRowId);
        }
    }

    public function getUnCodeForDangerousGoods(): void
    {
        $data = [];
        $getUnData = $this->common->gettbldata(['status' => 1], 'id,un_code,name,class,packing_group,main_risk,sub_level1,sub_level2,sub_level3,sub_level4,nos,adr_multiplicator,tunnel_code,transport_category,classification_code', 'dg_uncode', 0, 0);
        foreach ($getUnData as $eachLine) {
            $inputField = "<input type='radio' name='uncodeList' data-uncode='" . $eachLine['un_code'] . "' data-name='" . $eachLine['name'] . "' data-class='" . $eachLine['class'] . "' data-packing_group='" . $eachLine['packing_group'] . "' data-tunnel_code='" . $eachLine['tunnel_code'] . "' data-transport_category='" . $eachLine['transport_category'] . "' data-nos='" . $eachLine['nos'] . "' data-adr_multiplicator='" . $eachLine['adr_multiplicator'] . "' id='unCode_" . $eachLine['id'] . "' class='unCodeList' value='" . $eachLine['un_code'] . "' onchange='selectUnCodeData(" . $eachLine['id'] . ")'>";
            $data[] = [
                'inputField' => $inputField,
                'unCode' => $eachLine['un_code'],
                'name' => $eachLine['name'],
                'class' => $eachLine['class'],
                'packingGroup' => $eachLine['packing_group'],
                'mainRisk' => $eachLine['main_risk'],
                'subLevel1' => $eachLine['sub_level1'],
                'subLevel2' => $eachLine['sub_level2'],
                'subLevel3' => $eachLine['sub_level3'],
                'subLevel4' => $eachLine['sub_level4'],
                'classificationCode' => $eachLine['classification_code'],
                'nos' => $eachLine['nos'],
                'tunnelCode' => $eachLine['tunnel_code'],
            ];
        }
        echo json_encode($data);
    }

    public function editOrderInPopup(): void
    {
        $postData = $this->input->post(null, true);
        $orderRowId = $postData['orderRowId'] ?? 0;
        $data = [];
        if ($orderRowId > 0) {
            $data['quickbookData'] = $this->getQuickBookChangesForCustomer($orderRowId);
            $data['orderDetails'] = $this->customerordershandler->getOrderDetailsById($orderRowId);
        }
        echo $this->load->view('svkCustomer/svkCustomerQuickbook', $data, true);
    }

    private function updateOrderData(array $post): void
    {
        $orderRowId = $post['orderRowId'];
        $currentDate = date('Y-m-d H:i:s');
        $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
        $insertDate = $getActualDate['datetime'];
        $shipmentId = $post['dqNumber'] ?: "KN" . time();
        $service = $post['service'] ?: "19";
        $modeOfTransport = $post['modeOfTransport'] ?: "LTL";
        $orderType = $post['orderType'] ?: "";
        $shipperCode = $post['shipperCode'] ?? "";
        $shipperRowId = $post['shipperRowId'] ?? 0;
        $shipperName = $post['shipperName'] ?? "";
        $shipperCountry = $post['shipperCountry'] ?? "";
        $shipperSuburb = $post['shipperSuburb'] ?? "";
        $shipperStreet = $post['shipperStreet'] ?? "";
        $shipperCity = $post['shipperCity'] ?? "";
        $shipperLatitude = $post['shipperLatitude'] ?? "";
        $shipperLongitude = $post['shipperLongitude'] ?? "";
        $shipperPostalCode = $post['shipperPostalCode'] ?? "";

        $consigneeRowId = $post['consigneeRowId'] ?? 0;
        $consigneeCode = $post['consigneeCode'] ?? "";
        $consigneeName = $post['consigneeName'] ?? "";
        $consigneeCountry = $post['consigneeCountry'] ?? "";
        $consigneeSuburb = $post['consigneeSuburb'] ?? "";
        $consigneeStreet = $post['consigneeStreet'] ?? "";
        $consigneeCity = $post['consigneeCity'] ?? "";
        $consigneeLatitude = $post['consigneeLatitude'] ?? "";
        $consigneeLongitude = $post['consigneeLongitude'] ?? "";
        $consigneePostalCode = $post['consigneePostalCode'] ?? "";
        $customerProfileId = $post['rateCustomerProfileId'] ?? 0;
        $rateServiceRowId = $post['rateServiceRowId'] ?? 0;
        $rateOfferingRowId = $post['rateOfferingRowId'] ?? 0;
        $rateRecordRowId = $post['rateRecordRowId'] ?? 0;
        $laneRowId = $post['rateLaneRowId'] ?? 0;
        $estimatedEarlyPickupDate = $post['estimatedPickupDate'] !== "" ? date('Y-m-d H:i:s', strtotime($post['estimatedPickupDate'])) : $insertDate;
        $estimatedDeliveryDate = $post['estimatedDeliveryDate'] !== "" ? date('Y-m-d H:i:s', strtotime($post['estimatedDeliveryDate'])) : date('Y-m-d H:i:s', strtotime('+1 day', strtotime($estimatedEarlyPickupDate)));
        $getOrderData = $this->common->gettblrowdata(['id' => $orderRowId], "transport_mode,product", "tb_orders", 0, 0);
        $orderModeOfTransport = $getOrderData['transport_mode'] ?? "";
        $product = $getOrderData['product'] ?: "KN AsiaLink";
        $modeOfTransportRowId = 0;
        if ($modeOfTransport !== 0 && $orderModeOfTransport !== $modeOfTransport) {
            $getModeOfTransportName = $this->common->gettblrowdata(['code' => $modeOfTransport, 'status' => '1'], 'id', 'tb_transportmode', 0, 0);
            $modeOfTransportRowId = $getModeOfTransportName['id'] ?? 1;
        }
        $getPickup = getdatetimebytimezone(DFLT_TZ, $estimatedEarlyPickupDate, $this->timeZone);
        $earlyPickupDate = $getPickup['datetime'];
        $getDelivery = getdatetimebytimezone(DFLT_TZ, $estimatedDeliveryDate, $this->timeZone);
        $earlyDeliveryDate = $getDelivery['datetime'];
        $orderinfo = [
            'customer_id' => $this->customerRowId,
            'product' => $product,
            'company_code' => $this->companyCode,
            'branch_code' => $this->branchCode,
            'pickup_datetime' => $earlyPickupDate,
            'delivery_datetime' => $earlyDeliveryDate,
            'drop_custid' => $consigneeCode,
            'drop_partyid' => $consigneeCode,
            'user_id' => $this->userId,
            'pickup_custid' => $shipperCode,
            'pickup_partyid' => $shipperCode,
            'pickup_country' => $shipperCountry,
            'pickup_city' => $shipperCity,
            'pickup_pincode' => $shipperPostalCode,
            'pickup_company' => $shipperName,
            'pickup_address1' => $shipperStreet,
            'pickup_address2' => $shipperSuburb,
            'delivery_country' => $consigneeCountry,
            'delivery_city' => $consigneeCity,
            'delivery_pincode' => $consigneePostalCode,
            'delivery_company' => $consigneeName,
            'delivery_address1' => $consigneeStreet,
            'delivery_address2' => $consigneeSuburb,
            'transport_mode' => $modeOfTransport,
            'plat' => $shipperLatitude,
            'plng' => $shipperLongitude,
            'dlat' => $consigneeLatitude,
            'dlng' => $consigneeLongitude,
        ];
        if ($modeOfTransportRowId > 0) {
            $orderinfo['modeoftransport'] = $modeOfTransportRowId;
        }
        $this->common->updatetbledata("tb_orders", $orderinfo, ['id' => $orderRowId]);
        $details = [
            'service' => $service,
            'order_type' => $orderType
        ];
        $this->common->updatetbledata("tb_order_details", $details, ['order_row_id' => $orderRowId, 'status' => '1']);
        $orderParties = [];
        $getOrderParties = $this->CustomerOrder->getOrderInvolvedParties($orderRowId);
        foreach ($getOrderParties as $eachLine) {
            $partyName = strtolower($eachLine['name']);
            $orderParties[$partyName] = $eachLine['party_id'];
        }
        $partyShipperId = $orderParties['shipper'] ?? 0;
        $partyConsigneeId = $orderParties['consignee'] ?? 0;
        $orderShipperRowId = $orderParties['pickup'] ?? $partyShipperId;
        if ($orderShipperRowId !== $shipperRowId) {
            $shipperAddress = $shipperStreet . "," . $shipperCity . "," . $shipperSuburb;
            $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderRowId, 'party_master_id' => $shipperRowId, 'location_id' => $shipperCity, 'street' => $shipperStreet, 'state' => $shipperSuburb, 'address' => $shipperAddress, 'pincode' => $shipperPostalCode, 'country' => $shipperCountry, 'user_id' => $this->userId, 'createdon' => $insertDate]);
            $this->common->updatetbledata("tbl_orderparty_address", ['status' => '0'], ['order_id' => $orderRowId, 'party_master_id' => $orderShipperRowId]);
            $this->common->updatetbledata("tb_order_parties", ['party_id' => $shipperRowId], ['order_id' => $orderRowId, 'party_id' => $orderShipperRowId, 'status' => '1']);
        }
        $orderConsigneeRowId = $orderParties['delivery'] ?? $partyConsigneeId;
        if ($orderConsigneeRowId !== $consigneeRowId) {
            $consigneeAddress = $consigneeStreet . "," . $consigneeCity . "," . $consigneeSuburb;
            $this->common->insertTableData("tbl_orderparty_address", ['order_id' => $orderRowId, 'party_master_id' => $consigneeRowId, 'location_id' => $consigneeCity, 'street' => $consigneeStreet, 'state' => $consigneeSuburb, 'address' => $consigneeAddress, 'pincode' => $consigneePostalCode, 'country' => $consigneeCountry, 'user_id' => $this->userId, 'createdon' => $insertDate]);
            $this->common->updatetbledata("tbl_orderparty_address", ['status' => '0'], ['order_id' => $orderRowId, 'party_master_id' => $orderConsigneeRowId]);
            $this->common->updatetbledata("tb_order_parties", ['party_id' => $consigneeRowId], ['order_id' => $orderRowId, 'party_id' => $orderConsigneeRowId, 'status' => '1']);
        }
        $this->updateReferencesForOrder($orderRowId, $shipmentId, $post);
        $this->updateAddonsForCreatedOrder($orderRowId, $post);
        if (!in_array(0, [$customerProfileId, $rateServiceRowId, $rateOfferingRowId, $rateRecordRowId, $laneRowId], true)) {
            $getCustomerCode = $this->common->gettblrowdata(['id' => $this->customerRowId], 'code', 'tb_customers', 0, 0);
            $customerCode = $getCustomerCode['code'] ?? "";
            $this->ratemanagement->addratesForOrderFromRateEnquiry(
                [
                    'customerId' => $customerCode,
                    'orderRowId' => $orderRowId,
                    'customerProfile' => $customerProfileId,
                    'rateServiceRowId' => $rateServiceRowId,
                    'rateOfferingRowId' => $rateOfferingRowId,
                    'rateRecordRowId' => $rateRecordRowId,
                    'currency' => $this->session->userdata("usr_tzone")['currency'],
                    'userId' => $this->userId,
                    'laneRowId' => $laneRowId,
                    'vendorIdFromProfile' => $post['vendorIdFromProfile'] ?? 0,
                    'vendorCodeFromProfile' => $post['vendorCodeFromProfile'] ?? "",
                    'orderCreatedSource' => '19'
                ]
            );
        }
    }

    private function updateAddonsForCreatedOrder(int $orderRowId, array $postData): void
    {
        $vasData = $postData['vasData'] ?? [];
        $checkAddons = $this->common->gettbldata(['order_id' => $orderRowId, 'status' => '1'], "id,vas_id", "tb_order_vas", 0, 0);
        if (empty($checkAddons)) {
            if (empty($vasData)) {
                return;
            }
            $this->addAddonsForCreatedOrder($orderRowId, $postData);
        } else {
            $orderVasId = [];
            foreach ($checkAddons as $eachLine) {
                $orderVasId[] = $eachLine['vas_id'];
            }
            if (empty($vasData)) {
                $this->common->updatetbledata("tb_order_vas", ['status' => '0'], "vas_id IN (" . implode(',', $orderVasId) . " ) AND order_id = '" . $orderRowId . "' ");
            } else {
                $toInsertData = array_diff($vasData, $orderVasId);
                if (!empty($toInsertData)) {
                    $this->addAddonsForCreatedOrder($orderRowId, ['vasData' => $toInsertData]);
                }
                $toDeleteData = array_diff($orderVasId, $vasData);
                if (!empty($toDeleteData)) {
                    $this->common->updatetbledata("tb_order_vas", ['status' => '0'], "vas_id IN (" . implode(',', $toDeleteData) . " ) AND order_id = '" . $orderRowId . "' ");
                }
            }
        }
    }

    private function updateReferencesForOrder(int $orderRowId, string $shipmentId, array $postData): void
    {
        $orderReferences = $this->common->gettbldata("order_id ='" . $orderRowId . "' AND reference_id IN ('DQ','PO','ORD_PIKINST','ORD_DLVINST') AND status ='1'", "id,reference_id,ref_value", "tb_order_references", 0, 0);
        foreach ($orderReferences as $eachLine) {
            $references[$eachLine['reference_id']] = ['rowId' => $eachLine['id'], 'value' => $eachLine['ref_value'], 'referenceId' => $eachLine['reference_id']];
        }
        if (empty($orderReferences)) {
            return;
        }
        $this->checkAndAddReferencesOrder(['rowId' => $references['DQ']['rowId'] ?? 0, 'dbValue' => $references['DQ']['value'] ?? "", 'userValue' => $shipmentId, 'orderRowId' => $orderRowId, 'referenceId' => $references['DQ']['referenceId'] ?? "DQ"]);
        $this->checkAndAddReferencesOrder(['rowId' => $references['PO']['rowId'] ?? 0, 'dbValue' => $references['PO']['value'] ?? "", 'userValue' => $postData['purchaseOrder'] ?? "", 'orderRowId' => $orderRowId, 'referenceId' => $references['PO']['referenceId'] ?? "PO"]);
        $this->checkAndAddReferencesOrder(['rowId' => $references['ORD_PIKINST']['rowId'] ?? 0, 'dbValue' => $references['ORD_PIKINST']['value'] ?? "", 'userValue' => $postData['pickupInstructions'] ?? "", 'orderRowId' => $orderRowId, 'referenceId' => $references['ORD_PIKINST']['referenceId'] ?? "ORD_PIKINST"]);
        $this->checkAndAddReferencesOrder(['rowId' => $references['ORD_DLVINST']['rowId'] ?? 0, 'dbValue' => $references['ORD_DLVINST']['value'] ?? "", 'userValue' => $postData['deliveryInstructions'] ?? "", 'orderRowId' => $orderRowId, 'referenceId' => $references['ORD_DLVINST']['referenceId'] ?? "ORD_DLVINST"]);
    }

    private function checkAndAddReferencesOrder(array $data): void
    {
        if ($data['rowId'] === 0 && $data['userValue'] !== "") {
            $currentDate = date('Y-m-d H:i:s');
            $getActualDate = getdatetimebytimezone(DFLT_TZ, $currentDate, $this->timeZone);
            $insertDate = $getActualDate['datetime'];
            $this->common->insertTableData("tb_order_references", ['order_id' => $data['orderRowId'], 'reference_id' => $data['referenceId'], 'ref_value' => $data['userValue'], 'status' => '1', 'createdon' => $insertDate]);
        }
        if ($data['rowId'] > 0 && $data['dbValue'] !== $data['userValue']) {
            if ($data['userValue'] !== "") {
                $this->common->updatetbledata("tb_order_references", ['ref_value' => $data['userValue']], ['id' => $data['rowId']]);
            } else {
                $this->common->updatetbledata("tb_order_references", ['status' => '0'], ['id' => $data['rowId']]);
            }
            if ((checkAccessConditions('CHECK_STATUS_RETRIGGER_COMPANY', $this->companyCode)) && (checkAccessConditions('CHECK_STATUS_RETRIGGER_REFERENCE', $data['referenceId']))) {
                log_message("error", "Edited Order Reference From Customer login" . $data['orderRowId'] . " - " . $data['referenceId'] . " - " . $data['userValue']);
                try {
                    $this->load->library('orderstatusretriggertoedi214');
                    $this->orderstatusretriggertoedi214->retriggeredPreviousStatus($data['orderRowId']);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Reference to Altova " . $ex->getMessage());
                }
            }
        }
    }

    private function sendMailNotification(string $bookingId, int $orderRowId): void
    {
        $checkDgGoods = $this->CustomerOrder->checkDangerousGoodsForOrder($orderRowId);
        $unCodes = $checkDgGoods['unCode'] ?? [];
        $getUserCustomerAndVendorData = $this->CustomerOrder->getUserCustomerAndVendorData($orderRowId);
        $userMailId = $getUserCustomerAndVendorData['user_email_id'] ?? '';
        $userName = $getUserCustomerAndVendorData['name'] ?? '';
        $customerMailId = $getUserCustomerAndVendorData['customer_email_id'] ?? "";
        $customerCode = $getUserCustomerAndVendorData['customer_code'] ?? "";
        $vendorMailId = $getUserCustomerAndVendorData['vendor_email_id'] ?? "";
        $customerName = $getUserCustomerAndVendorData['customerName'] ?? "";
        $branchCode = $getUserCustomerAndVendorData['branch_code'] ?? "";
        $ccMailIds = $bccMailIds = [];
        $toMailIds = [$customerMailId];
        if (in_array($customerCode, ['1005751990', '1000612148','1005202085'])) {
            $toMailIds = ['angelie.omes@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com'];
            $bccMailIds = ['sol.ignacio@kuehne-nagel.com',$customerMailId];
            if ($vendorMailId != '') {
                $bccMailIds = array_merge($bccMailIds, explode("; ", $vendorMailId));
            }
            $ccMailIds =  ['m.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com'];
        }
        if ($customerCode == "1000612148") {
            $toMailIds = ['angela.gimoros@kuehne-nagel.com', $customerMailId];
        }
        if (empty($unCodes)) {
            $filesPath = [];
            $subject = "Booking (" . $bookingId . ") Created through eBooking ";
            $message = "Hi Team,<br>";
            $message .= "Booking got confirmed with Booking ID ( " . $bookingId . ") for the Customer Id (" . $this->customerCode . ")<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>Svkonekt.com";
            if (!empty($toMailIds)) {
                if ($this->phpmailerlibrary->sendMultipleToMail($toMailIds, $subject, $message, $ccMailIds, [], $bccMailIds)) {
                    log_message("error", "CustomerOrders-sendMailNotification-mailSendToCustomer - " . $bookingId." ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailIds)." bcc - ".json_encode($bccMailIds)." email body- ".$message);
                } else {
                    log_message("error", "CustomerOrders-sendMailNotification-mailNotSentToCustomer - " . $bookingId." ".$subject." to - ".json_encode($toMailIds)." cc - ".json_encode($ccMailIds)." bcc - ".json_encode($bccMailIds)." email body- ".$message);
                }
            }
        } else {
            $unCodeString = implode(", ", $unCodes);
            $filesPath = $checkDgGoods['pods'] ?? [];
            $subject = "Alert: Booking (" . $bookingId . ") created with Dangerous Goods";
            $message = "Dear " . $userName . ",<br>";
            $message .= "Booking created with ID ( " . $bookingId . ") containing the dangerous goods (" . $unCodeString . ")<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>Svkonekt.com";
        }
        if ($userMailId != "") {
            if ($this->phpmailerlibrary->sendmail($userMailId, $subject, $message, [], $filesPath ?? [])) {
                log_message("error", "CustomerOrders-sendMailNotification-mailSendToAdmin - " . $bookingId);
            } else {
                log_message("error", "CustomerOrders-sendMailNotification-mailNotSentToAdmin - " . $bookingId);
            }
        }
        if (checkAccessConditions('RELATED_2_SENDING_MAIL_TOKNIDS_WHILE_EBOOKING', $customerCode)) {
            $this->sendBookingCreatedMailToKN(['bookingId' => $bookingId, 'customerName' => $customerName, 'branchCode' => $branchCode]);
        }
    }

    private function sendBookingCreatedMailToKN(array $data): void
    {
        $customerName = "<span style='color: red'>(" . $data['customerName'] . ")</span>";
        $subject = "Booking (" . $data['bookingId'] . ") Created through eBooking (" . $data['customerName'] . ")";
        $message = "Hi Team,<br>";
        $message .= "Booking got confirmed with Booking ID ( " . $data['bookingId'] . ") for the Customer " . $customerName . "<br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>Svkonekt.com";
        $toMailIds = ['m.sivakumar@kuehne-nagel.com', 'joel.padua@kuehne-nagel.com', 'florylie-joy.gumboc@kuehne-nagel.com', 'angelie.omes@kuehne-nagel.com'];
        $branchCode = $data['branchCode'] ?? "";
        if ($branchCode == "PHCEB") {
            $toMailIds = array_merge($toMailIds, [
                'yvonne.he@Kuehne-Nagel.com',
                'angela.gimoros@kuehne-nagel.com',
            ]);
        }
        $bccMailIds = ['sol.ignacio@kuehne-nagel.com'];
        if ($this->phpmailerlibrary->sendMultipleToMail($toMailIds, $subject, $message, [], [], $bccMailIds)) {
            log_message("error", "CustomerOrders-sendMailNotification-mailSendToKNStaff - " . $data['bookingId'] . " " . $subject . " to - " . json_encode($toMailIds) . " bcc - " . json_encode($bccMailIds) . " email body- " . $message);
        } else {
            log_message("error", "CustomerOrders-sendMailNotification-mailNotSendToKNStaff - " . $data['bookingId'] . " " . $subject . " to - " . json_encode($toMailIds) . " bcc - " . json_encode($bccMailIds) . " email body- " . $message);
        }
    }

    public function viewOrderInPopup(): void
    {
        $postData = $this->input->post(null, true);
        $orderRowId = $postData['orderRowId'] ?? 0;
        $data = [];
        if ($orderRowId > 0) {
            $data['quickbookData'] = $this->getQuickBookChangesForCustomer($orderRowId);
            $data['orderDetails'] = $this->customerordershandler->getOrderDetailsById($orderRowId);
        }
        echo $this->load->view('svkCustomer/svkCustomerViewQuickbook', $data, true);
    }

    private function checkRoutingAutomation(array $data): void
    {
        $pickupInfo = $data['pickupInfo'];
        $pickupGeoCode = $data['pickupGeoCode'];
        $dropInfo = $data['dropInfo'];
        $dropGeoCode = $data['dropGeoCode'];
        $orderInfo = $data['orderInfo'];
        $getCargos = $this->common->gettbldata(['order_id' => $data['orderRowId'], 'status' => 1], 'order_id,cargo_id,length,width,height,weight,second_weight,volumetric_weight,volweight_uom,ldm,volume,second_volume,quantity,quantity_type,cargo_content,status,marks_numbers', 'tb_order_cargodetails', 0, 0);
        $customerDetails = $this->common->gettblrowdata(['id' => $this->customerRowId], 'phone,email_id', 'tb_customers', 0, 0);
        $totalWeight = $totalQuantity = $totalVolume = 0;
        foreach ($getCargos as $eachCargo) {
            $cargos = $eachCargo;
            $totalQuantity += $eachCargo['quantity'];
            $totalVolume += $eachCargo['volume'];
            $totalWeight += $eachCargo['weight'];
        }
        if (!empty($pickupGeoCode) && !empty($dropGeoCode)) {
            $pickupGeoCode['stoptype'] = "P";
            $dropGeoCode['stoptype'] = "D";
            $pickupGeoCode['order_country'] = trim($pickupInfo['country']);
            $pickupGeoCode['order_city'] = trim($pickupInfo['city']);
            $pickupGeoCode['order_zipcode'] = trim($pickupInfo['zipcode']);
            $dropGeoCode['order_country'] = trim($dropInfo['country']);
            $dropGeoCode['order_city'] = trim($dropInfo['city']);
            $dropGeoCode['order_zipcode'] = trim($dropInfo['zipcode']);
            $pickupGeoCode['cargo'] = $dropGeoCode['cargo'] = $cargos ?? [];
            $pickupRoute = getcust_routeautomate($this->customerRowId, $pickupGeoCode);
            $dropRoute = getcust_routeautomate($this->customerRowId, $dropGeoCode);
            if (!empty($pickupRoute) && !empty($dropRoute)) {
                $orderInfo['id'] = $data['orderRowId'];
                $orderInfo['order_id'] = $data['bookingId'];
                $orderInfo['shipment_name'] = "BOXES";
                $orderInfo['customer_phone'] = $customerDetails['phone'];
                $orderInfo['customer_email'] = $customerDetails['email_id'];
                $orderInfo['volume'] = $totalVolume;
                $orderInfo['weight'] = $totalWeight;
                $orderInfo['quantity'] = $totalQuantity;
                createshipmentbyorder($pickupRoute, $orderInfo);
            } else {
                $pickupInfo['cargo'] = $dropInfo['cargo'] = $cargos ?? [];
                $pickupRoute1 = getcust_routeautomate($this->customerRowId, $pickupInfo);
                $dropRoute1 = getcust_routeautomate($this->customerRowId, $dropInfo);
                if (!empty($pickupRoute1) && !empty($dropRoute1)) {
                    $orderInfo['id'] = $data['orderRowId'];
                    $orderInfo['order_id'] = $data['bookingId'];
                    $orderInfo['shipment_name'] = "BOXES";
                    $orderInfo['customer_phone'] = $customerDetails['phone'];
                    $orderInfo['customer_email'] = $customerDetails['email_id'];
                    $orderInfo['volume'] = $totalVolume;
                    $orderInfo['weight'] = $totalWeight;
                    $orderInfo['quantity'] = $totalQuantity;
                    createshipmentbyorder($pickupRoute1, $orderInfo);
                }
            }
        } else {
            $pickupInfo['cargo'] = $dropInfo['cargo'] = $cargos ?? [];
            $pickupRoute2 = getcust_routeautomate($this->customerRowId, $pickupInfo);
            $dropRoute2 = getcust_routeautomate($this->customerRowId, $dropInfo);
            if (!empty($pickupRoute2) && !empty($dropRoute2)) {
                $orderInfo['id'] = $data['orderRowId'];
                $orderInfo['order_id'] = $data['bookingId'];
                $orderInfo['shipment_name'] = "BOXES";
                $orderInfo['customer_phone'] = $customerDetails['phone'];
                $orderInfo['customer_email'] = $customerDetails['email_id'];
                $orderInfo['volume'] = $totalVolume;
                $orderInfo['weight'] = $totalWeight;
                $orderInfo['quantity'] = $totalQuantity;
                createshipmentbyorder($pickupRoute2, $orderInfo);
            }
        }
    }
}
