<?php

class MY_Log extends CI_Log
{
    /**
     * @param	string	the error level: 'error', 'debug' or 'info'
     * @param	string	the error message
     * @return	bool
     */
    public function write_log($level, $msg)
    {
        if ($this->_enabled === FALSE)
        {
            return FALSE;
        }

        //$level = strtoupper($level);
        $level = strtoupper(trim($level, " :"));

        if (( ! isset($this->_levels[$level]) OR ($this->_levels[$level] > $this->_threshold))
            && ! isset($this->_threshold_array[$this->_levels[$level]]))
        {
            return FALSE;
        }

        $message = $this->add_request_id_to_error_message($level, $msg);
        $this->write_log_to_file($level, $message);
        error_log($message);

        return 1;
    }

    private function add_request_id_to_error_message(string $level, string $message): string
    {
        if(!empty($_SERVER['UNIQUE_ID'])) {
            $message = sprintf("%s: %s", $_SERVER['UNIQUE_ID'], $message);
        }

        return $message;
    }

    private function generate_error_log_date(): string
    {
        // Instantiating DateTime with microseconds appended to initial date is needed for proper support of this format
        if (strpos($this->_date_fmt, 'u') !== FALSE)
        {
            $microtime_full = microtime(TRUE);
            $microtime_short = sprintf("%06d", ($microtime_full - floor($microtime_full)) * 1000000);
            $date = new DateTime(date('Y-m-d H:i:s.'.$microtime_short, $microtime_full));
            $date = $date->format($this->_date_fmt);
        }
        else
        {
            $date = date($this->_date_fmt);
        }

        return $date;
    }

    /**
     * @param string $message
     */
    private function write_log_to_file(string $level, string $message): void
    {
        $date = $this->generate_error_log_date();
        $message = sprintf("%s - %s --> %s", $level, $date, $message) . "\n";

        $filepath = $this->_log_path.'log-'.date('Y-m-d').'.'.$this->_file_ext;
        if ( ! $fp = @fopen($filepath, 'ab'))
        {
            return;
        }

        if ( ! file_exists($filepath))
        {
            $newfile = TRUE;
            // Only add protection to php files
            if ($this->_file_ext === 'php')
            {
                $message .= "<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>\n\n";
            }
        }

        flock($fp, LOCK_EX);

        for ($written = 0, $length = strlen($message); $written < $length; $written += $result) {
            if (($result = fwrite($fp, substr($message, $written))) === FALSE) {
                break;
            }
        }

        flock($fp, LOCK_UN);
        fclose($fp);

        if (isset($newfile) && $newfile === TRUE) {
            chmod($filepath, $this->_file_permissions);
        }
    }
}
