<?php

namespace App\Helpers;

use App\ExceptionHandler\OrderIdGeneratorException;
use Exception;

class ParsedOrderIdHelper implements ParsedOrderIdHelperInterface
{
    private const MINIMUM_LENGTH = 7;
    private const MAXIMUM_LENGTH = 18;

        public function parseOrderId($orderId): ParsedOrderIdHelperInterface
        {
            //log_message("error","OrderId11:".$orderId);
            if($orderId!=0){
            $this->validateIsInteger($orderId);
            $this->validateLength($orderId);
            $this->id = $orderId;
            $this->countryCode = substr($orderId, 0, 2);
            $this->yearNumber = substr($orderId, 2, 2);
            $this->weekNumber = substr($orderId, 4, 2);
            $this->idCode = substr($orderId, 6);}
    
            return $this;
        }

    public function getPrefix(): int
    {
        return (int) $this->countryCode.$this->yearNumber.$this->weekNumber;
    }

    public function getIdCode(): int    
    {
        return (int) $this->idCode;
    }

    public function getFullId(): int
    {
        return (int) $this->id;
    }

    public function upIdCode(): int
    {
        $this->id = (((int)$this->countryCode . $this->yearNumber . $this->weekNumber) . ($this->idCode)) + 1;
        return $this->id;
    }


    public function getIdCodeLength(): int
    {
        return strlen($this->idCode);
    }

    /**
     * @param $orderId
     * @throws Exception
     */
    public function validateLength($orderId): void
    {
        //log_message("error","OrderId:".$orderId);
        if (strlen($orderId) < self::MINIMUM_LENGTH) {
            throw new Exception("Given OrderId is inferior to minimum length");
        }

        if (strlen($orderId) > self::MAXIMUM_LENGTH) {
            throw new Exception("Given OrderId exceeds maximum length");
        }
    }

    /**
     * @param $orderId
     * @throws Exception
     */
    public function validateIsInteger($orderId): void
    {
        /*if(!is_numeric($orderId))
        {
            throw new Exception("Given OrderId contains a non-numeric value");
        }*/
        if (!preg_match('/^\d+$/', $orderId)) {
        throw new Exception("Given OrderId contains a non-numeric value");
    }
    }


}
