<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

if (!function_exists('manifestoverride')) {
    function manifestoverride($order_id)
    {
        $ci      = &get_instance();
        $ci->load->model('Aulabelmodel');
        $data = array();
        $consign = $ci->common->gettblrowdata(array(
            'order_row_id' => $order_id
        ), 'consignment_note', 'tb_order_details', 0, 0);
        $consignment_note=$consign['consignment_note']??0;
        if (empty($consignment_note)) {
            $consign = $ci->common->gettblrowdata(array(
                'id' => $order_id
            ), 'order_id', 'tb_orders', 0, 0);
            $consignment_note=$consign['order_id']??0;
        }
        if (!empty($consignment_note)) {
            $data['consignment_no'] = $consignment_note;
            $cargos = $ci->common->gettbldata(array(
                'status' => 1,
                'order_id' => $order_id
            ), 'id,cargo_id,order_id,quantity', 'tb_order_cargodetails', 0, 0);
            if(!empty($cargos)){
                foreach ($cargos as $cargo) {
                    $whr_barcode=['cargo_id'=>$cargo['cargo_id'],'status'=>1];
                    $barcode_count= $ci->Aulabelmodel->count_labels($whr_barcode);
                    $toatal_barcodes=(int)$barcode_count['count_barcodes']??0;
                    $total_quantity= (int)$cargo['quantity']??0;
                    if($toatal_barcodes==$total_quantity){
                        continue;
                    }
                    if($total_quantity > 1){
                        $total_quantity=$total_quantity-$toatal_barcodes;
                        for ($i=0;$i<$total_quantity;$i++){
                            $newbarcode = genbarcode($data['consignment_no'], $order_id);
                            $insarray = array(
                                'cargo_id' => $cargo['cargo_id'],
                                'order_id' => $cargo['order_id'],
                                'pallet_id' => $cargo['id'],
                                'bar_code' => $newbarcode,
                                'status' => 1
                            );
                            $ins = $ci->common->insertTableData("tb_order_cargo_labels", $insarray);
                        }
                    }else{
                        $newbarcode = genbarcode($data['consignment_no'], $order_id);
                        $insarray = array(
                            'cargo_id' => $cargo['cargo_id'],
                            'order_id' => $cargo['order_id'],
                            'pallet_id' => $cargo['id'],
                            'bar_code' => $newbarcode,
                            'status' => 1
                        );
                        $ins = $ci->common->insertTableData("tb_order_cargo_labels", $insarray);
                    }
                }
            }
        }
        return $data;
    }
}

if (!function_exists('genbarcode')) {
    function genbarcode($consignment_no, $order_id)
    {

        $ci      = &get_instance();
        $ci->load->model('aureportsmodel');
        $barcodestart = "0001";
        $whr = "bar_code LIKE '" . $consignment_no . "%' AND order_id=$order_id";
        $ci->load->model('aureportsmodel');
        $rcent = $ci->aureportsmodel->checkbarcode_basedonconsignmentnote($whr);
        if ($rcent->num_rows() > 0) {
            $newbarcode1 = $rcent->row()->bar_code;
            $getlasts4 = substr($newbarcode1, -4);
            $getlasts4++;
            $inc_length = strlen($getlasts4);
            $getlast4 = $getlasts4;
            if ($inc_length == 1) {
                $getlast4 = "000" . $getlast4;
            } else if ($inc_length == 2) {
                $getlast4 = "00" . $getlast4;
            } else if ($inc_length == 3) {
                $getlast4 = "0" . $getlast4;
            }
            $newbarcode = $consignment_no . "" . $getlast4;
            $getlast4 = "";
        } else {
            $newbarcode = $consignment_no . "" . $barcodestart;
        }
        return $newbarcode;
    }
}

if (!function_exists('appLabelRePrint')) {
    function appLabelRePrint($appRequestCargoData, $orderId)
    {
        $cargoId = 0;
        $postData = json_decode($appRequestCargoData);
        $cargoId = $postData[0]->id;
        $ci = &get_instance();
        $labelData = getLabelData($cargoId, $orderId);
        if (empty($labelData)) {
            return ['endUrl' => ''];
        }
        $labelData['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
        require 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH . 'assets/tmp',
            'mode' => 'utf-8',
            'format' => [
                112.0,
                152.0
            ],
            'tempDir' => FCPATH . 'assets/tmp',
            'margin_left' => 0,
            'margin_right' => 0,
            'margin_top' => 0,
            'margin_bottom' => 0,
            'margin_header' => 0,
            'margin_footer' => 0
        ]);
        $data['labelcontent'] = $ci->load->view('orders/aulabel', $labelData, true);
        $output = $ci->load->view('orders/order_label', $data, true);
        $mpdf->WriteHTML($output);
        $endUrl = $labelData['shipmentnumber'] . "_" . $labelData['consignment_no'] . "_" . date('YmdHis') . ".pdf";
        $labelPdf = "./assets/aucargolabel/" . $endUrl;
        $mpdf->Output($labelPdf, 'F');
        $labelData['endUrl']=$endUrl;
        return $labelData;
    }
}
function getLabelData($cargoDetailId, $orderId): array
{
    $data = [];
    $data['carrier_img'] = "";
    $data['count'] = $data['weight'] = $data['delivery_ins'] = "";
    $ci = &get_instance();
    $ci->load->model('Aulabelmodel');
    $getLabelData = $ci->Aulabelmodel->getCargoData($cargoDetailId, $orderId);
    if (empty($getLabelData)) {
        return [];
    }
    $getCarrierData = getVendorData($getLabelData['vendorName']);
    $getRoutingData = getRoutingDetails($getLabelData['order_id'], $getLabelData);
    $data['carrier_img'] = $getCarrierData['carrierImg'];
    $data['carrier_new_name'] = $getCarrierData['carrierNewName'];
    $data['delivery_ins'] = $getLabelData['delivery_ins'];
    $data['shipmentnumber'] = $getLabelData['shipmentNumber'];
    $data['routecode'] = getRouteingCode($getCarrierData['carrierNewName'], $getRoutingData['consigneePartyData']);
    $data['delivery_date'] = date('d/m/Y', strtotime($getLabelData['delivery_date']));
    $data['pickup_date'] = date('d/m/Y', strtotime($getLabelData['pickup_date']));
    $data['consignment_no'] = $getLabelData['consignment_note'];
    $data['container_no'] = $getLabelData['containerNumber'];
    $data['carrier_name'] = $getLabelData['vendorName'];
    $data['userId'] = $getLabelData['user_id'];
    $data['cargos'] = [
        'weight' => $getLabelData['weight'],
        'qty' => $getLabelData['quantity'],
        'cargo_type' => $getLabelData['cargo_type'],
        'cargo_content' => $getLabelData['cargo_content'],
        'barcode_no' => $getLabelData['bar_code'],
        'label_create_date' => $getLabelData['createdon'],
        'qr_code' => $getLabelData['qr_code']
    ];
    $data['drop_details'] = $getRoutingData['consigneePartyData'];
    $data['shipper_details'] = $getRoutingData['shipperPartyData'];
    $data['store_timings'] = storeTimings($data) ?? '';
    $data['weight'] = $getLabelData['weight'];
    $data['cargo_type'] = $getLabelData['cargo_type'];
    $data['cargo_content'] = $getLabelData['cargo_content'];
    $getCargoQty = getTotalCargos($getLabelData['order_id'], $cargoDetailId);
    $data['no'] = $getCargoQty['cartonNum'];
    $data['qty'] = $getCargoQty['cartonQty'];
    $data['caseid'] = $getLabelData['qr_code'];
    $data['barcode_no'] = $getLabelData['bar_code'];
    $data['label_create_date'] = getdatetimebytimezone("Australia/Sydney", $getLabelData['createdon'], DFLT_TZ)['datetime'];
    $data['static_text'] = true;

    return $data;
}

function getVendorData($carrierName): array
{
    $carrierName = (strtoupper($carrierName) == "BORDER EXPRESS") ? "BEX" : strtoupper($carrierName);
    $data['carrierNewName'] = "";
    $data['carrierImg'] = "";
    if ($carrierName == "BEX") {
        $data['carrierImg'] = "BEX.jpg";
        $data['carrierNewName'] = "REGIONAL";
        return $data;
    }
    if ($carrierName == "BONDS TRANSPORT") {
        $data['carrierImg'] = "Bonds.jpg";
        $data['carrierNewName'] = "METRO";
        return $data;
    }
    if ($carrierName == "BONDS DC") {
        $data['carrierImg'] = "DC.jpg";
        $data['carrierNewName'] = "DC";
        return $data;
    }
    return $data;
}

function getRoutingDetails($orderId, $getLabelData): array
{
    $ci = &get_instance();
    $ci->load->model('Aulabelmodel');
    $shipperPartyData = $ci->Aulabelmodel->getRoutingDetails($orderId, 'Shipper');
    $shipperPartyData['name'] = $getLabelData['pickup'];
    $shipperPartyData['street'] = $getLabelData['pickup_address1'];
    $shipperPartyData['state'] = $getLabelData['pickup_address2'];
    $shipperPartyData['city'] = $getLabelData['pickup_city'];
    $shipperPartyData['country'] = $getLabelData['pickup_country'];
    $shipperPartyData['pincode'] = $getLabelData['pickup_pincode'];
    $consigneePartyData = $ci->Aulabelmodel->getRoutingDetails($orderId, 'Consignee');
    $consigneePartyData['name'] = $getLabelData['delivery'];
    $consigneePartyData['street'] = $getLabelData['delivery_address1'];
    $consigneePartyData['state'] = $getLabelData['delivery_address2'];
    $consigneePartyData['city'] = $getLabelData['delivery_city'];
    $consigneePartyData['country'] = $getLabelData['delivery_country'];
    $consigneePartyData['pincode'] = $getLabelData['delivery_pincode'];
    return ['consigneePartyData' => $consigneePartyData, 'shipperPartyData' => $shipperPartyData];
}

function getRouteingCode($carrierName, $consigneeData)
{
    $ci = &get_instance();
    $routeingData['routing_code'] = "";
    if ($carrierName == 'BONDS TRANSPORT') {
        $routeingData = $ci->common->gettblrowdata([
            'correct_zip' => $consigneeData['pincode'],
            'status' => 1,
            'carrier_name' => 'Bonds'
        ], 'headport', 'tb_au_carrier_headports', 0, 0);
        return $routeingData['headport'] ?? '';
    }

    $routeingData = $ci->common->gettblrowdata([
        'postalcode' => $consigneeData['pincode'],
        'suburb' => $consigneeData['city'],
        'state' => $consigneeData['state'],
        'status' => 1,
        'type' => 2
    ], 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);
    if (!empty($routeingData)) {
        return $routeingData['routing_code'] ?? '';
    }
    $routeingData = $ci->common->gettblrowdata([
        'postalcode' => $consigneeData['pincode'],
        'state' => $consigneeData['state'],
        'status' => 1,
        'type' => 2
    ], 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);

    return $routeingData['routing_code'] ?? '';
}

function storeTimings($data)
{
    $ci = &get_instance();
    $store_code = 0;
    $storeData = [];
    if (isset($data['drop_details'], $data['order_id']) && !empty($data) &&
        !empty($data['drop_details']) && !empty($data['order_id'])) {
        $reference = $ci->common->gettblrowdata([
            'order_id' => $data['order_id'] ?? 0,
            'reference_id' => 'COI'
        ], 'ref_value', 'tb_order_references', 0, 0);
        if (!empty($reference)) {
            $store_code = $reference['ref_value'];
        }
    }
    $where = [
        'city' => $data['drop_details']['city'] ?? '',
        'state' => $data['drop_details']['state'] ?? '',
        'post_code' => $data['drop_details']['pincode'] ?? '',
        'name' => $data['drop_details']['name'] ?? '',
        'status' => 1
    ];
    if (!empty($store_code)) {
        $where['store_code'] = $store_code;
    }
    $storeData = $ci->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
    if (!empty($storeData) && !empty($storeData['dock_hours'])) {
        return $storeData;
    }
    unset($where['city'], $where['name']);
    $storeData = $ci->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
    if (!empty($storeData) && !empty($storeData['dock_hours'])) {
        return $storeData;
    }
    unset($where['state']);
    return $ci->common->gettblrowdata($where, 'dock_hours,days', 'tb_au_store_timings', 0, 0);
}

function getTotalCargos($orderId, $cargoDetailId): array
{
    $ci = &get_instance();
    $ci->load->model('Aulabelmodel');
    $data = [
        'cartonNum' => 1,
        'cartonQty' => 1
    ];
    $getTotalCargos = $ci->Aulabelmodel->getcargolabelsorted($orderId);

    if (!empty($getTotalCargos)) {
        $totalCartons = array_column($getTotalCargos, 'id');
        $cartonNum = array_search($cargoDetailId, $totalCartons, true);
        $cartonNum++;
        $data['cartonNum'] = !empty($cartonNum) ? $cartonNum : 1;
    }
    $getCargoIds = $ci->common->gettblrowdata(
        ['order_id' => $orderId, 'status' => 1],
        "count(id) idCount",
        "tb_order_cargodetails",
        0,
        0
    );
    $data['cartonQty'] = !empty($getCargoIds['idCount']) ? $getCargoIds['idCount'] : 1;
    return $data;
}

function getAuLabelConsigneeMobileNum(string $orderId): string
{
    $ci = &get_instance();
    $ci->load->model('Aulabelmodel');
    return $ci->Aulabelmodel->getConsigneeMobileNum($orderId);
}


