<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

if (! function_exists('au_deliverynote_customer_specific')) {
    function au_deliverynote_customer_specific($order_id, $booking_id)
    {

        $ci = &get_instance();
        if (! empty($order_id)) {

            $return_val = false;
            /*
                * Checking MACPAC customer
                */
            $ci->load->model('Aumanifestmodel');
            $get_cus_data = $ci->Aumanifestmodel->checkMacpacCustomer($order_id);
            $company_code = $ci->session->userdata('company_code') ?? "";

            /*
                * get session data
                */
            if ((empty($company_code))) {
                $session_data = get_session_data($order_id);
            }
            if (! empty($get_cus_data) && strtoupper($company_code) == "KNAU") {
                /**
                 * macpac delivery note
                 */
                $get_data   = macpac_deliverynote($order_id, $booking_id);
                $return_val = true;
            }

        }
        return $return_val;

    }

}

if (! function_exists('macpac_deliverynote')) {
    function macpac_deliverynote($order_id, $booking_id)
    {

        $ci = &get_instance();
        if ((! empty($order_id)) && (! empty($booking_id))) {
            $createdon_date = date('Y-m-d H:i:s');
            $return_val     = false;
            $ref_value      = "MACP" . $booking_id;
            $update_data    = ['consignment_note' => $ref_value];
            /**
             * update order details table
             */
            $update = $ci->common->updatetbledata("tb_order_details", $update_data, ['order_row_id' => $order_id]);
            /**
             *  DQ reference insert
             */
            $ref_ins = ['reference_id' => 'DQ', 'ref_value' => $ref_value, 'order_id' => $order_id, 'createdon' => $createdon_date];
            $ci->common->insertTableData("tb_order_references", $ref_ins);
            $return_val = true;
        }
        return $return_val;

    }
}
