<?php
if (! defined('BASEPATH'))
    exit('No direct script access allowed');

function borderconsignment($data,$source=NULL)
{
    $ci = &get_instance();

    $outBoundRequestData = asnborderBooking($data);
    $fileName = $outBoundRequestData['filename'];
    $outBoundRequestData['status'] = 0;
    $sftpResponse=borderSftpConnection($fileName);
    $outBoundRequestData['status']=$sftpResponse['status'];
    $response=$sftpResponse['response'];
    borderedilogs($outBoundRequestData);
    $dt = date('Y-m-d H:i:s');
    $ci->load->model('common');
    $insert = array(
        'req_type' => 'BOOKING',
        'filename' => $fileName,
        'order_id' => $data['ordid'],
        'res_status' => 'success',
        'status' => 1,
        'vendor_type'=>1,
        'createdon' => $dt,
        'updatedon' => $dt,
        'response' => $outBoundRequestData['status'],
    );
    $id = $ci->common->insertTableData('tb_bexedi', $insert);
    if($source == 'callapi') {
        echo "<h1>".$response."</h1>";
    }
}

function borderSftpConnection($fileName): array
{
    $ci = &get_instance();
    if(SYS_TYPE == 'TMS'){
        $username = BORDER_EXPRESS_PROD_USERNAME;
        $password = BORDER_EXPRESS_PROD_PASSWORD;
    }else{
        $username = BORDER_EXPRESS_TEST_USERNAME;
        $password = BORDER_EXPRESS_TEST_PASSWORD;
    }
    $sftpDestination = "/" . $fileName;
    $sourceFile = "./xml/borderapi/" . $fileName;
    $ci->load->library("SftpProxyClient");
    $SFTP=$ci->sftpproxyclient->proxyConnection(BORDER_EXPRESS_OUTBOUND_SFTP_URL,"Border Express");
    if(!$SFTP){
        return ['status' => 0, 'response' =>"Border Express proxy Login failed"];
    }

    return $ci->sftpproxyclient->fileUpload(['sftp'=>$SFTP,
        'sftpUsername'=>$username,
        'sftpPassword'=>$password,
        'sftpDestination'=>$sftpDestination,
        'sftpSourceFile'=>$sourceFile,
    ],"Border Express");
}

function asnborderBooking($data)
{
    $ci = &get_instance();
    $order_row_id = $data['ordid'];
    $ci->load->model(['common', 'truckwaybillmodel', 'Aulabelmodel']);

    $where = [
        "id" => $order_row_id
    ];
    $select = "order_id,shift_id,customer_id,user_id,weight,pickup_city,pickup_address2,pickup_pincode,pickup_company,pickup_datetime,pickup_address1,delivery_city,delivery_address2,delivery_pincode,delivery_company,delivery_datetime,delivery_address1,vendor_id";
    $table = "tb_orders";
    $order = $ci->common->gettblrowdata($where, $select, $table, 0, 0);
    $curtz = $ci->session->userdata("usr_tzone")['timezone']??"";
    if(empty($curtz)){
        $curtz = "Australia/Sydney";
    }
    if((empty($company_code)) || (empty($branch_code))){
        $ci->load->helper('bonds_helper');
        $session_data=get_session_data($order_row_id);
        $company_code=$session_data['company_code']??"";
        $branch_code=$session_data['branch_code']??"";
    }
    $order['pickup_datetime'] = getdatetimebytimezone($curtz, $order['pickup_datetime'], DFLT_TZ);
    $order['delivery_datetime'] = getdatetimebytimezone($curtz, $order['delivery_datetime'], DFLT_TZ);

    $where = [
        "order_id" => $order_row_id
    ];
    $select = "cargo_id,length,width,height,quantity,weight,volume,cargo_content";
    $table = "tb_order_cargodetails";
    $order_cargo = $ci->common->gettbldata($where, $select, $table, 0, 0);
    $pickupinfo = $ci->truckwaybillmodel->getshipper($order_row_id, 'Shipper');
    $receiverinfo = $ci->truckwaybillmodel->getshipper($order_row_id, 'Consignee');
    $order_details = $ci->common->gettblrowdata([
        'order_row_id' => $order_row_id
    ], 'service,delivery_note,purchase_order,consignment_note', 'tb_order_details', 0, 0);

    $customerinfo = $ci->common->gettblrowdata([
        'id' => $order['customer_id']
    ], 'name,phone,email_id', 'tb_customers', 0, 0);

    $isDG = 'NO';
    $itemsweight = 0;
    $itemscount = 0;
    $cargos = [];
    $barcodeCount = $ci->Aulabelmodel->count_labels(['order_id' => $order_row_id, 'status' => 1]);
    $totalBarcodes = (int)$barcodeCount['count_barcodes'] ?? 0;
    $cargoCount = $ci->Aulabelmodel->count_cargos(['r.id' => $order_row_id, 'r.status !=' => 0]);
    $totalQuantity = (int)$cargoCount['totqty'] ?? 0;
    if ($totalBarcodes < $totalQuantity) {
        $ci->load->helper('aulabel_helper');
        manifestoverride($order_row_id);
    }
    $carrierService='';
    if (count($order_cargo) > 0) {
        foreach ($order_cargo as $info) {
            $cargoinfo = $ci->common->gettblrowdata([
                'id' => $info['cargo_id']
            ], 'dg_goods,weight_unit,length_unit,width_unit,height_unit,cargo_type', 'tb_cargo_details', 0, 0);
            $isDG = ($cargoinfo['dg_goods'] == 0) ? 'NO' : 'YES';
            $info['quantity'] = round($info['quantity']);
            $info['length'] = conversationtocm($info['length'], $cargoinfo['length_unit']);
            $info['width'] = conversationtocm($info['width'], $cargoinfo['width_unit']);
            $info['height'] = conversationtocm($info['height'], $cargoinfo['height_unit']);
            $info['cargo_type'] = $cargoinfo['cargo_type'];
            $itemscount += $info['quantity'];
            $barcodes = $ci->Aulabelmodel->getLabelBarcodes($info['cargo_id'], $info['quantity']);
            if (!empty($barcodes)) {
                if (count($barcodes) > 1) {
                    $getBarcodes = array_column($barcodes, 'bar_code');
                    $barCodes = implode(';', $getBarcodes);
                    $info['bar_code'] = $barCodes;
                } else {
                    $info['bar_code'] = $barcodes['bar_code'];
                }
                $itemsweight += $info['weight'];
                $cargos[] = $info;
            }
        }

        $carrierService = "BEP";
    }

    if($company_code=="KNAU"){
        $branch = substr($branch_code, 4);
    }else{
        $branch = substr($branch_code, 2);
    }
    if ($branch == 'VIC') {
        $accountcode = 'KUE30';
    } elseif ($branch == 'QLD') {
        $accountcode = 'KUE31';
    } elseif ($branch == 'NSW') {
        $accountcode = 'KUE32';
    } elseif ($branch == 'WA') {
        $accountcode = 'KUE33';
    }
    if($company_code=="KNAU"){
        $accountcode = "KUE34";
    }

    $req = " ";
    $req .= '<Consignment>';
    $req .= '   <ConsignmentNumber>' . $order_details['consignment_note'] . '</ConsignmentNumber>';
    $req .= '   <ConsignmentDate>' . $order['pickup_datetime']['date'] . '</ConsignmentDate>';
    $req .= '   <SenderName>' . $pickupinfo['name'] . '</SenderName>';
    $order['pickup_address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['pickup_address1']);
    $req .= '   <SenderStreetAddress>' . $order['pickup_address1'] . '</SenderStreetAddress>';
    $req .= '   <SenderSuburb>' . $order['pickup_city'] . '</SenderSuburb>';
    $req .= '   <SenderPhone>' . $pickupinfo['mobile'] . '</SenderPhone>';
    $order['pickup_address2'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['pickup_address2']);
    $req .= '   <SenderState>' . $order['pickup_address2'] . '</SenderState>';
    $req .= '   <SenderPostcode>' . substr($order['pickup_pincode'], 0, 4) . '</SenderPostcode>';
    $req .= '<Pickup>Yes</Pickup>';
    $req .= '<Delivery>Yes</Delivery>';
    $req .= '   <DangerousGoods>' . $isDG . '</DangerousGoods>';
    $req .= '   <ReceiverName>' . $receiverinfo['name'] . '</ReceiverName>';
    $order['delivery_address1'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['delivery_address1']);
    $req .= '   <ReceiverStreetAddress>' . $order['delivery_address1'] . '</ReceiverStreetAddress>';
    $req .= '   <ReceiverSuburb>' . $order['delivery_city'] . '</ReceiverSuburb>';
    $order['delivery_address2'] = preg_replace('/&(?!#?[a-z0-9]+;)/', '&amp;', $order['delivery_address2']);
    $req .= '   <ReceiverState>' . $order['delivery_address2'] . '</ReceiverState>';
    $req .= '   <ReceiverPostcode>' . $order['delivery_pincode'] . '</ReceiverPostcode>';
    $req .= '   <ReceiverPhone>' . $receiverinfo['mobile'] . '</ReceiverPhone>';
    $req .= '   <ReceiverEmail>' . $receiverinfo['email'] . '</ReceiverEmail>';
    $req .= '   <Comments> No Split Deliveries Allowed </Comments>';
    $req .= '   <ChargeTo>' . $accountcode . '</ChargeTo>';
    $req .= '   <TotalWeight>' . $itemsweight . '</TotalWeight>';
    $req .= '   <CarrierService>' . $carrierService . '</CarrierService>';
    foreach ($cargos as $li) {
        $cargo_weight= number_format((float)round($li['weight'],2), 2, '.', '');
        $req .= '   <LoadDetails>';
        $req .= '       <ItemReference>' . $li['cargo_content'] . '</ItemReference>'; // goods desc
        $req .= '       <NumberOfUnits>' . $li['quantity'] . '</NumberOfUnits>';
        $req .= '       <LogisticUnit>' . $li['cargo_type'] . '</LogisticUnit>';
        $req .= '       <Weight>' . $cargo_weight . '</Weight>';
        $req .= '       <Length>' . round($li['length']) . '</Length>';
        $req .= '       <width>' . round($li['width']) . '</width>';
        $req .= '       <Height>' . round($li['height']) . '</Height>';
        $req .= '       <Cubic>' . $li['volume'] . '</Cubic>';
        $req .= '       <Barcode>' . $li['bar_code'] . '</Barcode>';
        $req .= '   </LoadDetails>';
    }
    if ($isDG == 'YES') {
        $req .= '   <DangerousGoodsValues>';
        $req .= '       <ShippingName></ShippingName>';
        $req .= '       <Class></Class>';
        $req .= '       <SubRisk></SubRisk>';
        $req .= '       <UNNo></UNNo>';
        $req .= '       <PackagingGroup></PackagingGroup>';
        $req .= '       <TypeOfPackage></TypeOfPackage>';
        $req .= '       <NoOfPackages></NoOfPackages>';
        $req .= '       <AggregateQuantity></AggregateQuantity>';
        $req .= '       <ContactName>' . $customerinfo['name'] . '</ContactName>';
        $req .= '       <ContactPhone>' . $customerinfo['phone'] . '</ContactPhone>';
        $req .= '   </DangerousGoodsValues>';
    }
    $req .= '</Consignment>';
    log_message("error", "border xml" . $req);
    $resname = date("Ymdhis");
    $filenm = $accountcode . "_beconsignment" . $resname . ".xml";
    $dom = new DOMDocument();
    $dom->preserveWhiteSpace = FALSE;
    $dom->loadXML($req);
    $dom->save('xml/borderapi/' . $filenm);

    $consignment_note=((isset($order_details['consignment_note'])) && (!empty($order_details['consignment_note'])))?$order_details['consignment_note']:0;
    $re_data = array(
        'filename' => $filenm,
        'vendor_id' => $order['vendor_id'],
        'request' => $req,
        'order_id' => $order['order_id'],
        'consignment_note' => $consignment_note,
        'order_row_id'=>$order_row_id
    );
    return $re_data;

}



if (! function_exists("conversationtocm")) {

    function conversationtocm($val, $unit)
    {
        if ($unit == 'M' || $unit == 'm') {
            $cm = 100; // 1 meters in cm
        } else if ($unit == 'Inches') {
            $cml = 2.54; // 1 inch in cm
        } else {
            $cm = 1;
        }
        $res = $val * $cm;
        return $res;
    }
}

if (! function_exists("checkborderCarrier")) {

    function checkborderCarrier($id)
    {
        $ci = &get_instance();
        $result = array();
        $res = $ci->db->select("name")
            ->from('tb_vendors')
            ->where(array(
            'id' => $id,
        ))->where_in('company_code', ["AUKN", "KNAU"])
            ->like(array(
            'name' => 'BORDER'
        ))
            ->get();
        if ($res) {
            if ($res->num_rows() > 0) {
                $result = $res->row_array();
            }
        }
        return $result;
    }
}
/*
 * BORDER EXPRESS request and response saved in log transactions
 */
if (! function_exists("borderedilogs")) {

    function borderedilogs($data)
    {
        $ci = &get_instance();
        $user_id = $ci->session->userdata('user_id')??"";
        $company_code = $ci->session->userdata('company_code')??"";
        $branch_code = $ci->session->userdata('branch_code')??"";
        if((empty($company_code)) || (empty($branch_code))){
           $ci->load->helper('bonds_helper');
           $session_data=get_session_data($data['order_row_id']);
           $company_code=$session_data['company_code']??"";
           $branch_code=$session_data['branch_code']??"";
           $user_id=$session_data['user_id']??"";
        }
        $ins_edi = $ins_obj_edi = array();
        $edi_id = $edi_name = $object_id = "";

        $edi_transactions = $ci->common->gettbldata(array(
            'txn_obj_id' => $data['order_id']
        ), 'txn_obj_id', 'tb_etn_edi_transactions', 0, 0);
        if (empty($edi_transactions)) {

            /*
             * Get edi_name from tb_edi_types table if edi name is not exists insert edi name
             */
              $vendor_name = "BORDER EXPRESS";
            $edi_types = $ci->db->select("id,edi_name")
                ->from('tb_edi_types')
                ->where(array(
                'status' => '1'
            ))
                ->like(array(
                'edi_name' => $vendor_name
            ))
                ->get();
            if ((! empty($edi_types)) && ($edi_types->num_rows() > 0)) {
                $edi_result = $edi_types->row_array();
                $edi_name = $edi_result['edi_name'];
                $edi_id = $edi_result['id'];
            } else {
                $edi_name = $vendor_name;
                $ins_edi['edi_name'] = $edi_name;
                $edi_id = $ci->common->insertTableData('tb_edi_types', $ins_edi);
            }
            /*
             * Get edi object from tb_edi_object_types table if edi object is not exists insert edi object
             */
            $object_types = $ci->db->select("id,obj_type_name")
                ->from('tb_edi_object_types')
                ->where(array(
                'status' => '1'
            ))
                ->like(array(
                'obj_type_name' => "order-id"
            ))
                ->get();
            if ((! empty($object_types)) && ($object_types->num_rows() > 0)) {
                $edi_obj_result = $object_types->row_array();
                $object_id = $edi_obj_result['id'];
            } else {
                $ins_obj_edi['obj_type_name'] = "order-id";
                $ins_obj_edi['description'] = "order-id";
                $object_id = $ci->common->insertTableData('tb_edi_object_types', $ins_obj_edi);
            }
            $Border_res = ($data['status'] == 1) ? 'Success' : 'Fail';

            $params = array(
                'edi_type' => 1, // '1->EDI Transport Order,2->EDI Status'
                'transaction_id' => time(),
                'edi_id' => $edi_id, // edi id based on name take it from tb_edi_types
                'edi_name' => $edi_name,
                'bounded_type' => 2, // '1->Inbound(partner => kN),2->Outbound (KN => partner)'
                'edi_format_type' => 'XML',
                'status' => $data['status'],
                'obj_type' => $object_id,
                'txn_obj_id' => $data['order_id'],
                'ref_value' => isset($data['consignment_note']) ? $data['consignment_note'] : 0,
                'user_id' => $user_id,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'edi_request' => $data['request'],
                'edi_response' => $Border_res
            );
            /* log_message */
            $ci->common->insertTableData('tb_etn_edi_transactions', $params);
        }
    }
}



