<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
function getHttpRequestConfig($useStaticProxy = false): array
{
    $req = [
        'follow_redirects' => true,
        'ssl_verify_peer' => false,
        'connect_timeout' => 100,
        'timeout' => 120,
    ];

    if (ENVIRONMENT !== 'development') {
        $req['proxy'] = $useStaticProxy ? VZEN_PROXY : PROXY_CONSTANT_HERE;
    }

    return $req;
}

if (!function_exists('ProcessCurl')) {
    function ProcessCurl($URL)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($URL);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array(
            'Content-Type' => 'application/json',
        ));
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return json_decode($response_body, true);
            } else {
                $error_msg = 'ProcessCurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ProcessCurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists("thirdpartyservicecurl")) {
    function thirdpartyservicecurl($url, $headers, $post, $httpRequestConfig = [])
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(array_merge(getHttpRequestConfig(), $httpRequestConfig));
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $responseBody = $response->getBody();
                if(isXML($responseBody)){
                    $xml = simplexml_load_string($responseBody);
                    $apiResponse = (array)$xml;
                }else{
                    $apiResponse = json_decode($responseBody,true);
                }
                return $apiResponse;
            } else {
                $error_msg = 'thirdpartyservicecurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase().'-url-'.$url;
                log_message("error",$error_msg);
                return array('_error'=>$error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'thirdpartyservicecurl  Error: ' . $e->getMessage();
            log_message("error",$error_msg);
            return array('_error'=>$error_msg);
        }
    }
}

if (!function_exists("thirdparty_curl_get")) {
    function thirdparty_curl_get($req_url,$headers) {
        $resp = "";
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($req_url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setHeader(array('cache-control: no-cache'));
        try{
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resp = $response->getBody();
            } else {
                $error_msg       = 'ruexpressservice Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ruexpressservice Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        $result = $resp;
        return $result;
    }
}
if (!function_exists("otmbookservicecurl")) {
    function otmbookservicecurl($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resulta  = $response->getBody();
                $resp = simplexml_load_string($resulta);
                $response1 = json_decode(json_encode($resp), true);
                return $response1;
            } else {
                $error_msg = 'otmbookservicecurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'otmbookservicecurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists("pushNotificationService")) {
    function pushNotificationService($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resulta = $response->getBody();
                return $resulta;
            } else {
                $error_msg = 'pushNotificationService Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return "";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'pushNotificationService  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return "";
        }
    }
}
if (!function_exists("shippeoservicecurl")) {
    function shippeoservicecurl($url, $headers)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $xml = "";
        $request->setBody($xml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return json_decode($response_body);
            } else {
                $error_msg = 'shippeoservicecurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'shippeoservicecurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}

if (!function_exists("executesmsservice")) {
    function executesmsservice(string $url): string
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $responseBody = $response->getBody();
                return $responseBody;
            } else {
                return 'executesmsservice Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            return 'executesmsservice  Error: ' . $e->getMessage();
        }
    }
}

if (!function_exists("googleshortenserviceurl")) {
    function googleshortenserviceurl($url, $apiurl, $enabledebug, $action, $data)
    {
        $action = (isset($action)) ? $action : 'shorten';
        $data   = (isset($data)) ? $data : array();
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        if ($action == 'shorten') {
            /* POST Url */
            $data['longUrl'] = $url;

            $request->setUrl($apiurl);
            $request->setHeader(array("Content-Type: application/json"));
            $request->setBody(json_encode($data));
            $request->setMethod(HTTP_Request2::METHOD_POST);
        } else if ($action == 'expand' or $action == 'analytics') {
            /* Get Url */
            $data['shortUrl'] = $url;
            $api_url = $apiurl . '&' . http_build_query($data);
            $request->setUrl($api_url);
            $request->setMethod(HTTP_Request2::METHOD_GET);
            if ($enabledebug) {
                echo $api_url . "<br />";
            }
        }
        $request->setConfig(getHttpRequestConfig());
        $xml = "";
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return json_decode($response_body);
            } else {
                $error_msg = 'googleshortenserviceurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'googleshortenserviceurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists("covidservicecurl")) {
    function covidservicecurl($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                $resulta       = str_replace("NaN", "null", $response_body);
                return json_decode($resulta, true);
            } else {
                $error_msg = 'covidservicecurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'covidservicecurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('ProcessGoogleAPICurl')) {
    function ProcessGoogleAPICurl($URL, $returnObject = false)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($URL);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array(
            'Content-Type' => 'application/json'
        ));
        /*$xml = "";
        $request->setBody($xml);*/
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return json_decode($response_body, !$returnObject);
            } else {
                $error_msg = 'ProcessGoogleAPICurl HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ProcessGoogleAPICurl Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('getdriverlocationbysms')) {
    function getdriverlocationbysms($post)
    {
        if (isset($post['authkey'])) {

            $serviceurl = $post['url'];
            $request1    = $post['data'];
            if ($post['reqtype'] == "json") {
                $request1 = json_encode($post['data']);
            }
            require_once './vendor/pear/http_request2/HTTP/Request2.php';
            $request = new HTTP_Request2();
            $request->setUrl($serviceurl);
            $request->setMethod(HTTP_Request2::METHOD_POST);
            $request->setConfig(getHttpRequestConfig());
            $request->setHeader(array('Content-Type: application/json', 'authkey: ' . $post['authkey']));
            $request->setBody($request1);
            try {
                $response = $request->send();
                if ($response->getStatus() == 200) {
                    $response_body = $response->getBody();
                    $resulta       = str_replace("NaN", "null", $response_body);
                    return json_decode($resulta, true);
                } else {
                    $error_msg = 'getdriverlocationbysms Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                    log_message("error", "1".$error_msg);
                    return array();
                }
            } catch (HTTP_Request2_Exception $e) {
                $error_msg = 'getdriverlocationbysms  Error: ' . $e->getMessage();
                log_message("error", $error_msg);
                return array();
            }
        }
    }
}
if (!function_exists('trainKeywordEntity')) {
    function trainKeywordEntity($entity, $value)
    {
        $data      = array("value" => $value);
        $postdata  = json_encode($data);
        $headers   = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Authorization: Bearer ' . CHATBOT_KEY;
        $url = 'https://api.wit.ai/entities/' . $entity . '/values';
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($postdata);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'trainKeywordEntity Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'trainKeywordEntity  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('sendchatbotmsgservice')) {
    function sendchatbotmsgservice($text)
    {
        $headers   = array();
        $headers[] = 'Content-Type: application/json';
        $headers[] = 'Accept: application/json';
        $headers[] = 'Authorization: Bearer ' . CHATBOT_KEY;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl('https://api.wit.ai/message?q=' . urlencode($text));
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $xml = "";
        $request->setBody($xml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'sendchatbotmsgservice HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return "";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'sendchatbotmsgservice Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return "";
        }
    }
}
if (!function_exists('offStreetParkingApi')) {
    function offStreetParkingApi($url)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $xml = "";
        $request->setBody($xml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'offStreetParkingApi HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return "";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'offStreetParkingApi Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return "";
        }
    }
}
if (!function_exists('getcontentfromservice')) {
    function getcontentfromservice($url)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $xml = "";
        $request->setBody($xml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'getcontentfromservice HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return "";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'getcontentfromservice Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return "";
        }
    }
}
if (!function_exists('getetnpriceinfo')) {
    function getetnpriceinfo($url, $jsoninput, $sessdata)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader();
        $request->setBody();
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'getetnpriceinfo Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'getetnpriceinfo  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('etntestlogin')) {
    function etntestlogin($url, $post = array())
    {
        $cookfile = './assets/tmp/cookies.txt';
        $input    = json_encode($post);
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setCookieJar($cookfile);
        $request->setHeader(array(
            "Accept: application/json, text/plain, */*",
            "Authorization: Basic a3BtZy1jbGllbnQ6S1BNR0AxMjM=",
            "Content-Type: application/json",
        ));
        $request->setBody($input);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $result               = $response->getBody();
                $res                  = json_decode($result, true);
                $readfile             = @file_get_contents($cookfile);
                $res['refresh_token'] = $res['access_token'] = "";
                $cookdata             = explode("\n", $readfile);
                if (!empty($cookdata)) {
                    foreach ($cookdata as $resarr) {
                        if (strpos($resarr, 'refresh_token') !== false) {
                            $chk = explode("refresh_token", $resarr);
                            $res['refresh_token'] = trim($chk[1]);
                        }
                        if (strpos($resarr, 'access_token') !== false) {
                            $chk1 = explode("access_token", $resarr);
                            $res['access_token'] = trim($chk1[1]);
                        }
                    }
                }
                unlink($cookfile);
                return $res;
            } else {
                $error_msg = 'etntestlogin HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'etntestlogin Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('gettekomloginapi')) {
    function gettekomloginapi($url, $post)
    {
        $cookfile = './assets/tmp/cookies2.txt';
        $postData = '';
        foreach ($post as $key => $val) {
            $postData .= urlencode($key) . '=' . urlencode($val) . '&';
        }
        $postData = rtrim($postData, '&');
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setCookieJar($cookfile);
        $request->setHeader(array(
            "Content-Type: application/x-www-form-urlencoded",
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.106 Safari/537.36",
            "Accept-Language:en-US,en;q=0.5",
        ));
        $request->setBody($postData);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $result = $response->getBody();
                $xml                = simplexml_load_string($result);
                $json               = json_encode($xml);
                $res                = json_decode($json, true);
                $readfile           = file_get_contents($cookfile);
                $cookdata           = explode("\n", $readfile);
                $res['cookiesdata'] = $cookdata;
                return $res;
            } else {
                $error_msg = 'gettekomloginapi HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'gettekomloginapi Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('gettekomvehiclelistapi')) {
    function gettekomvehiclelistapi($url, $post)
    {
        $cookfile = './assets/tmp/cookies2.txt';
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setCookieJar($cookfile);
        $request->setHeader();
        $request->setBody("");
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $result = $response->getBody();
                return $result;
            } else {
                $error_msg = 'gettekomvehiclelistapi HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'gettekomvehiclelistapi Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists('gettekomvehiclelocapi')) {
    function gettekomvehiclelocapi($url, $post)
    {
        $cookfile = "./assets/tmp/cookies2.txt";
        $postData = '';
        foreach ($post as $key => $val) {
            $postData .= $key . '=' . $val . '&';
        }
        $postData = rtrim($postData, '&');
        $cookfile = './assets/tmp/cookies2.txt';
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setCookieJar($cookfile);
        $request->setHeader(array(
            "Content-Type: application/x-www-form-urlencoded",
        ));
        $request->setBody("");
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $result = $response->getBody();
                $xml    = simplexml_load_string($result);
                $json   = json_encode($xml);
                $res    = json_decode($json, true);
                return $res;
            } else {
                $error_msg = 'gettekomvehiclelocapi HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'gettekomvehiclelocapi Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}
if (!function_exists("bordercarriercurl")) {
    function bordercarriercurl($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resulta = $response->getBody();
                return $resulta;
            } else {
                $error_msg = 'bordercarriercurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'bordercarriercurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}

if (!function_exists("bondscarriercurl")) {
    function bondscarriercurl($url,$headers,$post) {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $filename = $post['filename'];
        $filenm = $post['filenm'];
        $request->addUpload('uploadfile', $filename, $filenm, 'application/xml');
        $res = "";
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $res = $response->getBody();
            } else {
                $msg = 'ats_soap_curl Unexpected HTTP status : ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ats_soap_curl Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        return $res;
    }
}

if (!function_exists("ats_curl")) {
    function ats_curl($url, $headers, $post)
    {

        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl("http://dehamsl2973.int.kn/soap/SoapService.php");
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array("Content-Type: application/xml"));
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $res = $response->getBody();
                return $res;
            } else {
                $error_msg = 'ats_curl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return "0";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ats_curl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return "0";
        }
    }
}

if (!function_exists("requestborderapi")) {
    function requestborderapi($apiurl) {
        $ci = &get_instance();
        $ci->load->model("common");
        $tokenres = $ci->common->gettblrowdata(array('req_type'=>'token'),'response','tb_bexedi',0,0);
        if(!empty($tokenres)){
            $tokeninfo = (array)(json_decode($tokenres['response']));
            $token = $tokeninfo['access_token'];
            $headers = array('Authorization: bearer '.$token);
            require_once './vendor/pear/http_request2/HTTP/Request2.php';
            $request = new HTTP_Request2();
            $request->setUrl($apiurl);
            $request->setMethod(HTTP_Request2::METHOD_GET);
            $request->setConfig(getHttpRequestConfig());
            $request->setHeader($headers);
            try{
                $response = $request->send();
                if ($response->getStatus() == 200){
                    $res = $response->getBody();
                }else{
                    $res = "401";
                    getbordertoken();
                }
            }catch(HTTP_Request2_Exception $e){
                getbordertoken();
                $res = 'expired';
            }
        } else {
            getbordertoken();
            return 'expired';
        }
        return $res;
    }
}

if (!function_exists("getbordertoken")) {
    function getbordertoken() {
        $ci = &get_instance();
        $tokenurl = BORDER_API.'/token';
        $headers = array('Content-Type:  application/x-www-form-urlencoded');
        $postdata = 'grant_type=client_credentials&client_id='.BORDER_CLIENTID.'&client_secret='.BORDER_CLIENT_SECRET;
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($tokenurl);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($postdata);
        try{
            $response = $request->send();
            if ($response->getStatus() == 200){
                $res = $response->getBody();
                $response = (array)(json_decode($res));
                $dt = date('Y-m-d H:i:s');
                $insert = array('req_type'=>'token','response'=>$res,'apiurl'=>$tokenurl,'res_status'=>'success','status'=>1,'updatedon'=>$dt);
                $ci->load->model("common");
                $check = $ci->common->gettblrowdata(array('req_type'=>'token'),'response','tb_bexedi',0,0);
                if(!empty($check)){
                    $id  = $ci->common->updatetbledata('tb_bexedi',array('response'=>$insert['response']),array('req_type'=>'token'));
                } else {
                    $insert['createdon'] = $dt;
                    $id = $ci->common->insertTableData('tb_bexedi',$insert);
                }
            }
        }catch(HTTP_Request2_Exception $e){
            $res1 = 'expired';
        }
        return true;
    }
}

if (!function_exists("ats_soap_curl")) {
    function ats_soap_curl(string $xml): HTTP_Request2_Response
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(ATS_SERVICE);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader([
            'Content-Type' => 'application/xml',
        ]);
        $request->setBody($xml);
        try {
            return $request->send();
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }
}
/*
 * BiteTransit and Vozovo EDI Curls
 */
if (!function_exists("bitetransit_transport_order_curl")) {
    function bitetransit_transport_order_curl($request_format)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(BITE_TRANSPORT_ORDER);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig(true));
        $error_msg = "";
        $postdata  = json_encode($request_format);
        $request->setHeader(array(
            'Content-Type' => 'application/json',
        ));
        $request->setBody($postdata);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
            } else {
                $error_msg = 'bitetransit_transport_order_curl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'bitetransit_transport_order_curl Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        if (isset($response_body)) {
            $response = $response_body;
        }
        return array(
            'response' => $response,
            'err'      => $error_msg,
        );
    }
}
if (!function_exists("vozovoz_transport_order_curl")) {
    function vozovoz_transport_order_curl($request_format)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(VOZOVOZ_TRANSPORT_ORDER . VOZOVOZ_TOKEN);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $error_msg = "";
        $postdata  = json_encode($request_format, JSON_UNESCAPED_UNICODE);
        $request->setHeader(array(
            'Content-Type' => 'application/json',
        ));
        $request->setBody($postdata);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                // return $response_body;
            } else {
                $error_msg = 'vozovoz_transport_order_curl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                // return "0";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'vozovoz_transport_order_curl Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            // return "0";
        }
        if (isset($response_body)) {
            $response = $response_body;
        }
        return array(
            'response' => $response,
            'err'      => $error_msg,
        );
    }
}
if (!function_exists("vozovoz_status_tracking_curl")) {
    function vozovoz_status_tracking_curl($request_format)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(VOZOVOZ_TRANSPORT_ORDER . VOZOVOZ_TOKEN);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $error_msg = "";
        $postdata  = json_encode($request_format, JSON_UNESCAPED_UNICODE);
        $request->setHeader(array(
            'Content-Type' => 'application/json',
        ));
        $request->setBody($postdata);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                // return $response_body;
            } else {
                $error_msg = 'vozovoz_status_tracking_curl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'vozovoz_status_tracking_curl Error: ' . $e->getMessage();
        }
        if (isset($response_body)) {
            $response = $response_body;
        }
        return array(
            'response' => $response,
            'err'      => $error_msg,
        );
    }
}
if (!function_exists("skif_edi_curl")) {
    function skif_edi_curl($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $response = json_encode(array());
        $error_msg = "";
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response1 = $request->send();
            if ($response1->getStatus() == 200) {
                $response_body = $response1->getBody();
            } else {
                $error_msg = 'skif_edi_curl Unexpected HTTP status: ' . $response1->getStatus() . ' ' . $response1->getReasonPhrase();
                log_message("error", $error_msg);
                $response = json_encode(array("error" => $error_msg));
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'skif_edi_curl Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            $response = json_encode(array("error" => $error_msg));
        }
        if (isset($response_body)) {
            $response = $response_body;
        }
        return json_decode($response, true);
    }
}
if (!function_exists("ruexpressservice")) {
    function ruexpressservice($req, $server_url, $methos, $auth, $aplicaron_type)
    {
        $xml_post_string = "";
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($server_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array(
            'name'          => $methos,
            'Authorization' => $auth,
            'Content-Type'  => $aplicaron_type,
        ));
        $request->setBody($req);
        try{
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $xml_post_string = $response->getBody();
            } else {
                $xml_post_string = "error";
                $error_msg       = 'ruexpressservice Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $xml_post_string = 'ruexpressservice Error: ' . $e->getMessage();
            log_message("error", $xml_post_string);
        }
        return $xml_post_string;
    }
}
if (!function_exists("bonds_copy_image")) {
    function bonds_copy_image($url) {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $poddata  = '';
        $request = new HTTP_Request2();
        $request->setConfig(getHttpRequestConfig());
        $request->setUrl($url);
        $poddata = $request->send()->getBody();
        return $poddata;
    }
}
if (!function_exists("curl_post")) {
    function curl_post($post_array, $url, $manual_flag = 1) {
        error_reporting(0);
        switch ($manual_flag) {
            case "0":
                $base_url = site_url('SecureLink/' . $url);
                break;
            default:
                $base_url = site_url('Driverapiv3/' . $url);
                break;
        }
        $data = $post_array;
        $resp = "";
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($base_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        /*$request->setConfig(getHttpRequestConfig());*/
        $request->setHeader(array('Content-Type: multipart/form-data'));
        $request->setBody($data);
        try{
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resp = $response->getBody();
            } else {
                $error_msg       = 'ruexpressservice Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ruexpressservice Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        $result = json_decode($resp);
        return $result;
    }
}
if (!function_exists("curl_get")) {
    function curl_get($req_url) {
        $resp = "";
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($req_url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array('cache-control: no-cache'));
        try{
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resp = $response->getBody();
            } else {
                $error_msg       = 'ruexpressservice Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ruexpressservice Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        $result = $resp;
        return $result;
    }
}

if (!function_exists("process_posthttprequest")) {
    function process_posthttprequest($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resulta = $response->getBody();
                return $resulta;
            } else {
                $error_msg = 'process post http request Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'process post http request  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}

     if (!function_exists("share_secure_link")) {
        function share_secure_link($request_body){
            require_once './vendor/pear/http_request2/HTTP/Request2.php';
            $request = new HTTP_Request2();
            $request->setUrl(RETARUS_SMS_API);
            $request->setMethod(HTTP_Request2::METHOD_POST);
            $conn_config=getHttpRequestConfig();
            $conn_config['connect_timeout'] = 10; //maximum allsowed sec to connect api
            $conn_config['timeout'] = 30; // maximum waiting time in sec to receive packets
            $request->setConfig($conn_config);
            $error_msg = '';
            $response = array();
            $postdata  = json_encode($request_body);
            $request->setHeader(array(
                'cache-control' => 'no-cache',
                'content-type' => 'application/json',
                'authorization' => 'Basic '.base64_encode(RETARUS_SMS_USERNAME.':'.RETARUS_SMS_PASSWORD)
            ));
            $request->setBody($postdata);
            try {
                $response = $request->send();
                $response_code=$response->getStatus();
                if ($response_code >=200 && $response_code <=299) {
                    $response_body = $response->getBody();
                } else {
                    $error_msg = 'Message Sending Status:' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                }
            } catch (HTTP_Request2_Exception $e) {
                $error_msg = 'Message Sending Status: ' . $e->getMessage();
            }
            if (isset($response_body)) {
                $response = $response_body;
            }
            return array(
                'response' => $response,
                'err'      => $error_msg,
            );
        }
    }
 
if (!function_exists("shippeo_positions_curl")) {
    function shippeo_positions_curl($request_format, $auth_token) {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(SHIPPEO_POSITIONS);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $error_msg = "";
        $postdata = json_encode($request_format, JSON_UNESCAPED_UNICODE);
        $request->setHeader(array(
            'Authorization' => 'Bearer ' . $auth_token,
            'Content-Type' => 'application/json'
        ));
        $request->setBody($postdata);
        try {
            $response = $request->send();
            $status_flag = 0;
            $status = $response->getStatus();
            if ($status >= 200 && $status <= 299) {
                $status_flag = 1;
            }
            $response_body = json_decode($response->getBody());
        } catch (HTTP_Request2_Exception $e) {
            $response_body = 'shippeo_position_curl Error: ' . $e->getMessage();
        }
        return array('status'=>$status_flag,'response'=>$response_body);
    }
}

if (!function_exists("shippeo_status_curl")) {
    function shippeo_status_curl($request_format, $auth_token, $edi_ref_value = '')
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(SHIPPEO_EVENTS_PREFIX . $edi_ref_value . SHIPPEO_ORGANIZATION_SUFFIX . SHIPPEO_ORG_NUMBER);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setBody(json_encode($request_format, JSON_UNESCAPED_UNICODE));
        $request->setHeader(array(
            'Authorization' => 'Bearer ' . $auth_token,
            'Content-Type' => 'application/json'
        ));
        return $request->send();

    }
}
/* ecom shipment tracking api service call in xml format */
if (!function_exists("ecomtrackservicecurl")) {
    function ecomtrackservicecurl($url, $headers, $post, $httpRequestConfig = [])
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(array_merge(getHttpRequestConfig(), $httpRequestConfig));
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response_body = $response->getBody();
                return $response_body;
            } else {
                $error_msg = 'ecomtrackservicecurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error",$error_msg);
                return "";
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'ecomtrackservicecurl  Error: ' . $e->getMessage();
            log_error('Uniqlo Cronjob ecomShipmentTracking - Error: ' . $error_msg);
            return "";
        }
    }
}

/* function to replace the ecomtrackservicecurl() and possibly other curl using HTTP_Request2 calls */
if(!function_exists('curlRequestor')) {
    function curlRequestor(
        string $uri,
        ?string $method = 'GET',
        ?string $data = '',
        string $proxy = '',
        array $headers = [],
        ?object $retryFunction = null,
        ?object $delayFunction = null
    ): array {
        $headersReceived = '';
        $retry = false;
        $iterations = 0;
        $allowedMethods = ['GET', 'POST', 'PUT', 'PATCH', 'DELETE'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if($proxy != "") {
            curl_setopt($ch, CURLOPT_PROXY, $proxy);
        }
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_URL, $uri);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt(
            $ch,
            CURLOPT_HEADERFUNCTION,
            function ($curl, $header) use (&$headersReceived) {
                $len = strlen($header);
                $headersReceived .= $header;
                return $len;
            }
        );
        if(isset($method) && in_array($method, $allowedMethods)) {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        }
        if(isset($data)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        }

        do {
            $headersReceived = '';
            if (is_callable($delayFunction)) {
                $delay = $delayFunction->__invoke($iterations);
                usleep($delay);
            }

            $body = curl_exec($ch);
            $headersSent = curl_getinfo($ch, CURLINFO_HEADER_OUT);
            $responseCode = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
            $curlError = curl_errno($ch);
            $curlErrorMessage = curl_error($ch);
            $iterations++;

            if (is_callable($retryFunction)) {
                $retry = $retryFunction->__invoke($iterations, $curlError, $responseCode);
            }
        } while ($retry);

        curl_close($ch);

        return [
            'body'           => $body,
            'reqHeaders'     => $headersSent,
            'respHeaders'    => $headersReceived,
            'respCode'       => $responseCode,
            'curlError'      => $curlErrorMessage,
            ];
    }
}

//retry decider for curlRequestor()
if(!function_exists('retryDecider')) {
    function retryDecider()
    {
        return function ($retries, $error, $status = null): bool {
            //exit when retry number exceeds value
            if ($retries >= 3) {
                return false;
            }
            //retry on connection errors
            if ($error > 0) {
                return true;
            }
            //retry on server errors
            if ($status >= 400) {
                return true;
            }
            return false;
        };
    }
}

//retry delay calculation for curlRequestor
if(!function_exists('retryDelay')) {
    function retryDelay()
    {
        return function ($noOfRetries): int {
            //microseconds as a base for calculation
            return 1000000 * $noOfRetries;
        };
    }
}

if (!function_exists("mudita_requestaccesstoken")) {
    function mudita_requestaccesstoken($req_url) {
        $response = "";
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($req_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader(array('cache-control: no-cache'));
        try{
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $response = $response->getBody();
            } else {
                $error_msg       = 'Mudita Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error", $error_msg);
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'Mudita Error: ' . $e->getMessage();
            log_message("error", $error_msg);
        }
        return json_decode($response, true);
    }
}


if (!function_exists("nicplace_request_curl")) {
  function nicplace_request_curl($method, $url, $post = [], $http_status = false): array
  {
    require_once './vendor/pear/http_request2/HTTP/Request2.php';
    $headers = [
      'Content-Type: application/json',
      'nic-api-key: ' . nicplace_api_key,
      'portalId: ' . nicplace_portalId
    ];
    $request = new HTTP_Request2();
    $request->setUrl($url);
    $request->setMethod($method);
    $request->setConfig(getHttpRequestConfig());
    $request->setHeader($headers);
    if (!empty($post)) {
      $request->setBody(json_encode($post));
    }
    try {
      $response = $request->send();
      if ($response->getStatus() && $response->getStatus() < 300) {
        $success_msg = 'ProcessCurl Success HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase() . ' body => ' . $response->getBody() . ' method :: ' . $method;
        if ($http_status) {
          $return = [
            'http_status'   => $response->getStatus(),
            'response_body' => json_decode($response->getBody(), true)
          ];
        } else {
          $return = (array) json_decode($response->getBody(), true);
        }
      } else {
        $error_msg = 'ProcessCurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase() . PHP_EOL . $url . PHP_EOL . ' body => ' . $response->getBody() . ' method :: ' . $method;
        log_error("Nicplace_l (284) >> nicplace_curl >> error occurred " . $error_msg);
        $return = [
          'http_status'   => $response->getStatus(),
          'response_body' => json_decode($response->getBody(), true)
        ];
      }
    } catch (HTTP_Request2_Exception $e) {
      log_error('nicplace $e->getMessage() >>> ' . $e->getMessage());
      $return = [
        'http_status'   => 400,
        'response_body' => ['error' => $e->getMessage()]
      ];
    }
    return $return;
  }
}

if (!function_exists("rusExpressStatusCurl")) {
    function rusExpressStatusCurl(string $requestXml, string $orderId): array
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $ci = &get_instance();
        $ci->load->library("edi_logger");
        $responseXml = "";
        $request = new HTTP_Request2();
        $request->setUrl(RUEXP_SERVER_IP_STATUS);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig());
        $request->setHeader([
            'name' => 'Tracking',
            'Authorization' => 'Basic S3VlaG5lK05hZ2VsOjExMQ==',
            'Content-Type' => 'application/xml',
        ]);
        $request->setBody($requestXml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $responseXml = $response->getBody();
                $status = 'Success';
            } else {
                log_message(
                    'error',
                    'RusExpress Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase()
                );
                $status = 'Error';
            }
        } catch (HTTP_Request2_Exception $e) {
            log_message('error', 'Error: ' . $e->getMessage());
            $status = 'Error';
        }
        $ci->edi_logger->log_ruexp_order(1, $requestXml, $responseXml, $orderId, 2);
        $xmlString = str_replace('m:', '', $responseXml);
        return ['status' => $status, 'response' => json_decode(json_encode($xmlString), true)];
    }
}

if (!function_exists("rusExpressOrder")) {
    function rusExpressOrder(string $requestXml): array
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl(RUEXP_SERVER_IP_SAVEORDER);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(getHttpRequestConfig(true));
        $request->setHeader([
            'name' => 'SaveOrder',
            'Authorization' => 'Basic S3VlaG5lK05hZ2VsOjExMQ==',
            'Content-Type' => 'text/html'
        ]);
        $request->setBody($requestXml);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $result = $response->getBody();
                $status = 'Success';
            } else {
                $result = 'rusExpressOrder Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                $status = 'Error';
            }
        } catch (HTTP_Request2_Exception $e) {
            $result = 'rusExpressOrder error: ' . $e->getMessage();
            $status = 'Error';
        }
        return ['status'=> $status,'result' => $result];
    }
}
/* validate the string xml or not */
if (!function_exists("isXml")) {
    function isXml(string $value): bool
    {
        $prev = libxml_use_internal_errors(true);

        $doc = simplexml_load_string($value);
        $errors = libxml_get_errors();

        libxml_clear_errors();
        libxml_use_internal_errors($prev);

        return $doc && empty($errors) !== false;
    }
}

if (!function_exists("thirdpartyotmservicecurl")) {    
    function thirdpartyotmservicecurl($url, $headers, $post)
    {
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setHeader($headers);
        $request->setBody($post);
        try {
            $response = $request->send();
            if ($response->getStatus() == 200) {
                $resulta = $response->getBody();
                /*log_message('error', "resulta: " . $resulta);
                $resp = simplexml_load_string($resulta);
                log_message('error', "resp: " . $resp);
                $response1 = json_decode(json_encode($resp), true);
                log_message('error', "$response: " . $response1);*/
                log_message('error', "response: " . $resulta);
                return $resulta;
            } else {
                $error_msg = 'otmstatuscurl Unexpected HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                return array();
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'otmstatuscurl  Error: ' . $e->getMessage();
            log_message("error", $error_msg);
            return array();
        }
    }
}

