<?php
if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

function ftpConfig(): array
{
    return [
        'OUTBOUND_PATH' => SE_OUTBOUND_PATH,
        'BACKUP_PATH' => SE_BACKUP_PATH,
        'SERVER_IP' => SE_SERVER_IP,
        'USERNAME' => SE_USERNAME,
        'PASSWORD' => SE_PASSWORD,
    ];
}

function statusCodes(string $status): array
{
     switch ($status) {
        case 'ORIGIN GATE IN':
            $status_code = '0420';
            $status_type = 'P';
            $status_id = '2';
            $stage = 'ORIGIN GATE IN';
        case 'PICKUP':
            $status_code = '0500';
            $status_type = 'P';
            $status_id = '1';
            $stage = 'PICKUP';
            break;
        case 'ORIGIN GATE OUT':
            $status_code = '0191';
            $status_type = 'P';
            $status_id = '3';
            $stage = 'ORIGIN GATE OUT';
            break;
        case 'IN TRANSIT':
            $status_code = '1550';
            $status_type = 'P';
            $status_id = '4';
            $stage = 'IN TRANSIT';
            break;
        case 'DESTINATION GATE IN':
            $status_code = '0192';
            $status_type = 'D';
            $status_id = '2';
            $stage = 'DESTINATION GATE IN';
            break;
        case 'DELIVERY':
            $status_code = '3000';
            $status_type = 'D';
            $status_id = '3';
            $stage = 'DELIVERY';
            break;
        case 'DESTINATION GATE OUT':
            $status_code = '2300';
            $status_type = 'D';
            $status_id = '1';
            $stage = 'DESTINATION GATE OUT';
            break;
        default:
            $status_code = '';
            $status_type = '';
            $status_id = '';
            $stage = '';
    }
    return [
        'status_code' => $status_code,
        'status_type' => $status_type,
        'status_id' => $status_id,
        'stage' => $stage,
    ];

}

function statusCodesList(): array
{
	return [
        'ORIGIN GATE IN',
        'PICKUP',
        'ORIGIN GATE OUT',
        'IN TRANSIT',
        'DESTINATION GATE IN',
        'DELIVERY',
        'DESTINATION GATE OUT'
   ];
}

function openBoxcheckCustomerIdvalid(int $id, string $type): bool
{
    $ci = &get_instance();
    $ci->load->model(['common', 'OpenboxModel']);
    $ci->load->helper('Log');
    $customer_id = 0;
    if ($type == 'orderid') {
        $checkCustomer = $ci->common->gettblrowdata(['id' => $id, "status <>" => 0], 'customer_id,company_code,branch_code', 'tb_orders', 0, 0);
    } else {
        $checkCustomer = $ci->common->gettblrowdata(['trip_id' => $id, "status <>" => 0], 'customer_id,company_code,branch_code', 'tb_orders', 0, 0);
    }
    $company_code = "";
    if (count($checkCustomer) > 0) {
        $customer_id = $checkCustomer['customer_id'];
        $company_code = $checkCustomer['company_code'];

    }
    if ($customer_id == $ci->OpenboxModel->openBoxUserId() && $company_code == "UKKN-CG") {
        return true;
    } else {
        log_error("Open-box-info: customer id or company code or branch code miss match.");
        return false;
    }
}
