<?php

if ( ! function_exists('epod_as_html_to_pdf') )
{
    function epod_as_html_to_pdf(stdClass $epod, string $style = ''): string
    {
        $ext = pathinfo($epod->imgpath, PATHINFO_EXTENSION);

        switch ($ext) {
            case 'jpl':
                $style = 'width: 40px;height: 40px;margin-left: 15px;margin-bottom: 10px;';
                $imgLink = "./assets/img/txt-icon.png";
                break;
            case 'pdf':
                $style = 'width: 40px;height: 40px;margin-left: 15px;margin-bottom: 10px;';
                $imgLink = "./assets/img/pdf-icon.png";
                break;
            default:

                $path = '/var/www/poduploads/';

                try {
                    
                    $newFilename = str_replace(' ', '-', $epod->imgpath);

                    if ($newFilename !== $epod->imgpath) {

                        log_message('error', 'epod_helper is about to filename fix for id: '.$epod->id);
                        log_message('error', 'epod_helper filename: '.$epod->imgpath .' --> '.$newFilename);

                        copy($path . $epod->imgpath, $path . $newFilename);
                        $epod->imgpath = $newFilename;

                        $ci = &get_instance();
                        $ci->db->where('id', $epod->id)->limit(1);
                        $ci->db->update("tb_pod_uploads", ['imgpath' => $newFilename]);
                    }
                }   catch (Exception $e) {
                    log_message('error', 'epod_helper failed : '.$e->getMessage());
                }

                $imgLink = $path . $epod->imgpath;
        }

        $url = (base_url() === 'https:/' ? SITEURL .'/' : base_url()) . 'downloadEpod/safelink/' . $epod->hash . '.epod';

        return '<a target="_blank" href="'. $url .'">'.
            '<img style="'. $style .'" title="'. $url .'" src="'. $imgLink .'">'.
            '</a>';
    }

    function validatePictures(string $imageName): bool
    {
        $extension = pathinfo($imageName, PATHINFO_EXTENSION);
        if (!in_array($extension, ['jpl', 'pdf'])) {
            $info = @getimagesize('/var/www/poduploads/' . $imageName);
            $bits = $info['bits'] ?? 0;
            if ($bits == 0) {
                $status = false;
            }
        }
        return $status ?? true;
    }
}
