<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

if (!function_exists('getLocationName')) {
    function getLocationName($lat, $lng)
    {
        if (!$lat || !$lng) {
            return '';
        }

        $ci = &get_instance();
        $chkdb = $ci->db->select("name1")
            ->get_where("tb_location_data",[
                "lat" => trim($lat),
                "lng" => trim($lng)
            ],1,0);

        if($chkdb->num_rows()>0){
            return str_replace(",", ", ", $chkdb->row()->name1);
        }
        if ($ci->session->userdata('company_code') === "CNKN") {
            return getLocationNameByHereMap($lat, $lng);
        }

        return getLocationNameByGoogleMap($lat, $lng);
    }
}

if (!function_exists('getLocationNameByGoogleMap')) {
    function getLocationNameByGoogleMap($lat, $lng)
    {
        $ci = &get_instance();
        $ci->load->driver('cache', ['adapter' => 'redis', 'backup' => 'file']);
        $source = "{$lat},{$lng}";
        $cacheKey = 'latlong:' . hash('sha256', $source);
        if ($cachedResults = $ci->cache->get($cacheKey)) {
            return $cachedResults;
        }

        $databaseResults = $ci->db->select('name1, lat, lng')
            ->where(['source' => $source])
            ->or_where([
            'lat' => $lat,
            'lng' => $lng
        ])->limit(1)->get('tb_location_data');

        if ($databaseResults->num_rows() > 0) {
            $results = $databaseResults->row()->name1;
            $ci->cache->save($cacheKey, $results, 36000);
            return $results;
        }

        $url = "https://maps.googleapis.com/maps/api/geocode/json?latlng=" . trim($lat) . ',' . trim($lng) . "&key=" . GOOGLE_BKND_API_KEY;
        $result = ProcessGoogleAPICurl($url);

        if (isset($result['status']) && $result['status'] === 'OK') {
            $name = isset($result["results"][0]["formatted_address"]) ? $result["results"][0]["formatted_address"] : "";

            $name2 = $country = "";
            if (isset($result["results"][0]["address_components"])) {
                $name2 = isset($result["results"][0]["address_components"][1]['long_name']) ? $result["results"][0]["address_components"][1]['long_name'] : "";
                if ($name2 != "") {
                    $name2 = preg_replace('/[^a-zA-Z0-9-_\.,]/', '', $name2);
                }
            }

            foreach ($result['results'][0]['address_components'] as $googleAddressComponent) {
                if (in_array('country', $googleAddressComponent['types'])){
                    $country = $googleAddressComponent['short_name'];
                    break;
                }
            }

            if ($name != "") {
                $name = preg_replace('/[^a-zA-Z0-9-_\.,]/', '', $name);
                $ins = [
                    "name1" => $name,
                    "name2" => $name2,
                    "country" => $country,
                    "lat" => trim($lat),
                    "lng" => trim($lng),
                    'source' => $source
                ];
                $ci->db->insert("tb_location_data", $ins);
            }
            $name = str_replace(",", ", ", $name);
            $ci->cache->save($cacheKey, $name, 36000);
            return $name;
        }

        $ci->cache->save($cacheKey, '-', 36000);
        return "Google Map API Return Empty Response Relating To The Coordinates" . trim($lat) . ',' . trim($lng);
    }
}

if (!function_exists('getLocationNameByHereMap')) {
    function getLocationNameByHereMap($lat, $lng)
    {
        $ci   = &get_instance();
        $url = "https://reverse.geocoder.hereapi.cn/6.2/reversegeocode.json?app_id=".CHINA_HERE_MAP_API_ID."&app_code=".CHINA_HERE_MAP_API_CODE."&language=eng&mode=retrieveAddresses&prox=".trim($lat).','.trim($lng).",250";
        $result = ProcessGoogleAPICurl($url);
        if (isset($result['Response']['View'][0])) {
                        $location= $result['Response']['View'][0]['Result'][0]['Location']["Address"];
            $label=$location['Label'] ?? '' ;
            $state=$location['State'] ?? '' ;
            $city=$location['City'] ?? '' ;
            $district=$location['District'] ?? '' ;
            $street=$location['Street'] ?? '' ;
            $houseNumber=$location['HouseNumber'] ?? '' ;
            $countryName=$location['AdditionalData'][0]['value'] ?? '';
            $stateName=$location['AdditionalData'][1]['value'] ?? '';
            $locAddress = implode(', ', [$houseNumber, $street, $district, $state, $countryName]);
			$name = $label ?? $locAddress;
            if ($name != "") {
                $ins = array("name1"=>$name,"name2"=>$name,"lat"=>trim($lat),"lng"=>trim($lng));
                $ci->db->insert("tb_location_data",$ins);
                return $name;
            }
            return getLocationNameByGoogleMap($lat, $lng);
        }

        return getLocationNameByGoogleMap($lat, $lng);
    }
}

if (!function_exists('getShiftByTrip')) {
    function getShiftByTrip($trip)
    {
        $ci = &get_instance();
        $curtz = $ci->session->userdata("usr_tzone")['timezone'];
        $ci->db->select("s.id,convertToClientTZ(s.startdate,'".$curtz."') as stime,convertToClientTZ(s.enddate,'".$curtz."') as etime,t.splace,t.eplace,s.empshift_start,convertToClientTZ(s.startdate,'".$curtz."') as startdate,convertToClientTZ(s.enddate,'".$curtz."') as enddate,s.shipmentid");
        $ci->db->from('tb_shifts s');
        $ci->db->join('tb_trips t', 's.id=t.shift_id', 'INNER');
        $ci->db->where('t.id', $trip);
        $ci->db->limit(1);
        $query = $ci->db->get()->row_array();
        return $query;
    }
}

function getOrderIds(int $stop_id): string
{
    $ci = &get_instance();
    $query = $ci->db->query(
        "SELECT
    e.order_id
    FROM tb_employee e
    LEFT JOIN tb_orders o ON o.order_id = e.order_id
    WHERE
    o.shift_id > ? AND 
    (
      stop_id = ?
      OR drop_stopid = ?
    )
    AND e.status = ?
    AND o.status IN ?
    ",
        [0,$stop_id, $stop_id, 1, [1, 2]]
    );
    if ($query->num_rows() > 0) {
        foreach ($query->result_array() as $row) {
            $orderIds[] = $row['order_id'];
        }
    }
    return isset($orderIds) ? implode(', ', $orderIds) : '';
}
function getOccupancy($shipment_id)
{
    $ci = &get_instance();
    $sv = $ci->db->select('vehicle_id')->where(array("shft_id" => $shipment_id, "status" => "1"))->get("tb_shft_veh");
    if ($sv->num_rows() > 0) {
        $vehicle_id = $sv->row()->vehicle_id;
        $vehicle = $ci->db->select("truck_capacity")->get_where("tb_trucks_data",array("id" => $vehicle_id),1,0);
        if($vehicle->num_rows()>0){
            $truck_capacity = $vehicle->row()->truck_capacity;
            $act_capacity = $ci->db->query("SELECT IFNULL(SUM(capacity),0) as act_capacity FROM tb_employee WHERE shift_id = $shipment_id AND status = '1'")->row()->act_capacity;
            if ($truck_capacity == 0) {
                return 0;
            } else {
                return (($act_capacity * 100) / $truck_capacity);
            }
        }else{
            return 0;
        }
    } else {
        return 0;
    }
}

function getCargodetails($ordid)
{
    $ci = &get_instance();
    $res = array();
    // join to tb_cargo_details needed to get units of measure for dimensions
    $sv = $ci->db->query("SELECT ocd.cargo_content AS unit_name, ocd.cargo_content AS description, ocd.length, cd.length_unit, ocd.width, cd.width_unit, ocd.height, cd.height_unit, ocd.weight, cd.weight_unit, ocd.volume, cd.volume_unit, ocd.quantity, ocd.quantity_type FROM tb_order_cargodetails ocd LEFT JOIN tb_cargo_details cd ON ocd.cargo_id=cd.id WHERE ocd.order_id=$ordid AND ocd.status=1");
    if ($sv->num_rows() > 0) {
        $res = $sv->result_array();
    }
    return $res;
}

function getCargotypes($ordid)
{
    $ci = &get_instance();
    $res = array();
    $sv = $ci->db->get_where("tb_order_cargotypes",array("order_id" => $ordid));
    if ($sv->num_rows() > 0) {
        $res = $sv->result_array();
    }
    return $res;
}
function getEDAofShipmentbyord($ord){
    $ci = &get_instance();
    $res = [];
    $res["time"] = $res["slat"] = $res["slng"] = $res["dlat"] = $res["dlng"] = "";
    if($ord != ""){
        $sql = "SELECT s.id,s.startdate,s.enddate,e.plat,e.plng,e.dlat,e.dlng FROM tb_shifts s,tb_shiporder_stops o,tb_employee e WHERE s.id=o.shipment_id AND s.id=e.shift_id AND s.status=1 AND e.order_id='".$ord."' ORDER BY o.ordernumber DESC LIMIT 1";
        $query = $ci->db->query($sql);
        if ($query->num_rows() > 0) {
            $shipid = $query->row()->id;
            $res["time"] = $query->row()->enddate;
            $lat = $query->row()->plat;
            $lng = $query->row()->plng;
            $elat = $query->row()->dlat;
            $elng = $query->row()->dlng;
            $res["slat"] = $lat;
            $res["slng"] = $lng;
            $res["dlat"] = $elat;
            $res["dlng"] = $elng;
            $qry = $ci->db->query("SELECT id,vehicle_id,start_imei FROM tb_trips WHERE shift_id='".$shipid."' AND status=1 ORDER BY id DESC LIMIT 1");
            if($qry->num_rows() > 0){
                $trip = $qry->row()->id;
                $vehicle_id = $qry->row()->vehicle_id;
                $liveloc = $ci->db->select('latitude,longitude,receivedon')->get_where('tb_trucks_data',array("id"=>$vehicle_id),1,0);
                if($liveloc->num_rows()>0){
                    $lat = $liveloc->row()->latitude;
                    $lng = $liveloc->row()->longitude;
                    $res["time"] = $liveloc->row()->receivedon;
                    $chkdist = distancemetrixship($lat,$lng,$elat,$elng);
                    if($chkdist['duration'] > 0){
                        $duration = (int) $chkdist['duration'];
                        $res["time"] = date("Y-m-d H:i:s", time() + $duration);
                    }
                    $res["slat"] = $lat;
                    $res["slng"] = $lng;
                    $res["dlat"] = $elat;
                    $res["dlng"] = $elng;
                }
            }
        }
    }
    return $res;
}
function getTripinfoByOrder($ord){
    $ci = &get_instance();
    $res = array();
    if($ord != ""){
        $sql = "SELECT s.id,e.plat,e.plng,e.dlat,e.dlng FROM tb_shifts s,tb_shiporder_stops o,tb_employee e WHERE s.id=o.shipment_id AND s.id=e.shift_id AND e.order_id='".$ord."' ORDER BY o.ordernumber DESC LIMIT 1";
        $query = $ci->db->query($sql);
        if ($query->num_rows() > 0) {
            $shipid = $query->row()->id;
            $dlat = $query->row()->dlat;
            $dlng = $query->row()->dlng;
            $slat = $query->row()->plat;
            $slng = $query->row()->plng;
            $res['ship_id'] = $shipid;
            $res['slat'] = $slat;
            $res['slng'] = $slng;
            $res['dlat'] = $dlat;
            $res['dlng'] = $dlng;
            $qry = $ci->db->query("SELECT id,start_imei FROM tb_trips WHERE shift_id='".$shipid."' ORDER BY id DESC LIMIT 1");
            if($qry->num_rows() > 0){
                $res['trip_id'] = $qry->row()->id;
                $res['imei'] = $qry->row()->start_imei;
            }
        }
    }
    return $res;
}

function chkTripinfoByOrdertrip($ord,$curtz){
    $ci = &get_instance();
    $res = array();
    if($ord != ""){
        $sql = "SELECT id,shift_id,driver_id,vehicle_id,convertToClientTZ(stime,'".$curtz."') as stime,convertToClientTZ(etime,'".$curtz."') as etime,status,dlat as latitude,dlng as longitude FROM tb_trips WHERE id='".$ord."' ORDER BY id DESC LIMIT 1";
        $query = $ci->db->query($sql);
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
        }
    }
    return $res;
}

function chkTripinfoByOrder($ord,$curtz){
    $ci = &get_instance();
    $res = array();
    if($ord != ""){
        $sql = "SELECT t.id,t.shift_id,t.driver_id,t.vehicle_id,convertToClientTZ(t.stime,'".$curtz."') as stime,convertToClientTZ(t.etime,'".$curtz."') as etime,t.status FROM tb_trips t,tb_employee e WHERE t.shift_id=e.shift_id AND e.order_id='".$ord."' ORDER BY t.id DESC LIMIT 1";
        $query = $ci->db->query($sql);
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
        }
    }
    return $res;
}

function getDrivernameById($id){
    $ci = &get_instance();
    $res = array("name"=>"","contact_num"=>"","imei"=>"");
    if($id != ""){
        $chk = $ci->db->select("name,contact_num")->get_where("tb_truck_drivers",array("id"=>$id),1,0);
        if($chk->num_rows()>0){
            $res = array("name"=>$chk->row()->name,"contact_num"=>$chk->row()->contact_num,"imei"=>'');
        }
    }
    return $res;
}

function getShipdatabyorder($id){
    $ci = &get_instance();
    $res = array("freight_term"=>"","freight_termname"=>"");
    if($id != ""){
        $chk = $ci->db->select("freight_term,freight_termname")->get_where("tb_shipments",array("id"=>$id),1,0);
        if($chk->num_rows()>0){
            $res = array("freight_term"=>$chk->row()->freight_term,"freight_termname"=>$chk->row()->freight_termname);
        }
    }
    return $res;
}

function getPartiesbyOrder($id){
    $ci = &get_instance();
    $res = $party_master_id = array();
    if($id != ""){
        $cwhr  = $cwhr1 = "";

        if($ci->session->userdata('cust_id') !== FALSE){
            $custid = $ci->session->userdata('cust_id');
            if($custid != ""){
                $cwhr = " AND pt.name NOT LIKE 'Carrier' ";
                $cwhr1 = "AND t.name NOT LIKE 'Carrier' ";
            }
        }else{
            $cwhr  = $cwhr1 = "";
        }
        $shipper_info=$ci->db->query("select pt.name as partytype,p.name,p.email,p.mobile,p.customeridentifier,p.partyindetifier,pm.order_id,pm.party_master_id,pm.location_id,pm.street,pm.address,pm.state, pm.pincode,pm.country from `tbl_party_types` pt,`tbl_party_master` p,`tb_order_parties` po, `tbl_orderparty_address` pm where po.party_type=pt.id and p.id=po.party_id  and po.order_id='".$id."' and pm.order_id ='".$id."' and po.party_id=pm.party_master_id ".$cwhr." GROUP BY pm.party_master_id");
        if($shipper_info->num_rows() > 0){
            foreach($shipper_info->result_array() as $row){
                $res[] = $row;
                $party_master_id[] = $row['party_master_id'];
            }

            $whr = "";
            $res1 = array();
            if(!empty($party_master_id)){
                $whr = "AND p.party_id NOT IN(".implode(',', $party_master_id).")";
            }
            $chk = $ci->db->query("SELECT m.*,t.name as partytype FROM tb_order_parties p LEFT JOIN tbl_party_master m ON m.id = p.party_id LEFT JOIN tbl_party_types t ON t.id=p.party_type WHERE p.order_id=".$id." ".$whr." ".$cwhr1 );
            if($chk->num_rows()>0){
                foreach($chk->result_array() as $rr){
                    $res1[] = $rr;
                }
            }
            if(!empty($res1)){
                foreach($res1 as $rrr){
                    array_push($res, $rrr);
                }
            }
        }else{
            $chk = $ci->db->query("SELECT m.*,t.name as partytype FROM tb_order_parties p LEFT JOIN tbl_party_master m ON m.id = p.party_id LEFT JOIN tbl_party_types t ON t.id=p.party_type WHERE p.order_id=".$id." ".$cwhr1);
            if($chk->num_rows()>0){
                foreach($chk->result_array() as $rr){
                    $res[] = $rr;
                }

            }
        }

    }
    return $res;
}

function getColName($index){
    $alpha = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
    $index--;
    $nAlphabets = 26;
    $f = floor($index/pow($nAlphabets,0)) % $nAlphabets;
    $s = (floor($index/pow($nAlphabets,1)) % $nAlphabets)-1;
    $t = (floor($index/pow($nAlphabets,2)) % $nAlphabets)-1;
    $f = $f < 0 ? '' : $alpha[$f];
    $s = $s < 0 ? '' : $alpha[$s];
    $t = $t < 0 ? '' : $alpha[$t];
    return trim("{$t}{$s}{$f}");
}

function getdatetimebytimezone($uzone,$dt,$dzone){
    if($dt != ""){
        $res['date'] = date("Y-m-d",strtotime($dt));
        $res['time'] = date("H:i:s",strtotime($dt));
        $res['datetime'] = date("Y-m-d H:i:s",strtotime($dt));

        if($uzone != "" && $dzone != "" &&$uzone != $dzone){
            $userTimezone = new DateTimeZone($uzone);
            $dbTimezone = new DateTimeZone($dzone);
            $currDate = new DateTime($res['datetime'], $dbTimezone);
            $currDate->setTimezone($userTimezone);
            $res['datetime'] = $currDate->format('Y-m-d H:i:s');

            $res['date'] = $currDate->format('Y-m-d');
            $res['time'] = $currDate->format('H:i:s');
        }
    }else{
        $res['date'] = date("Y-m-d");
        $res['time'] = date("H:i:s");
        $res['datetime'] = date("Y-m-d H:i:s");
    }
    return $res;
}

function gettimezonebygmtplusval($plusval){
    $ci = &get_instance();
    $res = "Asia/Singapore";
    if($plusval != ""){
        $plusval = str_replace(":", ".", $plusval);
        $chk = $ci->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE cntry_hrs='".$plusval."' LIMIT 1");
        if($chk->num_rows()>0){
            $res = $chk->row()->cntry_timezone;
        }
    }
    return $res;
}

function gettimezonebycountrycode($country_code){
    $ci = &get_instance();
    $res = "Asia/Singapore";
    if($country_code != ""){
        $chk = $ci->db->query("SELECT cntry_timezone FROM tbl_country_master WHERE country_code='".$country_code."' LIMIT 1");
        if($chk->num_rows()>0){
            $res = $chk->row()->cntry_timezone;
        }
    }
    return $res;
}

function getbytimezonebyusr($usr,$cmpcode){
    $res = array();
    $res = array("currency"=>"SGD","timezone"=>"Asia/Singapore","hrs"=>"+08.00","curdt"=>date("Y-m-d H:i:s"));
    $ci = &get_instance();
    $curdt = date("Y-m-d H:i:s");
    $usrqry = $ci->db->select("country_code")->get_where("tb_users",array("id"=>$usr,"company_code"=>$cmpcode),1,0);
    if($usrqry->num_rows()>0){
        $country_code = $usrqry->row()->country_code;
        $getqry = $ci->db->query("SELECT currency,cntry_timezone,cntry_hrs FROM tbl_country_master WHERE country_code='".$cmpcode."' AND status=1 LIMIT 1");
        if($getqry->num_rows()>0){
            $res['timezone'] = $getqry->row()->cntry_timezone;
            $res["currency"] = $getqry->row()->currency;
            $res["hrs"] = $getqry->row()->cntry_hrs;
            $chkutime = date_default_timezone_get();
            $userTimezone = new DateTimeZone($res['timezone']);
            $dbTimezone = new DateTimeZone($chkutime);
            $date = new DateTime($curdt, $dbTimezone);
            $date->setTimezone($userTimezone);
            $result = $date->format('Y-m-d H:i:s');
            $res["curdt"]=$result;
        }
    }
    return $res;
}

function timezonenowbyusr($usr,$tzone){
    $res = array();
    $res = array("currency"=>"SGD","timezone"=>"Asia/Singapore","hrs"=>"+08.00","curdt"=>date("Y-m-d H:i:s"));
    $curdt = $result = date("Y-m-d H:i:s");
    $chkutime = date_default_timezone_get();
    if($tzone != $chkutime){
        $userTimezone = new DateTimeZone($tzone);
        $dbTimezone = new DateTimeZone($chkutime);
        $date = new DateTime($curdt, $dbTimezone);
        $date->setTimezone($userTimezone);
        $result = $date->format('Y-m-d H:i:s');
    }
    $res["curdt"]=$result;
    return $res;
}

if (!function_exists('includeChat')) {
    function includeChat()
    {
        $ci     = &get_instance();
        $data["user"] =  "KN Customer";
        if($ci->session->has_userdata("companyname")){
            $data["user"] =  $ci->session->userdata("companyname");
        }
        $ci->load->view('welcome_message',$data);

    }
}

function gettrackvendors($whr){
    $res = array();
    $ci = &get_instance();
    $usrqry = $ci->db->select("id,vendor_name")->get_where("tb_tracking_vendors",$whr);
    if($usrqry->num_rows()>0){
        $res = $usrqry->result_array();
    }
    return $res;
}

function gettracksimcarriers($whr){
    $res = array();
    $ci = &get_instance();
    $usrqry = $ci->db->select("id,carrier_name")->get_where("tb_sim_carriers",$whr);
    if($usrqry->num_rows()>0){
        $res = $usrqry->result_array();
    }
    return $res;
}

if (!function_exists('getshipbordertype')) {
    function getshipbordertype($pickuploc,$droploc){
        $res = 0;
        if($pickuploc['pickup_country'] != "" && $droploc['drop_country'] != ""){
            $pickupcountry = strtolower(trim($pickuploc['pickup_country']));
            $dropcountry = strtolower(trim($droploc['drop_country']));
            if($pickupcountry != $dropcountry){
                $res = 1;
            }
        }else{
            if($pickuploc['pickup_city'] != "" && $droploc['drop_city'] != ""){
                $pickup_city = strtolower(trim($pickuploc['pickup_city']));
                $drop_city = strtolower(trim($droploc['drop_city']));
                $pickupcountry = getcountryname($pickup_city);
                $dropcountry = getcountryname($drop_city);
                if($pickupcountry != "" && $dropcountry != ""){
                    if($pickupcountry != $dropcountry){
                        $res = 1;
                    }
                }
            }else{
                if($pickuploc['pickup_location'] != "" && $droploc['drop_location'] != ""){
                    $pickup_location = strtolower(trim($pickuploc['pickup_location'] ));
                    $drop_location = strtolower(trim($droploc['drop_location']));
                    $pickupcountry = getcountryname($pickup_location);
                    $dropcountry = getcountryname($drop_location);
                    if($pickupcountry != "" && $dropcountry != ""){
                        if($pickupcountry != $dropcountry){
                            $res = 1;
                        }
                    }
                }
            }
        }
        return $res;
    }
}
if (!function_exists('getcountryname')) {
    function getcountryname($address){
        $response = getlatlngsbyplace($address);
        return $response[3];
    }
}

if (!function_exists('dateTimeToUTC')) {
    // Example: input: $dateTime = '2021-08-20T15:00:00+02:00';

    // Usage: echo dateTimeToUTC($dateTime)->format('Y-m-d H:i:s'); it returns UTC
    function dateTimeToUTC(string $dateTime): \DateTime
    {
        $dateUTC = new \DateTime($dateTime);
        $dateUTC->setTimezone(new DateTimeZone(DFLT_TZ));

        return $dateUTC;
    }
}

if (!function_exists('getPlainXml')) {
    function getPlainXml($xml): string
    {
        $obj = SimpleXML_Load_String($xml);
        if ($obj === false) {
            return $xml;
        }
        $getNamespaces = $obj->getNamespaces(true);
        if (empty($getNamespaces)) {
            return $xml;
        }
        $getNamespacesKeys = array_keys($getNamespaces);
        foreach ($getNamespacesKeys as $key) {
            $pattern = '#' . '(' . '\<' . '/?' . preg_quote($key) . ')' . '(' . ':{1}' . ')' . '#';
            $xml = preg_replace($pattern, '$1' . '_', $xml);
        }
        return $xml;
    }
}

function checkAccessConditions(string $title, string $text): bool
{
    $ci = &get_instance();
    $db = clone $ci->db;
    $db->select("condition");
    $db->from("access_conditions");
    $db->where('title', $title);
    $query = $db->get();
    if ($query->num_rows() > 0) {
        $conditionValues = explode(',', $query->row()->condition);
        return in_array($text, $conditionValues);
    }
    return false;
}

function numWeeks(int $year, int $month, int $start = 0): int
{
    $unix = strtotime("$year-$month-01");
    $numberOfDays = date('t', $unix);
    if ($start === 0) {
        $dayOne = date('w', $unix);
    } else {
        $dayOne = date('N', $unix);
        $dayOne--;
    }
    $numberOfWeeks = floor(($numberOfDays - (6 - $dayOne)) / 7);
    return $numberOfWeeks;
}

function getDeliveryNotes(string $orderIds): string {
    $ci = &get_instance();
    $query = $ci->db->query("SELECT GROUP_CONCAT(tor.ref_value) AS delivery_note 
        FROM tb_orders o
        INNER JOIN tb_order_references tor ON tor.order_id = o.id
        WHERE o.order_id  IN ? AND o.status IN ? AND tor.reference_id = ?",
        [explode(',', $orderIds), [1, 2],'DQ']);
    return (int)$query->num_rows() === 1 ? (string)$query->row()->delivery_note : 'N/A';
}

if (!function_exists('getDistanceAndDurationWithMultipleStops')) {
    function getDistanceAndDurationWithMultipleStops(array $stops): array
    {
      //  log_message("error",json_encode($stops));
        $count = count($stops);
        if ($count < 2) {
            return [];
        }

        // Helper to compare lat/lng with tolerance
        $isSameLocation = function ($lat1, $lng1, $lat2, $lng2, $tolerance = 0.0005) {
           return (abs($lat1 - $lat2) <= $tolerance) && (abs($lng1 - $lng2) <= $tolerance);
        };

        $origin = $stops[0]['lat'] . "," . $stops[0]['lng'];
        $waypointsArr = [];
        for ($i = 1; $i < $count; $i++) {
            $waypointsArr[] = $stops[$i]['lat'] . "," . $stops[$i]['lng'];
        }
        $waypointsStr = "&waypoints=optimize:true|" . implode('|', $waypointsArr);

        $url = "https://maps.googleapis.com/maps/api/directions/json?"
             . "origin={$origin}&destination={$origin}{$waypointsStr}"
             . "&key=" . GOOGLE_BKND_API_KEY;

        $data = ProcessGoogleAPICurl($url);

        if (!isset($data['status']) || $data['status'] !== "OK") {
            log_message("error","no data - ".$url);
            return [];
        }

        $route = $data['routes'][0];
        $legs  = $route['legs'];
        $legsCount = count($legs);
        $totalDistance = $totalDuration = $i = 0;
        $legDetails = [];

        foreach ($legs as $leg) {
            if ($i == ($legsCount - 1)) {
                break; // skip last leg (back to origin)
            }
            $i++;

            $totalDistance += $leg['distance']['value'];
            $totalDuration += $leg['duration']['value'];

            $endLocation   = $leg['end_location'];
            $startLocation = $leg['start_location'];

            $legDetails[] = [
                'slat' => $startLocation['lat'],
                'slng' => $startLocation['lng'],
                'dlat' => $endLocation['lat'],
                'dlng' => $endLocation['lng'],
                'origin_address'      => $leg['start_address'],
                'destination_address' => $leg['end_address'],
                'distance'            => $leg['distance']['text'],
                'duration'            => $leg['duration']['text']
            ];
        }

        // Build orderedStops with index
        $orderedStops = [];
        $orderedStops[] = [
            'index' => 0, // first stop index
            'lat'   => $stops[0]['lat'],
            'lng'   => $stops[0]['lng'],
            'city'  => $legs[0]['start_address'],
            'found_in_legs' => true
        ];

        if (isset($route['waypoint_order'])) {
            foreach ($route['waypoint_order'] as $idx => $stopIndex) {
                $stopLat = $stops[$stopIndex + 1]['lat'];
                $stopLng = $stops[$stopIndex + 1]['lng'];

                // check if exists in legs
                $found = false;
                foreach ($legs as $leg) {
                    if ($isSameLocation($stopLat, $stopLng, $leg['start_location']['lat'], $leg['start_location']['lng']) ||
                        $isSameLocation($stopLat, $stopLng, $leg['end_location']['lat'], $leg['end_location']['lng'])) {
                        $found = true;
                        break;
                    }
                }

                $orderedStops[] = [
                    'index' => $stopIndex + 1, // actual index in original $stops
                    'lat'   => $stopLat,
                    'lng'   => $stopLng,
                    'city'  => $legs[$idx]['end_address'],
                    'found_in_legs' => $found
                ];
            }
        }

        if (end($orderedStops)['lat'] == $stops[0]['lat'] &&
            end($orderedStops)['lng'] == $stops[0]['lng']) {
            array_pop($orderedStops); // remove origin if added again
        }

        return [
            'legs'             => $legDetails,
            'totalDistanceKm'  => round($totalDistance / 1000, 2),
            'totalDurationMin' => round($totalDuration / 60, 2),
            'totalDurationHours' => round($leg['duration']['value'] / 3600, 2),
            'orderedStops'     => $orderedStops
        ];
    }
}

function getDistanceAndDurationTwoPoints(array $originPoint, array $destinationPoint): array
{
    // Validate input
    if (empty($originPoint['lat']) || empty($originPoint['lng']) || empty($destinationPoint['lat']) || empty($destinationPoint['lng'])) {
        return [];
    }

    $origin = $originPoint['lat'] . "," . $originPoint['lng'];
    $destination = $destinationPoint['lat'] . "," . $destinationPoint['lng'];

    $url = "https://maps.googleapis.com/maps/api/directions/json?"
        . "origin={$origin}&destination={$destination}"
        . "&key=" . GOOGLE_BKND_API_KEY;

    $data = ProcessGoogleAPICurl($url);

    if (!isset($data['status']) || $data['status'] !== "OK") {
        return [];
    }

    $leg = $data['routes'][0]['legs'][0];

    $result = [
        'fromAddress' => $leg['start_address'],
        'toAddress'   => $leg['end_address'],
        'totalDistanceKm'  => round($leg['distance']['value'] / 1000, 2),
        'totalDurationMin' => round($leg['duration']['value'] / 60, 2),
        'totalDurationHours' => round($leg['duration']['value'] / 3600, 2)
    ];

    return $result;
}