<?php

function utc_to_local_time($date, $timezone) { 
    // '2020-08-10 11:00:08' as date
    $userTimezone = new DateTimeZone($timezone);
    $gmtTimezone = new DateTimeZone('GMT');
    $myDateTime = new DateTime($date, $gmtTimezone);
    $offset = $userTimezone->getOffset($myDateTime);
    $myInterval = DateInterval::createFromDateString((string) $offset . 'seconds');
    $myDateTime->add($myInterval);
//    $result = $myDateTime->format('Y-m-d H:i:s');
    $result = $myDateTime->format('Y-m-d h:i A');
    return $result;
}

if(!function_exists('dateConvertByTimeZone')){
    function dateConvertByTimeZone($time, $oldTZ, $newTZ, $format='Y-m-d H:i:s') {
        if($time!='' && $oldTZ!='' && $newTZ!='' && $time!='0000-00-00 00:00:00'){
            $d = new DateTime($time, new DateTimeZone($oldTZ));        
            $d->setTimezone(new DateTimeZone($newTZ));
            return $d->format($format);
        }else{
            return $time;
        }        
    }
}

?>