<?php
if(!defined('BASEPATH')) exit('No direct script access allowed');

if (!function_exists("generatemanifestdoc")) {
  function generatemanifestdoc($shift_id){
    $ci = &get_instance();
    $ci->load->model('common');
  	$ci->load->model('truckwaybillmodel');
    $data = array();
    $data['manifest_no'] = generatemanifestno();
    $data['items_count'] = 0;
    $data['tot_weight'] = 0;
    $data['tot_vol'] = 0;
    $orders = $ci->common->gettbldata(array('shift_id'=>$shift_id),'id,plat,plng,customer_id,vendor_id,pickup_city,pickup_address2,pickup_pincode,pickup_address1,delivery_address2,delivery_pincode,delivery_city','tb_orders',0,0);
    foreach($orders as $ord){
       $ordref = $ci->common->gettblrowdata(array('order_id'=> $ord['id'],'reference_id'=>'BN'),'ref_value','tb_order_references',0,0);
       $delnote = $ci->common->gettblrowdata(array('order_id'=> $ord['id'],'reference_id'=>'DQ'),'ref_value','tb_order_references',0,0);
       $receiverinfo=$ci->truckwaybillmodel->getshipper($ord['id'],'Consignee');
       $pickupinfo=$ci->truckwaybillmodel->getshipper($ord['id'],'Shipper');
       $customer = $ci->common->gettblrowdata(array('id'=>$ord['customer_id']),'name','tb_customers',0,0);
       #print_r($ci->db->last_query()); exit;
       $order_cargos = $ci->common->gettbldata(array("order_id"=>$ord['id']),'cargo_id,quantity,weight,volume','tb_order_cargodetails',0,0);
       $ord['total_items']=0;
       $ord['total_weight']=0;
       $ord['total_volume']=0;
        foreach($order_cargos as $cargo){
          $cargoinfo = $ci->common->gettblrowdata(array('id'=>$cargo['cargo_id']),'dg_goods,cargo_type','tb_cargo_details',0,0);
          $data['isDG'] = ($cargoinfo['dg_goods']==0)?'No':'Yes';
          $ord['total_items'] += $cargo['quantity'];
          $ord['total_weight'] += $cargo['weight'];
          $ord['total_volume'] += $cargo['volume'];
          $data['cargo_type'] = $cargoinfo['cargo_type'];
        }
        $data['items_count'] += $ord['total_items'];
        $data['tot_weight'] += $ord['total_weight'];
        $data['tot_vol'] += $ord['total_volume'];
       $ord['service'] = "EXPRESS";
       $ord['ref_value'] = isset($ordref['ref_value'])?$ordref['ref_value']:'';
       $ord['delivery_note'] = isset($delnote['ref_value'])?$delnote['ref_value']:'';
       $ord['consignee_name'] = $receiverinfo['name'];
       $ord['customer_name'] = isset($customer['name'])?$customer['name']:'';
       $ordinfo[] = $ord;
       $data['shipper_name'] = $pickupinfo['name'];
       $data['customer_name'] = $ord['customer_name'];
       /* Inserting manifest no in order reference */
       $ins_ar = array('order_id'=>$ord['id'],'reference_id'=>'MANIFEST NO','ref_value' => $data['manifest_no']);
       $chkqry = $ci->common->gettblrowdata($ins_ar,'id','tb_order_references',0,0);
       if (empty($chkqry)) {
           $ins_ar['status'] = 1;
           $ins_ar['createdon'] = date('Y-m-d h:i:s');
           $ins = $ci->db->insert('tb_order_references', $ins_ar);
        }
    }

    $data['orders'] = $ordinfo;
    $vendor = $ci->common->gettblrowdata(array('id'=>$ordinfo[0]['vendor_id']),'name','tb_vendors',0,0);
    $data['vendor_name'] = $vendor['name'];
    $data['pick_city'] = $ordinfo[0]['pickup_city'];
    $data['del_city'] = $ordinfo[0]['delivery_city'];
    $data['pick_state'] = $ordinfo[0]['pickup_address2'];
    $data['del_state'] = $ordinfo[0]['delivery_address2'];
    $data['pick_pincode'] = $ordinfo[0]['pickup_pincode'];
    $data['pick_address1'] = $ordinfo[0]['pickup_address1'];
    $ci->load->view('manifestdoc/index',$data);
    require 'vendor/autoload.php';
    $mpdf = new \Mpdf\Mpdf([
      'default_font_size' => 9,
      'tempDir' => FCPATH .'assets/tmp',
      'format' => 'A4'
    ]);
     $mpdf->setAutoBottomMargin='stretch';
       $company_code = $ci->session->userdata('company_code');
       $data['company_code'] = $company_code;
       $html  = "";
         $html = $ci->load->view('manifestdoc/index',$data,true);
         $mpdf->WriteHTML($html);
         $filename = "mnf".date('YmdHis').".pdf";
         $filepath = NEW_POD_PATH.$filename;
         $mpdf->Output($filepath,'F');
         //$mpdf->Output($filename,'D');
         $curdt = date('Y-m-d H:i:s');
         $imageSize = filesize($filepath);
         $newUuid = $this->uuid->v4();
         $doctype = $ci->common->gettblrowdata(array('type_name'=> 'A8A Bond manifest'),'id','tb_document_types',0,0);
         $insert = array('trip_id'=>0,'shipment_id'=>$shift_id,'stop_id'=>0,'stop_detail_id'=>0,'stop_type'=>'P','doc_type'=>$doctype['id'],'user_id'=> $ci->session->userdata('user_id'),'status'=>1,'createdon'=>$curdt,'updatedon'=>$curdt,'imgpath'=>$filename,'filesize'=>$imageSize);
         foreach($orders as $ord){
           $insert['order_id'] = $ord['id'];
           $insert['latitude'] = $ord['plat'];
           $insert['longitude'] = $ord['plng'];
           $insert['hash'] = $newUuid;
           $insertid = $ci->common->insertTableData("tb_pod_uploads",$insert);
         }
  }
}

if (!function_exists("generatemanifestno")) {
  function generatemanifestno(){
    $ci = &get_instance();
    $ci->load->model('common');
      $current_data = $ci->db->query("select ref_value from tb_order_references where reference_id = 'MANIFEST NO' order by id DESC")->row_array();
      if(empty($current_data)){
        $latestid = '000ETN000';
      } else {
        $latestid = $current_data['ref_value'];
      }
      $num = substr($latestid, 6)+1;
        $numlength = strlen((string)$num);
        if($numlength == 1){
            $finalid = '000ETN00'.$num;
        } else if($numlength == 2){
            $finalid = '000ETN00'.$num;
        } else {
            $finalid = '000ETN00'.$num;
        }
      return $finalid;
  }
}
