<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


if (!function_exists("fuel_type")) {
    function fuel_type(string $selectedFuel = ''): string
    {
        $htmlOptions = '';

        $selectedFuel = strtolower($selectedFuel);

        foreach (['select', 'diesel', 'electricity', 'cng', 'lng', 'petrol'] as $fuel) {
            $htmlOptions .= '<option style="text-transform: uppercase" value="' . $fuel . '"' . ($fuel != $selectedFuel ? '' : ' selected="selected"') . '>' . $fuel . '</option>';
        }

        return $htmlOptions;
    }
}

if (!function_exists("getNextPalletSeq")) {
    function getNextPalletSeq($order_id = '')
    {
        $ci = &get_instance();
        $resp = "001";
        if ($order_id != "") {
            $getcontainer = $ci->db->select('ref_value')->get_where("tb_order_references", array("order_id" => $order_id, 'reference_id' => "CTR", 'status' => 1), 1, 0);
            if ($getcontainer->num_rows() > 0) {
                $contact_num = $getcontainer->row()->ref_value;
                $count = $resp;
                $rows1 = $ci->db->query("SELECT pallet_name FROM tb_order_cargodetails WHERE pallet_name LIKE '%" . $contact_num . "%' AND pallet_name!='' ORDER BY id DESC LIMIT 1");
                if ($rows1->num_rows() > 0) {
                    $recentval = $rows1->row()->pallet_name;
                    $new = explode("-", $recentval);
                    if (isset($new[2])) {
                        $count = ($new[2] + 1);
                    }
                }
                $resp = sprintf('%03d', $count);
            }
        }
        return $resp;
    }
}

if (!function_exists("getEmployee")) {
    function getEmployee($id)
    {
        $ci = &get_instance();
        $sql = $ci->db->where("assoc_id", $id)->get("tb_employee");
        if ($sql->num_rows() > 0) {
            return $sql->row();
        } else {
            return array();
        }
    }
}
if (!function_exists("getEmployeeID")) {
    function getEmployeeID($phone)
    {
        $ci = &get_instance();
        $sql = $ci->db->select('id')->get_where("tb_employee", array("phone" => $phone), 1, 0);
        if ($sql->num_rows() > 0) {
            return $sql->row()->id;
        } else {
            return "";
        }
    }
}
if (!function_exists("getcontainerno_byorder")) {
    function getcontainerno_byorder($orderid)
    {
        $ci = &get_instance();
        $sql = $ci->db->select('ref_value')->get_where("tb_order_references", array("order_id" => $orderid, 'reference_id' => 'CTR', 'status' => '1'));
        if ($sql->num_rows() > 0) {
            $ctr = array();
            foreach ($sql->result() as $res) {
                $ctr[] = $res->ref_value;
            }
            if (!empty($ctr)) {
                $container_no = implode(',', $ctr);
                return $container_no;
            } else {
                return "";
            }
        } else {
            return "";
        }
    }
}
if (!function_exists("getsuborderbyorder")) {
    function getsuborderbyorder($orderid)
    {
        $ci = &get_instance();
        $resp = array();
        $sql = $ci->db->select('id')->get_where("tb_orders", array("parent_id" => $orderid, 'status <>' => 0));
        if ($sql->num_rows() > 0) {
            foreach ($sql->result() as $res) {
                $resp[] = $res->id;
            }
        }
        return $resp;
    }
}

if (!function_exists("getVehicle")) {
    function getVehicle($reg)
    {
        $ci = &get_instance();
        $whr = array("register_number" => $reg, "status" => 'Active');
        $sql = $ci->db->select('id')->get_where("tb_trucks_data", $whr, 1, 0);
        if ($sql->num_rows() > 0) {
            return $sql->row()->id;
        } else {
            return array();
        }
    }
}
if (!function_exists("getImei")) {
    function getImei($reg)
    {
        $result = "";
        $ci = &get_instance();
        $qyery = $ci->db->query("select imei from tb_trucks_data where register_number='" . $reg . "'");
        $result = $qyery->row()->imei;
        return $result;
    }
}
if (!function_exists("getTruckType")) {
    function getTruckType($id)
    {
        $result = "";
        $ci = &get_instance();
        $qyery = $ci->db->query("select trucktype from tb_trucktypes where id='" . $id . "'");
        $result = @$qyery->row()->trucktype;

        return $result;
    }
}
function getClosest($search, $arr)
{
    $closest = null;
    foreach ($arr as $item) {
        if ($closest === null || abs($search - $closest) > abs($item - $search)) {
            $closest = $item;
        }
    }
    return $closest;
}

function encryptIt($driver, $trip)
{
    return base64_encode(base64_encode($driver) . "//" . base64_encode($trip));
}

function decryptIt($str)
{
    $str = base64_decode($str);
    $s = explode("//", $str);
    if (count($s) == 2) {
        $a = array(base64_decode($s[0]), base64_decode($s[1]));
    } else {
        $a = array("", "");
    }
    return $a;
}

function getdriverdelay($post, $vehicleid)
{
    $ci = &get_instance();
    $userid = $ci->session->userdata('user_id');
    $where = " where tr.trip_status = 1 ";
    if (isset($post['user_id']) && $post['user_id'] > 0) {
        $where .= " and tr.user_id = '" . $post['user_id'] . "' ";
    } else {
        $where .= " and tr.user_id = '" . $ci->session->userdata('user_id') . "' ";
    }
    if (isset($post['fromdate_search']) && trim($post['fromdate_search']) != "") {
        $where .= " and date(tr.createdon) >= '" . $post['fromdate_search'] . "' ";
    }
    if (isset($post['todate_search']) && trim($post['todate_search']) != "") {
        $where .= " and date(tr.createdon) <= '" . $post['todate_search'] . "' ";
    }
    if (isset($post['shift_search'])) {
        if (($key = array_search("", $post['shift_search'])) !== false) {
            unset($post['shift_search'][$key]);
        }
        if (!empty($post['shift_search'])) {
            $getlocid = getVehicleTripsByShiftSearch($post['shift_search']);
            if (count($getlocid) > 0) {
                foreach ($getlocid as $ld) {
                    $ddd[] = $ld['id'];
                }
                $dd = implode(",", $ddd);
            } else {
                $dd = 0;
            }
            $where .= " and tr.trip_id IN (" . $dd . ")";
        }
    }
    $query = "select count(t.id) AS ontime from tb_trip_summary as tr, tb_trips as t, tb_shifts h " . $where . " AND t.shift_id = h.id AND tr.trip_id=t.id AND t.vehicle_id=$vehicleid AND DATE_FORMAT( tr.end_time, '%H.%i' ) <= h.etime";
    $res = $ci->db->query($query);
    $i = 0;
    $dd = 0;
    $gettottrips = $ci->db->query("select count(tr.id) as totcnt from tb_trip_summary as tr, tb_trips as t, tb_truck_drivers as dr " . $where . " AND tr.trip_id=t.id AND t.vehicle_id=$vehicleid AND dr.id=tr.driver_id");
    $cnt = $gettottrips->row()->totcnt;
    $ontime = $res->row()->ontime;
    if ($cnt > 0) {
        $dd = @round(($ontime / $cnt) * 100, 2);
    }
    return $dd;
}

function getVehicleTripsByShiftSearch($shift)
{
    $ci = &get_instance();
    $result = array();
    $ci->db->select('id');
    $ci->db->from('tb_trips');
    if (is_array($shift) && !empty($shift)) {
        $ci->db->where_in('shift_id', $shift);
    } else {
        $ci->db->where('shift_id', $shift);
    }
    $res = $ci->db->get();
    $result = $res->result_array();
    return $result;
}

function gettripdetails($trip = "", $shft_veh_id = "")
{
    $ci = &get_instance();
    $res = array();
    if ($shft_veh_id != "" && $trip != "") {
        $emp = $ci->db->query("select e.pickup,e.drop,e.phone,e.id,e.name,e.startdate,e.ship_type,e.stop_order,e.shipment_weight, e.shipment_volume,e.capacity,ifnull(te.status,2) as status,ifnull(te.check_in,'') as time,te.absent_reason,te.pd_status from tb_shft_veh_emp ve,tb_employee e left outer join tb_trip_employee te on te.employee_id=e.id and te.trip_id=$trip where ve.shft_veh_id=$shft_veh_id and ve.status=1 and ve.emp_id=e.id group by e.id order by ve.priority asc");
        if ($emp->num_rows() > 0) {
            $res = $emp->result();
        }
    }
    return $res;
}

/**
 * replacement : App\TripStop\TripStopDetails
 *
 * @param array $row
 * @param false $rejected
 * @return array
 *
 */
function gettripstopdetails(array $row = [], bool $rejected = false):array
{
    $state = \App\TripStop\TripStopDetails::getInstance();
    $state->useShipments([ (object) $row ]);
    if ($rejected) {
        $state->useRejected();
    }
    $state->executeQueries();
    return (array) $state->getDetailsData($row['id']);
}

function gettriplivestatus($drv, $veh, $trip)
{
    $ci =& get_instance();
    $a = array();
    $a["location"] = "";
    $a["link"] = "";
    if ($trip != 0 && $trip != "") {
        $q = $ci->db->query("select latitude,longitude from tb_trucks_data where id=$veh limit 1");
        if ($q->num_rows() > 0) {
            $a["location"] = getLocationName($q->row()->latitude, $q->row()->longitude);
            $a["link"] = getLink($drv, $trip);
        }
    }
    return $a;
}

function getLink($driver, $trip)
{
    $ci =& get_instance();
    $link1 = base_url() . "cab/track/" . encryptIt($driver, $trip);
    if (isset($link1)) {
        return $link1;
    } else {
        return "";
    }
}

function shipmentStopWeight($stop)
{
    $ci = &get_instance();
    $stop_id = $stop->id;
    $emps_q = $ci->db->query("SELECT e.id,e.stop_id,e.shipment_volume,e.no_of_pkgs from tb_employee e,tb_shiporder_stops ss WHERE ss.id = $stop_id AND (e.stop_id = ss.id OR e.drop_stopid = ss.id) AND e.status='1'");
    $act_ship_units = 0;
    foreach ($emps_q->result() as $emp) {
        $act_ship_units += $emp->no_of_pkgs;
    }
    return $act_ship_units;
}

function shipmentUnits($shipment_id)
{
    $ci = &get_instance();
    $stops = $ci->db->query("SELECT id FROM tb_shiporder_stops WHERE shipment_id = $shipment_id");
    $total_units = $driver_entered_total = 0;
    foreach ($stops->result() as $stop) {
        $stop_id = $stop->id;
        $ship_units = $ci->db->query("SELECT ship_units FROM tb_shiporder_stops WHERE id = $stop_id AND stoptype='P'");
        if ($ship_units->num_rows() > 0) {
            $driver_entered = $ship_units->row()->ship_units;
            if ($driver_entered == "" || $driver_entered == "0") {
                $driver_entered = 1;
            }
            $driver_entered_total += $driver_entered;
            $total_units = 0;
            $sdet = $ci->db->query("SELECT no_of_pkgs from tb_employee WHERE (stop_id=$stop_id OR drop_stopid=$stop_id) AND status='1'");
            foreach ($sdet->result() as $row) {
                $total_units += $row->no_of_pkgs;
            }
        }
    }
    return array($total_units, $driver_entered_total);
}

function getTripDrivers($trip_id)
{
    $ci = &get_instance();
    $dnames = [];
    $drivers = $ci->db->query("SELECT d.name,d.contact_num from tb_trip_drivers td,tb_truck_drivers d where td.trip_id = $trip_id AND td.driver_id=d.id AND td.status='1'");
    foreach ($drivers->result() as $driver) {
        if (strlen($driver->name) > 0) {
            $dnames[] = $driver->name . " - " . $driver->contact_num;
        }
    }
    return implode(",", $dnames);
}

function getCountryCode($country)
{
    $counties = [
        "Afghanistan" => "AF",
        "Aland Islands" => "AX",
        "Albania" => "AL",
        "Algeria" => "DZ",
        "American Samoa" => "AS",
        "Andorra" => "AD",
        "Angola" => "AO",
        "Anguilla" => "AI",
        "Antarctica" => "AQ",
        "Antigua and Barbuda" => "AG",
        "Argentina" => "AR",
        "Armenia" => "AM",
        "Aruba" => "AW",
        "Australia" => "AU",
        "Austria" => "AT",
        "Azerbaijan" => "AZ",
        "Bahamas" => "BS",
        "Bahrain" => "BH",
        "Bangladesh" => "BD",
        "Barbados" => "BB",
        "Belarus" => "BY",
        "Belgium" => "BE",
        "Belize" => "BZ",
        "Benin" => "BJ",
        "Bermuda" => "BM",
        "Bhutan" => "BT",
        "Bolivia" => "BO",
        "Bonaire Sint Eustatius and Saba" => "BQ",
        "Bosnia and Herzegovina" => "BA",
        "Botswana" => "BW",
        "Bouvet Island" => "BV",
        "Brazil" => "BR",
        "British Indian Ocean Territory" => "IO",
        "Brunei Darussalam" => "BN",
        "Bulgaria" => "BG",
        "Burkina Faso" => "BF",
        "Burundi" => "BI",
        "Cambodia" => "KH",
        "Cameroon" => "CM",
        "Canada" => "CA",
        "Cape Verde" => "CV",
        "Cayman Islands" => "KY",
        "Central African Republic" => "CF",
        "Chad" => "TD",
        "Chile" => "CL",
        "China" => "CN",
        "Christmas Island" => "CX",
        "Cocos (Keeling) Islands" => "CC",
        "Colombia" => "CO",
        "Comoros" => "KM",
        "Congo" => "CG",
        "Congo The Democratic Republic of" => "CD",
        "Cook Islands" => "CK",
        "Costa Rica" => "CR",
        "Cote d'Ivoire" => "CI",
        "Croatia" => "HR",
        "Cuba" => "CU",
        "Curaçao" => "CW",
        "Cyprus" => "CY",
        "Czechia" => "CZ",
        "Denmark" => "DK",
        "Djibouti" => "DJ",
        "Dominica" => "DM",
        "Dominican Republic" => "DO",
        "Ecuador" => "EC",
        "Egypt" => "EG",
        "El Salvador" => "SV",
        "Equatorial Guinea" => "GQ",
        "Eritrea" => "ER",
        "Estonia" => "EE",
        "Ethiopia" => "ET",
        "Falkland Islands (Malvinas)" => "FK",
        "Faroe Islands" => "FO",
        "Fiji" => "FJ",
        "Finland" => "FI",
        "France" => "FR",
        "French Guiana" => "GF",
        "French Polynesia" => "PF",
        "French Southern Territories" => "TF",
        "Gabon" => "GA",
        "Gambia" => "GM",
        "Georgia" => "GE",
        "Germany" => "DE",
        "Ghana" => "GH",
        "Gibraltar" => "GI",
        "Greece" => "GR",
        "Greenland" => "GL",
        "Grenada" => "GD",
        "Guadeloupe" => "GP",
        "Guam" => "GU",
        "Guatemala" => "GT",
        "Guernsey" => "GG",
        "Guinea" => "GN",
        "Guinea-Bissau" => "GW",
        "Guyana" => "GY",
        "Haiti" => "HT",
        "Heard and Mc Donald Islands" => "HM",
        "Holy See (Vatican City State)" => "VA",
        "Honduras" => "HN",
        "Hong Kong" => "HK",
        "Hungary" => "HU",
        "Iceland" => "IS",
        "India" => "IN",
        "Indonesia" => "ID",
        "Iran Islamic Republic of" => "IR",
        "Iraq" => "IQ",
        "Ireland" => "IE",
        "Isle of Man" => "IM",
        "Israel" => "IL",
        "Italy" => "IT",
        "Jamaica" => "JM",
        "Japan" => "JP",
        "Jersey" => "JE",
        "Jordan" => "JO",
        "Kazakstan" => "KZ",
        "Kenya" => "KE",
        "Kiribati" => "KI",
        "Korea Democratic People's Republic of" => "KP",
        "Korea Republic of" => "KR",
        "Kosovo (temporary code)" => "XK",
        "Kuwait" => "KW",
        "Kyrgyzsta" => "KG",
        "Lao People's Democratic Republic" => "LA",
        "Latvia" => "LV",
        "Lebanon" => "LB",
        "Lesotho" => "LS",
        "Liberia" => "LR",
        "Libyan Arab Jamahiriya" => "LY",
        "Liechtenstein" => "LI",
        "Lithuania" => "LT",
        "Luxembourg" => "LU",
        "Macao" => "MO",
        "Macedonia The Former Yugoslav Republic Of" => "MK",
        "Madagascar" => "MG",
        "Malawi" => "MW",
        "Malaysia" => "MY",
        "Maldives" => "MV",
        "Mali" => "ML",
        "Malta" => "MT",
        "Marshall Islands" => "MH",
        "Martinique" => "MQ",
        "Mauritania" => "MR",
        "Mauritius" => "MU",
        "Mayotte" => "YT",
        "Mexico" => "MX",
        "Micronesia Federated States of" => "FM",
        "Moldova Republic of" => "MD",
        "Monaco" => "MC",
        "Mongolia" => "MN",
        "Montenegro" => "ME",
        "Montserrat" => "MS",
        "Morocco" => "MA",
        "Mozambique" => "MZ",
        "Myanmar" => "MM",
        "Namibia" => "NA",
        "Nauru" => "NR",
        "Nepal" => "NP",
        "Netherlands" => "NL",
        "Netherlands Antilles" => "AN",
        "New Caledonia" => "NC",
        "New Zealand" => "NZ",
        "Nicaragua" => "NI",
        "Niger" => "NE",
        "Nigeria" => "NG",
        "Niue" => "NU",
        "Norfolk Island" => "NF",
        "Northern Mariana Islands" => "MP",
        "Norway" => "NO",
        "Oman" => "OM",
        "Pakistan" => "PK",
        "Palau" => "PW",
        "Palestinian Territory Occupied" => "PS",
        "Panama" => "PA",
        "Papua New Guinea" => "PG",
        "Paraguay" => "PY",
        "Peru" => "PE",
        "Philippines" => "PH",
        "Pitcairn" => "PN",
        "Poland" => "PL",
        "Portugal" => "PT",
        "Puerto Rico" => "PR",
        "Qatar" => "QA",
        "Republic of Serbia" => "RS",
        "Reunion" => "RE",
        "Romania" => "RO",
        "Russia Federation" => "RU",
        "РОССИЯ" => "RU",
        "Rwanda" => "RW",
        "Saint Barthélemy" => "BL",
        "Saint Helena" => "SH",
        "Saint Kitts & Nevis" => "KN",
        "Saint Lucia" => "LC",
        "Saint Martin" => "MF",
        "Saint Pierre and Miquelon" => "PM",
        "Saint Vincent and the Grenadines" => "VC",
        "Samoa" => "WS",
        "San Marino" => "SM",
        "Sao Tome and Principe" => "ST",
        "Saudi Arabia" => "SA",
        "Senegal" => "SN",
        "Serbia and Montenegro" => "CS",
        "Seychelles" => "SC",
        "Sierra Leone" => "SL",
        "Singapore" => "SG",
        "Sint Maarten" => "SX",
        "Slovakia" => "SK",
        "Slovenia" => "SI",
        "Solomon Islands" => "SB",
        "Somalia" => "SO",
        "South Africa" => "ZA",
        "South Georgia & The South Sandwich Islands" => "GS",
        "South Sudan" => "SS",
        "Spain" => "ES",
        "Sri Lanka" => "LK",
        "Sudan" => "SD",
        "Suriname" => "SR",
        "Svalbard and Jan Mayen" => "SJ",
        "Swaziland" => "SZ",
        "Sweden" => "SE",
        "Switzerland" => "CH",
        "Syrian Arab Republic" => "SY",
        "Taiwan, Province of China" => "TW",
        "Tajikistan" => "TJ",
        "Tanzania United Republic of" => "TZ",
        "Thailand" => "TH",
        "Timor-Leste" => "TL",
        "Togo" => "TG",
        "Tokelau" => "TK",
        "Tonga" => "TO",
        "Trinidad and Tobago" => "TT",
        "Tunisia" => "TN",
        "Turkey" => "TR",
        "Turkish Rep N Cyprus (temporary code)" => "XT",
        "Turkmenistan" => "TM",
        "Turks and Caicos Islands" => "TC",
        "Tuvalu" => "TV",
        "Uganda" => "UG",
        "Ukraine" => "UA",
        "United Arab Emirates" => "AE",
        "United Kingdom" => "GB",
        "United States" => "US",
        "United States Minor Outlying Islands" => "UM",
        "Uruguay" => "UY",
        "Uzbekistan" => "UZ",
        "Vanuatu" => "VU",
        "Venezuela" => "VE",
        "Vietnam" => "VN",
        "Virgin Islands, British" => "VG",
        "Virgin Islands, U.S." => "VI",
        "Wallis and Futuna" => "WF",
        "Western Sahara" => "EH",
        "Yemen" => "YE",
        "Zambia" => "ZM",
        "Zimbabwe" => "ZW"
    ];
    return $counties[$country] ?? null;
}

function showDocumentsInExcel(array $OrderData,int $i, object $objPHPExcel, int $rowCount): void
{
    $documentTypesAndCells = [
        'pod' => 'K',
        'signature' => 'L',
        'others' => 'M'
    ];
    $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $i);
    $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $OrderData['custid']);
    $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $OrderData['order_id']);
    $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $OrderData['ref_num']);
    $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $OrderData['pickup_city']);
    $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $OrderData['pickup_company'].", ".$OrderData['pickup_country'].", ".$OrderData['pickup_city'].", ".$OrderData['pickup_pincode'].", ".$OrderData['pickup_address']);
    $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $OrderData['pickup_datetime']);
    $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $OrderData['delivery_city']);
    $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $OrderData['delivery_company'].", ".$OrderData['delivery_country'].", ".$OrderData['delivery_city'].", ".$OrderData['delivery_pincode'].", ".$OrderData['delivery_address']);
    $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $OrderData['delivery_datetime']);

    $documentsData = $OrderData['epods'];
    foreach ($documentTypesAndCells as $documentType => $cell)
    {
        $imageTmp = "";
        if (count($documentsData[$documentType]) > 0) {
            $documentData = $documentsData[$documentType][0];
            $file = NEW_POD_PATH.$documentData['imgpath'];
            if (file_exists($file)) {
                $imageTmp = getImage($file);
            }
            if ($imageTmp != "") {
                $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
                $objDrawing->setName("Stop: " . $documentData['stopname']);
                $objDrawing->setDescription("Document: " . $documentData['type_name'] . ", Date: " . $documentData['createdon'] . ", Latitude: " . $documentData['latitude'] . ", Longitude: " . $documentData['longitude']);
                $objDrawing->setImageResource($imageTmp);
                $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_JPEG);
                $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
                $objDrawing->setHeight(80);
                $objDrawing->setCoordinates($cell . $rowCount);
                $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
                $url = base_url() . "sheet/epod/" . knencrypt($documentData['id']);
                $objPHPExcel->getActiveSheet()->getCell($cell . $rowCount)->getHyperlink()->setUrl($url)->setTooltip("Stop: " . $documentData['stopname'] . ", Document: " . $documentData['type_name'] . ", Date: " . $documentData['createdon'] . ", Latitude: " . $documentData['latitude'] . ", Longitude: " . $documentData['longitude']);
            }
        }
        if ($imageTmp == "") {
            $objPHPExcel->getActiveSheet()->SetCellValue($cell . $rowCount, "");
        }
    }
}

function getImage(string $path) {
    $extension = strtolower(pathinfo($path, PATHINFO_EXTENSION));
    switch($extension) {
        case 'png':
            $img = @imagecreatefromstring(file_get_contents($path));
            break;
        case 'jpg':
        case 'jpeg':
            $img = @imagecreatefromjpeg($path);
            break;
        case 'gif':
            $img = @imagecreatefromgif($path);
            break;
        case 'bmp':
            $img = @imagecreatefrombmp($path);
            break;
        default:
            $img = null;
    }
    return $img;
}
