<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
if (!function_exists('getPromiseDate')) {
    function getPromiseDate(array $data)
    {
        $ci = &get_instance();
        $expectedDeliveryDate = "";
        if ($data['orderRowId'] > 0) {
            if ($data['orderSource'] == '16') {
                $orderTypeName = "Return";
            } else {
                $orderTypeName = $data['orderTypeName'];
            }
            $deliveredDateTime = $data['deliveredDateTime'];
            $manifestDateTime = $data['manifestDateTime'];
            if ($data['vendorId'] == "310" && $data['rtoStatusDateTime'] != "") {
                $deliveredDateTime = $data['rtoStatusDateTime'];
            }
            $containerNumber = $data['containerNumber'];
            if ($containerNumber != "") {
                if ($data['orderSource'] == '16') {
                    $apiPincode = $data['pickupPincode'];
                    $orderType = 0;
                } else {
                    $apiPincode = $data['deliveryPincode'];
                    $orderType = 1;
                }
                if (checkAccessConditions('CHECK_UNIQLO_CARRIER', $data['vendorId'])) {
                    if ($manifestDateTime != "") {
                        $checkExpectedDelivery = getexpdeliverByOrderPin($apiPincode, $orderType, $manifestDateTime, $data['vendorId']);
                        if ($checkExpectedDelivery != "") {
                            if (strpos($checkExpectedDelivery, "1970-01-01") === false) {
                                $expectedDeliveryDate = ucwords(date("d M Y", strtotime($checkExpectedDelivery)));
                            }
                        }
                    }
                }
            }
            if ($data['branchCode'] == 'INCL' && $orderTypeName != 'CC') {
                if ($deliveredDateTime != "" && $expectedDeliveryDate == "") {
                    $expectedDeliveryDate = $deliveredDateTime;
                }
            }
            if ($data['companyCode'] == 'INKN' && $data['branchCode'] != 'INCL') {
                $delivery_status_array = getdatetimebytimezone($data['timeZone'], $data['deliveryDateTime'], DFLT_TZ);
                $expectedDeliveryDate = date('d M Y', strtotime($delivery_status_array['datetime']));
            }
        }
        return $expectedDeliveryDate;
    }
}

/*Calculate expected delivery data basedon TAT*/
if (!function_exists('getexpdeliverByPushApiData')) {
    function getexpdeliverByPushApiData($awb, $orderRowId)
    {
        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByPushApiData inbound data: " . $awb);

        $response = "";
        $ci = &get_instance();
        $sql = "SELECT promise_deliver_date FROM tb_order_details WHERE order_row_id='" . $orderRowId . "' ORDER BY id DESC LIMIT 1";
        $res = $ci->db->query($sql);
        if ($res->num_rows() > 0) {
            $response = $res->row()->promise_deliver_date;
            if (strpos($response, "1970-01-01") !== false) {
                $response = "";
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByPushApiData outbound data: " . $response);

        return $response;
    }
}

/*get expected delivery data basedon TAT from customer pincode table*/
if (!function_exists('getexpdeliverByOrderPin')) {
    function getexpdeliverByOrderPin($pincode, $ordtype, $manifestdate, $vendorid)
    {
        $response = "";
        if ($pincode != "" && $vendorid != "") {
            $curdt = $manifestdate;
            $tatval = "";
            $ci = &get_instance();
            $sql = "SELECT carrier_surface_tat,carrier_return_surface_tat FROM tb_customer_pincodes WHERE destination_pin='" . $pincode . "' AND carrier_id=$vendorid AND status=1 ORDER BY id DESC LIMIT 1";
            $res = $ci->db->query($sql);
            if ($res->num_rows() > 0) {
                $tatval = $res->row()->carrier_surface_tat;
                if ($ordtype == '0') {
                    $tatval = $res->row()->carrier_return_surface_tat;
                }
            }
            if ($curdt != "" && $tatval != "") {
                $response = date("Y-m-d", strtotime("+$tatval days", strtotime($curdt)));
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "getexpdeliverByOrderPin outbound data: " . $response);

        return $response;
    }
}
