<?php

/*
 * Purpose:     To get ru lang words for ru invoice only.
 * @param       line     string
 * return       string
 */

function ru_invoice_words($line) {
    $ru_invoice_word = array(
        'limited_liability_company_kuehne_Nagel' => 'Limited Liability Company "Kuehne + Nagel"',
        'address' => 'Address',
        'address_desc' => "",
        'recipient' => 'Recipient',
        'count_no' => 'Count. No',
        'payees_bank' => 'Payee\'s bank',
        "bik" => 'BIK',
        'account_no' => 'Account No ',
        'invoice_no' => 'Invoice No',
        'from' => 'From',
        'current_date' => 'Current Date',
        'contract_number' => 'Contract Number',
        'agreement_date' => 'Agreement date',
        'payee' => 'Payer',
        'consignee' => 'Consignee',
        's.No' => 'S.No',
        'name_of_service' => 'Name of service',
        'unit_of_measurement' => 'Unit of measurement',
        'amount' => 'Amount',
        'price' => 'Price',
        'amount' => 'Amount',
        'total' => 'Total',
        'total_vat' => 'Total VAT',
        'total_payable' => 'Total payable',
        'leader' => 'Leader',
        'power_of_attorney_no' => 'Power of Attorney No',
        'dated' => 'Dated',
        'signature' => 'Signature',
        'full_name' => 'Full name',
        'chief_accountant' => 'Chief Accountant',
        'total_items_charge' => 'Total items charge',
        'along_the_route' => 'along the route',
        'a_machine' => 'a machine',
        'services_for_period_earlist' => 'services for the period',
        'order_in_bill' => 'order in bill',
        'under_contract_no' => 'under contract no',
        'according_to_register_no' => 'according to register No',
        'for_the_amount' => 'на сумму'
    );
    $ru_invoice_word1 = array(
        'limited_liability_company_kuehne_Nagel' => 'Общество с ограниченной ответственностью "Кюне + Нагель"',
        'address' => 'Адрес',
        'address_desc' => '123001 г. Москва Трехпрудный переулок д.9,стр.1, офис 006,тел.+7(495)7952000, факс +7(495)7952009',
        'recipient' => 'Получатель',
        'count_no' => 'Сч. №',
        'payees_bank' => 'Банк получателя',
        'bik' => 'БИК',
        'account_no' => 'СЧЕТ №',
        'invoice_no' => 'Номер счета',
        'from' => 'От',
        'current_date' => 'Текущая дата',
        'contract_number' => 'Номер договора',
        'agreement_date' => 'Дата договора',
        'payee' => 'Плательщик',
        'consignee' => 'Грузополучатель',
        's.No' => '№',
        'name_of_service' => 'Наименование услуги',
        'unit_of_measurement' => 'Единица измерения',
        'amount' => 'Количество',
        'price' => 'Цена',
        'amount1' => 'Сумма',
        'total' => 'Итого',
        'total_vat' => 'Итого НДС',
        'total_payable' => 'Всего к оплате',
        'leader' => 'Руководитель',
        'power_of_attorney_no' => 'По доверенности №',
        'dated' => 'от',
        'signature' => 'Подпись',
        'full_name' => 'расшифровка подписи',
        'chief_accountant' => 'Главный бухгалтер',
        'total_items_charge' => 'Всего наименований',
        'along_the_route' => 'по маршруту',
        'a_machine' => 'машина',
        'services_for_period_earlist' => 'услуги на период',
        'order_in_bill' => 'заказ в счет',
        'under_contract_no' => 'по контракту №',
        'according_to_register_no' => 'согласно регистру №',
        'for_the_amount' => 'на сумму'
    );
    return $ru_invoice_word1[$line];
}

/*
 * Purpose:     This is supporting method for ru_invoice_words to serve ru lang words..
 * @param       line     string
 * return       string
 */

function ru_invoice_line($line) {
    return ru_invoice_words($line);
}

/*
 * Purpose: To change currency based on last digit in given whole number.
 * @param       $number     float
 * return       string
 */

function whole_number_part($number) {
    $word = "рублей";
    $last_digit = substr($number, -1);

    $number_length = strlen($number);
    if ($number_length == 2) {
        if ($number > 10 && $number < 20) {
            return $word;
        } else {
            $last_digit = substr($number, -1);
        }
    } else if ($number_length > 2) {
        $last_two_digits = substr($number, -2);
        if ($last_two_digits > 10 && $last_two_digits < 20) {
            return $word;
        } else {
            $last_digit = substr($last_two_digits, -1);
        }
    }

    if (in_array($last_digit, array(1))) {
        $word = "рубль";
    } else if (in_array($last_digit, array(2, 3, 4))) {
        $word = "рубля";
    }
    return $word;
}

/*
 * Purpose: To change currency based on last digit in given fractional number.
 * @param       $number     float
 * return       string
 */

function fractional_number_part($number) {
    $word = "копеек";
    $last_digit = substr($number, -1);

    $number_length = strlen($number);
    if ($number_length == 2) {
        if ($number > 10 && $number < 20) {
            return $word;
        } else {
            $last_digit = substr($number, -1);
        }
    } else if ($number_length > 2) {
        $last_two_digits = substr($number, -2);
        if ($last_two_digits > 10 && $last_two_digits < 20) {
            return $word;
        } else {
            $last_digit = substr($last_two_digits, -1);
        }
    }

    if (in_array($last_digit, array("1"))) {
        $word = "копейка";
    } else if (in_array($last_digit, array("2", "3", "4"))) {
        $word = "копейки";
    }
    return $word;
}

/*
 *  Purpose : To restructure final amount .
 *  @param      arg1        float
 *  return float.
 */

function amount_restructure($arg1) {
    $step1 = str_replace(',', '', $arg1);
    $step2 = str_replace('.', ',', $step1);
    return $step2;
}

function ru_invoice_date_format($date) {
    if (validateDate($date, $format = 'Y-m-d') && $date != '0000-00-00') {
        if (false === strtotime($date)) {
            return "";
        }
        if ($date != "") {
            $date = date_create($date);
            return date_format($date, "d.m.Y");
        }
    }
    return "";
}

function validateDate($date, $format = 'Y-m-d') {
    $d = DateTime::createFromFormat($format, $date);
    return $d && $d->format($format) === $date;
}

function ru_invoice_signature() {
    $ci = & get_instance();
    $user_id = $ci->session->userdata('user_id');
    $signpath = "";
    if (isset($_SESSION["childid"])) {
        $childId = $ci->session->userdata('childid');
        $get_signaturepath = $ci->common->gettblrowdata(["id" => $childId], 'signpath', 'tb_user_logins', 0, 0);
        if (!empty($get_signaturepath)) {
            $signpath = $get_signaturepath['signpath'];
        }
    } else {
        $get_userdetails = $ci->common->gettblrowdata(array("id" => $user_id), 'signpath', 'tb_users', 0, 0);
        if (!empty($get_userdetails)) {
            $signpath = $get_userdetails['signpath'];
        }
    }
    return $signpath;
}

/**
 * https://habr.com/ru/post/53210/
 * Возвращает сумму прописью
 * @author runcore
 * @uses morph(...)
 */
function num2str($num) {
    $nul = 'ноль';
    $ten = array(
        array('', 'один', 'два', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять'),
        array('', 'одна', 'две', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять'),
    );
    $a20 = array('десять', 'одиннадцать', 'двенадцать', 'тринадцать', 'четырнадцать', 'пятнадцать', 'шестнадцать', 'семнадцать', 'восемнадцать', 'девятнадцать');
    $tens = array(2 => 'двадцать', 'тридцать', 'сорок', 'пятьдесят', 'шестьдесят', 'семьдесят', 'восемьдесят', 'девяносто');
    $hundred = array('', 'сто', 'двести', 'триста', 'четыреста', 'пятьсот', 'шестьсот', 'семьсот', 'восемьсот', 'девятьсот');
//    $unit = array(// Units
//        array('копейка', 'копейки', 'копеек', 1),
//        array('рубль', 'рубля', 'рублей', 0),
//        array('тысяча', 'тысячи', 'тысяч', 1),
//        array('миллион', 'миллиона', 'миллионов', 0),
//        array('миллиард', 'милиарда', 'миллиардов', 0),
//    );
    $unit = array(// Units
        array('коп.', 'коп.', 'коп.', 1),
        array('руб.', 'руб.', 'руб.', 0),
        array('тысяча', 'тысячи', 'тысяч', 1),
        array('миллион', 'миллиона', 'миллионов', 0),
        array('миллиард', 'милиарда', 'миллиардов', 0),
    );
    //
    list($rub, $kop) = explode('.', sprintf("%015.2f", floatval($num)));
    $out = array();
    if (intval($rub) > 0) {
        foreach (str_split($rub, 3) as $uk => $v) { // by 3 symbols
            if (!intval($v))
                continue;
            $uk = sizeof($unit) - $uk - 1; // unit key
            $gender = $unit[$uk][3];
            list($i1, $i2, $i3) = array_map('intval', str_split($v, 1));
            // mega-logic
            $out[] = $hundred[$i1]; # 1xx-9xx
            if ($i2 > 1)
                $out[] = $tens[$i2] . ' ' . $ten[$gender][$i3];# 20-99
            else
                $out[] = $i2 > 0 ? $a20[$i3] : $ten[$gender][$i3];# 10-19 | 1-9
            // units without rub & kop
            if ($uk > 1)
                $out[] = morph($v, $unit[$uk][0], $unit[$uk][1], $unit[$uk][2]);
        } //foreach
    } else
        $out[] = $nul;
        $out[] = morph(intval($rub), $unit[1][0], $unit[1][1], $unit[1][2]); // rub
    /*
     *  RT Lines
     */
    if (class_exists('NumberFormatter')) {
        $f = new NumberFormatter("ru", NumberFormatter::SPELLOUT);
        $decimlword = $f->format($kop);
        if(strpos($decimlword, "один") !== false) {
        $decimlword = str_replace('один', 'одна',  $decimlword);
       }
       if(strpos($decimlword, "два") !== false) {
        $decimlword = str_replace('два', 'две',  $decimlword);
       }
       if(strpos($decimlword, "дведцать") !== false) {
        $decimlword = str_replace('дведцать', 'двадцать',  $decimlword);
       }
        $out[] = $decimlword . ' ' . morph($kop, $unit[0][0], $unit[0][1], $unit[0][2]);
    } else {
        $out[] = $kop . ' ' . morph($kop, $unit[0][0], $unit[0][1], $unit[0][2]); // kop
    }
    $word = trim(preg_replace('/ {2,}/', ' ', join(' ', $out)));
    $firstChar = mb_substr($word, 0, 1, 'utf8');
    $remaining_string = mb_substr($word, 1, null, 'utf8');
    $word = mb_strtoupper($firstChar, 'utf8') . $remaining_string;
    return $word;
}

/**
 * Склоняем словоформу
 * @ author runcore
 */
function morph($n, $f1, $f2, $f5) {
    $n = abs(intval($n)) % 100;
    if ($n > 10 && $n < 20)
        return $f5;
    $n = $n % 10;
    if ($n > 1 && $n < 5)
        return $f2;
    if ($n == 1)
        return $f1;
    return $f5;
}

function invoice_dynamic_description($invoice_id){
    $description=FALSE;
    $ci = & get_instance();
    $invoice_data=$ci->common->gettblrowdata(array("id" => $invoice_id), 'invoice_description', 'tbl_bills', 0, 0);
    $invoice_description=$invoice_data['invoice_description'];
    if(isset($invoice_description) && $invoice_description!='NULL' && $invoice_description!='' && strlen(trim($invoice_description))>0){
        $description=$invoice_description;
    }
    return $description;
}

?>
