<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

function sendOTMStatusOLD(array $request)
{
    $ci = &get_instance();
    $ci->load->model('common');
    $resname = $request['glogDate'];
    $externalOrderId = $request['externalOrderId'];
    $orderStatusDateTime = $request['orderStatusDateTime'];
    $createdSource = $request['createdSource'] ?: "";
    $orderStatusDate = new DateTime($orderStatusDateTime); // Convert string to DateTime object
    $formattedDate = $orderStatusDate->format('YmdHis');
    $otmStatus = $request['otmStatus'];
    $domainName = $request['domainName'];
    $serviceurl = $userName = $password = "";
    if($createdSource == ""){
        $getCreatedSource = $ci->common->gettblrowdata(["external_order_id" => $externalOrderId], "created_source", "tb_orders", 0, 0);
        $createdSource = $getCreatedSource['created_source'];
    }
    if($createdSource == 24){
        $otmObject = "Cloud_Event";
    }else{  
        $otmObject = "Event";
    }
    $getOtmUserDetails = $ci->common->gettblrowdata(["domain" => $domainName,"object"=>$otmObject], "url, username, password", "int_cred", 0, 0);
    
    //log_message('error', "Query: " . $ci->db->last_query());
    if(empty($getOtmUserDetails)){
        return "";
    }
    
    $serviceurl = $getOtmUserDetails['url'];
    $userName = $getOtmUserDetails['username'];
    $password = $getOtmUserDetails['password'];
    
    /*$usernamePassword = $ci->db->select("url, username, password")->from("int_cred")->where(["domain" => $domainName, "object" => "Event"])->limit(1)->get();
    if($usernamePassword->num_rows() > 0 ) {
        $row = $usernamePassword->row();
        $serviceurl = $row->url;
        $userName = $row->username;
        $password = $row->password;
        //$password = decryptCryptoLibPassword($password);
    }*/
    $request = '';
    $request .= "<?xml version='1.0'?>";
    $request .= "<otm:Transmission xmlns:otm='http://xmlns.oracle.com/apps/otm/transmission/v6.4' xmlns:gtm='http://xmlns.oracle.com/apps/gtm/transmission/v6.4'>";
    $request .= "<otm:TransmissionHeader>";
    $request .= "<otm:Version>6.5.2.1-20240510</otm:Version>";
    $request .= "<otm:TransmissionCreateDt>";
    $request .= "<otm:GLogDate>" . $resname . "</otm:GLogDate>";
    $request .= "<otm:TZId>America/New_York</otm:TZId>";
    $request .= "<otm:TZOffset>-04:00</otm:TZOffset>";
    $request .= "</otm:TransmissionCreateDt>";
    $request .= "<otm:TransactionCount>1</otm:TransactionCount>";
    $request .= "<otm:SenderHostName>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderHostName>";
    $request .= "<otm:SenderSystemID>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderSystemID>";
    $request .= "<otm:userName>" . $userName . "</otm:userName>";
    $request .= "<otm:SenderTransmissionNo></otm:SenderTransmissionNo>";
    $request .= "<otm:ReferenceTransmissionNo>1</otm:ReferenceTransmissionNo>";
    $request .= "</otm:TransmissionHeader>";
    $request .= "<otm:TransmissionBody>";
    $request .= "<otm:GLogXMLElement>";
    $request .= "<otm:TransactionHeader>";
    $request .= "<otm:SenderTransactionId></otm:SenderTransactionId>";
    $request .= "</otm:TransactionHeader>";
    $request .= "<otm:TransOrderStatus>";
    $request .= "<otm:ReleaseGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $externalOrderId . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:ReleaseGid>";
    $request .= "<otm:StatusLevel>ORDER</otm:StatusLevel>";
    $request .= "<otm:OrderRefnum>";
    $request .= "<otm:OrderRefnumQualifierGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:Xid>GLOG</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:OrderRefnumQualifierGid>";
    $request .= "<otm:OrderRefnumValue>" . $domainName . "." . $externalOrderId . "</otm:OrderRefnumValue>";
    $request .= "</otm:OrderRefnum>";
    $request .= "<otm:StatusCodeGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:StatusCodeGid>";
    $request .= "<otm:StatusReasonCodeGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:StatusReasonCodeGid>";
    $request .= "<otm:TimeZoneGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:Xid>Local</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:TimeZoneGid>";
    $request .= "<otm:EventDt>";
    $request .= "<otm:GLogDate>" . $formattedDate . "</otm:GLogDate>";
    $request .= "<otm:TZId>Local</otm:TZId>";
    $request .= "<otm:TZOffset>+00:00</otm:TZOffset>";
    $request .= "</otm:EventDt>";
    $request .= "<otm:StatusGroup>";
    $request .= "<otm:StatusGroupGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:StatusGroupGid>";
    $request .= "</otm:StatusGroup>";
    $request .= "<otm:ReasonGroup>";
    $request .= "<otm:ReasonGroupGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
    $request .= '</otm:Gid>';
    $request .= '</otm:ReasonGroupGid>';
    $request .= '</otm:ReasonGroup>';
    $request .= '<otm:ResponsiblePartyGid>';
    $request .= '<otm:Gid>';
    $request .= '<otm:Xid>CARRIER</otm:Xid>';
    $request .= '</otm:Gid>';
    $request .= '</otm:ResponsiblePartyGid>';
    $request .= '<otm:ReportingUser>' . $userName . '</otm:ReportingUser>';
    $request .= '</otm:TransOrderStatus>';
    $request .= '</otm:GLogXMLElement>';
    $request .= '</otm:TransmissionBody>';
    $request .= '</otm:Transmission>';
    //log_message('error', "request: " . $request);
    $dom = new DOMDocument;
    $dom->preserveWhiteSpace = false;
    $dom->loadXML($request);
    /*log_message('error', "serviceurl: " . $serviceurl);
    log_message('error', "userName: " . $userName);
    log_message('error', "password: " . $password);*/
   // $dom->save('xml/otm_status/OTM_STATUS_' . $resname . '.xml');
    $auth = base64_encode($userName . ':' . $password);
    $headers = [
        'Content-Type: application/xml',
        'Authorization: Basic ' . base64_encode("$userName:$password"),
    ];
    $output = thirdpartyotmservicecurl($serviceurl, $headers, $request);
    log_message('error', "response: " . json_encode($output));
    return $output;
}

function sendOTMStatus(array $request)
{
    $ci = &get_instance();
    $ci->load->model('common');
    $resname = $request['glogDate'];
    $externalOrderId = $request['externalOrderId'];
    $orderStatusDateTime = $request['orderStatusDateTime'];
    $domainName = $request['domainName'];
    $createdSource = $request['createdSource'] ?: "";
    $timeZone = $request['timeZone'] ?: "";
    if($createdSource == "" || $timeZone == ""){
        $getCreatedSource = $ci->common->gettblrowdata(["external_order_id" => $externalOrderId], "user_id,created_source", "tb_orders", 0, 0);
        $ci->load->model('standardbookingmodel');
        $timeZone = $ci->standardbookingmodel->getUserTimeZone($getCreatedSource['user_id']);
        $userId = $getCreatedSource['user_id'];
        $createdSource = $getCreatedSource['created_source'];
    }
    /*$date = getdatetimebytimezone(DFLT_TZ, $orderStatusDateTime, $timeZone)["datetime"];
    $utcDateTime = new DateTime($date, new DateTimeZone('UTC'));
    $formattedDate = $utcDateTime->format('YmdHis');*/
    $orderStatusDate = new DateTime($orderStatusDateTime); // Convert string to DateTime object
    $formattedDate = $orderStatusDate->format('YmdHis');
    if($createdSource == 24){
        $otmObject = "Cloud_Event";
    }else{  
        $otmObject = "Event";
    }
    $getOtmUserDetails = $ci->common->gettblrowdata(["domain" => $domainName,"object"=>$otmObject], "url, username, password", "int_cred", 0, 0);
    if(empty($getOtmUserDetails)){
        return "";
    }
    $statusWhereCondition['svk_status'] = $request['orderStatusCode'];
    if($createdSource == 24){
        $statusWhereCondition['external_type'] = 'KNOTMCLD';
    }else{
        $statusWhereCondition['external_type'] = 'KNOTMOP';
    }
    $getOtmStatusCode = $ci->common->gettblrowdata($statusWhereCondition, "otm_status", "tb_edi_status", 0, 0);
    //echo $ci->db->last_query();
    if(empty($getOtmStatusCode)){
        return "";
    }
    $otmStatus = $getOtmStatusCode['otm_status'];
    $serviceurl = $getOtmUserDetails['url'];
    $userName = $getOtmUserDetails['username'];
    $password = $getOtmUserDetails['password'];
   
    if($createdSource == 24){
        $request = "<?xml version='1.0'?>";
        $request = "<otm:Transmission xmlns:otm='http://xmlns.oracle.com/apps/otm/transmission/v6.4' xmlns:gtm='http://xmlns.oracle.com/apps/gtm/transmission/v6.4'>";
    }else{
        $request = "<?xml version='1.0'?>";
        $request = "<otm:Transmission>";
    }
    $request .= "<otm:TransmissionHeader>";
    $request .= "<otm:Version>6.5.2.1-".date('ymd')."</otm:Version>";
    $request .= "<otm:TransmissionCreateDt>";
    $request .= "<otm:GLogDate>" . $resname . "</otm:GLogDate>";
    $request .= "<otm:TZId>UTC</otm:TZId>";
    $request .= "<otm:TZOffset>00:00</otm:TZOffset>";
    $request .= "</otm:TransmissionCreateDt>";
    $request .= "<otm:TransactionCount>1</otm:TransactionCount>";
    if($createdSource == 24){
        $request .= "<otm:SenderHostName>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</otm:SenderHostName>";
        $request .= "<otm:SenderSystemID>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</otm:SenderSystemID>";
        $request .= "<otm:UserName>" . $userName . "</otm:UserName>";
    }else{
        $request .= "<otm:SenderHostName>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderHostName>";
        $request .= "<otm:SenderSystemID>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderSystemID>"; 
        $request .= "<otm:userName>" . $userName . "</otm:userName>";
    }
    $request .= "<otm:SenderTransmissionNo>E$formattedDate</otm:SenderTransmissionNo>";
    $request .= "<otm:ReferenceTransmissionNo>1</otm:ReferenceTransmissionNo>";
    $request .= "</otm:TransmissionHeader>";
    $request .= "<otm:TransmissionBody>";
    $request .= "<otm:GLogXMLElement>";
    $request .= "<otm:TransactionHeader>";
    $request .= "<otm:SenderTransactionId>E$formattedDate</otm:SenderTransactionId>";
    $request .= "</otm:TransactionHeader>";
    $request .= "<otm:TransOrderStatus>";
    $request .= "<otm:ReleaseGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $externalOrderId . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:ReleaseGid>";
    //$request .= "<otm:TransactionCode>IU</otm:TransactionCode>";
    $request .= "<otm:StatusLevel>ORDER</otm:StatusLevel>";
    $request .= "<otm:OrderRefnum>";
    $request .= "<otm:OrderRefnumQualifierGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:Xid>GLOG</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:OrderRefnumQualifierGid>";
    $request .= "<otm:OrderRefnumValue>" . $domainName . "." . $externalOrderId . "</otm:OrderRefnumValue>";
    $request .= "</otm:OrderRefnum>";
    $request .= "<otm:StatusCodeGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:StatusCodeGid>";
    $request .= "<otm:StatusReasonCodeGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
    $request .= "<otm:Xid>1000</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:StatusReasonCodeGid>";
    $request .= "<otm:TimeZoneGid>";
    $request .= "<otm:Gid>";
    $request .= "<otm:Xid>UTC</otm:Xid>";
    $request .= "</otm:Gid>";
    $request .= "</otm:TimeZoneGid>";
    $request .= "<otm:EventDt>";
    $request .= "<otm:GLogDate>" . $formattedDate . "</otm:GLogDate>";
    $request .= "<otm:TZId>UTC</otm:TZId>";
    $request .= "<otm:TZOffset>+00:00</otm:TZOffset>";
    $request .= "</otm:EventDt>";
    if($createdSource != 24){
        $request .= "<otm:StatusGroup>";
        $request .= "<otm:StatusGroupGid>";
        $request .= "<otm:Gid>";
        $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
        $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
        $request .= "</otm:Gid>";
        $request .= "</otm:StatusGroupGid>";
        $request .= "</otm:StatusGroup>";
        $request .= "<otm:ReasonGroup>";
        $request .= "<otm:ReasonGroupGid>";
        $request .= "<otm:Gid>";
        $request .= "<otm:DomainName>" . $domainName . "</otm:DomainName>";
        $request .= "<otm:Xid>" . $otmStatus . "</otm:Xid>";
        $request .= '</otm:Gid>';
        $request .= '</otm:ReasonGroupGid>';
        $request .= '</otm:ReasonGroup>';
    }
    $request .= '<otm:ResponsiblePartyGid>';
    $request .= '<otm:Gid>';
    $request .= '<otm:Xid>CARRIER</otm:Xid>';
    $request .= '</otm:Gid>';
    $request .= '</otm:ResponsiblePartyGid>';
    $request .= '<otm:ReportingUser>' . $userName . '</otm:ReportingUser>';
    $request .= '</otm:TransOrderStatus>';
    $request .= '</otm:GLogXMLElement>';
    $request .= '</otm:TransmissionBody>';
    $request .= '</otm:Transmission>';
    log_message('error', "Otm-Status-request: " . $request);
   // exit;
    $headers = [
        'Content-Type: application/xml',
        'Authorization: Basic ' . base64_encode("$userName:$password"),
    ];
    $output = thirdpartyotmservicecurl($serviceurl, $headers, $request);
    log_message('error', "Otm-Status-response: " . json_encode($output));
    return $output;
}


function sendOTMDocuments(array $request)
{
    $ci = &get_instance();
    $ci->load->model('common');
    $resname = $request['glogDate'];
    $externalOrderId = $request['externalOrderId'];
    $domainName = $request['domainName'];
    $createdSource = $request['createdSource'] ?: "";
    $timeZone = $request['timeZone'] ?: "";
    $base64String = $request['base64String'] ?: "";
    $docTypewithCnt = $request['docType'] ?: "";
    if (strpos($docTypewithCnt, '-') !== false) {
        $docType = explode('-', $docTypewithCnt)[0];
    } else {
        $docType = $docTypewithCnt;
    }
    if($createdSource == "" || $timeZone == ""){
        $getCreatedSource = $ci->common->gettblrowdata(["external_order_id" => $externalOrderId], "user_id,created_source", "tb_orders", 0, 0);
        $ci->load->model('standardbookingmodel');
        $timeZone = $ci->standardbookingmodel->getUserTimeZone($getCreatedSource['user_id']);
        $userId = $getCreatedSource['user_id'];
        $createdSource = $getCreatedSource['created_source'];
    }
    if($createdSource == 24){
        $otmObject = "Cloud_Event";
    }else{  
        $otmObject = "Event";
    }
    $getOtmUserDetails = $ci->common->gettblrowdata(["domain" => $domainName,"object"=>$otmObject], "url, username, password", "int_cred", 0, 0);
    if(empty($getOtmUserDetails)){
        return "";
    }
    
    $serviceurl = $getOtmUserDetails['url'];
    $userName = $getOtmUserDetails['username'];
    $password = $getOtmUserDetails['password'];
    
    $request = "<?xml version='1.0' encoding='UTF-8'?>";
    $request .= "<Transmission>";
    $request .= "<TransmissionHeader>";
    $request .= "<Version>6.4.3</Version>";
    $request .= "<TransmissionCreateDt>";
    $request .= "<GLogDate>" . $resname . "</GLogDate>";
    $request .= "<TZId>GMT</TZId>";
    $request .= "<TZOffset>+00:00</TZOffset>";
    $request .= "</TransmissionCreateDt>";
    $request .= "<TransactionCount>1</TransactionCount>";
    if($createdSource == 24){
        $request .= "<SenderHostName>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</SenderHostName>";
        $request .= "<SenderSystemID>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</SenderSystemID>";
    }else{
        $request .= "<otm:SenderHostName>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderHostName>";
        $request .= "<otm:SenderSystemID>https://otmna2-test.amer.kuehne-nagel.com</otm:SenderSystemID>"; 
    }
    $request .= "<UserName>" . $userName . "</UserName>";
    $request .= "<Password>" . $password . "</Password>";
    $request .= "<SenderTransmissionNo>XL" . $resname . "</SenderTransmissionNo>";
    $request .= "</TransmissionHeader>";
    $request .= "<TransmissionBody>";
    $request .= "<GLogXMLElement>";
    $request .= "<TransactionHeader>";
    $request .= "<SenderTransactionId>XL" . $resname . "</SenderTransactionId>";
    $request .= "<SendReason>";
    $request .= "<Remark>";
    $request .= "<RemarkSequence>1</RemarkSequence>";
    $request .= "<RemarkQualifierGid>";
    $request .= "<Gid>";
    $request .= "<Xid>REM</Xid>";
    $request .= "</Gid>";
    $request .= "</RemarkQualifierGid>";
    $request .= "<RemarkText>" . $externalOrderId . "</RemarkText>";
    $request .= "</Remark>";
    $request .= "<SendReasonGid>";
    $request .= "<Gid>";
    $request .= "<Xid>DOCUMENT - CREATED</Xid>";
    $request .= "</Gid>";
    $request .= "</SendReasonGid>";
    $request .= "<ObjectType>DOCUMENT</ObjectType>";
    $request .= "</SendReason>";
    $request .= "</TransactionHeader>";
    $request .= "<Document>";
    $request .= "<DocumentGid>";
    $request .= "<Gid>";
    $request .= "<DomainName>" . $domainName . "</DomainName>";
    $request .= "<Xid>" . $externalOrderId . "-" . $docTypewithCnt . "</Xid>";
    $request .= "</Gid>";
    $request .= "</DocumentGid>";
    $request .= "<TransactionCode>IU</TransactionCode>";
    $request .= "<DocumentDefinitionGid>";
    $request .= "<Gid>";
    $request .= "<DomainName>" . $domainName . "</DomainName>";
    $request .= "<Xid>" . $docType . "</Xid>";
    $request .= "</Gid>";
    $request .= "</DocumentDefinitionGid>";
    $request .= "<DocumentOwner>";
    $request .= "<DataQueryTypeGid>";
    $request .= "<Gid>";
    $request .= "<Xid>ORDER RELEASE</Xid>";
    $request .= "</Gid>";
    $request .= "</DataQueryTypeGid>";
    $request .= "<ObjectGid>";
    $request .= "<Gid>";
    $request .= "<DomainName>" . $domainName . "</DomainName>";
    $request .= "<Xid>" . $externalOrderId . "</Xid>";
    $request .= "</Gid>";
    $request .= "</ObjectGid>";
    $request .= "</DocumentOwner>";
    $request .= "<DocumentContent>";
    $request .= "<DocMimeType>application/pdf</DocMimeType>";
    $request .= "<DocContentBinary>" . $base64String . "</DocContentBinary>";
    $request .= "</DocumentContent>";
    $request .= "</Document>";
    $request .= "</GLogXMLElement>";
    $request .= "</TransmissionBody>";
    $request .= "</Transmission>";

    log_message('error', "Otm-DOC-request: " . $request);
   // exit;
    $headers = [
        'Content-Type: application/xml',
        'Authorization: Basic ' . base64_encode("$userName:$password"),
    ];
    $output = thirdpartyotmservicecurl($serviceurl, $headers, $request);
    log_message('error', "Otm-DOC-response: " . json_encode($output));
    return $output;
}

