<?php if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/*get user country info*/

use App\Helpers\ParsedOrderIdHelper;
use App\Libraries\UniqueOrderIdGeneratorService;
use App\Models\OrderIdModel;

if (! function_exists('getUserTimeZone')) {
    function getUserTimeZone($cmpcode = null)
    {
        $res = ["currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG", "phone_code" => "65"];
        if ($cmpcode != "") {
            $ci     = &get_instance();
            $getqry = $ci->db->query("SELECT country_code,cntry_timezone,cntry_hrs,currency,phone_code FROM tbl_country_master WHERE country_code='" . $cmpcode . "' AND status=1 LIMIT 1");
            if ($getqry->num_rows() > 0) {
                $res = ["currency" => $getqry->row()->currency, "timezone" => $getqry->row()->cntry_timezone, "hrs" => $getqry->row()->cntry_hrs, 'country' => $getqry->row()->country_code, "phone_code" => $getqry->row()->phone_code];
            }
        }

        return $res;
    }
}

/*get user country info by user_id*/
if (! function_exists('getUserIDTimeZone')) {
    function getUserIDTimeZone($id)
    {
        $res = ["currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG", "phone_code" => "65"];
        if ($id != "") {
            $ci      = &get_instance();
            $getqry1 = $ci->db->query("SELECT country_code FROM tb_users WHERE id='" . $id . "' LIMIT 1");
            if ($getqry1->num_rows() > 0) {
                $cmpcode = $getqry1->row()->country_code;
                $getqry  = $ci->db->query("SELECT country_code,cntry_timezone,cntry_hrs,currency,phone_code FROM tbl_country_master WHERE country_code='" . $cmpcode . "' AND status=1 LIMIT 1");
                if ($getqry->num_rows() > 0) {
                    $res = ["currency" => $getqry->row()->currency, "timezone" => $getqry->row()->cntry_timezone, "hrs" => $getqry->row()->cntry_hrs, 'country' => $getqry->row()->country_code, "phone_code" => $getqry->row()->phone_code];
                }
            }
        }

        return $res;
    }
}
/* CHECK COUNTRY WISE RECORDS FOR LOGIN USERS */

if (! function_exists('checkuserpermissions')) {
    function checkuserpermissions()
    {
        $ci                = &get_instance();
        $result            = ['businesspartners', 'carrier'];
        $user_company_code = $ci->session->userdata('company_code');
        $user_role_id      = $ci->session->userdata('user_role_id');
        if ($ci->session->userdata('business_type') == 'Country Admin') {
            $result[] = 'orders';
        }
        if ('2' === $user_role_id) {
            if ('SGKN' === $user_company_code || 'MYKN' === $user_company_code) {
                $result = ['orders', 'businesspartners', 'vehicles', 'trips', 'carrier', 'drivers'];
            } elseif ('RUKN' === $user_company_code) {
                $result = ['businesspartners', 'carrier', 'vehicletypes', 'vehicles', 'drivers'];
            } elseif ('VNKN' === $user_company_code) {
                $result = ['vehicletypes', 'trips', 'carrier', 'businesspartners', 'vehicles', 'drivers'];
            } elseif ('AUKN' === $user_company_code || 'KNAU' === $user_company_code) {
                $result = ['carrier', 'vehicletypes', 'businesspartners', 'vehicles'];
            }
        } else if ('3' === $user_role_id && 'VNKN' === $user_company_code) {
            $result = ['vehicles', 'drivers'];
        }
        return $result;
    }
}
/* baseurl added based on boolean value to fix manage doc and ePod */
if (! function_exists('checkimageintmsorknlmv')) {
    function checkimageintmsorknlmv($img, $returnFileSystemPath = true)
    {
        $imglink = "";
        if ($img != "") {
            $imglink = NEW_POD_PATH . $img;
        }
        return $imglink;
    }
}
/* convert pdf to image */
if (! function_exists('convertpdftoimg')) {
    function convertpdftoimg($img)
    {
        $ci = &get_instance();
        $ci->load->library('Convertpdftoimage');
        $img1    = $ci->convertpdftoimage->convertpdftopng($img);
        $imglink = NEW_POD_PATH . $img1;
        return $imglink;
    }
}

/* checking Debitor jfr code to be updated or not*/
if (! function_exists('getdebitorcode_multiplerevenue')) {
    function getdebitorcode_multiplerevenue($orderids)
    {
        $ci         = &get_instance();
        $upd_orders = $rev_ids = [];
        $debtor_jfr = "";
        $ci->load->model('common');
        $ci->load->model('multipleaconedimodel');
        $ci->load->library('newjfrlogic_sgmy');
        $ci->load->library('ratemanagement');
        $trip_id = 0;
        if (! empty($orderids)) {
            $res = $ci->multipleaconedimodel->checktrip_existsornot($orderids);
            if (! empty($res)) {
                foreach ($res as $rr) {
                    $trip_id  = $rr['trip_id'];
                    $order_id = $rr['order_id'];
                    $user_id  = $rr['user_id'];
                    if ($trip_id > 0) {
                        $get_country  = $ci->db->select('country_code,company_code')->get_where("tb_users", ['id' => $user_id]);
                        $country_code = $get_country->row()->country_code;
                        $company_code = $get_country->row()->company_code;
                        $cdate        = date('Y-m-d H:i:s');
                        $curtz        = $ci->session->userdata("usr_tzone")['timezone'];
                        $getactual    = getdatetimebytimezone(DFLT_TZ, $cdate, $curtz);
                        $cdate        = $getactual['datetime'];
                        $info         = ['country_code' => $country_code, 'user_id' => $user_id, 'revnue_id' => '0', 'order_id' => $order_id, 'trip_id' => $trip_id, 'sts_createdon' => $cdate];
                        $debtor_jfr   = "";
                        if ($company_code == "SGKN" || $company_code == "MYKN") {
                            $debtor_jfr = $ci->newjfrlogic_sgmy->generatedebitro_jfrcode_sgmyorders($info);
                        } else {
                            if ($trip_id > 0) {
                                $debtor_jfr = generatedebitro_jfrcode($info);
                            }
                        }
                        if ($debtor_jfr != "") {
                            $upd_orders[] = $order_id;
                            $getrev       = $ci->db->select("id,currency,exchange_rate,foreign_currency")->get_where("tb_reveneus", ["type" => '1', "recipient_role" => 'Carrier', "order_id" => $order_id, "invoice_status" => '0', "status" => '1']);
                            if ($getrev->num_rows() > 0) {
                                foreach ($getrev->result() as $res) {
                                    $rev_ids[] = $res->id;
                                    if ($res->id > 0) {
                                        $foreign_currency = $res->foreign_currency;
                                        $session_currency = $res->currency;
                                        if ($foreign_currency != "") {
                                            $exchange_rate = $res->exchange_rate;
                                            if ($exchange_rate > 0) {
                                                $upd = $ci->db->where('id', $res->id)->update("tb_reveneus", ['invoice_status' => "1", 'debtor_jfr' => $debtor_jfr]);
                                            } else {
                                                $exchange_info        = ['exchange_rate_id' => '0', 'from_currency' => $foreign_currency, 'to_currency' => $session_currency, 'user_id' => $user_id, 'order_id' => $order_id, 'revenue_id' => $res->id];
                                                $exchange_rate_amount = $ci->ratemanagement->getexchnageamountfromcurrency($exchange_info);
                                                if ($exchange_rate_amount > 0) {
                                                    $ci->exchangerate->updatelocalamout_byexchangerate($res->id, $exchange_rate_amount, $foreign_currency);
                                                    $upd = $ci->db->where('id', $res->id)->update("tb_reveneus", ['invoice_status' => "1", 'debtor_jfr' => $debtor_jfr]);
                                                } else {
                                                    $upd_examount = $ci->common->updatetbledata("tb_reveneus", ['foreign_currency' => $foreign_currency], ['id' => $res->id]);
                                                }
                                            }
                                        } else {
                                            $upd = $ci->db->where('id', $res->id)->update("tb_reveneus", ['invoice_status' => "1", 'debtor_jfr' => $debtor_jfr]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return $rev_ids;
    }
}

/*Genereate debitor_jfr code*/
if (! function_exists('generatedebitro_jfrcode')) {
    function generatedebitro_jfrcode($info)
    {

        $ci         = &get_instance();
        $debtor_jfr = "";
        $ci->load->model('common');
        $dcode   = $ord_createdon   = $department_code   = $company_code   = $branch_code   = "";
        $service = 0;
        if (! empty($info)) {
            $order_id = $info['order_id'];
            $trip_id  = $info['trip_id'];
            $user_id  = $info['user_id'];
  
            $sts_createdon = isset($info['sts_createdon']) ? $info['sts_createdon'] : date('Y-m-d H:i:s');

            /* Case 1 check with Orderid */
            $chkjfr_with_ordid = $ci->db->query("SELECT r.debtor_jfr FROM tb_reveneus r,tb_orders o WHERE r.order_id ='" . $order_id . "' AND o.id=r.order_id  AND r.debtor_jfr IS NOT NULL  AND r.debtor_jfr !='' AND r.status =1");
            if ($chkjfr_with_ordid->num_rows() > 0) {
                $debtor_jfr = $chkjfr_with_ordid->row()->debtor_jfr;
            } else {
                /* start get traffic and spill codes */
                $getdepartment_code = $ci->db->query("SELECT o.company_code,o.branch_code,o.createdon,d.service,d.department_code FROM tb_orders o,tb_order_details d WHERE o.id='" . $order_id . "' AND o.id=d.order_row_id");
                if ($getdepartment_code->num_rows() > 0) {
                    $department_code = $getdepartment_code->row()->department_code;
                    $ord_createdon   = $getdepartment_code->row()->createdon;
                    $company_code    = $getdepartment_code->row()->company_code;
                    $branch_code     = $getdepartment_code->row()->branch_code;
                    $service         = $getdepartment_code->row()->service;
                } else {
                    $getcodes = $ci->common->gettblrowdata(['id' => $order_id], "company_code,branch_code", "tb_orders", 0, 0);
                    if (! empty($getcodes)) {
                        $company_code = $getcodes['company_code'];
                        $branch_code  = $getcodes['branch_code'];
                    }
                }
                if ($company_code == "") {
                    $company_code = $ci->session->userdata('company_code');
                }
                if ($branch_code == "") {
                    $branch_code = $ci->session->userdata('branch_code');
                }
                if ($department_code == "") {
                    $department_code = "CTP";
                }
                $traffic_code = $spill_one = $spill_two = "";
                /*trafficcode with department, brnach and service*/
                $gettrafficcode_service = $ci->db->select("traffic_code,spill_one,spill_two")->get_where("tbl_trafficcode_master", ['branch_code' => $branch_code, 'department_code' => $department_code, 'service' => $service, 'status' => '1']);
                /*trafficcode with department and brnach*/
                $gettrafficcode_department = $ci->db->select("traffic_code,spill_one,spill_two")->get_where("tbl_trafficcode_master", ['branch_code' => $branch_code, 'department_code' => $department_code, 'status' => '1']);
                if ($gettrafficcode_service->num_rows() > 0) {
                    $traffic_code = $gettrafficcode_service->row()->traffic_code;
                    $spill_one    = $gettrafficcode_service->row()->spill_one;
                    $spill_two    = $gettrafficcode_service->row()->spill_two;
                } else if ($gettrafficcode_department->num_rows() > 0) {
                    $traffic_code = $gettrafficcode_department->row()->traffic_code;
                    $spill_one    = $gettrafficcode_department->row()->spill_one;
                    $spill_two    = $gettrafficcode_department->row()->spill_two;
                } else {
                    $gettrafficcode = $ci->db->select("traffic_code,spill_one,spill_two")->get_where("tbl_trafficcode_master", ['branch_code' => $branch_code, 'status' => '1']);
                    if ($gettrafficcode->num_rows() > 0) {
                        $traffic_code = $gettrafficcode->row()->traffic_code;
                        $spill_one    = $gettrafficcode->row()->spill_one;
                        $spill_two    = $gettrafficcode->row()->spill_two;
                    }
                }
                /* End get traffic and spill codes*/
                $branch_officeno = "";
                $chkbno          = $ci->common->gettblrowdata(['branch_code' => $branch_code, 'status' => '1'], "branch_officeno", "tb_branch_master", 0, 0);
                $bno             = "00";
                if (! empty($chkbno)) {
                    $branch_officeno = $chkbno['branch_officeno'];
                }
                if ($branch_officeno != "") {
                    $bno = substr($branch_officeno, -2);
                }
                $dcode = $bno . $traffic_code;
                if ($debtor_jfr == "") {
                    /* check if trip has any other orders*/
                    $chktrip_withother_ord = $ci->db->query("SELECT r.debtor_jfr FROM tb_reveneus r,tb_orders o WHERE  o.id=r.order_id AND o.id !='" . $order_id . "' AND o.trip_id='" . $trip_id . "' AND o.status !=0 AND r.type=0 ");
                    if ($chktrip_withother_ord->num_rows() > 0) {
                        $debtor_jfr_trafficcode = $debtor_jfr_spillone = $debtor_jfr_spilltwo = "";
                        /* Case 2 check with Orderid , Tripid,trafficcode */
                        $chkjfr_with_tripid = $ci->db->query("SELECT MAX(r.debtor_jfr) as debtor_jfr FROM tb_reveneus r,tb_orders o WHERE  o.id=r.order_id AND o.id !='" . $order_id . "' AND o.trip_id='" . $trip_id . "' AND o.status !=0 AND r.type=0 AND debtor_jfr LIKE '" . $dcode . "%'");
                        if ($chkjfr_with_tripid->num_rows() > 0) {
                            $previous_jfr = $chkjfr_with_tripid->row()->debtor_jfr;
                            if (strlen($previous_jfr) == 14) {
                                $debtor_jfr_trafficcode = ++$previous_jfr;
                            }
                        }
                        if (strlen($spill_one) == 4) {
                            $dcode                = $bno . $spill_one;
                            $chkjfr_with_spillone = $ci->db->query("SELECT MAX(r.debtor_jfr) as debtor_jfr FROM tb_reveneus r,tb_orders o WHERE  o.id=r.order_id AND o.trip_id='" . $trip_id . "' AND o.status !=0 AND r.type=0 AND debtor_jfr LIKE '" . $dcode . "%'");
                            if ($chkjfr_with_spillone->num_rows() > 0) {
                                $previous_jfr = $chkjfr_with_spillone->row()->debtor_jfr;
                                if (strlen($previous_jfr) == 14) {
                                    $debtor_jfr_spillone = ++$previous_jfr;
                                }
                            }
                        }
                        if (strlen($spill_two) == 4) {
                            $dcode                = $bno . $spill_two;
                            $chkjfr_with_spilltwo = $ci->db->query("SELECT MAX(r.debtor_jfr) as debtor_jfr FROM tb_reveneus r,tb_orders o WHERE  o.id=r.order_id AND o.trip_id='" . $trip_id . "' AND o.status !=0 AND r.type=0 AND debtor_jfr LIKE '" . $dcode . "%'");
                            if ($chkjfr_with_spilltwo->num_rows() > 0) {
                                $previous_jfr = $chkjfr_with_spilltwo->row()->debtor_jfr;
                                if (strlen($previous_jfr) == 14) {
                                    $debtor_jfr_spilltwo = ++$previous_jfr;
                                }
                            }
                        }
                        if ($debtor_jfr_spilltwo != "") {
                            $debtor_jfr = $debtor_jfr_spilltwo;
                        } else if ($debtor_jfr_spillone != "") {
                            $debtor_jfr = $debtor_jfr_spillone;
                        } else if ($debtor_jfr_trafficcode != "") {
                            $debtor_jfr = $debtor_jfr_trafficcode;
                        }
                    }
                }
                if ($debtor_jfr == "") {
                    $current_month     = date('m');
                    $current_yearmonth = date('ym');
                    if ($sts_createdon != "") {
                        $current_yearmonth = date('ym', strtotime($sts_createdon));
                    }
                    $last_no           = "999";
                    $current_yearmonth = substr($current_yearmonth, -3);
                    $current_month     = substr($current_yearmonth, -2);
                    $chkcode           = $bno . $traffic_code . $current_yearmonth . $last_no;
                    $chkforspils       = $ci->db->query("SELECT id FROM tb_reveneus WHERE debtor_jfr IS NOT NULL AND debtor_jfr LIKE '" . $chkcode . "%' ");
                    $dcode             = $bno . $traffic_code . $current_yearmonth;
                    if ($chkforspils->num_rows() > 0) {
                        $dcode        = $bno . $spill_one . $current_yearmonth;
                        $chkcode1     = $bno . $spill_one . $current_yearmonth . $last_no;
                        $chkforspils1 = $ci->db->query("SELECT id FROM tb_reveneus WHERE debtor_jfr IS NOT NULL AND debtor_jfr LIKE '" . $chkcode1 . "%' ");
                        if ($chkforspils1->num_rows() > 0) {
                            $dcode = $bno . $spill_two . $current_yearmonth;
                        }
                    }
                    $getrecentcode = $ci->db->query("SELECT MAX(debtor_jfr) as debtor_jfr FROM tb_reveneus WHERE debtor_jfr  IS NOT NULL AND debtor_jfr != '' AND debtor_jfr LIKE '" . $dcode . "%' ");
                    $recent_jfr    = $previous_month    = 0;
                    if ($getrecentcode->num_rows() > 0) {
                        if (strlen($getrecentcode->row()->debtor_jfr) == 14) {
                            $recent_jfr = $getrecentcode->row()->debtor_jfr;
                        }
                    }
                    
                    if ($recent_jfr != 0) {
                        $getmonth       = substr($recent_jfr, -7);
                        $previous_month = ltrim(mb_substr($getmonth, 0, 2), 0);
                        if ($current_month > $previous_month) {
                            $inc = '011';
                        } else {
                            $rec_code  = substr($recent_jfr, -5);
                            $inc       = mb_substr($rec_code, 0, 3);
                            $increment = ltrim($inc, 0);
                            $increment++;
                            $inc        = $increment;
                            $inc_length = strlen($inc);
                            if ($inc_length == "1") {
                                $inc = "00" . $increment;
                            }
                            if ($inc_length == "2") {
                                $inc = "0" . $increment;
                            }
                            if ($inc_length == "3") {
                                $inc = $increment;
                            }
                        }
                    } else {
                        $inc = '011';
                    }
                    $id         = $inc . "01";
                    $debtor_jfr = $dcode . $id;
                }
            }
        }
        if (strlen($debtor_jfr) != 14) {
            $debtor_jfr = "";
        }

        return $debtor_jfr;

    }
}
/* This actually generates the tb.orders.order_id, which is also called the booking_id */

if (! function_exists('generatebookingid')) {
    function generatebookingid($orderinfo = [])
    {
        $booking_id = "";
        if (! empty($orderinfo)) {
            $countrycode  = $orderinfo['country_code'];
            $companyCode  = $orderinfo['company_code'];
            $orderid      = $orderinfo['order_id'];
            $tz           = getUserTimeZone($countrycode);
            $country_code = $tz['phone_code'];
            $cdate        = new DateTime("now", new DateTimeZone(DFLT_TZ));
            $year         = $cdate->format('y');
            $week         = $cdate->format('W');
            
            if ($companyCode == "KNAU") {
                $codeyear = $country_code . $week;
            } else {
                $codeyear = $country_code . $year;
            }
            $ci = &get_instance();
            $ci->load->model('order');
            if (in_array($companyCode, ['NZKN', 'NZPG'], true)) {
                $companyCondition = " (company_code like '%NZPG%' or company_code like '%NZKN%') ";
            } elseif (in_array($companyCode, ['THKN', 'THCL'], true)) {
                $companyCondition = " (company_code like '%THCL%' or company_code like '%THKN%') ";
            } else {
                $companyCondition = " company_code LIKE '" . $companyCode . "' ";
            }
            $whr    = "id < '" . $orderid . "' AND (order_id LIKE '" . $codeyear . "%' AND $companyCondition ) ";
            $previd = $ci->order->getrecentorderid($whr);

            if ($previd && $previd->num_rows() > 0) {
                $week_orderno = $previd->row()->order_id;
                $cn_length    = strlen($country_code);
                $wcount       = $prev_weekno       = $ycount       = $prev_ordno       = "";
                if ($companyCode == "KNAU") {
                    $prev_weekno = mb_substr($week_orderno, $cn_length, 2);
                    $wcount      = $cn_length + 2;
                    $ycount      = $wcount + 2;
                    $prev_ordno  = mb_substr($week_orderno, $ycount, 5);
                } else {
                    $wcount      = $cn_length + 2;
                    $prev_weekno = mb_substr($week_orderno, $wcount, 2);
                    $ycount      = $wcount + 2;
                    $prev_ordno  = mb_substr($week_orderno, $ycount, 5);
                }
                $id = ltrim($prev_ordno, 0);
                if ($prev_weekno < $week) {
                    $id = '0001';
                } else {
                    $i_id = $id;
                    $i_id++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id = "000" . $i_id;
                    } else {
                        if ($idlength == '2') {
                            $id = "00" . $i_id;
                        } else {
                            if ($idlength == '3') {
                                $id = "0" . $i_id;
                            } else {
                                if ($idlength == '4') {
                                    $id = $i_id;
                                } else {
                                    $id = $i_id;
                                }
                            }
                        }
                    }
                }
                if ($companyCode == "KNAU") {
                    $booking_id = $country_code . $week . $year . $id;
                } elseif ($companyCode == "UKKN-CG") {
                    $booking_id = $country_code . $week . $year . $id;
                } else {
                    $booking_id = $country_code . $year . $week . $id;
                }
                $chk = $ci->order->checkbooking_existsornot($booking_id);
                //log_message("error","55:".$chk->num_rows());
                if ($chk->num_rows() > 0) {
                    $iid = $id;
                    $iid++;
                    $ii_d      = $iid;
                    $id_length = strlen($iid);
                    if ($id_length == '1') {
                        $ii_d = "000" . $iid;
                    } else {
                        if ($id_length == '2') {
                            $ii_d = "00" . $iid;
                        } else {
                            if ($id_length == '3') {
                                $ii_d = "0" . $iid;
                            } else {
                                if ($id_length == '4') {
                                    $ii_d = $iid;
                                } else {
                                    $ii_d = $iid;
                                }
                            }
                        }
                    }
                    if ($companyCode == "KNAU") {
                        $booking_id = $country_code . $week . $year . $ii_d;
                    } elseif ($companyCode == "UKKN-CG") {
                        $booking_id = $country_code . $week . $year . $id;
                    } else {
                        $booking_id = $country_code . $year . $week . $ii_d;
                    }
                }
            } else {
                $i_id = 1;
                $id   = '000' . $i_id;
                if ($companyCode == "KNAU") {
                    $booking_id = $country_code . $week . $year . $id;
                } elseif ($companyCode == "UKKN-CG") {
                    $booking_id = $country_code . $week . $year . $id;
                } else {
                    $booking_id = $country_code . $year . $week . $id;
                }
            }
        }
        
        $uniqueOrderIdGeneratorService = new UniqueOrderIdGeneratorService(new OrderIdModel($ci->db), new ParsedOrderIdHelper());
        //log_message("error","11:".$booking_id);
        return $uniqueOrderIdGeneratorService->getUniqueOrderId($booking_id);
    }
}

function custrandom_color($i)
{
    if ($i != "") {
        $items = ["2589BD", "187795", "38686A", "A3B4A2", "CDC6AE", "CDC6AE", "B4D2E7"];

        return $items[$i % count($items)];
    }
}
/**
 * get the loggedin user latitude and longitude
 *
 *
 *
 * @author    Developer Name external.ram.k@kuehne-nagel.com
 * @date      30-03-2021 09:00:00+05.30
 * @change    Global
 * @param     Integer User ID
 * @return    Array
 */
function getLogUserLatLng($uid = null)
{
    $res['ulat'] = 20.5937;
    $res['ulng'] = 78.9629;
    if ($uid != "") {
        $ci = &get_instance();
        $ci->load->model("common");
        if ($ci->session->userdata("business_type")) {
            if ($ci->session->userdata("business_type") == "Country Admin") {
                $cmpcode = $ci->session->userdata("company_code");
                $sql     = $ci->common->gettblrowdata(["company_code" => $cmpcode], "lat,lng", "tb_users", 0, 0);
            } else {
                $sql = $ci->common->gettblrowdata(["id" => $uid], "lat,lng", "tb_users", 0, 0);
            }
            if (count($sql) > 0) {
                $res['ulat'] = $sql['lat'];
                $res['ulng'] = $sql['lng'];
            }
        }
    }
    return $res;
}

function calculateDistance12($lat1, $lon1, $lat2, $lon2)
{
    $res   = 0;
    $theta = doubleval($lon1) - doubleval($lon2);
    $dist  = sin(deg2rad(doubleval($lat1))) * sin(deg2rad(doubleval($lat2))) + cos(deg2rad(doubleval($lat1))) * cos(deg2rad(doubleval($lat2))) * cos(deg2rad($theta));
    $dist  = acos($dist);
    if (is_nan($dist)) {
        $dist = 0;
    }

    $dist  = rad2deg($dist);
    $miles = $dist * 60 * 1.1515;
    $res   = round(($miles * 1.609344), 2);

    return $res;
}

if (! function_exists('checkDriverAssignedVehicle')) {
    function checkDriverAssignedVehicle($id)
    {
        $ci     = &get_instance();
        $result = [];
        $sql    = $ci->db->where("driver_id", $id)->where("status", 1)->get("tbl_assigned_drivers");
        if ($sql->num_rows() > 0) {
            $vehid   = $sql->row()->vehicle_id;
            $result1 = $ci->db->select("id,register_number")->where("id", $vehid)->get("tb_trucks_data");
            if ($result1->num_rows() > 0) {
                $result = ["register_number" => $result1->row()->register_number, "vehicle_id" => $result1->row()->id, "is_primary" => true]; /*$result1->row()->register_number."<b style='font-size: 9px;'>[PRIMARY]</b>";*/
            }
        } else {
            $record = $ci->db->query("SELECT vehicle_id FROM tb_vehicles_drivers WHERE driver_id = $id AND status = '1' ORDER BY ID DESC LIMIT 1");
            if ($record->num_rows() > 0) {
                $vehicle_id = $record->row()->vehicle_id;
                $result1    = $ci->db->select("id,register_number")->where("id", $vehicle_id)->get("tb_trucks_data");
                if ($result1->num_rows() > 0) {
                    $result = ["register_number" => $result1->row()->register_number, "vehicle_id" => $result1->row()->id, "is_primary" => false];
                }
            }
        }

        return $result;
    }
}
function updateTripSummary($trip_id, $splace, $eplace)
{
    $ci = &get_instance();
    if ($trip_id != 'null') {
        $a = $ci->db->where(["id" => $trip_id])->update("tb_trips", ["act_splace" => $splace, "act_eplace" => $eplace, "updated_on" => date("Y-m-d H:i:s")]);
    }
}

function showFlashData()
{
    $ci = &get_instance();
    if ($ci->session->flashdata('success')) {
        echo '<div class="alert alert-success">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <strong>Success!</strong>' . $ci->session->flashdata('success') . '</div>';

    } else if ($ci->session->flashdata('error')) {

        echo '<div class="alert alert-danger">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <strong>Error!</strong>' . $ci->session->flashdata('error') . '</div>';

    } else if ($ci->session->flashdata('warning')) {

        echo '<div class="alert alert-warning">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <strong>Warning!</strong>' . $ci->session->flashdata('warning') . '</div>';

    } else if ($ci->session->flashdata('info')) {

        echo '<div class="alert alert-info">
        <a href="#" class="close" data-dismiss="alert">&times;</a>
        <strong>Info!</strong>' . $ci->session->flashdata('info') . '</div>';
    }

}

function getOccupencybyVehicle($id = null, $from = null, $to = null)
{
    $ci = &get_instance();
    $wr = "";
    if ($from == null) {
        $wr .= " and t.etime>='" . $from . "'";
    }
    if ($to = null) {
        $wr .= " and t.etime<='" . $to . "'";
    }
    $result = [];
    if ($id != null) {
        $chk = $ci->db->query("select ROUND(AVG(e.shipment_weight)*100/td.truck_weight,2) as avg_weight,ROUND(AVG(e.shipment_volume)*100/td.truck_volume,2) as avg_volume from tb_trips t,tb_employee e,tb_trucks_data td where t.shift_id=e.shift_id AND td.id=t.vehicle_id AND t.vehicle_id=$id $wr");
        if ($chk!= ""  && $chk->num_rows() > 0) {
            $result = $chk->row_array();
        }
    } else {
        $userid = $ci->session->userdata('user_id');
        $chk    = $ci->db->query("select ROUND(AVG(e.shipment_weight)*100/td.truck_weight,2) as avg_weight,ROUND(AVG(e.shipment_volume)*100/td.truck_volume,2) as avg_volume from tb_trips t,tb_employee e,tb_trucks_data td where t.shift_id=e.shift_id AND td.id=t.vehicle_id AND td.user_id=$userid $wr");
        if ($chk->num_rows() > 0) {
            $result = $chk->row_array();
        }
    }

    return $result;
}

function getOccupencybyTrip($id = null)
{
    $ci     = &get_instance();
    $result = [];
    if ($id != null) {
        $q = $ci->db->query("select IFNULL(ROUND(AVG(e.shipment_weight)*100/td.truck_weight,2),0) as avg_weight,IFNULL(ROUND(AVG(e.shipment_volume)*100/td.truck_volume,2),0) as avg_volume from tb_trips t,tb_trip_employee te,tb_employee e,tb_trucks_data td where t.id=$id and te.trip_id=t.id and te.employee_id=e.id and e.ship_type='D' and td.id=t.vehicle_id");
        if ($q->num_rows() > 0) {
            $result = $q->row_array();
        }
    }

    return $result;
}

function getempstatus($id = null)
{
    $ci             = &get_instance();
    $res['tripsts'] = [];
    $res['history'] = [];
    if ($id != null) {
        $q = $ci->db->query("SELECT trip_id,status,stime,check_in,absent_reason,pd_status FROM tb_trip_employee where employee_id=" . $id . " ORDER BY id DESC LIMIT 1");
        if ($q->num_rows() > 0) {
            $res['tripsts'] = ['trip_id' => $q->row()->trip_id, 'status' => $q->row()->status, 'stime' => $q->row()->stime, 'check_in' => $q->row()->check_in, 'absent_reason' => $q->row()->absent_reason, 'pd_status' => $q->row()->pd_status];
        }
        $q1 = $ci->db->query("SELECT m.status_name,s.latitude,s.longitude,s.createdon FROM tb_stop_status s,tb_status_master m where s.status_id=m.id AND s.stop_id=" . $id . " ORDER BY s.id ASC");
        if ($q1->num_rows() > 0) {
            foreach ($q1->result() as $r) {
                $placename      = getLocationName($r->latitude, $r->longitude);
                $res['history'] = ['name' => $r->status_name, 'place' => $placename, 'createdon' => $r->createdon];
            }
        }
    }

    return $res;
}

function getsuperadminusers($sadmin)
{
    $res = [];
    $ci  = &get_instance();
    $qry = $ci->db->select("user_id")->get_where("tb_user_mappings", ["admin_user_id" => $sadmin, "status" => 1]);
    if ($qry->num_rows() > 0) {
        foreach ($qry->result() as $rs) {
            $res[] = $rs->user_id;
        }
    }

    return $res;
}

function getQRrefsbyorderId($ordid, &$deliveryNumber = null)
{
    if (! $ordid) {
        return '';
    }

    $ci = &get_instance();

    $chk = $ci->db->query("SELECT r.ref_value, r.reference_id
    FROM tb_orders o,tb_order_references r
    WHERE o.id=r.order_id
      AND o.order_id = ?
      AND r.status=1
      AND reference_id IN('DQ','AWB','INN','DELNUM')", [$ordid]);

    if (! $chk->num_rows()) {
        return '';
    }

    $res = [];
    foreach ($chk->result() as $rf) {
        if (! $rf->ref_value) {
            continue;
        }
        if ($rf->reference_id === 'DELNUM') {
            $deliveryNumber = $rf->ref_value;
        } else {
            $res[] = $rf->ref_value;
        }
    }

    return implode(', ', $res);
}

function getQRrefsForMultipleOrders(array $orderIds): array
{
    if (empty($orderIds)) {
        return [];
    }

    $ci = &get_instance();

    $chk = $ci->db->query("SELECT o.order_id, r.ref_value, r.reference_id
    FROM tb_orders o,tb_order_references r
    WHERE o.id=r.order_id
      AND o.order_id IN ?
      AND r.status=1
      AND reference_id IN ('DQ','AWB','INN')", [$orderIds]);

    if (! $chk->num_rows()) {
        return [];
    }

    $res = [];
    foreach ($chk->result() as $rf) {
        if (! $rf->ref_value) {
            continue;
        }
        $current            = $res[$rf->order_id] ?? '';
        $res[$rf->order_id] = ($current ? $current . ', ' : '') . $rf->ref_value;
    }

    return $res;
}

function humanTiming($time = 0)
{
    $curtime = time();
    $time    = ($curtime - $time);
    $time    = ($time < 1) ? 1 : $time;
    $tokens  = [
        31536000 => 'Y',
        2592000  => 'M',
        604800   => 'W',
        86400    => 'D',
        3600     => 'H',
        60       => 'm',
        1        => 'S',
    ];
    foreach ($tokens as $unit => $text) {
        if ($time < $unit) {
            continue;
        }
        $numberOfUnits = floor($time / $unit);

        return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
    }
}

function knencrypt($sData)
{
    $id = (double) $sData * 525325.24;

    return base64_encode($id);
}

function kndecrypt($sData)
{
    $url_id = base64_decode($sData);
    $id     = (double) $url_id / 525325.24;

    return $id;
}

function trainPartyName($value)
{
    return trainKeywordEntity("party_name", $value);
}

function trainToLocation($value)
{
    return trainKeywordEntity("to_location", $value);
}

function trainFromLocation($value)
{
    return trainKeywordEntity("from_location", $value);
}

function isNotEmpty($string)
{
    return (isset($string) && $string != null && strlen(trim($string)) > 0);
}

function orderAddressUpdate($order_id)
{
    $ci     = &get_instance();
    $orders = $ci->db->query("SELECT id,pickup_city,pickup_country,pickup_pincode,pickup_address1,delivery_city,delivery_country,delivery_pincode,delivery_address1 FROM tb_orders WHERE id = '$order_id'");
    $ret    = ["plat" => null, "plng" => null, "dlat" => null, "dlng" => null];
    foreach ($orders->result() as $order) {
        $add1 = implode(",", [$order->pickup_address1, $order->pickup_city, $order->pickup_country, $order->pickup_pincode]);
        $add2 = implode(",", [$order->delivery_address1, $order->delivery_city, $order->delivery_country, $order->delivery_pincode]);
        $data = getlatlngsbyplace($add1);
        $lat1 = @$data[0];
        $lng1 = @$data[1];
        $data = [];
        $data = getlatlngsbyplace($add2);
        $lat2 = @$data[0];
        $lng2 = @$data[1];
        $ret  = ["plat" => $lat1, "plng" => $lng1, "dlat" => $lat2, "dlng" => $lng2];
        $ci->db->where("id", $order->id)->update("tb_orders", $ret);
    }

    return $ret;
}

function gettripendtime($tripid)
{
    $ci  = &get_instance();
    $res = "";
    if ($tripid != "") {
        $trip = $ci->db->query("SELECT etime FROM tb_trips WHERE id = '$tripid'");
        if ($trip->num_rows() > 0) {
            $res = $trip->row()->etime;
        }
    }

    return $res;
}

function gettripgateouttime($tripid): string
{
    if (! $tripid) {
        return "";
    }

    $ci = &get_instance();

    $trip = $ci->db->query(
        "SELECT createdon as etime
        FROM tb_stop_status
        WHERE trip_id = ? AND stop_type='D' AND status_id='SV0510' LIMIT 1", [$tripid]);

    return $trip->num_rows() ? $trip->row()->etime : "";
}

function getTripGateOutTimeForMultipleTrips(array $tripIds): array
{
    if (empty($tripIds)) {
        return [];
    }

    $ci    = &get_instance();
    $query = $ci->db->query(
        "SELECT trip_id, createdon as etime
        FROM tb_stop_status
        WHERE trip_id IN ? AND stop_type='D' AND status_id='SV0510'", [$tripIds]);
    if (! $query) {
        return [];
    }
    $res = [];
    foreach ($query->result() as $row) {
        $res[$row->trip_id] = $row->etime;
    }
    return $res;
}

function getEDAofNZShipmentbyord($id)
{
    $ci          = &get_instance();
    $res["time"] = "";
    if ($id != "") {
        $qry = $ci->db->query("select r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE r.order_id=o.id AND r.order_id=$id AND o.id=$id AND r.reference_id='ETA' AND r.status=1 LIMIT 1");
        if ($qry->num_rows() > 0) {
            $res["time"] = $qry->row()->ref_value;
        } else {
            $qry1 = $ci->db->query("select s.createdon FROM tb_stop_status s,tb_orders o WHERE s.shipment_id=o.shift_id AND s.stop_type='D' AND s.status_id IN(1,3) AND o.id=$id AND s.status=1 ORDER BY s.status_id DESC LIMIT 1");
            if ($qry1->num_rows() > 0) {
                $res["time"] = $qry1->row()->createdon;
            }
        }
    }

    return $res;
}

function checkstsvaliddate($date = null)
{
    $month = date("m", strtotime($date));
    $day   = date("d", strtotime($date));
    $year  = date("Y", strtotime($date));
    if ($date === '' || $year === '1970' || ! checkdate($month, $day, $year)) {
        return false;
    }
    return true;
}

function pageHasPermission($page_id, $operation = CREATE)
{
    $ci = &get_instance();
    //$userid = $ci->session->userdata('user_id');
    $role_id = $ci->session->userdata('user_role_id');
    $perms   = $ci->db->where(["role_id" => $role_id, "status" => "1"])->get("tb_permissions");
    if ($perms->num_rows() > 0) {
        return true;
    } else {
        return false;
    }
}

function moduleHasPermission($module_id, $operation = CREATE)
{
    $ci = &get_instance();
    //$userid = $ci->session->userdata('user_id');
    $role_id = $ci->session->userdata('user_role_id');
    $perms   = $ci->db->where(["module_id" => $role_id, "status" => "1"])->get("tb_permissions");
    if ($perms->num_rows() > 0) {
        return true;
    } else {
        return false;
    }
}

function getMenu(): array
{
    $container = &get_instance();
    $urls      = $accessUrls      = [];
    $container->load->library('cache_ui');
    if (! empty($cache = $container->cache_ui->getMainMenuQueryResult())) {
        return $cache;
    }
    $permissionsByModules = $container->db->query(
        'SELECT modules.id, modules.name, modules.icon,
                    pages.id as page_id, pages.page, pages.url, pages.icon as pages_icon
                FROM
                    tb_modules AS modules, tb_permissions AS permissions, tb_pages AS pages
                WHERE
                    modules.id = pages.module_id
                    AND modules.id = permissions.module_id
                    AND permissions.page_id = pages.id
                    AND permissions.status = 1
                    AND modules.status = 1
                    AND permissions.role_id = ?
                    AND pages.status = 1
                ORDER BY
                modules.sequence',
        [$container->session->userdata('user_role_id')]
    );
    //log_message("error", "query:" . $container->db->last_query());
    $permissions = [];

    while ($permissionsByModule = $permissionsByModules->unbuffered_row('array')) {
        $moduleName = $permissionsByModule['name'];
        //log_message("error", "module:" . $moduleName);
        if (! isset($permissions[$moduleName])) {
            unset($urls);
            $urls = [];

            $permissions[$moduleName] = [
                'id'    => $permissionsByModule['id'],
                'name'  => $moduleName,
                'icon'  => $permissionsByModule['icon'],
                'pages' => [],
            ];
        }
        $accessUrls[] = $permissionsByModule['url'];
        if (in_array($permissionsByModule['url'], $urls, true)) {
            continue;
        }

        $permissions[$moduleName]['pages'][] = [
            'id'        => $permissionsByModule['page_id'],
            'page'      => $permissionsByModule['page'],
            'url'       => $permissionsByModule['url'],
            'icon'      => $permissionsByModule['pages_icon'],
            'module_id' => $permissionsByModule['id'],
        ];
        
        

        $urls[] = $permissionsByModule['url'];
    }

    $result    = array_values($permissions);
    $fileNames = [];
    foreach ($accessUrls as $eachUrl) {
        $splitArray     = explode('/', $eachUrl);
        $controllerName = ! empty($splitArray) ? strtoupper($splitArray[0]) : '';
        if (! in_array($controllerName, $fileNames, true)) {
            $fileNames[] = $controllerName;
        }
    }
    
    $container->cache_ui->setMainMenuQueryResult($result, array_filter($fileNames));
    return $result;
}

function getallcountrylangs()
{
    $langchk = [
        "en"    => "english",
        "en_us" => "english_us",
        "fr"    => "french",
        "zh"    => "chinese",
        "de"    => "german",
        "th"    => "thailand",
        "hi"    => "hindi",
        "vn"    => "vietnamese",
        "ja"    => "japanese",
        "it"    => "italian",
        "ka"    => "kanji",
        "ms"    => "malay",
        "ta"    => "tamil",
        "te"    => "telugu",
        "ur"    => "urdu",
        "po"    => "polish",
        "ru"    => "russian",
    ];

    return $langchk;
}

function checkVNreq()
{
    $ci   = &get_instance();
    $resp = "";
    $ucmp = $ci->session->userdata('company_code');
    if ($ucmp != "VNKN") {
        $resp = "*";
    }

    return $resp;
}

function macadam_status_send($input, $status_stage, $carrier_datetype = "")
{
    $ci = &get_instance();

    switch ($status_stage) {
        case "PICKUP_GATE_IN":
            $input['status_code'] = '0490';
            break;
        case "PICKUP_OK":
            $input['status_code'] = '0500';
            break;
        case "PICKUP_NOT_DONE":
            $input['status_code']    = '0501';
            $input['exception_code'] = 'CI09';
            break;
        case "PICKUP_BROKEN":
            $input['status_code']    = '0502';
            $input['exception_code'] = 'DD02';
            break;
        case "PICKUP_GATE_OUT":
            $input['status_code'] = '0510';
            break;
        case "DELIVERY_GATE_IN":
            $input['status_code'] = '2990';
            break;
        case "DELIVERED":
            $input['status_code'] = '3000';
            break;
        case "DELIVERED_WITH_DAMAGE":
            $input['status_code']    = '3002';
            $input['exception_code'] = 'DD02';
            break;
        case "DELIVERY_SHORT":
            $input['status_code']    = '3002';
            $input['exception_code'] = 'DD01';
            break;
        case "DELIVERY_REFUSED":
        case "DELIVERY_NOT_DONE":
            $input['status_code']    = '3001';
            $input['exception_code'] = 'DI03';
            break;
        case "DELIVERY_GATE_OUT":
            $input['status_code'] = '9999';
            break;
        case "IN_TRANSIT":
            $input['status_code'] = '1550';
            break;
    }

    if ($input['stop_type'] == 'P') {
        $order_city = $input['pickup_city'];
    }
    if ($input['stop_type'] == 'D') {
        $order_city = $input['delivery_city'];
    }

    if ($carrier_datetype == "Carrier") {
        $current_date_time = $input['current_date_time'];
        $current_time      = $input['current_time'];
        $current_date      = $input['current_date'];
        $device_id         = 'CARRIER';
    } else {
        $current_date_time = date('Y-m-d\TH:i:s\Z');
        $current_time      = date('H:i:s\Z');
        $current_date      = date('Y-m-d');
        $device_id         = 'DRIVER';
    }

    $data = [
        "physicalreceiver"    => $input["physicalreceiver"],
        "logicalreceiver"     => $input["logicalreceiver"],
        "physicalsender"      => $input["physicalsender"],
        "logicalsender"       => $input["logicalsender"],
        "order_id"            => $input['tracking_ref'],
        "assoc_id"            => $input['assoc_id'],
        "ref_value_kn_office" => $input['ref_value_kn_office'] ?? '',
        "city"                => $order_city,
        "current_date_time"   => $current_date_time,
        "current_time"        => $current_time,
        "current_date"        => $current_date,
        "document_id"         => $input['document_id'] ?? '',
        "picture_id"          => $input['picture_id'] ?? '',
        "remark"              => $input['remark'] ?? '',
        "missing_qty"         => $input['missing_qty'] ?? '',
        "status_code"         => $input['status_code'],
        "upload_type"         => $input['upload_type'] ?? '',
        "exception_code"      => $input['exception_code'] ?? '',
        "pod_signee"          => $input['pod_signee'] ?? '',
        "branch_code"         => $input['branch_code'] ?? '',
        "company_code"        => $input['company_code'] ?? '',
        "user_id"             => $input['user_id'] ?? '',
        "device_id"           => $device_id,
        "from_secure_link"    => true,
    ];

    $created_source = $input['created_source'] ?? "";
    switch ($created_source) {
        case 18:
            if (! checkAccessConditions('CHECK_ROADLOG_STATUS_WONT_TRIGGER', $input['status_code'])) {
                $ci->load->library('Roadlog_status');
                $ci->roadlog_status->status_handler($data);
            }
            break;
        case 12:
            $ci->load->library('Macadam_Status');
            $ci->macadam_status->macadam_status_hanlder($data, $status_stage);
            break;
    }

}

function macadam_d3_dms(array $input)
{
    $ci = &get_instance();

    /**    
     * Edi Sources and their IDs in eTN - DB
     *  1 - Driver Collect,
     *  2 - Cust Quote,
     *  3 - Cust Quickbook,
     *  4 - Web,
     *  5 - SALog,
     *  6 - Shipment,
     *  7 - NZedi,
     *  8 - Shippeo
     *  12 - Macadam
     *  18 - RoadLog
     */

    $created_source = $input['created_source'] ?? "";
    switch ($created_source) {
        case 18:
            $ci->load->library('Roadlog_d3_dms');
            $res = $ci->roadlog_d3_dms->generate_jpl($input);
            break;
        case 12:
            $ci->load->library('D3_dms');
            $res = $ci->d3_dms->generate_jpl($input);
            break;
        default:
            $ci->load->library('D3_dms');
            $res = $ci->d3_dms->generate_jpl($input);
    }

    return $res;
}

function get_trip_sequence_no($shift_id, $trip_created_on)
{
    $ci = &get_instance();
    $ci->load->model('truckwaybillmodel');
    $company_code       = $ci->session->userdata('company_code');
    $branch_code        = $ci->session->userdata('branch_code');
    $trip_created_on_ym = date("ym", strtotime($trip_created_on));
    $sequence_no        = $trip_created_on_ym . "-" . "00000";
    $from_date_range    = date('ym', strtotime("-1 months", strtotime($trip_created_on)));
    $to_date_range      = date('ym', strtotime("+1 months", strtotime($trip_created_on)));
    $where              = [
        'shift_id'        => $shift_id,
        'company_code'    => $company_code,
        'branch_code'     => $branch_code,
        'from_date_range' => $from_date_range,
        'to_date_range'   => $to_date_range,
    ];
    $get_shift_rank = $ci->truckwaybillmodel->get_shift_rank($where);
    if ($get_shift_rank > 0) {
        $shift_rank  = str_pad($get_shift_rank, 5, '0', STR_PAD_LEFT);
        $sequence_no = $trip_created_on_ym . "-" . $shift_rank;
    }
    return $sequence_no;
}

function removeSpecialCharacters($string, $stringType = 'address')
{
    $string = str_replace('  ', ' ', $string);
    $string = preg_replace('/[^a-zA-Z0-9,+.\-\\/ ]/', '', $string);
    if ($stringType == "name") {
        $string = preg_replace('/[^A-Za-z0-9+. ]/', '', $string);
    }
    $string   = preg_replace('/-+/', '-', $string);
    $response = preg_replace('/,+/', ',', $string);
    return $response;
}

/**
 * Determines if user should
 *
 * @return bool
 */
function user_is_using_scac(): bool
{
    $ci           = &get_instance();
    $country_code = $ci->session->userdata('usr_tzone')['country'];

    return in_array($country_code, [
        'USA',
    ]);
}

function getCarrierids(string $carrierCode): array
{
    $ci            = &get_instance();
    $carrierIds    = [];
    $getCarrierIds = $ci->db->query("SELECT id FROM tb_vendors WHERE `code`= ? AND `status`='1'", [$carrierCode]);
    if ($getCarrierIds->num_rows() > 0) {
        foreach ($getCarrierIds->result() as $res) {
            $carrierIds[] = $res->id;
        }
    }
    return $carrierIds;
}

function getTripDelayTimeString(int $trip_id, string $curtz): string
{
    $CI           = &get_instance();
    $getCreatedOn = $CI->db->query("SELECT convertToClientTZ(`createdon`,?) as `createdon` FROM `tb_stop_status` WHERE `status`=? and `status_id` !=? and `trip_id`=? and `status_code`=?", [$curtz, 1, '9', $trip_id, 2300]);
    if ((int) $getCreatedOn->num_rows() === 0) {
        return "";
    }

    $getDeliveryDate = $CI->db->query("SELECT convertToClientTZ(`delivery_datetime`,?) as `delivery_datetime` FROM `tb_orders` WHERE `trip_id`=?", [$curtz, $trip_id]);
    if ((int) $getDeliveryDate->num_rows() === 0) {
        return "";
    }

    $createdOn    = strtotime($getCreatedOn->row()->createdon);
    $deliveryDate = strtotime($getDeliveryDate->row()->delivery_datetime);
    if ($deliveryDate > $createdOn) {
        return "";
    }
    $duration = $createdOn - $deliveryDate;
    $mins     = floor($duration / 60);
    $hours    = str_pad(floor($mins / 60), 2, "0", STR_PAD_LEFT);
    $mins     = str_pad($mins % 60, 2, "0", STR_PAD_LEFT);
    $mins     = $mins > 0 ? $mins . " min(s)" : "";
    $days     = "";
    if ((int) $hours > 24) {
        $days  = str_pad(floor($hours / 24), 2, "0", STR_PAD_LEFT);
        $hours = str_pad($hours % 24, 2, "0", STR_PAD_LEFT);
    }
    $hours = $hours > 0 ? $hours . " hour(s)" : "";
    if ($days) {$days = $days . " day(s) ";}
    return $days . $hours . $mins;
}

if (! function_exists('checkMapPermissionsByCustomer')) {
    function checkMapPermissionsByCustomer(int $customerId): int
    {
        $ci = &get_instance();
        $ci->load->model('customers_model');
        $checkMapReference = $ci->customers_model->checkMapReferenceForCustomer($customerId);
        if (empty($checkMapReference)) {
            return 1;
        }
        $referenceValue = strtoupper($checkMapReference['value']);
        if (in_array($referenceValue, ['Y', 'YES'])) {
            return 1;
        }
        return 0;
    }
}

if (! function_exists('getCarrierDetails')) {
    function getCarrierDetails(string $carrierName, string $company_code): int
    {
        $ci = &get_instance();
        $ci->load->model('Order');
        $carrierInfo = $ci->Order->filterCarrierList($carrierName, $company_code);
        return ! empty($carrierInfo) ? $carrierInfo[0]['id'] : 0;
    }
}

function getSalogRefNum(string $userId, array $post, string $companyCode): array
{
    $respose      = [];
    $referenceId  = 'XSR';
    $referenceVal = trim($post['salog_ref']);
    $whereLike    = ['r.ref_value' => $referenceVal];
    $permission   = checkuserpermissions();
    $CI           = &get_instance();
    $CI->load->model('Order');
    if (in_array("orders", $permission)) {
        $where = [
            'o.status!='     => '0',
            'o.company_code' => $companyCode,
            'r.reference_id' => $referenceId,
            'r.status'       => 1,
        ];
    } else {
        $where = [
            'o.status!='     => '0',
            'o.user_id'      => $userId,
            'r.reference_id' => $referenceId,
            'r.status'       => 1,
        ];
    }
    $result = $CI->Order->getrefvals($where, $whereLike);
    if (! empty($result)) {
        $respose = array_column($result, "order_id");
    }
    return $respose;
}

if (! function_exists('checkUrlAccessForUser')) {
    function checkUrlAccessForUser(string $url)
    {
        $ci = &get_instance();
        if ($ci->session->userdata()) {
            $userId      = $ci->session->userdata('user_id');
            $companyCode = $ci->session->userdata('company_code');
            $roleId      = $ci->session->userdata('user_role_id');
            if ($userId == 30) {
                if (in_array($url, ['COMPANY', 'BRANCH', 'DEPARTMENT', 'PRODUCT', 'SERVICES', 'COUNTRIES', 'TRANSPORTMODES', 'ARCHIVEDDOCUMENTS', 'USERS', 'SUBUSERS', 'GEOCITY', 'GEOPROVINCE', 'PACKAGETYPE'], true)) {
                    return true;
                }
                return false;
            } else {
                $adminSubMenuUrls   = ["GEOTIER", "ORDERTYPE", "VENDORPROFILE", "VEHICLEPROFILE", "CUSTOMERPREFERENCES", "CARRIERRATIOS", "CUSTOMREPORT"];
                $fleetMenuUrls      = ["VEHICLES", "COSTCENTER", "TRUCKTYPES", "KPIREPORTONEDAY"];
                $customerUrls       = ["NZGLENDorders", "CUSTOMER-GLOBALORDERS"];
                $cuountryAdminUrls  = ["MASSREFNUM"];
                $adminAndCAdminUrls = ["ADMIN-PENDINGORDERS", "ADMIN-ACTIVEORDERS", "ADMIN-DONEORDERS", "BROADCOMREPORT", "ECOTRANSITREPORT"];
                /* Admin */
                $countryBasedUrls['UKKN2'] = ["AMZORDERS"];
                $countryBasedUrls['SGKN2'] = ["SMTCORDERS", "SMTCXBRDRORDERS"];
                $countryBasedUrls['INFD2'] = ["SMTCORDERS", "SMTCXBRDRORDERS"];
                $countryBasedUrls['MYKN2'] = ["SMTCORDERS", "SMTCXBRDRORDERS"];
                $countryBasedUrls['NZKN2'] = ["NZMASSSTATUS", "READYORDERS"];
                $countryBasedUrls['INKN2'] = ["INBASICSHIPMENTREPORT"];
                /* carrier  */
                $countryBasedUrls['MYKN3'] = ["SMTCXBRDRORDERS"];
                $countryBasedUrls['SGKN3'] = ["SMTCXBRDRORDERS"];
                $countryBasedUrls['NZKN3'] = ["NZMASSSTATUS"];
                /* customer */
                $countryBasedUrls['NZKN4'] = ["NZGENORDERS", "READYORDERS"];
                $countryBasedUrls['NZPG4'] = ["NZGENORDERS"];
                $countryBasedUrls['SGKN4'] = ["SMTCCUSTORDERS"];
                $countryBasedUrls['MYKN4'] = ["SMTCCUSTORDERS"];
                $countryBasedUrls['ALL4']  = ["KNCUSTORDERS"];
                /* Sub Customer */
                $subCustomerBasedUrls['SGKN4'] = ["SMTCSUBCUSTORDERS", "SMTCXBRDRORDERS"];
                $subCustomerBasedUrls['MYKN4'] = ["SMTCSUBCUSTORDERS", "SMTCXBRDRORDERS"];
                $subCustomerBasedUrls['ALL4']  = ["KNSUBCUSTORDERS"];
                if (in_array($url, ['AMZORDERS', 'SMTCORDERS', 'SMTCCUSTORDERS', 'SMTCXBRDRORDERS', 'NZMASSSTATUS', 'INBASICSHIPMENTREPORT', 'NZGENORDERS', 'READYORDERS'], true)) {
                    $checkArray = $countryBasedUrls[$companyCode . $roleId] ?? [];
                    if (empty($checkArray)) {
                        return false;
                    }
                    if (in_array($url, $checkArray, true)) {
                        return true;
                    }
                    return false;
                } elseif ($url == "KNCUSTORDERS") {
                    if (checkAccessConditions('RELATED_2_SG_MY', $companyCode)) {
                        $key = $companyCode . $roleId;
                    } else {
                        $key = 'ALL' . $roleId;
                    }
                    if (in_array($url, $countryBasedUrls[$key] ?? "", true)) {
                        return true;
                    }
                    return false;
                } elseif ($url == "GLOBAL-MASSSTATUS") {
                    if ($companyCode != "NZKN") {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, ["VISIBILITY", "SHIPMENTPLAN", "SHIFT"])) {
                    if ($roleId == "4") {
                        return true;
                    }
                    return true;
                } elseif (in_array($url, ['SMTCSUBCUSTORDERS', 'KNSUBCUSTORDERS'], true)) {
                    if ($ci->session->userdata('subcustomer') != 1) {
                        return false;
                    }
                    if (checkAccessConditions('RELATED_2_SG_MY', $companyCode)) {
                        $key = $companyCode . $roleId;
                    } else {
                        $key = 'ALL' . $roleId;
                    }
                    if (in_array($url, $subCustomerBasedUrls[$key], true)) {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, $adminSubMenuUrls)) {
                    if ($roleId == 2) {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, $customerUrls, true)) {
                    if ($roleId == 4) {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, $fleetMenuUrls, true)) {
                    if (in_array($roleId, ["2", "3"], true)) {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, $cuountryAdminUrls, true)) {
                    if ($roleId == 1) {
                        return true;
                    }
                    return false;
                } elseif (in_array($url, $adminAndCAdminUrls, true)) {
                    if (in_array($roleId, ["1", "2"], true)) {
                        return true;
                    }
                    return false;
                } elseif ($url === "TRIPS") {
                    /*if ((checkAccessConditions('RELATED_2_CROSSBORDER', $companyCode)) && in_array($roleId, [2, 5])) {
                        return true;
                    }*/
                    if (in_array($roleId, [2, 5])) {
                        return true;
                    }
                    return false;
                } else {
                    $mainMenuUrls = $ci->session->userdata('mainMenuUrls');
                    if (empty($mainMenuUrls)) {
                        return true;
                    }
                    if (in_array($url, $mainMenuUrls, true)) {
                        return true;
                    }
                    return false;
                }
            }
        }
    }
}

if (! function_exists('checkSpecificPermissionsByUser')) {
    function checkSpecificPermissionsByUser(int $customerId, string $keyValue): int
    {
        $ci = &get_instance();
        $ci->load->model('customers_model');
        $checkMapReference = $ci->customers_model->getSpecificPermissionsByUser($customerId, $keyValue);
        if (empty($checkMapReference)) {
            return 1;
        }
        $referenceValue = strtoupper($checkMapReference['value']);
        if (! in_array($referenceValue, ['N', 'NO'])) {
            return 1;
        }
        return 0;
    }
}

if (! function_exists('getEbookingReference')) {
    function getEbookingReference()
    {
        $ci = &get_instance();
        $ci->load->model('Bpartners');
        $eBooking = $ci->Bpartners->getEbookingMenu();
        return $eBooking;
    }
}

if (! function_exists('checkTripEligibleForClose')) {
    function checkTripEligibleForClose(int $tripId)
    {
        if ((int) $tripId > 0) {
            $ci = &get_instance();
            $ci->load->model('common');
            $totalTripOrders = $ci->common->gettblrowdata(['trip_id' => $tripId], "COUNT(id) AS total_shipments", "tb_orders", 0, 0);
            if ((int) $totalTripOrders['total_shipments'] === 0) {
                $totalTripOrders = $ci->common->gettblrowdata(['trip_id' => $tripId], "COUNT(order_id) AS total_shipments", "tb_employee", 0, 0);
            }
            $deliveredShipments      = $ci->common->gettblrowdata(['trip_id' => $tripId, 'stop_type' => 'D', 'status_code' => 'SV0510', 'status' => 1], "COUNT(id) AS total_delivered", "tb_stop_status", 0, 0);
            $totalTripOrdersCount    = (int) $totalTripOrders['total_shipments'];
            $deliveredShipmentsCount = (int) $deliveredShipments['total_delivered'];
            log_message("error", "Trip {$tripId} has {$totalTripOrdersCount} shipment count with {$deliveredShipmentsCount} Closed Shipments");
            if ($totalTripOrdersCount > 0 && $deliveredShipmentsCount > 0 && ($totalTripOrdersCount === $deliveredShipmentsCount)) {
                return 1;
            }
        }
        return 0;
    }
}

/*if (! function_exists('getBase64DocumentData')) {
    function getBase64DocumentData(string $documentName): array
    {
        $filePath = NEW_POD_PATH . $documentName;
        if (file_exists($filePath)) {
            $extention   = strtolower(pathinfo($documentName, PATHINFO_EXTENSION));
            $fileData    = base64_encode(file_get_contents($filePath));
            $fileContent = 'data: ' . mime_content_type($filePath) . ';base64,' . $fileData;
        }
        return ['extention' => $extention ?? '', 'file_content' => $fileContent ?? ''];
    }
}*/

if (!function_exists('getBase64DocumentData')) {
    function getBase64DocumentData(string $documentName): array
    {
        $filePath = NEW_POD_PATH . $documentName;
        if (file_exists($filePath)) {
            $extention = strtolower(pathinfo($documentName, PATHINFO_EXTENSION));
            $fileData = base64_encode(file_get_contents($filePath));
            if (function_exists('mime_content_type')) {
                $mimeType = mime_content_type($filePath);
            } else {
                $mimeType = getMimeTypeFallback($extention);
            }
            $fileContent = 'data: ' . $mimeType . ';base64,' . $fileData;
            //$fileContent = 'data: ' . mime_content_type($filePath) . ';base64,' . $fileData;
        }
        return ['extention' => $extention ?? '', 'file_content' => $fileContent ?? ''];
    }
}
if (!function_exists('getMimeTypeFallback')) {
    function getMimeTypeFallback(string $extension): string
    {
        $mime_types = [
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'png' => 'image/png',
            'gif' => 'image/gif',
            'pdf' => 'application/pdf',
            'txt' => 'text/plain',
            'zip' => 'application/zip',
            'json' => 'application/json',
            'csv' => 'text/csv',
            'doc' => 'application/msword',
            'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'xls' => 'application/vnd.ms-excel',
            'xlsx' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'ppt' => 'application/vnd.ms-powerpoint',
            'pptx' => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        ];
        return $mime_types[$extension] ?? 'application/octet-stream';
    }
}

if (! function_exists('fetchSALOGDocuments')) {
    function fetchSALOGDocuments(int $orderId, string $downloadType = 'ONE'): int
    {
        $result = 0;
        $CI     = &get_instance();
        $CI->load->model(['common', 'Roadlogtosalogmodel']);
        $CI->load->library('SALOGDownloadDocuments');
        $getOrderInfo        = $CI->common->gettblrowdata(['id' => $orderId], "company_code,branch_code", "tb_orders", 0, 0);
        $getTrackingNumber   = $CI->common->gettblrowdata(['reference_id' => 'XSR', 'order_id' => $orderId], "ref_value", "tb_order_references", 0, 0);
        $allDocumentTypesIds = $CI->Roadlogtosalogmodel->getSALOGDocumentTypesIds($getOrderInfo['company_code']);
        if ($getTrackingNumber && ! empty($allDocumentTypesIds)) {
            $CI->Roadlogtosalogmodel->deleteExistingSALOGDocs($orderId, $allDocumentTypesIds);
            $documents   = [];
            $documents[] = $CI->Roadlogtosalogmodel->getCompanyWiseSALOGDocsTypes($getOrderInfo['company_code']);
            if ($getOrderInfo['branch_code'] === 'CNCTU') {
                $specificDocumentTypesIds = $CI->Roadlogtosalogmodel->getSALOGSpecificDocumentTypesIds('CNCTU_SALOG_ORDER_TYPE_DEL_DOCS');
                if ($specificDocumentTypesIds) {
                    $CI->Roadlogtosalogmodel->deleteExistingSALOGDocs($orderId, $specificDocumentTypesIds);
                }
                $documents[] = $CI->Roadlogtosalogmodel->getSALOGOrderTypeDocTypes('CNCTU_SALOG_ORDER_TYPE_DEL_DOCS');
            }
            $salogDocumentTypes = implode(',', $documents);
            $salogDocumentTypes = explode(',', $salogDocumentTypes);
            if ($salogDocumentTypes) {
                $isDownloadMultiple = 0;
                if (checkAccessConditions('SALOG_DOCS_MULTIPLE_DOWNLOAD_COUNTRY', $getOrderInfo['company_code']) && $downloadType === 'ALL') {
                    $isDownloadMultiple = 1;
                }
                foreach ($salogDocumentTypes as $type) {
                    $downloadType = 'ONE';
                    if ($isDownloadMultiple === 1 && checkAccessConditions('SALOG_DOCS_MULTIPLE_DOWNLOAD_DOCTYPE', $type)) {
                        $downloadType = 'ALL';
                    }
                    $result += $CI->salogdownloaddocuments->downloadSALOGByDocumentType($orderId, $getTrackingNumber['ref_value'], $type, $downloadType);
                }
                if ($result) {
                    log_message("error", "Total SALOG Docs downloaded for the order id {$orderId} is {$result}");
                    return 1;
                }
            }
        } else {
            log_message("error", "No Tracking Number to download SALOG Docs for {$orderId}");
        }
        return 0;
    }
}

function xborderCount(): array
{
    $ci = &get_instance();
    $ci->load->model('common');
    $companyCode = $ci->session->userdata('company_code');
    $roleId      = $ci->session->userdata('user_role_id');
    if ($companyCode == '') {
        return [];
    }
    if ($roleId != "2") {
        return [];
    }
    $notificationCount = $ci->common->gettbldata(
        [
            'xborder_reference' => $companyCode,
            'status'            => '1',
        ],
        "GROUP_CONCAT(id) as id ,count(DISTINCT (order_id)) as count, GROUP_CONCAT(DISTINCT (order_id)) as order_id",
        "xborder_notifications",
        0,
        0
    );
    return $notificationCount ?? [];
}

function xbdrNotificationInsert($id, $companyCode, $value, $order_id, $branchCode)
{
    $ci = &get_instance();
    if ($id == 'XBRDR' and ($companyCode != $value)) {
        $data = [
            'order_id'          => $order_id,
            'company_code'      => $companyCode,
            'branch_code'       => $branchCode,
            'xborder_reference' => $value,
            'status'            => 1,
        ];
        $check = $ci->db->select('id')->get_where('xborder_notifications', [
            'order_id'          => $order_id,
            'xborder_reference' => $value,
            'status'            => '1',
        ]);
        if ($check->num_rows() == 0) {
            $orderReferenceValueInsert = $ci->db->insert("xborder_notifications", $data);
        }
    }
    return $orderReferenceValueInsert ?? 0;
}


function get_status_description($status_id)
{
    $ci = &get_instance();
    $res = [];
    if ($status_id != "") {
        $sql = "SELECT status_description,status_id,mode_of_transport,process_name,status_icon FROM tb_status_type WHERE  STATUS = '1' AND  status_id='" . $status_id . "' ORDER BY status_id DESC LIMIT 1";
        $query = $ci->db->query($sql);
        //echo '1<pre>';echo $ci->db->last_query();echo '</pre>';
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
        }
    }
    return $res;
}

function get_order_type_description($order_type)
{
    $ci = &get_instance();
    $res = [];
    if ($order_type != "") {
        $sql = "SELECT id, order_type, description, customer, organization, business_entity, business_enity_value, status, createdby, createdon, modifiedby, modifiedon FROM tb_order_type WHERE  STATUS = '1' AND  id='" . $order_type . "' ORDER BY order_type DESC LIMIT 1";
        $query = $ci->db->query($sql);
        //echo '1<pre>';echo $ci->db->last_query();echo '</pre>';exit;
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
        }
    }
    return $res;
}

function get_party_contacts($id)
{
    $ci = &get_instance();
    $res = [];
    if ($id != "") {
        $sql = "SELECT `id`, `name`, `street`, `city`, `state`, `country`, `zipcode`, `phone`, `fax`, `email`, `status`, `createdby`, `createdon`, `modifiedby`, `modifiedon`, `party_id`, `party_role`, `party_code` FROM tb_party_contacts WHERE  STATUS = '1' AND  id='" . $id . "' ORDER BY id DESC LIMIT 1";

        $query = $ci->db->query($sql);
        //echo '1<pre>';echo $ci->db->last_query();echo '</pre>';
        if ($query->num_rows() > 0) {
            $res = $query->row_array();
        }
    }
    return $res;
}

if (!function_exists('getlatlngsbyaddress')) {
    function getlatlngsbyaddress($address)
    {
        $address = trim($address);
        $ci = &get_instance();
        if (empty(GOOGLE_MAP_KEY)) {
            return ['', '', '', ''];
        }

        $apiResults = ProcessGoogleAPICurl(
            'https://maps.googleapis.com/maps/api/geocode/json?address=' . urlencode($address) . '&key=' . GOOGLE_MAP_KEY
        );
        if (empty($apiResults) or $apiResults['status'] !== 'OK') {
            return ['', '', '', ''];
        }
        $googleLat = $apiResults['results'][0]['geometry']['location']['lat'];
        $googleLng = $apiResults['results'][0]['geometry']['location']['lng'];
        $googleFormattedAddress = $apiResults['results'][0]['formatted_address'];
        $googleShortAddress = $country = '';
        // find first address component of type "route" and use it as short address
        foreach ($apiResults['results'][0]['address_components'] as $googleAddressComponent) {
            if (in_array('route', $googleAddressComponent['types'])) {
                $googleShortAddress = $googleAddressComponent['long_name'];
            } elseif (in_array('country', $googleAddressComponent['types'])) {
                $country = $googleAddressComponent['short_name'];
            }
        }
        return [
            $googleLat,
            $googleLng,
            $googleFormattedAddress,
            $country,
        ];
    }
}

if (!function_exists('getLocationName')) {
    function getLocationName($lat, $lng)
    {
        if (!$lat || !$lng) {
            return '';
        }

        $ci = &get_instance();
        if (empty(GOOGLE_MAP_KEY)) {
            return ['', '', '', ''];
        }
        $apiResults = ProcessGoogleAPICurl(
            "https://maps.googleapis.com/maps/api/geocode/json?latlng=" . trim($lat) . ',' . trim($lng) . "&key=" . GOOGLE_MAP_KEY
        );
        
        if (isset($apiResults['status']) && $apiResults['status'] === 'OK') {
            $name = isset($apiResults["results"][0]["formatted_address"]) ? $apiResults["results"][0]["formatted_address"] : "";
        }
        return $name ?? "";
    }
}

function getTimeZoneFromIpAddress()
{
    $clientsIpAddress = get_client_ip();

    $clientInformation = unserialize(file_get_contents('http://www.geoplugin.net/php.gp?ip=' . $clientsIpAddress));

    $clientsLatitude = $clientInformation['geoplugin_latitude'];
    $clientsLongitude = $clientInformation['geoplugin_longitude'];
    $clientsCountryCode = $clientInformation['geoplugin_countryCode'];

    $timeZone = get_nearest_timezone($clientsLatitude, $clientsLongitude, $clientsCountryCode);

    return $timeZone;

}
function get_client_ip()
{
    // Check for IP address in $_SERVER array
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED'])) {
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    } elseif (!empty($_SERVER['REMOTE_ADDR'])) {
        $ip = $_SERVER['REMOTE_ADDR'];
    } else {
        $ip = 'UNKNOWN';
    }
    //$ip = '124.123.179.44';
    //log_message("error", "ip Address : " . $ip);
    return $ip;
}

function get_nearest_timezone($cur_lat, $cur_long, $country_code = '')
{
    $timezone_ids = ($country_code) ? DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country_code)
    : DateTimeZone::listIdentifiers();

    if ($timezone_ids && is_array($timezone_ids) && isset($timezone_ids[0])) {

        $time_zone = '';
        $tz_distance = 0;

        //only one identifier?
        if (count($timezone_ids) == 1) {
            $time_zone = $timezone_ids[0];
        } else {

            foreach ($timezone_ids as $timezone_id) {
                $timezone = new DateTimeZone($timezone_id);
                $location = $timezone->getLocation();
                $tz_lat = $location['latitude'];
                $tz_long = $location['longitude'];

                $theta = $cur_long - $tz_long;
                $distance = (sin(deg2rad($cur_lat)) * sin(deg2rad($tz_lat)))
                     + (cos(deg2rad($cur_lat)) * cos(deg2rad($tz_lat)) * cos(deg2rad($theta)));
                $distance = acos($distance);
                $distance = abs(rad2deg($distance));
                // echo '<br />'.$timezone_id.' '.$distance;

                if (!$time_zone || $tz_distance > $distance) {
                    $time_zone = $timezone_id;
                    $tz_distance = $distance;
                }

            }
        }
        //log_message("error", "timezone through ip Address : " . $time_zone);
        return $time_zone;
    }
    return 'unknown';
}

function formatDate($date, $timestamp = '')
{
    if ($date != '' && $date != "0000-00-00 00:00:00" && $date != '0') {
        if ($timestamp) {
            return date("d M Y h:i A", strtotime($date));
        } else {
            return date("d M Y", strtotime($date));
        }
    }
    return false;
}

function updateCustomStatus(array $orderStatusData): string
{
    foreach ($orderStatusData as $ordersData) {
        $orderDataId = $ordersData['orderID'];
        $statusHistory = $ordersData['statusHistory'];
        $orderStatusId = $ordersData['statusCode'];
        $statusType = $ordersData['statusValue'];
        $orderStatusDateTime = $ordersData['dateTime'];
        $orderStatusLocation = $ordersData['location'];
        $orderStatusRemarks = $ordersData['remarks'];
        $statusLatitude = $statusLongitude = "";

        $select = "tto.trip_id as trip_id, tbo.id as id, tbo.organization_id as organization_id,tbo.entity_value_id as entity_value_id,tbo.pickup_end_date as pickup_end_date,tbo.delivery_end_date as delivery_end_date,tbo.external_order_id as external_order_id,tbo.source as source";
        $whr = array("tbo.order_id" => $orderDataId, "tbo.status <>" => 0);
        $orderAry = $this->common->getjointbldata("tb_orders tbo", "tb_trip_orders tto", "tbo.id = tto.order_id", $whr, $select, 0, 0);
        $statusResponse = 0;
        if (sizeof($orderAry) > 0) {
            $orderId = $orderAry[0]['id'];
            $tripId = $orderAry[0]['trip_id'];
            $selectElgStatus = "otm_status";
            $whrElgStatus = array("elg_status" => $orderStatusId, "status <>" => 0);
            $elgStatusAry = $this->common->gettbldata($whrElgStatus, $selectElgStatus, "tb_edi_status", 0, 0);
            $orderStatus = 1;
            if ($orderStatusId == "1491" || $orderStatusId == "1048" || $orderStatusId == "3470") {
                $orderStatus = 1;
            }
            if ($orderStatusId == "3178" || $orderStatusId == "1748" || $orderStatusId == "1750" || $orderStatusId == "1749") {
                $orderStatus = 2;
            }
            if ($orderStatusId == "1427") {
                $orderStatus = 3;
            }
            if ($orderStatusId == "1048" && ($orderAry[0]['pickup_end_date'] == "")) {
                $insOrder = ["pickup_end_date" => $orderStatusDateTime, "order_status" => $orderStatus];
            } else if ($orderStatusId == "1750" && ($orderAry[0]['delivery_end_date'] == "")) {
                $insOrder = ["delivery_end_date" => $orderStatusDateTime, "order_status" => $orderStatus];
            } else {
                $insOrder = ["order_status" => $orderStatus];
            }
            $this->common->updatetbledata("tb_orders tbo", $insOrder, $whr);

            $statusSelect = "id";
            $statusWhr = array("status_id" => $orderStatusId, "status <>" => 0);
            $statusTypeAry = $this->common->gettbldata($statusWhr, $statusSelect, "tb_status_type", 0, 0);

            $orderStatusAutoId = $this->db->escape_str($statusTypeAry[0]['id']);

            $selectStatus = "*";
            $whrStatusCheck = array("order_id" => $orderId, "trip_id" => $tripId, "order_status_id" => $orderStatusAutoId, "status <>" => 0);
            $orderInfoAry = $this->common->gettbldata($whrStatusCheck, $selectStatus, "tb_order_status", 0, 0);
            if (sizeof($orderInfoAry) > 0) {
                if ($statusHistory == "YES") {
                    $ins = ["order_status_id" => $orderStatusAutoId, "order_status_date_and_time" => $orderStatusDateTime, "order_status_location" => $orderStatusLocation, "status_latitude" => $statusLatitude, "status_longitude" => $statusLongitude, "order_status_remarks" => $orderStatusRemarks, "createdon" => date('Y-m-d H:i:s'),
                        "modifiedon" => date('Y-m-d H:i:s'), "status" => 1, "status_type" => $statusType];
                    $whrStatus = ["order_id" => $orderId, "trip_id" => $tripId, "order_status_id" => $orderStatusAutoId, "status <>" => 0];
                    $statusResponse = $this->common->updatetbledata("tb_order_status", $ins, $whrStatus);
                } else {
                    $statusResponse = 1;
                }
            } else {
                $orderStatus = [
                    'order_id' => $this->db->escape_str($orderId),
                    'trip_id' => $this->db->escape_str($tripId),
                    'order_status_id' => $this->db->escape_str($orderStatusAutoId),
                    'order_status_date_and_time' => $this->db->escape_str($orderStatusDateTime),
                    'order_status_location' => $this->db->escape_str($orderStatusLocation),
                    'status_latitude' => $this->db->escape_str($statusLatitude),
                    'status_longitude' => $this->db->escape_str($statusLongitude),
                    'order_status_remarks' => $this->db->escape_str($orderStatusRemarks),
                    'status' => '1',
                    'status_type' => $this->db->escape_str($statusType),
                    'organization_id' => $this->db->escape_str($orderAry[0]['organization_id']),
                    'entity_value_id' => $this->db->escape_str($orderAry[0]['entity_value_id']),
                    'createdon' => date('Y-m-d H:i:s'),
                    'modifiedon' => date('Y-m-d H:i:s'),
                ];
                $order = $this->db->insert("tb_order_status", $orderStatus);
                $statusResponse = $this->db->insert_id();
            }

            $selectTripStatus = "*";
            $whrTripStatusCheck = array("order_id" => $orderId, "trip_id" => $tripId, "status_id" => $orderStatusAutoId, "status <>" => 0);
            $tripInfoAry = $this->common->gettbldata($whrTripStatusCheck, $selectTripStatus, "tb_trip_status", 0, 0);
            if (sizeof($tripInfoAry) > 0) {
                if ($statusHistory == "YES") {
                    $insTrip = ["status_id" => $orderStatusAutoId, "status_date" => $orderStatusDateTime, "status_location" => $orderStatusLocation, "latitude" => $statusLatitude, "longitude" => $statusLongitude, "createdon" => date('Y-m-d H:i:s'),
                        "updatedon" => date('Y-m-d H:i:s'), "status" => 1, "status_type" => $statusType];
                    $whrTripStatus = ["order_id" => $orderId, "trip_id" => $tripId, "status_id" => $orderStatusAutoId, "status <>" => 0];
                    $statusResponse = $this->common->updatetbledata("tb_trip_status", $insTrip, $whrTripStatus);
                } else {
                    $statusResponse = 1;
                }
            } else {
                $tripStatus = [
                    'trip_id' => $this->db->escape_str($tripId),
                    'order_id' => $this->db->escape_str($orderId),
                    'status_id' => $this->db->escape_str($orderStatusAutoId),
                    'status_location' => $this->db->escape_str($orderStatusLocation),
                    'latitude' => $this->db->escape_str($statusLatitude),
                    'longitude' => $this->db->escape_str($statusLongitude),
                    'status_date' => $this->db->escape_str($orderStatusDateTime),
                    'status' => '1',
                    'status_type' => $this->db->escape_str($statusType),
                    'createdon' => date('Y-m-d H:i:s'),
                    'updatedon' => date('Y-m-d H:i:s'),
                ];
                $trip = $this->db->insert("tb_trip_status", $tripStatus);
                $statusResponse = $this->db->insert_id();
            }
        }
    }
    return $statusResponse;
}

if (!function_exists('getMasterDataForOrderQuickbook')) {
        function getMasterDataForOrderQuickbook(array $sessionData)
        {
            if (empty($sessionData)) {
                return [];
            }
            $ci = &get_instance();
            $ci->load->model('common');
            $entityValues = getParentAndChildBusinessEntityIds();
            if (empty($entityValues)) {
                return [];
            }
            $getOrderTypeData = $ci->common->gettbldata("business_enity_value IN (" . implode(', ', $entityValues) . ") AND status ='1'", "id,order_type", "tb_order_type", 0, 0);
            foreach ($getOrderTypeData as $eachRow) {
                $orderTypes[] = ['rowId' => $eachRow['id'], 'orderType' => $eachRow['order_type']];
            }
    
            $getModeOfTransportData = $ci->common->gettbldata("business_enity_value IN (" . implode(', ', $entityValues) . ") AND status ='1'", "id,name,short_name", "tb_mode_of_transport", 0, 0);
            foreach ($getModeOfTransportData as $eachRow) {
                $modeOfTransport[] = ['rowId' => $eachRow['id'], 'name' => $eachRow['name'], 'shortName' => $eachRow['short_name']];
            }
            $getServiceMasterData = $ci->common->gettbldata("entity_value_id IN (" . implode(', ', $entityValues) . ") AND status ='1'", "id,service_id,name", "tb_service_master", 0, 0);
            foreach ($getServiceMasterData as $eachRow) {
                $serviceMaster[] = ['rowId' => $eachRow['id'], 'name' => $eachRow['name'], 'serviceId' => $eachRow['service_id']];
            }
            $getIncotermData = $ci->common->gettbldata("business_entity_value IN (" . implode(', ', $entityValues) . ") AND status ='1'", "id,incoterm_code,name", "tb_incoterm_codes", 0, 0);
            foreach ($getIncotermData as $eachRow) {
                $incoterm[] = ['rowId' => $eachRow['id'], 'name' => $eachRow['name'], 'incotermCode' => $eachRow['incoterm_code']];
            }
            $getReferenceData = $ci->common->gettbldata("business_enity_value IN (" . implode(', ', $entityValues) . ") AND status ='1'", "reference_type_id,reference_type,name,description", "tb_reference_type_master", 0, 0);
            foreach ($getReferenceData as $eachRow) {
                $referencesMaster[] = ['rowId' => $eachRow['reference_type_id'], 'referenceType' => $eachRow['reference_type'], 'name' => $eachRow['name'], 'description' => $eachRow['description']];
            }
            $getVasData = $ci->common->gettbldata("business_entity_value_id IN (" . implode(', ', $entityValues) . ") AND status ='1'", "id,vas_id,vas_name", "tb_vas_master", 0, 0);
            foreach ($getVasData as $eachRow) {
                $vasMaster[] = ['rowId' => $eachRow['id'], 'vasId' => $eachRow['vas_id'], 'vasName' => $eachRow['vas_name']];
            }
            return ['vasMaster' => $vasMaster ?? [], 'referencesMaster' => $referencesMaster ?? [],'incoterm' => $incoterm ?? [], 'serviceMaster' => $serviceMaster ?? [], 'modeOfTransport' => $modeOfTransport ?? [], 'orderTypes' => $orderTypes ?? []];
        }
    }

    if (!function_exists('getUserParties')) {
        function getUserParties()
        {
            $ci = &get_instance();
            $user = $ci->session->userdata('user_id');
            $checkParentPartyId = $ci->db->query("SELECT id FROM tb_party WHERE user_id = ? AND status = ?", [$user, 1]);
            if ($checkParentPartyId->num_rows() > 0) {
                foreach ($checkParentPartyId->result_array() as $res1) {
    
                    $partyIds[] = $id = $res1['id'];
                }
            }
            $checkChildPartyIds = $ci->db->query("SELECT id FROM tb_party WHERE parent_customer = ? AND status = ?", [$id, 1]);
            if ($checkChildPartyIds->num_rows() > 0) {
                foreach ($checkChildPartyIds->result_array() as $res1) {
    
                    $partyIds[] = $id = $res1['id'];
                }
            }
            return $partyIds ?? [];
        }
    }
    
    function formatNumber($num)
    {
        $rounded = round($num, 2);
        if (fmod($rounded, 1) == 0.0) {
            return (int) $rounded; // no decimals if whole number
        }
        return number_format($rounded, 2, '.', ''); // force 2 decimals
    }
    
    function xmlEscape($value)
    {
        return htmlspecialchars($value, ENT_XML1, 'UTF-8');
    }

    