<?php

class Aconinvoiceduedate
{

    private $ci;

    function __construct()
    {
        $ci = &get_instance();
    }

    /*
     * Get Acon invoice due date
     * @param  invoice  int   => 1-success and 0 fail
     */

    public function getrequest($invoice = "")
    {


        $ci = &get_instance();
        $ci->load->model("common");
        $data = $this->Acon_Invoice_Due_Date($invoice);

        if (count($data) > 0) {

            $options = [
                'soap_version' => SOAP_1_1,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'cache_wsdl' => 0,
                'trace' => 1
            ];

            // Security Header
            $securityHeaderXml = '
                <wsse:Security xmlns:wsse="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"
                    xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"
                    SOAP-ENV:mustUnderstand="1">
                        <wsse:UsernameToken wsu:Id="UsernameToken-8ff6cb08-604b-4c87-8132-de594e4ef516">
                           <wsse:Username>'.ACON_DUE_DATE_LOGIN.'</wsse:Username>
                           <wsse:Password Type="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText">'.ACON_DUE_DATE_PASSWORD.'</wsse:Password>
                        </wsse:UsernameToken>
                </wsse:Security>';

            $headerSecurity = new \SoapHeader(
                'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd',
                'Security',
                new \SoapVar($securityHeaderXml, XSD_ANYXML),
                true
            );

            // Audit Header
            $headerAuditNs = 'http://knesb.int.kn/xsd/esb/audit/v01';
            $applicationID = new SoapVar(ACON_DUE_DATE_APPLICATIONID, XSD_STRING, null, null, 'ApplicationID', $headerAuditNs);
            $requestID = new SoapVar(ACON_DUE_DATE_REQUESTID, XSD_STRING, null, null, 'RequestID', $headerAuditNs);
            $correlationId = new SoapVar(ACON_DUE_DATE_CORRELATIONID, XSD_STRING, null, null, 'CorrelationID', $headerAuditNs);
            $auditNode = new SoapVar([$applicationID, $requestID, $correlationId], SOAP_ENC_OBJECT, null, null, 'Audit', $headerAuditNs);

            $headerAudit = new SoapHeader(
                $headerAuditNs,
                'Audit',
                $auditNode
            );

            // Routing Header
            $routingHeaderXml = '
                <ns2:Routing xmlns:ns2="http://knesb.int.kn/xsd/esb/routing/v1/">
                    <ns2:Properties>
                       <ns2:Property Name="KNESB_Routing_Company">' . $data['company_code'] . '</ns2:Property>
                       <ns2:Property Name="KNESB_Routing_SenderId">'.ACON_DUE_DATE_ROUTING_SENDERID.'</ns2:Property>
                    </ns2:Properties>
                </ns2:Routing>';

            $headerRouting = new \SoapHeader(
                'http://knesb.int.kn/xsd/esb/routing/v1/',
                'Routing',
                new \SoapVar($routingHeaderXml, XSD_ANYXML)
            );

            // Initialize SOAP client
            $client = new SoapClient(ACON_DUE_DATE_IP, $options);
            $client->__setSoapHeaders([
                $headerSecurity,
                $headerAudit,
                $headerRouting
            ]);

            $myClass = new \stdClass;
            $myClass->CompanyCode = $data['company_code'];
            $myClass->DebtorCode = $data['accountcode'];
            $myClass->ItemType = $data['invoice_typecode'];
            $myClass->ItemDate = $data['invoice_date'];
            $myClass->TrackingNo = $data['invoice_no'];
            $myClass->ProfitCentre = '';
            $myClass->BusinessType = 'O';
            $myClass->IsCashInvoice = 'N';
            $myClass->ChargeType = '';
            $myClass->CallingApplication = 'ETRUCAR';
            $myClass->JobFileNo = '';

            try {
                $response = $client->GetInvoiceDueDate($myClass);
            } catch (Exception $e) {
                log_message('error', 'Acon Invoice DueDate error: ' . $e->getMessage());
            }

            log_message("error", "Acon Invoice DueDate response" . json_encode($response));
            $array = (array)$response;

            if (!empty($array)) {
                $acon_invoice_due_date = $array['DueDate'] ?? '';
                $acon_invoice_due_payment_term = $array['PaymentTerm'] ?? '';
                $acon_invoice_due_credit_terms = $array['CreditTerm'] ?? '';
                $acon_invoice_isprint_due_date = $array['IsPrintDueDate'] ?? '';
                $acon_invoice_due_date_special_text = $array['SpecialText'] ?? '';

                $upd_bill = $ci
                    ->db
                    ->where(['id' => $invoice])
                    ->update("tbl_bills",
                        [
                            'acon_invoice_due_date_status' => 1,
                            'acon_invoice_due_date' => $acon_invoice_due_date,
                            'acon_invoice_due_payment_term' => $acon_invoice_due_payment_term,
                            'acon_invoice_due_credit_terms' => $acon_invoice_due_credit_terms,
                            'acon_invoice_isprint_due_date' => $acon_invoice_isprint_due_date,
                            'acon_invoice_due_date_special_text' => $acon_invoice_due_date_special_text
                        ]
                    );
            }
        } else {

            log_message("error", "Acon Invoice billid id not found " . $invoice);
        }

        return $array;

    }

    public function Acon_Invoice_Due_Date($billid)
    {
        $ci = &get_instance();
        $ci->load->model("common");
        $ci->load->library('session');
        $ci->load->model("aconedimodel");
        $curdt = date('Y-m-d H:i:s');
        $data['status'] = 0;
        $bu_data = array();
        if ($billid > 0) {
            $acon_invoice_due_date_status = 0;
            $chkbill = $ci->common->gettblrowdata(array('id' => $billid), "acon_invoice_due_date_status", "tbl_bills", 0, 0);
            if (!empty($chkbill)) {
                $acon_invoice_due_date_status = $chkbill['acon_invoice_due_date_status'];
            }
            if ($acon_invoice_due_date_status == 0) {
                $zonecode = $ci->session->userdata("usr_tzone");
                $curtz = $zonecode['timezone'];
                $cntryname = $zonecode['country_name'];
                $cntrycode = $zonecode['country'];
                $getactual = getdatetimebytimezone($curtz, $curdt, DFLT_TZ);
                $timestamp = $getactual['date'] . "T" . $getactual['time'] . "Z";
                $invoice_typecode = "I";
                $company_code = '';
                $branch_code = '';
                $routing_company = '';

                $getdata = $ci->aconedimodel->gettblrowdata(array("id" => $billid), "branch_code,company_code", "tbl_bills", 0, 0);
                if (count($getdata) > 0) {
                    $company_code = $getdata["company_code"];
                    $branch_code = $getdata["branch_code"];
                } else {
                    log_message("error", "Acon Invoice DueDate Company Code Missing- " . $ci->db->last_query());
                }

                $getacon_country = $ci->aconedimodel->gettblrowdata(array("branch_code" => $branch_code, 'company_code' => $company_code), "acon_country", "tb_branch_master", 0, 0);
                if (count($getacon_country) > 0) {
                    $routing_company = $getacon_country['acon_country'];
                } else {
                    log_message("error", "Acon Invoice DueDate Company Code Missing- " . $ci->db->last_query());
                }


                if (count($getacon_country) > 0) {
                    $routing_company = $getacon_country['acon_country'];
                } else {
                    log_message("error", "Acon Invoice DueDate Company Code Missing- " . $ci->db->last_query());
                }

                $duedate = date("Y-m-20", strtotime("+1 month"));
                $issuedate = date("Ym");
                $invoice_no = $acon_code = $currency = $id = $invoice_date = "";
                $billgroup_id = 0;
                $getbilldata = $ci->aconedimodel->gettblrowdata(array("id" => $billid), "bill_group,invoice_no,invoice_date,acon_code,currency,iscashinvoice,id", "tbl_bills", 0, 0);
                log_message("error", "Acon Invoice DueDate getbilldata- " . $ci->db->last_query());
                if (count($getbilldata) > 0) {
                    $invoice_no = $getbilldata['invoice_no'];
                    $acon_code = $getbilldata['acon_code'];
                    $currency = $getbilldata['currency'];
                    $invoice_date = $getbilldata['invoice_date'];
                    $billgroup_id = $getbilldata['bill_group'];
                    $id = $getbilldata['id'];
                    $iscashinvoice = "N";
                    if ($getbilldata['iscashinvoice'] == "0") {
                        $iscashinvoice = "N";

                    } else if ($getbilldata['iscashinvoice'] == "1") {
                        $iscashinvoice = "Y";
                    }

                    if ($invoice_date != "") {
                        $issuedate = date('Ym', strtotime($invoice_date));
                    }
                }
                $where = array("r.type" => '0', 'r.invoice_status' => '2', 'r.bill_id' => $billid, 'r.status' => '1');
                if ($billgroup_id > 0) {
                    $getbillgroup = $ci->aconedimodel->gettblrowdata(array("id" => $billgroup_id), "name", "tb_billgroup_master", 0, 0);
                    log_message("error", "Acon Invoice DueDate getbillgroup- " . $ci->db->last_query());
                    if (count($getbillgroup) > 0) {
                        if ($getbillgroup['name'] == "Bill") {
                            $invoice_typecode = "I";
                            $where['amount >'] = 0;
                        } else if ($getbillgroup['name'] == "Credit Note") {
                            $invoice_typecode = "C";
                            $where['amount <'] = 0;
                        }

                    }
                    $data = array('company_code' => $routing_company, 'accountcode' => str_replace(' ', '', $acon_code), 'itemduedate' => $duedate, 'issuedate' => $issuedate, 'currency' => $currency, 'invoice_no' => $invoice_no, 'invoice_date' => $invoice_date, 'invoice_typecode' => $invoice_typecode, 'iscashinvoice' => $iscashinvoice, 'id' => $id);
                }


            } else {
                log_message("error", "Genarate Acon Invoice DueDate status- 2");
                $data['status'] = 2;
            }
        }
        return $data;
    }


}
