<?php

use phpseclib\Net\SSH2;

use phpseclib\Net\SFTP;

class Amazonstatusintegration

{

    /**

     * Update OrderStatus

     *

     * @param  mixed $postdata

     * @return void

     */

    public function updateOrderStatus($postdata)

    {

        $ci = &get_instance();

        $post['shipment_id'] = $postdata['shipment_id'];

        $post['trip_id']     = $postdata['trip_id'];

        $post['stop_id']     = $postdata['stop_id'];

        $post['driver_id']   = isset($postdata['driver_id']) ? $postdata['driver_id'] : "";

        $post['vehicle_id']   = isset($postdata['vehicle_id']) ? $postdata['vehicle_id'] : "";

        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";

        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";

        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";

        $post['pickup_state']   = isset($postdata['pickup_state']) ? $postdata['pickup_state'] : "";

        $post['pickup_address1']   = isset($postdata['pickup_address1']) ? $postdata['pickup_address1'] : "";

        $post['pickup_country']   = isset($postdata['pickup_country']) ? $postdata['pickup_country'] : "";

        $order_id = isset($postdata['ord_id']) ? $postdata['ord_id'] : "";

        $post['id'] = $order_id;

        $post['billOfLanding'] = "";

        $post['containerno'] = "";

        $refdata = array();

       $post['refdata'] = $refdata;

        if ($order_id != "") {

            $post['carrier_scac'] = 'KHNU';

            $post['status_code'] = $postdata['status_code'];

            $post['status_reason'] = 'NS';

            $post['trackingnumber'] = $postdata['order_id'];

            /*check driver and vehicle*/

            $post['vehicle_num'] = $post['driver_name'] = "";

            /*if($post['status_code'] == "TL" || $post['status_code'] == "CL" || $post['status_code'] == "LY"){*/

                if($post['vehicle_id'] != ""){

                    $chqry = $ci->db->select("register_number")->get_where("tb_trucks_data",array('id'=>$post['vehicle_id']),1,0);

                    if($chqry->num_rows() > 0){

                        $post['vehicle_num'] = $chqry->row()->register_number;

                    }

                }else{

                    $chqry1 = $ci->db->query("SELECT d.register_number FROM tb_trucks_data d,tb_shft_veh v WHERE d.id=v.vehicle_id AND v.shft_id='".$post['shipment_id']."' AND v.status=1 LIMIT 1");

                    if($chqry1->num_rows() > 0){

                        $post['vehicle_num'] = $chqry1->row()->register_number;

                    }

                }

            /*}*/

            $post['company_code'] = $post['branch_code'] = $post['shipment_id'] = $post['modeoftransport'] = "";

            $post['logicalreceiver'] = $post['physicalreceiver'] = $post['logicalsender'] = $post['physicalsender'] = "";

            $getordinfo = $ci->db->select("id,pickup_city, pickup_address1, pickup_country, company_code, branch_code, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, transport_mode,parent_id")->get_where("tb_orders",array("order_id"=>$postdata['order_id']),1,0);

            if($getordinfo->num_rows()>0){

                $ordid = $getordinfo->row()->id;

                $parentid = $getordinfo->row()->parent_id;

                $ref_ord_id = $order_id;

                if($parentid > 0){

                    $ref_ord_id = $parentid;

                }

                $referenceData = $ci->db->select("reference_id,ref_value")->get_where("tb_order_references",array('order_id'=>$ref_ord_id,"status"=>1));

                $refdata = array();

                if($referenceData->num_rows()>0){

                    foreach($referenceData->result() as $refq){

                        if($refq->reference_id == "BM"){

                            $post['billOfLanding'] = $refq->ref_value;

                        }

                        if($refq->reference_id == "CTR"){

                            $post['containerno'] = $refq->ref_value;

                        }

                        /*$refdata[] = array("referenceID"=>$refq->reference_id,"referenceValue"=>$refq->ref_value);*/

                    }

                }

                $orderpartyinfo = $ci->db->query("SELECT code,state FROM tb_order_parties o,tbl_party_master p,tbl_party_types t WHERE o.party_id=p.id AND o.order_id=$ordid AND o.party_type=t.id AND t.name='Shipper' AND o.status=1 LIMIT 1");

                if($orderpartyinfo->num_rows()>0){

                    $post['pickup_state'] = $orderpartyinfo->row()->state;

                }

                $post['company_code'] = $getordinfo->row()->company_code;

                $post['branch_code'] = $getordinfo->row()->branch_code;

                $post['shipment_id'] = $getordinfo->row()->shipmentid;

                if($post['shipment_id'] == ""){

                    $post['shipment_id'] = $postdata['order_id'];

                }

                if($post['pickup_city'] == ""){

                    $post['pickup_city'] = $getordinfo->row()->pickup_city;

                }

                if($post['pickup_address1'] == ""){

                    $post['pickup_address1'] = $getordinfo->row()->pickup_address1;

                }

                if($post['pickup_country'] == ""){

                    $post['pickup_country'] = $getordinfo->row()->pickup_country;

                }

                $post['logicalreceiver'] = $getordinfo->row()->logicalreceiver;

                $post['physicalreceiver'] = $getordinfo->row()->physicalreceiver;

                $post['logicalsender'] = $getordinfo->row()->logicalsender;

                $post['physicalsender'] = $getordinfo->row()->physicalsender;

                $post['modeoftransport'] = 'ROAD';/*$getordinfo->row()->transport_mode;*/

            }

            $post['createdon'] = date('Y-m-d H:i:s');

            $hrs = "Z";

            if(isset($postdata['hrs'])){

                $hrs = str_replace(".", ":", $postdata['hrs']);

            }

            if(isset($postdata['curtz'])){

                if(!isset($postdata['web'])){
                    $getactual = getdatetimebytimezone($postdata['curtz'],$post['createdon'],DFLT_TZ);
                    $post['createdon'] = $getactual['datetime'];
                    $post['date'] = $getactual['date'];
                    $post['time'] = $getactual['time']."".$hrs;
                }else{
                    $post['createdon'] = $postdata['web'];
                    $post['date'] = date('Y-m-d',strtotime($post['createdon']));
                    $post['time'] = date('H:i:s',strtotime($post['createdon']))."".$hrs;
                }

            }else{

                $post['date'] = date('Y-m-d');

                $post['time'] = date('H:i:s')."".$hrs;

            }

            $post['curdt'] = date('Y-m-d\TH:i:s.u', strtotime($post['createdon']))."".$hrs;

            $response = $this->sendOrderStatus($post);

            return true;

        } else {

            return false;

        }

    }



    /**

     * update order status

     *

     * @param  mixed $post

     * @return void

     */

    public function sendOrderStatus($post)

    {

        $request = '';

        $request .= '<?xml version="1.0" encoding="UTF-8"?>';

        $request .= '<ShipmentInformation>';

        $request .= '<TransactionInformation>';

        $request .= '<SenderIdentifier>'.$post['carrier_scac'].'</SenderIdentifier>';

        $request .= '<RecipientIdentifier>AMAZON</RecipientIdentifier>';

        $request .= '<DateOfPreparation>'.date('Ymd',strtotime($post['curdt'])).'</DateOfPreparation>';

        $request .= '<TimeOfPreparation>'.date('his',strtotime($post['time'])).'</TimeOfPreparation>';

        $request .= '</TransactionInformation>';

        $request .= '<EdiDocumentInformation>';

        $request .= '<EdiDocumentStandard>X12</EdiDocumentStandard>';

        $request .= '<EdiDocumentName>XML</EdiDocumentName>';

        $request .= '<EdiDocumentVersion>1.1</EdiDocumentVersion>';

        $request .= '</EdiDocumentInformation>';

        $request .= '<ShipmentStatusSeq>';

        $request .= '<ShipmentStatus>';

        $request .= '<ShipmentIdentification>';

        $request .= '<CarrierTrackingNum>'.$post['containerno'].'</CarrierTrackingNum>';

        $request .= '<BillOfLadingNumber>'.$post['billOfLanding'].'</BillOfLadingNumber>';

        $request .= '<ShipmentType>INBOUND</ShipmentType>';

        $request .= '</ShipmentIdentification>';

        $request .= '<LocationOfFreight>';

        $request .= '<Address>';

        $request .= '<City>'.$post['pickup_city'].'</City>';

        $request .= '<StateProvinceCode>'.$post['pickup_state'].'</StateProvinceCode>';

        $request .= '<CountryCode>'.$post['pickup_country'].'</CountryCode>';

        $request .= '</Address>';

        $request .= '</LocationOfFreight>';

        $request .= '<ShipmentStatusInformation>';

        $request .= '<Status>'.$post['status_code'].'</Status>';

        $request .= '<StatusReason>'.$post['status_reason'].'</StatusReason>';

        $request .= '</ShipmentStatusInformation>';

        $request .= '<TransportInformation>';

        $request .= '<TrailerNumber>'.$post['vehicle_num'].'</TrailerNumber>';

        $request .= '<TransportMode>'.$post['modeoftransport'].'</TransportMode>';

        $request .= '<CarrierSCAC>'.$post['carrier_scac'].'</CarrierSCAC>';

        $request .= '</TransportInformation>';

        $request .= '<DateTimePeriodInformation>';

        $request .= '<DateTimePeriodCode>123</DateTimePeriodCode>';

        $request .= '<DateTimePeriodFormat>203</DateTimePeriodFormat>';

        $request .= '<DateTimePeriodValue>'.date('Ymdhis',strtotime($post['createdon'])).'</DateTimePeriodValue>';

        $request .= '<DateTimePeriodDescription>UTC</DateTimePeriodDescription>';

        $request .= '</DateTimePeriodInformation>';

        /*$request .= '<ShipmentReferenceSequence>';

        if(count($post['refdata'])>0){

            foreach($post['refdata'] as $rf){

                $request .= '<ShipmentReference>';

                $request .= '<ReferenceId>'.$rf['referenceID'].'</ReferenceId>';

                $request .= '<ReferenceIdType>'.$rf['referenceValue'].'</ReferenceIdType>';

                $request .= '</ShipmentReference>';

            }

        }

        $request .= '</ShipmentReferenceSequence>';*/

        /*if($post['status_code'] == "TL" || $post['status_code'] == "CL" || $post['status_code'] == "LY"){

            $request .= '<ShipmentReferenceSequence>';

            $request .= '<ShipmentReference>';

            $request .= '<ReferenceId>'.$post['vehicle_num'].'</ReferenceId>';

            $request .= '<ReferenceIdType>VEHICLE</ReferenceIdType>';

            $request .= '</ShipmentReference>';

            $request .= '</ShipmentReferenceSequence>';

        }*/

        $request .= '</ShipmentStatus>';

        $request .= '</ShipmentStatusSeq>';

        $request .= '</ShipmentInformation>';

        //log_message('error', "amazon-statusxml " . $request);

        $filename = "KHNU_STATUS_".date('YmdHis')."_".$post['containerno']."_".$post['status_code'].".xml";

        $localfile = "./assets/amazonedis/".$filename;

        if (!file_exists(dirname($localfile))) {

          mkdir(dirname($localfile), 0700, true);

        }

        file_put_contents($localfile, $request);

        $folder_name = "/pub/inbound";

        $sftp_url = UKAMZ_URL;

        $username = UKAMZ_USRNAME;

        $password = UKAMZ_PWD;
        try{
            $sftp = new SFTP($sftp_url);

            if (!$sftp->login($username, $password)) {
                unset($sftp);
                /*throw new \Exception('Cannot login into your server !');*/
                log_message("error","Cannot login into your UK MTF Test server !");
            }else{

                $sftp->chdir($folder_name);

                $sftp->put($folder_name."/".$filename,$localfile,SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error","Some Problem occured!, Please Try Again Later.");
        }
    }



    public function outboundTrailerASN($postdata)

    {

        $ci = &get_instance();

        $post['shipment_id'] = $shift_id = $postdata['shipment_id'];

        $post['trip_id']     = $postdata['trip_id'];

        $post['stop_id']     = $postdata['stop_id'];

        /*$post['driver_id']   = isset($postdata['driver_id']) ? $postdata['driver_id'] : "";

        $post['vehicle_id']   = isset($postdata['vehicle_id']) ? $postdata['vehicle_id'] : "";*/

        $post['latitude']   = isset($postdata['latitude']) ? $postdata['latitude'] : "";

        $post['longitude']   = isset($postdata['longitude']) ? $postdata['longitude'] : "";

        $post['pickup_city']   = isset($postdata['pickup_city']) ? $postdata['pickup_city'] : "";

        $post['pickup_state']   = isset($postdata['pickup_state']) ? $postdata['pickup_state'] : "";

        $post['pickup_address1']   = isset($postdata['pickup_address1']) ? $postdata['pickup_address1'] : "";

        $post['pickup_country']   = isset($postdata['pickup_country']) ? $postdata['pickup_country'] : "";

        $order_id = isset($postdata['ord_id']) ? $postdata['ord_id'] : "";

        if($order_id != ""){

            $post['id'] = $order_id;

            $post['carrier_scac'] = 'KHNU';

            $post['CartonCount'] = $post['weight'] = 1;

            $post['volume'] = 0;

            $post['weightuom'] = "KG";

            $post['volumeuom'] = "CR";

            $post['billOfLanding'] = $post['carriership_ref'] = $post['vendorcode'] = "";

            $post['transportationMode'] = "Road";

            $post['sealNumber'] = "NA";

            $post['deliveryServiceLevel'] = "X";

            $post['cargosInfo'] = array();

            $start_route = $end_route = "";

            $post['ponumber'] = "";

            $detailordinfo = $ci->db->select("id,purchase_order")->get_where("tb_order_details",array("order_row_id"=>$order_id),1,0);

            if($detailordinfo->num_rows()>0){

                $post['ponumber'] = $detailordinfo->row()->purchase_order;

            }

            $getordinfo = $ci->db->select("id,pickup_city, pickup_address1, pickup_country,delivery_country,delivery_address1, company_code, branch_code,weight, volume, shipment_id, shipmentid, logicalreceiver, physicalreceiver, physicalsender, logicalsender, transport_mode,createdon,parent_id")->get_where("tb_orders",array("id"=>$order_id),1,0);

            if($getordinfo->num_rows()>0){

                $parentid = $getordinfo->row()->parent_id;

                $ref_ord_id = $order_id;

                if($parentid > 0){

                    $ref_ord_id = $parentid;

                }

                $referenceData = $ci->db->select("ref_value,reference_id")->get_where("tb_order_references",array('order_id'=>$ref_ord_id,"status"=>1));

                $refdata = array();

                if($referenceData->num_rows()>0){

                    foreach($referenceData->result() as $oref){

                        if($oref->reference_id == "BM"){

                            $post['billOfLanding'] = $oref->ref_value;

                        }

                        if($oref->reference_id == "CTR"){

                            $post['carriership_ref'] = $oref->ref_value;

                        }

                        if($oref->reference_id == "POL"){

                            $start_route = $oref->ref_value;

                        }

                        if($oref->reference_id == "POD"){

                            $end_route = $oref->ref_value;

                        }

                        /*$refdata[] = array("referenceID"=>$oref->reference_id,"referenceValue"=>$oref->ref_value);*/

                    }

                }

                $post['modeoftransport'] = $getordinfo->row()->transport_mode;

                $temp_shipid = $getordinfo->row()->shipment_id;

                $post['load'] = "Load";

                $post['load_locationidtype'] = "ZP";

                $post['load_locationcode'] = $start_route;

                $post['load_countrycode'] = $getordinfo->row()->pickup_country;

                $post['discharge'] = "Discharge";

                $post['discharge_locationidtype'] = "FC";

                $post['discharge_locationcode'] = $end_route;

                $post['discharge_countrycode'] = $getordinfo->row()->delivery_country;

                $ordcargo = $ci->db->query("SELECT o.id,o.cargo_id, o.cargo_content, o.quantity, o.weight, o.volume, o.buyer_part, o.linebp_num1, o.linecontainer_no,o.qr_code FROM tb_order_cargodetails o,tb_shipment_pallets p WHERE o.id=p.pallet_id AND o.order_id=$order_id AND o.status=1 AND p.status=1 ORDER BY o.id ASC");

                $post['CartonCount'] = $ordcargo->num_rows();

                $i=0;

                $pweight = 0; $pvolume = 0;

                if($post['CartonCount']>0){

                    foreach($ordcargo->result_array() as $ocrg){

                        $palletid = $ocrg['id'];

                        $cargo_id = $ocrg['cargo_id'];

                        $pweight += $ocrg['weight'];

                        $pvolume += $ocrg['volume'];

                        $cargouom = $ci->db->get_where("tb_cargo_details",array('id'=>$cargo_id,"status"=>1));

                        if($cargouom->num_rows()>0){

                            foreach($cargouom->result_array() as $crg){

                                if($i == 0){

                                    $post['weightuom'] = $crg['weight_unit'];

                                    $post['volumeuom'] = $crg['volume_unit'];

                                }

                                if($ocrg['qr_code'] == ""){

                                    $cargouom1 = $ci->db->select("qr_code")->get_where("tb_inner_cargo",array('cargo_id'=>$cargo_id,'pallet_id'=>$palletid,"status"=>1),1,0);

                                    if($cargouom1->num_rows()>0){

                                        $ocrg['qr_code'] = $cargouom1->row()->qr_code;

                                    }

                                }

                                $post['cargosInfo'][] = array('cargo_type'=>$crg['cargo_type'],'id_type'=>'GM','ext_id_type'=>'CID','length'=>$crg['length'],'length_unit'=>$crg['length_unit'],'width'=>$crg['width'],'width_unit'=>$crg['width_unit'],'height'=>$crg['height'],'height_unit'=>$crg['height_unit'],'weight'=>$ocrg['weight'],'volumetric_weight'=>$crg['volumetric_weight'],'volweight_uom'=>$crg['volweight_uom'],'weight_unit'=>$crg['weight_unit'],'volume'=>$ocrg['volume'],'volume_unit'=>$crg['volume_unit'],'quantity'=>$ocrg['quantity'],'cargo_content'=>$ocrg['cargo_content'],'buyer_part'=>$ocrg['buyer_part'],'buyer_part_code'=>'BP','externel_id'=>$ocrg['linebp_num1'],'linecontainer_no'=>$ocrg['linecontainer_no'],'qr_code'=>$ocrg['qr_code'],'weight_qualifier'=>'G');

                            }

                        }

                        $i++;

                    }

                }

                $post['weight'] = $pweight;

                $post['volume'] = $pvolume;

                $post['shipmentdate'] = $getordinfo->row()->createdon;

                $destinatefc = explode(", ", $getordinfo->row()->delivery_address1);

                $post['destinatefc'] = $destinatefc[count($destinatefc)-1];

                $post['logdate'] = date('Y-m-d H:i:s');

                $bsn_asn = $ci->db->select("shipid,logdate,vendorcode")->get_where("tb_shipments",array('id'=>$temp_shipid,"status"=>1),1,0);

                $post['transport_mode'] = $getordinfo->row()->transport_mode;

                if($getordinfo->row()->transport_mode == "FTL"){

                    $post['transport_mode'] = "TL";

                }

                $post['shipmentasn'] = "";

                $post['shipmentid'] = $getordinfo->row()->shipmentid;

                if($bsn_asn->num_rows()>0){

                    $post['shipmentasn'] = $bsn_asn->row()->shipid;

                    $post['vendorcode'] = $bsn_asn->row()->vendorcode;

                    $post['logdate'] = $bsn_asn->row()->logdate;

                }

                $output = $this->outboundTrailerxml($post);

            }

            return true;

        } else {

            return false;

        }

    }

    /**

     * out bound Trailer

     *

     * @param  mixed $post

     * @return void

     */

    public function outboundTrailerxml($post) {

        $request = '';

        $request .= '<?xml version="1.0" encoding="UTF-8"?>';

        $request .= '<AdvanceShipmentNotice>';

        $request .= '<ShipmentInformation>';

        $request .= '<ShipperASNID>'.$post['shipmentasn'].'</ShipperASNID>';

        $request .= '<ShipmentExternalId>'.$post['shipmentid'].'</ShipmentExternalId>';

        $request .= '<ShipmentType>'.$post['transport_mode'].'</ShipmentType>';

        $request .= '<ASNStatusType>00</ASNStatusType>';

        $request .= '<CarrierSCAC>'.$post['carrier_scac'].'</CarrierSCAC>';

        $request .= '<CarrierShipmentReferenceNumber>'.$post['carriership_ref'].'</CarrierShipmentReferenceNumber>';

        $request .= '<BillOfLadingNumber>'.$post['billOfLanding'].'</BillOfLadingNumber>';

        $request .= '<AmazonReferenceNumber>XML</AmazonReferenceNumber>';

        $request .= '<VendorCode>'.$post['vendorcode'].'</VendorCode>';

        $request .= '<CartonCount>'.$post['CartonCount'].'</CartonCount>';

        $request .= '<Weight>'.$post['weight'].'</Weight>';

        $request .= '<WeightUnitOfMeasure>'.$post['weightuom'].'</WeightUnitOfMeasure>';

        $request .= '<Volume>'.$post['volume'].'</Volume>';

        $request .= '<VolumeUnitOfMeasure>'.$post['volumeuom'].'</VolumeUnitOfMeasure>'; // TBD

        $request .= '<ASNSentDateTime>'.date('YmdHi',strtotime($post['logdate'])).'</ASNSentDateTime>';

        $request .= '<ShippedDate>'.date('YmdHi',strtotime($post['shipmentdate'])).'</ShippedDate>'; // TBD

        $request .= '<DestinationFC>'.$post['destinatefc'].'</DestinationFC>';

        $request .= '<FreightTerms>CC</FreightTerms>';

        $request .= '<Route>';

        $request .= '<Stop>';

        $request .= '<Function>'.$post['load'].'</Function>';

        $request .= '<LocationID>';

        $request .= '<LocationIDType>'.$post['load_locationidtype'].'</LocationIDType>';

        $request .= '<LocationCode>'.$post['load_locationcode'].'</LocationCode>';

        $request .= '<CountryCode>'.$post['load_countrycode'].'</CountryCode>';

        $request .= '</LocationID>';

        $request .= '</Stop>';

        $request .= '<Stop>';

        $request .= '<Function>'.$post['discharge'].'</Function>';

        $request .= '<LocationID>';

        $request .= '<LocationIDType>'.$post['discharge_locationidtype'].'</LocationIDType>';

        $request .= '<LocationCode>'.$post['discharge_locationcode'].'</LocationCode>';

        $request .= '<CountryCode>'.$post['discharge_countrycode'].'</CountryCode>';

        $request .= '</LocationID>';

        $request .= '</Stop>';

        $request .= '<DepartureFeederVessel>NULL</DepartureFeederVessel>';

        $request .= '</Route>';

        $request .= '<TransportationMode>'.$post['transportationMode'].'</TransportationMode>';

        $request .= '<SealNumber>'.$post['sealNumber'].'</SealNumber>';

        $request .= '<TransportMode>'.$post['modeoftransport'].'</TransportMode>';

        $request .= '<DeliveryServiceLevel>'.$post['deliveryServiceLevel'].'</DeliveryServiceLevel>';

        $request .= '</ShipmentInformation>';

        if(count($post['cargosInfo'])>0){

            $i=1;

            foreach($post['cargosInfo'] as $container){

                $request .= '<Container>';

                $request .= '<ContainerType>'.$container['cargo_type'].'</ContainerType>';

                $request .= '<ExternalID>';

                $request .= '<ID>'.$container['qr_code'].'</ID>';

                $request .= '<IDType>'.$container['id_type'].'</IDType>';

                $request .= '</ExternalID>';

                $request .= '<ExternalID>';

                $request .= '<IDType>'.$container['ext_id_type'].'</IDType>';

                $request .= '</ExternalID>';

                $request .= '<Item>';

                $request .= '<ExternalID>';

                $request .= '<ID>'.$container['buyer_part'].'</ID>';

                $request .= '<IDType>'.$container['buyer_part_code'].'</IDType>';

                $request .= '</ExternalID>';

                $request .= '<VBRExternalId>'.$container['externel_id'].'</VBRExternalId>';

                $request .= '<AsinDetailExternalId>'.$container['externel_id'].'</AsinDetailExternalId>';

                $request .= '<OceanContainerId>'.$container['linecontainer_no'].'</OceanContainerId>';

                $request .= '<InventoryOwnerGroup></InventoryOwnerGroup>';

                $request .= '<CartonCount>'.$i.'</CartonCount>';

                $request .= '<Quantity>'.$container['quantity'].'</Quantity>';

                $request .= '<PurchaseOrderNumber>'.$post['ponumber'].'</PurchaseOrderNumber>';

                $request .= '<WeightQualifier>'.$container['weight_qualifier'].'</WeightQualifier>';

                $request .= '<Weight>'.$container['weight'].'</Weight>';

                $request .= '<WeightUnitOfMeasure>'.$container['weight_unit'].'</WeightUnitOfMeasure>';

                $request .= '<Volume>'.$container['volume'].'</Volume>';

                $request .= '<VolumeUnitOfMeasure>'.$container['volume_unit'].'</VolumeUnitOfMeasure>';

                $request .= '</Item>';

                $request .= '</Container>';

                $i++;

            }

        }

        $request .= '</AdvanceShipmentNotice>';

        log_message('error', "amazon-outboundxml " . $request);

        $filename = "KHNU_ASN_".date('YmdHis')."_".$post['carriership_ref']."_".$post['id'].".xml";

        $localfile = "./assets/amazonedis/".$filename;

        if (!file_exists(dirname($localfile))) {

          mkdir(dirname($localfile), 0700, true);

        }

        file_put_contents($localfile, $request);

        $folder_name = "/pub/inbound";

        $sftp_url = UKAMZ_URL;

        $username = UKAMZ_USRNAME;

        $password = UKAMZ_PWD;
        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                /*throw new \Exception('Cannot login into your server !');*/
                log_message("error","Cannot login into your UK MTF test server !");
            }else{
                $sftp->chdir($folder_name);
                $sftp->put($folder_name."/".$filename,$localfile,SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error","Some Problem occured!, Please Try Again Later.");
        }
    }

}
