<?php

class AuUrlAuthentication
{
    private const AU_MANUAL_MILESTONE_LOGGED_IN_SINCE = 'AU_MANUAL_MILESTONE_LOGGED_IN_SINCE';
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
    }

    public function isAllowedToAccess($postData): bool
    {
        if ($this->loginAPI()) {
            return true;
        }

        if ((!$postData['username'] || !$postData['password'])) {
            return false;
        }
        $username = strtolower(trim($postData['username']));

        if (!array_key_exists($username, static::USER_PASSWORDS)) {
            return false;
        }

        if (!password_verify($postData['password'], static::USER_PASSWORDS[$username])) {
            return false;
        }

        $this->isLoggedInAPI();

        return true;
    }

    private function loginAPI()
    {
        $this->ci->session->{self::AU_MANUAL_MILESTONE_LOGGED_IN_SINCE} = new DateTime();
    }

    /**
     * @return bool
     */
    private function isLoggedInAPI(): bool
    {
        return $this->ci->session->{self::AU_MANUAL_MILESTONE_LOGGED_IN_SINCE} > new DateTime('-15 minutes');
    }

    private const USER_PASSWORDS = [
        'haramohan.mahalik' => '$2y$10$zj8hopMhmV/5h5Ea2h1o7uBvTMLnlXRzEHQOSnM.jP4apg84cpU8O',
        'gopi.krishna' => '$2y$10$jRdISqPGFYf8HudyT1niXOxN7BNJ.F7vM2d4M6zDT23QJN9p3Nolm',

    ];


}
