<?php
require ('barcode/vendor/autoload.php');
class Barcode {
	function generate($text)
	{
		$barcode = new \Com\Tecnick\Barcode\Barcode();
	    $targetPath = "assets/qr-code";
	    
	    if (!is_dir($targetPath)) {
	        mkdir($targetPath, 0710, true);
	    }
	    $bobj = $barcode->getBarcodeObj('QRCODE,H', $text, - 16, - 16, 'black', array( - 2, - 2, - 2, - 2))->setBackgroundColor('#FFF');
	    
		$imageData = $bobj->getPngData();
		//$timestamp = time();
		$milliseconds = round(microtime(true) * 1000);
		$qr_path = $targetPath.'/'.$milliseconds . '.png';
		file_put_contents($qr_path, $imageData);
		return $qr_path;
	}
}
?>