<?php defined('BASEPATH') OR exit('No direct script access allowed');
use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

class Billingjplfile
{
    public function __Construct(){
        $ci =& get_instance();
        $ci->load->model('common');
    }


    public function saveJPLFile($billid,$pdfFilePath){
        $ci =& get_instance();
        $bill_group = $branch_officeno = $invoice_no = $bill_party = $debtor_code = $booking_id = $customer_id = $company_code = $branch_code = $bill_group_type = $country_code = "";
        $order_id = $user_id = 0;
        if(($billid)>0){
            $getbilling_details = $ci->common->gettblrowdata(array("id"=>$billid),"bill_party,bill_group,invoice_no,acon_code","tbl_bills",0,0);
            if(!empty($getbilling_details)){
                $invoice_no  = $getbilling_details['invoice_no'];
                $bill_group  = $getbilling_details['bill_group'];
                $bill_party  = $getbilling_details['bill_party'];
                if(strlen($bill_party) > 35){
                    $bill_party = "";
                }
                $debtor_code = $getbilling_details['acon_code'];
                $getbillgroup_details = $ci->common->gettblrowdata(array('id'=>$bill_group,'status'=>'1'),"name","tb_billgroup_master",0,0);
                if(!empty($getbillgroup_details)){
                    $bill_group = strtoupper($getbillgroup_details['name']);
                }
                if($bill_group == "BILL" || $bill_group == "CREDIT NOTE"){
                    $bill_group_type = "I";
                    if($bill_group == "BILL"){
                        $bill_group_type = "I";
                    }else{
                        $bill_group_type = "C";
                    }
                    $getrev_details = $ci->common->gettblrowdata(array("bill_id"=>$billid,'status'=>'1'),"order_id,recipient_code","tb_reveneus",0,0);
                    if(!empty($getrev_details)){
                        $order_id = $getrev_details['order_id'];
                        if($order_id >0){
                            $getorder_details = $ci->common->gettblrowdata(array("id"=>$order_id,'status >'=>'0'),"order_id,user_id,customer_id,company_code,branch_code","tb_orders",0,0);
                            if(!empty($getorder_details)){
                                $booking_id = $getorder_details['order_id'];
                                $customer_id = $getorder_details['customer_id'];
                                $company_code = $getorder_details['company_code'];
                                $branch_code = $getorder_details['branch_code'];
                                $user_id = $getorder_details['user_id'];
                                if($user_id >0){
                                    $getuser_details = $ci->common->gettblrowdata(array("id"=>$user_id),"country_code","tb_users",0,0);
                                    if(!empty($getuser_details)){
                                        $country_code = $getuser_details['country_code'];
                                    }
                                }
                                if($company_code == ""){
                                    $company_code = $ci->session->userdata('company_code');
                                }
                                if($branch_code == ""){
                                    $branch_code = $ci->session->userdata('branch_code');
                                }
                                $getbranch_details = $ci->common->gettblrowdata(array("branch_code"=>$branch_code,"company_code"=>$company_code,'status'=>'1'),"branch_officeno","tb_branch_master",0,0);
                                if(!empty($getbranch_details)){
                                    $branch_officeno = $getbranch_details['branch_officeno'];
                                }
                            }
                        }
                    }
                    $createdon = date('Y-m-d H:i:s');
                 /*    $curtz = $ci->session->userdata("usr_tzone")['timezone'];
                    $getcreatedon = getdatetimebytimezone($curtz,$createdon,DFLT_TZ); */
                    $current_date1 = date('Y-m-d',strtotime($createdon));
                    $current_date2 = date('d.m.Y',strtotime($createdon));
                  /*   $current_time = $getcreatedon['time']; */
                    $current_time = date('H:i:s',strtotime($createdon));
                   /*  echo date('Y-m-d h:i,A',strtotime($getcreatedon['datetime']))."<br>"; */
                    $pagecount = 0;
                    if($pdfFilePath != ""){
                        $pagecount = $this->getNumPagesPdf($pdfFilePath);
                    }
                    $jplData = array('invoice_no'=>$invoice_no,'branch_officeno'=>$branch_officeno,'bill_group_type'=>$bill_group_type,'bill_party'=>$bill_party,'debtor_code'=>$debtor_code,'country_code'=>$country_code,'pages_count'=>$pagecount,'current_time'=>$current_time,'current_date1'=>$current_date1,'current_date2'=>$current_date2);
                    if(!empty($jplData)){
                        $content = $this->generatejplfile_forinvoice($jplData);
                        if($content != ""){
                            $jplFilePath = "./assets/jpl_files/".$jplData["invoice_no"].".jpl";
                            $fp = fopen($jplFilePath,"wb");
                            fwrite($fp,$content);
                            fclose($fp);
                            $storeftipjpl  = $this->uploadBillingKNFile($jplFilePath);
                            $storeftpippdf = $this->uploadBillingKNFile($pdfFilePath);

                        }
                    }
                }
            }
        }
    }

    public function generatejplfile_forinvoice($jplData){

        $jpl ='';
        if(!empty($jplData)){
           /*  $jpl .= '#arcid = "AC"'."\n";
            $jpl .= 'dokuart = "OINV"'."\n"; */
            $jpl .= '#arcid = "P  "'."\n";
            $jpl .= 'dokuart = "KNEFI"'."\n";
            $jpl .= 'text[1] = "'.@$jplData['invoice_no'].'"'."\n";
            $jpl .= 'dok_dat_feld[4]="'.@$jplData['current_time'].'"'."\n";
            $jpl .= 'dok_dat_feld[6]="'.@$jplData['invoice_no'].'"'."\n";
            $jpl .= 'dok_dat_feld[8]="'.@$jplData['branch_officeno'].'"'."\n";
            $jpl .= 'dok_dat_feld[9]="000"'."\n";
            $jpl .= 'dok_dat_feld[14]="'.@$jplData['bill_group_type'].'"'."\n";
            $jpl .= 'dok_dat_feld[35]="'.@$jplData['debtor_code'].'"'."\n";
            $jpl .= 'dok_dat_feld[42]="'.@$jplData['country_code'].'"'."\n";
            $jpl .= 'dok_dat_feld[44]="'.@$jplData['bill_party'].'"'."\n";
            $jpl .= 'dok_dat_feld[50]="'.@$jplData['current_date1'].'"'."\n";
            $jpl .= 'dok_dat_feld[51]="'.@$jplData['current_date2'].'"'."\n";
            $jpl .= 'dok_dat_feld[81]="'.$jplData['pages_count'].'"'."\n";
            $jpl .= 'dok_dat_feld[82]="0000"'."\n";
        }
        return $jpl;
    }

    public function getNumPagesPdf($filepath) {
        $fp = @fopen(preg_replace("/\[(.*?)\]/i", "", $filepath), "r");
        $max = 0;
        if (!$fp) {
            return "Could not open file: $filepath";
        } else {
            while (!@feof($fp)) {
                $line = @fgets($fp, 255);
                if (preg_match('/\/Count [0-9]+/', $line, $matches)) {
                    preg_match('/[0-9]+/', $matches[0], $matches2);
                    if ($max < $matches2[0]) {
                        $max = trim($matches2[0]);
                        break;
                    }
                }
            }
            @fclose($fp);
        }
        return $max;
    }

      public function uploadBillingKNFile($localfile){
        $remotefile = basename($localfile);
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        $folder_name = "/pub/inbound/D3/IF";
       /* $folder_name = "/pub/outbound/acon";   for testing purpose in uat*/

        try{
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                unset($sftp);
                /*throw new \Exception('Cannot login into your server !');*/
                log_message("error","Cannot login into your server While sending invoice to ACON !");
            }else{
                $sftp->chdir($folder_name);
                $sftp->put($folder_name."/".$remotefile,$localfile,SFTP::SOURCE_LOCAL_FILE);
                log_message("error","uploadedjpl-acon, path: ".$folder_name."/".$remotefile,$localfile);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error","Some Problem occured!, while sending jpl to acon, Please Try Again Later.");
        }
    }



    public function filegeneration($id,$pages_count,$invtype){
        $ci =& get_instance();
    	$data = array();
    	$invoice_no = $branch_number = $acon_code = $debitor_name = $type = "";
    	$current_time = date('H:i:s');
    	$current_date = date('Y-m-d');
    	$date_format = date('d.m.Y');
        if($invtype == "credit"){
            $type = "C";
        }
        if($invtype == "invoice"){
            $type= "I";
        }
    	$branch_code = $ci->session->userdata('branch_code');
    	$getbranch_number = $ci->common->gettblrowdata(array('branch_code'=>$branch_code,'status'=>'1'),"branch_officeno","tb_branch_master",0,0);
    	if(!empty($getbranch_number)){
    		$branch_number = $getbranch_number['branch_officeno'];
    	}
    	if($id >0){
    		$getbilling_details = $ci->common->gettblrowdata(array('id'=>$id),'invoice_no,acon_code','tbl_bills',0,0);
    		if(!empty($getbilling_details)){
    			$invoice_no = $getbilling_details['invoice_no'];
    			$acon_code = $getbilling_details['acon_code'];
    		}
    	}
    	if($acon_code == 0){
    		$acon_code = "";
    	}
    	if($acon_code != ""){
    		$getacon_debitorname = $ci->common->gettblrowdata(array('acon_debitor_code'=>$acon_code,'status'=>'1'),"name","tbl_party_master",0,0);
    		if(!empty($getacon_debitorname)){
    			$debitor_name  = $getacon_debitorname['name'];
    			if(strlen($debitor_name) > 35){
    				$debitor_name = "";
    			}
    		}
    	}
        if($invoice_no != ""){
            $data['country_code']  = $ci->session->userdata("usr_tzone")['country'];
            $data['branch_number'] = $branch_number;
            $data['debitor_name']  = $debitor_name;
            $data['debitor_code']  = $acon_code;
            $data['invoice_no']    = $invoice_no;
            $data['current_time']  = $current_time;
            $data['current_date']  = $current_date;
            $data['branch_number'] = $branch_number;
            $data['date_format']   = $date_format;
            $data['pages_count']   = $pages_count;
            $data['type']          = $type;
            $content = $ci->load->view('billing/jpl_template',$data,TRUE);
            $file_path = "./assets/billing/".$invoice_no.".jpl";
            $fp = fopen($file_path,"wb");
            fwrite($fp,$content);
            fclose($fp);
            $this->uploadKNFile($file_path);
        }
    }
    public function uploadKNFile($localfile){
    $remotefile = basename($localfile);
    $base_url = base_url();
    /*log_message("error","$remotefile file uploaded to KN FTP");*/
    $ftp = @ftp_connect(NZ_URL) or die("Could not connect");
    if(false === $ftp){
    }else{
        $loggedIn = "";
        if($base_url == "https://elog360.app/svkonekt_test/" || $base_url == "https://elog360.app/svkonekt_test/"){
            $loggedIn = @ftp_login($ftp,NZ_USERNAME,NZ_PASSWORD) or die("invalid username or password");
        }else{
            $loggedIn = @ftp_login($ftp,NZ_USERNAME2,NZ_PASSWORD2) or die("invalid username or password");
        }
        if(true === $loggedIn){
            ftp_pasv($ftp, true) or die("Passive mode failed");
            $server_files = ftp_nlist($ftp, "./pub/acon_inbound");
            if(!empty($server_files)){
                if(in_array("pub/acon_inbound/".$remotefile, $server_files)){
                    $delete = @ftp_delete($ftp, $remotefile);
                }
            }
            $ret = @ftp_nb_put($ftp, "./pub/acon_inbound/$remotefile", $localfile, FTP_BINARY, FTP_AUTORESUME);
            while (FTP_MOREDATA == $ret)
            {
                $ret = ftp_nb_continue($ftp);
            }
            ftp_close($ftp);
        }
    }

}
}
?>
