<?php

use phpseclib\Net\SFTP;

require_once APPPATH . '/libraries/RussianIntegrationService.php';

class BiteTransitService extends RussianIntegrationService
{
    public const STATUS_LIST = ["ST1", "ST2", "ST3", "ST4"];
    public const STATUS_LIST_WITH_CODES = ["ST1" => "0500", "ST2" => "1300", "ST3" => "1000", "ST4" => "3000"];
    public const AVAILABLE_STATUS_CODES = ['Accept', '0420', 'Pickup', '0191', '1550', '0192', 'Delivery', '2300', 'Close'];

    protected const STOP_STATUS_MAPPING = [
        'ST1' => [self::PICKUP_GATE_IN, self::PICKUP],
        'ST2' => [self::PICKUP_GATE_OUT, self::IN_TRANSIT],
        'ST3' => [self::DELIVERY_GATE_IN],
        'ST4' => [self::DELIVERY_GATE_OUT, self::DELIVERY]
    ];

    //put your code here
    public function __construct()
    {
        parent::__construct();

        $this->logPrefix = 'BITE TRANSIT';

        $this->ci->load->library("edi/EdiEngine");
        $this->ci->load->library("edi/EdiStatusProcess");
        $this->ci->load->library("Edi_logger");
        $this->ci->load->model('common');
        $this->ci->load->model('Order');
    }

    public function shipmentdata($shift_id)
    {
        if ($shift_id != "") {
            $getorderids = $this->ci->ediengine->getOrderIds($shift_id);
            $orders_size = count($getorderids);
            if ($orders_size == 0) {
                echo "No orders found.";
                exit();
            }
            if ((!empty($getorderids)) && $orders_size > 1) {
                for ($i = 0; $i < $orders_size; $i++) {
                    $order_id = $getorderids[$i]['id'];
                    if ($this->ci->ediengine->check_reference_exit_or_not($order_id, "RUCK") == 1) {
                        //                        log_message("error", "***************Transport Order Double submission condition is applied  @BITE TRANSIT***************" . $order_id);
                        $this->ci->edi_logger->log_bite_transit_transport_order('0', json_encode([], JSON_UNESCAPED_UNICODE), json_encode(["status" => "0", "message" => "RUCK Reference is already created."], JSON_UNESCAPED_UNICODE), $getorderids[$i]['order_id']);
                    } else {
                        $api_messages[] = $this->getOrderInfo($order_id);
                    }
                }
                echo json_encode(["status" => 1, "message" => "API triggered successfully."]);
                return;
            } else {
                $order_id = $getorderids[0]['id'];
                if ($this->ci->ediengine->check_reference_exit_or_not($order_id, "RUCK") == 1) {
                    //                    log_message("error", "***************Transport Order Double submission condition is applied @BITE TRANSIT***************" . $order_id);
                    $this->ci->edi_logger->log_bite_transit_transport_order('0', json_encode([], JSON_UNESCAPED_UNICODE), json_encode(["status" => "0", "message" => "RUCK Reference is already created."], JSON_UNESCAPED_UNICODE), $getorderids[0]['order_id']);
                } else {
                    return $this->getOrderInfo($order_id);
                }
                // return $this->getOrderInfo($order_id);
            }
        }
    }

    public function getOrderInfo($order_id)
    {
        $order_routing_details = $this->ci->ediengine->getOrderRoutingDetails($order_id);
        $getcargos = $this->ci->ediengine->getCargoDetailsSum($order_id);
        $pickup_details = $this->ci->ediengine->getOrderParites('Shipper', $order_id);
        $drop_details = $this->ci->ediengine->getOrderParites('Consignee', $order_id);
        $customer_details = $this->ci->ediengine->getOrderRelatedCustomer($order_routing_details['customer_id'])[0];

        $order_details = [
            "routing_details" => $order_routing_details,
            "cargo_details" => $getcargos,
            "pickup_details" => $pickup_details,
            "drop_details" => $drop_details,
            "customer_details" => $customer_details
        ];
        $this->createrequestformat($order_details);
    }

    public function createrequestformat($data)
    {
        $curtz = $this->ci->session->userdata("usr_tzone")['timezone'];

        $routing_details = $data['routing_details'];
        $cargo_details = $data['cargo_details'];
        $pickup_details = $data['pickup_details'];
        $drop_details = $data['drop_details'];
        $customer_details = $data['customer_details'];
        if (!isset($pickup_details['vat_reg_no'])) {
            $pickup_details['vat_reg_no'] = "";
        }
        if (!isset($pickup_details['tax_payer_no'])) {
            $pickup_details['tax_payer_no'] = "";
        }
        if (!isset($pickup_details['mobile'])) {
            $pickup_details['mobile'] = "";
        }
        if (!isset($drop_details['vat_reg_no'])) {
            $drop_details['vat_reg_no'] = "";
        }
        if (!isset($drop_details['vat_reg_no'])) {
            $drop_details['vat_reg_no'] = "";
        }
        if (!isset($drop_details['mobile'])) {
            $drop_details['mobile'] = "";
        }
        $order_row_id = $routing_details['id'];
        $order_z05_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'Z05', '0');
        $order_z04_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'Z04', '0');
        $order_z11_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'Z11', '0');
        $order_z12_reference = $this->ci->ediengine->getOrderReferences($order_row_id, 'Z12', '0');

        $pickup_ins = $this->ci->ediengine->getOrderReferences($order_row_id, 'ORD_PIKINST', '0');
        $delivery_ins = $this->ci->ediengine->getOrderReferences($order_row_id, 'ORD_DLVINST', '0');

        $createdon = getdatetimebytimezone($curtz, $routing_details['createdon'], DFLT_TZ);
        $pickup_datetime = getdatetimebytimezone($curtz, $routing_details['pickup_datetime'], DFLT_TZ);
        $pickup_endtime = getdatetimebytimezone($curtz, $routing_details['pickup_endtime'], DFLT_TZ);
        $delivery_datetime = getdatetimebytimezone($curtz, $routing_details['delivery_datetime'], DFLT_TZ);
        $drop_endtime = getdatetimebytimezone($curtz, $routing_details['drop_endtime'], DFLT_TZ);

        $curtz = $this->ci->session->userdata("usr_tzone")['timezone'];

        /*
         *  Get Cid based data from get_fixed_customer_info($cid, $looks_for) func
         */
        $agents_info = $this->get_fixed_customer_info($customer_details['code'], 'all');
        /*
         *  Get GUID based on shipper code
         */
        $agents_info_shipper = $this->get_party_codes($pickup_details['code']);
        /*
         *  Get GUID based on consignee code
         */
        $agents_info_consignee = $this->get_party_codes($drop_details['code']);

        $createdon = getdatetimebytimezone($curtz, date('Y-m-d'), DFLT_TZ);
        $DateOrder = date('d.m.Y', strtotime(getdatetimebytimezone($curtz, date('Y-m-d'), DFLT_TZ)['date']));
        $request_format = [
            "CodeWord" => "HFUEnfueGFoefn7834HIFe7438HUIFeo643JFIEfgh", // fixed
            "ID_Users" => "1", // fixed
            "DateOrder" => $DateOrder, //
            "ID_OfficeOut" => $this->ci->ediengine->getOfficeId($routing_details['pickup_city']), // based on condition
            "Name_OfficeOut" => $routing_details['pickup_city'], // shipper city
            "ID_OfficeIn" => $this->ci->ediengine->getOfficeId($routing_details['delivery_city']), // reconfirm
            "Name_OfficeIn" => $routing_details['delivery_city'], // consignee city name.
            "DateDeliveryCust" => "", // fixed
            "Hour1DeliveryCust" => "", // fixed
            "Hour2DeliveryCust" => "", // fixed
            "ID_SC" => 1, // fixed
            "NameSC" => "стандарт", // fixed
            "KNFinanceOrderID" => $this->ci->ediengine->getOrderReferences($order_row_id, 'DQ', '0'), // ORDER DQ Ref value
            "KNTrackingOrderID" => $routing_details['order_id'], // order id here.
            "CostCargo" => $routing_details['goods_value'],
            "Agents" => [
                [
                    "AgentOnOrder" => "1", // Fix "1"
                    "TypeAgent" => "0", // Fix "0"
                    "Name" => "Общество с ограниченной ответственностью \"Кюне+Нагель\"", // Fix "Общество с ограниченной ответственностью "Кюне+Нагель""
                    "INN" => "7710431565", // Fix "7710431565"
                    "KPP" => "771001001", // Fix "771001001"
                    "GUID" => "f5eb4681-aa6e-11e7-84d9-0cc47aa9af59", //  Fix 'f5eb4681-aa6e-11e7-84d9-0cc47aa9af59'
                    "Contact" => "", // fix blank
                    "Phone" => "+74957952000", //   Fix +7 495 7952000
                    "TypeDoc" => "", // fix blank
                    "NDoc" => "7710431565", // fixed :VAT Registration ID number
                    "SDoc" => "771001001" // fixed :Tax Payer ID number
                ],
                [
                    "AgentOnOrder" => "2", //fixed 2
                    "TypeAgent" => "0", //fixed 0
                    "Name" => $routing_details['pickup'], // Shipper Company Name
                    "INN" => $this->ci->ediengine->bite_transit_vat_reg_no_process($pickup_details['vat_reg_no'], $order_row_id, 'Z10'), // VAT Registration ID number
                    "KPP" => $pickup_details['tax_payer_no'], // Tax Payer ID number
                    "GUID" => $agents_info_shipper['guid'], // Guid fetch based on shipper ids
                    "Contact" => "", // fix blank
                    "Phone" => $this->ci->ediengine->bite_transit_expedition_phone_number_process($pickup_details['mobile'], $order_z05_reference), // Map Consignee Phone number and Reference Z05 value; Comma separated
                    "TypeDoc" => "", // Fix blank
                    "NDoc" => $this->ci->ediengine->bite_transit_vat_reg_no_process($pickup_details['vat_reg_no'], $order_row_id, 'Z10'), // VAT Registration ID number
                    "SDoc" => $pickup_details['tax_payer_no'] // Tax Payer ID number
                ],
                [
                    "AgentOnOrder" => "3", // fix 3
                    "TypeAgent" => "0", // Fix "0"
                    "Name" => $routing_details['delivery'], // Consignee Company Name (OR) Consignee name
                    "INN" => $this->ci->ediengine->bite_transit_vat_reg_no_process($drop_details['vat_reg_no'], $order_row_id, 'Z10'), // VAT Registration ID number
                    "KPP" => (is_null($drop_details['tax_payer_no'])) ? '' : $drop_details['tax_payer_no'], // Tax Payer ID number
                    "GUID" => $agents_info_consignee['guid'], // check in agent info array
                    "Contact" => "", // fix blank
                    "Phone" => $this->ci->ediengine->bite_transit_expedition_phone_number_process($drop_details['mobile'], $order_z05_reference), // Map Consignee Phone number and Reference Z05 value; Comma separated
                    "TypeDoc" => "", // Fix blank
                    "NDoc" => $this->ci->ediengine->bite_transit_vat_reg_no_process($drop_details['vat_reg_no'], $order_row_id, 'Z10'), // VAT Registration ID number
                    "SDoc" => (is_null($drop_details['tax_payer_no'])) ? '' : $drop_details['tax_payer_no'] // Tax Payer ID number
                ],
                [
                    "AgentOnOrder" => "4", // fix 4
                    "TypeAgent" => "0", // fix "0"
                    "Name" => "Общество с ограниченной ответственностью \"Кюне+Нагель\"", // Fix "Общество с ограниченной ответственностью "Кюне+Нагель""
                    "INN" => "7710431565", // Fix "7710431565"
                    "KPP" => "771001001", // Fix "771001001"
                    "GUID" => "f5eb4681-aa6e-11e7-84d9-0cc47aa9af59", // Fix 'f5eb4681-aa6e-11e7-84d9-0cc47aa9af59'
                    "Contact" => "", // Fix blank
                    "Phone" => "74957952000", // FIXED
                    "TypeDoc" => "", // Fix blank
                    "NDoc" => "7710431565", // FIX
                    "SDoc" => "771001001" // FIX
                ]
            ],
            "RequiresPhone" => 0, //Fix "0"
            //            "Note" => $this->ci->ediengine->bite_transit_pickup_and_drop_instruction_process(trim($pickup_ins), trim($delivery_ins)), // Map Driver Pickup Instructions + Driver Delivery Instructions
            "Note" => $this->bite_transit_order_notes_generation($pickup_ins, $delivery_ins, $order_z04_reference, $order_z11_reference, $order_z12_reference), // Map Driver Pickup Instructions + Driver Delivery Instructions
            "TypeOrder" => "1", //Fix "1"
            "Cargo" => [
                [
                    "ID_Character" => $agents_info['id_character'], // check in agent info array
                    "BOX" => [
                        [
                            "ID" => 1,
                            "Val" => $cargo_details['weight']
                        ],
                        [
                            "ID" => 2,
                            "Val" => $cargo_details['volume']
                        ],
                        [
                            "ID" => 4,
                            "Val" => $cargo_details['quantity'] // Total Order Place Count i.e sum of quantity.
                        ]
                    ]
                ]
            ], // end of reconfirm.
            "MarkUp" => [],
            "Service" => [],
            "Expedition" => [
                [
                    "ID_Office" => $this->ci->ediengine->getOfficeId($routing_details['pickup_city']),
                    "Direction" => "0", //Fix "0"
                    "Address" => $routing_details['pickup_address1'] . ',' . $routing_details['pickup_city'] . ',' . $routing_details['pickup_address2'], // Shipper:Street 1,
                    //Street 2, Street 3, House Number, Building, City Name,
                    //Province If blank do not populate; Comma separated
                    "Contact" => "", // Fix blank
                    "Phone" => $pickup_details['mobile'], // Map Shipper Phone number and Reference Z05 value; Comma separated
                    "Date" => date('d.m.Y', strtotime(getdatetimebytimezone($curtz, $pickup_datetime['date'], DFLT_TZ)['date'])), // Pick-up date, format dd.mm.yyyy
                    "Hour1" => (int)substr($pickup_datetime['time'], 0, 2), // Pick-up early time, format 1 digit hour from 0 to 23, for example 09:00 is 9, 16:00 is 16
                    "Hour2" => (int)substr($pickup_endtime['time'], 0, 2) // Pick-up late time, format 1 digit hour from 0 to 23, for example 09:00 is 9, 16:00 is 16
                ],
                [
                    "ID_Office" => $this->ci->ediengine->getOfficeId($routing_details['delivery_city']),
                    "Direction" => 1,
                    "Address" => $routing_details['delivery_address1'] . ',' . $routing_details['delivery_city'] . ',' . $routing_details['delivery_address2'],
                    "Contact" => "", // Fix blank
                    "Phone" => $this->ci->ediengine->bite_transit_expedition_phone_number_process($drop_details['mobile'], $order_z05_reference),
                    "Date" => date('d.m.Y', strtotime(getdatetimebytimezone($curtz, $delivery_datetime['date'], DFLT_TZ)['date'])), // Delivery date, format dd.mm.yyyy
                    "Hour1" => (int)substr($delivery_datetime['time'], 0, 2), // Delivery early time, format 1 digit hour from 0 to 23, for example 09:00 is 9, 16:00 is 16
                    "Hour2" => (int)substr($drop_endtime['time'], 0, 2) // Delivery late time, format 1 digit hour from 0 to 23, for example 09:00 is 9, 16:00 is 16
                ]
            ]
        ];
        return $this->bitetransitapicall($request_format, $order_row_id, $routing_details['order_id']);
    }

    public function bitetransitapicall($request_format, $order_row_id, $order_id)
    {
        /*
         *  Bite Transit api curl call.
         */
        $status = 0;
        try {
            // default values for $response and err
            $response = 'empty response received';
            $err = 'error response received';
            $bitetransit_response = bitetransit_transport_order_curl($request_format);
            $response = $bitetransit_response['response'];
            $err = $bitetransit_response['err'];
            /*
              log_message("error", $order_id . "-Response :" . json_encode($response, JSON_UNESCAPED_UNICODE));
             */
            if ($err != 'error response received' && $err != "") {
                // echo "cURL Error #:" . $err;
                $response = $err;
                return json_encode(["status" => 0, "message" => "cURL Error #:" . $err]);
            } else {
                if ($response != "empty response received" && $response != "") {
                    $response = json_decode($response);
                    if (isset($response->result) && $response->result != '') {
                        $result = $response->result;
                        $message = $result[0]->result;
                        if ($message == "1") {
                            // insert reference id.
                            $order_reference_insert = [
                                "order_id" => $order_row_id,
                                "reference_id" => "RUCK",
                                "ref_value" => "1",
                                "createdon" => getdatetimebytimezone(DFLT_TZ, date('Y-m-d H:i:s'), '')['datetime']
                            ];
                            if ($this->ci->common->insertTableData('tb_order_references', $order_reference_insert) > 0) {
                                $status = 1;
                                return json_encode(["status" => 1, "message" => "API triggered successfully."]);
                            } else {
                                return json_encode(["status" => 0, "message" => "API triggered successfully."]);
                            }
                        } else {
                            return json_encode(["status" => 0, "message" => $message]);
                        }
                    } else {
                        $response = ["status" => 0, "message" => "empty response received"];
                        return json_encode($response);
                    }
                } else {
                    $response = ["status" => 0, "message" => "empty response received"];
                    return json_encode($response);
                }
            }
        } catch (Exception $exc) {
            $response = "Catch Block:" . $exc->getTraceAsString();
        } finally {
            $this->ci->edi_logger->log_bite_transit_transport_order($status, json_encode($request_format, JSON_UNESCAPED_UNICODE), json_encode($response, JSON_UNESCAPED_UNICODE), $order_id);
        }
    }

    /**
     * @throws Exception
     */
    private function initSFtpClient(): SFTP
    {
        $client = new SFTP(BITE_TRANSIT_SERVER_IP);

        if (!$client->login(BITE_TRANSIT_USERNAME, BITE_TRANSIT_PWD)) {
            unset($client);
            // TODO: Throw custom execption
            throw new Exception('BITE TRANSIT - Unable to login to SFTP');
        }

        return $client;
    }

    public function process(): void
    {
        try {
            $client = $this->initSFtpClient();
        } catch (Exception $exception) {
            log_error('BITE TRANSIT - SFTP Login failure');
            return;
        }

        $client->chdir(BITE_TRANSIT_OUTBOUND_PATH);
        foreach ($client->nlist() as $fileName) {
            $fileContent = $client->get(BITE_TRANSIT_OUTBOUND_PATH . '/' . $fileName);
            if (strtolower(pathinfo($fileName, PATHINFO_EXTENSION)) !== 'xml') {
                continue;
            }

            if (!$biteTransitResult = $this->retrieveXml($client->get(BITE_TRANSIT_OUTBOUND_PATH . '/' . $fileName))) {
                continue;
            }

            $errors = $this->validateXmlFields([
                'communicationReference' => $biteTransitResult['communicationReference'],
                'trackDate' => $biteTransitResult['trackDate'],
                'trackTime' => $biteTransitResult['trackTime'],
                'consignmentNumber' => $biteTransitResult['consignmentNumber']
            ]);
            if (!empty($errors) || !$this->validateStatus($biteTransitResult['toStatus'])) {
                $this->ci->edi_logger->log_bite_transit_transport_status(0, $fileContent, json_encode($errors), $biteTransitResult['communicationReference']);
                continue;
            }

            // Check if communicationReference starts with TMW.
            if (
                substr($biteTransitResult['communicationReference'], 0, 'TMW')
                || !$this->ci->Order->checkIfExistsByBookingId($biteTransitResult['communicationReference'])
                || !$this->saveOrderStatus($biteTransitResult)
            ) {
                continue;
            }

            $this->ci->edi_logger->log_bite_transit_transport_status(1, $fileContent, json_encode($biteTransitResult, JSON_UNESCAPED_UNICODE), $biteTransitResult['communicationReference']);
            try {
                $client->chdir(BITE_TRANSIT_OUTBOUND_PATH . '/Backup/'); // change to backup directory
                $client->put($fileName, $fileContent, SFTP::SOURCE_STRING); // move into backup directory
            } catch (Throwable $th) {
                log_error('BITE TRANSIT - Unable to upload file into backup folder.');
                continue;
            }

            $client->delete(BITE_TRANSIT_OUTBOUND_PATH . '/' . $fileName, false);
        }
        unset($client);
    }

    private function saveOrderStatus(array $xml): bool
    {
        // Convert booking id to order id.
        $orders = $this->ci->db
            ->select(['id', 'order_id', 'shift_id', 'trip_id'])
            ->from('tb_orders')
            ->where(['order_id' => $xml['communicationReference']])
            ->get()->result();

        if (count($orders) !== 1) {
            log_error('BITE TRANSIT - Could not map communication reference "' . $xml['communicationReference'] . '" to our booking id.');
            return false;
        }

        $order = $orders[0];

        // Update the reference value with the consignment number.
        $this->ci->common->updatetbledata(
            'tb_order_references',
            ["ref_value" => $xml['consignmentNumber']],
            ["reference_id" => "RUCK", "order_id" => $order->id]
        );

        // Retrieve stop ids.
        if (($employee = $this->findEmployeeByBookingId($order->order_id)) === null) {
            log_error('SKIF - No stops found for order "' . $order->id . '"');
            return false;
        }

        // Retrieve vehicle id and drive id.
        $vehicle = $this->findVehicleByShiftId($order->shift_id);
        $driver = $vehicle !== null ? $this->findTruckDriverByVehicleId($vehicle->vehicle_id) : null;

        // Create the status based on the mapping and the CargoState retrieved from SKIF.
        $stopStatusMappingsReset = array_values(self::STOP_STATUS_MAPPING);

        // Retrieve the index from the $stopStatusMappings array since it has predefined keys.
        $index = array_search($xml['toStatus'], array_keys(self::STOP_STATUS_MAPPING));

        if ($index === false) {
            log_error('BITE TRANSIT - Status (' . $xml['toStatus'] . ') was not found within our system.');
            return false;
        }

        // Data for the stop status that should be inserted in the database.
        $data = [
            "order_id" => $order->id,
            "shipment_id" => $order->shift_id,
            "stop_id" => $employee->drop_stopid,
            "stop_detail_id" => $employee->id,
            "trip_id" => $order->trip_id,
            "vehicle_id" => $vehicle->vehicle_id,
            "driver_id" => $driver->id,
            "createdon" => date('Y-m-d H:i:s'),
            'reason' => 'BITE TRANSIT STATUS'
        ];

        // Loop through every stop status until the current one.
        // If a stop status doesn't exist in the database for the current order. Then we create it.
        for ($i = 0; $i <= $index; $i++) {
            foreach ($stopStatusMappingsReset[$i] as $stopStatus) {
                $currentStopStatus = $this->getStopStatuses()[$stopStatus];
                $stopStatusForOrder = $this->ci->db
                    ->select('id, status_code')
                    ->from('tb_stop_status')
                    ->where([
                        'order_id' => $order->id,
                        'status_code' => $currentStopStatus['status_code']
                    ])
                    ->get()->result();

                if (empty($stopStatusForOrder)) {
                    if ($currentStopStatus['stop_type'] === 'P') {
                        [$lat, $long] = getlatlngsbyplace($xml['SenderAddress']['street']);
                        $data['loc_name'] = $xml['SenderAddress']['street'];
                    } else {
                        [$lat, $long] = getlatlngsbyplace($xml['deliveryAddress']['street']);
                        $data['loc_name'] = $xml['deliveryAddress']['street'];
                    }

                    $data['latitude'] = $lat;
                    $data['longitude'] = $long;

                    $this->ci->db->insert(
                        'tb_stop_status',
                        array_merge($currentStopStatus, $data)
                    );
                }
            }
        }

        // Close the order.
        if ($xml['toStatus'] === 'ST4') {
            $this->ci->db
                ->where('id', $order->id)
                ->update('tb_orders', ['trip_sts' => 1]);
        }

        return true;
    }

    /*
     *  As of now it is a fixed data so that i won't push this data into db
     */

    public function get_fixed_customer_info($cid, $looks_for)
    {
        /*
         *  Note : Both short_customer_details and full_customer_details must have same cid sequence
         */
        $short_customer_details = [
            '1002021379',
            '1002367383',
            '1001709915',
            '1000558694',
            '1002004216'
        ];

        $full_customer_details = [
            ['cid' => '1002021379', 'customer_name' => 'АББ ООО', 'guid' => '3fac0ee2-7fc0-11ea-8dc3-0cc47aa9af59', 'id_character' => '3842'],
            ['cid' => '1002367383', 'customer_name' => 'ДЕНСО РУС ООО', 'guid' => '0c3c3a02-2c35-11e8-a7ef-0cc47aa9af59', 'id_character' => '3749'],
            ['cid' => '1001709915', 'customer_name' => 'МАЛЕ РУС ООО', 'guid' => 'de284c97-2565-11e9-8db1-0cc47aa9af59', 'id_character' => '3749'],
            ['cid' => '1000558694', 'customer_name' => 'МЭЛОН ФЭШН ГРУП АО', 'guid' => 'b1725672-3342-11e8-a7ef-0cc47aa9af59', 'id_character' => '29'],
            ['cid' => '1002004216', 'customer_name' => 'ДЮРАСЕЛЛ РАША ООО', 'guid' => 'ce40b8be-57a0-11e9-8db7-0cc47aa9af59', 'id_character' => '21032']
        ];

        $array_key_index = array_keys($short_customer_details, $cid);
        if (isset($array_key_index[0])) {
            $index = $array_key_index[0];
            if ($looks_for == "all") {
                return $full_customer_details[$index];
            } else {
                return $full_customer_details[$index][$looks_for];
            }
        } else {
            return ['cid' => '', 'customer_name' => '', 'guid' => '', 'id_character' => ''];
        }
    }

    public function generatesummary($tripid = null, $curtz = null)
    {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->ci->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");
            if ($sql->num_rows() > 0) {
                $data = [];
                $data['driver_name'] = $data['driver_num'] = "";
                $shift = $sql->row()->shift_id;
                $sql1 = $this->ci->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=" . $shift . " LIMIT 1");
                $data["trip"] = $sql1->row();
                /* $emp1 = $this->ci->db->query("select e.name,convertToClientTZ(te.stime,'".$curtz."') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=".$tripid); */
                $emp = $this->ci->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $dlat = $dlng = "";
                $trucks_query = $this->ci->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude from tb_trucks_data WHERE id=$vehicleid LIMIT 1");
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                    $dlat = $trucks_query->row()->latitude;
                    $dlng = $trucks_query->row()->longitude;
                }
                if ($dlat == "") {
                    $dlat = $sql->row()->plat;
                    $dlng = $sql->row()->plng;
                }
                if ($dlat == $sql->row()->plat) {
                    $dlat = $sql1->row()->elat;
                    $dlng = $sql1->row()->elng;
                }
                /* update end lat lng in trips */
                $whrtrip = ["id" => $tripid];
                $settrip = ["dlat" => $dlat, "dlng" => $dlng];
                $upd = $this->ci->db->where($whrtrip)->update("tb_trips", $settrip);
                $vtripinfo = ["plat" => $sql->row()->plat, "plng" => $sql->row()->plng, "dlat" => $dlat, "dlng" => $dlng];
                $data['tripinfo'] = (object)$vtripinfo;
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->ci->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                $sql2 = $this->ci->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 1;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = ['trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt];
                $chktrip = $this->ci->db->select("id")->get_where("tb_trip_summary", ["trip_id" => $tripid], 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->ci->db->insert("tb_trip_summary", $arr);
                }
                /* $data["trip_id"] = $tripid;
                  $shifttime = 0;
                  if ($trip_type != 2) {
                  $shti = $sql1->row()->startdate;
                  $shifttime = date('H:i A', strtotime($shti));
                  } else {
                  $shifttime = "Empty";
                  }
                  $data["driver_late"]  = $driver_late;
                  $data["empshifttime"] = $shifttime;
                  $data["distance"]     = $dist;
                  $data["stime"]        = $stime;
                  $data["etime"]        = $etime;
                  $data["simei"]        = $imei;
                  $data["eimei"]        = $eimei;
                  if ($odometer_end == "") {$odometer_end = 0;}
                  if ($odometer_start == "") {$odometer_start = 0;}
                  $data["odometer"]        = ($odometer_end - $odometer_start);
                  $data["page_title"]      = "Trip Report";
                  $data["capacity"]        = $cab_capacity;
                  $data["employees"]       = $emp1;
                  $data["trip_type"]       = $trip_type;
                  $data["register_number"] = $reg;
                  $data["truck_weight"]    = $truck_weight;
                  $data["truck_volume"]    = $truck_volume;
                  $data["ep"] = ""; */
                /* $getusermail = $this->ci->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                  if ($getusermail->num_rows() > 0) {
                  $receivemail = $getusermail->row()->emailid;
                  $receivename = $getusermail->row()->name;
                  $receivecc   = $getusermail->row()->cc_mails;
                  $data["ep"] = $getusermail->row()->address;
                  $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);
                  $repotmaildata = $this->ci->db->insert('tb_trips_mails',$insertdata);
                  $this->ci->load->library('email');
                  $this->email->to($receivemail, $receivename);
                  if ($receivecc != "") {
                  $this->email->cc($receivecc);
                  }
                  $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                  if ($trip_type == 1) {
                  $this->email->subject('svkonekt: Return Trip Status');
                  } else if ($trip_type == 2) {
                  $this->email->subject('svkonekt: Empty Trip Status');
                  } else {
                  $this->email->subject('svkonekt: Trip Status');
                  }
                  $this->email->set_mailtype('html');
                  $body = $this->ci->load->view('mail_forms/basicreport', $data, true);
                  $this->email->message($body);
                  $sendmail = $this->email->send();
                  } */
                /* echo json_encode(array("status" => 1, "data" => $data)); */
            }
        }
    }

    public function get_party_codes($code)
    {
        $result_set = $this->ci->common->gettblrowdata(['code' => $code, 'status' => 1], '*', 'bitetransit_party_codes', 1, 0);
        $result = "";
        if (isset($result_set['id']) && $result_set['id'] != '') {
            $result = $result_set;
        }
        return $result;
    }

    public function bite_transit_order_notes_generation($pickup_ins, $delivery_ins, $order_z04_reference, $order_z11_reference, $order_z12_reference)
    {
        $result = '';
        $result .= $pickup_ins . '; ' . $delivery_ins . '; ';
        if (strlen(trim($order_z04_reference)) > 2) {
            $result .= 'Z04 ' . $order_z04_reference . ', ';
        }
        if (strlen(trim($order_z11_reference)) > 2) {
            $result .= 'Z11 ' . $order_z11_reference . ', ';
        }
        if (strlen(trim($order_z12_reference)) > 2) {
            $result .= 'Z12 ' . $order_z12_reference;
        }
        $result = trim($result);
        $last_character = substr($result, -1);
        if ($last_character == ',' || $last_character == ', ') {
            $len = strlen($result);
            $result = substr($result, 0, $len - 1);
        }
        return $result;
    }

    public static function validateXML(
        string $communicationReference,
        string $toStatus,
        string $trackDate,
        string $trackTime,
        string $consignmentNumber
    ): array {
        $errors = [];
        if (empty($communicationReference)) {
            $errors[] = 'Bite transit Cron/ receives invalid communication ref:' . $communicationReference;
        }
        if (empty($toStatus)) {
            $errors[] = 'Bite transit Cron/ receives invalid toStatus:' . $toStatus;
        }
        if (!in_array($toStatus, self::STATUS_LIST)) {
            $errors[] = 'Bite transit Cron/ receives status not match with ST1...to....ST4:' . $toStatus;
        }
        if (empty($trackDate)) {
            $errors[] = 'Bite transit Cron/ receives invalid trackDate:' . $trackDate;
        }
        if (empty($trackTime)) {
            $errors[] = 'Bite transit Cron/ receives invalid trackTime:' . $trackTime;
        }
        if (empty($consignmentNumber)) {
            $errors[] = 'Bite transit Cron/ receives invalid consignmentNumber:' . $consignmentNumber;
        }
        return $errors;
    }
}
