<?php

class Blowhornorderstatuslib
{
    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['common', 'blowhornorderstatusmodel', 'Singlestatusmodel']);
    }

    public function insertOrderStatus(string $orderAWB, string $orderStatusResponse,string $statusFrom): void
    {
        $ci = &get_instance();
        $orderStatus = json_decode($orderStatusResponse, true, 512, JSON_THROW_ON_ERROR);
        if ($orderStatus['status'] == "PASS") {
            $orderStatusList = $orderStatus['message'];
            $orderInfo = $ci->blowhornorderstatusmodel->getOrderID($orderAWB);
            if (empty($orderInfo)) {
                log_message("error","There is no Order with this AWB: " . $orderAWB);
                return;
            }
            foreach ($orderInfo as $order) {
                $orderId = $order['id'];
                $bookingID = $order['order_id'];
            }
            $currentDate = date('Y-m-d H:i:s');
            foreach ($orderStatusList as $status) {
                $statusName = $status['status'] ?? "";
                $statusDateTime = $status['time'] ?? "";
                $statusEDD = $status['EDD'] ?? "";
                $estimateDateTime = date("Y-m-d H:i:s", strtotime($statusEDD));
                $statusDateTimeData = date("Y-m-d H:i:s", strtotime($statusDateTime));
                if ($statusFrom == "Web") {
                    $getactual    = getdatetimebytimezone( "Asia/Kolkata", $statusDateTimeData, DFLT_TZ );
                    $statusDateTimeData      = $getactual['datetime'];
                }
                $locationLatitude = $status['location']['lat'] ?? "";
                $locationLongitude = $status['location']['lon'] ?? "";
                $address = $status['address'] ?? "";
                $statusInfo = $this->getStatusInfo($status);
                $status_type = $statusInfo['statusType'] ?? "UD";
                if ($address == "" && ($locationLatitude != "" && $locationLongitude != "")) {
                    $address = getLocationName($locationLatitude, $locationLongitude);
                }
                $blowhornAPIData = [
                    'order_id' => $orderId,
                    'status_name' => $statusName,
                    'status_location' => $address,
                    'status_datetime' => $statusDateTimeData,
                    'status_type' => $status_type,
                    'instructions' => $statusName,
                    'pickup_date' => $statusDateTimeData,
                    'promise_deliver_date' => $estimateDateTime,
                    'exp_deliver_date' => $estimateDateTime,
                    'no_of_attempt' => 0,
                    'awbnum' => $orderAWB,
                    'queue_triggered' => 1,
                    'status' => 1,
                    ];
                $getBlowhornAPIData = $ci->common->gettblrowdata(
                    [
                    'order_id' => $orderId,
                    'status_name' => $statusName,
                    'status_datetime' => $statusDateTimeData,
                    'status_type' => $status_type
                ], "id", "tb_uniqlo_push_api_data", 0, 0);
                if (!empty($getBlowhornAPIData)) {
                    $TrackingId = ["id" => $getBlowhornAPIData['id']];
                    $ci->common->updatetbledata("tb_uniqlo_push_api_data", $blowhornAPIData, $TrackingId);
                } else {
                    $ci->common->insertTableData("tb_uniqlo_push_api_data", $blowhornAPIData);
                }

                $ci->common->updatetbledata("tb_order_details", ['promise_deliver_date' => $estimateDateTime], ["order_row_id" => $orderId]);

                $uniqloOrderTrackingData = [
                    'order_id' => $orderId,
                    'origin' => $address,
                    'status_name' => $statusName,
                    'status_location' => $address,
                    'status_datetime' => $statusDateTimeData,
                    'status_type' => $status_type,
                    'instructions' => $statusName,
                    'status_code' => $statusName,
                    'pickup_date' => $statusDateTimeData,
                    'status' => 1
                ];
                $orderTrackingWhere = [
                    'order_id' => $orderId,
                    'status_name' => $statusName,
                    'status_datetime' => $statusDateTimeData,
                    'status_type' => $status_type,
                    'status_code' => $statusName
                ];
                $orderTrackingData = $ci->common->gettblrowdata($orderTrackingWhere, "id", "tb_uniqlo_order_tracking", 0, 0);
                if (!empty($orderTrackingData)) {
                    $orderTrackingId = ["id" => $orderTrackingData['id']];
                    $ci->common->updatetbledata("tb_uniqlo_order_tracking", $uniqloOrderTrackingData, $orderTrackingId);
                } else {
                    $ci->common->insertTableData("tb_uniqlo_order_tracking", $uniqloOrderTrackingData);
                }
                $uniqloOrderScansData['order_id'] = $orderId;
                $uniqloOrderScansData['scan_datetime'] = $statusDateTimeData;
                $uniqloOrderScansData['scan_type'] = $status_type;
                $uniqloOrderScansData['scan_val'] = $statusName;
                $uniqloOrderScansData['scan_status_time'] = $statusDateTimeData;
                $uniqloOrderScansData['scan_location'] = $address;
                $uniqloOrderScansData['scan_instruction'] = $statusName;
                $uniqloOrderScansData['scan_status_code'] = $statusName;
                $uniqloOrderScansData['scan_geo_lat'] = $locationLatitude;
                $uniqloOrderScansData['scan_geo_lng'] = $locationLongitude;
                $uniqloOrderScansData['status'] = 1;

                $checkAssignStatusData = $ci->common->gettblrowdata(['order_id' => $orderId, 'scan_val' => "In-Progress"], "id", "tb_uniqlo_order_scans", 0, 0);
                if (!empty($checkAssignStatusData)) {
                    if ($checkAssignStatusData['id'] != "" && $statusName == "Assigned") {
                        $statusName = "Assigned-to-Out-for-delivery";
                        $uniqloOrderScansData['scan_val'] = $statusName;
                        $uniqloOrderScansData['scan_instruction'] = $statusName;
                        $uniqloOrderScansData['scan_status_code'] = $statusName;
                    }
                } else {
                    $checkAssignStatusData = $ci->common->gettblrowdata(['order_id' => $orderId, 'scan_val' => "Picked"], "id", "tb_uniqlo_order_scans", 0, 0);
                    if (!empty($checkAssignStatusData)) {
                        if ($checkAssignStatusData['id'] != "" && $statusName == "Assigned") {
                            $statusName = "In Transit";
                            $uniqloOrderScansData['scan_val'] = $statusName;
                            $uniqloOrderScansData['scan_instruction'] = $statusName;
                            $uniqloOrderScansData['scan_status_code'] = $statusName;
                        }
                    }
                }

                $orderTrackingScanWhere = [
                    'order_id' => $orderId,
                    'scan_datetime' => $statusDateTimeData,
                    'scan_type' => $status_type,
                    'scan_val' => $statusName,
                    'scan_instruction' => $statusName,
                    'scan_status_code' => $statusName
                ];
                $orderTrackingData = $ci->common->gettblrowdata($orderTrackingScanWhere, "id", "tb_uniqlo_order_scans", 0, 0);

                if (count($orderTrackingData) == 0) {
                    $ci->common->insertTableData("tb_uniqlo_order_scans", $uniqloOrderScansData);
                }
                $response[] = [
                    'order_id' => $orderId,
                    'Status' => $statusInfo['Status'],
                    'StatusLocation' => $address,
                    'StatusLatitude' => $locationLatitude,
                    'StatusLongitude' => $locationLongitude,
                    'StatusDateTime' => $statusInfo['StatusDateTime'],
                    'Instructions' => $statusName,
                    'StatusType' => $status_type,
                    'StatusId' => $statusInfo['StatusID'],
                    'StatusCode' => $statusInfo['Status_Code'],
                    'AWB' => $orderAWB,
                    'StopType' => $statusInfo['Stop_Type'],
                    'StatusDesc' => $statusInfo['desc'],
                ];
                if ($statusInfo['Status_Code'] == "1550") {
                    $response[] = [
                        'order_id' => $orderId,
                        'Status' => "Gate Out",
                        'StatusLocation' => $address,
                        'StatusLatitude' => $locationLatitude,
                        'StatusLongitude' => $locationLongitude,
                        'StatusDateTime' => $statusInfo['StatusDateTime'],
                        'Instructions' => $statusName,
                        'StatusType' => $status_type,
                        'StatusId' => "3",
                        'StatusCode' => "0191",
                        'AWB' => $orderAWB,
                        'StopType' => "P",
                        'StatusDesc' => $statusInfo['desc'],
                    ];
                }
                if ($statusInfo['Status_Code'] == "2300") {
                    $response[] = [
                        'order_id' => $orderId,
                        'Status' => "Gate Out",
                        'StatusLocation' => $address,
                        'StatusLatitude' => $locationLatitude,
                        'StatusLongitude' => $locationLongitude,
                        'StatusDateTime' => $statusInfo['StatusDateTime'],
                        'Instructions' => $statusName,
                        'StatusType' => $status_type,
                        'StatusId' => "3",
                        'StatusCode' => "3000",
                        'AWB' => $orderAWB,
                        'StopType' => "D",
                        'StatusDesc' => $statusInfo['desc'],
                    ];
                }
            }
            $this->insertEtnOrderStatus($response);
        }
    }

    public function insertEtnOrderStatus(array $orderStatuses): string
    {
        $ci = &get_instance();
        if (empty($orderStatuses)) {
            log_message("error", "No Status Received From BlowHorn");
            return "Empty";
        }
        foreach ($orderStatuses as $status) {
            $orderDetails = $ci->common->gettblrowdata(["id" => $status['order_id']], "id,order_id,pickup_city,plat,plng,dlat,dlng,user_id,shift_id,trip_id,vendor_id,company_code,branch_code,created_source", "tb_orders", 0, 0);
            if ($orderDetails['trip_id'] == 0) {
                $acceptTrip = $this->acceptTrip($orderDetails, $status);
                $orderDetails['trip_id'] = $acceptTrip;
            }
            $tripVechleDriver = $ci->common->gettblrowdata(["id" => $orderDetails['trip_id']], "`vehicle_id`,`driver_id`", "tb_trips", 0, 0);
            $vehicleId = $tripVechleDriver["vehicle_id"] ?? 0;
            $driverId = $tripVechleDriver["driver_id"] ?? 0;

            $stopIdInfo = $ci->common->gettblrowdata(["shipment_id" => $orderDetails['shift_id'], 'stoptype' => $status['StopType'], "status" => 1], "id", "tb_shiporder_stops", 0, 0);
            $stopId = $stopIdInfo['id'] ?? 0;

            $stopDetail = $ci->common->gettblrowdata(["shift_id" => $orderDetails['shift_id'], 'order_id' => $orderDetails['order_id'], "status" => 1], "id", "tb_employee", 0, 0);
            $stopDetailId = $stopDetail['id'] ?? 0;

            if ($status['Status'] != "Pending") {
                $stopStatusData = [
                    "order_id" => $status['order_id'],
                    "shipment_id" => $orderDetails['shift_id'],
                    "stop_id" => $stopId,
                    "stop_detail_id" => $stopDetailId,
                    "stop_type" => $status['StopType'],
                    "trip_id" => $orderDetails['trip_id'],
                    "status_id" => $status['StatusId'],
                    "loc_name" => $status['StatusLocation'],
                    "latitude" => $status['StatusLatitude'],
                    "longitude" => $status['StatusLongitude'],
                    "reason" => $status['StatusDesc'],
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $driverId,
                    "status_code" => $status['StatusCode'],
                    "createdon" => $status['StatusDateTime']
                ];
                $getStatusInfo = $ci->common->gettblrowdata(["shipment_id" => $orderDetails['shift_id'], 'order_id' => $status['order_id'], "stop_type" => $status['StopType'], "status_id" => $status['StatusId'], "status_code" => $status['StatusCode']], "id", "tb_stop_status", 0, 0);
                if (empty($getStatusInfo)) {
                    $ci->common->insertTableData("tb_stop_status", $stopStatusData);
                } else {
                    $statusRowid = $getStatusInfo['id'];
                    $ci->common->updatetbledata("tb_stop_status", ["id" => $statusRowid], $stopStatusData);
                }
                if ($status['StopType'] == "D" && $status['StatusCode'] == "2300") {
                    $tripsData["end_imei"] = "";
                    $tripsData["end_reading"] = '0';
                    $tripsData["etime"] = $tripsData["updated_on"] = $status['StatusDateTime'];
                    $tripsData["status"] = '0';
                    $tripsData["transit_status"] = '1';
                    $ci->common->updatetbledata(
                        "tb_orders",
                        ["trip_sts" => '1'],
                        ["id" => $orderDetails['id'], "trip_id <>" => 0]
                    );

                    $ci->common->updatetbledata("tb_trips", $tripsData, ["id" => $orderDetails['trip_id']]);
                    $ci->common->updatetbledata(
                        "tb_orders",
                        ["trip_sts" => '1'],
                        ["id" => $orderDetails['id'], "shift_id" => $orderDetails['shift_id']]
                    );
                }
            }
        }
        return "Success";
    }

    private function getStatusInfo(array $status): array
    {
        $statusinfo['Stop_Type'] = 'P';
        $statusinfo['desc'] = "Time:" . $status['time'] . ", Location:" . $status['address'] . ", Desc:" . $status['status'];
        $statusinfo['statusType'] = "UD";
        switch ($status['status']) {
            case "Pending":
                $statusinfo['Status'] = "Pending";
                $statusinfo['Status_Code'] = '0212';
                $statusinfo['Stop_Type'] = 'P';
                $statusinfo['StatusID'] = '10';
                break;
            case "Assigned":
                $statusinfo['Status'] = "Manifested";
                $statusinfo['Status_Code'] = '0470';
                $statusinfo['Stop_Type'] = 'P';
                $statusinfo['StatusID'] = '49';
                break;
            case "Out-For-Pickup":
            case "Pickup-Failed":
                $statusinfo['Status'] = "Gate In";
                $statusinfo['StatusID'] = 2;
                $statusinfo['Status_Code'] = '0420';
                $statusinfo['Stop_Type'] = 'P';
                break;
            case "Picked":
                $statusinfo['Status'] = "Pickup";
                $statusinfo['StatusID'] = 1;
                $statusinfo['Status_Code'] = '0500';
                $statusinfo['Stop_Type'] = 'P';
                break;
            case "At-Hub":
            case "In-Progress":
            case "Moving-to-Hub":
                $statusinfo['Status'] = "In-Transit";
                $statusinfo['StatusID'] = 4;
                $statusinfo['Status_Code'] = '1550';
                $statusinfo['Stop_Type'] = 'P';
                break;
            case "Attempted":
                $statusinfo['Status'] = "Gate In";
                $statusinfo['StatusID'] = 2;
                $statusinfo['Status_Code'] = '0192';
                $statusinfo['Stop_Type'] = 'D';
                break;
            case "Complete":
                $statusinfo['Status'] = "Delivered";
                $statusinfo['StatusID'] = 1;
                $statusinfo['Status_Code'] = '2300';
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "DL";
                break;
            case "Returned":
                $statusinfo['Status'] = "Returned";
                $statusCodeDetails = $this->getStatusCode("Returned");
                $statusinfo['Status_Code'] = $statusCodeDetails['statusid'];
                $statusinfo['StatusID'] = $statusCodeDetails['statusCode'];
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "DL";
                break;
            case "Returned-to-Origin":
                $statusinfo['Status'] = "Returned-to-Origin";
                $statusCodeDetails = $this->getStatusCode("Returned-to-Origin");
                $statusinfo['Status_Code'] = $statusCodeDetails['statusid'];
                $statusinfo['StatusID'] = $statusCodeDetails['statusCode'];
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "RT";
                break;
            case "Returned-to-Origin-Failed":
                $statusinfo['Status'] = "Returned-to-Origin-Failed";
                $statusCodeDetails = $this->getStatusCode("Returned-to-Origin-Failed");
                $statusinfo['Status_Code'] = $statusCodeDetails['statusid'];
                $statusinfo['StatusID'] = $statusCodeDetails['statusCode'];
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "RT";
                break;
            case "Moving-to-Origin":
                $statusinfo['Status'] = "Moving-to-Origin";
                $statusCodeDetails = $this->getStatusCode("Moving-to-Origin");
                $statusinfo['Status_Code'] = $statusCodeDetails['statusid'];
                $statusinfo['StatusID'] = $statusCodeDetails['statusCode'];
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "RT";
                break;
            case "At-Hub-RTO":
                $statusinfo['Status'] = "At-Hub-RTO";
                $statusCodeDetails = $this->getStatusCode("At-Hub-RTO");
                $statusinfo['Status_Code'] = $statusCodeDetails['statusid'];
                $statusinfo['StatusID'] = $statusCodeDetails['statusCode'];
                $statusinfo['Stop_Type'] = 'D';
                $statusinfo['statusType'] = "RT";
                break;
            default:
                $statusinfo['Status'] = "Pending";
                $statusinfo['Status_Code'] = '0212';
                $statusinfo['Stop_Type'] = 'P';
                $statusinfo['StatusID'] = '10';
                break;
        }
        $statusDate = date("Y-m-d H:i:s", strtotime($status['time']));
        $currentTimeZone = "Asia/Kolkata";
        $dateTimeByTimezone = getdatetimebytimezone($currentTimeZone, $statusDate, DFLT_TZ);
        $statusinfo['StatusDateTime'] = $dateTimeByTimezone['datetime'];
        return $statusinfo;
    }

    public function getStatusCode($code): array
    {
        $ci = &get_instance();
        $status = $ci->common->gettblrowdata(["status_code" => $code], "id,status_code", "tb_status_master", 0, 0);
        $statusId = $status['id'] ?? 0;
        $statusCode = $status['status_code'] ?? $code;
        if ($statusId == 0) {
            $statusMasterData = [
                'status_name' => $code,
                'description' => $code,
                'status_type' => "yes",
                'status_code' => $code,
                'company_code' => "INKN",
                'branch_code' => "INCL",
                'createdon' => date('Y-m-d H:i:s')
            ];
            $statusId = $ci->common->insertTableData("tb_status_master", $statusMasterData);
        }
        return ["statusid" => $statusId, "statusCode" => $statusCode];
    }

    public function acceptTrip(array $orderDetails, array $status): int
    {
        $ci = &get_instance();
        $vehicle_id = $driver_id = 0;
        $imei = "";
        $vehicle_id = $this->getCarrierVehicleid($orderDetails['vendor_id'], $orderDetails['shift_id'], $orderDetails['user_id']);
        $driver_id = $this->getVehicleDriversid($orderDetails['vendor_id'], $orderDetails['shift_id'], $orderDetails['user_id'], $vehicle_id);
        $latitude = $orderDetails['plat'] ?? "";
        $longitude = $orderDetails['plng'] ?? "";
        if ($orderDetails['plat'] != "" && $orderDetails['plng'] != "") {
            $userLatLong = $ci->common->gettblrowdata(["user_id" => $orderDetails['user_id']], "latitude,longitude", "tb_site_settings", 0, 0);
            if (!empty($userLatLong)) {
                $latitude = $userLatLong['latitude'];
                $longitude = $userLatLong['longitude'];
            }
        }
        $statusDateTime = $status['StatusCode'] == "0212" ? $status['StatusDateTime'] : date("Y-m-d H:i:s");
        $curtz = "Asia/Kolkata";
        $generateUTCtime = getdatetimebytimezone(DFLT_TZ, $statusDateTime, $curtz);
        $currentDateTime = $generateUTCtime['datetime'];
        $tripDetails = [
            'shift_id' => $orderDetails['shift_id'],
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id,
            'stime' => $currentDateTime,
            'start_imei' => $imei,
            'splace' => "",
            'eplace' => "",
            'start_reading' => 0,
            'end_reading' => 0,
            'created_on' => $currentDateTime,
            'updated_on' => $currentDateTime,
            'status' => 1,
            'trip_type' => 0,
            'transit_status' => 0,
            'plat' => $latitude,
            'plng' => $longitude
        ];
        $tripId = $ci->common->insertTableData('tb_trips', $tripDetails);
        $acceptanceStatus = [
            "order_id" => $orderDetails['id'],
            "shipment_id" => $orderDetails['shift_id'],
            "stop_id" => 0,
            "stop_detail_id" => 0,
            "stop_type" => "",
            "trip_id" => $tripId,
            "status_id" => "10",
            "latitude" => $latitude,
            "longitude" => $longitude,
            "status" => 1,
            "reason" => $status['StatusDesc'],
            "vehicle_id" => $vehicle_id,
            "driver_id" => $driver_id,
            "status_code" => "0212",
            "createdon" => $currentDateTime
        ];
        $ci->common->insertTableData('tb_stop_status', $acceptanceStatus);
        $ci->common->updatetbledata("tb_orders", ["trip_id" => $tripId], ["id" => $orderDetails['id']]);
        return $tripId ?? 0;
    }

    private function getCarrierVehicleid(int $vendor_id, int $shiftRowId, int $userId): int
    {
        $ci = &get_instance();
        $getVehicleId = $ci->common->gettblrowdata(['shft_id' => $shiftRowId, "carrier_id" => $vendor_id, "status" => "1"], "vehicle_id", "tb_shft_veh", 0, 0);
        $vehicle_id = $getVehicleId['vehicle_id'] ?? 0;
        if ($vehicle_id == 0) {
            $getCarrierVehicles = $ci->common->gettblrowdata([
                "vendor_id" => $vendor_id,
                "status" => 1
            ], "id,register_number", "tb_trucks_data", 0, 0);
            $vehicle_id = $getCarrierVehicles['id'] ?? "";
            $shfitVehicles = [
                "user_id" => $userId,
                "shft_id" => $shiftRowId,
                "carrier_id" => $vendor_id,
                "vehicle_id" => $vehicle_id,
                "register_number" => $getCarrierVehicles['register_number'] ?? "",
            ];
            $ci->common->insertTableData('tb_shft_veh', $shfitVehicles);
        }

        return $vehicle_id;
    }

    public function getVehicleDriversid(int $vendor_id, int $shiftRowId, int $userId, int $vehicleId): int
    {
        $ci = &get_instance();
        $getDriverId = $ci->common->gettblrowdata(['vehicle_id' => $vehicleId, 'status' => '1'], "driver_id", "tbl_assigned_drivers", 0, 0);
        $driver_id = $getDriverId['driver_id'] ?? 0;
        if ($driver_id == 0) {
            $getVehicleDrivers = $ci->common->gettblrowdata([
                "vehicle_id" => $vehicleId,
                "status" => 1
            ], "driver_id", "tb_vehicles_drivers", 0, 0);
            $driver_id = $getVehicleDrivers['driver_id'] ?? "0";
            $shfitVehiclesDrivers = [
                "user_id" => $userId,
                "vehicle_id" => $vehicleId,
                "driver_id" => $driver_id,
                "status" => 1
            ];
            $ci->common->insertTableData('tbl_assigned_drivers', $shfitVehiclesDrivers);
        }
        return $driver_id;
    }

}
