<?php

class CalculateDistanceByOrderId
{
    private $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model('calculateDistanceModel', 'calcdistancemodel');
    }

    public function findPlannedDistanceByOrderId(string $orderId): string
    {
        $orderQry = $this->CI->calcdistancemodel->getOrderData($orderId);
        if ($orderQry) {
            $kmData = [];
            $orderData = (object)$orderQry;
            $location = $this->getOriginDestinationLatLng($orderData);
            if ($location['origin_lat'] && $location['origin_lng'] && $location['destination_lat'] && $location['destination_lng']) {
                $kmData = distancemetrixship($location['origin_lat'], $location['origin_lng'], $location['destination_lat'], $location['destination_lng']);
            }
            if ($kmData) {
                return $kmData['disttext'];
            }
        }
        return "0 km";
    }

    public function findActualDistanceByOrderId(string $orderId): string
    {
        $orderData = (object)$this->CI->calcdistancemodel->getOrderData($orderId);
        if ($orderData && $orderData->trip_id > 0 && $orderData->status > 0) {
            $orderOriginGateOutQry = $this->CI->calcdistancemodel->getOrderOriginGateOutTime($orderData->id, $orderData->trip_id);
            if ($orderOriginGateOutQry) {
                $orderOriginGateOut = (object)$orderOriginGateOutQry;
                $getActualTripMinQry = $this->CI->calcdistancemodel->getActualTripMinId($orderData->trip_id, $orderOriginGateOut->createdon);
                $getActualTripMaxQry = $this->CI->calcdistancemodel->getTransitTripMaxId($orderData->trip_id);
                $orderDestinationGateInQry = $this->CI->calcdistancemodel->getOrderDestinationGateInTime($orderData->id, $orderData->trip_id);
                if ($orderDestinationGateInQry) {
                    $orderDestinationGateIn = (object)$orderDestinationGateInQry;
                    $getActualTripMaxQry = $this->CI->calcdistancemodel->getActualTripMaxId($orderData->trip_id, $orderDestinationGateIn->createdon);
                }
                $getActualTripMin = (object)$getActualTripMinQry;
                if ($getActualTripMaxQry) {
                    $getActualTripMax = (object)$getActualTripMaxQry;
                }
                $kmData = distancemetrixship($getActualTripMin->latitude  ?? 0, $getActualTripMin->longitude ?? 0, $getActualTripMax->latitude ?? 0, $getActualTripMax->longitude ?? 0);
                return $kmData['disttext'] ? strtoupper($kmData['disttext']) : "0 km";
            }
        }
        return "0 km";
    }

    private function calculateDistanceByTripId(string $trip_id): string
    {
        $tripQry = $this->CI->calcdistancemodel->getTripDetails($trip_id);
        if ($tripQry && $tripQry['init_lat'] > 0 && $tripQry['act_lat'] > 0) {
            if ($tripQry['init_lat'] > 0 && $tripQry['act_lat'] > 0) {
                $kmData = distancemetrixship($tripQry['init_lat'], $tripQry['init_lng'], $tripQry['act_lat'], $tripQry['act_lng']);
            }
            if ($kmData) {
                return $kmData['disttext'];
            }
        }
        return "0 km";
    }

    private function getOriginDestinationLatLng(object $order): array
    {
        $data = [
            'origin_lat' => '',
            'origin_lng' => '',
            'destination_lat' => '',
            'destination_lng' => ''
        ];
        $originStreet = (string)$order->pickup_address1;
        $originCity = (string)$order->pickup_city;
        $originCountry = (string)$order->pickup_country;
        $originCountry = $this->CI->calcdistancemodel->getCountryCodeByName($originCountry);
        $originPostalCode = (string)$order->pickup_pincode;
        $originAddress = implode(",", [$originStreet, $originCity, $originCountry, $originPostalCode]);
        $originLatLngData = getlatlngsbyplace($originAddress);
        $destinationStreet = (string)$order->delivery_address1;
        $destinationCity = (string)$order->delivery_city;
        $destinationCountry = (string)$order->delivery_country;
        $destinationCountry = $this->CI->calcdistancemodel->getCountryCodeByName($destinationCountry);
        $destinationPostalCode = (string)$order->delivery_pincode;
        $destinationAddress = implode(",", [$destinationStreet, $destinationCity, $destinationCountry, $destinationPostalCode]);
        $destinationLatLngData = getlatlngsbyplace($destinationAddress);
        if ($originLatLngData) {
            $data['origin_lat'] = $originLatLngData[0];
            $data['origin_lng'] = $originLatLngData[1];
        }
        if ($destinationLatLngData) {
            $data['destination_lat'] = $destinationLatLngData[0];
            $data['destination_lng'] = $destinationLatLngData[1];
        }
        return $data;
    }
}
