<?php

class CarrierDocumentOutbound
{
    private $ci;
    private $message;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['common', 'standardstatusmodel']);
        $ci->load->library(['standardoutboundhandler', 'Edi_logger']);
    }

    public function sendDocumentsToCarrier(int $order_id): void
    {
        $ci = &get_instance();
        if ($order_id == "" || $order_id == 0) {
            log_message("error", "sendDocumentsToCarrier Order Number" . $order_id);
            return;
        }
        $carrierInfo = $ci->standardstatusmodel->getOrderCarrierInformation($order_id);
        if (empty($carrierInfo)) {
            log_message("error", "Carrier configuration not done for Order" . $order_id);
            return;
        }
        foreach ($carrierInfo as $order) {
            $customerOrdersList[$order['customer_id']]["customerlinks"] = [
                "customer_name" => $order['customer_name'],
                "category_type" => $order['category_type'],
                "edi_url" => $order['edi_url'],
                "ediname" => $order['ediname'],
                "ediservice" => $order['ediservice'],
                "user_name" => $order['user_name'],
                "password" => $order['password'],
            ];
            $customerOrdersList[$order['customer_id']]['orderids'][] = $order['orderid'];
        }
        $ci->standardoutboundhandler->sendDocumentOutBound($customerOrdersList, "Carrier");
    }


}
