<?php

use phpseclib\Net\SFTP;

class Carriercommonedilib
{
    private $ci;

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(["common", "carriercommonmodel", "customreferencesmodel"]);
        $ci->load->helper("cleanstr_helper");
    }

    public function shipmentdata(int $shipmentNumber): string
    {
        if ($shipmentNumber == "") {
            log_message("error", "There is no Shipmentid");
            return "There is no Shipmentid";
        }
        $data = $tripdata = [];
        $ci = &get_instance();

        $tripdetails = $ci->common->gettblrowdata(["id" => $shipmentNumber], "id,shipmentid,company_code,branch_code,department_code,shift_leg_id,user_id", "tb_shifts", 0, 0);
        $tripdata['shipmentid'] = $tripdetails['shipmentid'];
        $tripdata['company_code'] = $company_code = $tripdetails['company_code'];
        $tripdata['branch_code'] = $branch_code = $tripdetails['branch_code'];
        $tripdata['department_code'] = $department_code = $tripdetails['department_code'];

        $orderUserTimeZone = $ci->carriercommonmodel->getOrderUserTimeZone($tripdetails['user_id']);
        $curtz = $orderUserTimeZone['cntry_timezone'];
        $code = $orderUserTimeZone['phone_code'];

        $tripdata['vendordetails'] = $ci->carriercommonmodel->getShipmentCarrier($shipmentNumber);
        $tripdata['vendordetails']['phone_code'] = $code;

        $tripdata['tripStops'] = $ci->carriercommonmodel->getShipmentStops($shipmentNumber, $orderUserTimeZone['phone_code']);

        $tripdata['trucks_data'] = $ci->carriercommonmodel->getshipmentVehicleInfo($shipmentNumber);

        if (!empty($tripdata['trucks_data'])) {
            $driver_data = $ci->carriercommonmodel->getshipmentAssignDeiver($shipmentNumber, $orderUserTimeZone['phone_code']);
            $driver_data['phone_code'] = $code;
        }
        $tripdata['driver_data'] = $driver_data ?? [];
        $ShipmentOrders = $this->getShipmentOrders($shipmentNumber, $code, $curtz);
        $tripdata['PhysicalReceiver'] = $ShipmentOrders[0]['physicalreceiver'] ?? "";
        $tripdata['LogicalReceiver'] = $ShipmentOrders[0]['logicalreceiver'] ?? "";
        $tripdata['PhysicalSender'] = $ShipmentOrders[0]['physicalsender'] ?? "";
        $LogicalSender = $ShipmentOrders[0]['logicalsender'] ?? "";
        if ($LogicalSender != "") {
            $logicalinfo = $ci->common->gettblrowdata(['branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
            if (count($logicalinfo) > 0) {
                $LogicalSender = $logicalinfo['logical_sender'];
            }
        }
        $tripdata['LogicalSender'] = $LogicalSender;
        $total_volume = $total_quantity = 0;
        $totalweightGrms = $totalweightKgs = $totalweighttons = 0;
        foreach ($ShipmentOrders as $order) {
            foreach ($order['cargos'] as $cargos) {
            	$weightUnit = strtolower($cargos['weight_unit']);
                if (in_array($weightUnit, ['g','gms'])) {
                    $totalweightGrms += $cargos['weight'];
                }
                if (in_array($weightUnit, ['kg','kgm','kgs'])) {
                    $totalweightKgs += $cargos['weight'];
                }
                if ($weightUnit === "tons") {
                    $totalweighttons += $cargos['weight'];
                }
                $total_volume += $cargos['volume'];
                $total_quantity += $cargos['quantity'];
            }
        }
        $total_weight = ($totalweightKgs + ($totalweightGrms / 1000) + ($totalweighttons / 1000));
        $tripdata['total_volume'] = $total_volume ?? "0.0";
        $tripdata['total_weight'] = $total_weight ?? "0.0";
        $tripdata['total_quantity'] = $total_quantity;
        $tripdata['weight_unit'] = "KG";
        $tripdata['volume_unit'] = "CBM";

        $data['tripdetails'] = $tripdata;
        $data['ordersdetails'] = $ShipmentOrders;
        

        $tripXMl = $this->generateTripXML($data);
        //log_message("error","tripXMl:".$tripXMl);
       
        /*$sendingStatus = $this->sendTollXML($tripXMl);
        $triggeringStatus = "0";
        if ($sendingStatus != "Service execution failed.") {
            $ci->common->updatetbledata("tb_trips", ['is_carrier_edi_sent' => 1], ['shift_id' => $shipmentNumber]);
            //echo "EDI Successfully Triggered";
            $triggeringStatus = "1";
            log_message("error", "Trip Notification XML to Altova Successfully Triggered: " . $tripdetails['shipmentid']);
        } else {
            echo "EDI Triggering Failed with Altova: " . $sendingStatus;
            log_message("error", "Trip Notification XML to Altova Triggering Failed: " . $sendingStatus . " : " . $tripdetails['shipmentid']);
        }*/
        return $tripXMl;
    }
    
    public function CargoExchangeShipmentData(int $shipmentNumber, int $orderId): string
    {
        if ($shipmentNumber == "") {
            log_message("error", "There is no Shipmentid");
            return "There is no Shipmentid";
        }
        $data = $tripdata = [];
        $ci = &get_instance();

        $tripdetails = $ci->common->gettblrowdata(["id" => $shipmentNumber], "id,shipmentid,company_code,branch_code,department_code,shift_leg_id,user_id", "tb_shifts", 0, 0);
        $tripdata['shipmentid'] = $tripdetails['shipmentid'];
        $tripdata['company_code'] = $company_code = $tripdetails['company_code'];
        $tripdata['branch_code'] = $branch_code = $tripdetails['branch_code'];
        $tripdata['department_code'] = $department_code = $tripdetails['department_code'];

        $orderUserTimeZone = $ci->carriercommonmodel->getOrderUserTimeZone($tripdetails['user_id']);
        $curtz = $orderUserTimeZone['cntry_timezone'];
        $code = $orderUserTimeZone['phone_code'];

        $tripdata['vendordetails'] = $ci->carriercommonmodel->getShipmentCarrier($shipmentNumber);
        $tripdata['vendordetails']['phone_code'] = $code;

        $tripdata['tripStops'] = $ci->carriercommonmodel->getShipmentStops($shipmentNumber, $orderUserTimeZone['phone_code']);

        $tripdata['trucks_data'] = $ci->carriercommonmodel->getshipmentVehicleInfo($shipmentNumber);

        if (!empty($tripdata['trucks_data'])) {
            $driver_data = $ci->carriercommonmodel->getshipmentAssignDeiver($shipmentNumber, $orderUserTimeZone['phone_code']);
            $driver_data['phone_code'] = $code;
        }
        $tripdata['driver_data'] = $driver_data ?? [];
        $ShipmentOrders = $this->getShipmentOrders($shipmentNumber, $code, $curtz);
        $tripdata['PhysicalReceiver'] = $ShipmentOrders[0]['physicalreceiver'] ?? "";
        $tripdata['LogicalReceiver'] = $ShipmentOrders[0]['logicalreceiver'] ?? "";
        $tripdata['PhysicalSender'] = $ShipmentOrders[0]['physicalsender'] ?? "";
        $LogicalSender = $ShipmentOrders[0]['logicalsender'] ?? "";
        if ($LogicalSender != "") {
            $logicalinfo = $ci->common->gettblrowdata(['branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
            if (count($logicalinfo) > 0) {
                $LogicalSender = $logicalinfo['logical_sender'];
            }
        }
        $tripdata['LogicalSender'] = $LogicalSender;
        $total_volume = $total_quantity = 0;
        $totalweightGrms = $totalweightKgs = $totalweighttons = 0;
        foreach ($ShipmentOrders as $order) {
            foreach ($order['cargos'] as $cargos) {
            	$weightUnit = strtolower($cargos['weight_unit']);
                if (in_array($weightUnit, ['g','gms'])) {
                    $totalweightGrms += $cargos['weight'];
                }
                if (in_array($weightUnit, ['kg','kgm','kgs'])) {
                    $totalweightKgs += $cargos['weight'];
                }
                if ($weightUnit === "tons") {
                    $totalweighttons += $cargos['weight'];
                }
                $total_volume += $cargos['volume'];
                $total_quantity += $cargos['quantity'];
            }
        }
        $total_weight = ($totalweightKgs + ($totalweightGrms / 1000) + ($totalweighttons / 1000));
        $tripdata['total_volume'] = $total_volume ?? "0.0";
        $tripdata['total_weight'] = $total_weight ?? "0.0";
        $tripdata['total_quantity'] = $total_quantity;
        $tripdata['weight_unit'] = "KG";
        $tripdata['volume_unit'] = "CBM";

        $data['tripdetails'] = $tripdata;
        $data['ordersdetails'] = $ShipmentOrders;
        
        
        $payload = [
            "driverName" => $tripdata['driver_data']['name'] ?? '',
            "vehicleNo" => $tripdata['trucks_data']['truck_number'] ?? '',
            "driverNumber" => $tripdata['driver_data']['contact_num'] ?? '',
            "origin" => [
                "locality" => '',
                "city" => $tripdata['tripStops']['pickup']['city'] ?? '',
                "state" => $tripdata['tripStops']['pickup']['state'] ?? '',
            ],
            "destinations" => [[
                "locality" => '',
                "city" => $tripdata['tripStops']['delivery']['city'] ?? '',
                "state" => $tripdata['tripStops']['delivery']['state'] ?? '',
                "pincode" => $tripdata['tripStops']['delivery']['pincode'] ?? '',
            ]],
            "invoiceNumber" => "",
            "transpoterName" => "",
            "branches" => []
        ];
        
        $jsonPayload = json_encode($payload);
        
        log_message('error', 'jsonPayload: ' . $jsonPayload);
        
        $url = "https://track.cxipl.com/api/v2/trips/create-trip";
        
        $headers = [
            "authkey: XGYMGWU6CGYNT6QQP26QVQ9QE3XTY4KY",
            "Content-Type: application/json"
        ];
    
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonPayload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
        $curlResponse = curl_exec($ch);
        log_message('error', 'curlResponse: ' . $curlResponse);
        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            log_message('error', 'Cargo Exchange API Curl error: ' . $error);
            return json_encode(['error' => $error]);
        }
    
        curl_close($ch);
    
        $response = json_decode($curlResponse, true);
        log_message('error', 'jsonPayload: ' . $jsonPayload);
        $trackId = null;
        $message = '';
        
        if (isset($response['success'])) {
            if ($response['success'] === true) {
                // Look in 'data'
                if (isset($response['data']['trackId'])) {
                    $trackId = $response['data']['trackId'];
                }
                if (isset($response['data']['message'])) {
                    $message = $response['data']['message'];
                }
            } else {
                // Look in 'error'
                if (isset($response['error']['trackId'])) {
                    $trackId = $response['error']['trackId'];
                }
                if (isset($response['error']['message'])) {
                    $message = $response['error']['message'];
                }
            }
        }
        
        if ($trackId !== null) {
            $referenceData = [
                    'order_id' => $orderId,
                    'reference_id' => "SOR",
                    'ref_value' => $trackId
                ];
            $ci->customreferencesmodel->addOrderReferences($referenceData);
        } else {
            echo "Message: " . ($message !== '' ? $message : "TrackId not found.");
        }
    
        return $message;
    }

    private function generateTripXML(array $data): string
    {
        $tansctionno = Date("Ymdhis") . "_" . $data['tripdetails']['shipmentid'];
        $request = "<?xml version='1.0' encoding='UTF-8'?>
				<SVKEDIMessage>
				   <SVKEDITripHeader>
				      <EDIVersion>6.3.1</EDIVersion>
				      <UserName>Svkonekt</UserName>
				      <Password>******</Password>
				      <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
				      <AckSpec>
				         <EmailAddress />
				         <AckOption>ERROR</AckOption>
				      </AckSpec>
				      <SourceApp>Svkonekt</SourceApp>
				      <DestinationApp>Altova</DestinationApp>
				      <ReferenceId>" . $data['tripdetails']['shipmentid'] . "</ReferenceId>
				      <Action>BookingDetails</Action>
				   </SVKEDITripHeader>
				   <SVKEDITripBody>
				   <SVKOrgDetails>
						 <Companycode>" . $data['tripdetails']['company_code'] . "</Companycode>
						 <Branchcode>" . $data['tripdetails']['branch_code'] . "</Branchcode>
						 <DepartmentCode>" . $data['tripdetails']['department_code'] . "</DepartmentCode>
						 <PhysicalReceiver>" . $data['tripdetails']['PhysicalReceiver'] . "</PhysicalReceiver>
						 <LogicalReceiver>" . $data['tripdetails']['LogicalReceiver'] . "</LogicalReceiver>
						 <PhysicalSender>" . $data['tripdetails']['PhysicalSender'] . "</PhysicalSender>
						 <LogicalSender>" . $data['tripdetails']['LogicalSender'] . "</LogicalSender>
                </SVKOrgDetails>
			 <TripDetails>
			  <TripHeader>
			   <TripID>" . $data['tripdetails']['shipmentid'] . "</TripID>
			   <ExternalTripID>" . $data['tripdetails']['shipmentid'] . "</ExternalTripID>";
        $request .= $this->getCarrierXML($data);
        $request .= $this->getTripLocationXML($data);
        $request .= $this->getVehicleDetailsXML($data);
        $request .= "<CargoSummary>
               <TotalQuantity>
                  <Value>" . $data['tripdetails']['total_quantity'] . "</Value>
                  <UOM>Numbers</UOM>
               </TotalQuantity>
               <TotalVolume>
                  <Value>" . $data['tripdetails']['total_volume'] . "</Value>
                  <UOM>" . $data['tripdetails']['volume_unit'] . "</UOM>
               </TotalVolume>
               <TotalWeight>
                  <Value>" . $data['tripdetails']['total_weight'] . "</Value>
                  <UOM>" . $data['tripdetails']['weight_unit'] . "</UOM>
               </TotalWeight>
            </CargoSummary></TripHeader>";
        $request .= $this->getShipmentOrdersXML($data);
        $request .= "</TripDetails></SVKEDITripBody></SVKEDIMessage>";
        $request = str_replace("&", "AND", $request);
        $request = str_replace("amp;", "", $request);
        $request = str_replace(";", ",", $request);
        $filename = date('Ymd') . "SVK" . $data['tripdetails']['shipmentid'] . ".xml";
        $localfile = "./xml/tripoutbound/" . $filename;
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $request);
        return str_replace("&", "AND", $request);
    }

    private function getShipmentOrdersXML(array $data): string
    {
        $request = "";
        foreach ($data['ordersdetails'] as $orders) {
            $request .= "<TripOrderDetails><OrderID>" . $orders['order_id'] . "</OrderID>
					<EXTOrderID>" . $orders['order_id'] . "</EXTOrderID>
					<Transits>
					<TransitLegId />
					</Transits>
					<OrderType>" . $orders['order_type'] . "</OrderType>
					<ModeOfTransport>" . str_replace("&", "AND", $orders['transport_mode']) . "</ModeOfTransport>
					<Product>" . str_replace("&", "AND", $orders['product']) . "</Product>
					<ServiceType>" . str_replace("&", "AND", $orders['service_type']) . "</ServiceType>
					<GoodsValue>" . str_replace("&", "AND", $orders['goods_value']) . "</GoodsValue>
					<TypeOfBusiness></TypeOfBusiness>
					<TermsOfTrade>
					<Incoterm>" . $orders['incoterm'] . "</Incoterm>
					<FreightName>
						<Term>" . $orders['delivery_term_id'] . "</Term>
						<Name>" . $orders['delivery_term_name'] . "</Name>
					</FreightName>
					</TermsOfTrade>
					<CustomerDetails>
							<ID>" . $orders['customer_details']['cust_id'] . "</ID>
							<PartyIdentifier>" . $orders['customer_details']['party_id'] . "</PartyIdentifier>
							<Company>
								<Name>" . str_replace("&", "AND", $orders['customer_details']['name']) . "</Name>
								<RegistrationNumber>" . $orders['customer_details']['cust_id'] . "</RegistrationNumber>
							</Company>
							<Address>
							<CustomerName>" . str_replace("&", "AND", $orders['customer_details']['name']) . "</CustomerName>
							<Address1>" . str_replace("&", "AND", $orders['customer_details']['address']) . "</Address1>
							<Address2></Address2>
							<Street>" . str_replace("&", "AND", $orders['customer_details']['street']) . "</Street>
							<City>" . str_replace("&", "AND", $orders['customer_details']['city']) . "</City>
							<State>" . str_replace("&", "AND", $orders['customer_details']['state']) . "</State>
							<Postal>" . $orders['customer_details']['pincode'] . "</Postal>
							<Country>" . $orders['customer_details']['country'] . "</Country>
							<ContactNo>
								<CountryCode>" . $orders['customer_details']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['customer_details']['phone'] . "</ContactNo>
								<EmailAddress></EmailAddress>
							</ContactNo>
						</Address>
						<DepartmentCode></DepartmentCode>";

            if (!empty($orders['customer_details']['references'])) {
                $request .= "<PartyReference>";
                foreach ($orders['customer_details']['references'] as $partyref) {
                    $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
                }
                $request .= " </PartyReference>";
            }
            $request .= "</CustomerDetails>
					<LocationInfo>
					<Source>
						<ID>" . $orders['source']['cust_id'] . "</ID>
						<PartyIdentifier>" . $orders['source']['party_id'] . "</PartyIdentifier>
						<Company>
								<Name>" . str_replace("&", "AND", $orders['source']['name']) . "</Name>
								<RegistrationNumber>" . $orders['source']['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<CompanyName>" . str_replace("&", "AND", $orders['source']['name']) . "</CompanyName>
							<Address1>".str_replace("&","AND",$orders['source']['Address1'])."</Address1>
							<Address2>".str_replace("&","AND",$orders['source']['Address2'])."</Address2>
							<Street>" . str_replace("&", "AND", $orders['source']['street']) . "</Street>
							<City>" . str_replace("&", "AND", $orders['source']['city']) . "</City>
							<State>" . str_replace("&", "AND", $orders['source']['state']) . "</State>
							<Postal>" . $orders['source']['pincode'] . " </Postal>
							<Country>" . $orders['source']['country'] . "</Country>
							<ContactNo>
								<CountryCode>" . $orders['source']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['source']['phone'] . "</ContactNo>
								<EmailAddress></EmailAddress>
							</ContactNo>
						</Address>
						<EstimatedDateTime>
							<From>
								<DateTime>" . $orders['source']['pickup_datetime'] . "</DateTime>
								<TimeZone>" . $orders['source']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['source']['pickup_datetime_utc'] . "</Time>
								</UTC>
							</From>
							<To>
								<DateTime>" . $orders['source']['pickup_endtime'] . "</DateTime>
								<TimeZone>" . $orders['source']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['source']['pickup_endtime_utc'] . "</Time>
								</UTC>
							</To>
						</EstimatedDateTime>";
            if (!empty($orders['source']['references'])) {
                $request .= "<PartyReference>";
                foreach ($orders['customer_details']['references'] as $partyref) {
                    $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
                }
                $request .= " </PartyReference>";
            }
            $request .= "</Source>
					<Destination>
						<ID>" . $orders['destination']['cust_id'] . "</ID>
						<PartyIdentifier>" . $orders['destination']['party_id'] . "</PartyIdentifier>
						<Company>
								<Name>" . str_replace("&", "AND", $orders['destination']['name']) . "</Name>
								<RegistrationNumber>" . $orders['destination']['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<CompanyName>" . str_replace("&", "AND", $orders['destination']['name']) . "</CompanyName>
					        <Address1>".str_replace("&","AND",$orders['destination']['Address1'])."</Address1>
                            <Address2>".str_replace("&","AND",$orders['destination']['Address2'])."</Address2>
							<Street>" . str_replace("&", "AND", $orders['destination']['street']) . "</Street>
							<City>" . $orders['destination']['city'] . "</City>
							<State>" . $orders['destination']['state'] . "</State>
							<Postal>" . $orders['destination']['pincode'] . " </Postal>
							<Country>" . $orders['destination']['country'] . "</Country>
							<ContactNo>
								<CountryCode>" . $orders['destination']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['destination']['phone'] . "</ContactNo>
								<EmailAddress></EmailAddress>
							</ContactNo>
						</Address>
						<EstimatedDateTime>
							<From>
								<DateTime>" . $orders['destination']['delivery_datetime'] . "</DateTime>
								<TimeZone>" . $orders['destination']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['destination']['delivery_datetime_utc'] . "</Time>
								</UTC>
							</From>
							<To>
								<DateTime>" . $orders['destination']['delivery_endtime'] . "</DateTime>
								<TimeZone>" . $orders['destination']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['destination']['delivery_datetime_utc'] . "</Time>
								</UTC>
							</To>
						</EstimatedDateTime>";
            if (!empty($orders['destination']['references'])) {
                $request .= "<PartyReference>";
                foreach ($orders['customer_details']['references'] as $partyref) {
                    $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
                }
                $request .= " </PartyReference>";
            }
            $request .= "</Destination>
					</LocationInfo>
					<CargoDetails>";
            foreach ($orders['cargos'] as $cargo) {
                $request .= "<TransportHandlingUnit>
							<CargoType>" . str_replace("&", "AND", $cargo['cargo_type']) . "</CargoType>
							<GoodsDescription>" . str_replace("&", "AND", $cargo['goods_description']) . "</GoodsDescription>
							<MarksandNumbers>" . $cargo['marks_numbers'] . "</MarksandNumbers>
							<ValueOfGoods></ValueOfGoods>
							<HandlingUnit>" . $cargo['handling_unit'] . "</HandlingUnit>
							<ItemId>" . $cargo['item_id'] . "</ItemId>
							<Length>
								<Value>" . $cargo['length'] . "</Value>
								<UOM>" . $cargo['length_unit'] . "</UOM>
							</Length>
							<Width>
								<Value>" . $cargo['width'] . "</Value>
								<UOM>" . $cargo['width_unit'] . "</UOM>
							</Width>
							<Height>
								<Value>".$cargo['height']."</Value>
								<UOM>".$cargo['height_unit']."</UOM>
							</Height>
							<ActualWeight>
								<Value>" . $cargo['second_weight'] . "</Value>
								<UOM>" . $cargo['secondweight_uom'] . "</UOM>
							</ActualWeight>
							<Weight>
								<Value>" . $cargo['weight'] . "</Value>
								<UOM>" . $cargo['weight_unit'] . "</UOM>
							</Weight>
							<VolumetricWeight>
								<Value>" . $cargo['volumetric_weight'] . "</Value>
								<UOM>" . $cargo['volweight_uom'] . "</UOM>
							</VolumetricWeight>
							<Volume>
								<Value>" . $cargo['volume'] . "</Value>
								<UOM>" . $cargo['volume_unit'] . "</UOM>
							</Volume>
							<ActualVolume>
								<Value>" . $cargo['second_volume'] . "</Value>
								<UOM>" . $cargo['secondvolume_uom'] . "</UOM>
							</ActualVolume>
							<Quantity>" . $cargo['quantity'] . "</Quantity>
							<ScannedQuantity>" . $cargo['scanned_quantity'] . "</ScannedQuantity>
							<ldm>" . $cargo['ldm'] . "</ldm>
							<GroundedFlag>" . $cargo['grounded'] . "</GroundedFlag>
							<StackableFlag>" . $cargo['stackable'] . "</StackableFlag>
							<SplittableFlag>" . $cargo['splittable'] . "</SplittableFlag>
							<DangerousGoodsFlag>" . $cargo['dg_goods'] . "</DangerousGoodsFlag>";
                $dggoods = "";
                $dgpackgecount = 0;
                if (!empty($cargo['dggoods'])) {
                    $dggoods .= "<DangerousGoods>";
                    foreach ($cargo['dggoods'] as $dgGoodsCargo) {
                        $dgpackgecount += (int)$dgGoodsCargo['num_pkgs'];
                        $dggoods .= "<DangerousGoodsPosition>";
                        $dggoods .= "<NumberOfPackages><Value>" . $dgGoodsCargo['num_pkgs'] . "</Value><QuantityType>" . $dgGoodsCargo['pkg_qty_type'] . "</QuantityType></NumberOfPackages>";
                        $dggoods .= "<DangerousGoodsDetails>";
                        $dggoods .= "<DangerousGoodsQuantity><Value>" . $dgGoodsCargo['quantity'] . "</Value><QuantityType>" . $dgGoodsCargo['quantity_type'] . "</QuantityType></DangerousGoodsQuantity>";
                        $dggoods .= "<UnitedNationsOrganisationNumber><Value>" . $dgGoodsCargo['org_number'] . "</Value><Variant>" . $dgGoodsCargo['org_num_varient'] . "</Variant></UnitedNationsOrganisationNumber>";
                        $dggoods .= "<DangerousGoodsClass>" . $dgGoodsCargo['db_class'] . "</DangerousGoodsClass>";
                        $dggoods .= "<MainRisk>" . $dgGoodsCargo['mainrisk'] . "</MainRisk>";
                        $dggoods .= "<SubsidiaryRisks>" . $dgGoodsCargo['subsidiary_risks'] . "</SubsidiaryRisks>";
                        $dggoods .= "<PackingGroup>" . $dgGoodsCargo['packing_group'] . "</PackingGroup>";
                        $dggoods .= "<DangerousGoodsDescriptions><Language>EN</Language><ProperShippingName>" . $dgGoodsCargo['description'] . "</ProperShippingName></DangerousGoodsDescriptions>";
                        $dggoods .= "<LimitedQuantityFlag>" . $dgGoodsCargo['limitqty_flag'] . "</LimitedQuantityFlag>";
                        $dggoods .= "<ExceptedQuantityFlag>" . $dgGoodsCargo['exceptqty_flag'] . "</ExceptedQuantityFlag>";
                        $dggoods .= "<HighConsequence></HighConsequence>";
                        $dggoods .= "<Roadfreight>";
                        $dggoods .= "<TunnelRestrictionCode>" . $dgGoodsCargo['tunnel_restriction_code'] . "</TunnelRestrictionCode>";
                        $dggoods .= "<TransportCategory>" . $dgGoodsCargo['transport_category'] . "</TransportCategory>";
                        $dggoods .= "<EnvironmentallyHazardous>" . $dgGoodsCargo['environment_hazardous'] . "</EnvironmentallyHazardous>";
                        $dggoods .= "<NOS>" . $dgGoodsCargo['nos'] . "</NOS>";
                        $dggoods .= "<ADRMultiplicator>" . $dgGoodsCargo['adr_multiplicator'] . "</ADRMultiplicator>";
                        $dggoods .= "<TotalADRPoints>" . $dgGoodsCargo['total_adr_points'] . "</TotalADRPoints>";
                        $dggoods .= "<ADRVersion>" . $dgGoodsCargo['adr_version'] . "</ADRVersion>";
                        $dggoods .= "</Roadfreight>";
                        $dggoods .= "</DangerousGoodsDetails>";
                        $dggoods .= "</DangerousGoodsPosition>";
                    }
                    $dggoods .= "</DangerousGoods>";
                }

                $request .= "<TotalPackagesOfDangerousGoods>" . $dgpackgecount . "</TotalPackagesOfDangerousGoods>";
                $request .= $dggoods;
                if (count($cargo['inner_cargo']) > 0) {
                    foreach ($cargo['inner_cargo'] as $inn_cargo) {
                        $request .= " <Packagingunit>
									<PackageType>" . $inn_cargo['cargo_type'] . "</PackageType>
									<PackageDescription>" . $inn_cargo['goods_description'] . "</PackageDescription>
									<Quantity>" . $inn_cargo['quantity'] . "</Quantity>
									<Length>
										<Value>" . $inn_cargo['length'] . "</Value>
										<UOM>" . $inn_cargo['length_unit'] . "</UOM>
									</Length>
									<Width>
										<Value>" . $inn_cargo['width'] . "</Value>
										<UOM>" . $inn_cargo['width_unit'] . "</UOM>
									</Width>
									<Height>
										<Value>" . $inn_cargo['height'] . "</Value>
										<UOM>" . $inn_cargo['height_unit'] . "</UOM>
									</Height>
									<Weight>
										<Value>" . $inn_cargo['weight'] . "</Value>
										<UOM>" . $inn_cargo['weight_unit'] . "</UOM>
									</Weight>
									<Volume>
										<Value>" . $inn_cargo['volume'] . "</Value>
										<UOM>" . $inn_cargo['volume_unit'] . "</UOM>
									</Volume>
									</Packagingunit>";
                    }
                }
                $request .= "
						</TransportHandlingUnit>";
            }
            $request .= "</CargoDetails><ValueAddedServices>";
            if (!empty($orders['addons'])) {
                foreach ($orders['addons'] as $addon) {
                    $request .= " <Addon>
							<AddonName>" . $addon['vas_name'] . "</AddonName>
							<AddonCode></AddonCode>
							<Currency></Currency>
							<RateUnit></RateUnit>
							<AddonAmount></AddonAmount>
							<AddonQuantity>" . $addon['quantity'] . "</AddonQuantity>
							</Addon>";
                }
            }

            $request .= "</ValueAddedServices><InvolvedParties>";
            if (!empty($orders['parties'])) {
                foreach ($orders['parties'] as $party) {
                    $request .= "<PartyType type='" . $party['type'] . "'>
						<ID>" . $party['cust_id'] . "</ID>
						<PartyIdentifier>" . $party['party_id'] . "</PartyIdentifier>
						<Company>
							<Name>" . str_replace("&", "AND", $party['name']) . "</Name>
							<RegistrationNumber>" . $party['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<FirstName>" . str_replace("&", "AND", $party['name']) . "</FirstName>
							<LastName>" . str_replace("&", "AND", $party['name']) . "</LastName>
							<Address1>" . str_replace("&", "AND", $party['address']) . "</Address1>
							<Address2>" . str_replace("&", "AND", $party['address']) . "</Address2>
							<Street>" . str_replace("&", "AND", $party['street']) . "</Street>
							<City>" . $party['city'] . "</City>
							<State>" . $party['state'] . "</State>
							<Postal>" . $party['pincode'] . " </Postal>
							<Country>" . $party['country'] . "</Country>
							<ContactNo>
								<CountryCode>" . $data['ordersdetails'][0]['source']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $party['phone'] . "</ContactNo>
								<EmailAddress></EmailAddress>
							</ContactNo>
						</Address> ";
                    if (!empty($party['party_references'])) {
                        $request .= "<PartyReference>";
                        foreach ($party['party_references'] as $partyref) {
                            $request .= "<References><RefType><Code>" . str_replace(" ", "_", $partyref['name']) . "</Code><Value>" . $partyref['value'] . "</Value></RefType></References>";
                        }
                        $request .= " </PartyReference>";
                    }
                    $request .= " </PartyType>";
                }
            }
            $request .= "</InvolvedParties><ManageReferences>";

            if (!empty($orders['innref'])) {
                foreach ($orders['innref'] as $ref) {
                    $request .= "<References>
									<RefType>
										<Code>" . $ref['reference_id'] . "</Code>
										<Value>" . str_replace("&", "AND", $ref['ref_value']) . "</Value>
									</RefType>
								</References>";
                }
            }
            $request .= "</ManageReferences><Remarks></Remarks></TripOrderDetails>";
        }
        return str_replace("&", "AND", $request);
    }

    private function getVehicleDetailsXML(array $data): string
    {
        $request = " <VehicleDetails>";
        if (!empty($data['tripdetails']['trucks_data'])) {
            $request .= "<VehicleTypeCode>" . $data['tripdetails']['trucks_data']['truck_number'] . "</VehicleTypeCode>
               <VehicleModelCode>" . $data['tripdetails']['trucks_data']['truck_brand'] . "</VehicleModelCode>
               <RegistrationNumber>" . $data['tripdetails']['trucks_data']['register_number'] . "</RegistrationNumber>
               <License>" . $data['tripdetails']['trucks_data']['insurence'] . "</License>
               <ApplicableForDangerousGoods>" . $data['tripdetails']['trucks_data']['insurence'] . "</ApplicableForDangerousGoods>
               <CommodityType>" . $data['tripdetails']['trucks_data']['insurence'] . "</CommodityType>
               <Properties>
                  <Weight>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['truck_weight'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['weight_unit'] . "</UOM>
                  </Weight>
                  <Volume>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['truck_volume'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['volume_unit'] . "</UOM>
                  </Volume>
                  <Length>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['length'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['length_unit'] . "</UOM>
                  </Length>
                  <Width>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['breadth'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['breadth_unit'] . "</UOM>
                  </Width>
                  <Height>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['height'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['height_unit'] . "</UOM>
                  </Height>
                  <Distance>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </Distance>
                  <DimensionGirth>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </DimensionGirth>
                  <ShipmentUnit>
                    <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </ShipmentUnit>
                  <PacketWeight>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </PacketWeight>
                  <PacketVolume>
                    <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </PacketVolume>
               </Properties>";
        }
        $request .= "</VehicleDetails><DriverDetails>";

        if (!empty($data['tripdetails']['driver_data'])) {
            $request .= "<DriverId>" . $data['tripdetails']['driver_data']['contact_num'] . "</DriverId>
               <DriverName>" . $data['tripdetails']['driver_data']['name'] . "</DriverName>
               <DriverLicence>" . $data['tripdetails']['driver_data']['driving_licence_num'] . "</DriverLicence>
               <Address>
                  <Address1>" . $data['tripdetails']['driver_data']['address1'] . "</Address1>
                  <Address2>" . $data['tripdetails']['driver_data']['address2'] . "</Address2>
                  <Street>" . $data['tripdetails']['driver_data']['street'] . "</Street>
                  <City>" . $data['tripdetails']['driver_data']['city'] . "</City>
                  <State>" . $data['tripdetails']['driver_data']['state'] . "</State>
                  <Postal>" . $data['tripdetails']['driver_data']['pincode'] . "</Postal>
                  <Country>" . $data['tripdetails']['driver_data']['country'] . "</Country>
                  <ContactNo>
                     <CountryCode>" . $data['tripdetails']['driver_data']['phone_code'] . "</CountryCode>
                     <ContactNo>" . $data['tripdetails']['driver_data']['contact_num'] . "</ContactNo>
                     <EmailAddress></EmailAddress>
                  </ContactNo>
               </Address>";
        }
        $request .= "</DriverDetails>";
        return str_replace("&", "AND", $request);
    }

    private function getTripLocationXML(array $data): string
    {
        $request = "<TripLocation>
				<TripStartLocation>
					<Address>
						<CompanyName>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['name']) . "</CompanyName>
						<Address1></Address1>
						<Address2>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['city']) . "</Address2>
						<Street>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['street']) . "</Street>
						<City>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['city']) . "</City>
						<State>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['state']) . "</State>
						<Postal>" . $data['tripdetails']['tripStops']['pickup']['pincode'] . "</Postal>
						<Country>" . $data['tripdetails']['tripStops']['pickup']['country'] . "</Country>
						<ContactNo>
							<CountryCode>" . $data['tripdetails']['tripStops']['pickup']['phone_code'] . "</CountryCode>
							<ContactNo>" . $data['tripdetails']['tripStops']['pickup']['mobile'] . "</ContactNo>
							<EmailAddress></EmailAddress>
						</ContactNo>
					</Address>

				</TripStartLocation>
				<TripEndLocation>
					<Address>
						<CompanyName>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['name']) . "</CompanyName>
						<Address1></Address1>
						<Address2>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['city']) . "</Address2>
						<Street>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['street']) . "</Street>
						<City>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['city']) . "</City>
						<State>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['state']) . "</State>
						<Postal>" . $data['tripdetails']['tripStops']['delivery']['pincode'] . "</Postal>
						<Country>" . $data['tripdetails']['tripStops']['delivery']['country'] . "</Country>
						<ContactNo>
							<CountryCode>" . $data['tripdetails']['tripStops']['delivery']['phone_code'] . "</CountryCode>
							<ContactNo>" . $data['tripdetails']['tripStops']['delivery']['mobile'] . "</ContactNo>
							<EmailAddress></EmailAddress>
						</ContactNo>
					</Address>
				</TripEndLocation>

			</TripLocation>";
        return str_replace("&", "AND", $request);
    }

    private function getCarrierXML(array $data): string
    {
        $request = "<CarrierDetails>
			   <ID>" . $data['tripdetails']['vendordetails']['code'] . "</ID>
			   <PartyIdentifier>" . $data['tripdetails']['vendordetails']['party_id'] . "</PartyIdentifier>
               <Address>
                  <CompanyName>" . $data['tripdetails']['vendordetails']['companyname'] . "</CompanyName>
                   <Address1>" . $data['tripdetails']['vendordetails']['street_2'] . "</Address1>
                   <Address2>" . $data['tripdetails']['vendordetails']['street_3'] . "</Address2>
                   <Street>" . $data['tripdetails']['vendordetails']['street'] . "</Street>
                   <City>" . $data['tripdetails']['vendordetails']['location_id'] . "</City>
                   <State>" . $data['tripdetails']['vendordetails']['state'] . "</State>
                   <Postal>" . $data['tripdetails']['vendordetails']['pincode'] . "</Postal>
                   <Country>" . $data['tripdetails']['vendordetails']['country'] . "</Country>
                   <ContactNo>
                   		<CountryCode>" . $data['tripdetails']['vendordetails']['phone_code'] . "</CountryCode>
                   		 <ContactNo>" . $data['tripdetails']['vendordetails']['mobile'] . "</ContactNo>
                    	<EmailAddress></EmailAddress>
                   </ContactNo>
                </Address>
            </CarrierDetails>";
        return $request = str_replace("&", "AND", $request);
    }


    private function sendTollXML($orderinfo): string
    {
        try {
            log_message("error", "sendTollXML Request to Altova" . json_encode($orderinfo));
            $data = 'inputFiles=' . $orderinfo;
            $curl = curl_init(ALTOVA_CARRIER_TRIP_URL);
            curl_setopt($curl, CURLOPT_URL, ALTOVA_CARRIER_TRIP_URL);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/x-www-form-urlencoded"];
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            $resp = curl_exec($curl);
            if ($resp === false) {
                log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
            }
            log_message("error", "sendTollXML Response" . $resp);
            curl_close($curl);
        } catch (Exception $ex) {
            $resp = "";
            log_message("error", "Some Problem occured!, While Sending Trip Notification XML to Altova " . $ex->getMessage());
        }
        return $resp;
    }


    public function gettripstopdetails($shift_id)
    {
        $ci = &get_instance();
        $stopsData = [];

        $allstops = $ci->db->query("SELECT * FROM tb_shiporder_stops  WHERE STATUS = '1' AND shipment_id='" . $shift_id . "'  ORDER BY ordernumber ASC");
        $allstopsres = $allstops->result_array();
        $totalrecords = sizeof($allstopsres);
        $pickupid = $allstopsres[0]['id'];
        $dropid = $allstopsres[$totalrecords - 1]['id'];


        $stops = $ci->db->query("SELECT o.`pickup_company`,o.`pickup_address1`,o.`pickup_address2`,o.`pickup_city`,o.`pickup_country`,o.`pickup_pincode`,pickup_custid FROM tb_shiporder_stops  tss  LEFT OUTER JOIN tb_employee te ON te.stop_id=tss.id LEFT OUTER JOIN tb_orders o ON o.order_id=te.order_id WHERE tss.status = '1' AND tss.shipment_id='" . $shift_id . "' AND te.stop_id='" . $pickupid . "' AND tss.stoptype='P'");
        $pickupres = $stops->result_array();
        $pickup_custid = $pickupres[0]['pickup_custid'];
        $pickupcustd = $ci->common->gettblrowdata(["code" => $pickup_custid], "mobile,email,state,street", "tbl_party_master", 0, 0);
        $pickup["pickup_company"] = $pickupres[0]["pickup_company"];
        $pickup["pickup_address1"] = $pickupres[0]["pickup_address1"];
        $pickup["pickup_address2"] = $pickupres[0]["pickup_address2"];
        $pickup["pickup_city"] = $pickupres[0]["pickup_city"];
        $pickup["pickup_country"] = $pickupres[0]["pickup_country"];
        $pickup["pickup_pincode"] = $pickupres[0]["pickup_pincode"];
        $pickup["ContactNo"] = $pickupcustd["mobile"];
        $pickup["EmailAddress"] = $pickupcustd["email"];
        $pickup["state"] = $pickupcustd["state"];
        $pickup["street"] = $pickupcustd["street"];


        $stops = $ci->db->query("SELECT o.`delivery_company`, o.`delivery_address1`,o.`delivery_address2`,o.`delivery_city`,o.`delivery_country`,o.`delivery_pincode`,drop_custid FROM tb_shiporder_stops  tss LEFT OUTER JOIN tb_employee te ON te.drop_stopid=tss.id LEFT OUTER JOIN tb_orders o ON o.order_id=te.order_id WHERE tss.status = '1' AND tss.shipment_id='" . $shift_id . "' AND te.drop_stopid ='" . $dropid . "' AND tss.stoptype='D'");
        $deliveryres = $stops->result_array();
        $drop_custid = $deliveryres[0]['drop_custid'];
        $dropcustd = $ci->common->gettblrowdata(["code" => $drop_custid], "mobile,email,state,street", "tbl_party_master", 0, 0);
        $delivery["delivery_company"] = $deliveryres[0]["delivery_company"];
        $delivery["delivery_address1"] = $deliveryres[0]["delivery_address1"];
        $delivery["delivery_address2"] = $deliveryres[0]["delivery_address2"];
        $delivery["delivery_city"] = $deliveryres[0]["delivery_city"];
        $delivery["delivery_country"] = $deliveryres[0]["delivery_country"];
        $delivery["delivery_pincode"] = $deliveryres[0]["delivery_pincode"];
        $delivery["ContactNo"] = $dropcustd['mobile'];
        $delivery["EmailAddress"] = $dropcustd['email'];
        $delivery["state"] = $dropcustd['state'];
        $delivery["street"] = $dropcustd['street'];

        $stopsData = [
            "pickup" => $pickup,
            "delivery" => $delivery
        ];

        return $stopsData;
    }

    private function getShipmentOrders(int $shipmentNumber, int $code, string $curtz): array
    {
        $ci = &get_instance();
        $ordersdetails = $ci->common->getjointbldata("tb_orders o", "tb_order_details tod", "o.id=tod.order_row_id", ["o.shift_id" => $shipmentNumber], "o.id as orderno,o.*,tod.*", 0, 0);
        foreach ($ordersdetails as $orders) {
            $orderinfo = [];
            $orderinfo['order_id'] = $orders['order_id'];
            $orderinfo['transport_mode'] = $orders['transport_mode'];
            $orderinfo['product'] = $orders['product'];
            $orderinfo['incoterm'] = $orders['incoterm'];
            $orderinfo['goods_value'] = $orders['goods_value'];
            $orderinfo['order_type'] = "";
            if($orders['order_type']!=""){
                $orderinfo['order_type'] = $this->getOrderTypeName($orders['order_type']);
            }

            $orderinfo['service_type'] = $orderinfo['delivery_term_id'] = $orderinfo['delivery_term_name'] = "";
            if ($orders['service'] != "") {
                $orderinfo['service_type'] = $this->getOrderServiceName($orders['service']);
            }
            if ($orders['delivery_term'] != "") {
                $deliveryTermInfo = $this->getOrderDeliveryTermInfo($orders['delivery_term']);
                $orderinfo['delivery_term_id'] = $deliveryTermInfo['term_id'] ?? "";
                $orderinfo['delivery_term_name'] = $deliveryTermInfo['name'] ?? "";
            }
            $orderinfo['physicalreceiver'] = $orders['physicalreceiver'];
            $orderinfo['logicalreceiver'] = $orders['logicalreceiver'];
            $orderinfo['physicalsender'] = $orders['physicalsender'];
            $orderinfo['logicalsender'] = $orders['logicalsender'];

            $epickup = getdatetimebytimezone($curtz, $orders['pickup_datetime'], DFLT_TZ);
            $early_pickup = $epickup['datetime'];
            $lpickup = getdatetimebytimezone($curtz, $orders['pickup_endtime'], DFLT_TZ);
            $late_pickup = $lpickup['datetime'];

            $edelivery = getdatetimebytimezone($curtz, $orders['delivery_datetime'], DFLT_TZ);
            $early_delivery = $edelivery['datetime'];
            $ldelivery = getdatetimebytimezone($curtz, $orders['drop_endtime'], DFLT_TZ);
            $late_delivery = $ldelivery['datetime'];
            $partyTypes = [];
            $parties = $this->getOrderPartyDetails($orders['orderno']);
            foreach ($parties as $party) {
                if ($party['type'] == "Shipper") {
                    $orderinfo['source'] = $party;
                }
                if ($party['type'] == "Consignee") {
                    $orderinfo['destination'] = $party;
                }
                if ($party['type'] == "Customer" || $party['type'] == "CUSTOMER") {
                    $orderinfo['customer_details'] = $party;
                }
                array_push($partyTypes, $party['type']);
            }
            if (!in_array("Customer", $partyTypes) || !in_array("CUSTOMER", $partyTypes)) {
                $orderinfo['customer_details'] = $this->getOrderCustomerDetails($orders['customer_id']);
                $orderinfo['customer_details']['party_references'] = $ci->common->getPartyReferences($orders['customer_id']);
                $orderinfo['customer_details']['type'] = "Customer";
                array_push($parties, $orderinfo['customer_details']);
            }
            $orderinfo['parties'] = $parties;

            $orderinfo['source']['CountryCode'] = $orderinfo['customer_details']['CountryCode'] = $orderinfo['destination']['CountryCode'] = $code;
            $orderinfo['source']['pickup_datetime'] = $early_pickup;
            $orderinfo['source']['pickup_datetime_utc'] = $orders['pickup_datetime'];
            $orderinfo['source']['pickup_endtime'] = $late_pickup;
            $orderinfo['source']['pickup_endtime_utc'] = $orders['pickup_endtime'];
            $orderinfo['source']['Address1'] = $orders['pickup_address1'];
            $orderinfo['source']['Address2'] = $orders['pickup_address2'];
            $orderinfo['destination']['delivery_datetime'] = $early_delivery;
            $orderinfo['destination']['delivery_datetime_utc'] = $orders['delivery_datetime'];
            $orderinfo['destination']['delivery_endtime'] = $late_delivery;
            $orderinfo['destination']['delivery_endtime_utc'] = $orders['drop_endtime'];
            $orderinfo['destination']['Address1'] = $orders['delivery_address1'];
            $orderinfo['destination']['Address2'] = $orders['delivery_address2'];
            $orderinfo['source']['timezone'] = $orderinfo['destination']['timezone'] = $curtz;

            $orderinfo['cargos'] = $this->getOrderCargoDetails($orders['orderno']);
            $orderinfo['addons'] = $this->getOrderAddons($orders['orderno']);
            $orderinfo['innref'] = $this->getOrderManageReferences($orders['orderno']);
            $orderdata[] = $orderinfo;
        }
        return $orderdata ?? [];
    }

    private function getOrderCargoDetails(int $id): array
    {
        $ci = &get_instance();
        $cargos = [];
        $cargo_type = "";
        $getcargos = $ci->common->gettbldata(["order_id" => $id, "status" => 1], "id,cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content,second_weight, second_volume,scanned_quantity,ldm,volumetric_weight", "tb_order_cargodetails", 0, 0);
        if (!empty($getcargos)) {
            $cargo_cnt = 0;
            foreach ($getcargos as $res) {
                $cargos[$cargo_cnt]['quantity_type'] = $res['quantity_type'];
                $cargos[$cargo_cnt]['content'] = $res['cargo_content'] ?? "MISCELLANEOUS";
                $cargos[$cargo_cnt]['length'] = $res['length'];
                $cargos[$cargo_cnt]['width'] = $res['width'];
                $cargos[$cargo_cnt]['height'] = $res['height'];
                $cargos[$cargo_cnt]['weight'] = $res['weight'] ?? 1;
                $cargos[$cargo_cnt]['volume'] = $res['volume'] ?? 1;
                $cargos[$cargo_cnt]['quantity'] = $res['quantity'];
                $cargos[$cargo_cnt]['second_weight'] = $res['second_weight'];
                $cargos[$cargo_cnt]['second_volume'] = $res['second_volume'];
                $cargos[$cargo_cnt]['scanned_quantity'] = $res['scanned_quantity'];
                $cargos[$cargo_cnt]['ldm'] = $res['ldm'];
                $cargos[$cargo_cnt]['volumetric_weight'] = $res['volumetric_weight'];
                if ($res['cargo_id'] != "") {
                    $checkInnerCargo = $ci->common->gettblrowdata(["id" => $res['cargo_id']], "cargo_type, handling_unit,weight_unit,volume_unit,length_unit,width_unit, height_unit,goods_description,marks_numbers,item_id,secondweight_uom,secondvolume_uom, grounded,stackable,splittable,dg_goods,volweight_uom", "tb_cargo_details", 0, 0);
                    if (!empty($checkInnerCargo)) {
                        $cargo_type = $checkInnerCargo['cargo_type'] ?? "";
                        $cargo_type = $cargo_type ?? $checkInnerCargo['handling_unit'];
                        $cargos[$cargo_cnt]['cargo_type'] = $checkInnerCargo['cargo_type'] ?? "";
                        $cargos[$cargo_cnt]['handling_unit'] = $checkInnerCargo['handling_unit'];
                        $cargos[$cargo_cnt]['weight_unit'] = $checkInnerCargo['weight_unit'];
                        $cargos[$cargo_cnt]['volume_unit'] = $checkInnerCargo['volume_unit'];
                        $cargos[$cargo_cnt]['length_unit'] = $checkInnerCargo['length_unit'];
                        $cargos[$cargo_cnt]['width_unit'] = $checkInnerCargo['width_unit'];
                        $cargos[$cargo_cnt]['height_unit'] = $checkInnerCargo['height_unit'];
                        $cargos[$cargo_cnt]['goods_description'] = $checkInnerCargo['goods_description'];
                        $cargos[$cargo_cnt]['marks_numbers'] = $checkInnerCargo['marks_numbers'];
                        $cargos[$cargo_cnt]['item_id'] = $checkInnerCargo['item_id'];
                        $cargos[$cargo_cnt]['secondweight_uom'] = $checkInnerCargo['secondweight_uom'];
                        $cargos[$cargo_cnt]['secondvolume_uom'] = $checkInnerCargo['secondvolume_uom'];
                        $cargos[$cargo_cnt]['grounded'] = $checkInnerCargo['grounded'];
                        $cargos[$cargo_cnt]['stackable'] = $checkInnerCargo['stackable'];
                        $cargos[$cargo_cnt]['splittable'] = $checkInnerCargo['splittable'];
                        $cargos[$cargo_cnt]['dg_goods'] = $checkInnerCargo['dg_goods'];
                        $cargos[$cargo_cnt]['volweight_uom'] = $checkInnerCargo['volweight_uom'];
                    }
                    $inner_cargo_res = $ci->common->gettbldata(["cargo_id" => $res['cargo_id']], "cargo_type,goods_description,quantity,length,length_unit, width,width_unit,height,height_unit,weight,weight_unit,volume,volume_unit", "tb_inner_cargo", 0, 0);
                    $cargos[$cargo_cnt]['inner_cargo'] = $inner_cargo_res ?? [];

                    $dgCargoDetails = $ci->common->gettbldata(["order_id"=>$id,"order_cargo_id" => $res['id']], "*", "tb_order_dg_goods", 0, 0);
                    $cargos[$cargo_cnt]['dggoods'] = (!empty($dgCargoDetails)) ? $dgCargoDetails : [];

                    $cargo_cnt++;
                }
            }
        }
        return $cargos ?? [];
    }

    private function getOrderPartyDetails(int $id): array
    {
        $ci = &get_instance();
        $parties = [];
        $whereClouse = " AND o.order_id='$id' ";
        $chekparty = $ci->common->getorderpartydata($whereClouse);
        if (count($chekparty) > 0) {
            foreach ($chekparty as $rr) {
                $partydetail = [];
                $getpartyinfo = $ci->common->gettbldata(["partner_id" => $rr->id], "*", "tb_party_reference", 0, 0);
                $chktype = $ci->common->gettblrowdata(["id" => $rr->party_type], "name", "tbl_party_types", 0, 0);
                if (count($chktype) > 0) {
                    if ($rr->party_master_id != "") {
                        $cntry = $rr->pcountry;
                        if (strlen($cntry) > 2) {
                            $cntry = substr($cntry, 0, 2);
                        }
                        $pstreet = $rr->pstreet;
                        if ($pstreet == "") {
                            $pstreet = $rr->plocation_id;
                        }
                        $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->paddress, 'pincode' => $rr->ppincode, 'country' => $cntry, 'street' => $pstreet, 'city' => $rr->plocation_id, 'state' => $rr->pstate, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier, 'kn_login_account' => $rr->kn_login_account, 'party_references' => $getpartyinfo];
                    } else {
                        $cntry = $rr->country;
                        if (strlen($cntry) > 2) {
                            $cntry = substr($cntry, 0, 2);
                        }
                        $street = $rr->street;
                        if ($street == "") {
                            $street = $rr->street;
                        }
                        $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->address, 'pincode' => $rr->pincode, 'country' => $cntry, 'street' => $street, 'city' => $rr->location_id, 'state' => $rr->state, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier, 'kn_login_account' => $rr->kn_login_account, 'party_references' => $getpartyinfo];
                    }
                    $pdetail['type'] = $chktype['name'];
                    $parties[] = $pdetail;
                }
            }
        }
        return $parties;
    }

    private function getOrderCustomerDetails(int $customerId): array
    {
        $ci = &get_instance();
        if ($customerId == "") {
            return [];
        }
        $customerInfo = $ci->common->getjointbldata("`tb_customers` tc", "tbl_party_master tpm", "tc.code=tpm.code", ["tc.id" => $customerId], "tpm.id, tpm.code as cust_id, tpm.name,tpm.partyindetifier as party_id,tpm.street, tpm.street_2,tpm.street_3, tpm.email,tpm.mobile as phone,tpm.location_id AS city, tpm.address,tpm.country,tpm.state,tpm.pincode", 0, 0);
        return $customerInfo[0] ?? [];
    }

    private function getOrderTypeName(int $orderType): string
    {
        $ci = &get_instance();
        $orderTypeName = $ci->common->gettblrowdata(["id" => $orderType], "type_name", "tb_order_types", 0, 0);
        return $orderTypeName['type_name'] ?? "";
    }

    private function getOrderServiceName(int $service): string
    {
        $ci = &get_instance();
        $orderServiceName = $ci->common->gettblrowdata(["id" => $service], "name", "tb_service_master", 0, 0);
        return $orderServiceName['name'] ?? "";
    }

    private function getOrderDeliveryTermInfo(int $deliveryTerm): array
    {
        $ci = &get_instance();
        $orderTermName = $ci->common->gettblrowdata(["id" => $deliveryTerm], "`term_id`,`name`", "tb_delivery_terms", 0, 0);
        return (!empty($orderTermName)) ? $orderTermName : [];
    }

    private function getOrderAddons(int $id): array
    {
        $ci = &get_instance();
        $addonsRes = $ci->db->query("SELECT tvm.vas_name,tos.`quantity` FROM `tb_order_vas` tos LEFT OUTER JOIN `tb_vas_master` tvm ON tos.vas_id=tvm.id  WHERE tos.`order_id`=? AND tos.`status`='1'", [$id]);
        return $addonsRes->num_rows() > 0 ? $addonsRes->result_array() : [];
    }

    private function getOrderManageReferences(int $id): array
    {
        $ci = &get_instance();
        $referencesValue = $ci->db->query("SELECT reference_id,ref_value FROM tb_order_references where order_id =? AND status=?", [$id, 1]);
        return $referencesValue->num_rows() > 0 ? $referencesValue->result_array() : [];
    }
}
