<?php

class Carrierskifcargoedi
{
    private $ci;
    private $payersCodesCache = [];

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->library(['edi_engine', 'Edi_logger']);
        $this->ci->load->model(['common', 'Edi_common_model', 'Order']);
        if (!$this->ci->session->userdata('user_id')) {
            redirect('login');
        }
    }

    public function shipmentdata(int $shiftId): void
    {
        $ordersData = $orderRowIds = $triggeredOrders = $toBeTriggeredOrders = $triggeredOrdersData = [];
        if ($shiftId > 0) {
            $sql = "SELECT id,order_id,user_id,company_code,branch_code,shift_id FROM tb_orders where shift_id = ? AND status > ?";
            $getOrderIds = $this->ci->db->query($sql, [$shiftId, 0]);
            foreach ($getOrderIds->result_array() as $orders) {
                $ordersData[$orders['id']] = [
                    'bookingId' => $orders['order_id'],
                    'userId' => $orders['user_id'],
                    'companyCode' => $orders['company_code'],
                    'branchCode' => $orders['branch_code'],
                    'shiftId' => $orders['shift_id'],
                ];
                $orderRowIds[] = $orders['id'];
            }
            if (!empty($orderRowIds)) {
                $sql = "SELECT order_id FROM tb_order_references where order_id IN ? AND reference_id = ? AND status = ? GROUP BY order_id";
                $checkTriggeredStatus = $this->ci->db->query($sql, [$orderRowIds, 'RUCK', 1]);
                foreach ($checkTriggeredStatus->result_array() as $sts) {
                    $triggeredOrders[] = $sts['order_id'];
                }
            }
            if (!empty($triggeredOrders)) {
                foreach ($triggeredOrders as $singleOrderId) {
                    $bookingId = $ordersData[$singleOrderId]['bookingId'] ?? '';
                    if ($singleOrderId > 0) {
                        $triggeredOrdersData[] = [
                            'bookingId' => $bookingId,
                            'orderRowId' => $singleOrderId,
                            'companyCode' => $ordersData[$singleOrderId]['companyCode'] ?? '',
                            'branchCode' => $ordersData[$singleOrderId]['branchCode'] ?? '',
                            'userId' => $ordersData[$singleOrderId]['userId'],
                            'ediRequest' => 'SKIF API CALL',
                            'ediResponse' => 'SKIF API already Triggered for order id-' . $bookingId,
                            'status' => '0',
                        ];
                    }
                }
            } else {
                $toBeTriggeredOrders = $orderRowIds;
            }
            if (!empty($triggeredOrdersData)) {
                $this->addSkifEdiTriggeredLogs($triggeredOrdersData, 2);
                foreach ($orderRowIds as $orderId) {
                    if (!in_array($orderId, $triggeredOrders, true)) {
                        $toBeTriggeredOrders[] = $orderId;
                    }
                }
            }
            if (!empty($toBeTriggeredOrders)) {
                $this->getBulkOrderDetails($toBeTriggeredOrders);
            }
        }
    }

    public function addSkifEdiTriggeredLogs(array $ordersData, int $boundType): void
    {
        $insertData = [];
        $i = 0;
        foreach ($ordersData as $order) {
            $time = time();
            $transactionID = $time + $i;
            $insertData[] = [
                'edi_type' => 1,
                'transaction_id' => $transactionID,
                'edi_id' => 4,
                'edi_name' => 'SKIF',
                'bounded_type' => $boundType,
                'edi_format_type' => 'XML',
                'status' => $order['status'],
                'obj_type' => 1,
                'txn_obj_id' => $order['bookingId'],
                'user_id' => $order['userId'],
                'company_code' => $order['companyCode'],
                'branch_code' => $order['branchCode'],
                'edi_request' => $order['ediRequest'],
                'edi_response' => $order['ediResponse'],
            ];
            $i++;
        }
        if (!empty($insertData)) {
            $this->ci->db->insert_batch('tb_etn_edi_transactions', $insertData);
        }
    }

    public function getBulkOrderDetails(array $orderIds): void
    {
        $currentTimeZone = $this->ci->session->userdata("usr_tzone")['timezone'];
        $ordersData = $customerIds = $customerDetails = $referenceDetails = $cargos = $patries = [];
        $sql = "SELECT o.id,
                o.order_id,
                convertToClientTZ(o.pickup_datetime,'" . $currentTimeZone . "') as pickup_datetime,
                convertToClientTZ(o.pickup_endtime,'" . $currentTimeZone . "') as pickup_endtime,
                convertToClientTZ(o.delivery_datetime,'" . $currentTimeZone . "') as delivery_datetime,
                convertToClientTZ(o.drop_endtime,'" . $currentTimeZone . "') as drop_endtime,
                o.pickup_company,
                o.delivery_company,
                o.pickup_country,
                o.delivery_country,
                o.pickup_city,
                o.delivery_city,
                o.pickup_pincode,
                o.delivery_pincode,
                o.pickup_address1,
                o.delivery_address1,
                o.pickup_address2,
                o.delivery_address2,
                o.goods_value,
                o.transport_mode,
                o.customer_id,
                o.company_code,
                o.branch_code,
                o.order_status,
                o.shift_id,
                convertToClientTZ(o.createdon,'" . $currentTimeZone . "') as createdon
        FROM tb_orders o
        WHERE o.id IN ?";
        $getOrdersData = $this->ci->db->query($sql, [$orderIds]);
        foreach ($getOrdersData->result_array() as $orders) {
            $customerIds[] = $orders['customer_id'];
            $ordersData[$orders['id']] = [
                'orderRowId' => $orders['id'],
                'bookingId' => $orders['order_id'],
                'pickupDateTime' => $orders['pickup_datetime'],
                'pickupEndTime' => $orders['pickup_endtime'],
                'deliveryDateTime' => $orders['delivery_datetime'],
                'dropEndtime' => $orders['drop_endtime'],
                'pickupCompany' => $orders['pickup_company'],
                'deliveryCompany' => $orders['delivery_company'],
                'pickupCountry' => $orders['pickup_country'],
                'deliveryCountry' => $orders['delivery_country'],
                'pickupCity' => $orders['pickup_city'],
                'deliveryCity' => $orders['delivery_city'],
                'pickupPincode' => $orders['pickup_pincode'],
                'deliveryPincode' => $orders['delivery_pincode'],
                'pickupAddress1' => $orders['pickup_address1'],
                'deliveryAddress1' => $orders['delivery_address1'],
                'pickupAddress2' => $orders['pickup_address2'],
                'deliveryAddress2' => $orders['delivery_address2'],
                'goodsValue' => $orders['goods_value'],
                'transportMode' => $orders['transport_mode'],
                'customerId' => $orders['customer_id'],
                'companyCode' => $orders['company_code'],
                'branchCode' => $orders['branch_code'],
                'orderStatus' => $orders['order_status'],
                'shiftId' => $orders['shift_id'],
                'createdOn' => $orders['createdon'],
                'deliveryNote' => '',
                'pickupInstructions' => '',
                'deliveryInstructions' => '',
                'Z04' => '',
                'Z05' => '',
                'cargo_type' => '',
                'cargos' => $cargos,
                'patries' => $patries,
            ];
        }
        if (!empty($customerIds)) {
            $sql = "SELECT id,name,code FROM tb_customers WHERE id IN ? AND status =?";
            $getCustomerDetails = $this->ci->db->query($sql, [$customerIds, 1]);
            foreach ($getCustomerDetails->result_array() as $customer) {
                $customerDetails[$customer['id']] = ['name' => $customer['name'], 'code' => $customer['code']];
            }
        }
        $sql = "SELECT id,order_id,reference_id,ref_value FROM tb_order_references WHERE order_id IN ? AND reference_id IN ? AND status = ?";
        $getReferenceDetails = $this->ci->db->query(
            $sql,
            [$orderIds, ['DQ', 'ORD_PIKINST', 'ORD_DLVINST', 'Z05', 'Z04'], 1]
        );
        foreach ($getReferenceDetails->result_array() as $ref) {
            $referenceDetails[] = [
                'orderId' => $ref['order_id'],
                'referenceId' => $ref['reference_id'],
                'refValue' => $ref['ref_value'],
            ];
        }
        $this->triggerBulkOrders($ordersData, $orderIds, $customerDetails, $referenceDetails);
    }

    public function triggerBulkOrders(
        array $ordersData,
        array $orderIds,
        array $customerDetails,
        array $referenceDetails
    ): void {
        $timeZone = $this->ci->session->userdata('usr_tzone');
        $countryName = $timeZone['country_name'];
        $finalOrdersData = [];
        if (!empty($referenceDetails)) {
            $ordersData = $this->addReferenceToOrderDetails($referenceDetails, $ordersData);
        }
        $ordersData = $this->addPartyDetailsToOrderDetails($orderIds, $ordersData);
        $ordersData = $this->addCargoDetailsToOrderDetails($orderIds, $ordersData);

        foreach ($ordersData as $orders) {
            $finalOrdersData[] = [
                'SenderTransmissionNo' => $orders['bookingId'] ?? '',
                'ordernumber' => $orders['bookingId'] ?? '',
                'order_status' => $orders['orderStatus'] ?? '',
                'pickup_datetime' => $orders['pickupDateTime'] ?? '',
                'delivery_datetime' => $orders['deliveryDateTime'] ?? '',
                'pickup_endtime' => $orders['pickupEndTime'] ?? '',
                'delivery_endtime' => $orders['dropEndtime'] ?? '',
                'createdon' => $orders['createdOn'] ?? '',
                'delivery_company' => $orders['deliveryCompany'] ?? '',
                'delivery_city' => $orders['deliveryCity'] ?? '',
                'delivery_country' => $orders['deliveryCountry'] ?? '',
                'delivery_address1' => $orders['deliveryAddress1'] ?? '',
                'delivery_address2' => $orders['deliveryAddress2'] ?? '',
                'delivery_pincode' => $orders['deliveryPincode'] ?? '',
                'transport_mode' => $orders['transportMode'] ?? '',
                'pickup_country' => $orders['pickupCountry'] ?? '',
                'pickup_pincode' => $orders['pickupPincode'] ?? '',
                'pickup_company' => $orders['pickupCompany'] ?? '',
                'pickup_city' => $orders['pickupPincode'] ?? '',
                'pickup_address1' => $orders['pickupAddress1'] ?? '',
                'pickup_address2' => $orders['pickupAddress2'] ?? '',
                'cargos' => $orders['cargos'] ?? [],
                'parties' => $orders['parties'] ?? [],
                'quantity' => '1',
                'pickup_custid' => $orders['shipper_code'] ?? '',
                'drop_custid' => $orders['consignee_code'] ?? '',
                'pickup_partyid' => $orders['shipper_party_id'] ?? '',
                'drop_partyid' => $orders['conisgnee_party_id'] ?? '',
                'country_name' => $countryName,
                'cargo_type' => $orders['cargo_type'] ?? '',
                'shift_id' => $orders['shiftId'] ?? '',
                'payerCode' => $this->getPayerCode(
                    $orders, $customerDetails
                ),
                'ord_pikinst' => $orders['pickupInstructions'] ?? '',
                'ord_dlvinst' => $orders['deliveryInstructions'] ?? '',
                'documets' => $orders['deliveryNote'] ?? '',
                'z05' => $orders['Z05'] ?? '',
                'z04val' => $orders['Z04'] ?? '',
                'order_row_id' => $orders['orderRowId'] ?? '',
                'shipper_code' => $orders['shipper_code'] ?? '',
                'cargo_cost' => $orders['goodsValue'] ?? '',
                'consinee_code' => $orders['consignee_code'] ?? '',
                'consignee_phone' => $orders['consignee_phone'] ?? '',
                'consignee_email' => $orders['consignee_email'] ?? '',
                'shipper_email' => $orders['shipper_email'] ?? '',
                'shipper_phone' => $orders['shipper_phone'] ?? '',
                'shipper_address' => $orders['shipper_address'] ?? '',
                'pickup_cityy' => $orders['pickupCity'] ?? '',
                'shipper_street' => $orders['shipper_street'] ?? '',
                'shipper_name' => $orders['shipper_name'] ?? '',
                'consignee_name' => $orders['consignee_name'] ?? '',
                'devlivery_cityy' => $orders['deliveryCity'] ?? '',
            ];
        }

        foreach ($finalOrdersData as $data) {
            $this->sendxmlservice($data);
        }
    }

    public function getPayerCode(array $orders, array $customerDetails): string
    {
        if (ENVIRONMENT === 'testing') {
            return '1689339359';
        }
        $customerCode = $customerDetails[$orders['customerId']]['code'] ?? "";
        if (!$orders['customerId'] || !$customerCode) {
            return '';
        }

        return $this->payersCodesCache[$customerCode] ?? ($this->payersCodesCache[$customerCode] = $this->ci->Edi_common_model->getpayercode(
                $customerCode,
                $orders['pickupCity'],
                $orders['deliveryCity']
            ));
    }

    public function addReferenceToOrderDetails(array $referenceDetails, array $ordersData): array
    {
        foreach ($referenceDetails as $ref) {
            $orderRowID = $ref['orderId'];
            if ($ref['referenceId'] === "DQ") {
                $ordersData[$orderRowID]['deliveryNote'] = $ref['refValue'];
            }
            if ($ref['referenceId'] === "ORD_PIKINST") {
                $ordersData[$orderRowID]['pickupInstructions'] = $ref['refValue'];
            }
            if ($ref['referenceId'] === "ORD_DLVINST") {
                $ordersData[$orderRowID]['deliveryInstructions'] = $ref['refValue'];
            }
            if ($ref['referenceId'] === "Z04") {
                $ordersData[$orderRowID]['Z04'] = $ref['refValue'];
            }
            if ($ref['referenceId'] === "Z05") {
                $ordersData[$orderRowID]['Z05'] = $ref['refValue'];
            }
        }
        return $ordersData;
    }

    public function addPartyDetailsToOrderDetails(array $orderIds, array $ordersData): array
    {
        $partyNames = $partyMasters = [];
        $orderParties = $this->getOrderPartyTypes($orderIds);
        $orderPartyTypes = $orderParties['orderPartyTypes'];
        $partyTypeIds = $orderParties['partyTypeIds'];
        $partyMasterIds = $orderParties['partyMasterIds'];
        if (!empty($partyTypeIds)) {
            $partyNames = $this->getPartyTypeNamesFromId($partyTypeIds);
        }
        if (!empty($partyMasterIds)) {
            $partyMasters = $this->getPartyMasterDataFromId($partyMasterIds);
        }
        foreach ($orderPartyTypes as $parties) {
            $partyTypeId = $parties['party_type'];
            $partyMasterId = $parties['party_id'];
            $partyName = $partyNames[$partyTypeId] ?? "";
            $parties['name'] = $partyMasters[$partyMasterId]['name'] ?? "";
            $parties['email'] = $partyMasters[$partyMasterId]['email'] ?? "";
            $parties['phone'] = $partyMasters[$partyMasterId]['mobile'] ?? "";
            $parties['cust_id'] = $partyMasters[$partyMasterId]['code'] ?? "";
            $parties['party_id'] = $partyMasters[$partyMasterId]['partyindetifier'] ?? "";
            $orderParties[] = $parties;
            $orderRowId = $parties['order_id'];
            switch ($partyName) {
                case 'Consignee':
                case 'Consignor':
                case 'Shipper':
                case 'Carrier':
                    $parties['type'] = $partyName;
                    break;
                case 'FREIGHT_PAYER':
                    $parties['type'] = "PF";
                    break;
                default:
                    $parties['type'] = 'Shipper';
            }

            if ($parties['type'] === "Shipper") {
                $parties['street'] = $ordersData[$orderRowId]['pickupAddress1'] ?? $partyMasters[$partyMasterId]['street'];
                $parties['city'] = $ordersData[$orderRowId]['pickupCity'] ?? $partyMasters[$partyMasterId]['city'];
                $parties['state'] = $ordersData[$orderRowId]['pickupAddress2'] ?? $partyMasters[$partyMasterId]['state'];
                $parties['pincode'] = $ordersData[$orderRowId]['pickupPincode'] ?? $partyMasters[$partyMasterId]['pincode'];
                $parties['country'] = $ordersData[$orderRowId]['pickupCountry'] ?? $partyMasters[$partyMasterId]['country'];
                $address = $parties['street'] . "," . $parties['city'] . "," . $parties['state'] . "," . $parties['country'];
                $parties['address'] = $address;
                $ordersData[$orderRowId]['shipper_code'] = $parties['cust_id'];
                $ordersData[$orderRowId]['shipper_phone'] = $parties['phone'];
                $ordersData[$orderRowId]['shipper_email'] = $parties['email'];
                $ordersData[$orderRowId]['shipper_address'] = $partyMasters[$partyMasterId]['address'] ?? '';
                $ordersData[$orderRowId]['shipper_street'] = $partyMasters[$partyMasterId]['street'] ?? '';
                $ordersData[$orderRowId]['shipper_name'] = $parties['name'];
                $ordersData[$orderRowId]['shipper_party_id'] = $parties['party_id'];

            } elseif ($parties['type'] === "Consignee") {
                $parties['street'] = $ordersData[$orderRowId]['deliveryAddress1'] ?? $partyMasters[$partyMasterId]['street'];
                $parties['city'] = $ordersData[$orderRowId]['deliveryCity'] ?? $partyMasters[$partyMasterId]['city'];
                $parties['state'] = $ordersData[$orderRowId]['deliveryAddress2'] ?? $partyMasters[$partyMasterId]['state'];
                $parties['pincode'] = $ordersData[$orderRowId]['pickupPincode'] ?? $partyMasters[$partyMasterId]['pincode'];
                $parties['country'] = $ordersData[$orderRowId]['deliveryPincode'] ?? $partyMasters[$partyMasterId]['country'];
                $address = $parties['street'] . "," . $parties['city'] . "," . $parties['state'] . "," . $parties['country'];
                $parties['address'] = $address;
                $ordersData[$orderRowId]['consignee_code'] = $parties['cust_id'];
                $ordersData[$orderRowId]['consignee_phone'] = $parties['phone'];
                $ordersData[$orderRowId]['consignee_email'] = $parties['email'];
                $ordersData[$orderRowId]['consignee_address'] = $partyMasters[$partyMasterId]['address'] ?? '';
                $ordersData[$orderRowId]['consignee_street'] = $partyMasters[$partyMasterId]['street'] ?? '';
                $ordersData[$orderRowId]['consignee_name'] = $parties['name'];
                $ordersData[$orderRowId]['conisgnee_party_id'] = $parties['party_id'];

            } else {
                $parties['country'] = $partyMasters[$partyMasterId]['country'] ?? "";
                $parties['state'] = $partyMasters[$partyMasterId]['state'] ?? "";
                $parties['street'] = $partyMasters[$partyMasterId]['street'] ?? "";
                $parties['pincode'] = $partyMasters[$partyMasterId]['pincode'] ?? "";
                $parties['address'] = $partyMasters[$partyMasterId]['address'] ?? "";
                $parties['city'] = $partyMasters[$partyMasterId]['city'] ?? "";
            }
            $ordersData[$orderRowId]['parties'][] = $parties;
        }

        return $ordersData;
    }

    public function getOrderPartyTypes(array $orderIds): array
    {
        $orderPartyTypes = $partyTypeIds = $partyMasterIds = [];
        $sql = "SELECT id,order_id,party_id,party_type FROM tb_order_parties WHERE order_id IN ? AND status = ?";
        $getPartyDetails = $this->ci->db->query($sql, [$orderIds, 1]);
        foreach ($getPartyDetails->result_array() as $res) {
            $partyMasterIds[] = $res['party_id'];
            $partyTypeIds[] = $res['party_type'];
            $orderPartyTypes[] = [
                'order_id' => $res['order_id'],
                'party_id' => $res['party_id'],
                'party_type' => $res['party_type'],
            ];
        }

        return [
            'orderPartyTypes' => $orderPartyTypes,
            'partyTypeIds' => $partyTypeIds,
            'partyMasterIds' => $partyMasterIds,
        ];
    }

    public function getPartyTypeNamesFromId(array $partyTypeIds): array
    {
        $partyNames = [];
        $sql = "SELECT id,name FROM tbl_party_types WHERE id IN ? AND status =?";
        $getPartyNames = $this->ci->db->query($sql, [$partyTypeIds, 1]);
        foreach ($getPartyNames->result_array() as $res) {
            $partyNames[$res['id']] = $res['name'];
        }
        return $partyNames;
    }

    public function getPartyMasterDataFromId(array $partyMasterIds): array
    {
        $partyMasters = [];
        $sql = "SELECT id,party_type_id,name,email,mobile,code,partyindetifier,address,location_id,country,state,street,pincode
                FROM tbl_party_master
                WHERE id IN ? AND status = ?";

        $getPartyMasterDetails = $this->ci->db->query($sql, [$partyMasterIds, 1]);
        foreach ($getPartyMasterDetails->result_array() as $res) {
            $partyMasters[$res['id']] = [
                'name' => $res['name'],
                'email' => $res['email'],
                'mobile' => $res['mobile'],
                'code' => $res['code'],
                'partyindetifier' => $res['partyindetifier'],
                'country' => $res['country'],
                'state' => $res['state'],
                'street' => $res['street'],
                'pincode' => $res['pincode'],
                'city' => $res['location_id'],
                'address' => $res['address'],
            ];
        }
        return $partyMasters;
    }

    public function addCargoDetailsToOrderDetails(array $orderIds, array $ordersData): array
    {
        $sql = "SELECT order_id,cargo_id,handling_unit,length,width,height,weight,volume,quantity,quantity_type,cargo_content
                FROM tb_order_cargodetails
                WHERE order_id IN ? AND status = ?";

        $getCargodetails = $this->ci->db->query($sql, [$orderIds, 1]);
        foreach ($getCargodetails->result_array() as $res) {
            $orderRowId = $res['order_id'];
            $ordersData[$orderRowId]['cargo_type'] = $res['quantity_type'];
            $ordersData[$orderRowId]['cargos'][] = [
                'cargo_type' => $res['quantity_type'],
                'content' => $res['cargo_content'],
                'length' => $res['length'],
                'width' => $res['width'],
                'height' => $res['height'],
                'weight' => $res['weight'],
                'volume' => $res['volume'],
                'quantity' => $res['quantity'],
            ];
        }
        return $ordersData;
    }

    /* send shipment data */
    public function shipmentdataold(int $shiftId): void
    {
        if ($shiftId > 0) {
            $getOrderIds = $this->ci->common->gettbldata(
                ['shift_id' => $shiftId, 'status !=' => 0],
                'id,order_id',
                'tb_orders',
                0,
                0
            );
            if (!empty($getOrderIds)) {
                foreach ($getOrderIds as $res) {
                    $checkTrigger = $this->ci->edi_engine->checkTrigerStatus($res['id']);
                    if (!$checkTrigger) {
                        $this->triggerAPI($res['id'], $shiftId);
                    } else {
                        $this->ci->edi_logger->log_skif_order(
                            '0',
                            'SKIF API CALL',
                            'SKIF API already Triggered for order id-' . $res['order_id'],
                            $res['order_id'],
                            2
                        );
                    }
                }
            } else {
                $this->ci->edi_logger->log_skif_order(
                    '0',
                    'SKIF API CALL',
                    'SKIF API- Order ids not found for shift id - ' . $shiftId,
                    0,
                    2
                );
            }
        }
    }

    public function triggerAPI($order_row_id, $shiftId): void
    {
        $documents = [];
        $data = [];
        $cargos = [];
        $cargo_type = '';
        $quantity = 1;
        $ord_pikinst = '';
        $ord_dlvinst = '';
        $id = $order_row_id;
        $pickupid = $order_row_id;
        $shipper_name = '';
        $shipper_email = '';
        $shipper_phone = '';
        $shipper_address = '';
        $shipper_street = '';
        $shipper_code = '';
        $consignee_name = '';
        $consinee_code = '';
        $consignee_phone = '';
        $consignee_email = '';
        $chkorder = $this->ci->Order->getordertoedit($id);
        if (empty($chkorder->row())) {
            $this->ci->edi_logger->log_skif_order(
                '0',
                'SKIF API CALL',
                'SKIF API- Order ids not found for shift id -' . $id,
                $id,
                2
            );
        } else {
            $orderid = $chkorder->row()->order_id;
            $devlivery_cityy = $chkorder->row()->delivery_city;
            $drop_endtimee = $chkorder->row()->drop_endtime;
            $delivery_datetimee = $chkorder->row()->delivery_datetime;
            $delivery_pincodee = $chkorder->row()->delivery_pincode;
            $delivery_companyy = $chkorder->row()->delivery;
            $drop_partyidd = $chkorder->row()->drop_partyid;
            $drop_custidd = $chkorder->row()->drop_custid;
            $pickup_cityy = $chkorder->row()->pickup_city;
            $pickup_datetime = $chkorder->row()->pickup_datetime;
            $pickup_endtime = $chkorder->row()->pickup_endtime;
            $goods_value = $chkorder->row()->goods_value;
            $zonecode = $this->ci->session->userdata('usr_tzone');
            $curtz = $zonecode['timezone'];
            $pickup_datetime = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
            $pickup_datetime = $pickup_datetime['datetime'];
            $pickup_endtime = getdatetimebytimezone($curtz, $pickup_endtime, DFLT_TZ);
            $pickup_endtime = $pickup_endtime['datetime'];
            $delivery_datetimee = getdatetimebytimezone($curtz, $delivery_datetimee, DFLT_TZ);
            $delivery_datetime = $delivery_datetimee['datetime'];
            $drop_endtimee = getdatetimebytimezone($curtz, $drop_endtimee, DFLT_TZ);
            $delivery_endtime = $drop_endtimee['datetime'];
            $pickup_details = $this->ci->common
                ->gettbldata([
                    'order_id' => $pickupid,
                ], 'reference_id,ref_value', 'tb_order_references', 0, 0);
            foreach ($pickup_details as $res) {
                if ($res['reference_id'] === 'ORD_PIKINST') {
                    $ord_pikinst = $res['ref_value'];
                }
                if ($res['reference_id'] === 'ORD_DLVINST') {
                    $ord_dlvinst = $res['ref_value'];
                }
            }

            $documet = $this->ci->common
                ->gettbldata([
                    'order_id' => $id,
                    'reference_id' => 'DQ',
                ], 'id,ref_value', 'tb_order_references', 0, 0);
            foreach ($documet as $res) {
                $documents = $res['ref_value'];
            }

            if (ENVIRONMENT === 'testing') {
                $payerCode = '1689339359';
            } else {
                $cuse_code = $this->ci->Edi_common_model
                    ->getCustomercode($id);
                $payerCode = $this->ci->Edi_common_model
                    ->getpayercode($cuse_code, $pickup_cityy, $devlivery_cityy);
                $chkorder = $this->ci->Order
                    ->getordertoedit($id);
            }

            if ($chkorder->num_rows() > 0) {
                $customer_id = $chkorder->row()->customer_id;
                $pickup_country = $chkorder->row()->pickup_country;
                $delivery_country = $chkorder->row()->delivery_country;
                $zonecode = $this->ci->session->userdata('usr_tzone');
                $curtz = $zonecode['timezone'];
                $cntryname = $zonecode['country_name'];
                $createdon = $chkorder->row()->createdon;
                $updatedon = $chkorder->row()->updatedon;
                $getactual = getdatetimebytimezone($curtz, $createdon, DFLT_TZ);
                $curdt = $getactual['datetime'];
                $parties = [];
                $whr = " AND o.order_id='$id' ";
                $chekparty = $this->ci->common->getorderpartydata($whr);

                if (count($chekparty) > 0) {
                    foreach ($chekparty as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->ci->common
                            ->gettblrowdata([
                                'id' => $ptype,
                            ], 'name', 'tbl_party_types', 0, 0);
                        if (count($chktype) > 0) {
                            if ($rr->party_master_id !== '') {
                                $cntry = $rr->pcountry;
                                if (strlen($cntry) > 2) {
                                    $cntry = substr($cntry, 0, 2);
                                }
                                $pstreet = $rr->pstreet;
                                if ($pstreet === '') {
                                    $pstreet = $rr->plocation_id;
                                }
                                $pdetail = [
                                    'name' => $rr->name,
                                    'cust_id' => $customer_id,
                                    'address' => $rr->paddress,
                                    'pincode' => $rr->ppincode,
                                    'country' => $cntry,
                                    'street' => $pstreet,
                                    'city' => $rr->plocation_id,
                                    'state' => $rr->pstate,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'party_id' => $rr->partyindetifier,
                                ];
                            } else {
                                $cntry = $rr->country;
                                if (strlen($cntry) > 2) {
                                    $cntry = substr($cntry, 0, 2);
                                }
                                $street = $rr->street;
                                if ($street === '') {
                                    $street = $rr->street;
                                }
                                $pdetail = [
                                    'name' => $rr->name,
                                    'cust_id' => $rr->code,
                                    'address' => $rr->address,
                                    'pincode' => $rr->pincode,
                                    'country' => $cntry,
                                    'street' => $street,
                                    'city' => $rr->location_id,
                                    'state' => $rr->state,
                                    'phone' => $rr->mobile,
                                    'email' => $rr->email,
                                    'party_id' => $rr->partyindetifier,
                                ];
                            }

                            switch ($chktype['name']) {
                                case 'Consignee':
                                case 'Consignor':
                                case 'Shipper':
                                case 'Carrier':
                                    $pdetail['type'] = $chktype['name'];
                                    break;
                                case 'FREIGHT_PAYER':
                                    $pdetail['type'] = 'PF';
                                    break;
                                default:
                                    $pdetail['type'] = 'Shipper';
                            }

                            $parties[] = $pdetail;
                        }
                    }
                }

                $getcargos = $this->ci
                    ->common
                    ->gettbldata(
                        [
                            'order_id' => $id,
                            'status' => 1,
                        ],
                        "cargo_id, handling_unit, length, width, height,
                        weight, volume, quantity,quantity_type,cargo_content,qr_code,volumetric_weight",
                        'tb_order_cargodetails',
                        0,
                        0
                    );

                if (count($getcargos) > 0) {
                    foreach ($getcargos as $res) {
                        $volume = $res['volume'];
                        $weight = $res['weight'];

                        $weight_unit = 'KG';
                        $volume_unit = 'CBM';
                        if ($res['cargo_id'] !== '') {
                            $chk = $this->ci
                                ->common
                                ->gettblrowdata([
                                    'id' => $res['cargo_id'],
                                ], 'cargo_type,handling_unit,weight_unit,volume_unit', 'tb_cargo_details', 0, 0);
                            if (count($chk) > 0) {
                                if ($chk['cargo_type'] !== '') {
                                    $cargo_type = $chk['cargo_type'];
                                }
                                if ($chk['handling_unit'] !== '') {
                                    $cargo_type = $chk['handling_unit'];
                                }
                                $weight_unit = $chk['weight_unit'];
                                $volume_unit = $chk['volume_unit'];
                            }
                        }
                        $content = $res['cargo_content'] ?? '';
                        $cargos[] = [
                            'cargo_type' => $res['quantity_type'],
                            'content' => $content,
                            'length' => $res['length'],
                            'width' => $res['width'],
                            'height' => $res['height'],
                            'weight' => $weight,
                            'volume' => $volume,
                            'quantity' => $res['quantity'],
                            'weight_unit' => $weight_unit,
                            'volume_unit' => $volume_unit,
                            'qr_code' => $res['qr_code'],
                        ];
                    }
                }
                $party_master_id_consinee = $this
                    ->ci->Edi_common_model->getOrderParitesId('Consignee', $order_row_id);
                $consignee_get = $this->ci->common
                    ->gettblrowdata([
                        'id' => $party_master_id_consinee,
                    ], 'code,name,mobile,email,address,street', 'tbl_party_master', 0, 0);
                if (count($consignee_get) > 0) {
                    $consignee_phone = $consignee_get['mobile'];
                    $consignee_email = $consignee_get['email'];
                    $consinee_code = $consignee_get['code'];
                    $consignee_name = $consignee_get['name'];
                } else {
                    $this->ci->edi_logger->log_skif_order(
                        '0',
                        'SKIF API CALL',
                        'SKIF API- consigne details not found',
                        $orderid,
                        2
                    );
                }
                $party_master_id_shippr = $this
                    ->ci->Edi_common_model->getOrderParitesId('Shipper', $order_row_id);
                $get_shipper_cid = $this->ci->common
                    ->gettblrowdata([
                        'id' => $party_master_id_shippr,
                    ], 'name,code,mobile,email,address,street', 'tbl_party_master', 0, 0);
                if (count($get_shipper_cid) > 0) {
                    $shipper_code = $get_shipper_cid['code'];
                    $shipper_phone = $get_shipper_cid['mobile'];
                    $shipper_email = $get_shipper_cid['email'];
                    $shipper_address = $get_shipper_cid['address'];
                    $shipper_street = $get_shipper_cid['street'];
                    $shipper_name = $get_shipper_cid['name'];
                } else {

                    log_message( 'Error', 'Shipper details not found' );


                }

                //Docs
                $z05val = '';
                $z05 = $this->ci
                    ->common
                    ->gettblrowdata([
                        'order_id' => $order_row_id,
                        'reference_id' => 'Z05',
                        'status' => 1,
                    ], 'ref_value', 'tb_order_references', 1, 0);
                if (count($z05) > 0) {
                    $z05val = $z05['ref_value'];
                }
                $z04val = '';
                $z04 = $this->ci
                    ->common
                    ->gettblrowdata([
                        'order_id' => $order_row_id,
                        'reference_id' => 'Z04',
                        'status' => 1,
                    ], 'ref_value', 'tb_order_references', 1, 0);
                if (count($z04) > 0) {
                    $z04val = $z04['ref_value'];
                }
                $data = [
                    'SenderTransmissionNo' => $chkorder->row()->order_id,
                    'ordernumber' => $orderid,
                    'order_status' => $chkorder->row()->order_status,
                    'pickup_datetime' => $pickup_datetime,
                    'delivery_datetime' => $delivery_datetime,
                    'pickup_endtime' => $pickup_endtime,
                    'delivery_endtime' => $delivery_endtime,
                    'createdon' => $curdt,
                    'delivery_company' => $delivery_companyy,
                    'delivery_city' => $chkorder->row()->delivery_city,
                    'delivery_country' => $delivery_country,
                    'delivery_address1' => $chkorder->row()->delivery_address1,
                    'delivery_address2' => $chkorder->row()->delivery_address2,
                    'delivery_pincode' => $delivery_pincodee,
                    'transport_mode' => $chkorder->row()->transport_mode,
                    'pickup_country' => $pickup_country,
                    'pickup_pincode' => $chkorder->row()->pickup_pincode,
                    'pickup_company' => $chkorder->row()->pickup,
                    'pickup_city' => $chkorder->row()->pickup_city,
                    'pickup_address1' => $chkorder->row()->pickup_address1,
                    'pickup_address2' => $chkorder->row()->pickup_address2,
                    'cargos' => $cargos,
                    'parties' => $parties,
                    'quantity' => $quantity,
                    'pickup_custid' => $chkorder->row()->pickup_custid,
                    'drop_custid' => $drop_custidd,
                    'pickup_partyid' => $chkorder->row()->pickup_partyid,
                    'drop_partyid' => $drop_partyidd,
                    'country_name' => $cntryname,
                    'cargo_type' => $cargo_type,
                    'shift_id' => $shiftId,
                    'payerCode' => $payerCode,
                    'ord_pikinst' => $ord_pikinst,
                    'ord_dlvinst' => $ord_dlvinst,
                    'documets' => $documents,
                    'z05' => $z05val,
                    'z04val' => $z04val,
                    'order_row_id' => $order_row_id,
                    'shipper_code' => $shipper_code,
                    'cargo_cost' => $goods_value,
                    'consinee_code' => $consinee_code,
                    'consignee_phone' => $consignee_phone,
                    'consignee_email' => $consignee_email,
                    'shipper_email' => $shipper_email,
                    'shipper_phone' => $shipper_phone,
                    'shipper_address' => $shipper_address,
                    'pickup_cityy' => $pickup_cityy,
                    'shipper_street' => $shipper_street,
                    'shipper_name' => $shipper_name,
                    'consignee_name' => $consignee_name,
                    'devlivery_cityy' => $devlivery_cityy,
                ];
            }
            $this->sendxmlservice($data);
        }
    }

    public function sendxmlservice(array $data):void
    {
        $request = '<SkifCargo>
            <request>
                <ClientOrderNo>' . $data['SenderTransmissionNo'] . '</ClientOrderNo>
                <PickCargo> 1 </PickCargo>
                <PickComment>' . $this->cleanComment($data['ord_pikinst']) . '</PickComment>
                <PCTime>' . date("d.m.Y H:i", strtotime($data['pickup_datetime'])) . '</PCTime>
                <PCTimeEnd> ' . date("d.m.Y H:i", strtotime($data['pickup_endtime'])) . '</PCTimeEnd>';
        if (!empty($data['parties'])) {
            $request .= '<RecipTown>' . $data['devlivery_cityy'] . '</RecipTown>';
            $request .= '<RecipId>' . $data['consinee_code'] . '</RecipId>';
            $request .= '<RecipName>' . $data['consignee_name'] . '</RecipName>';
            $request .= '<RecipContact></RecipContact>';
            $request .= '<RecipPhone>' . $data['consignee_phone'];
            $request .= $data['z05']!=='' ? ',' . $data['z05'] : '';
            $request .= '</RecipPhone>';
            $request .= '<RecipEmail>' . $data['consignee_email'] . '</RecipEmail>';
            $request .= '<DelivCargo>1</DelivCargo>';
            $request .= '<DelivComment>' . $this->cleanComment($data['ord_dlvinst']) . ' </DelivComment>';
            $request .= '<DelivAddress>' . $this->extractDeliveryAddressFromParties($data['parties']) . '</DelivAddress>';
        }

        $request .= '<DCTime>' . date("d.m.Y H:i", strtotime($data['delivery_datetime'])) . '</DCTime>';
        $request .= '<DCTimeEnd>' . date("d.m.Y H:i", strtotime($data['delivery_endtime'])) . '</DCTimeEnd>';

        $totqty = $totwg = $totvol = 0;
        $out = [];

        foreach ($data['cargos'] as $info) {
            if ($info['content'] !== "") {
                $out[] = "" . $info['content'];
            }
            $totqty += $info['quantity'];
            $totwg += $info['weight'];
            $totvol += $info['volume'] !== "" ? $info['volume'] : 0;
        }

        $request .= '<PackagesSummary>';
        $request .= '<Weight>' . $totwg . '</Weight>';
        $request .= '<Volume>' . $totvol . '</Volume>';
        $request .= '<PlaceCount>' . $totqty . '</PlaceCount>';
        $request .= '</PackagesSummary>';
        $request .= '<CargoCost>' . $data['cargo_cost'] . '</CargoCost>';
        $request .= '<CargoContent>' . implode(', ', $out) . '</CargoContent>';
        $request .= '<SenderTownName>' . $data['pickup_cityy'] . '</SenderTownName>';
        $request .= '<SenderCode>' . $data['shipper_code'] . '</SenderCode>';
        $request .= '<SenderName>' . $data['shipper_name'] . '</SenderName>';
        $request .= '<SenderContact></SenderContact>';
        $request .= '<SenderPhone>' . $data['shipper_phone'];
        $request .= $data['z05'] !== "" ? ', ' . $data['z05'] : '';
        $request .= '</SenderPhone>';
        $request .= '<SenderEmail>' . $data['shipper_email'] . '</SenderEmail>';
        $request .= '<PickAddress>' . $data['shipper_street'] . '</PickAddress>';
        $request .= '<PayerTownName>Москва</PayerTownName>';
        $request .= '<PayerCode>' . $data['payerCode'] . '</PayerCode>';
        $request .= '<PayerName>Общество с ограниченной ответственностью "Кюне+Нагель</PayerName>';
        $request .= '<PayerINN>7710431565</PayerINN>';
        $request .= '<SenderDopInfo>' . $this->cleanComment($data['ord_pikinst']) . '</SenderDopInfo>';
        $request .= '<RecipDopInfo>' . $this->cleanComment($data['ord_dlvinst']) . '</RecipDopInfo>';

        $request .= '<Packages>';
        if ($data['z04val'] !== '') {
            $z04val = $data['z04val'];
            $z04Split = explode(',', $z04val);
            foreach ($z04Split as $z04val) {
                $request .= '<Box>';
                $request .= '<ProductCode>x</ProductCode>';
                $request .= '<ProductName>x</ProductName>';
                $request .= '<ProductCost>0</ProductCost>';
                $request .= '<BoxBarCode>' . $z04val . '</BoxBarCode>';
                $request .= '</Box>';
            }
        }
        $request .= '</Packages>';

        if ($this->hasDocuments($data['documets'])) {
            $request .= $this->buildDocumentsSection($data['documets']);
        }
        $request .= '</request></SkifCargo>';

        $this->dispatchSoapRequest($request, $data);
    }

    private function cleanComment(string $comment): string {
        return str_ireplace([
            '\'',
            '"',
            ', ',
            ';
            ',
            '<',
            '>',
            '&',
        ], ' ', $comment);
    }

    private function extractDeliveryAddressFromParties (array $parties):string {
        foreach ($parties as $res1) {
            if ($res1['type'] === "Consignee") {
                $address = $res1['address'];
                $street = $res1['street'];
            }
        }
        return ($address ?? '') .', '.($street ?? '');
    }

    private function hasDocuments(string $doc):bool {
        return (strpos($doc, 'TTH:') !== false)
            || (strpos($doc, 'ТТН:') !== false)
            || (strpos($doc, 'ТОРГ-12:') !== false);
    }

    private function buildDocumentsSection(string $docs):string {
        $request = '';

        $docsSplit = explode(';', $docs);
        if (count($docsSplit) === 1) {

            // do not remove second condition - strings are NOT equal
            // 1st ASCII: 84 84 72 58
            // 2nd ASCII: 208 162 208 162 208 157 58 32
            if ((strpos($docs, 'TTH:') !== false) || strpos($docs, 'ТТН: ') !== false) {
                $docs .= strpos($docs, ';') !== false ? '' :  ' ;';
            } else {
                $docs = ';' . $docs;
            }
            if (strpos($docs, 'ТОРГ-12:') !== false) {
                $docs .= strpos($docs, ';') !== false ? '' : ' ;';
            }
        }

        $docsSplit = explode(';', $docs);
        if (count($docsSplit) !== 1) {
            $tth_array = explode(',', $docsSplit[0]);
            $t12_array = explode(',', $docsSplit[1]);
            if ($tth_array[0] !== '') {
                foreach ($tth_array as $tth) {
                    $tth_trimval = str_replace('ТТН: ', '', trim($tth));

                    $request .= '<DocSet>
                                <TTNDocNo>' . str_replace('TTH: ', '', trim($tth_trimval)) . '</TTNDocNo>
                                 <DocSumm> 0</DocSumm>
                                </DocSet>';
                }
            }
            if ($t12_array[0] !== '') {
                foreach ($t12_array as $t12) {
                    $request .= '<DocSet>
                                <T12DocNo>' . str_replace('ТОРГ-12:', '', $t12) . '</T12DocNo>
                                 <DocSumm>0</DocSumm>
                                </DocSet>';
                }
            }
        }

        return '<SenderDocuments>'.$request.'</SenderDocuments>';
    }

    /**
     * @throws SoapFault
     * @throws JsonException
     */
    private function dispatchSoapRequest(string $request, array $data): void
    {
        $client = new SoapClient(
            SKIF_SERVER_IP,
            [
                'login' => SKIF_LOGIN,
                'proxy_host' => KN_PROXY_DNS,
                'proxy_port' => KN_PROXY_PORT,
                'password' => SKIF_PASSWORD,
                'soap_version' => SOAP_1_2,
                'cache_wsdl' => WSDL_CACHE_NONE,
                'exceptions' => true,
                'trace' => 1,
            ]
        );
        $XMLString = $request;
        $params = ['XMLString' => $XMLString];
        $XMLString = $client->CreateOrder($params);
        $xml = simplexml_load_string($XMLString->return);
        $json = json_encode($xml, JSON_THROW_ON_ERROR);
        $array = json_decode($json, true, 512, JSON_THROW_ON_ERROR);
        $stat = 0;

        if ($array['ProcResult'] === '0') {
            $this->ci->common->insertTableData('tb_order_references', [
                'ref_value' => $array['OrderNo'],
                'reference_id' => 'RUCK',
                'order_id' => $data['order_row_id'],
                'createdon' => date('Y-m-d h:i:s'),
            ]);
            $this->ci->common->insertTableData('tb_order_references', [
                'ref_value' => $array['OrderShortNo'],
                'reference_id' => 'RUCKSN',
                'order_id' => $data['order_row_id'],
                'createdon' => date('Y-m-d h:i:s'),
            ]);
            $stat = 1;
        }

        $this->ci->edi_logger->log_skif_order($stat, $request, $json, $data['ordernumber'], 2);
    }
}
