<?php

class Carrierstandardtripoutbound
{
    private $ci;
    private const GRAMS_ARRAY = ["G", "Gms", "gms", "grm"];
    private const KILOGRAMS_ARRAY = ["Kg", "kg"];
    private const TONS_ARRAY = ["Tons", "tons"];

    public function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(["common", "carriercommonmodel"]);
        $ci->load->helper("cleanstr_helper");
        $ci->load->library(["Edi_logger"]);
    }

    public function shipmentdata(int $shipmentNumber, string $functionCode = "I"): int
    {
        if ($shipmentNumber == "") {
            log_message("error", "There is no Shipmentid");
            return "There is no Shipmentid";
        }
        $data = $tripdata = [];
        $ci = &get_instance();
        $ci->session->unset_userdata('carrier_trip_outbound');
        $tripdetails = $ci->common->gettblrowdata(["id" => $shipmentNumber], "id,shipmentid,company_code,branch_code,department_code,shift_leg_id,user_id", "tb_shifts", 0, 0);
        $tripdata['shipmentid'] = $tripdetails['shipmentid'];
        $tripdata['company_code'] = $company_code = $tripdetails['company_code'];
        $tripdata['branch_code'] = $branch_code = $tripdetails['branch_code'];
        $tripdata['department_code'] = $department_code = $tripdetails['department_code'];
        $ci->edi_logger->setEdi_type(1);
        $ci->edi_logger->setTxn_obj_id($tripdetails['shipmentid']);
        $ci->edi_logger->setUser_id($tripdetails['user_id']);
        $ci->edi_logger->setCompany_code($company_code);
        $ci->edi_logger->setBranch_code($branch_code);
        $ci->edi_logger->setTransaction_id(time());
        $ci->edi_logger->setEdi_id("38");
        $ci->edi_logger->setEdi_name('Trip Outbound');
        $ci->edi_logger->setBounded_type(2);


        $orderUserTimeZone = $ci->carriercommonmodel->getOrderUserTimeZone($tripdetails['user_id'] ?? "231");
        $curtz = $orderUserTimeZone['cntry_timezone'];
        $code = $orderUserTimeZone['phone_code'];

        $tripdata['vendordetails'] = $ci->carriercommonmodel->getShipmentCarrier($shipmentNumber);
        $tripdata['vendordetails']['phone_code'] = $code;
        $carrierID = $tripdata['vendordetails']['id'];
        $getCarrierEDIIfo = $ci->carriercommonmodel->getCarrierEDIDetails($carrierID);
        if (empty($getCarrierEDIIfo)) {
            log_message("error", "Carrier Does not have permission for shipment:" . $tripdetails['shipmentid']);
            return 0;
        }

        $tripdata['tripStops'] = $ci->carriercommonmodel->getShipmentStops($shipmentNumber, $orderUserTimeZone['phone_code']);

        $tripdata['trucks_data'] = $ci->carriercommonmodel->getshipmentVehicleInfo($shipmentNumber);

        if (!empty($tripdata['trucks_data'])) {
            $driver_data = $ci->carriercommonmodel->getshipmentAssignDeiver($shipmentNumber, $orderUserTimeZone['phone_code']);
            $driver_data['phone_code'] = $code;
        }
        $tripdata['driver_data'] = $driver_data ?? [];

        $ShipmentOrders = $this->getShipmentOrders($shipmentNumber, $code, $curtz);

        $tripdata['vendordetails']['additioncontacts'] = $this->carrierAdditionalContacts($ShipmentOrders);

        $tripdata['PhysicalReceiver'] = $ShipmentOrders[0]['physicalreceiver'] ?? "";
        $tripdata['LogicalReceiver'] = $ShipmentOrders[0]['logicalreceiver'] ?? "";
        $tripdata['PhysicalSender'] = $ShipmentOrders[0]['physicalsender'] ?? "";
        $LogicalSender = $ShipmentOrders[0]['logicalsender'] ?? "";
        if ($LogicalSender != "") {
            $logicalinfo = $ci->common->gettblrowdata(['branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
            if (count($logicalinfo) > 0) {
                $LogicalSender = $logicalinfo['logical_sender'];
            }
        }
        $tripdata['LogicalSender'] = $LogicalSender;

        $total_volume = $total_quantity = 0;
        $totalweightGrms = $totalweightKgs = $totalweighttons = 0;
        foreach ($ShipmentOrders as $order) {
            if ($order['gross_weight_uom'] == "G" || $order['gross_weight_uom'] == "gms") {
                $totalweightGrms += $order['weight'];
            }
            if ($order['gross_weight_uom'] == "kg" || $order['gross_weight_uom'] == "KGM" || $order['gross_weight_uom'] == "Kgs") {
                $totalweightKgs += $order['weight'];
            }
            if ($order['gross_weight_uom'] == "Tons") {
                $totalweighttons += $order['weight'];
            }
            $total_volume += $order['volume'];
            $total_quantity += $order['quantity'];
        }
        $total_weight = ($totalweightKgs + ($totalweightGrms / 1000) + ($totalweighttons / 1000));

        $tripdata['total_volume'] = $total_volume ?? "0.0";
        $tripdata['total_weight'] = $total_weight ?? "0.0";
        $tripdata['total_quantity'] = $total_quantity;
        $tripdata['weight_unit'] = "KG";
        $tripdata['volume_unit'] = "CBM";

        $data['tripdetails'] = $tripdata;
        $data['ordersdetails'] = $ShipmentOrders;
        if ($functionCode == "CA") {
            $functionCode = $this->checkTripStatus($shipmentNumber, $functionCode);
        }
        $tripXMl = $this->generateTripXML($data, $functionCode);
        $ci->edi_logger->setEdi_request($tripXMl);
        $sendingStatus = $this->sendTollXML($tripXMl, $carrierID, $data);
        $triggeringStatus = "0";
        if ($sendingStatus != "Service execution failed." && $sendingStatus != "") {
            $ci->common->updatetbledata("tb_trips", ['is_carrier_edi_sent' => 1], ['shift_id' => $shipmentNumber]);
            $triggeringStatus = "1";
            log_message("error", "Trip Notification XML to Carrier Successfully Triggered: " . $tripdetails['shipmentid']);
        } else {
            echo "EDI Triggering Failed with Carrier: " . $sendingStatus;
            log_message("error", "Trip Notification XML to Carrier Triggering Failed: " . $sendingStatus . " : " . $tripdetails['shipmentid']);
        }
        $ci->edi_logger->setEdi_format_type('XML');
        $ci->edi_logger->setEdi_response($sendingStatus);
        $ci->edi_logger->setObj_type_name('Trip Outbound');
        $ci->edi_logger->setStatus(($triggeringStatus === '1' ? 1 : 0));
        $ci->edi_logger->saveToEdiLogs();
        return $triggeringStatus;
    }

    private function generateTripXML(array $data, string $functionCode): string
    {
        $action = "I";
        if ($functionCode == "UP") {
            $action = "U";
        }
        if ($functionCode == "CA") {
            $action = "D";
        }
        if ($functionCode == "DL") {
            $action = "D";
        }
        $tansctionno = Date("Ymdhis") . "_" . $data['tripdetails']['shipmentid'];
        $request = "<?xml version='1.0' encoding='UTF-8'?>
				<SVKEDIMessage>
				   <SVKEDITripHeader>
				      <EDIVersion>6.3.1</EDIVersion>
				      <UserName>Svkonekt</UserName>
				      <Password>******</Password>
				      <SenderTransmissionNo>" . $tansctionno . "</SenderTransmissionNo>
				      <AckSpec>
				         <EmailAddress />
				         <AckOption>ERROR</AckOption>
				      </AckSpec>
				      <SourceApp>Svkonekt</SourceApp>
				      <DestinationApp>" . $data['tripdetails']['company_code'] . "</DestinationApp>
				      <ReferenceId>" . $data['tripdetails']['shipmentid'] . "</ReferenceId>
				      <Action>" . $action . "</Action>
				   </SVKEDITripHeader>
				   <SVKEDITripBody>
				   <eTNOrgDetails>
						 <Companycode>" . $data['tripdetails']['company_code'] . "</Companycode>
						 <Branchcode>" . $data['tripdetails']['branch_code'] . "</Branchcode>
						 <DepartmentCode>" . $data['tripdetails']['department_code'] . "</DepartmentCode>
						 <PhysicalReceiver>" . $data['tripdetails']['PhysicalReceiver'] . "</PhysicalReceiver>
						 <LogicalReceiver>" . $data['tripdetails']['LogicalReceiver'] . "</LogicalReceiver>
						 <PhysicalSender>" . $data['tripdetails']['PhysicalSender'] . "</PhysicalSender>
						 <LogicalSender>" . $data['tripdetails']['LogicalSender'] . "</LogicalSender>
                </eTNOrgDetails>
			 <TripDetails>
			  <TripHeader>
			   <TripID>" . $data['tripdetails']['shipmentid'] . "</TripID>
			   <ExternalTripID>" . $data['tripdetails']['shipmentid'] . "</ExternalTripID>";
        $request .= $this->getCarrierXML($data);
        $request .= $this->getTripLocationXML($data);
        $request .= $this->getVehicleDetailsXML($data);
        $request .= "<CargoSummary>
               <TotalQuantity>
                  <Value>" . $data['tripdetails']['total_quantity'] . "</Value>
                  <UOM>Numbers</UOM>
               </TotalQuantity>
               <TotalVolume>
                  <Value>" . $data['tripdetails']['total_volume'] . "</Value>
                  <UOM>" . $data['tripdetails']['volume_unit'] . "</UOM>
               </TotalVolume>
               <TotalWeight>
                  <Value>" . $data['tripdetails']['total_weight'] . "</Value>
                  <UOM>" . $data['tripdetails']['weight_unit'] . "</UOM>
               </TotalWeight>
            </CargoSummary></TripHeader>";
        $request .= $this->getShipmentOrdersXML($data, $data['tripdetails']['company_code']);
        $request .= "</TripDetails></SVKEDITripBody></SVKEDIMessage>";
        $request = str_replace("&", "AND", $request);
        $request = str_replace("amp;", "", $request);
        $request = str_replace(";", ",", $request);
        $filename = date('Ymd') . "SVK" . $data['tripdetails']['shipmentid'] . ".xml";
        $localfile = "./xml/tripoutbound/" . $filename;
        if (!file_exists(dirname($localfile))) {
            if (!mkdir($concurrentDirectory = dirname($localfile), 0700, true) && !is_dir($concurrentDirectory)) {
                throw new \RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
            }
        }
        file_put_contents($localfile, $request);
        return str_replace("&", "AND", $request);
    }

    private function getShipmentOrdersXML(array $data, string $companyCode): string
    {
        $request = "";
        foreach ($data['ordersdetails'] as $orders) {
            $request .= "<TripOrderDetails><OrderID>" . $orders['order_id'] . "</OrderID>
					<EXTOrderID>" . $orders['order_id'] . "</EXTOrderID>
					<Transits>
					<TransitLegId />
					</Transits>
					<OrderType>" . $orders['order_type'] . "</OrderType>
					<ModeOfTransport>" . str_replace("&", "AND", $orders['transport_mode']) . "</ModeOfTransport>
					<Product>" . str_replace("&", "AND", $orders['product']) . "</Product>
					<ServiceType>" . str_replace("&", "AND", $orders['service_type']) . "</ServiceType>
					<GoodsValue>" . str_replace("&", "AND", $orders['goods_value']) . "</GoodsValue>
					<TypeOfBusiness></TypeOfBusiness>
					<TermsOfTrade>
					<Incoterm>" . $orders['incoterm'] . "</Incoterm>
					<FreightName>
						<Term>" . $orders['delivery_term_id'] . "</Term>
						<Name>" . $orders['delivery_term_name'] . "</Name>
					</FreightName>
					</TermsOfTrade>
					<OrderCargoSummary>
	   <TotalQuantity>
		  <Value>" . $orders['quantity'] . "</Value>
		  <UOM>Numbers</UOM>
	   </TotalQuantity>
	   <Volume>
		  <Value>" . $orders['second_volume'] . "</Value>
		  <UOM>" . $orders['secondvolume_uom'] . "</UOM>
	   </Volume>
	   <ActualVolume>
			<Value>" . $orders['volume'] . "</Value>
			<UOM>" . $orders['secondvolume_uom'] . "</UOM>
		</ActualVolume>
	   <Weight>
		  <Value>" . $orders['second_weight'] . "</Value>
		  <UOM>" . $orders['secondweight_uom'] . "</UOM>
	   </Weight>
		<ActualWeight>
			<Value>" . $orders['gross_weight'] . "</Value>
			<UOM>" . $orders['secondweight_uom'] . "</UOM>
		</ActualWeight>
</OrderCargoSummary>";
            if ($companyCode != "CNKN") {
                $request .= "<CustomerDetails>
							<ID>" . $orders['customer_details']['cust_id'] . "</ID>
							<Company>
								<Name>" . str_replace("&", "AND", $orders['customer_details']['name']) . "</Name>
								<RegistrationNumber>" . $orders['customer_details']['cust_id'] . "</RegistrationNumber>
							</Company>
							<Address>
							<CustomerName>" . str_replace("&", "AND", $orders['customer_details']['name']) . "</CustomerName>
							<Address1>" . str_replace("&", "AND", $orders['customer_details']['address']) . "</Address1>
							<Address2></Address2>
							<Street>" . str_replace("&", "AND", $orders['customer_details']['street']) . "</Street>
							<City>" . str_replace("&", "AND", $orders['customer_details']['city']) . "</City>
							<State>" . str_replace("&", "AND", $orders['customer_details']['state']) . "</State>
							<Postal>" . $orders['customer_details']['pincode'] . "</Postal>
							<Country>" . $orders['customer_details']['country'] . "</Country>
							<ContactInfo>
								<CountryCode>" . $orders['customer_details']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['customer_details']['phone'] . "</ContactNo>
								<EmailAddress>" . $orders['customer_details']['email'] . "</EmailAddress>
							</ContactInfo>
						</Address>";


                $request .= " <AdditionalContactInfo>";
                if (!empty($orders['customer_details']['additioncontacts'])) {
                    foreach ($orders['customer_details']['additioncontacts'] as $additioncontacts) {
                        $request .= "<ContactInfo>";
                        $request .= "<Name>" . str_replace("&", "AND", $additioncontacts['name']) . "</Name>";
                        $request .= "<Street>" . str_replace("&", "AND", $additioncontacts['street']) . "</Street>";
                        $request .= "<City>" . str_replace("&", "AND", $additioncontacts['city']) . "</City>";
                        $request .= "<State>" . str_replace("&", "AND", $additioncontacts['state']) . "</State>";
                        $request .= "<Postal>" . str_replace("&", "AND", $additioncontacts['zipcode']) . "</Postal>";
                        $request .= "<Country>" . str_replace("&", "AND", $additioncontacts['country']) . "</Country>";
                        $request .= "<Phone>" . str_replace("&", "AND", $additioncontacts['phone']) . "</Phone>";
                        $request .= "<Fax>" . str_replace("&", "AND", $additioncontacts['fax']) . "</Fax>";
                        $request .= "<Email>" . str_replace("&", "AND", $additioncontacts['email']) . "</Email>";
                        $request .= "</ContactInfo>";
                    }
                }

                $request .= "</AdditionalContactInfo></CustomerDetails>";
            }
            $request .= "<LocationInfo>
					<Source>
						<ID>" . $orders['source']['cust_id'] . "</ID>
						<Company>
								<Name>" . str_replace("&", "AND", $orders['source']['name']) . "</Name>
								<RegistrationNumber>" . $orders['source']['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<CompanyName>" . str_replace("&", "AND", $orders['source']['name']) . "</CompanyName>
							<Address1>" . str_replace("&", "AND", $orders['source']['Address1']) . "</Address1>
							<Address2>" . str_replace("&", "AND", $orders['source']['street_2']) . "</Address2>
							<Street>" . str_replace("&", "AND", $orders['source']['street']) . "</Street>
							<City>" . str_replace("&", "AND", $orders['source']['city']) . "</City>
							<State>" . str_replace("&", "AND", $orders['source']['state']) . "</State>
							<Postal>" . $orders['source']['pincode'] . " </Postal>
							<Country>" . $orders['source']['country'] . "</Country>
							<ContactInfo>
								<CountryCode>" . $orders['source']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['source']['phone'] . "</ContactNo>
								<EmailAddress>" . $orders['source']['email'] . "</EmailAddress>
							</ContactInfo>
						</Address>
						<EstimatedDateTime>
							<From>
								<DateTime>" . $orders['source']['pickup_datetime'] . "</DateTime>
								<TimeZone>" . $orders['source']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['source']['pickup_datetime_utc'] . "</Time>
								</UTC>
							</From>
							<To>
								<DateTime>" . $orders['source']['pickup_endtime'] . "</DateTime>
								<TimeZone>" . $orders['source']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['source']['pickup_endtime_utc'] . "</Time>
								</UTC>
							</To>
						</EstimatedDateTime>";

            $request .= " <AdditionalContactInfo>";
            if (!empty($orders['source']['additioncontacts'])) {
                foreach ($orders['source']['additioncontacts'] as $additioncontacts) {
                    $request .= "<ContactInfo>";
                    $request .= "<Name>" . str_replace("&", "AND", $additioncontacts['name']) . "</Name>";
                    $request .= "<Street>" . str_replace("&", "AND", $additioncontacts['street']) . "</Street>";
                    $request .= "<City>" . str_replace("&", "AND", $additioncontacts['city']) . "</City>";
                    $request .= "<State>" . str_replace("&", "AND", $additioncontacts['state']) . "</State>";
                    $request .= "<Postal>" . str_replace("&", "AND", $additioncontacts['zipcode']) . "</Postal>";
                    $request .= "<Country>" . str_replace("&", "AND", $additioncontacts['country']) . "</Country>";
                    $request .= "<Phone>" . str_replace("&", "AND", $additioncontacts['phone']) . "</Phone>";
                    $request .= "<Fax>" . str_replace("&", "AND", $additioncontacts['fax']) . "</Fax>";
                    $request .= "<Email>" . str_replace("&", "AND", $additioncontacts['email']) . "</Email>";
                    $request .= "</ContactInfo>";
                }
            }

            $request .= "</AdditionalContactInfo></Source>
					<Destination>
						<ID>" . $orders['destination']['cust_id'] . "</ID>
						<Company>
								<Name>" . str_replace("&", "AND", $orders['destination']['name']) . "</Name>
								<RegistrationNumber>" . $orders['destination']['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<CompanyName>" . str_replace("&", "AND", $orders['destination']['name']) . "</CompanyName>
					        <Address1>" . str_replace("&", "AND", $orders['destination']['Address1']) . "</Address1>
                            <Address2>" . str_replace("&", "AND", $orders['destination']['street_2']) . "</Address2>
							<Street>" . str_replace("&", "AND", $orders['destination']['street']) . "</Street>
							<City>" . $orders['destination']['city'] . "</City>
							<State>" . $orders['destination']['state'] . "</State>
							<Postal>" . $orders['destination']['pincode'] . " </Postal>
							<Country>" . $orders['destination']['country'] . "</Country>
							<ContactInfo>
								<CountryCode>" . $orders['destination']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $orders['destination']['phone'] . "</ContactNo>
								<EmailAddress>" . $orders['destination']['email'] . "</EmailAddress>
							</ContactInfo>
						</Address>
						<EstimatedDateTime>
							<From>
								<DateTime>" . $orders['destination']['delivery_datetime'] . "</DateTime>
								<TimeZone>" . $orders['destination']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['destination']['delivery_datetime_utc'] . "</Time>
								</UTC>
							</From>
							<To>
								<DateTime>" . $orders['destination']['delivery_endtime'] . "</DateTime>
								<TimeZone>" . $orders['destination']['timezone'] . "</TimeZone>
								<UTC>
								<Time>" . $orders['destination']['delivery_datetime_utc'] . "</Time>
								</UTC>
							</To>
						</EstimatedDateTime>";

            $request .= " <AdditionalContactInfo>";
            if (!empty($orders['destination']['additioncontacts'])) {
                foreach ($orders['destination']['additioncontacts'] as $additioncontacts) {
                    $request .= "<ContactInfo>";
                    $request .= "<Name>" . str_replace("&", "AND", $additioncontacts['name']) . "</Name>";
                    $request .= "<Street>" . str_replace("&", "AND", $additioncontacts['street']) . "</Street>";
                    $request .= "<City>" . str_replace("&", "AND", $additioncontacts['city']) . "</City>";
                    $request .= "<State>" . str_replace("&", "AND", $additioncontacts['state']) . "</State>";
                    $request .= "<Postal>" . str_replace("&", "AND", $additioncontacts['zipcode']) . "</Postal>";
                    $request .= "<Country>" . str_replace("&", "AND", $additioncontacts['country']) . "</Country>";
                    $request .= "<Phone>" . str_replace("&", "AND", $additioncontacts['phone']) . "</Phone>";
                    $request .= "<Fax>" . str_replace("&", "AND", $additioncontacts['fax']) . "</Fax>";
                    $request .= "<Email>" . str_replace("&", "AND", $additioncontacts['email']) . "</Email>";
                    $request .= "</ContactInfo>";
                }
            }

            $request .= "</AdditionalContactInfo></Destination>
					</LocationInfo>
					<CargoDetails>";
            foreach ($orders['cargos'] as $cargo) {
                $request .= "<TransportHandlingUnit>
							<CargoType>" . str_replace("&", "AND", $cargo['cargo_type']) . "</CargoType>
							<GoodsDescription>" . str_replace("&", "AND", $cargo['goods_description']) . "</GoodsDescription>
							<MarksandNumbers>" . $cargo['marks_numbers'] . "</MarksandNumbers>
							<ValueOfGoods></ValueOfGoods>
							<HandlingUnit>" . $cargo['handling_unit'] . "</HandlingUnit>
							<ItemId>" . $cargo['item_id'] . "</ItemId>
							<Length>
								<Value>" . $cargo['length'] . "</Value>
								<UOM>" . $cargo['length_unit'] . "</UOM>
							</Length>
							<Width>
								<Value>" . $cargo['width'] . "</Value>
								<UOM>" . $cargo['width_unit'] . "</UOM>
							</Width>
							<Height>
								<Value>" . $cargo['height'] . "</Value>
								<UOM>" . $cargo['height_unit'] . "</UOM>
							</Height>
							<ActualWeight>
								<Value>" . $cargo['second_weight'] . "</Value>
								<UOM>" . $cargo['secondweight_uom'] . "</UOM>
							</ActualWeight>
							<Weight>
								<Value>" . $cargo['weight'] . "</Value>
								<UOM>" . $cargo['weight_unit'] . "</UOM>
							</Weight>
							<VolumetricWeight>
								<Value>" . $cargo['volumetric_weight'] . "</Value>
								<UOM>" . $cargo['volweight_uom'] . "</UOM>
							</VolumetricWeight>
							<Volume>
								<Value>" . $cargo['volume'] . "</Value>
								<UOM>" . $cargo['volume_unit'] . "</UOM>
							</Volume>
							<ActualVolume>
								<Value>" . $cargo['second_volume'] . "</Value>
								<UOM>" . $cargo['secondvolume_uom'] . "</UOM>
							</ActualVolume>
							<Quantity>" . $cargo['quantity'] . "</Quantity>
							<ScannedQuantity>" . $cargo['scanned_quantity'] . "</ScannedQuantity>
							<ldm>" . $cargo['ldm'] . "</ldm>
							<GroundedFlag>" . $cargo['grounded'] . "</GroundedFlag>
							<StackableFlag>" . $cargo['stackable'] . "</StackableFlag>
							<SplittableFlag>" . $cargo['splittable'] . "</SplittableFlag>
							<DangerousGoodsFlag>" . $cargo['dg_goods'] . "</DangerousGoodsFlag>";
                $dggoods = "";
                $dgpackgecount = 0;
                if (!empty($cargo['dggoods'])) {
                    $dggoods .= "<DangerousGoods>";
                    foreach ($cargo['dggoods'] as $dgGoodsCargo) {
                        $dgpackgecount += $dgGoodsCargo['num_pkgs'];
                        $dggoods .= "<DangerousGoodsPosition>";
                        $dggoods .= "<NumberOfPackages><Value>" . $dgGoodsCargo['num_pkgs'] . "</Value><QuantityType>" . $dgGoodsCargo['pkg_qty_type'] . "</QuantityType></NumberOfPackages>";
                        $dggoods .= "<DangerousGoodsDetails>";
                        $dggoods .= "<DangerousGoodsQuantity><Value>" . $dgGoodsCargo['quantity'] . "</Value><QuantityType>" . $dgGoodsCargo['quantity_type'] . "</QuantityType></DangerousGoodsQuantity>";
                        $dggoods .= "<UnitedNationsOrganisationNumber><Value>" . $dgGoodsCargo['org_number'] . "</Value><Variant>" . $dgGoodsCargo['org_num_varient'] . "</Variant></UnitedNationsOrganisationNumber>";
                        $dggoods .= "<DangerousGoodsClass>" . $dgGoodsCargo['db_class'] . "</DangerousGoodsClass>";
                        $dggoods .= "<MainRisk>" . $dgGoodsCargo['mainrisk'] . "</MainRisk>";
                        $dggoods .= "<SubsidiaryRisks>" . $dgGoodsCargo['subsidiary_risks'] . "</SubsidiaryRisks>";
                        $dggoods .= "<PackingGroup>" . $dgGoodsCargo['packing_group'] . "</PackingGroup>";
                        $dggoods .= "<DangerousGoodsDescriptions><Language>EN</Language><ProperShippingName>" . $dgGoodsCargo['description'] . "</ProperShippingName></DangerousGoodsDescriptions>";
                        $dggoods .= "<LimitedQuantityFlag>" . $dgGoodsCargo['limitqty_flag'] . "</LimitedQuantityFlag>";
                        $dggoods .= "<ExceptedQuantityFlag>" . $dgGoodsCargo['exceptqty_flag'] . "</ExceptedQuantityFlag>";
                        $dggoods .= "<HighConsequence></HighConsequence>";
                        $dggoods .= "<Roadfreight>";
                        $dggoods .= "<TunnelRestrictionCode>" . $dgGoodsCargo['tunnel_restriction_code'] . "</TunnelRestrictionCode>";
                        $dggoods .= "<TransportCategory>" . $dgGoodsCargo['transport_category'] . "</TransportCategory>";
                        $dggoods .= "<EnvironmentallyHazardous>" . $dgGoodsCargo['environment_hazardous'] . "</EnvironmentallyHazardous>";
                        $dggoods .= "<NOS>" . $dgGoodsCargo['nos'] . "</NOS>";
                        $dggoods .= "<ADRMultiplicator>" . $dgGoodsCargo['adr_multiplicator'] . "</ADRMultiplicator>";
                        $dggoods .= "<TotalADRPoints>" . $dgGoodsCargo['total_adr_points'] . "</TotalADRPoints>";
                        $dggoods .= "<ADRVersion>" . $dgGoodsCargo['adr_version'] . "</ADRVersion>";
                        $dggoods .= "</Roadfreight>";
                        $dggoods .= "</DangerousGoodsDetails>";
                        $dggoods .= "</DangerousGoodsPosition>";
                    }
                    $dggoods .= "</DangerousGoods>";
                }

                $request .= "<TotalPackagesOfDangerousGoods>" . $dgpackgecount . "</TotalPackagesOfDangerousGoods>";
                $request .= $dggoods;
                if (count($cargo['inner_cargo']) > 0) {
                    foreach ($cargo['inner_cargo'] as $inn_cargo) {
                        $request .= " <Packagingunit>
									<PackageType>" . $inn_cargo['cargo_type'] . "</PackageType>
									<PackageDescription>" . $inn_cargo['goods_description'] . "</PackageDescription>
									<Quantity>" . $inn_cargo['quantity'] . "</Quantity>
									<Length>
										<Value>" . $inn_cargo['length'] . "</Value>
										<UOM>" . $inn_cargo['length_unit'] . "</UOM>
									</Length>
									<Width>
										<Value>" . $inn_cargo['width'] . "</Value>
										<UOM>" . $inn_cargo['width_unit'] . "</UOM>
									</Width>
									<Height>
										<Value>" . $inn_cargo['height'] . "</Value>
										<UOM>" . $inn_cargo['height_unit'] . "</UOM>
									</Height>
									<Weight>
										<Value>" . $inn_cargo['weight'] . "</Value>
										<UOM>" . $inn_cargo['weight_unit'] . "</UOM>
									</Weight>
									<Volume>
										<Value>" . $inn_cargo['volume'] . "</Value>
										<UOM>" . $inn_cargo['volume_unit'] . "</UOM>
									</Volume>
									</Packagingunit>";
                    }
                }
                $request .= "
						</TransportHandlingUnit>";
            }
            $request .= "</CargoDetails><ValueAddedServices>";
            if (!empty($orders['addons'])) {
                foreach ($orders['addons'] as $addon) {
                    $request .= " <Addon>
							<AddonName>" . $addon['vas_name'] . "</AddonName>
							<AddonCode></AddonCode>
							<Currency></Currency>
							<RateUnit></RateUnit>
							<AddonAmount></AddonAmount>
							<AddonQuantity>" . $addon['quantity'] . "</AddonQuantity>
							</Addon>";
                }
            }

            $request .= "</ValueAddedServices><InvolvedParties>";
            $partyTypes = ["Customer", "CUSTOMER"];
            if (!empty($orders['parties'])) {
                foreach ($orders['parties'] as $party) {
                    if ($companyCode == "CNKN" && (!in_array($party['type'], $partyTypes))) {
                        $request .= "<PartyType type='" . $party['type'] . "'>
						<ID>" . $party['cust_id'] . "</ID>
						<Company>
							<Name>" . str_replace("&", "AND", $party['name']) . "</Name>
							<RegistrationNumber>" . $party['cust_id'] . "</RegistrationNumber>
						</Company>
						<Address>
							<FirstName>" . str_replace("&", "AND", $party['name']) . "</FirstName>
							<LastName>" . str_replace("&", "AND", $party['name']) . "</LastName>
							<Address1>" . str_replace("&", "AND", $party['street']) . "</Address1>
							<Address2>" . str_replace("&", "AND", $party['street_2']) . "</Address2>
							<Street>" . str_replace("&", "AND", $party['street']) . "</Street>
							<City>" . $party['city'] . "</City>
							<State>" . $party['state'] . "</State>
							<Postal>" . $party['pincode'] . " </Postal>
							<Country>" . $party['country'] . "</Country>
							<ContactInfo>
								<CountryCode>" . $data['ordersdetails'][0]['source']['CountryCode'] . "</CountryCode>
								<ContactNo>" . $party['phone'] . "</ContactNo>
								<EmailAddress>" . $party['email'] . "</EmailAddress>
							</ContactInfo>
						</Address> ";

                        $request .= " <AdditionalContactInfo>";
                        if (!empty($party['additioncontacts'])) {
                            foreach ($party['additioncontacts'] as $additioncontacts) {
                                $request .= "<ContactInfo>";
                                $request .= "<Name>" . str_replace("&", "AND", $additioncontacts['name']) . "</Name>";
                                $request .= "<Street>" . str_replace("&", "AND", $additioncontacts['street']) . "</Street>";
                                $request .= "<City>" . str_replace("&", "AND", $additioncontacts['city']) . "</City>";
                                $request .= "<State>" . str_replace("&", "AND", $additioncontacts['state']) . "</State>";
                                $request .= "<Postal>" . str_replace("&", "AND", $additioncontacts['zipcode']) . "</Postal>";
                                $request .= "<Country>" . str_replace("&", "AND", $additioncontacts['country']) . "</Country>";
                                $request .= "<Phone>" . str_replace("&", "AND", $additioncontacts['phone']) . "</Phone>";
                                $request .= "<Fax>" . str_replace("&", "AND", $additioncontacts['fax']) . "</Fax>";
                                $request .= "<Email>" . str_replace("&", "AND", $additioncontacts['email']) . "</Email>";
                                $request .= "</ContactInfo>";
                            }
                        }

                        $request .= "</AdditionalContactInfo></PartyType>";
                    }
                }
            }
            $request .= "</InvolvedParties><ManageReferences>";

            if (!empty($orders['innref'])) {
                foreach ($orders['innref'] as $ref) {
                    $request .= "<References>
									<RefType>
										<Code>" . $ref['reference_id'] . "</Code>
										<Value>" . str_replace("&", "AND", $ref['ref_value']) . "</Value>
									</RefType>
								</References>";
                }
            }
            $request .= "</ManageReferences><Remarks></Remarks></TripOrderDetails>";
        }
        return str_replace("&", "AND", $request);
    }

    private function getVehicleDetailsXML(array $data): string
    {
        $request = " <VehicleDetails>";
        if (!empty($data['tripdetails']['trucks_data'])) {
            $request .= "<VehicleTypeCode>" . $data['tripdetails']['trucks_data']['truck_number'] . "</VehicleTypeCode>
               <VehicleModelCode>" . $data['tripdetails']['trucks_data']['truck_brand'] . "</VehicleModelCode>
               <RegistrationNumber>" . $data['tripdetails']['trucks_data']['register_number'] . "</RegistrationNumber>
               <License>" . $data['tripdetails']['trucks_data']['insurence'] . "</License>
               <ApplicableForDangerousGoods>" . $data['tripdetails']['trucks_data']['insurence'] . "</ApplicableForDangerousGoods>
               <CommodityType>" . $data['tripdetails']['trucks_data']['insurence'] . "</CommodityType>
               <Properties>
                  <Weight>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['truck_weight'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['weight_unit'] . "</UOM>
                  </Weight>
                  <Volume>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['truck_volume'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['volume_unit'] . "</UOM>
                  </Volume>
                  <Length>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['length'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['length_unit'] . "</UOM>
                  </Length>
                  <Width>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['breadth'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['breadth_unit'] . "</UOM>
                  </Width>
                  <Height>
                     <Min>0.00</Min>
                     <Max>" . $data['tripdetails']['trucks_data']['height'] . "</Max>
                     <UOM>" . $data['tripdetails']['trucks_data']['height_unit'] . "</UOM>
                  </Height>
                  <Distance>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </Distance>
                  <DimensionGirth>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </DimensionGirth>
                  <ShipmentUnit>
                    <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </ShipmentUnit>
                  <PacketWeight>
                     <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </PacketWeight>
                  <PacketVolume>
                    <Min>0.00</Min>
                     <Max>0.00</Max>
                     <UOM></UOM>
                  </PacketVolume>
               </Properties>";
        }
        $request .= "</VehicleDetails><DriverDetails>";

        if (!empty($data['tripdetails']['driver_data'])) {
            $request .= "<DriverId>" . $data['tripdetails']['driver_data']['contact_num'] . "</DriverId>
               <DriverName>" . $data['tripdetails']['driver_data']['name'] . "</DriverName>
               <DriverLicence>" . $data['tripdetails']['driver_data']['driving_licence_num'] . "</DriverLicence>
               <Address>
                  <Address1>" . $data['tripdetails']['driver_data']['address1'] . "</Address1>
                  <Address2></Address2>
                  <Street>" . $data['tripdetails']['driver_data']['street'] . "</Street>
                  <City>" . $data['tripdetails']['driver_data']['city'] . "</City>
                  <State>" . $data['tripdetails']['driver_data']['state'] . "</State>
                  <Postal>" . $data['tripdetails']['driver_data']['pincode'] . "</Postal>
                  <Country>" . $data['tripdetails']['driver_data']['country'] . "</Country>
                  <ContactInfo>
                     <CountryCode>" . $data['tripdetails']['driver_data']['phone_code'] . "</CountryCode>
                     <ContactNo>" . $data['tripdetails']['driver_data']['contact_num'] . "</ContactNo>
                     <EmailAddress>" . $data['tripdetails']['driver_data']['email'] . "</EmailAddress>
                  </ContactInfo>
               </Address>";
        }
        $request .= "</DriverDetails>";
        return str_replace("&", "AND", $request);
    }

    private function getTripLocationXML(array $data): string
    {
        $request = "<TripLocation>
				<TripStartLocation>
					<Address>
						<CompanyName>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['name']) . "</CompanyName>
						<Address1>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['street']) . "</Address1>
						<Address2>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['street_2']) . "</Address2>
						<Street>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['street']) . "</Street>
						<City>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['city']) . "</City>
						<State>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['pickup']['state']) . "</State>
						<Postal>" . $data['tripdetails']['tripStops']['pickup']['pincode'] . "</Postal>
						<Country>" . $data['tripdetails']['tripStops']['pickup']['country'] . "</Country>
						<ContactInfo>
							<CountryCode>" . $data['tripdetails']['tripStops']['pickup']['phone_code'] . "</CountryCode>
							<ContactNo>" . $data['tripdetails']['tripStops']['pickup']['mobile'] . "</ContactNo>
							<EmailAddress>" . $data['tripdetails']['tripStops']['pickup']['email'] . "</EmailAddress>
						</ContactInfo>
					</Address>

				</TripStartLocation>
				<TripEndLocation>
					<Address>
						<CompanyName>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['name']) . "</CompanyName>
						<Address1>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['street']) . "</Address1>
						<Address2>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['street_2']) . "</Address2>
						<Street>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['street']) . "</Street>
						<City>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['city']) . "</City>
						<State>" . str_replace("&", "AND", $data['tripdetails']['tripStops']['delivery']['state']) . "</State>
						<Postal>" . $data['tripdetails']['tripStops']['delivery']['pincode'] . "</Postal>
						<Country>" . $data['tripdetails']['tripStops']['delivery']['country'] . "</Country>
						<ContactInfo>
							<CountryCode>" . $data['tripdetails']['tripStops']['delivery']['phone_code'] . "</CountryCode>
							<ContactNo>" . $data['tripdetails']['tripStops']['delivery']['mobile'] . "</ContactNo>
							<EmailAddress>" . $data['tripdetails']['tripStops']['delivery']['email'] . "</EmailAddress>
						</ContactInfo>
					</Address>
				</TripEndLocation>

			</TripLocation>";
        return str_replace("&", "AND", $request);
    }

    private function getCarrierXML(array $data): string
    {
        $request = "<CarrierDetails>
			   <ID>" . $data['tripdetails']['vendordetails']['code'] . "</ID>
               <Address>
                  <CompanyName>" . $data['tripdetails']['vendordetails']['companyname'] . "</CompanyName>
                   <Address1>" . $data['tripdetails']['vendordetails']['street'] . "</Address1>
                   <Address2>" . $data['tripdetails']['vendordetails']['street_2'] . "</Address2>
                   <Street>" . $data['tripdetails']['vendordetails']['street'] . "</Street>
                   <City>" . $data['tripdetails']['vendordetails']['location_id'] . "</City>
                   <State>" . $data['tripdetails']['vendordetails']['state'] . "</State>
                   <Postal>" . $data['tripdetails']['vendordetails']['pincode'] . "</Postal>
                   <Country>" . $data['tripdetails']['vendordetails']['country'] . "</Country>
                   <ContactInfo>
                   		<CountryCode>" . $data['tripdetails']['vendordetails']['phone_code'] . "</CountryCode>
                   		 <ContactNo>" . $data['tripdetails']['vendordetails']['mobile'] . "</ContactNo>
                    	<EmailAddress>" . $data['tripdetails']['vendordetails']['email'] . "</EmailAddress>
                   </ContactInfo>
                </Address> <AdditionalContactInfo>";
        if (!empty($data['tripdetails']['vendordetails']['additioncontacts'][0])) {
            foreach ($data['tripdetails']['vendordetails']['additioncontacts'][0] as $additioncontacts) {
                $request .= "<ContactInfo>";
                $request .= "<Name>" . str_replace("&", "AND", $additioncontacts['name']) . "</Name>";
                $request .= "<Street>" . str_replace("&", "AND", $additioncontacts['street']) . "</Street>";
                $request .= "<City>" . str_replace("&", "AND", $additioncontacts['city']) . "</City>";
                $request .= "<State>" . str_replace("&", "AND", $additioncontacts['state']) . "</State>";
                $request .= "<Postal>" . str_replace("&", "AND", $additioncontacts['zipcode']) . "</Postal>";
                $request .= "<Country>" . str_replace("&", "AND", $additioncontacts['country']) . "</Country>";
                $request .= "<Phone>" . str_replace("&", "AND", $additioncontacts['phone']) . "</Phone>";
                $request .= "<Fax>" . str_replace("&", "AND", $additioncontacts['fax']) . "</Fax>";
                $request .= "<Email>" . str_replace("&", "AND", $additioncontacts['email']) . "</Email>";
                $request .= "</ContactInfo>";
            }
        }

        $request .= "</AdditionalContactInfo></CarrierDetails>";
        return $request = str_replace("&", "AND", $request);
    }


    private function sendTollXML(string $orderinfo, int $carrierID, array $data): string
    {
        $ci = &get_instance();
        $response = "";
        $getCarrierEDIIfo = $ci->carriercommonmodel->getCarrierEDIDetails($carrierID);
        if (!empty($getCarrierEDIIfo)) {
            foreach ($getCarrierEDIIfo as $ediIfo) {
                if ($ediIfo["editype"] == "P" && $ediIfo["ediservice"] == "Web Services") {
                    log_message("error", "EDI URL" . $ediIfo["edi_url"]);
                    $response = $this->sendTripToWebServicePassURL($orderinfo, $ediIfo,$data);
                    if ($response['success'] == false) {
                        $this->sendTripFailedEmailNotification($data, $response);
                    }
                }
            }
        } else {
            log_message("error", "Carrier Does not have permission " . $data['tripdetails']['shipmentid'] . $carrierID);
        }
        //log_message("error", "Resonces From EDI" . json_encode($response));
        return json_encode($response) ?? "";
    }

    private function sendTriptoAltova(string $orderinfo): string
    {
        try {
            log_message("error", "sendTollXML Request to Altova" . json_encode($orderinfo));
            $data = 'inputFiles=' . $orderinfo;
            $curl = curl_init(ALTOVA_CARRIER_TRIP_URL);
            curl_setopt($curl, CURLOPT_URL, ALTOVA_CARRIER_TRIP_URL);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/x-www-form-urlencoded"];
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            $resp = curl_exec($curl);
            if ($resp === false) {
                log_message('error', 'sendElg360order request failed: ' . curl_error($curl));
            }
            log_message("error", "sendTollXML Response" . $resp);
            curl_close($curl);
        } catch (Exception $ex) {
            $resp = "";
            log_message("error", "Some Problem occured!, While Sending Trip Notification XML to Carrier " . $ex->getMessage());
        }
        return $resp;
    }

    private function sendTripToWebServicePassURL(string $orderinfo, array $ediIfo,array $data): array
    {
        try {
            log_message("error", "Request to PASS URL Webservice: " . json_encode($orderinfo));
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $ediIfo['edi_url']);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_PROXY, KN_NEW_PROXY_URL);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            $headers = ["Content-Type: application/xml"];
            if ($ediIfo['user_name'] != "" && $ediIfo['password'] != "") {
                $username = $ediIfo['user_name'];
                $password = $ediIfo['password'];
                $headers = [
                    'Content-Type: application/xml',
                    'Authorization: Basic ' . base64_encode("$username:$password")
                ];
            }
            if ($ediIfo['authentication'] != null) {
                $authInfo = explode(":", $ediIfo['authentication']);
                if ($authInfo[0] == "Sign") {
                    $headers = [
                        'Content-Type: application/xml',
                        'Cache-Control: no-cache',
                        'Accept-Encoding: gzip, deflate, br',
                        'Connection: keep-alive',
                        ''.$authInfo[0].':  '.$authInfo[1]
                    ];
                }
            }
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $orderinfo);
            $response = curl_exec($curl);
            if ($response === false) {
                log_message('error', 'request failed for PASS URL WEbservice: ' . curl_error($curl));
                $this->sendTripFailedEmailNotification($data, curl_error($curl));
            }
            log_message("error", "PASS URL WEbservice  Response" . json_encode(json_decode($response)));
            curl_close($curl);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Sending PASS URL WEbservice  " . $ex->getMessage());
        }
        if (json_encode(json_decode($response)) !== "null") {
            $response = json_decode($response, true);
        } else {
            $response = json_decode(json_encode(simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
        }
        return $response ?? [];
    }


    public function gettripstopdetails($shift_id)
    {
        $ci = &get_instance();
        $stopsData = [];

        $allstops = $ci->db->query("SELECT * FROM tb_shiporder_stops  WHERE STATUS = '1' AND shipment_id='" . $shift_id . "'  ORDER BY ordernumber ASC");
        $allstopsres = $allstops->result_array();
        $totalrecords = sizeof($allstopsres);
        $pickupid = $allstopsres[0]['id'];
        $dropid = $allstopsres[$totalrecords - 1]['id'];


        $stops = $ci->db->query("SELECT o.`pickup_company`,o.`pickup_address1`,o.`pickup_address2`,o.`pickup_city`,o.`pickup_country`,o.`pickup_pincode`,pickup_custid FROM tb_shiporder_stops  tss  LEFT OUTER JOIN tb_employee te ON te.stop_id=tss.id LEFT OUTER JOIN tb_orders o ON o.order_id=te.order_id WHERE tss.status = '1' AND tss.shipment_id='" . $shift_id . "' AND te.stop_id='" . $pickupid . "' AND tss.stoptype='P'");
        $pickupres = $stops->result_array();
        $pickup_custid = $pickupres[0]['pickup_custid'];
        $pickupcustd = $ci->common->gettblrowdata(["code" => $pickup_custid], "mobile,email,state,street", "tbl_party_master", 0, 0);
        $pickup["pickup_company"] = $pickupres[0]["pickup_company"];
        $pickup["pickup_address1"] = $pickupres[0]["pickup_address1"];
        $pickup["pickup_address2"] = $pickupres[0]["pickup_address2"];
        $pickup["pickup_city"] = $pickupres[0]["pickup_city"];
        $pickup["pickup_country"] = $pickupres[0]["pickup_country"];
        $pickup["pickup_pincode"] = $pickupres[0]["pickup_pincode"];
        $pickup["ContactNo"] = $pickupcustd["mobile"];
        $pickup["EmailAddress"] = $pickupcustd["email"];
        $pickup["state"] = $pickupcustd["state"];
        $pickup["street"] = $pickupcustd["street"];


        $stops = $ci->db->query("SELECT o.`delivery_company`, o.`delivery_address1`,o.`delivery_address2`,o.`delivery_city`,o.`delivery_country`,o.`delivery_pincode`,drop_custid FROM tb_shiporder_stops  tss LEFT OUTER JOIN tb_employee te ON te.drop_stopid=tss.id LEFT OUTER JOIN tb_orders o ON o.order_id=te.order_id WHERE tss.status = '1' AND tss.shipment_id='" . $shift_id . "' AND te.drop_stopid ='" . $dropid . "' AND tss.stoptype='D'");
        $deliveryres = $stops->result_array();
        $drop_custid = $deliveryres[0]['drop_custid'];
        $dropcustd = $ci->common->gettblrowdata(["code" => $drop_custid], "mobile,email,state,street", "tbl_party_master", 0, 0);
        $delivery["delivery_company"] = $deliveryres[0]["delivery_company"];
        $delivery["delivery_address1"] = $deliveryres[0]["delivery_address1"];
        $delivery["delivery_address2"] = $deliveryres[0]["delivery_address2"];
        $delivery["delivery_city"] = $deliveryres[0]["delivery_city"];
        $delivery["delivery_country"] = $deliveryres[0]["delivery_country"];
        $delivery["delivery_pincode"] = $deliveryres[0]["delivery_pincode"];
        $delivery["ContactNo"] = $dropcustd['mobile'];
        $delivery["EmailAddress"] = $dropcustd['email'];
        $delivery["state"] = $dropcustd['state'];
        $delivery["street"] = $dropcustd['street'];

        $stopsData = [
            "pickup" => $pickup,
            "delivery" => $delivery
        ];

        return $stopsData;
    }

    private function getShipmentOrders(int $shipmentNumber, int $code, string $curtz): array
    {
        $ci = &get_instance();
        $ordersdetails = $ci->common->getjointbldata("tb_orders o", "tb_order_details tod", "o.id=tod.order_row_id", ["o.shift_id" => $shipmentNumber], "o.id as orderno,o.*,tod.*", 0, 0);
        if (empty($ordersdetails)) {
            $ordersdetails = $ci->carriercommonmodel->getShipmentLegOrderDetails($shipmentNumber);
        }
        foreach ($ordersdetails as $orders) {
            $orderCargoSummary = $ci->carriercommonmodel->getOrderCargoSummary($orders['orderno']);
            $orderinfo = [];
            $orderinfo['order_id'] = $orders['order_id'];
            $orderinfo['transport_mode'] = $orders['transport_mode'];
            $orderinfo['product'] = $orders['product'];
            $orderinfo['incoterm'] = $orders['incoterm'];
            $orderinfo['goods_value'] = $orders['goods_value'];
            $orderinfo['quantity'] = $orderCargoSummary['totqty'];
            $weight_unit = (isset($orderCargoSummary['weight_unit']) && $orderCargoSummary['weight_unit'] != "") ? $this->getWeightHigherUnit(
                $orderCargoSummary['weight_unit']
            ) : "kg";
            $second_weight = (isset($orderCargoSummary['second_weight']) && $orderCargoSummary['second_weight'] != "") ? $orderCargoSummary['second_weight'] : 0;
            $second_volume = (isset($orderCargoSummary['second_volume']) && $orderCargoSummary['second_volume'] != "") ? $orderCargoSummary['second_volume'] : 0;
            $orderinfo['weight'] = $this->calculateWeight($orderCargoSummary['totwg'], $weight_unit);
            $orderinfo['gross_weight'] = $orderCargoSummary['weight'];
            $orderinfo['gross_weight_uom'] = $orderCargoSummary['gross_weight_uom'] ?? "KG";
            $orderinfo['chargeable_weight'] = $orderCargoSummary['chargeable_weight'];
            $orderinfo['chargeable_weight_uom'] = $orderCargoSummary['chargeable_weight_uom'] ?? "KG";
            $orderinfo['volume'] = $orderCargoSummary['totvol'];
            $orderinfo['second_weight'] = $second_weight;
            $orderinfo['secondweight_uom'] = $orderCargoSummary['secondweight_uom'] ?? "KG";
            $orderinfo['second_volume'] = $second_volume;
            $orderinfo['secondvolume_uom'] = $orderCargoSummary['secondvolume_uom'] ?? "CBM";
            $orderinfo['order_type'] = $this->getOrderTypeName($orders['order_type']);
            $orderinfo['service_type'] = $orderinfo['delivery_term_id'] = $orderinfo['delivery_term_name'] = "";
            if ($orders['service'] != "") {
                $orderinfo['service_type'] = $this->getOrderServiceName($orders['service']);
            }
            if ($orders['delivery_term'] != "") {
                $deliveryTermInfo = $this->getOrderDeliveryTermInfo($orders['delivery_term']);
                $orderinfo['delivery_term_id'] = $deliveryTermInfo['term_id'] ?? "";
                $orderinfo['delivery_term_name'] = $deliveryTermInfo['name'] ?? "";
            }
            $orderinfo['physicalreceiver'] = $orders['physicalreceiver'];
            $orderinfo['logicalreceiver'] = $orders['logicalreceiver'];
            $orderinfo['physicalsender'] = $orders['physicalsender'];
            $orderinfo['logicalsender'] = $orders['logicalsender'];

            $epickup = getdatetimebytimezone($curtz, $orders['pickup_datetime'], DFLT_TZ);
            $early_pickup = $epickup['datetime'];
            $lpickup = getdatetimebytimezone($curtz, $orders['pickup_endtime'], DFLT_TZ);
            $late_pickup = $lpickup['datetime'];

            $edelivery = getdatetimebytimezone($curtz, $orders['delivery_datetime'], DFLT_TZ);
            $early_delivery = $edelivery['datetime'];
            $ldelivery = getdatetimebytimezone($curtz, $orders['drop_endtime'], DFLT_TZ);
            $late_delivery = $ldelivery['datetime'];
            $partyTypes = [];
            $parties = $this->getOrderPartyDetails($orders['orderno']);
            foreach ($parties as $party) {
                if ($party['type'] == "Shipper") {
                    $orderinfo['source'] = $party;
                }
                if ($party['type'] == "Consignee") {
                    $orderinfo['destination'] = $party;
                }
                if ($party['type'] == "Customer") {
                    $orderinfo['customer_details'] = $party;
                }
                array_push($partyTypes, $party['type']);
            }
            $orderinfo['customer_details']['additioncontacts'] = $ci->carriercommonmodel->getAdditionalcontacts($orders['orderno'], "CUCT");

            if (!in_array("Customer", $partyTypes)) {
                $orderinfo['customer_details'] = $this->getOrderCustomerDetails($orders['customer_id']);
                $orderinfo['customer_details']['party_references'] = $ci->common->getPartyReferences($orders['customer_id']);
                $orderinfo['customer_details']['type'] = "Customer";
                array_push($parties, $orderinfo['customer_details']);
            }

            $orderinfo['parties'] = $parties;

            $orderinfo['source']['CountryCode'] = $orderinfo['customer_details']['CountryCode'] = $orderinfo['destination']['CountryCode'] = $code;
            $orderinfo['source']['pickup_datetime'] = $early_pickup;
            $orderinfo['source']['pickup_datetime_utc'] = $orders['pickup_datetime'];
            $orderinfo['source']['pickup_endtime'] = $late_pickup;
            $orderinfo['source']['pickup_endtime_utc'] = $orders['pickup_endtime'];
            $orderinfo['source']['Address1'] = $orders['pickup_address1'];
            $orderinfo['source']['Address2'] = $orders['pickup_address2'];
            $orderinfo['destination']['delivery_datetime'] = $early_delivery;
            $orderinfo['destination']['delivery_datetime_utc'] = $orders['delivery_datetime'];
            $orderinfo['destination']['delivery_endtime'] = $late_delivery;
            $orderinfo['destination']['delivery_endtime_utc'] = $orders['drop_endtime'];
            $orderinfo['destination']['Address1'] = $orders['delivery_address1'];
            $orderinfo['destination']['Address2'] = $orders['delivery_address2'];
            $orderinfo['source']['timezone'] = $orderinfo['destination']['timezone'] = $curtz;

            $orderinfo['cargos'] = $this->getOrderCargoDetails($orders['orderno']);
            $orderinfo['addons'] = $this->getOrderAddons($orders['orderno']);
            $orderinfo['innref'] = $this->getOrderManageReferences($orders['orderno']);
            $orderdata[] = $orderinfo;
        }
        return $orderdata ?? [];
    }

    private function getOrderCargoDetails(int $id): array
    {
        $ci = &get_instance();
        $cargos = [];
        $cargo_type = "";
        $getcargos = $ci->common->gettbldata(["order_id" => $id, "status" => 1], "id,cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content,second_weight, second_volume,scanned_quantity,ldm,volumetric_weight", "tb_order_cargodetails", 0, 0);
        if (!empty($getcargos)) {
            $cargo_cnt = 0;
            foreach ($getcargos as $res) {
                $cargos[$cargo_cnt]['quantity_type'] = $res['quantity_type'];
                $cargos[$cargo_cnt]['content'] = $res['cargo_content'] ?? "MISCELLANEOUS";
                $cargos[$cargo_cnt]['length'] = $res['length'];
                $cargos[$cargo_cnt]['width'] = $res['width'];
                $cargos[$cargo_cnt]['height'] = $res['height'];
                $cargos[$cargo_cnt]['weight'] = $res['weight'] ?? 1;
                $cargos[$cargo_cnt]['volume'] = $res['volume'] ?? 1;
                $cargos[$cargo_cnt]['quantity'] = $res['quantity'];
                $cargos[$cargo_cnt]['second_weight'] = $res['second_weight'];
                $cargos[$cargo_cnt]['second_volume'] = $res['second_volume'];
                $cargos[$cargo_cnt]['scanned_quantity'] = $res['scanned_quantity'];
                $cargos[$cargo_cnt]['ldm'] = $res['ldm'];
                $cargos[$cargo_cnt]['volumetric_weight'] = $res['volumetric_weight'];
                if ($res['cargo_id'] != "") {
                    $checkInnerCargo = $ci->common->gettblrowdata(["id" => $res['cargo_id']], "cargo_type, handling_unit,weight_unit,volume_unit,length_unit,width_unit, height_unit,goods_description,marks_numbers,item_id,secondweight_uom,secondvolume_uom, grounded,stackable,splittable,dg_goods,volweight_uom", "tb_cargo_details", 0, 0);
                    if (!empty($checkInnerCargo)) {
                        $cargo_type = $checkInnerCargo['cargo_type'] ?? "";
                        $cargo_type = $cargo_type ?? $checkInnerCargo['handling_unit'];
                        $cargos[$cargo_cnt]['cargo_type'] = $checkInnerCargo['cargo_type'] ?? "";
                        $cargos[$cargo_cnt]['handling_unit'] = $checkInnerCargo['handling_unit'];
                        $cargos[$cargo_cnt]['weight_unit'] = $checkInnerCargo['weight_unit'];
                        $cargos[$cargo_cnt]['volume_unit'] = $checkInnerCargo['volume_unit'];
                        $cargos[$cargo_cnt]['length_unit'] = $checkInnerCargo['length_unit'];
                        $cargos[$cargo_cnt]['width_unit'] = $checkInnerCargo['width_unit'];
                        $cargos[$cargo_cnt]['height_unit'] = $checkInnerCargo['height_unit'];
                        $cargos[$cargo_cnt]['goods_description'] = $checkInnerCargo['goods_description'];
                        $cargos[$cargo_cnt]['marks_numbers'] = $checkInnerCargo['marks_numbers'];
                        $cargos[$cargo_cnt]['item_id'] = $checkInnerCargo['item_id'];
                        $cargos[$cargo_cnt]['secondweight_uom'] = $checkInnerCargo['secondweight_uom'];
                        $cargos[$cargo_cnt]['secondvolume_uom'] = $checkInnerCargo['secondvolume_uom'];
                        $cargos[$cargo_cnt]['grounded'] = $checkInnerCargo['grounded'];
                        $cargos[$cargo_cnt]['stackable'] = $checkInnerCargo['stackable'];
                        $cargos[$cargo_cnt]['splittable'] = $checkInnerCargo['splittable'];
                        $cargos[$cargo_cnt]['dg_goods'] = $checkInnerCargo['dg_goods'];
                        $cargos[$cargo_cnt]['volweight_uom'] = $checkInnerCargo['volweight_uom'];
                    }
                    $inner_cargo_res = $ci->common->gettbldata(["cargo_id" => $res['cargo_id']], "cargo_type,goods_description,quantity,length,length_unit, width,width_unit,height,height_unit,weight,weight_unit,volume,volume_unit", "tb_inner_cargo", 0, 0);
                    $cargos[$cargo_cnt]['inner_cargo'] = $inner_cargo_res ?? [];

                    $dgCargoDetails = $ci->common->gettbldata(["order_id" => $id, "order_cargo_id" => $res['id']], "*", "tb_order_dg_goods", 0, 0);
                    $cargos[$cargo_cnt]['dggoods'] = (!empty($dgCargoDetails)) ? $dgCargoDetails : [];

                    $cargo_cnt++;
                }
            }
        }
        return $cargos ?? [];
    }

    private function getOrderPartyDetails(int $id): array
    {
        $ci = &get_instance();
        $parties = [];
        $whereClouse = " AND o.order_id='$id' ";
        $chekparty = $ci->common->getorderpartydata($whereClouse);
        if (count($chekparty) > 0) {
            foreach ($chekparty as $rr) {
                $partydetail = [];
                $getpartyinfo = $ci->common->gettbldata(["partner_id" => $rr->id], "*", "tb_party_reference", 0, 0);

                $chktype = $ci->common->gettblrowdata(["id" => $rr->party_type], "name", "tbl_party_types", 0, 0);
                if (count($chktype) > 0) {
                    $additioncontacts = match (strtoupper($chktype['name'])) {
                        "SHIPPER" => $ci->carriercommonmodel->getAdditionalcontacts($id, "SHI"),
                        "CONSIGNEE" => $ci->carriercommonmodel->getAdditionalcontacts($id, "CNI"),
                        "CUSTOMER" => $ci->carriercommonmodel->getAdditionalcontacts($id, "CUI"),
                        "PICKUP" => $ci->carriercommonmodel->getAdditionalcontacts($id, "PKI"),
                        "DELIVERY" => $ci->carriercommonmodel->getAdditionalcontacts($id, "DLI"),
                        "NOTIFY_PARTY" => $ci->carriercommonmodel->getAdditionalcontacts($id, "NPI"),
                        "CARRIER" => $ci->carriercommonmodel->getAdditionalcontacts($id, "CRI"),
                        default => [],
                    };

                    if ($rr->party_master_id != "") {
                        $cntry = $rr->pcountry;
                        if (strlen($cntry) > 2) {
                            $cntry = substr($cntry, 0, 2);
                        }
                        $pstreet = $rr->pstreet;
                        if ($pstreet == "") {
                            $pstreet = $rr->plocation_id;
                        }
                        $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->paddress, 'pincode' => $rr->ppincode, 'country' => $cntry, 'street' => $pstreet, 'street_2' => $rr->street_2, 'street_3' => $rr->street_3, 'city' => $rr->plocation_id, 'state' => $rr->pstate, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier, 'kn_login_account' => $rr->kn_login_account, 'party_references' => $getpartyinfo, 'additioncontacts' => $additioncontacts];
                    } else {
                        $cntry = $rr->country;
                        if (strlen($cntry) > 2) {
                            $cntry = substr($cntry, 0, 2);
                        }
                        $street = $rr->street;
                        if ($street == "") {
                            $street = $rr->street;
                        }
                        $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->address, 'pincode' => $rr->pincode, 'country' => $cntry, 'street' => $street, 'street_2' => $rr->street_2, 'street_3' => $rr->street_3, 'city' => $rr->location_id, 'state' => $rr->state, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier, 'kn_login_account' => $rr->kn_login_account, 'party_references' => $getpartyinfo, 'additioncontacts' => $additioncontacts];
                    }
                    $pdetail['type'] = $chktype['name'];
                    $parties[] = $pdetail;
                }
            }
        }
        return $parties;
    }

    private function getOrderCustomerDetails(int $customerId): array
    {
        $ci = &get_instance();
        if ($customerId == "") {
            return [];
        }
        $customerInfo = $ci->common->getjointbldata("`tb_customers` tc", "tbl_party_master tpm", "tc.code=tpm.code", ["tc.id" => $customerId], "tpm.id, tpm.code as cust_id, tpm.name, tpm.street, tpm.street_2,tpm.street_3, tpm.email,tpm.mobile as phone,tpm.location_id AS city, tpm.address,tpm.country,tpm.state,tpm.pincode", 0, 0);
        return $customerInfo[0] ?? [];
    }

    private function getOrderTypeName(string $orderType = '0'): string {
        $name = '';
        if ($orderType > 0) {
            $ci = &get_instance();
            $orderTypeName = $ci->common->gettblrowdata(["id" => $orderType], "type_name", "tb_order_types", 0, 0);
            $name = $orderTypeName ? $orderTypeName['type_name'] : '';
        }
        return $name;
    }

    private function getOrderServiceName(int $service): string
    {
        $ci = &get_instance();
        $orderServiceName = $ci->common->gettblrowdata(["id" => $service], "name", "tb_service_master", 0, 0);
        return $orderServiceName['name'] ?? "";
    }

    private function getOrderDeliveryTermInfo(int $deliveryTerm): array
    {
        $ci = &get_instance();
        $orderTermName = $ci->common->gettblrowdata(["id" => $deliveryTerm], "`term_id`,`name`", "tb_delivery_terms", 0, 0);
        return (!empty($orderTermName)) ? $orderTermName : [];
    }

    private function getOrderAddons(int $id): array
    {
        $ci = &get_instance();
        $addonsRes = $ci->db->query("SELECT tvm.vas_name,tos.`quantity` FROM `tb_order_vas` tos LEFT OUTER JOIN `tb_vas_master` tvm ON tos.vas_id=tvm.id  WHERE tos.`order_id`=? AND tos.`status`='1'", [$id]);
        return $addonsRes->num_rows() > 0 ? $addonsRes->result_array() : [];
    }

    private function getOrderManageReferences(int $id): array
    {
        $ci = &get_instance();
        $referencesValue = $ci->db->query("SELECT reference_id,ref_value FROM tb_order_references where order_id =? AND status=?", [$id, 1]);
        return $referencesValue->num_rows() > 0 ? $referencesValue->result_array() : [];
    }

    private function carrierAdditionalContacts(array $ShipmentOrders): array
    {
        foreach ($ShipmentOrders as $orders) {
            foreach ($orders['parties'] as $party) {
                if ($party['type'] == "Carrier") {
                    $additioncontacts[] = $party['additioncontacts'];
                }
            }
        }
        return $additioncontacts ?? [];
    }

    private function getWeightHigherUnit($weightUnit): string
    {
        $weightUnitArray = explode(",", $weightUnit);

        if (array_intersect(self::TONS_ARRAY, $weightUnitArray)) {
            return 'tons';
        } elseif (array_intersect(self::KILOGRAMS_ARRAY, $weightUnitArray)) {
            return 'kg';
        } elseif (array_intersect(self::GRAMS_ARRAY, $weightUnitArray)) {
            return 'g';
        }
        return 'kg';
    }

    private function calculateWeight($weight, string $weightUnit)
    {
        if ($weightUnit == 'tons') {
            return $weight / 1000;
        } elseif ($weightUnit == 'g') {
            return $weight * 1000;
        }

        return $weight;
    }

    public function sendTripFailedEmailNotification(array $data, array $response): void
    {
        $ci = &get_instance();
        log_message("error", "sendTripFailedEmailNotification Trip Outbound data: " . $data['tripdetails']['shipmentid']);

        $ci->load->library('PhpMailerLibrary');
        $ordersList = [];
        foreach ($data['ordersdetails'] as $orders) {
            $ordersList[] = $orders['order_id'];
        }
        $subject = "Error/Alert -Trip Outbound Failed for The Trip ID:  " . $data['tripdetails']['shipmentid'];
        $message = "Hi Team,<br>";
        $message .= "Trip Outbound Failed for  Booking ID: " . implode(",", $ordersList) . "<br>";
        $message .= "Trip ID:  " . $data['tripdetails']['shipmentid'] . "<br>";
        $message .= "Carrier Name:  " . $data['tripdetails']['vendordetails']['companyname'] . "<br>";
        $message .= "The Error Message is:  " . $response['message'] . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
        log_message("error", "Trip Outbound Failed Message" . json_encode($message));
        try {
            if ($ci->phpmailerlibrary->sendmail(YTDREPORT_MAILS, $subject, $message, json_decode(YTDREPORT_CC_MAILS))) {
                log_message("error", "email sent for " . $subject);
            } else {
                log_message("error", "email failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendTripFailedEmailNotification email failed - " . $e->getMessage());
        }
    }

    public function tripOutboundToEportal(int $shipmentNumber, string $functionCode = "I"): int {
        if ($shipmentNumber == "") {
            log_message("error", "There is no Shipmentid");
            return 0;
        }
        $data = $tripdata = [];
        $ci = &get_instance();
        $tripdetails = $ci->common->gettblrowdata(["id" => $shipmentNumber], "id,shipmentid,company_code,branch_code,department_code,shift_leg_id,user_id", "tb_shifts", 0, 0);
        $tripdata['shipmentid'] = $tripdetails['shipmentid'];
        $tripdata['company_code'] = $company_code = $tripdetails['company_code'];
        $tripdata['branch_code'] = $branch_code = $tripdetails['branch_code'];
        $tripdata['department_code'] = $department_code = $tripdetails['department_code'];
        $ci->edi_logger->setEdi_type(1);
        $ci->edi_logger->setTxn_obj_id($tripdetails['shipmentid']);
        $ci->edi_logger->setUser_id($tripdetails['user_id']);
        $ci->edi_logger->setCompany_code($company_code);
        $ci->edi_logger->setBranch_code($branch_code);
        $ci->edi_logger->setTransaction_id(time());
        $ci->edi_logger->setEdi_id("38");
        $ci->edi_logger->setEdi_name('Trip Outbound to ePortal');
        $ci->edi_logger->setBounded_type(2);
        $orderUserTimeZone = $ci->carriercommonmodel->getOrderUserTimeZone($tripdetails['user_id'] ?? "231");
        $curtz = $orderUserTimeZone['cntry_timezone'];
        $code = $orderUserTimeZone['phone_code'];
        $tripdata['vendordetails'] = $ci->carriercommonmodel->getShipmentCarrier($shipmentNumber);
        $tripdata['vendordetails']['phone_code'] = $code;
        $carrierID = $tripdata['vendordetails']['id'];
        $tripdata['tripStops'] = $ci->carriercommonmodel->getShipmentStops($shipmentNumber, $orderUserTimeZone['phone_code']);
        $tripdata['trucks_data'] = $ci->carriercommonmodel->getshipmentVehicleInfo($shipmentNumber);
        if (!empty($tripdata['trucks_data'])) {
            $driver_data = $ci->carriercommonmodel->getshipmentAssignDeiver($shipmentNumber, $orderUserTimeZone['phone_code']);
            $driver_data['phone_code'] = $code;
        }
        $tripdata['driver_data'] = $driver_data ?? [];
        $ShipmentOrders = $this->getShipmentOrders($shipmentNumber, $code, $curtz);
        $tripdata['vendordetails']['additioncontacts'] = $this->carrierAdditionalContacts($ShipmentOrders);
        $tripdata['PhysicalReceiver'] = $ShipmentOrders[0]['physicalreceiver'] ?? "";
        $tripdata['LogicalReceiver'] = $ShipmentOrders[0]['logicalreceiver'] ?? "";
        $tripdata['PhysicalSender'] = $ShipmentOrders[0]['physicalsender'] ?? "";
        $LogicalSender = $ShipmentOrders[0]['logicalsender'] ?? "";
        if ($LogicalSender != "") {
            $logicalinfo = $ci->common->gettblrowdata(['branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
            if (count($logicalinfo) > 0) {
                $LogicalSender = $logicalinfo['logical_sender'];
            }
        }
        $tripdata['LogicalSender'] = $LogicalSender;
        $total_volume = $total_quantity = 0;
        $totalweightGrms = $totalweightKgs = $totalweighttons = 0;
        foreach ($ShipmentOrders as $order) {
            if ($order['gross_weight_uom'] == "G" || $order['gross_weight_uom'] == "gms") {
                $totalweightGrms += $order['weight'];
            }
            if ($order['gross_weight_uom'] == "kg" || $order['gross_weight_uom'] == "KGM" || $order['gross_weight_uom'] == "Kgs") {
                $totalweightKgs += $order['weight'];
            }
            if ($order['gross_weight_uom'] == "Tons") {
                $totalweighttons += $order['weight'];
            }
            $total_volume += $order['volume'];
            $total_quantity += $order['quantity'];
        }
        $total_weight = ($totalweightKgs + ($totalweightGrms / 1000) + ($totalweighttons / 1000));
        $tripdata['total_volume'] = $total_volume ?? "0.0";
        $tripdata['total_weight'] = $total_weight ?? "0.0";
        $tripdata['total_quantity'] = $total_quantity;
        $tripdata['weight_unit'] = "KG";
        $tripdata['volume_unit'] = "CBM";
        $data['tripdetails'] = $tripdata;
        $data['ordersdetails'] = $ShipmentOrders;
        $tripXMl = $this->generateTripXML($data, $functionCode);
        $ci->edi_logger->setEdi_request($tripXMl);
        $ci->load->library('EportalBUFA');
        $ci->eportalbufa->orderId = (isset($ShipmentOrders[0]['order_id'])) ? $ShipmentOrders[0]['order_id'] : 0;
        $ci->eportalbufa->sendTripNotificationToEportal($tripXMl);
        $ci->edi_logger->setEdi_format_type('XML');
        $ci->edi_logger->setEdi_response(1);
        $ci->edi_logger->setObj_type_name('Trip Outbound to ePortal CNKN');
        $ci->edi_logger->setStatus(1);
        $ci->edi_logger->saveToEdiLogs();
        return 1;
    }

    public function sendEmailNotification(int $shipmentid, string $response): void
    {
        $ci = &get_instance();
        log_message("error", "sendEmailNotification Trip Outbound data: " . $shipmentid);
        $ci->load->library('PhpMailerLibrary');
        $subject = "Error/Alert -Trip Outbound Failed for The Trip ID:  " . $shipmentid;
        $message = "Hi Team,<br>";
        $message .= "Trip Outbound Failed for  Trip ID: " . $shipmentid . "<br>";
        $message .= "The Error Message is:  " . $response . "<br><br>";
        $message .= "This is an automatically generated EMail, please do not reply <br><br><br><br>";
        $message .= "Thanks,<br>Support Team,<br>svkonekt.com";
        try {
            if ($ci->phpmailerlibrary->sendmail(TRIP_FAIL_EMAILS, $subject, $message)) {
                log_message("error", "sendEmailNotification sent for " . $subject);
            } else {
                log_message("error", "sendEmailNotification failed for " . $subject);
            }
        } catch (Exception $e) {
            log_message("error", "sendEmailNotification email failed - " . $e->getMessage());
        }
    }

    public function checkTripStatus(int $shipmentNumber, string $functionCode): string
    {
        $ci = &get_instance();
        $tripclose = $tripCancel = 0;
        $getTripOrders = $ci->common->gettbldata(["shift_id" => $shipmentNumber, "status" => 0], "id,status,trip_sts", "tb_orders", 0, 0);
        if (!empty($getTripOrders)) {
            foreach ($getTripOrders as $orders) {
                if ($orders['trip_sts'] == "1") {
                    $tripclose = $tripclose + 1;
                }
                if ($orders['status'] == "3") {
                    $tripCancel = $tripCancel + 1;
                }
            }
        }
        if (count($getTripOrders) == $tripCancel) {
            $functionCode = "CA";
        } else {
            $functionCode = $functionCode == "CA" ? "UP" : $functionCode;
        }
        return $functionCode;
    }
}
