<?php

class Cip
{
    private $CI;
    public string $request_url;

    public function __construct()
    {
        $this->CI = &get_instance();
        $this->CI->load->model('common');
        require_once './vendor/pear/http_request2/HTTP/Request2.php';
    }
    private function getAuthorizationKey() : array {
        return $this->CI->common->gettblrowdata(['id'=>1],'authorization_key,updated_at','cip_authorization_key',1,0);
    }

    public function updateAuthorizationKey(): int
    {
        $status = 0;
        $authorization_Qry = $this->CI->db->select('authorization_key')->where(['id'=>1])->get('cip_authorization_key')->row();

        if(empty($authorization_Qry))
            return 0;

        $headers = [
            'Content-Type:application/json',
            'Authorization: Basic '. base64_encode(CIP_AUTH_USER_NAME.":".CIP_AUTH_USER_PASSWORD)
        ];

        $data = ['user' => CIP_POST_USER_NAME, 'password' => CIP_POST_USER_PASSWORD];

        $post = json_encode($data);

        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($this->request_url);
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setHeader($headers);
        $request->setBody($post);

        try {
            $response = $request->send();

            if ($response->getStatus() == 200)
            {
                $responseBody = $response->getBody();
                $u_data = ['authorization_key'=>(string)$responseBody,'updated_at'=>date('Y-m-d H:i:00')];

                if($this->CI->db->where(['id'=>1])->update('cip_authorization_key',$u_data)){
                    $status = 1;
                }
            }
            else
            {
                $error_msg = 'HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
                log_message("error",$error_msg);
            }
        }
        catch (HTTP_Request2_Exception $e)
        {
            $error_msg = 'update_authorization_key  Error: ' . $e->getMessage();
            log_message("error",$error_msg);
        }

        return $status;
    }

    public function fetch_details_by_cip(): array
    {
        $status = 0;
        $message = "";

        $authorization_Qry = $this->CI->db->select('authorization_key')->where(['id'=>1])->get('cip_authorization_key')->row();
        $authorization_key = $authorization_Qry->authorization_key;

        $headers = [
            'Content-Type: application/json',
            'Authorization: Basic '. base64_encode(CIP_AUTH_USER_NAME.":".CIP_AUTH_USER_PASSWORD),
            'X-Authorization: '.$authorization_key
        ];

        $data = [];

        require_once './vendor/pear/http_request2/HTTP/Request2.php';
        $request = new HTTP_Request2();
        $request->setUrl($this->request_url);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig([
            'follow_redirects' => true,
            'ssl_verify_peer' => false,
            'connect_timeout' => 100,
            'timeout' => 120
        ]);

        $request->setHeader($headers);

        try {
            $response = $request->send();

            if ($response->getStatus() == 200)
            {
                $responseBody = $response->getBody();

                if(isXML($responseBody))
                {
                    $xml = simplexml_load_string($responseBody);
                    $apiResponse = (array)$xml;
                }else{
                    $apiResponse = json_decode($responseBody,true);
                }
                $status = 1;
                $data = $apiResponse ? $apiResponse : [];
            }
            else
            {
                $error_msg = 'HTTP status: ' . $response->getStatus() . ' ' . $response->getReasonPhrase();
                log_message("error",$error_msg);
                $message = $this->CI->lang->line('driverapp_no_data_found');
            }
        } catch (HTTP_Request2_Exception $e) {
            $error_msg = 'BusinessPartnerDetailsByCIP  Error: ' . $e->getMessage();
            log_message("error",$error_msg);
            $message = $e->getMessage();
        }
        return compact('status','message','data');
    }
    public function generateCIDinCIPPortal(array $data=[]) : array {
        $authorizationQry = $this->getAuthorizationKey();
        if (empty($authorizationQry)) {
            return ['status'=>0,'cid'=>''];
        }
        $status = 1;
        $cid    = '';
        $data = (object)$data;
        $payLoad = [
            "leid"=>NULL,
            "ouid"=>NULL,
            "addressEnvelopeRequest"=>[
                "deliveryServiceType"   =>  "PHYSICAL_ADDRESS",
                "forceDuplicate"        =>  true,
                "originalAddress"   =>  [
                    "locality"                  => (string) $data->locality,
                    "dependentLocality"         => (string) $data->dependentLocality,
                    "subDependentLocality"      => (string) $data->dependentLocality,
                    "thoroughfare1"             => (string) $data->thoroughfare1,
                    "thoroughfare2"             => (string) $data->thoroughfare2,
                    "thoroughfare3"             => "",
                    "plot"                      => (string) $data->plot,
                    "building"                  => (string) $data->building,
                    "extension"                 => "",
                    "postcode"                  => (string) $data->postcode,
                    "provinceCode"              => "",
                    "province"                  => (string) $data->province,
                    "countryIso2Code"           => (string) $data->countryIso2Code,
                    "deliveryServiceName"       => "",
                    "deliveryServiceQualifier"  => "",
                    "dataSource"                => "",
                    "addressLanguageCode"       => "",
                    "addressTranslations"       => []
                ]
            ],
            "comments"          => "",
            "vatNumber"         => "",
            "registrationNumber"=> "",
            "suggestionId"      => NULL,
            "lookupId"          => "",
            "legalEntityRequest"=>  [
                "entityName"        => (string) $data->entityName,
                "entityNameLocal"   => (string) $data->entityNameLocal,
                "comments"          => ""
            ],
            "operatingUnitRequest"  =>  [
                "branchName"        => "",
                "branchNameLocal"   => "",
                "divisionName"      => "",
                "divisionNameLocal" => "",
                "comments"          => "",
                "smtStatus"         => "NEW",
                "smtStatusValidUntil"=> NULL
            ]
        ];
        $post = json_encode($payLoad);
        //log_message("error","CIP create CID payload => ".$post);
        $request = new HTTP_Request2();
        $request->setUrl(CIP_PORTAL_BASE_URL.'cip-customer/customers');
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(['follow_redirects' => TRUE]);
        $request->setHeader([
            'Authorization' => $authorizationQry['authorization_key'],
            'Content-Type' => 'application/json'
        ]);
        $request->setBody($post);
        try {
            $response = $request->send();
            $statusCode = (int)$response->getStatus();
            if ( in_array($statusCode, [200, 201])) {
                $body = $response->getBody();
                $message = 'CIP PORTAL Success Response: '.$body;
                $responseBody = json_decode($body,true);
                $cid = isset($responseBody['cid']) ? $responseBody['cid'] : '';
            } else {
                //log_message("error","CIP create CID error response => ".$response->getBody());
                $status = 3;
                $message = 'CIP PORTAL Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $status = 2;
            $message = 'CIP PORTAL Error at '.date('d-m-Y H:i:s'). $e->getMessage();
        }
        log_message("error",$message);
        return compact('status','cid');
    }
    public function fetchCipPortalBpInfoByCID(string $cid): array {
        $authorizationQry = $this->getAuthorizationKey();
        if (empty($authorizationQry)) {
            return ['status'=>0,'data'=>[]];
        }
        $data = [];
        $status = 1;
        $request = new HTTP_Request2();
        $request->setUrl(CIP_PORTAL_BASE_URL.'cip-customer/customers/'.$cid);
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(['follow_redirects' => TRUE]);
        $request->setHeader(['Authorization' => $authorizationQry['authorization_key']]);
        try {
            $response = $request->send();
            $statusCode = (int)$response->getStatus();
            if ( in_array($statusCode, [200, 201])) {
                $body = $response->getBody();
                $message = 'CIP PORTAL GET BP Success Response: '.$body;
                $data = json_decode($body,true);
            } else {
                //log_message("error","CIP fetch Customer Info error response => ".$response->getBody());
                $status = 3;
                $message = 'CIP PORTAL GET BP Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $status = 2;
            $message = 'CIP PORTAL GET BP Error at '.date('d-m-Y H:i:s'). $e->getMessage();
        }
        log_message("error",$message);
        return compact('status','data');
    }
    public function fetchCipPortalBpAddressInfoByCID(string $cid): array {
        $authorizationQry = $this->getAuthorizationKey();
        if (empty($authorizationQry)) {
            return ['status'=>0,'data'=>[]];
        }
        $data = [];
        $status = 1;
        $request = new HTTP_Request2();
        $request->setUrl(CIP_PORTAL_BASE_URL.'cip-customer/customers/'.$cid.'/addresses');
        $request->setMethod(HTTP_Request2::METHOD_GET);
        $request->setConfig(['follow_redirects' => TRUE]);
        $request->setHeader(['Authorization' => $authorizationQry['authorization_key']]);
        try {
            $response = $request->send();
            $statusCode = (int)$response->getStatus();
            if ( in_array($statusCode, [200, 201])) {
                $body = $response->getBody();
                $message = 'CIP PORTAL GET BP Addresses Success Response: '.$body;
                $data = json_decode($body,true);
            } else {
                //log_message("error","CIP fetch Customer Address Info error response => ".$response->getBody());
                $status = 3;
                $message = 'CIP PORTAL GET BP Addresses Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $status = 2;
            $message = 'CIP PORTAL GET BP Addresses Error at '.date('d-m-Y H:i:s'). $e->getMessage();
        }
        log_message("error",$message);
        return compact('status','data');
    }
    public function createLookupSuggesstions(array $searchData = []): array {
        $authorizationQry = $this->getAuthorizationKey();
        if (empty($authorizationQry)) {
            return ['status'=>0,'data'=>[]];
        }
        $data = [];
        $locality = isset($searchData['locality']) ? $searchData['locality'] : '';
        $searchData = (object) $searchData;
        $payLoad = [
            "entityName"=> $searchData->entityName,
            "tradingName"=> $searchData->entityName,
            "divisionName"=> "",
            "address"=> [
                "locality"=> "",
                "dependentLocality"=> "",
                "subDependentLocality"=> "",
                "thoroughfare1"=> "",
                "thoroughfare2"=> "",
                "thoroughfare3"=> "",
                "plot"=> "",
                "building"=> "",
                "extension"=> "",
                "postcode"=> "",
                "provinceCode"=> "",
                "province"=> "",
                "countryIso2Code"=> $searchData->countryIso2Code,
                "deliveryServiceName"=> "",
                "deliveryServiceQualifier"=> "",
                "dataSource"=> "",
                "addressLanguageCode"=> "",
                "addressTranslations"=> []
            ],
            "vatNumber"=> "",
            "vatCountry"=> $searchData->countryIso2Code,
            "searchOnlyDataMirror"=> true
        ];
        $post = json_encode($payLoad);
        //log_message("error","CIP create lookup suggestions payload => ".$post);
        $status = 1;
        $request = new HTTP_Request2();
        $request->setUrl(CIP_PORTAL_BASE_URL.'cip-customer/customers/lookup-suggestions');
        $request->setMethod(HTTP_Request2::METHOD_POST);
        $request->setConfig(['follow_redirects' => TRUE]);
        $request->setHeader(['Authorization' => $authorizationQry['authorization_key'], 'Content-Type' => 'application/json']);
        $request->setBody($post);
        try {
            $response = $request->send();
            $statusCode = (int) $response->getStatus();
            if ( in_array($statusCode, [200, 201])) {
                $body = $response->getBody();
                $message = 'CIP PORTAL GET Lookup Suggesstions Success Response: '.$body;
                $data = json_decode($body,true);
            } else {
                //log_message("error","CIP fetch lookup suggestions error response => ".$response->getBody());
                $status = 3;
                $message = 'CIP PORTAL GET Lookup Suggesstions Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $status = 2;
            $message = 'CIP PORTAL GET Lookup Suggesstions Error at '.date('d-m-Y H:i:s'). $e->getMessage();
        }
        log_message("error",$message);
        return compact('status','data');
    }
    public function updateCustomerAddressAfterLookup(array $updateData = []): array {
        $authorizationQry = $this->getAuthorizationKey();
        if (empty($authorizationQry) || empty($updateData)) {
            return ['status'=>0,'data'=>[]];
        }
        $data=[];
        $updateData = (object) $updateData;
        $cid = $updateData->cid;
        $payLoad = [
            "lookupId"=> $updateData->lookupId,
            "suggestionId"=> null,
            "address"=> [
                "deliveryServiceType"=> "PHYSICAL_ADDRESS",
                "forceDuplicate"=> false,
                "originalAddress"=> [
                    "locality"=> $updateData->locality,
                    "dependentLocality"=> $updateData->dependentLocality,
                    "subDependentLocality"=> "",
                    "thoroughfare1"=> $updateData->thoroughfare1,
                    "thoroughfare2"=> $updateData->thoroughfare2,
                    "thoroughfare3"=> $updateData->thoroughfare3,
                    "plot"=> $updateData->plot,
                    "building"=> $updateData->building,
                    "extension"=> "",
                    "postcode"=> $updateData->postcode,
                    "provinceCode"=> "",
                    "province"=> $updateData->province,
                    "countryIso2Code"=> $updateData->countryIso2Code,
                    "deliveryServiceName"=> "",
                    "deliveryServiceQualifier"=> "",
                    "dataSource"=> "",
                    "addressLanguageCode"=> "",
                    "addressTranslations"=> []
                ],
                "addressId"=> $updateData->addressId,
                "reason"=> "CHANGE",
                "forceReason"=> ""
            ]
        ];
        $post = json_encode($payLoad);
        //log_message("error","CIP update customer address payload => ".$post);
        $status = 1;
        $request = new HTTP_Request2();
        $request->setUrl(CIP_PORTAL_BASE_URL.'cip-customer/customers/'.$cid.'/addresses');
        $request->setMethod(HTTP_Request2::METHOD_PUT);
        $request->setConfig(['follow_redirects' => TRUE]);
        $request->setHeader(['Authorization' => $authorizationQry['authorization_key'], 'Content-Type' => 'application/json']);
        $request->setBody($post);
        try {
            $response = $request->send();
            $statusCode = (int) $response->getStatus();
            if ( in_array($statusCode, [200, 201])) {
                $body = $response->getBody();
                $message = 'CIP PORTAL Update BP Address Success Response: '.$body;
                $data = json_decode($body,true);
            } else {
                //log_message("error","CIP update customer error response => ".$response->getBody());
                $status = 3;
                $message = 'CIP PORTAL Update BP Address Unexpected HTTP status: '.$response->getStatus().' '.$response->getReasonPhrase();
            }
        } catch (HTTP_Request2_Exception $e) {
            $status = 2;
            $message = 'CIP PORTAL Update BP Address Error at '.date('d-m-Y H:i:s'). $e->getMessage();
        }
        log_message("error",$message);
        return compact('status','data');
    }
}
