<?php

class Customerchartlib
{
    private $ci;

    function __construct()
    {
        $ci = &get_instance();
        $ci->load->model(['common', 'AmChartModel']);
    }

    public function getPieChartData(array $yearInfo): array
    {
        $ci = &get_instance();
        $whereClause = $this->getWhereClause();
        if ($yearInfo["currentYear"] == 0 && $yearInfo["currentMonth"] == 0 && $yearInfo["currentweek"] == 0) {
            return [];
        }
        $pendingOrders = $ci->AmChartModel->getPendingOrders($yearInfo, $whereClause);
        $activeOrders = $ci->AmChartModel->getActiveOrders($yearInfo, $whereClause);
        $activePendingOrders = [["Name" => "Pending", "Count" => (int)$pendingOrders], ["Name" => "Active", "Count" => (int)$activeOrders]];
        $deliveryOrdersInfo = [];
        $deliveryTypeOrder = $ci->AmChartModel->getDeliveryTypeOrder($yearInfo, $whereClause);
        foreach ($deliveryTypeOrder as $orderType) {
            $deliveryOrdersInfo[] = ["Name" => $orderType['OrderType'], "Count" => (int)$orderType['order_count']];
        }
        $data = [
            "activePendingOrders" => $activePendingOrders,
            "deliveryOrdersInfo" => $deliveryOrdersInfo
        ];
        return !empty($data) ? $data : [];
    }

    public function getGaugeChartData(array $yearInfo): array
    {
        $ci = &get_instance();
        $whereClause = $this->getWhereClause();
        if ($yearInfo["currentYear"] == 0 && $yearInfo["currentMonth"] == 0 && $yearInfo["currentweek"] == 0) {
            return [];
        }
        $data['noPodOrders'] = $ci->AmChartModel->getPodNotAvailableOrders($yearInfo, $whereClause);
        return $data ?? [];
    }

    private function getWhereClause(): array
    {
        $ci = &get_instance();
        $companyCode = $ci->session->userdata('company_code');
        $businessType = $ci->session->userdata("business_type");
        if ($businessType == "Country Admin") {
            $userIds = $ci->session->userdata('country_user_ids');
        }
        if ($businessType == "Truck_Owner") {
            $userIds[] = $ci->session->userdata("user_id");
        }
        if ($businessType == "Customer") {
            $customerId = $ci->session->userdata("cust_id");
        }
        if ($businessType == "Carrier") {
            $vendorId = $ci->session->userdata("id");
        }
        return [
            'companyCode' => $companyCode,
            'businessType' => $businessType,
            'userIds' => $userIds ?? [],
            'customerId' => $customerId ?? 0,
            'vendorId' => $vendorId ?? 0
        ];
    }
}
