<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customerordershandler
{
    private $ci;

    public function __construct()
    {
        $this->ci = &get_instance();
        $this->ci->load->model(['common', 'svkCustomer/CustomerOrder']);
    }

    public function getOrderDetailsById(int $rowId): array
    {
        $data['ordersTableData'] = $this->ci->common->gettblrowdata(['id' => $rowId], "id,order_id,pickup_datetime,delivery_datetime,pickup_company,delivery_company,pickup_country,delivery_country,pickup_city,delivery_city,pickup_pincode,delivery_pincode,pickup_address1,delivery_address1,pickup_address2,delivery_address2,transport_mode,customer_id,plat,plng,dlat,dlng,product,shift_id,trip_id", "tb_orders", 0, 0);
        $data['orderDetailsTableData'] = $this->ci->common->gettblrowdata(['order_row_id' => $rowId], "order_type,service,", "tb_order_details", 0, 0);
        $getInvolvedParties = $this->ci->CustomerOrder->getOrderInvolvedParties($rowId);
        $orderPartyIds = [];
        foreach ($getInvolvedParties as $eachLine) {
            $partyType = strtolower($eachLine['name']);
            $partyIds[] = $eachLine['party_id'];
            $orderPartyIds[$partyType] = ['rowId' => $eachLine['party_id'],'house_number' => $eachLine['house_number']];
        }
        if (!empty($partyIds)) {
            $partyIdDetails = $this->ci->common->gettbldata(" id IN (" . implode(',', $partyIds) . " ) AND status = '1'", "id,email,mobile,code", "tbl_party_master", 0, 0);
            foreach ($partyIdDetails as $eachLine) {
                $orderPartyDetails[$eachLine['id']] = ['rowId' => $eachLine['id'], 'email' => $eachLine['email'], 'mobile' => $eachLine['mobile'], 'code' => $eachLine['code']];
            }
        }
        $getAddons = $this->ci->common->gettbldata(['order_id' => $rowId, 'status' => '1'], "vas_id", "tb_order_vas", 0, 0);
        foreach ($getAddons as $eachLine) {
            $data['orderAddons'][] = $eachLine['vas_id'];
        }
        $references = $this->ci->common->gettbldata("order_id ='" . $rowId . "' AND reference_id IN ('DQ','PO','ORD_PIKINST','ORD_DLVINST') AND status ='1'", "reference_id,ref_value", "tb_order_references", 0, 0);
        foreach ($references as $eachRow) {
            $orderReferences[$eachRow['reference_id']] = $eachRow['ref_value'];
        }
        $data['orderTotalWeight'] = $data['orderTotalVolume'] = $data['orderTotalQuantity'] = 0;
        $documentsList = $this->ci->common->getjointbldata("tb_pod_uploads p", "tb_document_types d", "p.doc_type=d.id", "p.order_id = '" . $rowId . "' AND p.status ='1'", "p.id,p.imgpath,p.createdon,d.type_name", 0, 0);
        foreach ($documentsList as $eachLine) {
            $fileName = $eachLine['imgpath'];
            $base64DocumentData = getBase64DocumentData($fileName);
            $stringData = "'" . $base64DocumentData['file_content'] . "'," . "'" . $base64DocumentData['extention'] . "'";
            $path = '<p style="cursor:pointer;" onclick="return downloadDocument(' . $stringData . ')"> ' . $fileName . '</p>';
            $orderDocuments[] = ['rowId' => $eachLine['id'], 'typeName' => $eachLine['type_name'], 'date' => $eachLine['createdon'], 'path' => $path];
        }
        $cargos = $this->ci->common->getjointbldata("tb_order_cargodetails o", "tb_cargo_details c", "c.id=o.cargo_id", "o.order_id = '" . $rowId . "' AND o.status ='1'", "o.id as order_cargo_id,o.length,o.width,o.height,o.weight,o.volume,o.quantity,o.quantity_type,o.cargo_content,c.id as cargo_row_id,c.handling_unit,c.length_unit,c.width_unit,c.height_unit,c.weight_unit,c.volume_unit,c.stackable,c.grounded,c.splittable,c.dg_goods,c.item_id", 0, 0);
        foreach ($cargos as $eachLine) {
            $dimensionsArray = $this->convertCargoDimensions($eachLine);
            $dgGoods = $eachLine['dg_goods'];
            $cargoRowId = $eachLine['cargo_row_id'];
            $orderCargoId = $eachLine['order_cargo_id'];
            if ($dgGoods > 0) {
                $dgOrderCargoRowId[] = $orderCargoId;
                $cargoIdsForDg[$orderCargoId] = $cargoRowId;
            }
            $data['orderTotalWeight'] += $dimensionsArray['weight'];
            $data['orderTotalVolume'] += $eachLine['volume'];
            $data['orderTotalQuantity'] += $eachLine['quantity'];
            $length = $dimensionsArray['length'] > 0 ? round($dimensionsArray['length'], 2) : "";
            $width = $dimensionsArray['width'] > 0 ? round($dimensionsArray['width'], 2) : "";
            $height = $dimensionsArray['height'] > 0 ? round($dimensionsArray['height'], 2) : "";
            $orderCargos[] = [
                'orderCargoId' => $orderCargoId,
                'cargoRowId' => $cargoRowId,
                'length' => $length,
                'width' => $width,
                'height' => $height,
                'weight' => round($dimensionsArray['weight'], 2),
                'volume' => round($eachLine['volume'], 2),
                'quantity' => $eachLine['quantity'],
                'quantityType' => $eachLine['quantity_type'],
                'cargoContent' => $eachLine['cargo_content'],
                'stackable' => $eachLine['stackable'],
                'grounded' => $eachLine['grounded'],
                'splittable' => $eachLine['splittable'],
                'dgGoods' => $dgGoods,
                'itemRowId' => $eachLine['item_id'],
                'handlingUnit' => $eachLine['handling_unit']
            ];
        }
        $data['orderDgDetails'] = $this->getDgDetailsFromCargo($cargoIdsForDg ?? [], $dgOrderCargoRowId ?? []);
        $revenuesIds = [];
        $getRevenues = $this->ci->common->gettbldata(['order_id' => $rowId, 'type' => '0', 'status' => '1'], "id", "tb_reveneus", 0, 0);
        foreach ($getRevenues as $eachLine) {
            $revenuesIds[] = $eachLine['id'];
        }
        if (!empty($revenuesIds)) {
            $data['orderCharges'] = $this->ci->common->getjointbldata("tb_charges c", "tb_charge_codes cc", "c.charge_code=cc.id", "c.revenue_id IN (" . implode(',', $revenuesIds) . ") AND c.status ='1'", "c.rate_id,c.amount,c.currency,cc.charge_code", 0, 0);
        }
        $data['orderPartyDetails'] = $orderPartyDetails ?? [];
        $data['orderCargos'] = $orderCargos ?? [];
        $data['orderPartyIds'] = $orderPartyIds;
        $data['orderReferences'] = $orderReferences ?? [];
        $data['orderDocuments'] = $orderDocuments ?? [];
        $data['orderRowId'] = $rowId;
        return $data ?? [];
    }

    private function getDgDetailsFromCargo(array $cargoIdsForDg, array $dgOrderCargoRowId): array
    {
        if (empty($cargoIdsForDg)) {
            return [];
        }
        $getDgDetails = $this->ci->common->gettbldata("order_cargo_id IN (" . implode(',', $dgOrderCargoRowId) . ") AND status ='1'", "id,order_cargo_id,num_pkgs,pkg_qty_type,quantity,quantity_type,org_number,org_name,db_class,description,limited_quantity,excepted_quantity,tunnel_restriction_code,environment_hazardous,nos,packing_group,gross_weight,net_weight,netexplosive_mass,liters,fire_works", "tb_order_dg_goods", 0, 0);
        foreach ($getDgDetails as $eachLine) {
            $cargoRowId = $cargoIdsForDg[$eachLine['order_cargo_id']] ?? 0;
            $dgRowId = $eachLine['id'];
            $dgUnCode = $eachLine['org_number'];
            $dgUnCodeClass = $eachLine['db_class'];
            $dgUnCodeName = $eachLine['org_name'];
            $dgUnCodePackingGroup = $eachLine['packing_group'];
            $dgNos = $eachLine['nos'];
            $dgTunnelCode = $eachLine['tunnel_restriction_code'];
            $dgNoOfPackages = $eachLine['quantity'];
            $dgPackageType = $eachLine['quantity_type'];
            $dgGrossWeight = $eachLine['gross_weight'];
            $dgNetWeight = $eachLine['net_weight'];
            $dgNetExplosiveMass = $eachLine['netexplosive_mass'];
            $dgLiters = $eachLine['liters'];
            $dgLimitedQuantity = $eachLine['limited_quantity'];
            $dgExpectedQuantity = $eachLine['excepted_quantity'];
            $dgEnvironmentally = $eachLine['environment_hazardous'];
            $dgTechinalName = $eachLine['description'];
            $dgFireworks = $eachLine['fire_works'];
            $response[] = "<input type='hidden' id='dgWithCargo_" . $cargoRowId . "' name='dgWithCargo' value='" . $dgRowId . "'>
            <input type='checkbox' form='quickbookForm' name='dgRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='dgRowIds" . $dgRowId . "' value = '" . $dgRowId . "' style='display: none;' checked data-unCode='" . $dgUnCode . "' data-unCodeName='" . $dgUnCodeName . "' data-unCodeClass='" . $dgUnCodeClass . "' data-packagingGroup='" . $dgUnCodePackingGroup . "' data-nos='" . $dgNos . "' data-tunnelCode='" . $dgTunnelCode . "' data-packages='" . $dgNoOfPackages . "' data-packageType='" . $dgPackageType . "' data-gorssWeight='" . $dgGrossWeight . "' data-netWeight='" . $dgNetWeight . "' data-explosiveMass='" . $dgNetExplosiveMass . "' data-liters='" . $dgLiters . "' data-ltdQuantity='" . $dgLimitedQuantity . "' data-expQuantity='" . $dgExpectedQuantity . "' data-environmentally='" . $dgEnvironmentally . "' data-techinalName='" . $dgTechinalName . "' data-fireWorks='" . $dgFireworks . "'> ";
        }
        return $response ?? [];
    }

    public function convertCargoDimensions(array $info): array
    {
        $lengthUom = $info['length_unit'];
        $databaseLength = $info['length'];
        $metersConversionLength = in_array($lengthUom, ['m', 'M', 'Meters']) ? ($databaseLength * 100) : $databaseLength;
        $length = in_array($lengthUom, ['Inches', 'INCHES', 'inches']) ? ($metersConversionLength * 2.54) : $metersConversionLength;
        $widthUom = $info['width_unit'];
        $databaseWidth = $info['width'];
        $metersConversionWidth = in_array($widthUom, ['m', 'M', 'Meters']) ? ($databaseWidth * 100) : $databaseWidth;
        $width = in_array($widthUom, ['Inches', 'INCHES', 'inches']) ? ($metersConversionWidth * 2.54) : $metersConversionWidth;
        $heightUom = $info['height_unit'];
        $databaseHeight = $info['height'];
        $metersConversionHeight = in_array($heightUom, ['m', 'M', 'Meters']) ? ($databaseHeight * 100) : $databaseHeight;
        $height = in_array($heightUom, ['Inches', 'INCHES', 'inches']) ? ($metersConversionHeight * 2.54) : $metersConversionHeight;
        $weightUom = $info['weight_unit'];
        $databaseweight = $info['weight'];
        $weight = in_array($weightUom, ['TONS', 'Tons', 'tons']) ? ($databaseweight * 907.185) : $databaseweight;
        return ['length' => $length, 'width' => $width, 'height' => $height, 'weight' => $weight];
    }
}

?>
